-- MySQL dump 10.13  Distrib 5.7.25, for Linux (x86_64)
--
-- Host: localhost    Database: moodle
-- ------------------------------------------------------
-- Server version	5.7.25-0ubuntu0.18.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `mdl_analytics_indicator_calc`
--

DROP TABLE IF EXISTS `mdl_analytics_indicator_calc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_indicator_calc` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `starttime` bigint(10) NOT NULL,
  `endtime` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `sampleorigin` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sampleid` bigint(10) NOT NULL,
  `indicator` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` decimal(10,2) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analindicalc_staendcon_ix` (`starttime`,`endtime`,`contextid`),
  KEY `mdl_analindicalc_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stored indicator calculations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_indicator_calc`
--

LOCK TABLES `mdl_analytics_indicator_calc` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_indicator_calc` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_indicator_calc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_models`
--

DROP TABLE IF EXISTS `mdl_analytics_models`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_models` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `trained` tinyint(1) NOT NULL DEFAULT '0',
  `target` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `indicators` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timesplitting` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `predictionsprocessor` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` bigint(10) NOT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analmode_enatra_ix` (`enabled`,`trained`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Analytic models.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_models`
--

LOCK TABLES `mdl_analytics_models` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_models` DISABLE KEYS */;
INSERT INTO `mdl_analytics_models` VALUES (1,0,0,'\\core\\analytics\\target\\course_dropout','[\"\\\\mod_assign\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_assign\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_book\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_book\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_chat\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_chat\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_choice\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_choice\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_data\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_data\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_feedback\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_feedback\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_folder\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_folder\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_forum\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_forum\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_glossary\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_glossary\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_imscp\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_imscp\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_label\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_label\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_lesson\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_lesson\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_lti\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_lti\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_page\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_page\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_quiz\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_quiz\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_resource\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_resource\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_scorm\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_scorm\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_survey\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_survey\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_url\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_url\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_wiki\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_wiki\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_workshop\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_workshop\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\core_course\\\\analytics\\\\indicator\\\\completion_enabled\",\"\\\\core_course\\\\analytics\\\\indicator\\\\potential_cognitive_depth\",\"\\\\core_course\\\\analytics\\\\indicator\\\\potential_social_breadth\",\"\\\\core\\\\analytics\\\\indicator\\\\any_access_after_end\",\"\\\\core\\\\analytics\\\\indicator\\\\any_access_before_start\",\"\\\\core\\\\analytics\\\\indicator\\\\any_write_action_in_course\",\"\\\\core\\\\analytics\\\\indicator\\\\read_actions\"]',NULL,'0',1547809420,1547809420,1547809420,0),(2,1,1,'\\core\\analytics\\target\\no_teaching','[\"\\\\core_course\\\\analytics\\\\indicator\\\\no_teacher\",\"\\\\core_course\\\\analytics\\\\indicator\\\\no_student\"]','\\core\\analytics\\time_splitting\\single_range','0',1547809420,1547809420,1547809420,0);
/*!40000 ALTER TABLE `mdl_analytics_models` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_models_log`
--

DROP TABLE IF EXISTS `mdl_analytics_models_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_models_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `version` bigint(10) NOT NULL,
  `target` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `indicators` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timesplitting` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `score` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `info` longtext COLLATE utf8mb4_unicode_ci,
  `dir` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analmodelog_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Analytic models changes during evaluation.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_models_log`
--

LOCK TABLES `mdl_analytics_models_log` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_models_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_models_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_predict_samples`
--

DROP TABLE IF EXISTS `mdl_analytics_predict_samples`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_predict_samples` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `analysableid` bigint(10) NOT NULL,
  `timesplitting` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rangeindex` bigint(10) NOT NULL,
  `sampleids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_analpredsamp_modanatimr_ix` (`modelid`,`analysableid`,`timesplitting`,`rangeindex`),
  KEY `mdl_analpredsamp_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Samples already used for predictions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_predict_samples`
--

LOCK TABLES `mdl_analytics_predict_samples` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_predict_samples` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_predict_samples` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_prediction_actions`
--

DROP TABLE IF EXISTS `mdl_analytics_prediction_actions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_prediction_actions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `predictionid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `actionname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analpredacti_preuseact_ix` (`predictionid`,`userid`,`actionname`),
  KEY `mdl_analpredacti_pre_ix` (`predictionid`),
  KEY `mdl_analpredacti_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Register of user actions over predictions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_prediction_actions`
--

LOCK TABLES `mdl_analytics_prediction_actions` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_prediction_actions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_prediction_actions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_predictions`
--

DROP TABLE IF EXISTS `mdl_analytics_predictions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_predictions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `sampleid` bigint(10) NOT NULL,
  `rangeindex` mediumint(5) NOT NULL,
  `prediction` decimal(10,2) NOT NULL,
  `predictionscore` decimal(10,5) NOT NULL,
  `calculations` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timestart` bigint(10) DEFAULT NULL,
  `timeend` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analpred_modcon_ix` (`modelid`,`contextid`),
  KEY `mdl_analpred_mod_ix` (`modelid`),
  KEY `mdl_analpred_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Predictions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_predictions`
--

LOCK TABLES `mdl_analytics_predictions` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_predictions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_predictions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_train_samples`
--

DROP TABLE IF EXISTS `mdl_analytics_train_samples`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_train_samples` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `analysableid` bigint(10) NOT NULL,
  `timesplitting` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fileid` bigint(10) NOT NULL,
  `sampleids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_analtraisamp_modanatim_ix` (`modelid`,`analysableid`,`timesplitting`),
  KEY `mdl_analtraisamp_mod_ix` (`modelid`),
  KEY `mdl_analtraisamp_fil_ix` (`fileid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Samples used for training';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_train_samples`
--

LOCK TABLES `mdl_analytics_train_samples` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_train_samples` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_train_samples` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_used_analysables`
--

DROP TABLE IF EXISTS `mdl_analytics_used_analysables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_used_analysables` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `action` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `analysableid` bigint(10) NOT NULL,
  `timeanalysed` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analusedanal_modact_ix` (`modelid`,`action`),
  KEY `mdl_analusedanal_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='List of analysables used by each model';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_used_analysables`
--

LOCK TABLES `mdl_analytics_used_analysables` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_used_analysables` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_used_analysables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_used_files`
--

DROP TABLE IF EXISTS `mdl_analytics_used_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_used_files` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL DEFAULT '0',
  `fileid` bigint(10) NOT NULL DEFAULT '0',
  `action` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `time` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_analusedfile_modactfil_ix` (`modelid`,`action`,`fileid`),
  KEY `mdl_analusedfile_mod_ix` (`modelid`),
  KEY `mdl_analusedfile_fil_ix` (`fileid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Files that have already been used for training and predictio';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_used_files`
--

LOCK TABLES `mdl_analytics_used_files` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_used_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_used_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign`
--

DROP TABLE IF EXISTS `mdl_assign`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `alwaysshowdescription` tinyint(2) NOT NULL DEFAULT '0',
  `nosubmissions` tinyint(2) NOT NULL DEFAULT '0',
  `submissiondrafts` tinyint(2) NOT NULL DEFAULT '0',
  `sendnotifications` tinyint(2) NOT NULL DEFAULT '0',
  `sendlatenotifications` tinyint(2) NOT NULL DEFAULT '0',
  `duedate` bigint(10) NOT NULL DEFAULT '0',
  `allowsubmissionsfromdate` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `requiresubmissionstatement` tinyint(2) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(2) NOT NULL DEFAULT '0',
  `cutoffdate` bigint(10) NOT NULL DEFAULT '0',
  `gradingduedate` bigint(10) NOT NULL DEFAULT '0',
  `teamsubmission` tinyint(2) NOT NULL DEFAULT '0',
  `requireallteammemberssubmit` tinyint(2) NOT NULL DEFAULT '0',
  `teamsubmissiongroupingid` bigint(10) NOT NULL DEFAULT '0',
  `blindmarking` tinyint(2) NOT NULL DEFAULT '0',
  `revealidentities` tinyint(2) NOT NULL DEFAULT '0',
  `attemptreopenmethod` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  `maxattempts` mediumint(6) NOT NULL DEFAULT '-1',
  `markingworkflow` tinyint(2) NOT NULL DEFAULT '0',
  `markingallocation` tinyint(2) NOT NULL DEFAULT '0',
  `sendstudentnotifications` tinyint(2) NOT NULL DEFAULT '1',
  `preventsubmissionnotingroup` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assi_cou_ix` (`course`),
  KEY `mdl_assi_tea_ix` (`teamsubmissiongroupingid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table saves information about an instance of mod_assign';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign`
--

LOCK TABLES `mdl_assign` WRITE;
/*!40000 ALTER TABLE `mdl_assign` DISABLE KEYS */;
INSERT INTO `mdl_assign` VALUES (1,2,'Absensi','',1,1,0,0,0,0,1549299600,1548694800,100,1548770536,0,1,0,1549904400,0,0,0,0,0,'none',-1,0,0,1,0);
/*!40000 ALTER TABLE `mdl_assign` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_grades`
--

DROP TABLE IF EXISTS `mdl_assign_grades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `grader` bigint(10) NOT NULL DEFAULT '0',
  `grade` decimal(10,5) DEFAULT '0.00000',
  `attemptnumber` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_assigrad_assuseatt_uix` (`assignment`,`userid`,`attemptnumber`),
  KEY `mdl_assigrad_use_ix` (`userid`),
  KEY `mdl_assigrad_att_ix` (`attemptnumber`),
  KEY `mdl_assigrad_ass_ix` (`assignment`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Grading information about a single assignment submission.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_grades`
--

LOCK TABLES `mdl_assign_grades` WRITE;
/*!40000 ALTER TABLE `mdl_assign_grades` DISABLE KEYS */;
INSERT INTO `mdl_assign_grades` VALUES (1,1,2,1548780969,1548780991,2,80.00000,0);
/*!40000 ALTER TABLE `mdl_assign_grades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_overrides`
--

DROP TABLE IF EXISTS `mdl_assign_overrides`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_overrides` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) DEFAULT NULL,
  `userid` bigint(10) DEFAULT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `allowsubmissionsfromdate` bigint(10) DEFAULT NULL,
  `duedate` bigint(10) DEFAULT NULL,
  `cutoffdate` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_assiover_ass_ix` (`assignid`),
  KEY `mdl_assiover_gro_ix` (`groupid`),
  KEY `mdl_assiover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The overrides to assign settings.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_overrides`
--

LOCK TABLES `mdl_assign_overrides` WRITE;
/*!40000 ALTER TABLE `mdl_assign_overrides` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_overrides` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_plugin_config`
--

DROP TABLE IF EXISTS `mdl_assign_plugin_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_plugin_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `plugin` varchar(28) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subtype` varchar(28) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(28) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_assiplugconf_plu_ix` (`plugin`),
  KEY `mdl_assiplugconf_sub_ix` (`subtype`),
  KEY `mdl_assiplugconf_nam_ix` (`name`),
  KEY `mdl_assiplugconf_ass_ix` (`assignment`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Config data for an instance of a plugin in an assignment.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_plugin_config`
--

LOCK TABLES `mdl_assign_plugin_config` WRITE;
/*!40000 ALTER TABLE `mdl_assign_plugin_config` DISABLE KEYS */;
INSERT INTO `mdl_assign_plugin_config` VALUES (1,1,'onlinetext','assignsubmission','enabled','0'),(2,1,'file','assignsubmission','enabled','1'),(3,1,'file','assignsubmission','maxfilesubmissions','20'),(4,1,'file','assignsubmission','maxsubmissionsizebytes','0'),(5,1,'file','assignsubmission','filetypeslist','image,web_image'),(6,1,'comments','assignsubmission','enabled','1'),(7,1,'comments','assignfeedback','enabled','1'),(8,1,'comments','assignfeedback','commentinline','0'),(9,1,'editpdf','assignfeedback','enabled','1'),(10,1,'offline','assignfeedback','enabled','0'),(11,1,'file','assignfeedback','enabled','0');
/*!40000 ALTER TABLE `mdl_assign_plugin_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_submission`
--

DROP TABLE IF EXISTS `mdl_assign_submission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_submission` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `status` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `attemptnumber` bigint(10) NOT NULL DEFAULT '0',
  `latest` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_assisubm_assusegroatt_uix` (`assignment`,`userid`,`groupid`,`attemptnumber`),
  KEY `mdl_assisubm_use_ix` (`userid`),
  KEY `mdl_assisubm_att_ix` (`attemptnumber`),
  KEY `mdl_assisubm_assusegrolat_ix` (`assignment`,`userid`,`groupid`,`latest`),
  KEY `mdl_assisubm_ass_ix` (`assignment`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table keeps information about student interactions with';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_submission`
--

LOCK TABLES `mdl_assign_submission` WRITE;
/*!40000 ALTER TABLE `mdl_assign_submission` DISABLE KEYS */;
INSERT INTO `mdl_assign_submission` VALUES (1,1,2,1548770597,1548780810,'submitted',0,0,1),(2,1,3,1548921237,1548921237,'new',0,0,1);
/*!40000 ALTER TABLE `mdl_assign_submission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_user_flags`
--

DROP TABLE IF EXISTS `mdl_assign_user_flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_user_flags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `mailed` smallint(4) NOT NULL DEFAULT '0',
  `extensionduedate` bigint(10) NOT NULL DEFAULT '0',
  `workflowstate` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allocatedmarker` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assiuserflag_mai_ix` (`mailed`),
  KEY `mdl_assiuserflag_use_ix` (`userid`),
  KEY `mdl_assiuserflag_ass_ix` (`assignment`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='List of flags that can be set for a single user in a single ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_user_flags`
--

LOCK TABLES `mdl_assign_user_flags` WRITE;
/*!40000 ALTER TABLE `mdl_assign_user_flags` DISABLE KEYS */;
INSERT INTO `mdl_assign_user_flags` VALUES (1,2,1,0,0,0,'',0);
/*!40000 ALTER TABLE `mdl_assign_user_flags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_user_mapping`
--

DROP TABLE IF EXISTS `mdl_assign_user_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_user_mapping` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assiusermapp_ass_ix` (`assignment`),
  KEY `mdl_assiusermapp_use_ix` (`userid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Map an assignment specific id number to a user';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_user_mapping`
--

LOCK TABLES `mdl_assign_user_mapping` WRITE;
/*!40000 ALTER TABLE `mdl_assign_user_mapping` DISABLE KEYS */;
INSERT INTO `mdl_assign_user_mapping` VALUES (1,1,2);
/*!40000 ALTER TABLE `mdl_assign_user_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_comments`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `commenttext` longtext COLLATE utf8mb4_unicode_ci,
  `commentformat` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assicomm_ass_ix` (`assignment`),
  KEY `mdl_assicomm_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Text feedback for submitted assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_comments`
--

LOCK TABLES `mdl_assignfeedback_comments` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_annot`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_annot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_editpdf_annot` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `gradeid` bigint(10) NOT NULL DEFAULT '0',
  `pageno` bigint(10) NOT NULL DEFAULT '0',
  `x` bigint(10) DEFAULT '0',
  `y` bigint(10) DEFAULT '0',
  `endx` bigint(10) DEFAULT '0',
  `endy` bigint(10) DEFAULT '0',
  `path` longtext COLLATE utf8mb4_unicode_ci,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT 'line',
  `colour` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT 'black',
  `draft` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdl_assieditanno_grapag_ix` (`gradeid`,`pageno`),
  KEY `mdl_assieditanno_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='stores annotations added to pdfs submitted by students';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_annot`
--

LOCK TABLES `mdl_assignfeedback_editpdf_annot` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_annot` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_annot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_cmnt`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_cmnt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_editpdf_cmnt` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `gradeid` bigint(10) NOT NULL DEFAULT '0',
  `x` bigint(10) DEFAULT '0',
  `y` bigint(10) DEFAULT '0',
  `width` bigint(10) DEFAULT '120',
  `rawtext` longtext COLLATE utf8mb4_unicode_ci,
  `pageno` bigint(10) NOT NULL DEFAULT '0',
  `colour` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT 'black',
  `draft` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdl_assieditcmnt_grapag_ix` (`gradeid`,`pageno`),
  KEY `mdl_assieditcmnt_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores comments added to pdfs';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_cmnt`
--

LOCK TABLES `mdl_assignfeedback_editpdf_cmnt` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_cmnt` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_cmnt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_queue`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_editpdf_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `submissionid` bigint(10) NOT NULL,
  `submissionattempt` bigint(10) NOT NULL,
  `attemptedconversions` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_assieditqueu_subsub_uix` (`submissionid`,`submissionattempt`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Queue for processing.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_queue`
--

LOCK TABLES `mdl_assignfeedback_editpdf_queue` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_queue` DISABLE KEYS */;
INSERT INTO `mdl_assignfeedback_editpdf_queue` VALUES (1,1,0,0);
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_quick`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_quick`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_editpdf_quick` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `rawtext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` bigint(10) NOT NULL DEFAULT '120',
  `colour` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT 'yellow',
  PRIMARY KEY (`id`),
  KEY `mdl_assieditquic_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores teacher specified quicklist comments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_quick`
--

LOCK TABLES `mdl_assignfeedback_editpdf_quick` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_quick` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_quick` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_file`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_file` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assifile_ass2_ix` (`assignment`),
  KEY `mdl_assifile_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores info about the number of files submitted by a student';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_file`
--

LOCK TABLES `mdl_assignfeedback_file` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_file` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_file` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignment`
--

DROP TABLE IF EXISTS `mdl_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignment` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `assignmenttype` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `resubmit` tinyint(2) NOT NULL DEFAULT '0',
  `preventlate` tinyint(2) NOT NULL DEFAULT '0',
  `emailteachers` tinyint(2) NOT NULL DEFAULT '0',
  `var1` bigint(10) DEFAULT '0',
  `var2` bigint(10) DEFAULT '0',
  `var3` bigint(10) DEFAULT '0',
  `var4` bigint(10) DEFAULT '0',
  `var5` bigint(10) DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '100000',
  `timedue` bigint(10) NOT NULL DEFAULT '0',
  `timeavailable` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assi_cou2_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignment`
--

LOCK TABLES `mdl_assignment` WRITE;
/*!40000 ALTER TABLE `mdl_assignment` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignment_submissions`
--

DROP TABLE IF EXISTS `mdl_assignment_submissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignment_submissions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  `data1` longtext COLLATE utf8mb4_unicode_ci,
  `data2` longtext COLLATE utf8mb4_unicode_ci,
  `grade` bigint(11) NOT NULL DEFAULT '0',
  `submissioncomment` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `format` smallint(4) NOT NULL DEFAULT '0',
  `teacher` bigint(10) NOT NULL DEFAULT '0',
  `timemarked` bigint(10) NOT NULL DEFAULT '0',
  `mailed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assisubm_use2_ix` (`userid`),
  KEY `mdl_assisubm_mai_ix` (`mailed`),
  KEY `mdl_assisubm_tim_ix` (`timemarked`),
  KEY `mdl_assisubm_ass2_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Info about submitted assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignment_submissions`
--

LOCK TABLES `mdl_assignment_submissions` WRITE;
/*!40000 ALTER TABLE `mdl_assignment_submissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignment_submissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignment_upgrade`
--

DROP TABLE IF EXISTS `mdl_assignment_upgrade`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignment_upgrade` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `oldcmid` bigint(10) NOT NULL DEFAULT '0',
  `oldinstance` bigint(10) NOT NULL DEFAULT '0',
  `newcmid` bigint(10) NOT NULL DEFAULT '0',
  `newinstance` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assiupgr_old_ix` (`oldcmid`),
  KEY `mdl_assiupgr_old2_ix` (`oldinstance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Info about upgraded assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignment_upgrade`
--

LOCK TABLES `mdl_assignment_upgrade` WRITE;
/*!40000 ALTER TABLE `mdl_assignment_upgrade` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignment_upgrade` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignsubmission_file`
--

DROP TABLE IF EXISTS `mdl_assignsubmission_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignsubmission_file` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `submission` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assifile_ass_ix` (`assignment`),
  KEY `mdl_assifile_sub_ix` (`submission`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Info about file submissions for assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignsubmission_file`
--

LOCK TABLES `mdl_assignsubmission_file` WRITE;
/*!40000 ALTER TABLE `mdl_assignsubmission_file` DISABLE KEYS */;
INSERT INTO `mdl_assignsubmission_file` VALUES (1,1,1,1);
/*!40000 ALTER TABLE `mdl_assignsubmission_file` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignsubmission_onlinetext`
--

DROP TABLE IF EXISTS `mdl_assignsubmission_onlinetext`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignsubmission_onlinetext` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `submission` bigint(10) NOT NULL DEFAULT '0',
  `onlinetext` longtext COLLATE utf8mb4_unicode_ci,
  `onlineformat` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assionli_ass_ix` (`assignment`),
  KEY `mdl_assionli_sub_ix` (`submission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Info about onlinetext submission';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignsubmission_onlinetext`
--

LOCK TABLES `mdl_assignsubmission_onlinetext` WRITE;
/*!40000 ALTER TABLE `mdl_assignsubmission_onlinetext` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignsubmission_onlinetext` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_auth_oauth2_linked_login`
--

DROP TABLE IF EXISTS `mdl_auth_oauth2_linked_login`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_auth_oauth2_linked_login` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `confirmtoken` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirmtokenexpires` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_authoautlinklogi_useis_uix` (`userid`,`issuerid`,`username`),
  KEY `mdl_authoautlinklogi_issuse_ix` (`issuerid`,`username`),
  KEY `mdl_authoautlinklogi_use_ix` (`usermodified`),
  KEY `mdl_authoautlinklogi_use2_ix` (`userid`),
  KEY `mdl_authoautlinklogi_iss_ix` (`issuerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Accounts linked to a users Moodle account.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_auth_oauth2_linked_login`
--

LOCK TABLES `mdl_auth_oauth2_linked_login` WRITE;
/*!40000 ALTER TABLE `mdl_auth_oauth2_linked_login` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_auth_oauth2_linked_login` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_availability_paypal_tnx`
--

DROP TABLE IF EXISTS `mdl_availability_paypal_tnx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_availability_paypal_tnx` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `business` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `receiver_email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `receiver_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `item_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `contextid` bigint(10) NOT NULL DEFAULT '0',
  `memo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_name1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_selection1_x` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_name2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_selection2_x` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `payment_status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pending_reason` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `reason_code` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `txn_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parent_txn_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `payment_type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timeupdated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_avaipayptnx_con_ix` (`contextid`),
  KEY `mdl_avaipayptnx_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Holds all known information about PayPal transactions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_availability_paypal_tnx`
--

LOCK TABLES `mdl_availability_paypal_tnx` WRITE;
/*!40000 ALTER TABLE `mdl_availability_paypal_tnx` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_availability_paypal_tnx` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_backup_controllers`
--

DROP TABLE IF EXISTS `mdl_backup_controllers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_backup_controllers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `operation` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'backup',
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `format` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `interactive` smallint(4) NOT NULL,
  `purpose` smallint(4) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `status` smallint(4) NOT NULL,
  `execution` smallint(4) NOT NULL,
  `executiontime` bigint(10) NOT NULL,
  `checksum` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `controller` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_backcont_bac_uix` (`backupid`),
  KEY `mdl_backcont_typite_ix` (`type`,`itemid`),
  KEY `mdl_backcont_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='To store the backup_controllers as they are used';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_backup_controllers`
--

LOCK TABLES `mdl_backup_controllers` WRITE;
/*!40000 ALTER TABLE `mdl_backup_controllers` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_backup_controllers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_backup_courses`
--

DROP TABLE IF EXISTS `mdl_backup_courses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_backup_courses` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `laststarttime` bigint(10) NOT NULL DEFAULT '0',
  `lastendtime` bigint(10) NOT NULL DEFAULT '0',
  `laststatus` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '5',
  `nextstarttime` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_backcour_cou_uix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='To store every course backup status';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_backup_courses`
--

LOCK TABLES `mdl_backup_courses` WRITE;
/*!40000 ALTER TABLE `mdl_backup_courses` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_backup_courses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_backup_logs`
--

DROP TABLE IF EXISTS `mdl_backup_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_backup_logs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `loglevel` smallint(4) NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_backlogs_bacid_uix` (`backupid`,`id`),
  KEY `mdl_backlogs_bac_ix` (`backupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='To store all the logs from backup and restore operations (by';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_backup_logs`
--

LOCK TABLES `mdl_backup_logs` WRITE;
/*!40000 ALTER TABLE `mdl_backup_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_backup_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge`
--

DROP TABLE IF EXISTS `mdl_badge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `usercreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `issuername` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `issuerurl` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `issuercontact` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expiredate` bigint(10) DEFAULT NULL,
  `expireperiod` bigint(10) DEFAULT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `courseid` bigint(10) DEFAULT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `messagesubject` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attachment` tinyint(1) NOT NULL DEFAULT '1',
  `notification` tinyint(1) NOT NULL DEFAULT '1',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `nextcron` bigint(10) DEFAULT NULL,
  `version` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageauthorname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageauthoremail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageauthorurl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imagecaption` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_badg_typ_ix` (`type`),
  KEY `mdl_badg_cou_ix` (`courseid`),
  KEY `mdl_badg_use_ix` (`usermodified`),
  KEY `mdl_badg_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines badge';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge`
--

LOCK TABLES `mdl_badge` WRITE;
/*!40000 ALTER TABLE `mdl_badge` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_backpack`
--

DROP TABLE IF EXISTS `mdl_badge_backpack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_backpack` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `backpackurl` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `backpackuid` bigint(10) NOT NULL,
  `autosync` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgback_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines settings for connecting external backpack';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_backpack`
--

LOCK TABLES `mdl_badge_backpack` WRITE;
/*!40000 ALTER TABLE `mdl_badge_backpack` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_backpack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_competencies`
--

DROP TABLE IF EXISTS `mdl_badge_competencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_competencies` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `targetname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `targeturl` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `targetdescription` longtext COLLATE utf8mb4_unicode_ci,
  `targetframework` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `targetcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgcomp_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines competencies alignment for badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_competencies`
--

LOCK TABLES `mdl_badge_competencies` WRITE;
/*!40000 ALTER TABLE `mdl_badge_competencies` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_competencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_criteria`
--

DROP TABLE IF EXISTS `mdl_badge_criteria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '1',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgcrit_badcri_uix` (`badgeid`,`criteriatype`),
  KEY `mdl_badgcrit_cri_ix` (`criteriatype`),
  KEY `mdl_badgcrit_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines criteria for issuing badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_criteria`
--

LOCK TABLES `mdl_badge_criteria` WRITE;
/*!40000 ALTER TABLE `mdl_badge_criteria` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_criteria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_criteria_met`
--

DROP TABLE IF EXISTS `mdl_badge_criteria_met`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_criteria_met` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `issuedid` bigint(10) DEFAULT NULL,
  `critid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `datemet` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgcritmet_cri_ix` (`critid`),
  KEY `mdl_badgcritmet_use_ix` (`userid`),
  KEY `mdl_badgcritmet_iss_ix` (`issuedid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines criteria that were met for an issued badge';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_criteria_met`
--

LOCK TABLES `mdl_badge_criteria_met` WRITE;
/*!40000 ALTER TABLE `mdl_badge_criteria_met` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_criteria_met` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_criteria_param`
--

DROP TABLE IF EXISTS `mdl_badge_criteria_param`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_criteria_param` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `critid` bigint(10) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgcritpara_cri_ix` (`critid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines parameters for badges criteria';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_criteria_param`
--

LOCK TABLES `mdl_badge_criteria_param` WRITE;
/*!40000 ALTER TABLE `mdl_badge_criteria_param` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_criteria_param` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_endorsement`
--

DROP TABLE IF EXISTS `mdl_badge_endorsement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_endorsement` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `issuername` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `issuerurl` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `issueremail` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `claimid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `claimcomment` longtext COLLATE utf8mb4_unicode_ci,
  `dateissued` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_badgendo_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines endorsement for badge';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_endorsement`
--

LOCK TABLES `mdl_badge_endorsement` WRITE;
/*!40000 ALTER TABLE `mdl_badge_endorsement` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_endorsement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_external`
--

DROP TABLE IF EXISTS `mdl_badge_external`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_external` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backpackid` bigint(10) NOT NULL,
  `collectionid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgexte_bac_ix` (`backpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Setting for external badges display';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_external`
--

LOCK TABLES `mdl_badge_external` WRITE;
/*!40000 ALTER TABLE `mdl_badge_external` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_external` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_issued`
--

DROP TABLE IF EXISTS `mdl_badge_issued`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_issued` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `uniquehash` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dateissued` bigint(10) NOT NULL DEFAULT '0',
  `dateexpire` bigint(10) DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '0',
  `issuernotified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgissu_baduse_uix` (`badgeid`,`userid`),
  KEY `mdl_badgissu_bad_ix` (`badgeid`),
  KEY `mdl_badgissu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines issued badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_issued`
--

LOCK TABLES `mdl_badge_issued` WRITE;
/*!40000 ALTER TABLE `mdl_badge_issued` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_issued` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_manual_award`
--

DROP TABLE IF EXISTS `mdl_badge_manual_award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_manual_award` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL,
  `recipientid` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `issuerrole` bigint(10) NOT NULL,
  `datemet` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgmanuawar_bad_ix` (`badgeid`),
  KEY `mdl_badgmanuawar_rec_ix` (`recipientid`),
  KEY `mdl_badgmanuawar_iss_ix` (`issuerid`),
  KEY `mdl_badgmanuawar_iss2_ix` (`issuerrole`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Track manual award criteria for badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_manual_award`
--

LOCK TABLES `mdl_badge_manual_award` WRITE;
/*!40000 ALTER TABLE `mdl_badge_manual_award` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_manual_award` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_related`
--

DROP TABLE IF EXISTS `mdl_badge_related`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_related` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `relatedbadgeid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgrela_badrel_uix` (`badgeid`,`relatedbadgeid`),
  KEY `mdl_badgrela_bad_ix` (`badgeid`),
  KEY `mdl_badgrela_rel_ix` (`relatedbadgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines badge related for badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_related`
--

LOCK TABLES `mdl_badge_related` WRITE;
/*!40000 ALTER TABLE `mdl_badge_related` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_related` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_bigbluebuttonbn`
--

DROP TABLE IF EXISTS `mdl_bigbluebuttonbn`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_bigbluebuttonbn` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `type` tinyint(2) NOT NULL DEFAULT '0',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci,
  `introformat` smallint(4) NOT NULL DEFAULT '1',
  `meetingid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `moderatorpass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `viewerpass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `wait` tinyint(1) NOT NULL DEFAULT '0',
  `record` tinyint(1) NOT NULL DEFAULT '0',
  `welcome` longtext COLLATE utf8mb4_unicode_ci,
  `voicebridge` mediumint(5) NOT NULL DEFAULT '0',
  `openingtime` bigint(10) NOT NULL DEFAULT '0',
  `closingtime` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `presentation` longtext COLLATE utf8mb4_unicode_ci,
  `participants` longtext COLLATE utf8mb4_unicode_ci,
  `userlimit` smallint(3) NOT NULL DEFAULT '0',
  `recordings_html` tinyint(1) NOT NULL DEFAULT '0',
  `recordings_deleted` tinyint(1) NOT NULL DEFAULT '1',
  `recordings_imported` tinyint(1) NOT NULL DEFAULT '0',
  `recordings_preview` tinyint(1) NOT NULL DEFAULT '0',
  `clienttype` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The bigbluebuttonbn table to store information about a meeti';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_bigbluebuttonbn`
--

LOCK TABLES `mdl_bigbluebuttonbn` WRITE;
/*!40000 ALTER TABLE `mdl_bigbluebuttonbn` DISABLE KEYS */;
INSERT INTO `mdl_bigbluebuttonbn` VALUES (1,0,2,'Interview Test (Live)','',1,'f1ddebafb99364fb76e688a562c55be25132f6b9','QtWHi?oY&8c;','@;W,?uM3j6zb',0,1,'',0,0,0,1551203143,1551236547,'','[{\"selectiontype\":\"all\",\"selectionid\":\"all\",\"role\":\"viewer\"},{\"selectiontype\":\"user\",\"selectionid\":\"2\",\"role\":\"moderator\"}]',0,1,1,0,1,0);
/*!40000 ALTER TABLE `mdl_bigbluebuttonbn` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_bigbluebuttonbn_logs`
--

DROP TABLE IF EXISTS `mdl_bigbluebuttonbn_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_bigbluebuttonbn_logs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `bigbluebuttonbnid` bigint(10) NOT NULL,
  `userid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `meetingid` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `log` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The bigbluebuttonbn table to store meeting activity events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_bigbluebuttonbn_logs`
--

LOCK TABLES `mdl_bigbluebuttonbn_logs` WRITE;
/*!40000 ALTER TABLE `mdl_bigbluebuttonbn_logs` DISABLE KEYS */;
INSERT INTO `mdl_bigbluebuttonbn_logs` VALUES (1,2,1,2,1551203143,'f1ddebafb99364fb76e688a562c55be25132f6b9','Add',NULL),(2,2,1,2,1551236547,'f1ddebafb99364fb76e688a562c55be25132f6b9','Edit',NULL),(3,2,1,2,1551236606,'f1ddebafb99364fb76e688a562c55be25132f6b9-2-1','Create','{\"record\":true}'),(4,2,1,2,1551236610,'f1ddebafb99364fb76e688a562c55be25132f6b9-2-1','Join',NULL);
/*!40000 ALTER TABLE `mdl_bigbluebuttonbn_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block`
--

DROP TABLE IF EXISTS `mdl_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cron` bigint(10) NOT NULL DEFAULT '0',
  `lastcron` bigint(10) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_bloc_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='contains all installed blocks';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block`
--

LOCK TABLES `mdl_block` WRITE;
/*!40000 ALTER TABLE `mdl_block` DISABLE KEYS */;
INSERT INTO `mdl_block` VALUES (1,'activity_modules',0,0,1),(2,'activity_results',0,0,1),(3,'admin_bookmarks',0,0,1),(4,'badges',0,0,1),(5,'blog_menu',0,0,1),(6,'blog_recent',0,0,1),(7,'blog_tags',0,0,1),(8,'calendar_month',0,0,1),(9,'calendar_upcoming',0,0,1),(10,'comments',0,0,1),(11,'community',0,0,1),(12,'completionstatus',0,0,1),(13,'course_list',0,0,1),(14,'course_summary',0,0,1),(15,'feedback',0,0,1),(16,'globalsearch',0,0,1),(17,'glossary_random',0,0,1),(18,'html',0,0,1),(19,'login',0,0,1),(20,'lp',0,0,1),(21,'mentees',0,0,1),(22,'mnet_hosts',0,0,1),(23,'myoverview',0,0,1),(24,'myprofile',0,0,1),(25,'navigation',0,0,1),(26,'news_items',0,0,1),(27,'online_users',0,0,1),(28,'participants',0,0,1),(29,'private_files',0,0,1),(30,'quiz_results',0,0,0),(31,'recent_activity',0,0,1),(32,'recentlyaccessedcourses',0,0,1),(33,'recentlyaccesseditems',0,0,1),(34,'rss_client',0,0,1),(35,'search_forums',0,0,1),(36,'section_links',0,0,1),(37,'selfcompletion',0,0,1),(38,'settings',0,0,1),(39,'site_main_menu',0,0,1),(40,'social_activities',0,0,1),(41,'starredcourses',0,0,1),(42,'tag_flickr',0,0,1),(43,'tag_youtube',0,0,0),(44,'tags',0,0,1),(45,'timeline',0,0,1),(46,'mylivechat',0,0,1);
/*!40000 ALTER TABLE `mdl_block` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_community`
--

DROP TABLE IF EXISTS `mdl_block_community`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_community` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `coursename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `coursedescription` longtext COLLATE utf8mb4_unicode_ci,
  `courseurl` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `imageurl` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Community block';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_community`
--

LOCK TABLES `mdl_block_community` WRITE;
/*!40000 ALTER TABLE `mdl_block_community` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_block_community` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_instances`
--

DROP TABLE IF EXISTS `mdl_block_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_instances` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `blockname` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parentcontextid` bigint(10) NOT NULL,
  `showinsubcontexts` smallint(4) NOT NULL,
  `requiredbytheme` smallint(4) NOT NULL DEFAULT '0',
  `pagetypepattern` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subpagepattern` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `defaultregion` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `defaultweight` bigint(10) NOT NULL,
  `configdata` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_blocinst_parshopagsub_ix` (`parentcontextid`,`showinsubcontexts`,`pagetypepattern`,`subpagepattern`),
  KEY `mdl_blocinst_tim_ix` (`timemodified`),
  KEY `mdl_blocinst_par_ix` (`parentcontextid`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table stores block instances. The type of block this is';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_instances`
--

LOCK TABLES `mdl_block_instances` WRITE;
/*!40000 ALTER TABLE `mdl_block_instances` DISABLE KEYS */;
INSERT INTO `mdl_block_instances` VALUES (1,'admin_bookmarks',1,0,0,'admin-*',NULL,'side-pre',2,'',1547809672,1547809672),(2,'timeline',1,0,0,'my-index','2','side-post',0,'',1547809672,1547809672),(3,'private_files',1,0,0,'my-index','2','side-post',1,'',1547809672,1547809672),(4,'online_users',1,0,0,'my-index','2','side-post',2,'',1547809672,1547809672),(5,'badges',1,0,0,'my-index','2','side-post',3,'',1547809673,1547809673),(6,'calendar_month',1,0,0,'my-index','2','side-post',4,'',1547809673,1547809673),(7,'calendar_upcoming',1,0,0,'my-index','2','side-post',5,'',1547809673,1547809673),(8,'lp',1,0,0,'my-index','2','content',0,'',1547809673,1547809673),(9,'recentlyaccessedcourses',1,0,0,'my-index','2','content',1,'',1547809673,1547809673),(10,'myoverview',1,0,0,'my-index','2','content',2,'',1547809673,1547809673),(11,'timeline',5,0,0,'my-index','3','side-post',0,'',1547810179,1547810179),(12,'private_files',5,0,0,'my-index','3','side-post',1,'',1547810179,1547810179),(13,'online_users',5,0,0,'my-index','3','side-post',2,'',1547810179,1547810179),(14,'badges',5,0,0,'my-index','3','side-post',3,'',1547810179,1547810179),(15,'calendar_month',5,0,0,'my-index','3','side-post',4,'',1547810179,1547810179),(16,'calendar_upcoming',5,0,0,'my-index','3','side-post',5,'',1547810179,1547810179),(17,'lp',5,0,0,'my-index','3','content',0,'',1547810179,1547810179),(18,'recentlyaccessedcourses',5,0,0,'my-index','3','content',1,'',1547810180,1547810180),(19,'myoverview',5,0,0,'my-index','3','content',2,'',1547810180,1547810180),(20,'navigation',1,1,1,'*',NULL,'side-post',0,'',1548773048,1548773048),(21,'settings',1,1,1,'*',NULL,'side-post',0,'',1548773048,1548773048),(22,'timeline',31,0,0,'my-index','5','side-post',0,'',1548920747,1548920747),(23,'private_files',31,0,0,'my-index','5','side-post',1,'',1548920747,1548920747),(24,'online_users',31,0,0,'my-index','5','side-post',2,'',1548920747,1548920747),(25,'badges',31,0,0,'my-index','5','side-post',3,'',1548920747,1548920747),(26,'calendar_month',31,0,0,'my-index','5','side-post',4,'',1548920747,1548920747),(27,'calendar_upcoming',31,0,0,'my-index','5','side-post',5,'',1548920748,1548920748),(28,'lp',31,0,0,'my-index','5','content',0,'',1548920748,1548920748),(29,'recentlyaccessedcourses',31,0,0,'my-index','5','content',1,'',1548920748,1548920748),(30,'myoverview',31,0,0,'my-index','5','content',2,'',1548920748,1548920748);
/*!40000 ALTER TABLE `mdl_block_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_positions`
--

DROP TABLE IF EXISTS `mdl_block_positions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_positions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `blockinstanceid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `pagetype` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subpage` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `visible` smallint(4) NOT NULL,
  `region` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `weight` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_blocposi_bloconpagsub_uix` (`blockinstanceid`,`contextid`,`pagetype`,`subpage`),
  KEY `mdl_blocposi_blo_ix` (`blockinstanceid`),
  KEY `mdl_blocposi_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the position of a sticky block_instance on a another ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_positions`
--

LOCK TABLES `mdl_block_positions` WRITE;
/*!40000 ALTER TABLE `mdl_block_positions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_block_positions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_recent_activity`
--

DROP TABLE IF EXISTS `mdl_block_recent_activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_recent_activity` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `cmid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `action` tinyint(1) NOT NULL,
  `modname` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_blocreceacti_coutim_ix` (`courseid`,`timecreated`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Recent activity block';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_recent_activity`
--

LOCK TABLES `mdl_block_recent_activity` WRITE;
/*!40000 ALTER TABLE `mdl_block_recent_activity` DISABLE KEYS */;
INSERT INTO `mdl_block_recent_activity` VALUES (1,2,2,1548770537,2,0,NULL),(2,2,3,1551203143,2,0,NULL),(3,2,4,1551203331,2,0,NULL),(4,2,5,1551206450,2,0,NULL),(5,2,3,1551207298,2,1,NULL),(6,2,4,1551207305,2,1,NULL),(7,2,5,1551207325,2,1,NULL),(8,2,5,1551207340,2,1,NULL),(9,2,4,1551207934,2,1,NULL),(10,2,4,1551208020,2,1,NULL),(11,2,3,1551236547,2,1,NULL);
/*!40000 ALTER TABLE `mdl_block_recent_activity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_recentlyaccesseditems`
--

DROP TABLE IF EXISTS `mdl_block_recentlyaccesseditems`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_recentlyaccesseditems` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `cmid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `timeaccess` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_blocrece_usecoucmi_uix` (`userid`,`courseid`,`cmid`),
  KEY `mdl_blocrece_use_ix` (`userid`),
  KEY `mdl_blocrece_cou_ix` (`courseid`),
  KEY `mdl_blocrece_cmi_ix` (`cmid`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Most recently accessed items accessed by a user';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_recentlyaccesseditems`
--

LOCK TABLES `mdl_block_recentlyaccesseditems` WRITE;
/*!40000 ALTER TABLE `mdl_block_recentlyaccesseditems` DISABLE KEYS */;
INSERT INTO `mdl_block_recentlyaccesseditems` VALUES (1,2,2,2,1548849139),(2,2,2,3,1548921237),(3,2,4,2,1551235473),(4,2,5,2,1551235527),(5,2,4,3,1551238396);
/*!40000 ALTER TABLE `mdl_block_recentlyaccesseditems` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_rss_client`
--

DROP TABLE IF EXISTS `mdl_block_rss_client`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_rss_client` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `title` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `preferredtitle` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `shared` tinyint(2) NOT NULL DEFAULT '0',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `skiptime` bigint(10) NOT NULL DEFAULT '0',
  `skipuntil` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Remote news feed information. Contains the news feed id, the';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_rss_client`
--

LOCK TABLES `mdl_block_rss_client` WRITE;
/*!40000 ALTER TABLE `mdl_block_rss_client` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_block_rss_client` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_blog_association`
--

DROP TABLE IF EXISTS `mdl_blog_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_blog_association` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `blogid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_blogasso_con_ix` (`contextid`),
  KEY `mdl_blogasso_blo_ix` (`blogid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Associations of blog entries with courses and module instanc';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_blog_association`
--

LOCK TABLES `mdl_blog_association` WRITE;
/*!40000 ALTER TABLE `mdl_blog_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_blog_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_blog_external`
--

DROP TABLE IF EXISTS `mdl_blog_external`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_blog_external` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `url` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `filtertags` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `failedlastsync` tinyint(1) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) DEFAULT NULL,
  `timefetched` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_blogexte_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='External blog links used for RSS copying of blog entries to ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_blog_external`
--

LOCK TABLES `mdl_blog_external` WRITE;
/*!40000 ALTER TABLE `mdl_blog_external` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_blog_external` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_book`
--

DROP TABLE IF EXISTS `mdl_book`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_book` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `numbering` smallint(4) NOT NULL DEFAULT '0',
  `navstyle` smallint(4) NOT NULL DEFAULT '1',
  `customtitles` tinyint(2) NOT NULL DEFAULT '0',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines book';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_book`
--

LOCK TABLES `mdl_book` WRITE;
/*!40000 ALTER TABLE `mdl_book` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_book` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_book_chapters`
--

DROP TABLE IF EXISTS `mdl_book_chapters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_book_chapters` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `bookid` bigint(10) NOT NULL DEFAULT '0',
  `pagenum` bigint(10) NOT NULL DEFAULT '0',
  `subchapter` bigint(10) NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contentformat` smallint(4) NOT NULL DEFAULT '0',
  `hidden` tinyint(2) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `importsrc` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines book_chapters';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_book_chapters`
--

LOCK TABLES `mdl_book_chapters` WRITE;
/*!40000 ALTER TABLE `mdl_book_chapters` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_book_chapters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cache_filters`
--

DROP TABLE IF EXISTS `mdl_cache_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_cache_filters` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` bigint(10) NOT NULL DEFAULT '0',
  `md5key` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rawtext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_cachfilt_filmd5_ix` (`filter`,`md5key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='For keeping information about cached data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cache_filters`
--

LOCK TABLES `mdl_cache_filters` WRITE;
/*!40000 ALTER TABLE `mdl_cache_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_cache_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cache_flags`
--

DROP TABLE IF EXISTS `mdl_cache_flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_cache_flags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `flagtype` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiry` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_cachflag_fla_ix` (`flagtype`),
  KEY `mdl_cachflag_nam_ix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Cache of time-sensitive flags';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cache_flags`
--

LOCK TABLES `mdl_cache_flags` WRITE;
/*!40000 ALTER TABLE `mdl_cache_flags` DISABLE KEYS */;
INSERT INTO `mdl_cache_flags` VALUES (1,'userpreferenceschanged','2',1551235424,'1',1551242624),(2,'accesslib/dirtyusers','2',1548771218,'1',1548778418),(3,'userpreferenceschanged','3',1551238326,'1',1551245526),(4,'accesslib/dirtyusers','3',1548921038,'1',1548928238),(5,'accesslib/dirtycontexts','/1/25/26',1551238446,'1',1551245646),(6,'accesslib/dirtycontexts','/1',1551237726,'1',1551244926);
/*!40000 ALTER TABLE `mdl_cache_flags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_capabilities`
--

DROP TABLE IF EXISTS `mdl_capabilities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_capabilities` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `captype` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contextlevel` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `riskbitmask` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_capa_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=621 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='this defines all capabilities';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_capabilities`
--

LOCK TABLES `mdl_capabilities` WRITE;
/*!40000 ALTER TABLE `mdl_capabilities` DISABLE KEYS */;
INSERT INTO `mdl_capabilities` VALUES (1,'moodle/site:config','write',10,'moodle',62),(2,'moodle/site:configview','read',10,'moodle',0),(3,'moodle/site:readallmessages','read',10,'moodle',8),(4,'moodle/site:manageallmessaging','write',10,'moodle',8),(5,'moodle/site:deleteanymessage','write',10,'moodle',32),(6,'moodle/site:sendmessage','write',10,'moodle',16),(7,'moodle/site:deleteownmessage','write',10,'moodle',0),(8,'moodle/site:approvecourse','write',10,'moodle',4),(9,'moodle/backup:backupcourse','write',50,'moodle',28),(10,'moodle/backup:backupsection','write',50,'moodle',28),(11,'moodle/backup:backupactivity','write',70,'moodle',28),(12,'moodle/backup:backuptargethub','write',50,'moodle',28),(13,'moodle/backup:backuptargetimport','write',50,'moodle',28),(14,'moodle/backup:downloadfile','write',50,'moodle',28),(15,'moodle/backup:configure','write',50,'moodle',28),(16,'moodle/backup:userinfo','read',50,'moodle',8),(17,'moodle/backup:anonymise','read',50,'moodle',8),(18,'moodle/restore:restorecourse','write',50,'moodle',28),(19,'moodle/restore:restoresection','write',50,'moodle',28),(20,'moodle/restore:restoreactivity','write',50,'moodle',28),(21,'moodle/restore:viewautomatedfilearea','write',50,'moodle',28),(22,'moodle/restore:restoretargethub','write',50,'moodle',28),(23,'moodle/restore:restoretargetimport','write',50,'moodle',28),(24,'moodle/restore:uploadfile','write',50,'moodle',28),(25,'moodle/restore:configure','write',50,'moodle',28),(26,'moodle/restore:rolldates','write',50,'moodle',0),(27,'moodle/restore:userinfo','write',50,'moodle',30),(28,'moodle/restore:createuser','write',10,'moodle',24),(29,'moodle/site:manageblocks','write',80,'moodle',20),(30,'moodle/site:accessallgroups','read',70,'moodle',0),(31,'moodle/site:viewfullnames','read',70,'moodle',0),(32,'moodle/site:viewuseridentity','read',70,'moodle',0),(33,'moodle/site:viewreports','read',50,'moodle',8),(34,'moodle/site:trustcontent','write',70,'moodle',4),(35,'moodle/site:uploadusers','write',10,'moodle',24),(36,'moodle/filter:manage','write',50,'moodle',0),(37,'moodle/user:create','write',10,'moodle',24),(38,'moodle/user:delete','write',10,'moodle',40),(39,'moodle/user:update','write',10,'moodle',24),(40,'moodle/user:viewdetails','read',50,'moodle',0),(41,'moodle/user:viewalldetails','read',30,'moodle',8),(42,'moodle/user:viewlastip','read',30,'moodle',8),(43,'moodle/user:viewhiddendetails','read',50,'moodle',8),(44,'moodle/user:loginas','write',50,'moodle',30),(45,'moodle/user:managesyspages','write',10,'moodle',0),(46,'moodle/user:manageblocks','write',30,'moodle',0),(47,'moodle/user:manageownblocks','write',10,'moodle',0),(48,'moodle/user:manageownfiles','write',10,'moodle',0),(49,'moodle/user:ignoreuserquota','write',10,'moodle',0),(50,'moodle/my:configsyspages','write',10,'moodle',0),(51,'moodle/role:assign','write',50,'moodle',28),(52,'moodle/role:review','read',50,'moodle',8),(53,'moodle/role:override','write',50,'moodle',28),(54,'moodle/role:safeoverride','write',50,'moodle',16),(55,'moodle/role:manage','write',10,'moodle',28),(56,'moodle/role:switchroles','read',50,'moodle',12),(57,'moodle/category:manage','write',40,'moodle',4),(58,'moodle/category:viewhiddencategories','read',40,'moodle',0),(59,'moodle/cohort:manage','write',40,'moodle',0),(60,'moodle/cohort:assign','write',40,'moodle',0),(61,'moodle/cohort:view','read',50,'moodle',0),(62,'moodle/course:create','write',40,'moodle',4),(63,'moodle/course:creategroupconversations','write',50,'moodle',4),(64,'moodle/course:request','write',10,'moodle',0),(65,'moodle/course:delete','write',50,'moodle',32),(66,'moodle/course:update','write',50,'moodle',4),(67,'moodle/course:view','read',50,'moodle',0),(68,'moodle/course:enrolreview','read',50,'moodle',8),(69,'moodle/course:enrolconfig','write',50,'moodle',8),(70,'moodle/course:reviewotherusers','read',50,'moodle',0),(71,'moodle/course:bulkmessaging','write',50,'moodle',16),(72,'moodle/course:viewhiddenuserfields','read',50,'moodle',8),(73,'moodle/course:viewhiddencourses','read',50,'moodle',0),(74,'moodle/course:visibility','write',50,'moodle',0),(75,'moodle/course:managefiles','write',50,'moodle',4),(76,'moodle/course:ignoreavailabilityrestrictions','read',70,'moodle',0),(77,'moodle/course:ignorefilesizelimits','write',50,'moodle',0),(78,'moodle/course:manageactivities','write',70,'moodle',4),(79,'moodle/course:activityvisibility','write',70,'moodle',0),(80,'moodle/course:viewhiddenactivities','write',70,'moodle',0),(81,'moodle/course:viewparticipants','read',50,'moodle',0),(82,'moodle/course:changefullname','write',50,'moodle',4),(83,'moodle/course:changeshortname','write',50,'moodle',4),(84,'moodle/course:renameroles','write',50,'moodle',0),(85,'moodle/course:changeidnumber','write',50,'moodle',4),(86,'moodle/course:changecategory','write',50,'moodle',4),(87,'moodle/course:changesummary','write',50,'moodle',4),(88,'moodle/course:setforcedlanguage','write',50,'moodle',0),(89,'moodle/site:viewparticipants','read',10,'moodle',0),(90,'moodle/course:isincompletionreports','read',50,'moodle',0),(91,'moodle/course:viewscales','read',50,'moodle',0),(92,'moodle/course:managescales','write',50,'moodle',0),(93,'moodle/course:managegroups','write',50,'moodle',0),(94,'moodle/course:reset','write',50,'moodle',32),(95,'moodle/course:viewsuspendedusers','read',10,'moodle',0),(96,'moodle/course:tag','write',50,'moodle',16),(97,'moodle/blog:view','read',10,'moodle',0),(98,'moodle/blog:search','read',10,'moodle',0),(99,'moodle/blog:viewdrafts','read',10,'moodle',8),(100,'moodle/blog:create','write',10,'moodle',16),(101,'moodle/blog:manageentries','write',10,'moodle',16),(102,'moodle/blog:manageexternal','write',10,'moodle',16),(103,'moodle/calendar:manageownentries','write',50,'moodle',16),(104,'moodle/calendar:managegroupentries','write',50,'moodle',16),(105,'moodle/calendar:manageentries','write',50,'moodle',16),(106,'moodle/user:editprofile','write',30,'moodle',24),(107,'moodle/user:editownprofile','write',10,'moodle',16),(108,'moodle/user:changeownpassword','write',10,'moodle',0),(109,'moodle/user:readuserposts','read',30,'moodle',0),(110,'moodle/user:readuserblogs','read',30,'moodle',0),(111,'moodle/user:viewuseractivitiesreport','read',30,'moodle',8),(112,'moodle/user:editmessageprofile','write',30,'moodle',16),(113,'moodle/user:editownmessageprofile','write',10,'moodle',0),(114,'moodle/question:managecategory','write',50,'moodle',20),(115,'moodle/question:add','write',50,'moodle',20),(116,'moodle/question:editmine','write',50,'moodle',20),(117,'moodle/question:editall','write',50,'moodle',20),(118,'moodle/question:viewmine','read',50,'moodle',0),(119,'moodle/question:viewall','read',50,'moodle',0),(120,'moodle/question:usemine','read',50,'moodle',0),(121,'moodle/question:useall','read',50,'moodle',0),(122,'moodle/question:movemine','write',50,'moodle',0),(123,'moodle/question:moveall','write',50,'moodle',0),(124,'moodle/question:config','write',10,'moodle',2),(125,'moodle/question:flag','write',50,'moodle',0),(126,'moodle/question:tagmine','write',50,'moodle',0),(127,'moodle/question:tagall','write',50,'moodle',0),(128,'moodle/site:doclinks','read',10,'moodle',0),(129,'moodle/course:sectionvisibility','write',50,'moodle',0),(130,'moodle/course:useremail','write',50,'moodle',0),(131,'moodle/course:viewhiddensections','write',50,'moodle',0),(132,'moodle/course:setcurrentsection','write',50,'moodle',0),(133,'moodle/course:movesections','write',50,'moodle',0),(134,'moodle/site:mnetlogintoremote','read',10,'moodle',0),(135,'moodle/grade:viewall','read',50,'moodle',8),(136,'moodle/grade:view','read',50,'moodle',0),(137,'moodle/grade:viewhidden','read',50,'moodle',8),(138,'moodle/grade:import','write',50,'moodle',12),(139,'moodle/grade:export','read',50,'moodle',8),(140,'moodle/grade:manage','write',50,'moodle',12),(141,'moodle/grade:edit','write',50,'moodle',12),(142,'moodle/grade:managegradingforms','write',50,'moodle',12),(143,'moodle/grade:sharegradingforms','write',10,'moodle',4),(144,'moodle/grade:managesharedforms','write',10,'moodle',4),(145,'moodle/grade:manageoutcomes','write',50,'moodle',0),(146,'moodle/grade:manageletters','write',50,'moodle',0),(147,'moodle/grade:hide','write',50,'moodle',0),(148,'moodle/grade:lock','write',50,'moodle',0),(149,'moodle/grade:unlock','write',50,'moodle',0),(150,'moodle/my:manageblocks','write',10,'moodle',0),(151,'moodle/notes:view','read',50,'moodle',0),(152,'moodle/notes:manage','write',50,'moodle',16),(153,'moodle/tag:manage','write',10,'moodle',16),(154,'moodle/tag:edit','write',10,'moodle',16),(155,'moodle/tag:flag','write',10,'moodle',16),(156,'moodle/tag:editblocks','write',10,'moodle',0),(157,'moodle/block:view','read',80,'moodle',0),(158,'moodle/block:edit','write',80,'moodle',20),(159,'moodle/portfolio:export','read',10,'moodle',0),(160,'moodle/comment:view','read',50,'moodle',0),(161,'moodle/comment:post','write',50,'moodle',24),(162,'moodle/comment:delete','write',50,'moodle',32),(163,'moodle/webservice:createtoken','write',10,'moodle',62),(164,'moodle/webservice:managealltokens','write',10,'moodle',42),(165,'moodle/webservice:createmobiletoken','write',10,'moodle',24),(166,'moodle/rating:view','read',50,'moodle',0),(167,'moodle/rating:viewany','read',50,'moodle',8),(168,'moodle/rating:viewall','read',50,'moodle',8),(169,'moodle/rating:rate','write',50,'moodle',0),(170,'moodle/course:publish','write',10,'moodle',24),(171,'moodle/course:markcomplete','write',50,'moodle',0),(172,'moodle/course:overridecompletion','write',50,'moodle',0),(173,'moodle/community:add','write',10,'moodle',0),(174,'moodle/community:download','write',10,'moodle',0),(175,'moodle/badges:manageglobalsettings','write',10,'moodle',34),(176,'moodle/badges:viewbadges','read',50,'moodle',0),(177,'moodle/badges:manageownbadges','write',30,'moodle',0),(178,'moodle/badges:viewotherbadges','read',30,'moodle',0),(179,'moodle/badges:earnbadge','write',50,'moodle',0),(180,'moodle/badges:createbadge','write',50,'moodle',16),(181,'moodle/badges:deletebadge','write',50,'moodle',32),(182,'moodle/badges:configuredetails','write',50,'moodle',16),(183,'moodle/badges:configurecriteria','write',50,'moodle',4),(184,'moodle/badges:configuremessages','write',50,'moodle',16),(185,'moodle/badges:awardbadge','write',50,'moodle',16),(186,'moodle/badges:revokebadge','write',50,'moodle',16),(187,'moodle/badges:viewawarded','read',50,'moodle',8),(188,'moodle/site:forcelanguage','read',10,'moodle',0),(189,'moodle/search:query','read',10,'moodle',0),(190,'moodle/competency:competencymanage','write',40,'moodle',0),(191,'moodle/competency:competencyview','read',40,'moodle',0),(192,'moodle/competency:competencygrade','write',50,'moodle',0),(193,'moodle/competency:coursecompetencymanage','write',50,'moodle',0),(194,'moodle/competency:coursecompetencyconfigure','write',70,'moodle',0),(195,'moodle/competency:coursecompetencygradable','read',50,'moodle',0),(196,'moodle/competency:coursecompetencyview','read',50,'moodle',0),(197,'moodle/competency:evidencedelete','write',30,'moodle',0),(198,'moodle/competency:planmanage','write',30,'moodle',0),(199,'moodle/competency:planmanagedraft','write',30,'moodle',0),(200,'moodle/competency:planmanageown','write',30,'moodle',0),(201,'moodle/competency:planmanageowndraft','write',30,'moodle',0),(202,'moodle/competency:planview','read',30,'moodle',0),(203,'moodle/competency:planviewdraft','read',30,'moodle',0),(204,'moodle/competency:planviewown','read',30,'moodle',0),(205,'moodle/competency:planviewowndraft','read',30,'moodle',0),(206,'moodle/competency:planrequestreview','write',30,'moodle',0),(207,'moodle/competency:planrequestreviewown','write',30,'moodle',0),(208,'moodle/competency:planreview','write',30,'moodle',0),(209,'moodle/competency:plancomment','write',30,'moodle',0),(210,'moodle/competency:plancommentown','write',30,'moodle',0),(211,'moodle/competency:usercompetencyview','read',30,'moodle',0),(212,'moodle/competency:usercompetencyrequestreview','write',30,'moodle',0),(213,'moodle/competency:usercompetencyrequestreviewown','write',30,'moodle',0),(214,'moodle/competency:usercompetencyreview','write',30,'moodle',0),(215,'moodle/competency:usercompetencycomment','write',30,'moodle',0),(216,'moodle/competency:usercompetencycommentown','write',30,'moodle',0),(217,'moodle/competency:templatemanage','write',40,'moodle',0),(218,'moodle/analytics:listinsights','read',50,'moodle',8),(219,'moodle/analytics:managemodels','write',10,'moodle',2),(220,'moodle/competency:templateview','read',40,'moodle',0),(221,'moodle/competency:userevidencemanage','write',30,'moodle',0),(222,'moodle/competency:userevidencemanageown','write',30,'moodle',0),(223,'moodle/competency:userevidenceview','read',30,'moodle',0),(224,'moodle/site:maintenanceaccess','write',10,'moodle',0),(225,'moodle/site:messageanyuser','write',10,'moodle',16),(226,'moodle/site:managecontextlocks','write',70,'moodle',0),(227,'mod/assign:view','read',70,'mod_assign',0),(228,'mod/assign:submit','write',70,'mod_assign',0),(229,'mod/assign:grade','write',70,'mod_assign',4),(230,'mod/assign:exportownsubmission','read',70,'mod_assign',0),(231,'mod/assign:addinstance','write',50,'mod_assign',4),(232,'mod/assign:editothersubmission','write',70,'mod_assign',41),(233,'mod/assign:grantextension','write',70,'mod_assign',0),(234,'mod/assign:revealidentities','write',70,'mod_assign',0),(235,'mod/assign:reviewgrades','write',70,'mod_assign',0),(236,'mod/assign:releasegrades','write',70,'mod_assign',0),(237,'mod/assign:managegrades','write',70,'mod_assign',0),(238,'mod/assign:manageallocations','write',70,'mod_assign',0),(239,'mod/assign:viewgrades','read',70,'mod_assign',0),(240,'mod/assign:viewblinddetails','write',70,'mod_assign',8),(241,'mod/assign:receivegradernotifications','read',70,'mod_assign',0),(242,'mod/assign:manageoverrides','write',70,'mod_assign',0),(243,'mod/assignment:view','read',70,'mod_assignment',0),(244,'mod/assignment:addinstance','write',50,'mod_assignment',4),(245,'mod/assignment:submit','write',70,'mod_assignment',0),(246,'mod/assignment:grade','write',70,'mod_assignment',4),(247,'mod/assignment:exportownsubmission','read',70,'mod_assignment',0),(248,'mod/book:addinstance','write',50,'mod_book',4),(249,'mod/book:read','read',70,'mod_book',0),(250,'mod/book:viewhiddenchapters','read',70,'mod_book',0),(251,'mod/book:edit','write',70,'mod_book',4),(252,'mod/chat:addinstance','write',50,'mod_chat',4),(253,'mod/chat:chat','write',70,'mod_chat',16),(254,'mod/chat:readlog','read',70,'mod_chat',0),(255,'mod/chat:deletelog','write',70,'mod_chat',0),(256,'mod/chat:exportparticipatedsession','read',70,'mod_chat',8),(257,'mod/chat:exportsession','read',70,'mod_chat',8),(258,'mod/chat:view','read',70,'mod_chat',0),(259,'mod/choice:addinstance','write',50,'mod_choice',4),(260,'mod/choice:choose','write',70,'mod_choice',0),(261,'mod/choice:readresponses','read',70,'mod_choice',0),(262,'mod/choice:deleteresponses','write',70,'mod_choice',0),(263,'mod/choice:downloadresponses','read',70,'mod_choice',0),(264,'mod/choice:view','read',70,'mod_choice',0),(265,'mod/data:addinstance','write',50,'mod_data',4),(266,'mod/data:viewentry','read',70,'mod_data',0),(267,'mod/data:writeentry','write',70,'mod_data',16),(268,'mod/data:comment','write',70,'mod_data',16),(269,'mod/data:rate','write',70,'mod_data',0),(270,'mod/data:viewrating','read',70,'mod_data',0),(271,'mod/data:viewanyrating','read',70,'mod_data',8),(272,'mod/data:viewallratings','read',70,'mod_data',8),(273,'mod/data:approve','write',70,'mod_data',16),(274,'mod/data:manageentries','write',70,'mod_data',16),(275,'mod/data:managecomments','write',70,'mod_data',16),(276,'mod/data:managetemplates','write',70,'mod_data',20),(277,'mod/data:viewalluserpresets','read',70,'mod_data',0),(278,'mod/data:manageuserpresets','write',70,'mod_data',20),(279,'mod/data:exportentry','read',70,'mod_data',8),(280,'mod/data:exportownentry','read',70,'mod_data',0),(281,'mod/data:exportallentries','read',70,'mod_data',8),(282,'mod/data:exportuserinfo','read',70,'mod_data',8),(283,'mod/data:view','read',70,'mod_data',0),(284,'mod/feedback:addinstance','write',50,'mod_feedback',4),(285,'mod/feedback:view','read',70,'mod_feedback',0),(286,'mod/feedback:complete','write',70,'mod_feedback',16),(287,'mod/feedback:viewanalysepage','read',70,'mod_feedback',8),(288,'mod/feedback:deletesubmissions','write',70,'mod_feedback',0),(289,'mod/feedback:mapcourse','write',70,'mod_feedback',0),(290,'mod/feedback:edititems','write',70,'mod_feedback',20),(291,'mod/feedback:createprivatetemplate','write',70,'mod_feedback',16),(292,'mod/feedback:createpublictemplate','write',70,'mod_feedback',16),(293,'mod/feedback:deletetemplate','write',70,'mod_feedback',0),(294,'mod/feedback:viewreports','read',70,'mod_feedback',8),(295,'mod/feedback:receivemail','read',70,'mod_feedback',8),(296,'mod/folder:addinstance','write',50,'mod_folder',4),(297,'mod/folder:view','read',70,'mod_folder',0),(298,'mod/folder:managefiles','write',70,'mod_folder',16),(299,'mod/forum:addinstance','write',50,'mod_forum',4),(300,'mod/forum:viewdiscussion','read',70,'mod_forum',0),(301,'mod/forum:viewhiddentimedposts','read',70,'mod_forum',0),(302,'mod/forum:startdiscussion','write',70,'mod_forum',16),(303,'mod/forum:replypost','write',70,'mod_forum',16),(304,'mod/forum:addnews','write',70,'mod_forum',16),(305,'mod/forum:replynews','write',70,'mod_forum',16),(306,'mod/forum:viewrating','read',70,'mod_forum',0),(307,'mod/forum:viewanyrating','read',70,'mod_forum',8),(308,'mod/forum:viewallratings','read',70,'mod_forum',8),(309,'mod/forum:rate','write',70,'mod_forum',0),(310,'mod/forum:createattachment','write',70,'mod_forum',16),(311,'mod/forum:deleteownpost','write',70,'mod_forum',0),(312,'mod/forum:deleteanypost','write',70,'mod_forum',0),(313,'mod/forum:splitdiscussions','write',70,'mod_forum',0),(314,'mod/forum:movediscussions','write',70,'mod_forum',0),(315,'mod/forum:pindiscussions','write',70,'mod_forum',0),(316,'mod/forum:editanypost','write',70,'mod_forum',16),(317,'mod/forum:viewqandawithoutposting','read',70,'mod_forum',0),(318,'mod/forum:viewsubscribers','read',70,'mod_forum',0),(319,'mod/forum:managesubscriptions','write',70,'mod_forum',16),(320,'mod/forum:postwithoutthrottling','write',70,'mod_forum',16),(321,'mod/forum:exportdiscussion','read',70,'mod_forum',8),(322,'mod/forum:exportpost','read',70,'mod_forum',8),(323,'mod/forum:exportownpost','read',70,'mod_forum',8),(324,'mod/forum:addquestion','write',70,'mod_forum',16),(325,'mod/forum:allowforcesubscribe','read',70,'mod_forum',0),(326,'mod/forum:canposttomygroups','write',70,'mod_forum',0),(327,'mod/forum:canoverridediscussionlock','write',70,'mod_forum',0),(328,'mod/glossary:addinstance','write',50,'mod_glossary',4),(329,'mod/glossary:view','read',70,'mod_glossary',0),(330,'mod/glossary:write','write',70,'mod_glossary',16),(331,'mod/glossary:manageentries','write',70,'mod_glossary',16),(332,'mod/glossary:managecategories','write',70,'mod_glossary',16),(333,'mod/glossary:comment','write',70,'mod_glossary',16),(334,'mod/glossary:managecomments','write',70,'mod_glossary',16),(335,'mod/glossary:import','write',70,'mod_glossary',16),(336,'mod/glossary:export','read',70,'mod_glossary',0),(337,'mod/glossary:approve','write',70,'mod_glossary',16),(338,'mod/glossary:rate','write',70,'mod_glossary',0),(339,'mod/glossary:viewrating','read',70,'mod_glossary',0),(340,'mod/glossary:viewanyrating','read',70,'mod_glossary',8),(341,'mod/glossary:viewallratings','read',70,'mod_glossary',8),(342,'mod/glossary:exportentry','read',70,'mod_glossary',8),(343,'mod/glossary:exportownentry','read',70,'mod_glossary',0),(344,'mod/imscp:view','read',70,'mod_imscp',0),(345,'mod/imscp:addinstance','write',50,'mod_imscp',4),(346,'mod/label:addinstance','write',50,'mod_label',4),(347,'mod/label:view','read',70,'mod_label',0),(348,'mod/lesson:addinstance','write',50,'mod_lesson',4),(349,'mod/lesson:edit','write',70,'mod_lesson',4),(350,'mod/lesson:grade','write',70,'mod_lesson',20),(351,'mod/lesson:viewreports','read',70,'mod_lesson',8),(352,'mod/lesson:manage','write',70,'mod_lesson',0),(353,'mod/lesson:manageoverrides','write',70,'mod_lesson',0),(354,'mod/lesson:view','read',70,'mod_lesson',0),(355,'mod/lti:view','read',70,'mod_lti',0),(356,'mod/lti:addinstance','write',50,'mod_lti',4),(357,'mod/lti:manage','write',70,'mod_lti',8),(358,'mod/lti:admin','write',70,'mod_lti',8),(359,'mod/lti:addcoursetool','write',50,'mod_lti',0),(360,'mod/lti:requesttooladd','write',50,'mod_lti',0),(361,'mod/page:view','read',70,'mod_page',0),(362,'mod/page:addinstance','write',50,'mod_page',4),(363,'mod/quiz:view','read',70,'mod_quiz',0),(364,'mod/quiz:addinstance','write',50,'mod_quiz',4),(365,'mod/quiz:attempt','write',70,'mod_quiz',16),(366,'mod/quiz:reviewmyattempts','read',70,'mod_quiz',0),(367,'mod/quiz:manage','write',70,'mod_quiz',16),(368,'mod/quiz:manageoverrides','write',70,'mod_quiz',0),(369,'mod/quiz:preview','write',70,'mod_quiz',0),(370,'mod/quiz:grade','write',70,'mod_quiz',20),(371,'mod/quiz:regrade','write',70,'mod_quiz',16),(372,'mod/quiz:viewreports','read',70,'mod_quiz',8),(373,'mod/quiz:deleteattempts','write',70,'mod_quiz',32),(374,'mod/quiz:ignoretimelimits','read',70,'mod_quiz',0),(375,'mod/quiz:emailconfirmsubmission','read',70,'mod_quiz',0),(376,'mod/quiz:emailnotifysubmission','read',70,'mod_quiz',0),(377,'mod/quiz:emailwarnoverdue','read',70,'mod_quiz',0),(378,'mod/resource:view','read',70,'mod_resource',0),(379,'mod/resource:addinstance','write',50,'mod_resource',4),(380,'mod/scorm:addinstance','write',50,'mod_scorm',4),(381,'mod/scorm:viewreport','read',70,'mod_scorm',0),(382,'mod/scorm:skipview','read',70,'mod_scorm',0),(383,'mod/scorm:savetrack','write',70,'mod_scorm',0),(384,'mod/scorm:viewscores','read',70,'mod_scorm',0),(385,'mod/scorm:deleteresponses','write',70,'mod_scorm',0),(386,'mod/scorm:deleteownresponses','write',70,'mod_scorm',0),(387,'mod/survey:addinstance','write',50,'mod_survey',4),(388,'mod/survey:participate','read',70,'mod_survey',0),(389,'mod/survey:readresponses','read',70,'mod_survey',0),(390,'mod/survey:download','read',70,'mod_survey',0),(391,'mod/url:view','read',70,'mod_url',0),(392,'mod/url:addinstance','write',50,'mod_url',4),(393,'mod/wiki:addinstance','write',50,'mod_wiki',4),(394,'mod/wiki:viewpage','read',70,'mod_wiki',0),(395,'mod/wiki:editpage','write',70,'mod_wiki',16),(396,'mod/wiki:createpage','write',70,'mod_wiki',16),(397,'mod/wiki:viewcomment','read',70,'mod_wiki',0),(398,'mod/wiki:editcomment','write',70,'mod_wiki',16),(399,'mod/wiki:managecomment','write',70,'mod_wiki',0),(400,'mod/wiki:managefiles','write',70,'mod_wiki',0),(401,'mod/wiki:overridelock','write',70,'mod_wiki',0),(402,'mod/wiki:managewiki','write',70,'mod_wiki',0),(403,'mod/workshop:view','read',70,'mod_workshop',0),(404,'mod/workshop:addinstance','write',50,'mod_workshop',4),(405,'mod/workshop:switchphase','write',70,'mod_workshop',0),(406,'mod/workshop:editdimensions','write',70,'mod_workshop',4),(407,'mod/workshop:submit','write',70,'mod_workshop',0),(408,'mod/workshop:peerassess','write',70,'mod_workshop',0),(409,'mod/workshop:manageexamples','write',70,'mod_workshop',0),(410,'mod/workshop:allocate','write',70,'mod_workshop',0),(411,'mod/workshop:publishsubmissions','write',70,'mod_workshop',0),(412,'mod/workshop:viewauthornames','read',70,'mod_workshop',0),(413,'mod/workshop:viewreviewernames','read',70,'mod_workshop',0),(414,'mod/workshop:viewallsubmissions','read',70,'mod_workshop',0),(415,'mod/workshop:viewpublishedsubmissions','read',70,'mod_workshop',0),(416,'mod/workshop:viewauthorpublished','read',70,'mod_workshop',0),(417,'mod/workshop:viewallassessments','read',70,'mod_workshop',0),(418,'mod/workshop:overridegrades','write',70,'mod_workshop',0),(419,'mod/workshop:ignoredeadlines','write',70,'mod_workshop',0),(420,'mod/workshop:deletesubmissions','write',70,'mod_workshop',0),(421,'mod/workshop:exportsubmissions','read',70,'mod_workshop',0),(422,'auth/oauth2:managelinkedlogins','write',30,'auth_oauth2',0),(423,'enrol/category:synchronised','write',10,'enrol_category',0),(424,'enrol/category:config','write',50,'enrol_category',0),(425,'enrol/cohort:config','write',50,'enrol_cohort',0),(426,'enrol/cohort:unenrol','write',50,'enrol_cohort',0),(427,'enrol/database:unenrol','write',50,'enrol_database',0),(428,'enrol/database:config','write',50,'enrol_database',0),(429,'enrol/flatfile:manage','write',50,'enrol_flatfile',0),(430,'enrol/flatfile:unenrol','write',50,'enrol_flatfile',0),(431,'enrol/guest:config','write',50,'enrol_guest',0),(432,'enrol/imsenterprise:config','write',50,'enrol_imsenterprise',0),(433,'enrol/ldap:manage','write',50,'enrol_ldap',0),(434,'enrol/lti:config','write',50,'enrol_lti',0),(435,'enrol/lti:unenrol','write',50,'enrol_lti',0),(436,'enrol/manual:config','write',50,'enrol_manual',0),(437,'enrol/manual:enrol','write',50,'enrol_manual',0),(438,'enrol/manual:manage','write',50,'enrol_manual',0),(439,'enrol/manual:unenrol','write',50,'enrol_manual',0),(440,'enrol/manual:unenrolself','write',50,'enrol_manual',0),(441,'enrol/meta:config','write',50,'enrol_meta',0),(442,'enrol/meta:selectaslinked','read',50,'enrol_meta',0),(443,'enrol/meta:unenrol','write',50,'enrol_meta',0),(444,'enrol/mnet:config','write',50,'enrol_mnet',0),(445,'enrol/paypal:config','write',50,'enrol_paypal',0),(446,'enrol/paypal:manage','write',50,'enrol_paypal',0),(447,'enrol/paypal:unenrol','write',50,'enrol_paypal',0),(448,'enrol/paypal:unenrolself','write',50,'enrol_paypal',0),(449,'enrol/self:config','write',50,'enrol_self',0),(450,'enrol/self:manage','write',50,'enrol_self',0),(451,'enrol/self:holdkey','write',50,'enrol_self',0),(452,'enrol/self:unenrolself','write',50,'enrol_self',0),(453,'enrol/self:unenrol','write',50,'enrol_self',0),(454,'message/airnotifier:managedevice','write',10,'message_airnotifier',0),(455,'block/activity_modules:addinstance','write',80,'block_activity_modules',20),(456,'block/activity_results:addinstance','write',80,'block_activity_results',20),(457,'block/admin_bookmarks:myaddinstance','write',10,'block_admin_bookmarks',0),(458,'block/admin_bookmarks:addinstance','write',80,'block_admin_bookmarks',20),(459,'block/badges:addinstance','read',80,'block_badges',0),(460,'block/badges:myaddinstance','read',10,'block_badges',8),(461,'block/blog_menu:addinstance','write',80,'block_blog_menu',20),(462,'block/blog_recent:addinstance','write',80,'block_blog_recent',20),(463,'block/blog_tags:addinstance','write',80,'block_blog_tags',20),(464,'block/calendar_month:myaddinstance','write',10,'block_calendar_month',0),(465,'block/calendar_month:addinstance','write',80,'block_calendar_month',20),(466,'block/calendar_upcoming:myaddinstance','write',10,'block_calendar_upcoming',0),(467,'block/calendar_upcoming:addinstance','write',80,'block_calendar_upcoming',20),(468,'block/comments:myaddinstance','write',10,'block_comments',0),(469,'block/comments:addinstance','write',80,'block_comments',20),(470,'block/community:myaddinstance','write',10,'block_community',0),(471,'block/community:addinstance','write',80,'block_community',20),(472,'block/completionstatus:addinstance','write',80,'block_completionstatus',20),(473,'block/course_list:myaddinstance','write',10,'block_course_list',0),(474,'block/course_list:addinstance','write',80,'block_course_list',20),(475,'block/course_summary:addinstance','write',80,'block_course_summary',20),(476,'block/feedback:addinstance','write',80,'block_feedback',20),(477,'block/globalsearch:myaddinstance','write',10,'block_globalsearch',0),(478,'block/globalsearch:addinstance','write',80,'block_globalsearch',0),(479,'block/glossary_random:myaddinstance','write',10,'block_glossary_random',0),(480,'block/glossary_random:addinstance','write',80,'block_glossary_random',20),(481,'block/html:myaddinstance','write',10,'block_html',0),(482,'block/html:addinstance','write',80,'block_html',20),(483,'block/login:addinstance','write',80,'block_login',20),(484,'block/lp:addinstance','write',10,'block_lp',0),(485,'block/lp:myaddinstance','write',10,'block_lp',0),(486,'block/lp:view','read',10,'block_lp',0),(487,'block/mentees:myaddinstance','write',10,'block_mentees',0),(488,'block/mentees:addinstance','write',80,'block_mentees',20),(489,'block/mnet_hosts:myaddinstance','write',10,'block_mnet_hosts',0),(490,'block/mnet_hosts:addinstance','write',80,'block_mnet_hosts',20),(491,'block/myoverview:myaddinstance','write',10,'block_myoverview',0),(492,'block/myoverview:addinstance','write',80,'block_myoverview',20),(493,'block/myprofile:myaddinstance','write',10,'block_myprofile',0),(494,'block/myprofile:addinstance','write',80,'block_myprofile',20),(495,'block/navigation:myaddinstance','write',10,'block_navigation',0),(496,'block/navigation:addinstance','write',80,'block_navigation',20),(497,'block/news_items:myaddinstance','write',10,'block_news_items',0),(498,'block/news_items:addinstance','write',80,'block_news_items',20),(499,'block/online_users:myaddinstance','write',10,'block_online_users',0),(500,'block/online_users:addinstance','write',80,'block_online_users',20),(501,'block/online_users:viewlist','read',80,'block_online_users',0),(502,'block/participants:addinstance','write',80,'block_participants',20),(503,'block/private_files:myaddinstance','write',10,'block_private_files',0),(504,'block/private_files:addinstance','write',80,'block_private_files',20),(505,'block/quiz_results:addinstance','write',80,'block_quiz_results',20),(506,'block/recent_activity:addinstance','write',80,'block_recent_activity',20),(507,'block/recent_activity:viewaddupdatemodule','read',50,'block_recent_activity',0),(508,'block/recent_activity:viewdeletemodule','read',50,'block_recent_activity',0),(509,'block/recentlyaccessedcourses:myaddinstance','write',10,'block_recentlyaccessedcourses',0),(510,'block/recentlyaccessedcourses:addinstance','write',80,'block_recentlyaccessedcourses',0),(511,'block/recentlyaccesseditems:myaddinstance','write',10,'block_recentlyaccesseditems',0),(512,'block/recentlyaccesseditems:addinstance','write',80,'block_recentlyaccesseditems',0),(513,'block/rss_client:myaddinstance','write',10,'block_rss_client',0),(514,'block/rss_client:addinstance','write',80,'block_rss_client',20),(515,'block/rss_client:manageownfeeds','write',80,'block_rss_client',0),(516,'block/rss_client:manageanyfeeds','write',80,'block_rss_client',16),(517,'block/search_forums:addinstance','write',80,'block_search_forums',20),(518,'block/section_links:addinstance','write',80,'block_section_links',20),(519,'block/selfcompletion:addinstance','write',80,'block_selfcompletion',20),(520,'block/settings:myaddinstance','write',10,'block_settings',0),(521,'block/settings:addinstance','write',80,'block_settings',20),(522,'block/site_main_menu:addinstance','write',80,'block_site_main_menu',20),(523,'block/social_activities:addinstance','write',80,'block_social_activities',20),(524,'block/starredcourses:myaddinstance','write',10,'block_starredcourses',0),(525,'block/starredcourses:addinstance','write',80,'block_starredcourses',0),(526,'block/tag_flickr:addinstance','write',80,'block_tag_flickr',20),(527,'block/tag_youtube:addinstance','write',80,'block_tag_youtube',20),(528,'block/tags:myaddinstance','write',10,'block_tags',0),(529,'block/tags:addinstance','write',80,'block_tags',20),(530,'block/timeline:myaddinstance','write',10,'block_timeline',0),(531,'block/timeline:addinstance','write',80,'block_timeline',20),(532,'report/completion:view','read',50,'report_completion',8),(533,'report/courseoverview:view','read',10,'report_courseoverview',8),(534,'report/log:view','read',50,'report_log',8),(535,'report/log:viewtoday','read',50,'report_log',8),(536,'report/loglive:view','read',50,'report_loglive',8),(537,'report/outline:view','read',50,'report_outline',8),(538,'report/outline:viewuserreport','read',50,'report_outline',8),(539,'report/participation:view','read',50,'report_participation',8),(540,'report/performance:view','read',10,'report_performance',2),(541,'report/progress:view','read',50,'report_progress',8),(542,'report/questioninstances:view','read',10,'report_questioninstances',0),(543,'report/security:view','read',10,'report_security',2),(544,'report/stats:view','read',50,'report_stats',8),(545,'report/usersessions:manageownsessions','write',30,'report_usersessions',0),(546,'gradeexport/ods:view','read',50,'gradeexport_ods',8),(547,'gradeexport/ods:publish','read',50,'gradeexport_ods',8),(548,'gradeexport/txt:view','read',50,'gradeexport_txt',8),(549,'gradeexport/txt:publish','read',50,'gradeexport_txt',8),(550,'gradeexport/xls:view','read',50,'gradeexport_xls',8),(551,'gradeexport/xls:publish','read',50,'gradeexport_xls',8),(552,'gradeexport/xml:view','read',50,'gradeexport_xml',8),(553,'gradeexport/xml:publish','read',50,'gradeexport_xml',8),(554,'gradeimport/csv:view','write',50,'gradeimport_csv',0),(555,'gradeimport/direct:view','write',50,'gradeimport_direct',0),(556,'gradeimport/xml:view','write',50,'gradeimport_xml',0),(557,'gradeimport/xml:publish','write',50,'gradeimport_xml',0),(558,'gradereport/grader:view','read',50,'gradereport_grader',8),(559,'gradereport/history:view','read',50,'gradereport_history',8),(560,'gradereport/outcomes:view','read',50,'gradereport_outcomes',8),(561,'gradereport/overview:view','read',50,'gradereport_overview',8),(562,'gradereport/singleview:view','read',50,'gradereport_singleview',8),(563,'gradereport/user:view','read',50,'gradereport_user',8),(564,'webservice/rest:use','read',50,'webservice_rest',0),(565,'webservice/soap:use','read',50,'webservice_soap',0),(566,'webservice/xmlrpc:use','read',50,'webservice_xmlrpc',0),(567,'repository/areafiles:view','read',70,'repository_areafiles',0),(568,'repository/boxnet:view','read',70,'repository_boxnet',0),(569,'repository/coursefiles:view','read',70,'repository_coursefiles',0),(570,'repository/dropbox:view','read',70,'repository_dropbox',0),(571,'repository/equella:view','read',70,'repository_equella',0),(572,'repository/filesystem:view','read',70,'repository_filesystem',0),(573,'repository/flickr:view','read',70,'repository_flickr',0),(574,'repository/flickr_public:view','read',70,'repository_flickr_public',0),(575,'repository/googledocs:view','read',70,'repository_googledocs',0),(576,'repository/local:view','read',70,'repository_local',0),(577,'repository/merlot:view','read',70,'repository_merlot',0),(578,'repository/nextcloud:view','read',70,'repository_nextcloud',0),(579,'repository/onedrive:view','read',70,'repository_onedrive',0),(580,'repository/picasa:view','read',70,'repository_picasa',0),(581,'repository/recent:view','read',70,'repository_recent',0),(582,'repository/s3:view','read',70,'repository_s3',0),(583,'repository/skydrive:view','read',70,'repository_skydrive',0),(584,'repository/upload:view','read',70,'repository_upload',0),(585,'repository/url:view','read',70,'repository_url',0),(586,'repository/user:view','read',70,'repository_user',0),(587,'repository/webdav:view','read',70,'repository_webdav',0),(588,'repository/wikimedia:view','read',70,'repository_wikimedia',0),(589,'repository/youtube:view','read',70,'repository_youtube',0),(590,'tool/customlang:view','read',10,'tool_customlang',2),(591,'tool/customlang:edit','write',10,'tool_customlang',6),(592,'tool/dataprivacy:managedatarequests','write',10,'tool_dataprivacy',60),(593,'tool/dataprivacy:managedataregistry','write',10,'tool_dataprivacy',60),(594,'tool/dataprivacy:makedatarequestsforchildren','write',30,'tool_dataprivacy',24),(595,'tool/dataprivacy:downloadownrequest','read',30,'tool_dataprivacy',0),(596,'tool/dataprivacy:downloadallrequests','read',30,'tool_dataprivacy',8),(597,'tool/lpmigrate:frameworksmigrate','write',10,'tool_lpmigrate',0),(598,'tool/monitor:subscribe','read',50,'tool_monitor',8),(599,'tool/monitor:managerules','write',50,'tool_monitor',4),(600,'tool/monitor:managetool','write',10,'tool_monitor',4),(601,'tool/policy:accept','write',10,'tool_policy',0),(602,'tool/policy:acceptbehalf','write',30,'tool_policy',8),(603,'tool/policy:managedocs','write',10,'tool_policy',0),(604,'tool/policy:viewacceptances','read',10,'tool_policy',0),(605,'tool/recyclebin:deleteitems','write',50,'tool_recyclebin',32),(606,'tool/recyclebin:restoreitems','write',50,'tool_recyclebin',0),(607,'tool/recyclebin:viewitems','read',50,'tool_recyclebin',0),(608,'tool/uploaduser:uploaduserpictures','write',10,'tool_uploaduser',16),(609,'tool/usertours:managetours','write',10,'tool_usertours',4),(610,'booktool/exportimscp:export','read',70,'booktool_exportimscp',0),(611,'booktool/importhtml:import','write',70,'booktool_importhtml',4),(612,'booktool/print:print','read',70,'booktool_print',0),(613,'quiz/grading:viewstudentnames','read',70,'quiz_grading',0),(614,'quiz/grading:viewidnumber','read',70,'quiz_grading',0),(615,'quiz/statistics:view','read',70,'quiz_statistics',0),(616,'atto/recordrtc:recordaudio','write',70,'atto_recordrtc',0),(617,'atto/recordrtc:recordvideo','write',70,'atto_recordrtc',0),(618,'mod/bigbluebuttonbn:addinstance','write',50,'mod_bigbluebuttonbn',4),(619,'mod/bigbluebuttonbn:join','read',70,'mod_bigbluebuttonbn',0),(620,'mod/bigbluebuttonbn:managerecordings','read',70,'mod_bigbluebuttonbn',0);
/*!40000 ALTER TABLE `mdl_capabilities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat`
--

DROP TABLE IF EXISTS `mdl_chat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_chat` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `keepdays` bigint(11) NOT NULL DEFAULT '0',
  `studentlogs` smallint(4) NOT NULL DEFAULT '0',
  `chattime` bigint(10) NOT NULL DEFAULT '0',
  `schedule` smallint(4) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_chat_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Each of these is a chat room';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat`
--

LOCK TABLES `mdl_chat` WRITE;
/*!40000 ALTER TABLE `mdl_chat` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat_messages`
--

DROP TABLE IF EXISTS `mdl_chat_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_chat_messages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_chatmess_use_ix` (`userid`),
  KEY `mdl_chatmess_gro_ix` (`groupid`),
  KEY `mdl_chatmess_timcha_ix` (`timestamp`,`chatid`),
  KEY `mdl_chatmess_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores all the actual chat messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat_messages`
--

LOCK TABLES `mdl_chat_messages` WRITE;
/*!40000 ALTER TABLE `mdl_chat_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat_messages_current`
--

DROP TABLE IF EXISTS `mdl_chat_messages_current`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_chat_messages_current` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_chatmesscurr_use_ix` (`userid`),
  KEY `mdl_chatmesscurr_gro_ix` (`groupid`),
  KEY `mdl_chatmesscurr_timcha_ix` (`timestamp`,`chatid`),
  KEY `mdl_chatmesscurr_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores current session';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat_messages_current`
--

LOCK TABLES `mdl_chat_messages_current` WRITE;
/*!40000 ALTER TABLE `mdl_chat_messages_current` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat_messages_current` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat_users`
--

DROP TABLE IF EXISTS `mdl_chat_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_chat_users` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(11) NOT NULL DEFAULT '0',
  `userid` bigint(11) NOT NULL DEFAULT '0',
  `groupid` bigint(11) NOT NULL DEFAULT '0',
  `version` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `firstping` bigint(10) NOT NULL DEFAULT '0',
  `lastping` bigint(10) NOT NULL DEFAULT '0',
  `lastmessageping` bigint(10) NOT NULL DEFAULT '0',
  `sid` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `lang` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_chatuser_use_ix` (`userid`),
  KEY `mdl_chatuser_las_ix` (`lastping`),
  KEY `mdl_chatuser_gro_ix` (`groupid`),
  KEY `mdl_chatuser_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Keeps track of which users are in which chat rooms';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat_users`
--

LOCK TABLES `mdl_chat_users` WRITE;
/*!40000 ALTER TABLE `mdl_chat_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_choice`
--

DROP TABLE IF EXISTS `mdl_choice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_choice` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `publish` tinyint(2) NOT NULL DEFAULT '0',
  `showresults` tinyint(2) NOT NULL DEFAULT '0',
  `display` smallint(4) NOT NULL DEFAULT '0',
  `allowupdate` tinyint(2) NOT NULL DEFAULT '0',
  `allowmultiple` tinyint(2) NOT NULL DEFAULT '0',
  `showunanswered` tinyint(2) NOT NULL DEFAULT '0',
  `includeinactive` tinyint(2) NOT NULL DEFAULT '1',
  `limitanswers` tinyint(2) NOT NULL DEFAULT '0',
  `timeopen` bigint(10) NOT NULL DEFAULT '0',
  `timeclose` bigint(10) NOT NULL DEFAULT '0',
  `showpreview` tinyint(2) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_choi_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Available choices are stored here';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_choice`
--

LOCK TABLES `mdl_choice` WRITE;
/*!40000 ALTER TABLE `mdl_choice` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_choice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_choice_answers`
--

DROP TABLE IF EXISTS `mdl_choice_answers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_choice_answers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `choiceid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `optionid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_choiansw_use_ix` (`userid`),
  KEY `mdl_choiansw_cho_ix` (`choiceid`),
  KEY `mdl_choiansw_opt_ix` (`optionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='choices performed by users';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_choice_answers`
--

LOCK TABLES `mdl_choice_answers` WRITE;
/*!40000 ALTER TABLE `mdl_choice_answers` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_choice_answers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_choice_options`
--

DROP TABLE IF EXISTS `mdl_choice_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_choice_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `choiceid` bigint(10) NOT NULL DEFAULT '0',
  `text` longtext COLLATE utf8mb4_unicode_ci,
  `maxanswers` bigint(10) DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_choiopti_cho_ix` (`choiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='available options to choice';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_choice_options`
--

LOCK TABLES `mdl_choice_options` WRITE;
/*!40000 ALTER TABLE `mdl_choice_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_choice_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cohort`
--

DROP TABLE IF EXISTS `mdl_cohort`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_cohort` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `name` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `theme` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_coho_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Each record represents one cohort (aka site-wide group).';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cohort`
--

LOCK TABLES `mdl_cohort` WRITE;
/*!40000 ALTER TABLE `mdl_cohort` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_cohort` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cohort_members`
--

DROP TABLE IF EXISTS `mdl_cohort_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_cohort_members` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `cohortid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timeadded` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_cohomemb_cohuse_uix` (`cohortid`,`userid`),
  KEY `mdl_cohomemb_coh_ix` (`cohortid`),
  KEY `mdl_cohomemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link a user to a cohort.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cohort_members`
--

LOCK TABLES `mdl_cohort_members` WRITE;
/*!40000 ALTER TABLE `mdl_cohort_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_cohort_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_comments`
--

DROP TABLE IF EXISTS `mdl_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `component` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commentarea` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `format` tinyint(2) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_comm_concomite_ix` (`contextid`,`commentarea`,`itemid`),
  KEY `mdl_comm_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='moodle comments module';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_comments`
--

LOCK TABLES `mdl_comments` WRITE;
/*!40000 ALTER TABLE `mdl_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency`
--

DROP TABLE IF EXISTS `mdl_competency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `idnumber` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `competencyframeworkid` bigint(10) NOT NULL,
  `parentid` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortorder` bigint(10) NOT NULL,
  `ruletype` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ruleoutcome` tinyint(2) NOT NULL DEFAULT '0',
  `ruleconfig` longtext COLLATE utf8mb4_unicode_ci,
  `scaleid` bigint(10) DEFAULT NULL,
  `scaleconfiguration` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_comp_comidn_uix` (`competencyframeworkid`,`idnumber`),
  KEY `mdl_comp_rul_ix` (`ruleoutcome`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table contains the master record of each competency in ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency`
--

LOCK TABLES `mdl_competency` WRITE;
/*!40000 ALTER TABLE `mdl_competency` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_coursecomp`
--

DROP TABLE IF EXISTS `mdl_competency_coursecomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_coursecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `ruleoutcome` tinyint(2) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compcour_coucom_uix` (`courseid`,`competencyid`),
  KEY `mdl_compcour_courul_ix` (`courseid`,`ruleoutcome`),
  KEY `mdl_compcour_cou2_ix` (`courseid`),
  KEY `mdl_compcour_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link a competency to a course.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_coursecomp`
--

LOCK TABLES `mdl_competency_coursecomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_coursecomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_coursecomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_coursecompsetting`
--

DROP TABLE IF EXISTS `mdl_competency_coursecompsetting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_coursecompsetting` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `pushratingstouserplans` tinyint(2) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compcour_cou_uix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table contains the course specific settings for compete';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_coursecompsetting`
--

LOCK TABLES `mdl_competency_coursecompsetting` WRITE;
/*!40000 ALTER TABLE `mdl_competency_coursecompsetting` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_coursecompsetting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_evidence`
--

DROP TABLE IF EXISTS `mdl_competency_evidence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_evidence` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `usercompetencyid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `action` tinyint(2) NOT NULL,
  `actionuserid` bigint(10) DEFAULT NULL,
  `descidentifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `desccomponent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `desca` longtext COLLATE utf8mb4_unicode_ci,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `note` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_compevid_use_ix` (`usercompetencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The evidence linked to a user competency';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_evidence`
--

LOCK TABLES `mdl_competency_evidence` WRITE;
/*!40000 ALTER TABLE `mdl_competency_evidence` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_evidence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_framework`
--

DROP TABLE IF EXISTS `mdl_competency_framework`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_framework` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contextid` bigint(10) NOT NULL,
  `idnumber` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `scaleid` bigint(11) DEFAULT NULL,
  `scaleconfiguration` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `visible` tinyint(2) NOT NULL DEFAULT '1',
  `taxonomies` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compfram_idn_uix` (`idnumber`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='List of competency frameworks.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_framework`
--

LOCK TABLES `mdl_competency_framework` WRITE;
/*!40000 ALTER TABLE `mdl_competency_framework` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_framework` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_modulecomp`
--

DROP TABLE IF EXISTS `mdl_competency_modulecomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_modulecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `cmid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `ruleoutcome` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compmodu_cmicom_uix` (`cmid`,`competencyid`),
  KEY `mdl_compmodu_cmirul_ix` (`cmid`,`ruleoutcome`),
  KEY `mdl_compmodu_cmi_ix` (`cmid`),
  KEY `mdl_compmodu_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link a competency to a module.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_modulecomp`
--

LOCK TABLES `mdl_competency_modulecomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_modulecomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_modulecomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_plan`
--

DROP TABLE IF EXISTS `mdl_competency_plan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_plan` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL,
  `templateid` bigint(10) DEFAULT NULL,
  `origtemplateid` bigint(10) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `duedate` bigint(10) DEFAULT '0',
  `reviewerid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_compplan_usesta_ix` (`userid`,`status`),
  KEY `mdl_compplan_tem_ix` (`templateid`),
  KEY `mdl_compplan_stadue_ix` (`status`,`duedate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Learning plans';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_plan`
--

LOCK TABLES `mdl_competency_plan` WRITE;
/*!40000 ALTER TABLE `mdl_competency_plan` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_plan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_plancomp`
--

DROP TABLE IF EXISTS `mdl_competency_plancomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_plancomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `planid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compplan_placom_uix` (`planid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Plan competencies';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_plancomp`
--

LOCK TABLES `mdl_competency_plancomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_plancomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_plancomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_relatedcomp`
--

DROP TABLE IF EXISTS `mdl_competency_relatedcomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_relatedcomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `competencyid` bigint(10) NOT NULL,
  `relatedcompetencyid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Related competencies';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_relatedcomp`
--

LOCK TABLES `mdl_competency_relatedcomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_relatedcomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_relatedcomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_template`
--

DROP TABLE IF EXISTS `mdl_competency_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_template` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contextid` bigint(10) NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `visible` tinyint(2) NOT NULL DEFAULT '1',
  `duedate` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Learning plan templates.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_template`
--

LOCK TABLES `mdl_competency_template` WRITE;
/*!40000 ALTER TABLE `mdl_competency_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_templatecohort`
--

DROP TABLE IF EXISTS `mdl_competency_templatecohort`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_templatecohort` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `templateid` bigint(10) NOT NULL,
  `cohortid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_comptemp_temcoh_uix` (`templateid`,`cohortid`),
  KEY `mdl_comptemp_tem2_ix` (`templateid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Default comment for the table, please edit me';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_templatecohort`
--

LOCK TABLES `mdl_competency_templatecohort` WRITE;
/*!40000 ALTER TABLE `mdl_competency_templatecohort` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_templatecohort` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_templatecomp`
--

DROP TABLE IF EXISTS `mdl_competency_templatecomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_templatecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `templateid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_comptemp_tem_ix` (`templateid`),
  KEY `mdl_comptemp_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link a competency to a learning plan template.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_templatecomp`
--

LOCK TABLES `mdl_competency_templatecomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_templatecomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_templatecomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_usercomp`
--

DROP TABLE IF EXISTS `mdl_competency_usercomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_usercomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `reviewerid` bigint(10) DEFAULT NULL,
  `proficiency` tinyint(2) DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compuser_usecom_uix` (`userid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='User competencies';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_usercomp`
--

LOCK TABLES `mdl_competency_usercomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_usercomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_usercomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_usercompcourse`
--

DROP TABLE IF EXISTS `mdl_competency_usercompcourse`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_usercompcourse` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `proficiency` tinyint(2) DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compuser_usecoucom_uix` (`userid`,`courseid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='User competencies in a course';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_usercompcourse`
--

LOCK TABLES `mdl_competency_usercompcourse` WRITE;
/*!40000 ALTER TABLE `mdl_competency_usercompcourse` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_usercompcourse` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_usercompplan`
--

DROP TABLE IF EXISTS `mdl_competency_usercompplan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_usercompplan` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `planid` bigint(10) NOT NULL,
  `proficiency` tinyint(2) DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compuser_usecompla_uix` (`userid`,`competencyid`,`planid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='User competencies plans';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_usercompplan`
--

LOCK TABLES `mdl_competency_usercompplan` WRITE;
/*!40000 ALTER TABLE `mdl_competency_usercompplan` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_usercompplan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_userevidence`
--

DROP TABLE IF EXISTS `mdl_competency_userevidence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_userevidence` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `descriptionformat` tinyint(1) NOT NULL,
  `url` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_compuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The evidence of prior learning';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_userevidence`
--

LOCK TABLES `mdl_competency_userevidence` WRITE;
/*!40000 ALTER TABLE `mdl_competency_userevidence` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_userevidence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_userevidencecomp`
--

DROP TABLE IF EXISTS `mdl_competency_userevidencecomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_userevidencecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userevidenceid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compuser_usecom2_uix` (`userevidenceid`,`competencyid`),
  KEY `mdl_compuser_use2_ix` (`userevidenceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Relationship between user evidence and competencies';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_userevidencecomp`
--

LOCK TABLES `mdl_competency_userevidencecomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_userevidencecomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_userevidencecomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_config`
--

DROP TABLE IF EXISTS `mdl_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_conf_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=505 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Moodle configuration variables';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_config`
--

LOCK TABLES `mdl_config` WRITE;
/*!40000 ALTER TABLE `mdl_config` DISABLE KEYS */;
INSERT INTO `mdl_config` VALUES (2,'rolesactive','1'),(3,'auth','email'),(4,'enrol_plugins_enabled','manual,guest,self,cohort,paypal'),(5,'theme','adaptable'),(6,'filter_multilang_converted','1'),(7,'siteidentifier','pZWUNEsDdfnRyiH4ADjwgoGARkyUvzzRlocalhost'),(8,'backup_version','2008111700'),(9,'backup_release','2.0 dev'),(10,'mnet_dispatcher_mode','off'),(11,'sessiontimeout','7200'),(12,'stringfilters',''),(13,'filterall','0'),(14,'texteditors','atto,tinymce,textarea'),(15,'antiviruses',''),(16,'media_plugins_sortorder','videojs,youtube,swf'),(17,'upgrade_extracreditweightsstepignored','1'),(18,'upgrade_calculatedgradeitemsignored','1'),(19,'upgrade_letterboundarycourses','1'),(20,'mnet_localhost_id','1'),(21,'mnet_all_hosts_id','2'),(22,'siteguest','1'),(23,'siteadmins','2'),(24,'themerev','1551238789'),(25,'jsrev','1551237298'),(26,'gdversion','2'),(27,'licenses','unknown,allrightsreserved,public,cc,cc-nd,cc-nc-nd,cc-nc,cc-nc-sa,cc-sa'),(28,'version','2018120301.05'),(29,'enableoutcomes','0'),(30,'usecomments','1'),(31,'usetags','1'),(32,'enablenotes','1'),(33,'enableportfolios','0'),(34,'enablewebservices','0'),(35,'messaging','1'),(36,'messagingallusers','0'),(37,'messagingdeletereadnotificationsdelay','604800'),(38,'messagingallowemailoverride','0'),(39,'enablestats','0'),(40,'enablerssfeeds','0'),(41,'enableblogs','1'),(42,'enablecompletion','1'),(43,'completiondefault','1'),(44,'enableavailability','1'),(45,'enableplagiarism','0'),(46,'enablebadges','1'),(47,'enableglobalsearch','0'),(48,'allowstealth','0'),(49,'defaultpreference_maildisplay','2'),(50,'defaultpreference_mailformat','1'),(51,'defaultpreference_maildigest','0'),(52,'defaultpreference_autosubscribe','1'),(53,'defaultpreference_trackforums','0'),(54,'autologinguests','0'),(55,'hiddenuserfields',''),(56,'showuseridentity','email'),(57,'fullnamedisplay','language'),(58,'alternativefullnameformat','language'),(59,'maxusersperpage','100'),(60,'enablegravatar','0'),(61,'gravatardefaulturl','mm'),(62,'agedigitalconsentverification','0'),(63,'agedigitalconsentmap','*, 16\nAT, 14\nES, 14\nUS, 13'),(64,'sitepolicy',''),(65,'sitepolicyguest',''),(66,'enablecourserequests','0'),(67,'defaultrequestcategory','1'),(68,'requestcategoryselection','0'),(69,'courserequestnotify',''),(70,'grade_profilereport','user'),(71,'grade_aggregationposition','1'),(72,'grade_includescalesinaggregation','1'),(73,'grade_hiddenasdate','0'),(74,'gradepublishing','0'),(75,'grade_export_exportfeedback','0'),(76,'grade_export_displaytype','1'),(77,'grade_export_decimalpoints','2'),(78,'grade_navmethod','1'),(79,'grade_export_userprofilefields','firstname,lastname,idnumber,institution,department,email'),(80,'grade_export_customprofilefields',''),(81,'recovergradesdefault','0'),(82,'gradeexport',''),(83,'unlimitedgrades','0'),(84,'grade_report_showmin','1'),(85,'gradepointmax','100'),(86,'gradepointdefault','100'),(87,'grade_minmaxtouse','1'),(88,'grade_mygrades_report','overview'),(89,'gradereport_mygradeurl',''),(90,'grade_hideforcedsettings','1'),(91,'grade_aggregation','13'),(92,'grade_aggregation_flag','0'),(93,'grade_aggregations_visible','13'),(94,'grade_aggregateonlygraded','1'),(95,'grade_aggregateonlygraded_flag','2'),(96,'grade_aggregateoutcomes','0'),(97,'grade_aggregateoutcomes_flag','2'),(98,'grade_keephigh','0'),(99,'grade_keephigh_flag','3'),(100,'grade_droplow','0'),(101,'grade_droplow_flag','2'),(102,'grade_overridecat','1'),(103,'grade_displaytype','1'),(104,'grade_decimalpoints','2'),(105,'grade_item_advanced','iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime'),(106,'grade_report_studentsperpage','100'),(107,'grade_report_showonlyactiveenrol','1'),(108,'grade_report_quickgrading','1'),(109,'grade_report_showquickfeedback','0'),(110,'grade_report_meanselection','1'),(111,'grade_report_enableajax','0'),(112,'grade_report_showcalculations','1'),(113,'grade_report_showeyecons','0'),(114,'grade_report_showaverages','1'),(115,'grade_report_showlocks','0'),(116,'grade_report_showranges','0'),(117,'grade_report_showanalysisicon','1'),(118,'grade_report_showuserimage','1'),(119,'grade_report_showactivityicons','1'),(120,'grade_report_shownumberofgrades','0'),(121,'grade_report_averagesdisplaytype','inherit'),(122,'grade_report_rangesdisplaytype','inherit'),(123,'grade_report_averagesdecimalpoints','inherit'),(124,'grade_report_rangesdecimalpoints','inherit'),(125,'grade_report_historyperpage','50'),(126,'grade_report_overview_showrank','0'),(127,'grade_report_overview_showtotalsifcontainhidden','0'),(128,'grade_report_user_showrank','0'),(129,'grade_report_user_showpercentage','1'),(130,'grade_report_user_showgrade','1'),(131,'grade_report_user_showfeedback','1'),(132,'grade_report_user_showrange','1'),(133,'grade_report_user_showweight','1'),(134,'grade_report_user_showaverage','0'),(135,'grade_report_user_showlettergrade','0'),(136,'grade_report_user_rangedecimals','0'),(137,'grade_report_user_showhiddenitems','1'),(138,'grade_report_user_showtotalsifcontainhidden','0'),(139,'grade_report_user_showcontributiontocoursetotal','1'),(140,'badges_defaultissuername',''),(141,'badges_defaultissuercontact',''),(142,'badges_badgesalt','badges1547809378'),(143,'badges_allowexternalbackpack','1'),(144,'badges_allowcoursebadges','1'),(146,'forcetimezone','99'),(147,'country','0'),(148,'defaultcity',''),(149,'geoip2file','/var/www/moodledata/geoip/GeoLite2-City.mmdb'),(150,'googlemapkey3',''),(151,'allcountrycodes',''),(152,'autolang','1'),(153,'lang','id'),(154,'langmenu','1'),(155,'langlist',''),(156,'langrev','1551237298'),(157,'langcache','1'),(158,'langstringcache','1'),(159,'locale',''),(160,'latinexcelexport','0'),(161,'sitedefaultlicense','allrightsreserved'),(162,'media_default_width','400'),(163,'media_default_height','300'),(164,'requiremodintro','0'),(166,'authloginviaemail','0'),(167,'allowaccountssameemail','0'),(168,'authpreventaccountcreation','0'),(169,'loginpageautofocus','0'),(170,'guestloginbutton','1'),(171,'limitconcurrentlogins','0'),(172,'alternateloginurl',''),(173,'forgottenpasswordurl',''),(174,'auth_instructions',''),(175,'allowemailaddresses',''),(176,'denyemailaddresses',''),(177,'verifychangedemail','1'),(178,'recaptchapublickey',''),(179,'recaptchaprivatekey',''),(180,'filteruploadedfiles','0'),(181,'filtermatchoneperpage','0'),(182,'filtermatchonepertext','0'),(183,'portfolio_moderate_filesize_threshold','1048576'),(184,'portfolio_high_filesize_threshold','5242880'),(185,'portfolio_moderate_db_threshold','20'),(186,'portfolio_high_db_threshold','50'),(187,'repositorycacheexpire','120'),(188,'repositorygetfiletimeout','30'),(189,'repositorysyncfiletimeout','1'),(190,'repositorysyncimagetimeout','3'),(191,'repositoryallowexternallinks','1'),(192,'legacyfilesinnewcourses','0'),(193,'legacyfilesaddallowed','1'),(194,'searchengine','simpledb'),(195,'searchindexwhendisabled','0'),(196,'searchindextime','600'),(197,'searchallavailablecourses','0'),(198,'enablewsdocumentation','0'),(199,'allowbeforeblock','0'),(200,'allowedip',''),(201,'blockedip',''),(202,'protectusernames','1'),(203,'forcelogin','0'),(204,'forceloginforprofiles','1'),(205,'forceloginforprofileimage','0'),(206,'opentogoogle','0'),(207,'allowindexing','0'),(208,'maxbytes','0'),(209,'userquota','104857600'),(210,'allowobjectembed','0'),(211,'enabletrusttext','0'),(212,'maxeditingtime','1800'),(213,'extendedusernamechars','0'),(214,'keeptagnamecase','1'),(215,'profilesforenrolledusersonly','1'),(216,'cronclionly','1'),(217,'cronremotepassword',''),(218,'lockoutthreshold','0'),(219,'lockoutwindow','1800'),(220,'lockoutduration','1800'),(221,'passwordpolicy','1'),(222,'minpasswordlength','8'),(223,'minpassworddigits','1'),(224,'minpasswordlower','1'),(225,'minpasswordupper','1'),(226,'minpasswordnonalphanum','1'),(227,'maxconsecutiveidentchars','0'),(228,'passwordreuselimit','0'),(229,'pwresettime','1800'),(230,'passwordchangelogout','0'),(231,'passwordchangetokendeletion','0'),(232,'tokenduration','7257600'),(233,'groupenrolmentkeypolicy','1'),(234,'disableuserimages','0'),(235,'emailchangeconfirmation','1'),(236,'rememberusername','2'),(237,'strictformsrequired','0'),(238,'cookiesecure','1'),(239,'cookiehttponly','0'),(240,'allowframembedding','0'),(241,'curlsecurityblockedhosts',''),(242,'curlsecurityallowedport',''),(243,'displayloginfailures','0'),(244,'notifyloginfailures',''),(245,'notifyloginthreshold','10'),(246,'themelist',''),(247,'themedesignermode','0'),(248,'allowuserthemes','0'),(249,'allowcoursethemes','0'),(250,'allowcategorythemes','0'),(251,'allowcohortthemes','0'),(252,'allowthemechangeonurl','0'),(253,'allowuserblockhiding','1'),(254,'allowblockstodock','1'),(255,'custommenuitems',''),(256,'customusermenuitems','grades,grades|/grade/report/mygrades.php|t/grades\r\nmessages,message|/message/index.php|t/message\r\npreferences,moodle|/user/preferences.php|t/preferences'),(257,'enabledevicedetection','1'),(258,'devicedetectregex','[]'),(259,'calendartype','gregorian'),(260,'calendar_adminseesall','0'),(261,'calendar_site_timeformat','0'),(262,'calendar_startwday','0'),(263,'calendar_weekend','65'),(264,'calendar_lookahead','21'),(265,'calendar_maxevents','10'),(266,'enablecalendarexport','1'),(267,'calendar_customexport','1'),(268,'calendar_exportlookahead','365'),(269,'calendar_exportlookback','5'),(270,'calendar_exportsalt','uzVbum6EPlmBIN7gaF3l4wJ9tpqqAKbwFe7UDWaNioN7HZKza6v9GKjIg7Xl'),(271,'calendar_showicalsource','1'),(272,'useblogassociations','1'),(273,'bloglevel','4'),(274,'useexternalblogs','1'),(275,'externalblogcrontime','86400'),(276,'maxexternalblogsperuser','1'),(277,'blogusecomments','1'),(278,'blogshowcommentscount','1'),(279,'defaulthomepage','1'),(280,'allowguestmymoodle','1'),(281,'navshowfullcoursenames','0'),(282,'navshowcategories','1'),(283,'navshowmycoursecategories','0'),(284,'navshowallcourses','0'),(285,'navsortmycoursessort','sortorder'),(286,'navcourselimit','10'),(287,'usesitenameforsitepages','0'),(288,'linkadmincategories','1'),(289,'linkcoursesections','1'),(290,'navshowfrontpagemods','1'),(291,'navadduserpostslinks','1'),(292,'formatstringstriptags','1'),(293,'emoticons','[{\"text\":\":-)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":-D\",\"imagename\":\"s\\/biggrin\",\"imagecomponent\":\"core\",\"altidentifier\":\"biggrin\",\"altcomponent\":\"core_pix\"},{\"text\":\";-)\",\"imagename\":\"s\\/wink\",\"imagecomponent\":\"core\",\"altidentifier\":\"wink\",\"altcomponent\":\"core_pix\"},{\"text\":\":-\\/\",\"imagename\":\"s\\/mixed\",\"imagecomponent\":\"core\",\"altidentifier\":\"mixed\",\"altcomponent\":\"core_pix\"},{\"text\":\"V-.\",\"imagename\":\"s\\/thoughtful\",\"imagecomponent\":\"core\",\"altidentifier\":\"thoughtful\",\"altcomponent\":\"core_pix\"},{\"text\":\":-P\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\":-p\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\"B-)\",\"imagename\":\"s\\/cool\",\"imagecomponent\":\"core\",\"altidentifier\":\"cool\",\"altcomponent\":\"core_pix\"},{\"text\":\"^-)\",\"imagename\":\"s\\/approve\",\"imagecomponent\":\"core\",\"altidentifier\":\"approve\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-)\",\"imagename\":\"s\\/wideeyes\",\"imagecomponent\":\"core\",\"altidentifier\":\"wideeyes\",\"altcomponent\":\"core_pix\"},{\"text\":\":o)\",\"imagename\":\"s\\/clown\",\"imagecomponent\":\"core\",\"altidentifier\":\"clown\",\"altcomponent\":\"core_pix\"},{\"text\":\":-(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\":(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-.\",\"imagename\":\"s\\/shy\",\"imagecomponent\":\"core\",\"altidentifier\":\"shy\",\"altcomponent\":\"core_pix\"},{\"text\":\":-I\",\"imagename\":\"s\\/blush\",\"imagecomponent\":\"core\",\"altidentifier\":\"blush\",\"altcomponent\":\"core_pix\"},{\"text\":\":-X\",\"imagename\":\"s\\/kiss\",\"imagecomponent\":\"core\",\"altidentifier\":\"kiss\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-o\",\"imagename\":\"s\\/surprise\",\"imagecomponent\":\"core\",\"altidentifier\":\"surprise\",\"altcomponent\":\"core_pix\"},{\"text\":\"P-|\",\"imagename\":\"s\\/blackeye\",\"imagecomponent\":\"core\",\"altidentifier\":\"blackeye\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-[\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"(grr)\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"xx-P\",\"imagename\":\"s\\/dead\",\"imagecomponent\":\"core\",\"altidentifier\":\"dead\",\"altcomponent\":\"core_pix\"},{\"text\":\"|-.\",\"imagename\":\"s\\/sleepy\",\"imagecomponent\":\"core\",\"altidentifier\":\"sleepy\",\"altcomponent\":\"core_pix\"},{\"text\":\"}-]\",\"imagename\":\"s\\/evil\",\"imagecomponent\":\"core\",\"altidentifier\":\"evil\",\"altcomponent\":\"core_pix\"},{\"text\":\"(h)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(heart)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(y)\",\"imagename\":\"s\\/yes\",\"imagecomponent\":\"core\",\"altidentifier\":\"yes\",\"altcomponent\":\"core\"},{\"text\":\"(n)\",\"imagename\":\"s\\/no\",\"imagecomponent\":\"core\",\"altidentifier\":\"no\",\"altcomponent\":\"core\"},{\"text\":\"(martin)\",\"imagename\":\"s\\/martin\",\"imagecomponent\":\"core\",\"altidentifier\":\"martin\",\"altcomponent\":\"core_pix\"},{\"text\":\"( )\",\"imagename\":\"s\\/egg\",\"imagecomponent\":\"core\",\"altidentifier\":\"egg\",\"altcomponent\":\"core_pix\"}]'),(294,'docroot','https://docs.moodle.org'),(295,'doclang',''),(296,'doctonewwindow','0'),(297,'coursecontactduplicates','0'),(298,'courselistshortnames','0'),(299,'coursesperpage','20'),(300,'courseswithsummarieslimit','10'),(301,'courseoverviewfileslimit','1'),(302,'courseoverviewfilesext','.jpg,.gif,.png'),(303,'coursegraceperiodbefore','0'),(304,'coursegraceperiodafter','0'),(305,'useexternalyui','0'),(306,'yuicomboloading','1'),(307,'cachejs','1'),(308,'modchooserdefault','1'),(309,'additionalhtmlhead',''),(310,'additionalhtmltopofbody',''),(311,'additionalhtmlfooter',''),(312,'pathtophp',''),(313,'pathtodu',''),(314,'aspellpath',''),(315,'pathtodot',''),(316,'pathtogs','/usr/bin/gs'),(317,'pathtopython',''),(318,'supportname','Admin Pengguna'),(319,'supportemail',''),(320,'supportpage',''),(321,'dbsessions','0'),(322,'sessioncookie',''),(323,'sessioncookiepath',''),(324,'sessioncookiedomain',''),(325,'statsfirstrun','none'),(326,'statsmaxruntime','0'),(327,'statsruntimedays','31'),(328,'statsuserthreshold','0'),(329,'slasharguments','1'),(330,'getremoteaddrconf','0'),(331,'proxyhost',''),(332,'proxyport','0'),(333,'proxytype','HTTP'),(334,'proxyuser',''),(335,'proxypassword',''),(336,'proxybypass','localhost, 127.0.0.1'),(337,'maintenance_enabled','1'),(338,'maintenance_message',''),(339,'deleteunconfirmed','168'),(340,'deleteincompleteusers','0'),(341,'disablegradehistory','0'),(342,'gradehistorylifetime','0'),(343,'tempdatafoldercleanup','168'),(344,'extramemorylimit','512M'),(345,'maxtimelimit','0'),(346,'curlcache','120'),(347,'curltimeoutkbitrate','56'),(348,'smtphosts',''),(349,'smtpsecure',''),(350,'smtpauthtype','LOGIN'),(351,'smtpuser',''),(352,'smtppass',''),(353,'smtpmaxbulk','1'),(354,'allowedemaildomains',''),(355,'sitemailcharset','0'),(356,'allowusermailcharset','0'),(357,'allowattachments','1'),(358,'mailnewline','LF'),(359,'emailfromvia','1'),(360,'updateautocheck','1'),(361,'updateminmaturity','200'),(362,'updatenotifybuilds','0'),(363,'enablesafebrowserintegration','0'),(364,'dndallowtextandlinks','0'),(365,'pathtosassc',''),(366,'contextlocking','0'),(367,'contextlockappliestoadmin','1'),(368,'forceclean','0'),(369,'debug','0'),(370,'debugdisplay','0'),(371,'debugsmtp','0'),(372,'perfdebug','7'),(373,'debugstringids','0'),(374,'debugvalidators','0'),(375,'debugpageinfo','0'),(376,'profilingenabled','0'),(377,'profilingincluded',''),(378,'profilingexcluded',''),(379,'profilingautofrec','0'),(380,'profilingallowme','0'),(381,'profilingallowall','0'),(382,'profilinglifetime','1440'),(383,'profilingimportprefix','(I)'),(384,'release','3.6.1+ (Build: 20181220)'),(385,'branch','36'),(386,'localcachedirpurged','1551237298'),(387,'scheduledtaskreset','1551237298'),(388,'allversionshash','566a9073d7459e9c8ebd08849c889b43ce3773bf'),(390,'registrationpending','0'),(391,'notloggedinroleid','6'),(392,'guestroleid','6'),(393,'defaultuserroleid','7'),(394,'creatornewroleid','3'),(395,'restorernewroleid','3'),(396,'sitepolicyhandler',''),(397,'gradebookroles','5'),(398,'block_html_allowcssclasses','0'),(399,'block_course_list_adminview','all'),(400,'block_course_list_hideallcourseslink','0'),(401,'block_online_users_timetosee','5'),(402,'block_rss_client_num_entries','5'),(403,'block_rss_client_timeout','30'),(404,'pathtounoconv','/usr/bin/unoconv'),(405,'jabberhost',''),(406,'jabberserver',''),(407,'jabberusername',''),(408,'jabberpassword',''),(409,'jabberport','5222'),(410,'airnotifierurl','https://messages.moodle.net'),(411,'airnotifierport','443'),(412,'airnotifiermobileappname','com.moodle.moodlemobile'),(413,'airnotifierappname','commoodlemoodlemobile'),(414,'airnotifieraccesskey',''),(415,'logguests','1'),(416,'loglifetime','0'),(417,'data_enablerssfeeds','0'),(418,'feedback_allowfullanonymous','0'),(419,'forum_displaymode','3'),(420,'forum_shortpost','300'),(421,'forum_longpost','600'),(422,'forum_manydiscussions','100'),(423,'forum_maxbytes','512000'),(424,'forum_maxattachments','9'),(425,'forum_subscription','0'),(426,'forum_trackingtype','1'),(427,'forum_trackreadposts','1'),(428,'forum_allowforcedreadtracking','0'),(429,'forum_oldpostdays','14'),(430,'forum_usermarksread','0'),(431,'forum_cleanreadtime','2'),(432,'digestmailtime','17'),(433,'forum_enablerssfeeds','0'),(434,'forum_enabletimedposts','1'),(435,'glossary_entbypage','10'),(436,'glossary_dupentries','0'),(437,'glossary_allowcomments','0'),(438,'glossary_linkbydefault','1'),(439,'glossary_defaultapproval','1'),(440,'glossary_enablerssfeeds','0'),(441,'glossary_linkentries','0'),(442,'glossary_casesensitive','0'),(443,'glossary_fullmatch','0'),(444,'chat_method','ajax'),(445,'chat_refresh_userlist','10'),(446,'chat_old_ping','35'),(447,'chat_refresh_room','5'),(448,'chat_normal_updatemode','jsupdate'),(449,'chat_serverhost','localhost'),(450,'chat_serverip','127.0.0.1'),(451,'chat_serverport','9111'),(452,'chat_servermax','100'),(453,'filter_multilang_force_old','0'),(454,'filter_censor_badwords',''),(455,'profileroles','5,4,3'),(456,'coursecontact','3'),(457,'frontpage','6'),(458,'frontpageloggedin','6'),(459,'maxcategorydepth','2'),(460,'frontpagecourselimit','200'),(461,'commentsperpage','15'),(462,'defaultfrontpageroleid','8'),(463,'messageinbound_enabled','0'),(464,'messageinbound_mailbox',''),(465,'messageinbound_domain',''),(466,'messageinbound_host',''),(467,'messageinbound_hostssl','ssl'),(468,'messageinbound_hostuser',''),(469,'messageinbound_hostpass',''),(470,'enablemobilewebservice','0'),(471,'timezone','Asia/Jakarta'),(472,'registerauth',''),(473,'noreplyaddress','hr-assessment@halinda.com'),(475,'bigbluebuttonbn_server_url','http://test-install.blindsidenetworks.com/bigbluebutton/'),(476,'bigbluebuttonbn_shared_secret','8cd8ef52e8e101574e400365b55e11a6'),(477,'bigbluebuttonbn_recording_default','1'),(478,'bigbluebuttonbn_recording_editable','1'),(479,'bigbluebuttonbn_recording_icons_enabled','1'),(480,'bigbluebuttonbn_importrecordings_enabled','0'),(481,'bigbluebuttonbn_importrecordings_from_deleted_enabled','0'),(482,'bigbluebuttonbn_recordings_html_default','1'),(483,'bigbluebuttonbn_recordings_html_editable','0'),(484,'bigbluebuttonbn_recordings_deleted_default','1'),(485,'bigbluebuttonbn_recordings_deleted_editable','0'),(486,'bigbluebuttonbn_recordings_imported_default','0'),(487,'bigbluebuttonbn_recordings_imported_editable','1'),(488,'bigbluebuttonbn_recordings_preview_default','1'),(489,'bigbluebuttonbn_recordings_preview_editable','0'),(490,'bigbluebuttonbn_waitformoderator_default','0'),(491,'bigbluebuttonbn_waitformoderator_editable','1'),(492,'bigbluebuttonbn_waitformoderator_ping_interval','10'),(493,'bigbluebuttonbn_waitformoderator_cache_ttl','60'),(494,'bigbluebuttonbn_voicebridge_editable','0'),(495,'bigbluebuttonbn_preuploadpresentation_enabled','0'),(496,'bigbluebuttonbn_userlimit_default','0'),(497,'bigbluebuttonbn_userlimit_editable','0'),(498,'bigbluebuttonbn_participant_moderator_default','0'),(499,'bigbluebuttonbn_sendnotifications_enabled','1'),(500,'bigbluebuttonbn_recordingready_enabled','0'),(501,'bigbluebuttonbn_meetingevents_enabled','0'),(503,'theme_adaptable_putprops','');
/*!40000 ALTER TABLE `mdl_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_config_log`
--

DROP TABLE IF EXISTS `mdl_config_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_config_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `plugin` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci,
  `oldvalue` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_conflog_tim_ix` (`timemodified`),
  KEY `mdl_conflog_use_ix` (`userid`)
) ENGINE=InnoDB AUTO_INCREMENT=1913 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Changes done in server configuration through admin UI';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_config_log`
--

LOCK TABLES `mdl_config_log` WRITE;
/*!40000 ALTER TABLE `mdl_config_log` DISABLE KEYS */;
INSERT INTO `mdl_config_log` VALUES (1,0,1547809443,NULL,'enableoutcomes','0',NULL),(2,0,1547809444,NULL,'usecomments','1',NULL),(3,0,1547809445,NULL,'usetags','1',NULL),(4,0,1547809445,NULL,'enablenotes','1',NULL),(5,0,1547809445,NULL,'enableportfolios','0',NULL),(6,0,1547809445,NULL,'enablewebservices','0',NULL),(7,0,1547809445,NULL,'messaging','1',NULL),(8,0,1547809445,NULL,'messagingallusers','0',NULL),(9,0,1547809445,NULL,'messagingdeletereadnotificationsdelay','604800',NULL),(10,0,1547809445,NULL,'messagingallowemailoverride','0',NULL),(11,0,1547809446,NULL,'enablestats','0',NULL),(12,0,1547809446,NULL,'enablerssfeeds','0',NULL),(13,0,1547809446,NULL,'enableblogs','1',NULL),(14,0,1547809446,NULL,'enablecompletion','1',NULL),(15,0,1547809446,NULL,'completiondefault','1',NULL),(16,0,1547809446,NULL,'enableavailability','1',NULL),(17,0,1547809446,NULL,'enableplagiarism','0',NULL),(18,0,1547809446,NULL,'enablebadges','1',NULL),(19,0,1547809446,NULL,'enableglobalsearch','0',NULL),(20,0,1547809446,NULL,'allowstealth','0',NULL),(21,0,1547809446,NULL,'defaultpreference_maildisplay','2',NULL),(22,0,1547809446,NULL,'defaultpreference_mailformat','1',NULL),(23,0,1547809447,NULL,'defaultpreference_maildigest','0',NULL),(24,0,1547809447,NULL,'defaultpreference_autosubscribe','1',NULL),(25,0,1547809447,NULL,'defaultpreference_trackforums','0',NULL),(26,0,1547809447,NULL,'autologinguests','0',NULL),(27,0,1547809447,NULL,'hiddenuserfields','',NULL),(28,0,1547809447,NULL,'showuseridentity','email',NULL),(29,0,1547809447,NULL,'fullnamedisplay','language',NULL),(30,0,1547809447,NULL,'alternativefullnameformat','language',NULL),(31,0,1547809447,NULL,'maxusersperpage','100',NULL),(32,0,1547809447,NULL,'enablegravatar','0',NULL),(33,0,1547809447,NULL,'gravatardefaulturl','mm',NULL),(34,0,1547809447,NULL,'agedigitalconsentverification','0',NULL),(35,0,1547809448,NULL,'agedigitalconsentmap','*, 16\nAT, 14\nES, 14\nUS, 13',NULL),(36,0,1547809448,NULL,'sitepolicy','',NULL),(37,0,1547809448,NULL,'sitepolicyguest','',NULL),(38,0,1547809448,'moodlecourse','visible','1',NULL),(39,0,1547809448,'moodlecourse','format','topics',NULL),(40,0,1547809448,'moodlecourse','maxsections','52',NULL),(41,0,1547809448,'moodlecourse','numsections','4',NULL),(42,0,1547809448,'moodlecourse','hiddensections','0',NULL),(43,0,1547809448,'moodlecourse','coursedisplay','0',NULL),(44,0,1547809448,'moodlecourse','courseenddateenabled','1',NULL),(45,0,1547809448,'moodlecourse','courseduration','31536000',NULL),(46,0,1547809448,'moodlecourse','lang','',NULL),(47,0,1547809449,'moodlecourse','newsitems','5',NULL),(48,0,1547809449,'moodlecourse','showgrades','1',NULL),(49,0,1547809449,'moodlecourse','showreports','0',NULL),(50,0,1547809449,'moodlecourse','maxbytes','0',NULL),(51,0,1547809449,'moodlecourse','enablecompletion','1',NULL),(52,0,1547809449,'moodlecourse','groupmode','0',NULL),(53,0,1547809449,'moodlecourse','groupmodeforce','0',NULL),(54,0,1547809449,NULL,'enablecourserequests','0',NULL),(55,0,1547809449,NULL,'defaultrequestcategory','1',NULL),(56,0,1547809449,NULL,'requestcategoryselection','0',NULL),(57,0,1547809449,NULL,'courserequestnotify','',NULL),(58,0,1547809450,'backup','loglifetime','30',NULL),(59,0,1547809450,'backup','backup_general_users','1',NULL),(60,0,1547809450,'backup','backup_general_users_locked','',NULL),(61,0,1547809450,'backup','backup_general_anonymize','0',NULL),(62,0,1547809450,'backup','backup_general_anonymize_locked','',NULL),(63,0,1547809450,'backup','backup_general_role_assignments','1',NULL),(64,0,1547809450,'backup','backup_general_role_assignments_locked','',NULL),(65,0,1547809450,'backup','backup_general_activities','1',NULL),(66,0,1547809450,'backup','backup_general_activities_locked','',NULL),(67,0,1547809450,'backup','backup_general_blocks','1',NULL),(68,0,1547809450,'backup','backup_general_blocks_locked','',NULL),(69,0,1547809450,'backup','backup_general_filters','1',NULL),(70,0,1547809450,'backup','backup_general_filters_locked','',NULL),(71,0,1547809450,'backup','backup_general_comments','1',NULL),(72,0,1547809450,'backup','backup_general_comments_locked','',NULL),(73,0,1547809451,'backup','backup_general_badges','1',NULL),(74,0,1547809451,'backup','backup_general_badges_locked','',NULL),(75,0,1547809451,'backup','backup_general_calendarevents','1',NULL),(76,0,1547809451,'backup','backup_general_calendarevents_locked','',NULL),(77,0,1547809451,'backup','backup_general_userscompletion','1',NULL),(78,0,1547809451,'backup','backup_general_userscompletion_locked','',NULL),(79,0,1547809451,'backup','backup_general_logs','0',NULL),(80,0,1547809451,'backup','backup_general_logs_locked','',NULL),(81,0,1547809451,'backup','backup_general_histories','0',NULL),(82,0,1547809451,'backup','backup_general_histories_locked','',NULL),(83,0,1547809451,'backup','backup_general_questionbank','1',NULL),(84,0,1547809452,'backup','backup_general_questionbank_locked','',NULL),(85,0,1547809452,'backup','backup_general_groups','1',NULL),(86,0,1547809452,'backup','backup_general_groups_locked','',NULL),(87,0,1547809452,'backup','backup_general_competencies','1',NULL),(88,0,1547809452,'backup','backup_general_competencies_locked','',NULL),(89,0,1547809452,'backup','import_general_maxresults','10',NULL),(90,0,1547809452,'backup','import_general_duplicate_admin_allowed','0',NULL),(91,0,1547809452,'backup','backup_import_activities','1',NULL),(92,0,1547809452,'backup','backup_import_activities_locked','',NULL),(93,0,1547809452,'backup','backup_import_blocks','1',NULL),(94,0,1547809452,'backup','backup_import_blocks_locked','',NULL),(95,0,1547809453,'backup','backup_import_filters','1',NULL),(96,0,1547809453,'backup','backup_import_filters_locked','',NULL),(97,0,1547809453,'backup','backup_import_calendarevents','1',NULL),(98,0,1547809453,'backup','backup_import_calendarevents_locked','',NULL),(99,0,1547809453,'backup','backup_import_questionbank','1',NULL),(100,0,1547809453,'backup','backup_import_questionbank_locked','',NULL),(101,0,1547809453,'backup','backup_import_groups','1',NULL),(102,0,1547809453,'backup','backup_import_groups_locked','',NULL),(103,0,1547809453,'backup','backup_import_competencies','1',NULL),(104,0,1547809453,'backup','backup_import_competencies_locked','',NULL),(105,0,1547809453,'backup','backup_auto_active','0',NULL),(106,0,1547809453,'backup','backup_auto_weekdays','0000000',NULL),(107,0,1547809453,'backup','backup_auto_hour','0',NULL),(108,0,1547809453,'backup','backup_auto_minute','0',NULL),(109,0,1547809454,'backup','backup_auto_storage','0',NULL),(110,0,1547809454,'backup','backup_auto_destination','',NULL),(111,0,1547809454,'backup','backup_auto_max_kept','1',NULL),(112,0,1547809454,'backup','backup_auto_delete_days','0',NULL),(113,0,1547809454,'backup','backup_auto_min_kept','0',NULL),(114,0,1547809454,'backup','backup_shortname','0',NULL),(115,0,1547809454,'backup','backup_auto_skip_hidden','1',NULL),(116,0,1547809454,'backup','backup_auto_skip_modif_days','30',NULL),(117,0,1547809454,'backup','backup_auto_skip_modif_prev','0',NULL),(118,0,1547809454,'backup','backup_auto_users','1',NULL),(119,0,1547809454,'backup','backup_auto_role_assignments','1',NULL),(120,0,1547809454,'backup','backup_auto_activities','1',NULL),(121,0,1547809455,'backup','backup_auto_blocks','1',NULL),(122,0,1547809455,'backup','backup_auto_filters','1',NULL),(123,0,1547809455,'backup','backup_auto_comments','1',NULL),(124,0,1547809455,'backup','backup_auto_badges','1',NULL),(125,0,1547809455,'backup','backup_auto_calendarevents','1',NULL),(126,0,1547809455,'backup','backup_auto_userscompletion','1',NULL),(127,0,1547809455,'backup','backup_auto_logs','0',NULL),(128,0,1547809455,'backup','backup_auto_histories','0',NULL),(129,0,1547809455,'backup','backup_auto_questionbank','1',NULL),(130,0,1547809455,'backup','backup_auto_groups','1',NULL),(131,0,1547809456,'backup','backup_auto_competencies','1',NULL),(132,0,1547809456,'restore','restore_general_users','1',NULL),(133,0,1547809456,'restore','restore_general_users_locked','',NULL),(134,0,1547809456,'restore','restore_general_enrolments','1',NULL),(135,0,1547809456,'restore','restore_general_enrolments_locked','',NULL),(136,0,1547809456,'restore','restore_general_role_assignments','1',NULL),(137,0,1547809456,'restore','restore_general_role_assignments_locked','',NULL),(138,0,1547809456,'restore','restore_general_activities','1',NULL),(139,0,1547809456,'restore','restore_general_activities_locked','',NULL),(140,0,1547809456,'restore','restore_general_blocks','1',NULL),(141,0,1547809456,'restore','restore_general_blocks_locked','',NULL),(142,0,1547809457,'restore','restore_general_filters','1',NULL),(143,0,1547809457,'restore','restore_general_filters_locked','',NULL),(144,0,1547809457,'restore','restore_general_comments','1',NULL),(145,0,1547809457,'restore','restore_general_comments_locked','',NULL),(146,0,1547809457,'restore','restore_general_badges','1',NULL),(147,0,1547809457,'restore','restore_general_badges_locked','',NULL),(148,0,1547809457,'restore','restore_general_calendarevents','1',NULL),(149,0,1547809457,'restore','restore_general_calendarevents_locked','',NULL),(150,0,1547809457,'restore','restore_general_userscompletion','1',NULL),(151,0,1547809457,'restore','restore_general_userscompletion_locked','',NULL),(152,0,1547809457,'restore','restore_general_logs','1',NULL),(153,0,1547809457,'restore','restore_general_logs_locked','',NULL),(154,0,1547809457,'restore','restore_general_histories','1',NULL),(155,0,1547809457,'restore','restore_general_histories_locked','',NULL),(156,0,1547809458,'restore','restore_general_groups','1',NULL),(157,0,1547809458,'restore','restore_general_groups_locked','',NULL),(158,0,1547809458,'restore','restore_general_competencies','1',NULL),(159,0,1547809458,'restore','restore_general_competencies_locked','',NULL),(160,0,1547809458,'restore','restore_merge_overwrite_conf','0',NULL),(161,0,1547809458,'restore','restore_merge_overwrite_conf_locked','',NULL),(162,0,1547809458,'restore','restore_merge_course_fullname','1',NULL),(163,0,1547809458,'restore','restore_merge_course_fullname_locked','',NULL),(164,0,1547809458,'restore','restore_merge_course_shortname','1',NULL),(165,0,1547809458,'restore','restore_merge_course_shortname_locked','',NULL),(166,0,1547809458,'restore','restore_merge_course_startdate','1',NULL),(167,0,1547809458,'restore','restore_merge_course_startdate_locked','',NULL),(168,0,1547809459,'restore','restore_replace_overwrite_conf','0',NULL),(169,0,1547809459,'restore','restore_replace_overwrite_conf_locked','',NULL),(170,0,1547809459,'restore','restore_replace_course_fullname','1',NULL),(171,0,1547809459,'restore','restore_replace_course_fullname_locked','',NULL),(172,0,1547809459,'restore','restore_replace_course_shortname','1',NULL),(173,0,1547809459,'restore','restore_replace_course_shortname_locked','',NULL),(174,0,1547809459,'restore','restore_replace_course_startdate','1',NULL),(175,0,1547809459,'restore','restore_replace_course_startdate_locked','',NULL),(176,0,1547809459,'restore','restore_replace_keep_roles_and_enrolments','0',NULL),(177,0,1547809459,'restore','restore_replace_keep_roles_and_enrolments_locked','',NULL),(178,0,1547809460,'restore','restore_replace_keep_groups_and_groupings','0',NULL),(179,0,1547809460,'restore','restore_replace_keep_groups_and_groupings_locked','',NULL),(180,0,1547809460,NULL,'grade_profilereport','user',NULL),(181,0,1547809460,NULL,'grade_aggregationposition','1',NULL),(182,0,1547809460,NULL,'grade_includescalesinaggregation','1',NULL),(183,0,1547809460,NULL,'grade_hiddenasdate','0',NULL),(184,0,1547809460,NULL,'gradepublishing','0',NULL),(185,0,1547809460,NULL,'grade_export_exportfeedback','0',NULL),(186,0,1547809460,NULL,'grade_export_displaytype','1',NULL),(187,0,1547809460,NULL,'grade_export_decimalpoints','2',NULL),(188,0,1547809460,NULL,'grade_navmethod','1',NULL),(189,0,1547809460,NULL,'grade_export_userprofilefields','firstname,lastname,idnumber,institution,department,email',NULL),(190,0,1547809461,NULL,'grade_export_customprofilefields','',NULL),(191,0,1547809461,NULL,'recovergradesdefault','0',NULL),(192,0,1547809461,NULL,'gradeexport','',NULL),(193,0,1547809461,NULL,'unlimitedgrades','0',NULL),(194,0,1547809461,NULL,'grade_report_showmin','1',NULL),(195,0,1547809461,NULL,'gradepointmax','100',NULL),(196,0,1547809461,NULL,'gradepointdefault','100',NULL),(197,0,1547809461,NULL,'grade_minmaxtouse','1',NULL),(198,0,1547809461,NULL,'grade_mygrades_report','overview',NULL),(199,0,1547809462,NULL,'gradereport_mygradeurl','',NULL),(200,0,1547809462,NULL,'grade_hideforcedsettings','1',NULL),(201,0,1547809462,NULL,'grade_aggregation','13',NULL),(202,0,1547809462,NULL,'grade_aggregation_flag','0',NULL),(203,0,1547809462,NULL,'grade_aggregations_visible','13',NULL),(204,0,1547809462,NULL,'grade_aggregateonlygraded','1',NULL),(205,0,1547809462,NULL,'grade_aggregateonlygraded_flag','2',NULL),(206,0,1547809462,NULL,'grade_aggregateoutcomes','0',NULL),(207,0,1547809462,NULL,'grade_aggregateoutcomes_flag','2',NULL),(208,0,1547809462,NULL,'grade_keephigh','0',NULL),(209,0,1547809462,NULL,'grade_keephigh_flag','3',NULL),(210,0,1547809462,NULL,'grade_droplow','0',NULL),(211,0,1547809462,NULL,'grade_droplow_flag','2',NULL),(212,0,1547809463,NULL,'grade_overridecat','1',NULL),(213,0,1547809463,NULL,'grade_displaytype','1',NULL),(214,0,1547809463,NULL,'grade_decimalpoints','2',NULL),(215,0,1547809463,NULL,'grade_item_advanced','iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime',NULL),(216,0,1547809463,NULL,'grade_report_studentsperpage','100',NULL),(217,0,1547809463,NULL,'grade_report_showonlyactiveenrol','1',NULL),(218,0,1547809463,NULL,'grade_report_quickgrading','1',NULL),(219,0,1547809463,NULL,'grade_report_showquickfeedback','0',NULL),(220,0,1547809463,NULL,'grade_report_meanselection','1',NULL),(221,0,1547809463,NULL,'grade_report_enableajax','0',NULL),(222,0,1547809463,NULL,'grade_report_showcalculations','1',NULL),(223,0,1547809463,NULL,'grade_report_showeyecons','0',NULL),(224,0,1547809463,NULL,'grade_report_showaverages','1',NULL),(225,0,1547809464,NULL,'grade_report_showlocks','0',NULL),(226,0,1547809464,NULL,'grade_report_showranges','0',NULL),(227,0,1547809464,NULL,'grade_report_showanalysisicon','1',NULL),(228,0,1547809464,NULL,'grade_report_showuserimage','1',NULL),(229,0,1547809464,NULL,'grade_report_showactivityicons','1',NULL),(230,0,1547809464,NULL,'grade_report_shownumberofgrades','0',NULL),(231,0,1547809464,NULL,'grade_report_averagesdisplaytype','inherit',NULL),(232,0,1547809464,NULL,'grade_report_rangesdisplaytype','inherit',NULL),(233,0,1547809464,NULL,'grade_report_averagesdecimalpoints','inherit',NULL),(234,0,1547809464,NULL,'grade_report_rangesdecimalpoints','inherit',NULL),(235,0,1547809464,NULL,'grade_report_historyperpage','50',NULL),(236,0,1547809465,NULL,'grade_report_overview_showrank','0',NULL),(237,0,1547809465,NULL,'grade_report_overview_showtotalsifcontainhidden','0',NULL),(238,0,1547809465,NULL,'grade_report_user_showrank','0',NULL),(239,0,1547809465,NULL,'grade_report_user_showpercentage','1',NULL),(240,0,1547809465,NULL,'grade_report_user_showgrade','1',NULL),(241,0,1547809465,NULL,'grade_report_user_showfeedback','1',NULL),(242,0,1547809465,NULL,'grade_report_user_showrange','1',NULL),(243,0,1547809465,NULL,'grade_report_user_showweight','1',NULL),(244,0,1547809466,NULL,'grade_report_user_showaverage','0',NULL),(245,0,1547809466,NULL,'grade_report_user_showlettergrade','0',NULL),(246,0,1547809466,NULL,'grade_report_user_rangedecimals','0',NULL),(247,0,1547809466,NULL,'grade_report_user_showhiddenitems','1',NULL),(248,0,1547809466,NULL,'grade_report_user_showtotalsifcontainhidden','0',NULL),(249,0,1547809466,NULL,'grade_report_user_showcontributiontocoursetotal','1',NULL),(250,0,1547809466,'analytics','predictionsprocessor','\\mlbackend_php\\processor',NULL),(251,0,1547809466,'analytics','timesplittings','\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range',NULL),(252,0,1547809466,'analytics','modeloutputdir','/var/www/moodledata/models',NULL),(253,0,1547809466,'analytics','onlycli','1',NULL),(254,0,1547809467,'analytics','modeltimelimit','1200',NULL),(255,0,1547809467,'core_competency','enabled','1',NULL),(256,0,1547809467,'core_competency','pushcourseratingstouserplans','1',NULL),(257,0,1547809467,NULL,'badges_defaultissuername','',NULL),(258,0,1547809467,NULL,'badges_defaultissuercontact','',NULL),(259,0,1547809467,NULL,'badges_badgesalt','badges1547809378',NULL),(260,0,1547809467,NULL,'badges_allowexternalbackpack','1',NULL),(261,0,1547809468,NULL,'badges_allowcoursebadges','1',NULL),(262,0,1547809469,NULL,'timezone','Asia/Jakarta',NULL),(263,0,1547809471,NULL,'forcetimezone','99',NULL),(264,0,1547809471,NULL,'country','0',NULL),(265,0,1547809471,NULL,'defaultcity','',NULL),(266,0,1547809471,NULL,'geoip2file','/var/www/moodledata/geoip/GeoLite2-City.mmdb',NULL),(267,0,1547809471,NULL,'googlemapkey3','',NULL),(268,0,1547809471,NULL,'allcountrycodes','',NULL),(269,0,1547809471,NULL,'autolang','1',NULL),(270,0,1547809471,NULL,'lang','id',NULL),(271,0,1547809471,NULL,'langmenu','1',NULL),(272,0,1547809472,NULL,'langlist','',NULL),(273,0,1547809472,NULL,'langcache','1',NULL),(274,0,1547809472,NULL,'langstringcache','1',NULL),(275,0,1547809472,NULL,'locale','',NULL),(276,0,1547809472,NULL,'latinexcelexport','0',NULL),(277,0,1547809472,'cachestore_apcu','testperformance','0',NULL),(278,0,1547809472,'cachestore_memcached','testservers','',NULL),(279,0,1547809472,'cachestore_mongodb','testserver','',NULL),(280,0,1547809473,'cachestore_redis','test_server','',NULL),(281,0,1547809473,'cachestore_redis','test_password','',NULL),(282,0,1547809473,NULL,'sitedefaultlicense','allrightsreserved',NULL),(283,0,1547809473,NULL,'media_default_width','400',NULL),(284,0,1547809473,NULL,'media_default_height','300',NULL),(285,0,1547809473,NULL,'requiremodintro','0',NULL),(286,0,1547809473,NULL,'registerauth','',NULL),(287,0,1547809474,NULL,'authloginviaemail','0',NULL),(288,0,1547809474,NULL,'allowaccountssameemail','0',NULL),(289,0,1547809474,NULL,'authpreventaccountcreation','0',NULL),(290,0,1547809474,NULL,'loginpageautofocus','0',NULL),(291,0,1547809474,NULL,'guestloginbutton','1',NULL),(292,0,1547809474,NULL,'limitconcurrentlogins','0',NULL),(293,0,1547809474,NULL,'alternateloginurl','',NULL),(294,0,1547809474,NULL,'forgottenpasswordurl','',NULL),(295,0,1547809474,NULL,'auth_instructions','',NULL),(296,0,1547809474,NULL,'allowemailaddresses','',NULL),(297,0,1547809474,NULL,'denyemailaddresses','',NULL),(298,0,1547809474,NULL,'verifychangedemail','1',NULL),(299,0,1547809475,NULL,'recaptchapublickey','',NULL),(300,0,1547809475,NULL,'recaptchaprivatekey','',NULL),(301,0,1547809475,NULL,'filteruploadedfiles','0',NULL),(302,0,1547809475,NULL,'filtermatchoneperpage','0',NULL),(303,0,1547809475,NULL,'filtermatchonepertext','0',NULL),(304,0,1547809475,NULL,'portfolio_moderate_filesize_threshold','1048576',NULL),(305,0,1547809475,NULL,'portfolio_high_filesize_threshold','5242880',NULL),(306,0,1547809475,NULL,'portfolio_moderate_db_threshold','20',NULL),(307,0,1547809475,NULL,'portfolio_high_db_threshold','50',NULL),(308,0,1547809475,'question_preview','behaviour','deferredfeedback',NULL),(309,0,1547809476,'question_preview','correctness','1',NULL),(310,0,1547809476,'question_preview','marks','2',NULL),(311,0,1547809476,'question_preview','markdp','2',NULL),(312,0,1547809476,'question_preview','feedback','1',NULL),(313,0,1547809476,'question_preview','generalfeedback','1',NULL),(314,0,1547809476,'question_preview','rightanswer','1',NULL),(315,0,1547809476,'question_preview','history','0',NULL),(316,0,1547809476,NULL,'repositorycacheexpire','120',NULL),(317,0,1547809477,NULL,'repositorygetfiletimeout','30',NULL),(318,0,1547809477,NULL,'repositorysyncfiletimeout','1',NULL),(319,0,1547809477,NULL,'repositorysyncimagetimeout','3',NULL),(320,0,1547809477,NULL,'repositoryallowexternallinks','1',NULL),(321,0,1547809477,NULL,'legacyfilesinnewcourses','0',NULL),(322,0,1547809477,NULL,'legacyfilesaddallowed','1',NULL),(323,0,1547809477,NULL,'searchengine','simpledb',NULL),(324,0,1547809478,NULL,'searchindexwhendisabled','0',NULL),(325,0,1547809478,NULL,'searchindextime','600',NULL),(326,0,1547809478,NULL,'searchallavailablecourses','0',NULL),(327,0,1547809478,NULL,'enablewsdocumentation','0',NULL),(328,0,1547809478,NULL,'allowbeforeblock','0',NULL),(329,0,1547809478,NULL,'allowedip','',NULL),(330,0,1547809478,NULL,'blockedip','',NULL),(331,0,1547809478,NULL,'protectusernames','1',NULL),(332,0,1547809478,NULL,'forcelogin','0',NULL),(333,0,1547809478,NULL,'forceloginforprofiles','1',NULL),(334,0,1547809479,NULL,'forceloginforprofileimage','0',NULL),(335,0,1547809479,NULL,'opentogoogle','0',NULL),(336,0,1547809479,NULL,'allowindexing','0',NULL),(337,0,1547809479,NULL,'maxbytes','0',NULL),(338,0,1547809479,NULL,'userquota','104857600',NULL),(339,0,1547809479,NULL,'allowobjectembed','0',NULL),(340,0,1547809479,NULL,'enabletrusttext','0',NULL),(341,0,1547809479,NULL,'maxeditingtime','1800',NULL),(342,0,1547809479,NULL,'extendedusernamechars','0',NULL),(343,0,1547809479,NULL,'keeptagnamecase','1',NULL),(344,0,1547809480,NULL,'profilesforenrolledusersonly','1',NULL),(345,0,1547809480,NULL,'cronclionly','1',NULL),(346,0,1547809480,NULL,'cronremotepassword','',NULL),(347,0,1547809480,'tool_task','enablerunnow','1',NULL),(348,0,1547809480,NULL,'lockoutthreshold','0',NULL),(349,0,1547809480,NULL,'lockoutwindow','1800',NULL),(350,0,1547809480,NULL,'lockoutduration','1800',NULL),(351,0,1547809480,NULL,'passwordpolicy','1',NULL),(352,0,1547809480,NULL,'minpasswordlength','8',NULL),(353,0,1547809480,NULL,'minpassworddigits','1',NULL),(354,0,1547809480,NULL,'minpasswordlower','1',NULL),(355,0,1547809481,NULL,'minpasswordupper','1',NULL),(356,0,1547809481,NULL,'minpasswordnonalphanum','1',NULL),(357,0,1547809481,NULL,'maxconsecutiveidentchars','0',NULL),(358,0,1547809481,NULL,'passwordreuselimit','0',NULL),(359,0,1547809481,NULL,'pwresettime','1800',NULL),(360,0,1547809481,NULL,'passwordchangelogout','0',NULL),(361,0,1547809481,NULL,'passwordchangetokendeletion','0',NULL),(362,0,1547809481,NULL,'tokenduration','7257600',NULL),(363,0,1547809481,NULL,'groupenrolmentkeypolicy','1',NULL),(364,0,1547809481,NULL,'disableuserimages','0',NULL),(365,0,1547809482,NULL,'emailchangeconfirmation','1',NULL),(366,0,1547809482,NULL,'rememberusername','2',NULL),(367,0,1547809482,NULL,'strictformsrequired','0',NULL),(368,0,1547809482,NULL,'cookiesecure','1',NULL),(369,0,1547809482,NULL,'cookiehttponly','0',NULL),(370,0,1547809482,NULL,'allowframembedding','0',NULL),(371,0,1547809482,NULL,'curlsecurityblockedhosts','',NULL),(372,0,1547809482,NULL,'curlsecurityallowedport','',NULL),(373,0,1547809482,NULL,'displayloginfailures','0',NULL),(374,0,1547809482,NULL,'notifyloginfailures','',NULL),(375,0,1547809482,NULL,'notifyloginthreshold','10',NULL),(376,0,1547809483,NULL,'themelist','',NULL),(377,0,1547809483,NULL,'themedesignermode','0',NULL),(378,0,1547809483,NULL,'allowuserthemes','0',NULL),(379,0,1547809483,NULL,'allowcoursethemes','0',NULL),(380,0,1547809483,NULL,'allowcategorythemes','0',NULL),(381,0,1547809483,NULL,'allowcohortthemes','0',NULL),(382,0,1547809483,NULL,'allowthemechangeonurl','0',NULL),(383,0,1547809483,NULL,'allowuserblockhiding','1',NULL),(384,0,1547809483,NULL,'allowblockstodock','1',NULL),(385,0,1547809483,NULL,'custommenuitems','',NULL),(386,0,1547809483,NULL,'customusermenuitems','grades,grades|/grade/report/mygrades.php|t/grades\nmessages,message|/message/index.php|t/message\npreferences,moodle|/user/preferences.php|t/preferences',NULL),(387,0,1547809483,NULL,'enabledevicedetection','1',NULL),(388,0,1547809484,NULL,'devicedetectregex','[]',NULL),(389,0,1547809484,'theme_boost','preset','default.scss',NULL),(390,0,1547809484,'theme_boost','presetfiles','',NULL),(391,0,1547809484,'theme_boost','backgroundimage','',NULL),(392,0,1547809484,'theme_boost','brandcolor','',NULL),(393,0,1547809484,'theme_boost','scsspre','',NULL),(394,0,1547809484,'theme_boost','scss','',NULL),(395,0,1547809484,'theme_clean','invert','0',NULL),(396,0,1547809484,'theme_clean','logo','',NULL),(397,0,1547809484,'theme_clean','smalllogo','',NULL),(398,0,1547809484,'theme_clean','sitename','1',NULL),(399,0,1547809484,'theme_clean','customcss','',NULL),(400,0,1547809485,'theme_clean','footnote','',NULL),(401,0,1547809485,'theme_more','textcolor','#333366',NULL),(402,0,1547809485,'theme_more','linkcolor','#FF6500',NULL),(403,0,1547809485,'theme_more','bodybackground','',NULL),(404,0,1547809485,'theme_more','backgroundimage','',NULL),(405,0,1547809485,'theme_more','backgroundrepeat','repeat',NULL),(406,0,1547809485,'theme_more','backgroundposition','0',NULL),(407,0,1547809485,'theme_more','backgroundfixed','0',NULL),(408,0,1547809485,'theme_more','contentbackground','#FFFFFF',NULL),(409,0,1547809485,'theme_more','secondarybackground','#FFFFFF',NULL),(410,0,1547809486,'theme_more','invert','1',NULL),(411,0,1547809486,'theme_more','logo','',NULL),(412,0,1547809486,'theme_more','smalllogo','',NULL),(413,0,1547809486,'theme_more','sitename','1',NULL),(414,0,1547809486,'theme_more','customcss','',NULL),(415,0,1547809486,'theme_more','footnote','',NULL),(416,0,1547809486,'core_admin','logo','',NULL),(417,0,1547809486,'core_admin','logocompact','',NULL),(418,0,1547809487,NULL,'calendartype','gregorian',NULL),(419,0,1547809487,NULL,'calendar_adminseesall','0',NULL),(420,0,1547809487,NULL,'calendar_site_timeformat','0',NULL),(421,0,1547809487,NULL,'calendar_startwday','0',NULL),(422,0,1547809487,NULL,'calendar_weekend','65',NULL),(423,0,1547809487,NULL,'calendar_lookahead','21',NULL),(424,0,1547809487,NULL,'calendar_maxevents','10',NULL),(425,0,1547809487,NULL,'enablecalendarexport','1',NULL),(426,0,1547809487,NULL,'calendar_customexport','1',NULL),(427,0,1547809487,NULL,'calendar_exportlookahead','365',NULL),(428,0,1547809488,NULL,'calendar_exportlookback','5',NULL),(429,0,1547809488,NULL,'calendar_exportsalt','uzVbum6EPlmBIN7gaF3l4wJ9tpqqAKbwFe7UDWaNioN7HZKza6v9GKjIg7Xl',NULL),(430,0,1547809488,NULL,'calendar_showicalsource','1',NULL),(431,0,1547809488,NULL,'useblogassociations','1',NULL),(432,0,1547809488,NULL,'bloglevel','4',NULL),(433,0,1547809488,NULL,'useexternalblogs','1',NULL),(434,0,1547809488,NULL,'externalblogcrontime','86400',NULL),(435,0,1547809488,NULL,'maxexternalblogsperuser','1',NULL),(436,0,1547809488,NULL,'blogusecomments','1',NULL),(437,0,1547809488,NULL,'blogshowcommentscount','1',NULL),(438,0,1547809488,NULL,'defaulthomepage','1',NULL),(439,0,1547809488,NULL,'allowguestmymoodle','1',NULL),(440,0,1547809489,NULL,'navshowfullcoursenames','0',NULL),(441,0,1547809489,NULL,'navshowcategories','1',NULL),(442,0,1547809489,NULL,'navshowmycoursecategories','0',NULL),(443,0,1547809489,NULL,'navshowallcourses','0',NULL),(444,0,1547809489,NULL,'navsortmycoursessort','sortorder',NULL),(445,0,1547809489,NULL,'navcourselimit','10',NULL),(446,0,1547809489,NULL,'usesitenameforsitepages','0',NULL),(447,0,1547809489,NULL,'linkadmincategories','1',NULL),(448,0,1547809489,NULL,'linkcoursesections','1',NULL),(449,0,1547809489,NULL,'navshowfrontpagemods','1',NULL),(450,0,1547809489,NULL,'navadduserpostslinks','1',NULL),(451,0,1547809490,NULL,'formatstringstriptags','1',NULL),(452,0,1547809490,NULL,'emoticons','[{\"text\":\":-)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":-D\",\"imagename\":\"s\\/biggrin\",\"imagecomponent\":\"core\",\"altidentifier\":\"biggrin\",\"altcomponent\":\"core_pix\"},{\"text\":\";-)\",\"imagename\":\"s\\/wink\",\"imagecomponent\":\"core\",\"altidentifier\":\"wink\",\"altcomponent\":\"core_pix\"},{\"text\":\":-\\/\",\"imagename\":\"s\\/mixed\",\"imagecomponent\":\"core\",\"altidentifier\":\"mixed\",\"altcomponent\":\"core_pix\"},{\"text\":\"V-.\",\"imagename\":\"s\\/thoughtful\",\"imagecomponent\":\"core\",\"altidentifier\":\"thoughtful\",\"altcomponent\":\"core_pix\"},{\"text\":\":-P\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\":-p\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\"B-)\",\"imagename\":\"s\\/cool\",\"imagecomponent\":\"core\",\"altidentifier\":\"cool\",\"altcomponent\":\"core_pix\"},{\"text\":\"^-)\",\"imagename\":\"s\\/approve\",\"imagecomponent\":\"core\",\"altidentifier\":\"approve\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-)\",\"imagename\":\"s\\/wideeyes\",\"imagecomponent\":\"core\",\"altidentifier\":\"wideeyes\",\"altcomponent\":\"core_pix\"},{\"text\":\":o)\",\"imagename\":\"s\\/clown\",\"imagecomponent\":\"core\",\"altidentifier\":\"clown\",\"altcomponent\":\"core_pix\"},{\"text\":\":-(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\":(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-.\",\"imagename\":\"s\\/shy\",\"imagecomponent\":\"core\",\"altidentifier\":\"shy\",\"altcomponent\":\"core_pix\"},{\"text\":\":-I\",\"imagename\":\"s\\/blush\",\"imagecomponent\":\"core\",\"altidentifier\":\"blush\",\"altcomponent\":\"core_pix\"},{\"text\":\":-X\",\"imagename\":\"s\\/kiss\",\"imagecomponent\":\"core\",\"altidentifier\":\"kiss\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-o\",\"imagename\":\"s\\/surprise\",\"imagecomponent\":\"core\",\"altidentifier\":\"surprise\",\"altcomponent\":\"core_pix\"},{\"text\":\"P-|\",\"imagename\":\"s\\/blackeye\",\"imagecomponent\":\"core\",\"altidentifier\":\"blackeye\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-[\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"(grr)\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"xx-P\",\"imagename\":\"s\\/dead\",\"imagecomponent\":\"core\",\"altidentifier\":\"dead\",\"altcomponent\":\"core_pix\"},{\"text\":\"|-.\",\"imagename\":\"s\\/sleepy\",\"imagecomponent\":\"core\",\"altidentifier\":\"sleepy\",\"altcomponent\":\"core_pix\"},{\"text\":\"}-]\",\"imagename\":\"s\\/evil\",\"imagecomponent\":\"core\",\"altidentifier\":\"evil\",\"altcomponent\":\"core_pix\"},{\"text\":\"(h)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(heart)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(y)\",\"imagename\":\"s\\/yes\",\"imagecomponent\":\"core\",\"altidentifier\":\"yes\",\"altcomponent\":\"core\"},{\"text\":\"(n)\",\"imagename\":\"s\\/no\",\"imagecomponent\":\"core\",\"altidentifier\":\"no\",\"altcomponent\":\"core\"},{\"text\":\"(martin)\",\"imagename\":\"s\\/martin\",\"imagecomponent\":\"core\",\"altidentifier\":\"martin\",\"altcomponent\":\"core_pix\"},{\"text\":\"( )\",\"imagename\":\"s\\/egg\",\"imagecomponent\":\"core\",\"altidentifier\":\"egg\",\"altcomponent\":\"core_pix\"}]',NULL),(453,0,1547809490,NULL,'docroot','https://docs.moodle.org',NULL),(454,0,1547809490,NULL,'doclang','',NULL),(455,0,1547809490,NULL,'doctonewwindow','0',NULL),(456,0,1547809490,NULL,'coursecontactduplicates','0',NULL),(457,0,1547809490,NULL,'courselistshortnames','0',NULL),(458,0,1547809490,NULL,'coursesperpage','20',NULL),(459,0,1547809490,NULL,'courseswithsummarieslimit','10',NULL),(460,0,1547809490,NULL,'courseoverviewfileslimit','1',NULL),(461,0,1547809490,NULL,'courseoverviewfilesext','.jpg,.gif,.png',NULL),(462,0,1547809491,NULL,'coursegraceperiodbefore','0',NULL),(463,0,1547809491,NULL,'coursegraceperiodafter','0',NULL),(464,0,1547809491,NULL,'useexternalyui','0',NULL),(465,0,1547809491,NULL,'yuicomboloading','1',NULL),(466,0,1547809491,NULL,'cachejs','1',NULL),(467,0,1547809491,NULL,'modchooserdefault','1',NULL),(468,0,1547809491,NULL,'additionalhtmlhead','',NULL),(469,0,1547809491,NULL,'additionalhtmltopofbody','',NULL),(470,0,1547809491,NULL,'additionalhtmlfooter','',NULL),(471,0,1547809491,NULL,'pathtophp','',NULL),(472,0,1547809491,NULL,'pathtodu','',NULL),(473,0,1547809491,NULL,'aspellpath','',NULL),(474,0,1547809491,NULL,'pathtodot','',NULL),(475,0,1547809491,NULL,'pathtogs','/usr/bin/gs',NULL),(476,0,1547809492,NULL,'pathtopython','',NULL),(477,0,1547809492,NULL,'supportname','Admin Pengguna',NULL),(478,0,1547809492,NULL,'supportemail','',NULL),(479,0,1547809492,NULL,'supportpage','',NULL),(480,0,1547809492,NULL,'dbsessions','0',NULL),(481,0,1547809492,NULL,'sessioncookie','',NULL),(482,0,1547809492,NULL,'sessioncookiepath','',NULL),(483,0,1547809492,NULL,'sessioncookiedomain','',NULL),(484,0,1547809492,NULL,'statsfirstrun','none',NULL),(485,0,1547809492,NULL,'statsmaxruntime','0',NULL),(486,0,1547809492,NULL,'statsruntimedays','31',NULL),(487,0,1547809493,NULL,'statsuserthreshold','0',NULL),(488,0,1547809493,NULL,'slasharguments','1',NULL),(489,0,1547809493,NULL,'getremoteaddrconf','0',NULL),(490,0,1547809493,NULL,'proxyhost','',NULL),(491,0,1547809493,NULL,'proxyport','0',NULL),(492,0,1547809493,NULL,'proxytype','HTTP',NULL),(493,0,1547809493,NULL,'proxyuser','',NULL),(494,0,1547809493,NULL,'proxypassword','',NULL),(495,0,1547809493,NULL,'proxybypass','localhost, 127.0.0.1',NULL),(496,0,1547809493,NULL,'maintenance_enabled','0',NULL),(497,0,1547809494,NULL,'maintenance_message','',NULL),(498,0,1547809494,NULL,'deleteunconfirmed','168',NULL),(499,0,1547809494,NULL,'deleteincompleteusers','0',NULL),(500,0,1547809494,NULL,'disablegradehistory','0',NULL),(501,0,1547809494,NULL,'gradehistorylifetime','0',NULL),(502,0,1547809494,NULL,'tempdatafoldercleanup','168',NULL),(503,0,1547809494,NULL,'extramemorylimit','512M',NULL),(504,0,1547809494,NULL,'maxtimelimit','0',NULL),(505,0,1547809494,NULL,'curlcache','120',NULL),(506,0,1547809494,NULL,'curltimeoutkbitrate','56',NULL),(507,0,1547809494,NULL,'smtphosts','',NULL),(508,0,1547809494,NULL,'smtpsecure','',NULL),(509,0,1547809494,NULL,'smtpauthtype','LOGIN',NULL),(510,0,1547809494,NULL,'smtpuser','',NULL),(511,0,1547809495,NULL,'smtppass','',NULL),(512,0,1547809495,NULL,'smtpmaxbulk','1',NULL),(513,0,1547809495,NULL,'allowedemaildomains','',NULL),(514,0,1547809495,NULL,'sitemailcharset','0',NULL),(515,0,1547809495,NULL,'allowusermailcharset','0',NULL),(516,0,1547809495,NULL,'allowattachments','1',NULL),(517,0,1547809495,NULL,'mailnewline','LF',NULL),(518,0,1547809495,NULL,'emailfromvia','1',NULL),(519,0,1547809495,NULL,'updateautocheck','1',NULL),(520,0,1547809495,NULL,'updateminmaturity','200',NULL),(521,0,1547809495,NULL,'updatenotifybuilds','0',NULL),(522,0,1547809496,NULL,'enablesafebrowserintegration','0',NULL),(523,0,1547809496,NULL,'dndallowtextandlinks','0',NULL),(524,0,1547809496,NULL,'pathtosassc','',NULL),(525,0,1547809496,NULL,'contextlocking','0',NULL),(526,0,1547809496,NULL,'contextlockappliestoadmin','1',NULL),(527,0,1547809496,NULL,'forceclean','0',NULL),(528,0,1547809496,NULL,'debug','0',NULL),(529,0,1547809496,NULL,'debugdisplay','0',NULL),(530,0,1547809496,NULL,'debugsmtp','0',NULL),(531,0,1547809496,NULL,'perfdebug','7',NULL),(532,0,1547809496,NULL,'debugstringids','0',NULL),(533,0,1547809497,NULL,'debugvalidators','0',NULL),(534,0,1547809497,NULL,'debugpageinfo','0',NULL),(535,0,1547809497,NULL,'profilingenabled','0',NULL),(536,0,1547809497,NULL,'profilingincluded','',NULL),(537,0,1547809497,NULL,'profilingexcluded','',NULL),(538,0,1547809497,NULL,'profilingautofrec','0',NULL),(539,0,1547809498,NULL,'profilingallowme','0',NULL),(540,0,1547809498,NULL,'profilingallowall','0',NULL),(541,0,1547809498,NULL,'profilinglifetime','1440',NULL),(542,0,1547809498,NULL,'profilingimportprefix','(I)',NULL),(543,0,1547809676,'activitynames','filter_active','1',''),(544,0,1547809678,'mathjaxloader','filter_active','1',''),(545,0,1547809679,'mediaplugin','filter_active','1',''),(546,2,1547810003,NULL,'notloggedinroleid','6',NULL),(547,2,1547810003,NULL,'guestroleid','6',NULL),(548,2,1547810003,NULL,'defaultuserroleid','7',NULL),(549,2,1547810003,NULL,'creatornewroleid','3',NULL),(550,2,1547810003,NULL,'restorernewroleid','3',NULL),(551,2,1547810003,'tool_dataprivacy','contactdataprotectionofficer','0',NULL),(552,2,1547810003,'tool_dataprivacy','automaticdeletionrequests','1',NULL),(553,2,1547810003,'tool_dataprivacy','privacyrequestexpiry','604800',NULL),(554,2,1547810003,'tool_dataprivacy','requireallenddatesforuserdeletion','1',NULL),(555,2,1547810003,'tool_dataprivacy','showdataretentionsummary','1',NULL),(556,2,1547810003,'tool_log','exportlog','1',NULL),(557,2,1547810003,NULL,'sitepolicyhandler','',NULL),(558,2,1547810003,NULL,'gradebookroles','5',NULL),(559,2,1547810004,'analytics','logstore','logstore_standard',NULL),(560,2,1547810004,'tool_recyclebin','coursebinenable','1',NULL),(561,2,1547810004,'tool_recyclebin','coursebinexpiry','604800',NULL),(562,2,1547810004,'tool_recyclebin','categorybinenable','1',NULL),(563,2,1547810004,'tool_recyclebin','categorybinexpiry','604800',NULL),(564,2,1547810004,'tool_recyclebin','autohide','1',NULL),(565,2,1547810004,'antivirus_clamav','runningmethod','commandline',NULL),(566,2,1547810004,'antivirus_clamav','pathtoclam','',NULL),(567,2,1547810004,'antivirus_clamav','pathtounixsocket','',NULL),(568,2,1547810004,'antivirus_clamav','clamfailureonupload','donothing',NULL),(569,2,1547810004,'block_activity_results','config_showbest','3',NULL),(570,2,1547810004,'block_activity_results','config_showbest_locked','',NULL),(571,2,1547810004,'block_activity_results','config_showworst','0',NULL),(572,2,1547810004,'block_activity_results','config_showworst_locked','',NULL),(573,2,1547810005,'block_activity_results','config_usegroups','0',NULL),(574,2,1547810005,'block_activity_results','config_usegroups_locked','',NULL),(575,2,1547810005,'block_activity_results','config_nameformat','1',NULL),(576,2,1547810005,'block_activity_results','config_nameformat_locked','',NULL),(577,2,1547810005,'block_activity_results','config_gradeformat','1',NULL),(578,2,1547810005,'block_activity_results','config_gradeformat_locked','',NULL),(579,2,1547810005,'block_activity_results','config_decimalpoints','2',NULL),(580,2,1547810005,'block_activity_results','config_decimalpoints_locked','',NULL),(581,2,1547810005,NULL,'block_html_allowcssclasses','0',NULL),(582,2,1547810005,NULL,'block_course_list_adminview','all',NULL),(583,2,1547810005,NULL,'block_course_list_hideallcourseslink','0',NULL),(584,2,1547810005,NULL,'block_online_users_timetosee','5',NULL),(585,2,1547810006,NULL,'block_rss_client_num_entries','5',NULL),(586,2,1547810006,NULL,'block_rss_client_timeout','30',NULL),(587,2,1547810006,'block_section_links','numsections1','22',NULL),(588,2,1547810006,'block_section_links','incby1','2',NULL),(589,2,1547810006,'block_section_links','numsections2','40',NULL),(590,2,1547810006,'block_section_links','incby2','5',NULL),(591,2,1547810006,'block_tag_youtube','apikey','',NULL),(592,2,1547810006,'fileconverter_googledrive','issuerid','',NULL),(593,2,1547810006,NULL,'pathtounoconv','/usr/bin/unoconv',NULL),(594,2,1547810006,'editor_atto','toolbar','collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist\nlinks = link\nfiles = image, media, recordrtc, managefiles\nstyle2 = underline, strike, subscript, superscript\nalign = align\nindent = indent\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html',NULL),(595,2,1547810007,'editor_atto','autosavefrequency','60',NULL),(596,2,1547810007,'atto_collapse','showgroups','5',NULL),(597,2,1547810007,'atto_equation','librarygroup1','\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n',NULL),(598,2,1547810007,'atto_equation','librarygroup2','\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n',NULL),(599,2,1547810007,'atto_equation','librarygroup3','\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n',NULL),(600,2,1547810007,'atto_equation','librarygroup4','\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n',NULL),(601,2,1547810007,'atto_recordrtc','allowedtypes','both',NULL),(602,2,1547810007,'atto_recordrtc','audiobitrate','128000',NULL),(603,2,1547810007,'atto_recordrtc','videobitrate','2500000',NULL),(604,2,1547810007,'atto_recordrtc','timelimit','120',NULL),(605,2,1547810007,'atto_table','allowborders','0',NULL),(606,2,1547810007,'atto_table','allowbackgroundcolour','0',NULL),(607,2,1547810007,'atto_table','allowwidth','0',NULL),(608,2,1547810008,'editor_tinymce','customtoolbar','wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen',NULL),(609,2,1547810008,'editor_tinymce','fontselectlist','Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings',NULL),(610,2,1547810008,'editor_tinymce','customconfig','',NULL),(611,2,1547810008,'tinymce_moodleemoticon','requireemoticon','1',NULL),(612,2,1547810008,'tinymce_spellchecker','spellengine','',NULL),(613,2,1547810008,'tinymce_spellchecker','spelllanguagelist','+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv',NULL),(614,2,1547810008,'format_singleactivity','activitytype','forum',NULL),(615,2,1547810008,NULL,'jabberhost','',NULL),(616,2,1547810008,NULL,'jabberserver','',NULL),(617,2,1547810008,NULL,'jabberusername','',NULL),(618,2,1547810008,NULL,'jabberpassword','',NULL),(619,2,1547810008,NULL,'jabberport','5222',NULL),(620,2,1547810008,NULL,'airnotifierurl','https://messages.moodle.net',NULL),(621,2,1547810009,NULL,'airnotifierport','443',NULL),(622,2,1547810009,NULL,'airnotifiermobileappname','com.moodle.moodlemobile',NULL),(623,2,1547810009,NULL,'airnotifierappname','commoodlemoodlemobile',NULL),(624,2,1547810009,NULL,'airnotifieraccesskey','',NULL),(625,2,1547810009,'logstore_database','dbdriver','',NULL),(626,2,1547810009,'logstore_database','dbhost','',NULL),(627,2,1547810009,'logstore_database','dbuser','',NULL),(628,2,1547810009,'logstore_database','dbpass','',NULL),(629,2,1547810009,'logstore_database','dbname','',NULL),(630,2,1547810009,'logstore_database','dbtable','',NULL),(631,2,1547810009,'logstore_database','dbpersist','0',NULL),(632,2,1547810009,'logstore_database','dbsocket','',NULL),(633,2,1547810009,'logstore_database','dbport','',NULL),(634,2,1547810009,'logstore_database','dbschema','',NULL),(635,2,1547810009,'logstore_database','dbcollation','',NULL),(636,2,1547810010,'logstore_database','dbhandlesoptions','0',NULL),(637,2,1547810010,'logstore_database','buffersize','50',NULL),(638,2,1547810010,'logstore_database','logguests','0',NULL),(639,2,1547810010,'logstore_database','includelevels','1,2,0',NULL),(640,2,1547810010,'logstore_database','includeactions','c,r,u,d',NULL),(641,2,1547810010,'logstore_legacy','loglegacy','0',NULL),(642,2,1547810010,NULL,'logguests','1',NULL),(643,2,1547810010,NULL,'loglifetime','0',NULL),(644,2,1547810010,'logstore_standard','logguests','1',NULL),(645,2,1547810010,'logstore_standard','loglifetime','0',NULL),(646,2,1547810010,'logstore_standard','buffersize','50',NULL),(647,2,1547810011,'media_videojs','videoextensions','html_video,.f4v,.flv',NULL),(648,2,1547810011,'media_videojs','audioextensions','html_audio',NULL),(649,2,1547810011,'media_videojs','rtmp','0',NULL),(650,2,1547810011,'media_videojs','useflash','0',NULL),(651,2,1547810011,'media_videojs','youtube','1',NULL),(652,2,1547810011,'media_videojs','videocssclass','video-js',NULL),(653,2,1547810011,'media_videojs','audiocssclass','video-js',NULL),(654,2,1547810011,'media_videojs','limitsize','1',NULL),(655,2,1547810011,'assign','feedback_plugin_for_gradebook','assignfeedback_comments',NULL),(656,2,1547810011,'assign','showrecentsubmissions','0',NULL),(657,2,1547810011,'assign','submissionreceipts','1',NULL),(658,2,1547810011,'assign','submissionstatement','This assignment is my own work, except where I have acknowledged the use of the works of other people.',NULL),(659,2,1547810011,'assign','maxperpage','-1',NULL),(660,2,1547810012,'assign','alwaysshowdescription','1',NULL),(661,2,1547810012,'assign','alwaysshowdescription_adv','',NULL),(662,2,1547810012,'assign','alwaysshowdescription_locked','',NULL),(663,2,1547810012,'assign','allowsubmissionsfromdate','0',NULL),(664,2,1547810012,'assign','allowsubmissionsfromdate_enabled','1',NULL),(665,2,1547810012,'assign','allowsubmissionsfromdate_adv','',NULL),(666,2,1547810012,'assign','duedate','604800',NULL),(667,2,1547810012,'assign','duedate_enabled','1',NULL),(668,2,1547810012,'assign','duedate_adv','',NULL),(669,2,1547810012,'assign','cutoffdate','1209600',NULL),(670,2,1547810012,'assign','cutoffdate_enabled','',NULL),(671,2,1547810012,'assign','cutoffdate_adv','',NULL),(672,2,1547810012,'assign','gradingduedate','1209600',NULL),(673,2,1547810012,'assign','gradingduedate_enabled','1',NULL),(674,2,1547810013,'assign','gradingduedate_adv','',NULL),(675,2,1547810013,'assign','submissiondrafts','0',NULL),(676,2,1547810013,'assign','submissiondrafts_adv','',NULL),(677,2,1547810013,'assign','submissiondrafts_locked','',NULL),(678,2,1547810013,'assign','requiresubmissionstatement','0',NULL),(679,2,1547810013,'assign','requiresubmissionstatement_adv','',NULL),(680,2,1547810013,'assign','requiresubmissionstatement_locked','',NULL),(681,2,1547810013,'assign','attemptreopenmethod','none',NULL),(682,2,1547810014,'assign','attemptreopenmethod_adv','',NULL),(683,2,1547810014,'assign','attemptreopenmethod_locked','',NULL),(684,2,1547810014,'assign','maxattempts','-1',NULL),(685,2,1547810014,'assign','maxattempts_adv','',NULL),(686,2,1547810014,'assign','maxattempts_locked','',NULL),(687,2,1547810014,'assign','teamsubmission','0',NULL),(688,2,1547810014,'assign','teamsubmission_adv','',NULL),(689,2,1547810014,'assign','teamsubmission_locked','',NULL),(690,2,1547810014,'assign','preventsubmissionnotingroup','0',NULL),(691,2,1547810014,'assign','preventsubmissionnotingroup_adv','',NULL),(692,2,1547810014,'assign','preventsubmissionnotingroup_locked','',NULL),(693,2,1547810014,'assign','requireallteammemberssubmit','0',NULL),(694,2,1547810015,'assign','requireallteammemberssubmit_adv','',NULL),(695,2,1547810015,'assign','requireallteammemberssubmit_locked','',NULL),(696,2,1547810015,'assign','teamsubmissiongroupingid','',NULL),(697,2,1547810015,'assign','teamsubmissiongroupingid_adv','',NULL),(698,2,1547810015,'assign','sendnotifications','0',NULL),(699,2,1547810015,'assign','sendnotifications_adv','',NULL),(700,2,1547810015,'assign','sendnotifications_locked','',NULL),(701,2,1547810015,'assign','sendlatenotifications','0',NULL),(702,2,1547810015,'assign','sendlatenotifications_adv','',NULL),(703,2,1547810015,'assign','sendlatenotifications_locked','',NULL),(704,2,1547810015,'assign','sendstudentnotifications','1',NULL),(705,2,1547810016,'assign','sendstudentnotifications_adv','',NULL),(706,2,1547810016,'assign','sendstudentnotifications_locked','',NULL),(707,2,1547810016,'assign','blindmarking','0',NULL),(708,2,1547810016,'assign','blindmarking_adv','',NULL),(709,2,1547810016,'assign','blindmarking_locked','',NULL),(710,2,1547810016,'assign','markingworkflow','0',NULL),(711,2,1547810016,'assign','markingworkflow_adv','',NULL),(712,2,1547810016,'assign','markingworkflow_locked','',NULL),(713,2,1547810016,'assign','markingallocation','0',NULL),(714,2,1547810016,'assign','markingallocation_adv','',NULL),(715,2,1547810016,'assign','markingallocation_locked','',NULL),(716,2,1547810016,'assignsubmission_file','default','1',NULL),(717,2,1547810017,'assignsubmission_file','maxfiles','20',NULL),(718,2,1547810017,'assignsubmission_file','filetypes','',NULL),(719,2,1547810017,'assignsubmission_file','maxbytes','0',NULL),(720,2,1547810017,'assignsubmission_onlinetext','default','0',NULL),(721,2,1547810017,'assignfeedback_comments','default','1',NULL),(722,2,1547810017,'assignfeedback_comments','inline','0',NULL),(723,2,1547810017,'assignfeedback_comments','inline_adv','',NULL),(724,2,1547810017,'assignfeedback_comments','inline_locked','',NULL),(725,2,1547810017,'assignfeedback_editpdf','default','1',NULL),(726,2,1547810017,'assignfeedback_editpdf','stamps','',NULL),(727,2,1547810017,'assignfeedback_file','default','0',NULL),(728,2,1547810017,'assignfeedback_offline','default','0',NULL),(729,2,1547810017,'book','numberingoptions','0,1,2,3',NULL),(730,2,1547810017,'book','navoptions','0,1,2',NULL),(731,2,1547810018,'book','numbering','1',NULL),(732,2,1547810018,'book','navstyle','1',NULL),(733,2,1547810018,NULL,'data_enablerssfeeds','0',NULL),(734,2,1547810018,NULL,'feedback_allowfullanonymous','0',NULL),(735,2,1547810018,'resource','framesize','130',NULL),(736,2,1547810018,'resource','displayoptions','0,1,4,5,6',NULL),(737,2,1547810018,'resource','printintro','1',NULL),(738,2,1547810018,'resource','display','0',NULL),(739,2,1547810018,'resource','showsize','0',NULL),(740,2,1547810018,'resource','showtype','0',NULL),(741,2,1547810018,'resource','showdate','0',NULL),(742,2,1547810018,'resource','popupwidth','620',NULL),(743,2,1547810018,'resource','popupheight','450',NULL),(744,2,1547810019,'resource','filterfiles','0',NULL),(745,2,1547810019,'folder','showexpanded','1',NULL),(746,2,1547810019,'folder','maxsizetodownload','0',NULL),(747,2,1547810019,NULL,'forum_displaymode','3',NULL),(748,2,1547810019,NULL,'forum_shortpost','300',NULL),(749,2,1547810019,NULL,'forum_longpost','600',NULL),(750,2,1547810019,NULL,'forum_manydiscussions','100',NULL),(751,2,1547810019,NULL,'forum_maxbytes','512000',NULL),(752,2,1547810019,NULL,'forum_maxattachments','9',NULL),(753,2,1547810019,NULL,'forum_subscription','0',NULL),(754,2,1547810019,NULL,'forum_trackingtype','1',NULL),(755,2,1547810019,NULL,'forum_trackreadposts','1',NULL),(756,2,1547810019,NULL,'forum_allowforcedreadtracking','0',NULL),(757,2,1547810020,NULL,'forum_oldpostdays','14',NULL),(758,2,1547810020,NULL,'forum_usermarksread','0',NULL),(759,2,1547810020,NULL,'forum_cleanreadtime','2',NULL),(760,2,1547810020,NULL,'digestmailtime','17',NULL),(761,2,1547810020,NULL,'forum_enablerssfeeds','0',NULL),(762,2,1547810020,NULL,'forum_enabletimedposts','1',NULL),(763,2,1547810020,NULL,'glossary_entbypage','10',NULL),(764,2,1547810020,NULL,'glossary_dupentries','0',NULL),(765,2,1547810020,NULL,'glossary_allowcomments','0',NULL),(766,2,1547810020,NULL,'glossary_linkbydefault','1',NULL),(767,2,1547810020,NULL,'glossary_defaultapproval','1',NULL),(768,2,1547810020,NULL,'glossary_enablerssfeeds','0',NULL),(769,2,1547810021,NULL,'glossary_linkentries','0',NULL),(770,2,1547810021,NULL,'glossary_casesensitive','0',NULL),(771,2,1547810021,NULL,'glossary_fullmatch','0',NULL),(772,2,1547810021,'imscp','keepold','1',NULL),(773,2,1547810021,'imscp','keepold_adv','',NULL),(774,2,1547810021,'quiz','timelimit','0',NULL),(775,2,1547810021,'quiz','timelimit_adv','',NULL),(776,2,1547810021,'quiz','overduehandling','autosubmit',NULL),(777,2,1547810021,'quiz','overduehandling_adv','',NULL),(778,2,1547810022,'quiz','graceperiod','86400',NULL),(779,2,1547810022,'quiz','graceperiod_adv','',NULL),(780,2,1547810022,'quiz','graceperiodmin','60',NULL),(781,2,1547810022,'quiz','attempts','0',NULL),(782,2,1547810022,'quiz','attempts_adv','',NULL),(783,2,1547810022,'quiz','grademethod','1',NULL),(784,2,1547810022,'quiz','grademethod_adv','',NULL),(785,2,1547810022,'quiz','maximumgrade','10',NULL),(786,2,1547810022,'quiz','questionsperpage','1',NULL),(787,2,1547810022,'quiz','questionsperpage_adv','',NULL),(788,2,1547810022,'quiz','navmethod','free',NULL),(789,2,1547810022,'quiz','navmethod_adv','1',NULL),(790,2,1547810022,'quiz','shuffleanswers','1',NULL),(791,2,1547810022,'quiz','shuffleanswers_adv','',NULL),(792,2,1547810023,'quiz','preferredbehaviour','deferredfeedback',NULL),(793,2,1547810023,'quiz','canredoquestions','0',NULL),(794,2,1547810023,'quiz','canredoquestions_adv','1',NULL),(795,2,1547810023,'quiz','attemptonlast','0',NULL),(796,2,1547810023,'quiz','attemptonlast_adv','1',NULL),(797,2,1547810023,'quiz','reviewattempt','69904',NULL),(798,2,1547810023,'quiz','reviewcorrectness','69904',NULL),(799,2,1547810023,'quiz','reviewmarks','69904',NULL),(800,2,1547810023,'quiz','reviewspecificfeedback','69904',NULL),(801,2,1547810024,'quiz','reviewgeneralfeedback','69904',NULL),(802,2,1547810024,'quiz','reviewrightanswer','69904',NULL),(803,2,1547810024,'quiz','reviewoverallfeedback','4368',NULL),(804,2,1547810024,'quiz','showuserpicture','0',NULL),(805,2,1547810024,'quiz','showuserpicture_adv','',NULL),(806,2,1547810024,'quiz','decimalpoints','2',NULL),(807,2,1547810024,'quiz','decimalpoints_adv','',NULL),(808,2,1547810024,'quiz','questiondecimalpoints','-1',NULL),(809,2,1547810024,'quiz','questiondecimalpoints_adv','1',NULL),(810,2,1547810024,'quiz','showblocks','0',NULL),(811,2,1547810024,'quiz','showblocks_adv','1',NULL),(812,2,1547810024,'quiz','password','',NULL),(813,2,1547810025,'quiz','password_adv','',NULL),(814,2,1547810025,'quiz','subnet','',NULL),(815,2,1547810025,'quiz','subnet_adv','1',NULL),(816,2,1547810025,'quiz','delay1','0',NULL),(817,2,1547810025,'quiz','delay1_adv','1',NULL),(818,2,1547810025,'quiz','delay2','0',NULL),(819,2,1547810025,'quiz','delay2_adv','1',NULL),(820,2,1547810025,'quiz','browsersecurity','-',NULL),(821,2,1547810025,'quiz','browsersecurity_adv','1',NULL),(822,2,1547810025,'quiz','initialnumfeedbacks','2',NULL),(823,2,1547810025,'quiz','autosaveperiod','60',NULL),(824,2,1547810026,'label','dndmedia','1',NULL),(825,2,1547810026,'label','dndresizewidth','400',NULL),(826,2,1547810026,'label','dndresizeheight','400',NULL),(827,2,1547810026,NULL,'chat_method','ajax',NULL),(828,2,1547810026,NULL,'chat_refresh_userlist','10',NULL),(829,2,1547810026,NULL,'chat_old_ping','35',NULL),(830,2,1547810026,NULL,'chat_refresh_room','5',NULL),(831,2,1547810026,NULL,'chat_normal_updatemode','jsupdate',NULL),(832,2,1547810026,NULL,'chat_serverhost','localhost',NULL),(833,2,1547810026,NULL,'chat_serverip','127.0.0.1',NULL),(834,2,1547810027,NULL,'chat_serverport','9111',NULL),(835,2,1547810027,NULL,'chat_servermax','100',NULL),(836,2,1547810027,'page','displayoptions','5',NULL),(837,2,1547810027,'page','printheading','1',NULL),(838,2,1547810027,'page','printintro','0',NULL),(839,2,1547810027,'page','printlastmodified','1',NULL),(840,2,1547810027,'page','display','5',NULL),(841,2,1547810027,'page','popupwidth','620',NULL),(842,2,1547810027,'page','popupheight','450',NULL),(843,2,1547810027,'mod_lesson','mediafile','',NULL),(844,2,1547810028,'mod_lesson','mediafile_adv','1',NULL),(845,2,1547810028,'mod_lesson','mediawidth','640',NULL),(846,2,1547810028,'mod_lesson','mediaheight','480',NULL),(847,2,1547810028,'mod_lesson','mediaclose','0',NULL),(848,2,1547810028,'mod_lesson','progressbar','0',NULL),(849,2,1547810028,'mod_lesson','progressbar_adv','',NULL),(850,2,1547810028,'mod_lesson','ongoing','0',NULL),(851,2,1547810028,'mod_lesson','ongoing_adv','1',NULL),(852,2,1547810028,'mod_lesson','displayleftmenu','0',NULL),(853,2,1547810028,'mod_lesson','displayleftmenu_adv','',NULL),(854,2,1547810029,'mod_lesson','displayleftif','0',NULL),(855,2,1547810029,'mod_lesson','displayleftif_adv','1',NULL),(856,2,1547810029,'mod_lesson','slideshow','0',NULL),(857,2,1547810029,'mod_lesson','slideshow_adv','1',NULL),(858,2,1547810029,'mod_lesson','slideshowwidth','640',NULL),(859,2,1547810029,'mod_lesson','slideshowheight','480',NULL),(860,2,1547810029,'mod_lesson','slideshowbgcolor','#FFFFFF',NULL),(861,2,1547810029,'mod_lesson','maxanswers','5',NULL),(862,2,1547810029,'mod_lesson','maxanswers_adv','1',NULL),(863,2,1547810029,'mod_lesson','defaultfeedback','0',NULL),(864,2,1547810029,'mod_lesson','defaultfeedback_adv','1',NULL),(865,2,1547810029,'mod_lesson','activitylink','',NULL),(866,2,1547810029,'mod_lesson','activitylink_adv','1',NULL),(867,2,1547810029,'mod_lesson','timelimit','0',NULL),(868,2,1547810030,'mod_lesson','timelimit_adv','',NULL),(869,2,1547810030,'mod_lesson','password','0',NULL),(870,2,1547810030,'mod_lesson','password_adv','1',NULL),(871,2,1547810030,'mod_lesson','modattempts','0',NULL),(872,2,1547810030,'mod_lesson','modattempts_adv','',NULL),(873,2,1547810030,'mod_lesson','displayreview','0',NULL),(874,2,1547810031,'mod_lesson','displayreview_adv','',NULL),(875,2,1547810031,'mod_lesson','maximumnumberofattempts','1',NULL),(876,2,1547810031,'mod_lesson','maximumnumberofattempts_adv','',NULL),(877,2,1547810031,'mod_lesson','defaultnextpage','0',NULL),(878,2,1547810031,'mod_lesson','defaultnextpage_adv','1',NULL),(879,2,1547810031,'mod_lesson','numberofpagestoshow','1',NULL),(880,2,1547810031,'mod_lesson','numberofpagestoshow_adv','1',NULL),(881,2,1547810031,'mod_lesson','practice','0',NULL),(882,2,1547810031,'mod_lesson','practice_adv','',NULL),(883,2,1547810032,'mod_lesson','customscoring','1',NULL),(884,2,1547810032,'mod_lesson','customscoring_adv','1',NULL),(885,2,1547810032,'mod_lesson','retakesallowed','0',NULL),(886,2,1547810032,'mod_lesson','retakesallowed_adv','',NULL),(887,2,1547810032,'mod_lesson','handlingofretakes','0',NULL),(888,2,1547810032,'mod_lesson','handlingofretakes_adv','1',NULL),(889,2,1547810032,'mod_lesson','minimumnumberofquestions','0',NULL),(890,2,1547810032,'mod_lesson','minimumnumberofquestions_adv','1',NULL),(891,2,1547810033,'scorm','displaycoursestructure','0',NULL),(892,2,1547810033,'scorm','displaycoursestructure_adv','',NULL),(893,2,1547810033,'scorm','popup','0',NULL),(894,2,1547810033,'scorm','popup_adv','',NULL),(895,2,1547810033,'scorm','displayactivityname','1',NULL),(896,2,1547810033,'scorm','framewidth','100',NULL),(897,2,1547810033,'scorm','framewidth_adv','1',NULL),(898,2,1547810033,'scorm','frameheight','500',NULL),(899,2,1547810034,'scorm','frameheight_adv','1',NULL),(900,2,1547810034,'scorm','winoptgrp_adv','1',NULL),(901,2,1547810034,'scorm','scrollbars','0',NULL),(902,2,1547810034,'scorm','directories','0',NULL),(903,2,1547810034,'scorm','location','0',NULL),(904,2,1547810034,'scorm','menubar','0',NULL),(905,2,1547810034,'scorm','toolbar','0',NULL),(906,2,1547810034,'scorm','status','0',NULL),(907,2,1547810034,'scorm','skipview','0',NULL),(908,2,1547810034,'scorm','skipview_adv','1',NULL),(909,2,1547810034,'scorm','hidebrowse','0',NULL),(910,2,1547810034,'scorm','hidebrowse_adv','1',NULL),(911,2,1547810034,'scorm','hidetoc','0',NULL),(912,2,1547810034,'scorm','hidetoc_adv','1',NULL),(913,2,1547810035,'scorm','nav','1',NULL),(914,2,1547810035,'scorm','nav_adv','1',NULL),(915,2,1547810035,'scorm','navpositionleft','-100',NULL),(916,2,1547810035,'scorm','navpositionleft_adv','1',NULL),(917,2,1547810035,'scorm','navpositiontop','-100',NULL),(918,2,1547810035,'scorm','navpositiontop_adv','1',NULL),(919,2,1547810035,'scorm','collapsetocwinsize','767',NULL),(920,2,1547810035,'scorm','collapsetocwinsize_adv','1',NULL),(921,2,1547810035,'scorm','displayattemptstatus','1',NULL),(922,2,1547810035,'scorm','displayattemptstatus_adv','',NULL),(923,2,1547810035,'scorm','grademethod','1',NULL),(924,2,1547810035,'scorm','maxgrade','100',NULL),(925,2,1547810035,'scorm','maxattempt','0',NULL),(926,2,1547810035,'scorm','whatgrade','0',NULL),(927,2,1547810036,'scorm','forcecompleted','0',NULL),(928,2,1547810036,'scorm','forcenewattempt','0',NULL),(929,2,1547810036,'scorm','autocommit','0',NULL),(930,2,1547810036,'scorm','masteryoverride','1',NULL),(931,2,1547810036,'scorm','lastattemptlock','0',NULL),(932,2,1547810036,'scorm','auto','0',NULL),(933,2,1547810036,'scorm','updatefreq','0',NULL),(934,2,1547810036,'scorm','scormstandard','0',NULL),(935,2,1547810036,'scorm','allowtypeexternal','0',NULL),(936,2,1547810036,'scorm','allowtypelocalsync','0',NULL),(937,2,1547810036,'scorm','allowtypeexternalaicc','0',NULL),(938,2,1547810037,'scorm','allowaicchacp','0',NULL),(939,2,1547810037,'scorm','aicchacptimeout','30',NULL),(940,2,1547810037,'scorm','aicchacpkeepsessiondata','1',NULL),(941,2,1547810037,'scorm','aiccuserid','1',NULL),(942,2,1547810037,'scorm','forcejavascript','1',NULL),(943,2,1547810037,'scorm','allowapidebug','0',NULL),(944,2,1547810037,'scorm','apidebugmask','.*',NULL),(945,2,1547810037,'scorm','protectpackagedownloads','0',NULL),(946,2,1547810037,'url','framesize','130',NULL),(947,2,1547810037,'url','secretphrase','',NULL),(948,2,1547810038,'url','rolesinparams','0',NULL),(949,2,1547810038,'url','displayoptions','0,1,5,6',NULL),(950,2,1547810038,'url','printintro','1',NULL),(951,2,1547810038,'url','display','0',NULL),(952,2,1547810038,'url','popupwidth','620',NULL),(953,2,1547810038,'url','popupheight','450',NULL),(954,2,1547810038,'workshop','grade','80',NULL),(955,2,1547810038,'workshop','gradinggrade','20',NULL),(956,2,1547810038,'workshop','gradedecimals','0',NULL),(957,2,1547810038,'workshop','maxbytes','0',NULL),(958,2,1547810038,'workshop','strategy','accumulative',NULL),(959,2,1547810038,'workshop','examplesmode','0',NULL),(960,2,1547810038,'workshopallocation_random','numofreviews','5',NULL),(961,2,1547810038,'workshopform_numerrors','grade0','Tidak',NULL),(962,2,1547810039,'workshopform_numerrors','grade1','Ya',NULL),(963,2,1547810039,'workshopeval_best','comparison','5',NULL),(964,2,1547810039,'auth_cas','field_map_firstname','',NULL),(965,2,1547810039,'auth_cas','field_updatelocal_firstname','oncreate',NULL),(966,2,1547810039,'auth_cas','field_updateremote_firstname','0',NULL),(967,2,1547810039,'auth_cas','field_lock_firstname','unlocked',NULL),(968,2,1547810039,'auth_cas','field_map_lastname','',NULL),(969,2,1547810039,'auth_cas','field_updatelocal_lastname','oncreate',NULL),(970,2,1547810039,'auth_cas','field_updateremote_lastname','0',NULL),(971,2,1547810039,'auth_cas','field_lock_lastname','unlocked',NULL),(972,2,1547810039,'auth_cas','field_map_email','',NULL),(973,2,1547810039,'auth_cas','field_updatelocal_email','oncreate',NULL),(974,2,1547810040,'auth_cas','field_updateremote_email','0',NULL),(975,2,1547810040,'auth_cas','field_lock_email','unlocked',NULL),(976,2,1547810040,'auth_cas','field_map_city','',NULL),(977,2,1547810040,'auth_cas','field_updatelocal_city','oncreate',NULL),(978,2,1547810040,'auth_cas','field_updateremote_city','0',NULL),(979,2,1547810040,'auth_cas','field_lock_city','unlocked',NULL),(980,2,1547810040,'auth_cas','field_map_country','',NULL),(981,2,1547810040,'auth_cas','field_updatelocal_country','oncreate',NULL),(982,2,1547810040,'auth_cas','field_updateremote_country','0',NULL),(983,2,1547810040,'auth_cas','field_lock_country','unlocked',NULL),(984,2,1547810040,'auth_cas','field_map_lang','',NULL),(985,2,1547810040,'auth_cas','field_updatelocal_lang','oncreate',NULL),(986,2,1547810040,'auth_cas','field_updateremote_lang','0',NULL),(987,2,1547810040,'auth_cas','field_lock_lang','unlocked',NULL),(988,2,1547810041,'auth_cas','field_map_description','',NULL),(989,2,1547810041,'auth_cas','field_updatelocal_description','oncreate',NULL),(990,2,1547810041,'auth_cas','field_updateremote_description','0',NULL),(991,2,1547810041,'auth_cas','field_lock_description','unlocked',NULL),(992,2,1547810041,'auth_cas','field_map_url','',NULL),(993,2,1547810041,'auth_cas','field_updatelocal_url','oncreate',NULL),(994,2,1547810041,'auth_cas','field_updateremote_url','0',NULL),(995,2,1547810041,'auth_cas','field_lock_url','unlocked',NULL),(996,2,1547810041,'auth_cas','field_map_idnumber','',NULL),(997,2,1547810042,'auth_cas','field_updatelocal_idnumber','oncreate',NULL),(998,2,1547810042,'auth_cas','field_updateremote_idnumber','0',NULL),(999,2,1547810042,'auth_cas','field_lock_idnumber','unlocked',NULL),(1000,2,1547810042,'auth_cas','field_map_institution','',NULL),(1001,2,1547810042,'auth_cas','field_updatelocal_institution','oncreate',NULL),(1002,2,1547810042,'auth_cas','field_updateremote_institution','0',NULL),(1003,2,1547810042,'auth_cas','field_lock_institution','unlocked',NULL),(1004,2,1547810042,'auth_cas','field_map_department','',NULL),(1005,2,1547810042,'auth_cas','field_updatelocal_department','oncreate',NULL),(1006,2,1547810042,'auth_cas','field_updateremote_department','0',NULL),(1007,2,1547810042,'auth_cas','field_lock_department','unlocked',NULL),(1008,2,1547810042,'auth_cas','field_map_phone1','',NULL),(1009,2,1547810042,'auth_cas','field_updatelocal_phone1','oncreate',NULL),(1010,2,1547810043,'auth_cas','field_updateremote_phone1','0',NULL),(1011,2,1547810043,'auth_cas','field_lock_phone1','unlocked',NULL),(1012,2,1547810043,'auth_cas','field_map_phone2','',NULL),(1013,2,1547810043,'auth_cas','field_updatelocal_phone2','oncreate',NULL),(1014,2,1547810043,'auth_cas','field_updateremote_phone2','0',NULL),(1015,2,1547810043,'auth_cas','field_lock_phone2','unlocked',NULL),(1016,2,1547810043,'auth_cas','field_map_address','',NULL),(1017,2,1547810043,'auth_cas','field_updatelocal_address','oncreate',NULL),(1018,2,1547810043,'auth_cas','field_updateremote_address','0',NULL),(1019,2,1547810043,'auth_cas','field_lock_address','unlocked',NULL),(1020,2,1547810044,'auth_cas','field_map_firstnamephonetic','',NULL),(1021,2,1547810044,'auth_cas','field_updatelocal_firstnamephonetic','oncreate',NULL),(1022,2,1547810044,'auth_cas','field_updateremote_firstnamephonetic','0',NULL),(1023,2,1547810044,'auth_cas','field_lock_firstnamephonetic','unlocked',NULL),(1024,2,1547810044,'auth_cas','field_map_lastnamephonetic','',NULL),(1025,2,1547810044,'auth_cas','field_updatelocal_lastnamephonetic','oncreate',NULL),(1026,2,1547810044,'auth_cas','field_updateremote_lastnamephonetic','0',NULL),(1027,2,1547810044,'auth_cas','field_lock_lastnamephonetic','unlocked',NULL),(1028,2,1547810044,'auth_cas','field_map_middlename','',NULL),(1029,2,1547810044,'auth_cas','field_updatelocal_middlename','oncreate',NULL),(1030,2,1547810044,'auth_cas','field_updateremote_middlename','0',NULL),(1031,2,1547810044,'auth_cas','field_lock_middlename','unlocked',NULL),(1032,2,1547810045,'auth_cas','field_map_alternatename','',NULL),(1033,2,1547810045,'auth_cas','field_updatelocal_alternatename','oncreate',NULL),(1034,2,1547810045,'auth_cas','field_updateremote_alternatename','0',NULL),(1035,2,1547810045,'auth_cas','field_lock_alternatename','unlocked',NULL),(1036,2,1547810045,'auth_db','host','127.0.0.1',NULL),(1037,2,1547810045,'auth_db','type','mysqli',NULL),(1038,2,1547810045,'auth_db','sybasequoting','0',NULL),(1039,2,1547810045,'auth_db','name','',NULL),(1040,2,1547810045,'auth_db','user','',NULL),(1041,2,1547810045,'auth_db','pass','',NULL),(1042,2,1547810045,'auth_db','table','',NULL),(1043,2,1547810045,'auth_db','fielduser','',NULL),(1044,2,1547810046,'auth_db','fieldpass','',NULL),(1045,2,1547810046,'auth_db','passtype','plaintext',NULL),(1046,2,1547810046,'auth_db','extencoding','utf-8',NULL),(1047,2,1547810046,'auth_db','setupsql','',NULL),(1048,2,1547810046,'auth_db','debugauthdb','0',NULL),(1049,2,1547810046,'auth_db','changepasswordurl','',NULL),(1050,2,1547810046,'auth_db','removeuser','0',NULL),(1051,2,1547810046,'auth_db','updateusers','0',NULL),(1052,2,1547810046,'auth_db','field_map_firstname','',NULL),(1053,2,1547810047,'auth_db','field_updatelocal_firstname','oncreate',NULL),(1054,2,1547810047,'auth_db','field_updateremote_firstname','0',NULL),(1055,2,1547810047,'auth_db','field_lock_firstname','unlocked',NULL),(1056,2,1547810047,'auth_db','field_map_lastname','',NULL),(1057,2,1547810047,'auth_db','field_updatelocal_lastname','oncreate',NULL),(1058,2,1547810047,'auth_db','field_updateremote_lastname','0',NULL),(1059,2,1547810047,'auth_db','field_lock_lastname','unlocked',NULL),(1060,2,1547810047,'auth_db','field_map_email','',NULL),(1061,2,1547810047,'auth_db','field_updatelocal_email','oncreate',NULL),(1062,2,1547810047,'auth_db','field_updateremote_email','0',NULL),(1063,2,1547810047,'auth_db','field_lock_email','unlocked',NULL),(1064,2,1547810047,'auth_db','field_map_city','',NULL),(1065,2,1547810048,'auth_db','field_updatelocal_city','oncreate',NULL),(1066,2,1547810048,'auth_db','field_updateremote_city','0',NULL),(1067,2,1547810048,'auth_db','field_lock_city','unlocked',NULL),(1068,2,1547810048,'auth_db','field_map_country','',NULL),(1069,2,1547810048,'auth_db','field_updatelocal_country','oncreate',NULL),(1070,2,1547810048,'auth_db','field_updateremote_country','0',NULL),(1071,2,1547810048,'auth_db','field_lock_country','unlocked',NULL),(1072,2,1547810048,'auth_db','field_map_lang','',NULL),(1073,2,1547810048,'auth_db','field_updatelocal_lang','oncreate',NULL),(1074,2,1547810048,'auth_db','field_updateremote_lang','0',NULL),(1075,2,1547810048,'auth_db','field_lock_lang','unlocked',NULL),(1076,2,1547810048,'auth_db','field_map_description','',NULL),(1077,2,1547810048,'auth_db','field_updatelocal_description','oncreate',NULL),(1078,2,1547810048,'auth_db','field_updateremote_description','0',NULL),(1079,2,1547810049,'auth_db','field_lock_description','unlocked',NULL),(1080,2,1547810049,'auth_db','field_map_url','',NULL),(1081,2,1547810049,'auth_db','field_updatelocal_url','oncreate',NULL),(1082,2,1547810049,'auth_db','field_updateremote_url','0',NULL),(1083,2,1547810049,'auth_db','field_lock_url','unlocked',NULL),(1084,2,1547810049,'auth_db','field_map_idnumber','',NULL),(1085,2,1547810049,'auth_db','field_updatelocal_idnumber','oncreate',NULL),(1086,2,1547810049,'auth_db','field_updateremote_idnumber','0',NULL),(1087,2,1547810049,'auth_db','field_lock_idnumber','unlocked',NULL),(1088,2,1547810049,'auth_db','field_map_institution','',NULL),(1089,2,1547810049,'auth_db','field_updatelocal_institution','oncreate',NULL),(1090,2,1547810049,'auth_db','field_updateremote_institution','0',NULL),(1091,2,1547810049,'auth_db','field_lock_institution','unlocked',NULL),(1092,2,1547810050,'auth_db','field_map_department','',NULL),(1093,2,1547810050,'auth_db','field_updatelocal_department','oncreate',NULL),(1094,2,1547810050,'auth_db','field_updateremote_department','0',NULL),(1095,2,1547810050,'auth_db','field_lock_department','unlocked',NULL),(1096,2,1547810050,'auth_db','field_map_phone1','',NULL),(1097,2,1547810050,'auth_db','field_updatelocal_phone1','oncreate',NULL),(1098,2,1547810050,'auth_db','field_updateremote_phone1','0',NULL),(1099,2,1547810050,'auth_db','field_lock_phone1','unlocked',NULL),(1100,2,1547810051,'auth_db','field_map_phone2','',NULL),(1101,2,1547810051,'auth_db','field_updatelocal_phone2','oncreate',NULL),(1102,2,1547810051,'auth_db','field_updateremote_phone2','0',NULL),(1103,2,1547810051,'auth_db','field_lock_phone2','unlocked',NULL),(1104,2,1547810051,'auth_db','field_map_address','',NULL),(1105,2,1547810051,'auth_db','field_updatelocal_address','oncreate',NULL),(1106,2,1547810051,'auth_db','field_updateremote_address','0',NULL),(1107,2,1547810051,'auth_db','field_lock_address','unlocked',NULL),(1108,2,1547810051,'auth_db','field_map_firstnamephonetic','',NULL),(1109,2,1547810051,'auth_db','field_updatelocal_firstnamephonetic','oncreate',NULL),(1110,2,1547810051,'auth_db','field_updateremote_firstnamephonetic','0',NULL),(1111,2,1547810051,'auth_db','field_lock_firstnamephonetic','unlocked',NULL),(1112,2,1547810051,'auth_db','field_map_lastnamephonetic','',NULL),(1113,2,1547810051,'auth_db','field_updatelocal_lastnamephonetic','oncreate',NULL),(1114,2,1547810052,'auth_db','field_updateremote_lastnamephonetic','0',NULL),(1115,2,1547810052,'auth_db','field_lock_lastnamephonetic','unlocked',NULL),(1116,2,1547810052,'auth_db','field_map_middlename','',NULL),(1117,2,1547810052,'auth_db','field_updatelocal_middlename','oncreate',NULL),(1118,2,1547810052,'auth_db','field_updateremote_middlename','0',NULL),(1119,2,1547810052,'auth_db','field_lock_middlename','unlocked',NULL),(1120,2,1547810052,'auth_db','field_map_alternatename','',NULL),(1121,2,1547810052,'auth_db','field_updatelocal_alternatename','oncreate',NULL),(1122,2,1547810052,'auth_db','field_updateremote_alternatename','0',NULL),(1123,2,1547810052,'auth_db','field_lock_alternatename','unlocked',NULL),(1124,2,1547810052,'auth_ldap','field_map_firstname','',NULL),(1125,2,1547810052,'auth_ldap','field_updatelocal_firstname','oncreate',NULL),(1126,2,1547810052,'auth_ldap','field_updateremote_firstname','0',NULL),(1127,2,1547810052,'auth_ldap','field_lock_firstname','unlocked',NULL),(1128,2,1547810053,'auth_ldap','field_map_lastname','',NULL),(1129,2,1547810053,'auth_ldap','field_updatelocal_lastname','oncreate',NULL),(1130,2,1547810053,'auth_ldap','field_updateremote_lastname','0',NULL),(1131,2,1547810053,'auth_ldap','field_lock_lastname','unlocked',NULL),(1132,2,1547810053,'auth_ldap','field_map_email','',NULL),(1133,2,1547810053,'auth_ldap','field_updatelocal_email','oncreate',NULL),(1134,2,1547810053,'auth_ldap','field_updateremote_email','0',NULL),(1135,2,1547810053,'auth_ldap','field_lock_email','unlocked',NULL),(1136,2,1547810053,'auth_ldap','field_map_city','',NULL),(1137,2,1547810053,'auth_ldap','field_updatelocal_city','oncreate',NULL),(1138,2,1547810053,'auth_ldap','field_updateremote_city','0',NULL),(1139,2,1547810053,'auth_ldap','field_lock_city','unlocked',NULL),(1140,2,1547810054,'auth_ldap','field_map_country','',NULL),(1141,2,1547810054,'auth_ldap','field_updatelocal_country','oncreate',NULL),(1142,2,1547810054,'auth_ldap','field_updateremote_country','0',NULL),(1143,2,1547810054,'auth_ldap','field_lock_country','unlocked',NULL),(1144,2,1547810054,'auth_ldap','field_map_lang','',NULL),(1145,2,1547810054,'auth_ldap','field_updatelocal_lang','oncreate',NULL),(1146,2,1547810054,'auth_ldap','field_updateremote_lang','0',NULL),(1147,2,1547810055,'auth_ldap','field_lock_lang','unlocked',NULL),(1148,2,1547810055,'auth_ldap','field_map_description','',NULL),(1149,2,1547810055,'auth_ldap','field_updatelocal_description','oncreate',NULL),(1150,2,1547810055,'auth_ldap','field_updateremote_description','0',NULL),(1151,2,1547810055,'auth_ldap','field_lock_description','unlocked',NULL),(1152,2,1547810055,'auth_ldap','field_map_url','',NULL),(1153,2,1547810055,'auth_ldap','field_updatelocal_url','oncreate',NULL),(1154,2,1547810055,'auth_ldap','field_updateremote_url','0',NULL),(1155,2,1547810055,'auth_ldap','field_lock_url','unlocked',NULL),(1156,2,1547810055,'auth_ldap','field_map_idnumber','',NULL),(1157,2,1547810055,'auth_ldap','field_updatelocal_idnumber','oncreate',NULL),(1158,2,1547810055,'auth_ldap','field_updateremote_idnumber','0',NULL),(1159,2,1547810055,'auth_ldap','field_lock_idnumber','unlocked',NULL),(1160,2,1547810055,'auth_ldap','field_map_institution','',NULL),(1161,2,1547810056,'auth_ldap','field_updatelocal_institution','oncreate',NULL),(1162,2,1547810056,'auth_ldap','field_updateremote_institution','0',NULL),(1163,2,1547810056,'auth_ldap','field_lock_institution','unlocked',NULL),(1164,2,1547810056,'auth_ldap','field_map_department','',NULL),(1165,2,1547810056,'auth_ldap','field_updatelocal_department','oncreate',NULL),(1166,2,1547810056,'auth_ldap','field_updateremote_department','0',NULL),(1167,2,1547810056,'auth_ldap','field_lock_department','unlocked',NULL),(1168,2,1547810056,'auth_ldap','field_map_phone1','',NULL),(1169,2,1547810056,'auth_ldap','field_updatelocal_phone1','oncreate',NULL),(1170,2,1547810057,'auth_ldap','field_updateremote_phone1','0',NULL),(1171,2,1547810057,'auth_ldap','field_lock_phone1','unlocked',NULL),(1172,2,1547810057,'auth_ldap','field_map_phone2','',NULL),(1173,2,1547810057,'auth_ldap','field_updatelocal_phone2','oncreate',NULL),(1174,2,1547810057,'auth_ldap','field_updateremote_phone2','0',NULL),(1175,2,1547810057,'auth_ldap','field_lock_phone2','unlocked',NULL),(1176,2,1547810057,'auth_ldap','field_map_address','',NULL),(1177,2,1547810057,'auth_ldap','field_updatelocal_address','oncreate',NULL),(1178,2,1547810057,'auth_ldap','field_updateremote_address','0',NULL),(1179,2,1547810057,'auth_ldap','field_lock_address','unlocked',NULL),(1180,2,1547810057,'auth_ldap','field_map_firstnamephonetic','',NULL),(1181,2,1547810058,'auth_ldap','field_updatelocal_firstnamephonetic','oncreate',NULL),(1182,2,1547810058,'auth_ldap','field_updateremote_firstnamephonetic','0',NULL),(1183,2,1547810058,'auth_ldap','field_lock_firstnamephonetic','unlocked',NULL),(1184,2,1547810058,'auth_ldap','field_map_lastnamephonetic','',NULL),(1185,2,1547810058,'auth_ldap','field_updatelocal_lastnamephonetic','oncreate',NULL),(1186,2,1547810058,'auth_ldap','field_updateremote_lastnamephonetic','0',NULL),(1187,2,1547810058,'auth_ldap','field_lock_lastnamephonetic','unlocked',NULL),(1188,2,1547810058,'auth_ldap','field_map_middlename','',NULL),(1189,2,1547810058,'auth_ldap','field_updatelocal_middlename','oncreate',NULL),(1190,2,1547810058,'auth_ldap','field_updateremote_middlename','0',NULL),(1191,2,1547810058,'auth_ldap','field_lock_middlename','unlocked',NULL),(1192,2,1547810058,'auth_ldap','field_map_alternatename','',NULL),(1193,2,1547810058,'auth_ldap','field_updatelocal_alternatename','oncreate',NULL),(1194,2,1547810058,'auth_ldap','field_updateremote_alternatename','0',NULL),(1195,2,1547810059,'auth_ldap','field_lock_alternatename','unlocked',NULL),(1196,2,1547810059,'auth_manual','expiration','0',NULL),(1197,2,1547810059,'auth_manual','expirationtime','30',NULL),(1198,2,1547810059,'auth_manual','expiration_warning','0',NULL),(1199,2,1547810059,'auth_manual','field_lock_firstname','unlocked',NULL),(1200,2,1547810059,'auth_manual','field_lock_lastname','unlocked',NULL),(1201,2,1547810059,'auth_manual','field_lock_email','unlocked',NULL),(1202,2,1547810059,'auth_manual','field_lock_city','unlocked',NULL),(1203,2,1547810059,'auth_manual','field_lock_country','unlocked',NULL),(1204,2,1547810059,'auth_manual','field_lock_lang','unlocked',NULL),(1205,2,1547810059,'auth_manual','field_lock_description','unlocked',NULL),(1206,2,1547810059,'auth_manual','field_lock_url','unlocked',NULL),(1207,2,1547810059,'auth_manual','field_lock_idnumber','unlocked',NULL),(1208,2,1547810060,'auth_manual','field_lock_institution','unlocked',NULL),(1209,2,1547810060,'auth_manual','field_lock_department','unlocked',NULL),(1210,2,1547810060,'auth_manual','field_lock_phone1','unlocked',NULL),(1211,2,1547810060,'auth_manual','field_lock_phone2','unlocked',NULL),(1212,2,1547810060,'auth_manual','field_lock_address','unlocked',NULL),(1213,2,1547810060,'auth_manual','field_lock_firstnamephonetic','unlocked',NULL),(1214,2,1547810060,'auth_manual','field_lock_lastnamephonetic','unlocked',NULL),(1215,2,1547810060,'auth_manual','field_lock_middlename','unlocked',NULL),(1216,2,1547810060,'auth_manual','field_lock_alternatename','unlocked',NULL),(1217,2,1547810060,'auth_mnet','rpc_negotiation_timeout','30',NULL),(1218,2,1547810060,'auth_oauth2','field_lock_firstname','unlocked',NULL),(1219,2,1547810060,'auth_oauth2','field_lock_lastname','unlocked',NULL),(1220,2,1547810061,'auth_oauth2','field_lock_email','unlocked',NULL),(1221,2,1547810061,'auth_oauth2','field_lock_city','unlocked',NULL),(1222,2,1547810061,'auth_oauth2','field_lock_country','unlocked',NULL),(1223,2,1547810061,'auth_oauth2','field_lock_lang','unlocked',NULL),(1224,2,1547810061,'auth_oauth2','field_lock_description','unlocked',NULL),(1225,2,1547810061,'auth_oauth2','field_lock_url','unlocked',NULL),(1226,2,1547810061,'auth_oauth2','field_lock_idnumber','unlocked',NULL),(1227,2,1547810062,'auth_oauth2','field_lock_institution','unlocked',NULL),(1228,2,1547810062,'auth_oauth2','field_lock_department','unlocked',NULL),(1229,2,1547810062,'auth_oauth2','field_lock_phone1','unlocked',NULL),(1230,2,1547810062,'auth_oauth2','field_lock_phone2','unlocked',NULL),(1231,2,1547810062,'auth_oauth2','field_lock_address','unlocked',NULL),(1232,2,1547810062,'auth_oauth2','field_lock_firstnamephonetic','unlocked',NULL),(1233,2,1547810062,'auth_oauth2','field_lock_lastnamephonetic','unlocked',NULL),(1234,2,1547810062,'auth_oauth2','field_lock_middlename','unlocked',NULL),(1235,2,1547810062,'auth_oauth2','field_lock_alternatename','unlocked',NULL),(1236,2,1547810062,'auth_email','recaptcha','0',NULL),(1237,2,1547810062,'auth_email','field_lock_firstname','unlocked',NULL),(1238,2,1547810062,'auth_email','field_lock_lastname','unlocked',NULL),(1239,2,1547810062,'auth_email','field_lock_email','unlocked',NULL),(1240,2,1547810062,'auth_email','field_lock_city','unlocked',NULL),(1241,2,1547810062,'auth_email','field_lock_country','unlocked',NULL),(1242,2,1547810063,'auth_email','field_lock_lang','unlocked',NULL),(1243,2,1547810063,'auth_email','field_lock_description','unlocked',NULL),(1244,2,1547810063,'auth_email','field_lock_url','unlocked',NULL),(1245,2,1547810063,'auth_email','field_lock_idnumber','unlocked',NULL),(1246,2,1547810063,'auth_email','field_lock_institution','unlocked',NULL),(1247,2,1547810063,'auth_email','field_lock_department','unlocked',NULL),(1248,2,1547810063,'auth_email','field_lock_phone1','unlocked',NULL),(1249,2,1547810063,'auth_email','field_lock_phone2','unlocked',NULL),(1250,2,1547810063,'auth_email','field_lock_address','unlocked',NULL),(1251,2,1547810063,'auth_email','field_lock_firstnamephonetic','unlocked',NULL),(1252,2,1547810063,'auth_email','field_lock_lastnamephonetic','unlocked',NULL),(1253,2,1547810063,'auth_email','field_lock_middlename','unlocked',NULL),(1254,2,1547810063,'auth_email','field_lock_alternatename','unlocked',NULL),(1255,2,1547810064,'auth_shibboleth','user_attribute','',NULL),(1256,2,1547810064,'auth_shibboleth','convert_data','',NULL),(1257,2,1547810064,'auth_shibboleth','alt_login','off',NULL),(1258,2,1547810064,'auth_shibboleth','organization_selection','urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai',NULL),(1259,2,1547810064,'auth_shibboleth','logout_handler','',NULL),(1260,2,1547810064,'auth_shibboleth','logout_return_url','',NULL),(1261,2,1547810064,'auth_shibboleth','login_name','Shibboleth Login',NULL),(1262,2,1547810064,'auth_shibboleth','auth_logo','',NULL),(1263,2,1547810064,'auth_shibboleth','auth_instructions','Use the <a href=\"http://localhost/hr-assessment/auth/shibboleth/index.php\">Shibboleth login</a> to get access via Shibboleth, if your institution supports it.<br />Otherwise, use the normal login form shown here.',NULL),(1264,2,1547810064,'auth_shibboleth','changepasswordurl','',NULL),(1265,2,1547810064,'auth_shibboleth','field_map_firstname','',NULL),(1266,2,1547810064,'auth_shibboleth','field_updatelocal_firstname','oncreate',NULL),(1267,2,1547810065,'auth_shibboleth','field_lock_firstname','unlocked',NULL),(1268,2,1547810065,'auth_shibboleth','field_map_lastname','',NULL),(1269,2,1547810065,'auth_shibboleth','field_updatelocal_lastname','oncreate',NULL),(1270,2,1547810065,'auth_shibboleth','field_lock_lastname','unlocked',NULL),(1271,2,1547810065,'auth_shibboleth','field_map_email','',NULL),(1272,2,1547810065,'auth_shibboleth','field_updatelocal_email','oncreate',NULL),(1273,2,1547810065,'auth_shibboleth','field_lock_email','unlocked',NULL),(1274,2,1547810065,'auth_shibboleth','field_map_city','',NULL),(1275,2,1547810065,'auth_shibboleth','field_updatelocal_city','oncreate',NULL),(1276,2,1547810065,'auth_shibboleth','field_lock_city','unlocked',NULL),(1277,2,1547810065,'auth_shibboleth','field_map_country','',NULL),(1278,2,1547810065,'auth_shibboleth','field_updatelocal_country','oncreate',NULL),(1279,2,1547810065,'auth_shibboleth','field_lock_country','unlocked',NULL),(1280,2,1547810065,'auth_shibboleth','field_map_lang','',NULL),(1281,2,1547810065,'auth_shibboleth','field_updatelocal_lang','oncreate',NULL),(1282,2,1547810066,'auth_shibboleth','field_lock_lang','unlocked',NULL),(1283,2,1547810066,'auth_shibboleth','field_map_description','',NULL),(1284,2,1547810066,'auth_shibboleth','field_updatelocal_description','oncreate',NULL),(1285,2,1547810066,'auth_shibboleth','field_lock_description','unlocked',NULL),(1286,2,1547810066,'auth_shibboleth','field_map_url','',NULL),(1287,2,1547810066,'auth_shibboleth','field_updatelocal_url','oncreate',NULL),(1288,2,1547810066,'auth_shibboleth','field_lock_url','unlocked',NULL),(1289,2,1547810066,'auth_shibboleth','field_map_idnumber','',NULL),(1290,2,1547810066,'auth_shibboleth','field_updatelocal_idnumber','oncreate',NULL),(1291,2,1547810066,'auth_shibboleth','field_lock_idnumber','unlocked',NULL),(1292,2,1547810066,'auth_shibboleth','field_map_institution','',NULL),(1293,2,1547810066,'auth_shibboleth','field_updatelocal_institution','oncreate',NULL),(1294,2,1547810067,'auth_shibboleth','field_lock_institution','unlocked',NULL),(1295,2,1547810067,'auth_shibboleth','field_map_department','',NULL),(1296,2,1547810067,'auth_shibboleth','field_updatelocal_department','oncreate',NULL),(1297,2,1547810067,'auth_shibboleth','field_lock_department','unlocked',NULL),(1298,2,1547810067,'auth_shibboleth','field_map_phone1','',NULL),(1299,2,1547810067,'auth_shibboleth','field_updatelocal_phone1','oncreate',NULL),(1300,2,1547810067,'auth_shibboleth','field_lock_phone1','unlocked',NULL),(1301,2,1547810067,'auth_shibboleth','field_map_phone2','',NULL),(1302,2,1547810067,'auth_shibboleth','field_updatelocal_phone2','oncreate',NULL),(1303,2,1547810067,'auth_shibboleth','field_lock_phone2','unlocked',NULL),(1304,2,1547810067,'auth_shibboleth','field_map_address','',NULL),(1305,2,1547810067,'auth_shibboleth','field_updatelocal_address','oncreate',NULL),(1306,2,1547810068,'auth_shibboleth','field_lock_address','unlocked',NULL),(1307,2,1547810068,'auth_shibboleth','field_map_firstnamephonetic','',NULL),(1308,2,1547810068,'auth_shibboleth','field_updatelocal_firstnamephonetic','oncreate',NULL),(1309,2,1547810068,'auth_shibboleth','field_lock_firstnamephonetic','unlocked',NULL),(1310,2,1547810068,'auth_shibboleth','field_map_lastnamephonetic','',NULL),(1311,2,1547810068,'auth_shibboleth','field_updatelocal_lastnamephonetic','oncreate',NULL),(1312,2,1547810068,'auth_shibboleth','field_lock_lastnamephonetic','unlocked',NULL),(1313,2,1547810068,'auth_shibboleth','field_map_middlename','',NULL),(1314,2,1547810068,'auth_shibboleth','field_updatelocal_middlename','oncreate',NULL),(1315,2,1547810068,'auth_shibboleth','field_lock_middlename','unlocked',NULL),(1316,2,1547810068,'auth_shibboleth','field_map_alternatename','',NULL),(1317,2,1547810068,'auth_shibboleth','field_updatelocal_alternatename','oncreate',NULL),(1318,2,1547810069,'auth_shibboleth','field_lock_alternatename','unlocked',NULL),(1319,2,1547810069,'auth_none','field_lock_firstname','unlocked',NULL),(1320,2,1547810069,'auth_none','field_lock_lastname','unlocked',NULL),(1321,2,1547810069,'auth_none','field_lock_email','unlocked',NULL),(1322,2,1547810069,'auth_none','field_lock_city','unlocked',NULL),(1323,2,1547810069,'auth_none','field_lock_country','unlocked',NULL),(1324,2,1547810069,'auth_none','field_lock_lang','unlocked',NULL),(1325,2,1547810069,'auth_none','field_lock_description','unlocked',NULL),(1326,2,1547810069,'auth_none','field_lock_url','unlocked',NULL),(1327,2,1547810069,'auth_none','field_lock_idnumber','unlocked',NULL),(1328,2,1547810069,'auth_none','field_lock_institution','unlocked',NULL),(1329,2,1547810069,'auth_none','field_lock_department','unlocked',NULL),(1330,2,1547810070,'auth_none','field_lock_phone1','unlocked',NULL),(1331,2,1547810070,'auth_none','field_lock_phone2','unlocked',NULL),(1332,2,1547810070,'auth_none','field_lock_address','unlocked',NULL),(1333,2,1547810070,'auth_none','field_lock_firstnamephonetic','unlocked',NULL),(1334,2,1547810070,'auth_none','field_lock_lastnamephonetic','unlocked',NULL),(1335,2,1547810070,'auth_none','field_lock_middlename','unlocked',NULL),(1336,2,1547810070,'auth_none','field_lock_alternatename','unlocked',NULL),(1337,2,1547810070,'enrol_cohort','roleid','5',NULL),(1338,2,1547810070,'enrol_cohort','unenrolaction','0',NULL),(1339,2,1547810070,'enrol_meta','nosyncroleids','',NULL),(1340,2,1547810071,'enrol_meta','syncall','1',NULL),(1341,2,1547810071,'enrol_meta','unenrolaction','3',NULL),(1342,2,1547810071,'enrol_meta','coursesort','sortorder',NULL),(1343,2,1547810071,'enrol_database','dbtype','',NULL),(1344,2,1547810071,'enrol_database','dbhost','localhost',NULL),(1345,2,1547810071,'enrol_database','dbuser','',NULL),(1346,2,1547810071,'enrol_database','dbpass','',NULL),(1347,2,1547810071,'enrol_database','dbname','',NULL),(1348,2,1547810071,'enrol_database','dbencoding','utf-8',NULL),(1349,2,1547810072,'enrol_database','dbsetupsql','',NULL),(1350,2,1547810072,'enrol_database','dbsybasequoting','0',NULL),(1351,2,1547810072,'enrol_database','debugdb','0',NULL),(1352,2,1547810072,'enrol_database','localcoursefield','idnumber',NULL),(1353,2,1547810072,'enrol_database','localuserfield','idnumber',NULL),(1354,2,1547810072,'enrol_database','localrolefield','shortname',NULL),(1355,2,1547810072,'enrol_database','localcategoryfield','id',NULL),(1356,2,1547810072,'enrol_database','remoteenroltable','',NULL),(1357,2,1547810072,'enrol_database','remotecoursefield','',NULL),(1358,2,1547810072,'enrol_database','remoteuserfield','',NULL),(1359,2,1547810072,'enrol_database','remoterolefield','',NULL),(1360,2,1547810072,'enrol_database','remoteotheruserfield','',NULL),(1361,2,1547810072,'enrol_database','defaultrole','5',NULL),(1362,2,1547810072,'enrol_database','ignorehiddencourses','0',NULL),(1363,2,1547810073,'enrol_database','unenrolaction','0',NULL),(1364,2,1547810073,'enrol_database','newcoursetable','',NULL),(1365,2,1547810073,'enrol_database','newcoursefullname','fullname',NULL),(1366,2,1547810073,'enrol_database','newcourseshortname','shortname',NULL),(1367,2,1547810073,'enrol_database','newcourseidnumber','idnumber',NULL),(1368,2,1547810073,'enrol_database','newcoursecategory','',NULL),(1369,2,1547810073,'enrol_database','defaultcategory','1',NULL),(1370,2,1547810073,'enrol_database','templatecourse','',NULL),(1371,2,1547810073,'enrol_flatfile','location','',NULL),(1372,2,1547810073,'enrol_flatfile','encoding','UTF-8',NULL),(1373,2,1547810073,'enrol_flatfile','mailstudents','0',NULL),(1374,2,1547810073,'enrol_flatfile','mailteachers','0',NULL),(1375,2,1547810073,'enrol_flatfile','mailadmins','0',NULL),(1376,2,1547810073,'enrol_flatfile','unenrolaction','3',NULL),(1377,2,1547810074,'enrol_flatfile','expiredaction','3',NULL),(1378,2,1547810074,'enrol_guest','requirepassword','0',NULL),(1379,2,1547810074,'enrol_guest','usepasswordpolicy','0',NULL),(1380,2,1547810074,'enrol_guest','showhint','0',NULL),(1381,2,1547810074,'enrol_guest','defaultenrol','1',NULL),(1382,2,1547810074,'enrol_guest','status','1',NULL),(1383,2,1547810074,'enrol_guest','status_adv','',NULL),(1384,2,1547810074,'enrol_imsenterprise','imsfilelocation','',NULL),(1385,2,1547810074,'enrol_imsenterprise','logtolocation','',NULL),(1386,2,1547810074,'enrol_imsenterprise','mailadmins','0',NULL),(1387,2,1547810074,'enrol_imsenterprise','createnewusers','0',NULL),(1388,2,1547810074,'enrol_imsenterprise','imsupdateusers','0',NULL),(1389,2,1547810074,'enrol_imsenterprise','imsdeleteusers','0',NULL),(1390,2,1547810074,'enrol_imsenterprise','fixcaseusernames','0',NULL),(1391,2,1547810075,'enrol_imsenterprise','fixcasepersonalnames','0',NULL),(1392,2,1547810075,'enrol_imsenterprise','imssourcedidfallback','0',NULL),(1393,2,1547810075,'enrol_imsenterprise','imsrolemap01','5',NULL),(1394,2,1547810075,'enrol_imsenterprise','imsrolemap02','3',NULL),(1395,2,1547810075,'enrol_imsenterprise','imsrolemap03','3',NULL),(1396,2,1547810075,'enrol_imsenterprise','imsrolemap04','5',NULL),(1397,2,1547810075,'enrol_imsenterprise','imsrolemap05','0',NULL),(1398,2,1547810076,'enrol_imsenterprise','imsrolemap06','4',NULL),(1399,2,1547810076,'enrol_imsenterprise','imsrolemap07','0',NULL),(1400,2,1547810076,'enrol_imsenterprise','imsrolemap08','4',NULL),(1401,2,1547810076,'enrol_imsenterprise','truncatecoursecodes','0',NULL),(1402,2,1547810076,'enrol_imsenterprise','createnewcourses','0',NULL),(1403,2,1547810076,'enrol_imsenterprise','updatecourses','0',NULL),(1404,2,1547810076,'enrol_imsenterprise','createnewcategories','0',NULL),(1405,2,1547810076,'enrol_imsenterprise','nestedcategories','0',NULL),(1406,2,1547810076,'enrol_imsenterprise','categoryidnumber','0',NULL),(1407,2,1547810076,'enrol_imsenterprise','categoryseparator','',NULL),(1408,2,1547810076,'enrol_imsenterprise','imsunenrol','0',NULL),(1409,2,1547810076,'enrol_imsenterprise','imscoursemapshortname','coursecode',NULL),(1410,2,1547810076,'enrol_imsenterprise','imscoursemapfullname','short',NULL),(1411,2,1547810076,'enrol_imsenterprise','imscoursemapsummary','ignore',NULL),(1412,2,1547810076,'enrol_imsenterprise','imsrestricttarget','',NULL),(1413,2,1547810077,'enrol_imsenterprise','imscapitafix','0',NULL),(1414,2,1547810077,'enrol_manual','expiredaction','1',NULL),(1415,2,1547810077,'enrol_manual','expirynotifyhour','6',NULL),(1416,2,1547810077,'enrol_manual','defaultenrol','1',NULL),(1417,2,1547810077,'enrol_manual','status','0',NULL),(1418,2,1547810077,'enrol_manual','roleid','5',NULL),(1419,2,1547810077,'enrol_manual','enrolstart','4',NULL),(1420,2,1547810077,'enrol_manual','enrolperiod','0',NULL),(1421,2,1547810077,'enrol_manual','expirynotify','0',NULL),(1422,2,1547810077,'enrol_manual','expirythreshold','86400',NULL),(1423,2,1547810077,'enrol_mnet','roleid','5',NULL),(1424,2,1547810077,'enrol_mnet','roleid_adv','1',NULL),(1425,2,1547810078,'enrol_paypal','paypalbusiness','',NULL),(1426,2,1547810078,'enrol_paypal','mailstudents','0',NULL),(1427,2,1547810078,'enrol_paypal','mailteachers','0',NULL),(1428,2,1547810078,'enrol_paypal','mailadmins','0',NULL),(1429,2,1547810078,'enrol_paypal','expiredaction','3',NULL),(1430,2,1547810078,'enrol_paypal','status','1',NULL),(1431,2,1547810078,'enrol_paypal','cost','0',NULL),(1432,2,1547810078,'enrol_paypal','currency','USD',NULL),(1433,2,1547810078,'enrol_paypal','roleid','5',NULL),(1434,2,1547810078,'enrol_paypal','enrolperiod','0',NULL),(1435,2,1547810078,'enrol_lti','emaildisplay','2',NULL),(1436,2,1547810078,'enrol_lti','city','',NULL),(1437,2,1547810079,'enrol_lti','country','',NULL),(1438,2,1547810079,'enrol_lti','timezone','99',NULL),(1439,2,1547810079,'enrol_lti','lang','id',NULL),(1440,2,1547810079,'enrol_lti','institution','',NULL),(1441,2,1547810079,'enrol_self','requirepassword','0',NULL),(1442,2,1547810079,'enrol_self','usepasswordpolicy','0',NULL),(1443,2,1547810079,'enrol_self','showhint','0',NULL),(1444,2,1547810079,'enrol_self','expiredaction','1',NULL),(1445,2,1547810079,'enrol_self','expirynotifyhour','6',NULL),(1446,2,1547810079,'enrol_self','defaultenrol','1',NULL),(1447,2,1547810079,'enrol_self','status','1',NULL),(1448,2,1547810079,'enrol_self','newenrols','1',NULL),(1449,2,1547810079,'enrol_self','groupkey','0',NULL),(1450,2,1547810080,'enrol_self','roleid','5',NULL),(1451,2,1547810080,'enrol_self','enrolperiod','0',NULL),(1452,2,1547810080,'enrol_self','expirynotify','0',NULL),(1453,2,1547810080,'enrol_self','expirythreshold','86400',NULL),(1454,2,1547810080,'enrol_self','longtimenosee','0',NULL),(1455,2,1547810080,'enrol_self','maxenrolled','0',NULL),(1456,2,1547810080,'enrol_self','sendcoursewelcomemessage','1',NULL),(1457,2,1547810080,'filter_urltolink','formats','0',NULL),(1458,2,1547810080,'filter_urltolink','embedimages','1',NULL),(1459,2,1547810080,'filter_emoticon','formats','1,4,0',NULL),(1460,2,1547810080,'filter_mathjaxloader','httpsurl','https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.2/MathJax.js',NULL),(1461,2,1547810080,'filter_mathjaxloader','texfiltercompatibility','0',NULL),(1462,2,1547810080,'filter_mathjaxloader','mathjaxconfig','\nMathJax.Hub.Config({\n    config: [\"Accessible.js\", \"Safe.js\"],\n    errorSettings: { message: [\"!\"] },\n    skipStartupTypeset: true,\n    messageStyle: \"none\"\n});\n',NULL),(1463,2,1547810081,'filter_mathjaxloader','additionaldelimiters','',NULL),(1464,2,1547810081,NULL,'filter_multilang_force_old','0',NULL),(1465,2,1547810081,'filter_tex','latexpreamble','\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n',NULL),(1466,2,1547810081,'filter_tex','latexbackground','#FFFFFF',NULL),(1467,2,1547810081,'filter_tex','density','120',NULL),(1468,2,1547810081,'filter_tex','pathlatex','/usr/bin/latex',NULL),(1469,2,1547810081,'filter_tex','pathdvips','/usr/bin/dvips',NULL),(1470,2,1547810081,'filter_tex','pathconvert','/usr/bin/convert',NULL),(1471,2,1547810081,'filter_tex','pathdvisvgm','/usr/bin/dvisvgm',NULL),(1472,2,1547810081,'filter_tex','pathmimetex','',NULL),(1473,2,1547810081,'filter_tex','convertformat','gif',NULL),(1474,2,1547810081,NULL,'filter_censor_badwords','',NULL),(1475,2,1547810081,'qtype_multichoice','answerhowmany','1',NULL),(1476,2,1547810082,'qtype_multichoice','shuffleanswers','1',NULL),(1477,2,1547810082,'qtype_multichoice','answernumbering','abc',NULL),(1478,2,1547810082,NULL,'profileroles','5,4,3',NULL),(1479,2,1547810082,NULL,'coursecontact','3',NULL),(1480,2,1547810082,NULL,'frontpage','6',NULL),(1481,2,1547810082,NULL,'frontpageloggedin','6',NULL),(1482,2,1547810082,NULL,'maxcategorydepth','2',NULL),(1483,2,1547810082,NULL,'frontpagecourselimit','200',NULL),(1484,2,1547810082,NULL,'commentsperpage','15',NULL),(1485,2,1547810082,NULL,'defaultfrontpageroleid','8',NULL),(1486,2,1547810082,NULL,'messageinbound_enabled','0',NULL),(1487,2,1547810083,NULL,'messageinbound_mailbox','',NULL),(1488,2,1547810083,NULL,'messageinbound_domain','',NULL),(1489,2,1547810083,NULL,'messageinbound_host','',NULL),(1490,2,1547810083,NULL,'messageinbound_hostssl','ssl',NULL),(1491,2,1547810083,NULL,'messageinbound_hostuser','',NULL),(1492,2,1547810083,NULL,'messageinbound_hostpass','',NULL),(1493,2,1547810083,NULL,'enablemobilewebservice','0',NULL),(1494,2,1547810083,'tool_mobile','apppolicy','',NULL),(1495,2,1547810149,NULL,'timezone','Asia/Jakarta',NULL),(1496,2,1547810149,NULL,'registerauth','',NULL),(1497,2,1547810178,NULL,'noreplyaddress','hr-assessment@halinda.com',NULL),(1498,2,1547819222,NULL,'bigbluebuttonbn_server_url','http://test-install.blindsidenetworks.com/bigbluebutton/',NULL),(1499,2,1547819222,NULL,'bigbluebuttonbn_shared_secret','8cd8ef52e8e101574e400365b55e11a6',NULL),(1500,2,1547819223,NULL,'bigbluebuttonbn_recording_default','1',NULL),(1501,2,1547819223,NULL,'bigbluebuttonbn_recording_editable','1',NULL),(1502,2,1547819223,NULL,'bigbluebuttonbn_recording_icons_enabled','1',NULL),(1503,2,1547819223,NULL,'bigbluebuttonbn_importrecordings_enabled','0',NULL),(1504,2,1547819223,NULL,'bigbluebuttonbn_importrecordings_from_deleted_enabled','0',NULL),(1505,2,1547819223,NULL,'bigbluebuttonbn_recordings_html_default','1',NULL),(1506,2,1547819224,NULL,'bigbluebuttonbn_recordings_html_editable','0',NULL),(1507,2,1547819224,NULL,'bigbluebuttonbn_recordings_deleted_default','1',NULL),(1508,2,1547819224,NULL,'bigbluebuttonbn_recordings_deleted_editable','0',NULL),(1509,2,1547819224,NULL,'bigbluebuttonbn_recordings_imported_default','0',NULL),(1510,2,1547819224,NULL,'bigbluebuttonbn_recordings_imported_editable','1',NULL),(1511,2,1547819224,NULL,'bigbluebuttonbn_recordings_preview_default','1',NULL),(1512,2,1547819224,NULL,'bigbluebuttonbn_recordings_preview_editable','0',NULL),(1513,2,1547819224,NULL,'bigbluebuttonbn_waitformoderator_default','0',NULL),(1514,2,1547819224,NULL,'bigbluebuttonbn_waitformoderator_editable','1',NULL),(1515,2,1547819224,NULL,'bigbluebuttonbn_waitformoderator_ping_interval','10',NULL),(1516,2,1547819225,NULL,'bigbluebuttonbn_waitformoderator_cache_ttl','60',NULL),(1517,2,1547819225,NULL,'bigbluebuttonbn_voicebridge_editable','0',NULL),(1518,2,1547819225,NULL,'bigbluebuttonbn_preuploadpresentation_enabled','0',NULL),(1519,2,1547819225,NULL,'bigbluebuttonbn_userlimit_default','0',NULL),(1520,2,1547819225,NULL,'bigbluebuttonbn_userlimit_editable','0',NULL),(1521,2,1547819225,NULL,'bigbluebuttonbn_participant_moderator_default','0',NULL),(1522,2,1547819225,NULL,'bigbluebuttonbn_sendnotifications_enabled','1',NULL),(1523,2,1547819225,NULL,'bigbluebuttonbn_recordingready_enabled','0',NULL),(1524,2,1547819225,NULL,'bigbluebuttonbn_meetingevents_enabled','0',NULL),(1525,2,1548771993,'theme_more','backgroundimage','/background.jpg',''),(1526,2,1548772195,NULL,'themedesignermode','1','0'),(1527,2,1548772195,NULL,'allowuserthemes','1','0'),(1528,2,1548772195,NULL,'allowcoursethemes','1','0'),(1529,2,1548772196,NULL,'allowcategorythemes','1','0'),(1530,2,1548772196,NULL,'allowcohortthemes','1','0'),(1531,2,1548772196,NULL,'customusermenuitems','grades,grades|/grade/report/mygrades.php|t/grades\r\nmessages,message|/message/index.php|t/message\r\npreferences,moodle|/user/preferences.php|t/preferences','grades,grades|/grade/report/mygrades.php|t/grades\nmessages,message|/message/index.php|t/message\npreferences,moodle|/user/preferences.php|t/preferences'),(1532,2,1548772279,'theme_boost','brandcolor','#3200E6',''),(1533,2,1548772279,'theme_more','linkcolor','#1C00C8','#FF6500'),(1534,2,1548772279,'theme_more','bodybackground','#FFB7DA',''),(1535,2,1548772279,'theme_more','contentbackground','#E2FA0A','#FFFFFF'),(1536,2,1548772279,'theme_more','secondarybackground','#AAC6FD','#FFFFFF'),(1537,2,1548772789,'theme_adaptable','maincolor','#3A454b',NULL),(1538,2,1548772789,'theme_adaptable','backcolor','#FFF',NULL),(1539,2,1548772790,'theme_adaptable','regionmaincolor','#FFF',NULL),(1540,2,1548772790,'theme_adaptable','linkcolor','#51666C',NULL),(1541,2,1548772790,'theme_adaptable','linkhover','#009688',NULL),(1542,2,1548772790,'theme_adaptable','selectiontext','#000000',NULL),(1543,2,1548772790,'theme_adaptable','selectionbackground','#00B3A1',NULL),(1544,2,1548772790,'theme_adaptable','loadingcolor','#00B3A1',NULL),(1545,2,1548772790,'theme_adaptable','msgbadgecolor','#E53935',NULL),(1546,2,1548772791,'theme_adaptable','messagingbackgroundcolor','#FFFFFF',NULL),(1547,2,1548772791,'theme_adaptable','headerbkcolor','#00796B',NULL),(1548,2,1548772791,'theme_adaptable','headertextcolor','#ffffff',NULL),(1549,2,1548772791,'theme_adaptable','headerbkcolor2','#009688',NULL),(1550,2,1548772791,'theme_adaptable','headertextcolor2','#ffffff',NULL),(1551,2,1548772792,'theme_adaptable','menubkcolor','#ffffff',NULL),(1552,2,1548772792,'theme_adaptable','menufontcolor','#222222',NULL),(1553,2,1548772792,'theme_adaptable','menuhovercolor','#00B3A1',NULL),(1554,2,1548772792,'theme_adaptable','menubordercolor','#00B3A1',NULL),(1555,2,1548772792,'theme_adaptable','mobilemenubkcolor','#F9F9F9',NULL),(1556,2,1548772792,'theme_adaptable','mobilemenufontcolor','#000000',NULL),(1557,2,1548772792,'theme_adaptable','marketblockbordercolor','#e8eaeb',NULL),(1558,2,1548772792,'theme_adaptable','marketblocksbackgroundcolor','transparent',NULL),(1559,2,1548772793,'theme_adaptable','rendereroverlaycolor','#3A454b',NULL),(1560,2,1548772793,'theme_adaptable','rendereroverlayfontcolor','#FFF',NULL),(1561,2,1548772793,'theme_adaptable','tilesbordercolor','#3A454b',NULL),(1562,2,1548772793,'theme_adaptable','covbkcolor','#3A454b',NULL),(1563,2,1548772793,'theme_adaptable','covfontcolor','#ffffff',NULL),(1564,2,1548772793,'theme_adaptable','dividingline','#ffffff',NULL),(1565,2,1548772793,'theme_adaptable','dividingline2','#ffffff',NULL),(1566,2,1548772793,'theme_adaptable','breadcrumb','#f5f5f5',NULL),(1567,2,1548772793,'theme_adaptable','breadcrumbtextcolor','#444444',NULL),(1568,2,1548772794,'theme_adaptable','messagepopupbackground','#fff000',NULL),(1569,2,1548772794,'theme_adaptable','messagepopupcolor','#333333',NULL),(1570,2,1548772794,'theme_adaptable','footerbkcolor','#424242',NULL),(1571,2,1548772794,'theme_adaptable','footertextcolor','#ffffff',NULL),(1572,2,1548772794,'theme_adaptable','footertextcolor2','#ffffff',NULL),(1573,2,1548772794,'theme_adaptable','footerlinkcolor','#ffffff',NULL),(1574,2,1548772794,'theme_adaptable','forumheaderbackgroundcolor','#ffffff',NULL),(1575,2,1548772794,'theme_adaptable','forumbodybackgroundcolor','#ffffff',NULL),(1576,2,1548772794,'theme_adaptable','fontname','Open Sans',NULL),(1577,2,1548772795,'theme_adaptable','fontsubset','',NULL),(1578,2,1548772795,'theme_adaptable','fontsize','95%',NULL),(1579,2,1548772795,'theme_adaptable','fontweight','400',NULL),(1580,2,1548772795,'theme_adaptable','fontcolor','#333333',NULL),(1581,2,1548772795,'theme_adaptable','topmenufontsize','14px',NULL),(1582,2,1548772795,'theme_adaptable','menufontsize','14px',NULL),(1583,2,1548772795,'theme_adaptable','menufontpadding','20px',NULL),(1584,2,1548772795,'theme_adaptable','fontheadername','Roboto',NULL),(1585,2,1548772796,'theme_adaptable','fontheaderweight','400',NULL),(1586,2,1548772796,'theme_adaptable','fontheadercolor','#333333',NULL),(1587,2,1548772796,'theme_adaptable','fonttitlename','Roboto Condensed',NULL),(1588,2,1548772796,'theme_adaptable','fonttitlesize','48px',NULL),(1589,2,1548772796,'theme_adaptable','fonttitleweight','400',NULL),(1590,2,1548772796,'theme_adaptable','fonttitlecolor','#ffffff',NULL),(1591,2,1548772796,'theme_adaptable','fonttitlecolorcourse','#ffffff',NULL),(1592,2,1548772797,'theme_adaptable','buttonradius','5px',NULL),(1593,2,1548772797,'theme_adaptable','buttoncolor','#51666C',NULL),(1594,2,1548772797,'theme_adaptable','buttonhovercolor','#009688',NULL),(1595,2,1548772797,'theme_adaptable','buttontextcolor','#ffffff',NULL),(1596,2,1548772797,'theme_adaptable','editonbk','#4caf50',NULL),(1597,2,1548772797,'theme_adaptable','editoffbk','#f44336',NULL),(1598,2,1548772798,'theme_adaptable','editfont','#ffffff',NULL),(1599,2,1548772798,'theme_adaptable','editverticalpadding','4px',NULL),(1600,2,1548772798,'theme_adaptable','edithorizontalpadding','6px',NULL),(1601,2,1548772798,'theme_adaptable','edittopmargin','1px',NULL),(1602,2,1548772798,'theme_adaptable','buttonlogincolor','#ef5350',NULL),(1603,2,1548772798,'theme_adaptable','buttonloginhovercolor','#e53935',NULL),(1604,2,1548772798,'theme_adaptable','buttonlogintextcolor','#FFFFFF',NULL),(1605,2,1548772798,'theme_adaptable','buttonloginpadding','0px',NULL),(1606,2,1548772798,'theme_adaptable','buttonloginheight','24px',NULL),(1607,2,1548772799,'theme_adaptable','buttonloginmargintop','2px',NULL),(1608,2,1548772799,'theme_adaptable','buttoncancelbackgroundcolor','#d8d5d5',NULL),(1609,2,1548772799,'theme_adaptable','buttoncancelcolor','#1d1c1c',NULL),(1610,2,1548772799,'theme_adaptable','buttondropshadow','0px',NULL),(1611,2,1548772799,'theme_adaptable','headerbgimage','',NULL),(1612,2,1548772799,'theme_adaptable','frontpagelogin','1',NULL),(1613,2,1548772799,'theme_adaptable','displaylogin','button',NULL),(1614,2,1548772799,'theme_adaptable','enablemessagemenu','1',NULL),(1615,2,1548772800,'theme_adaptable','filteradminmessages','',NULL),(1616,2,1548772800,'theme_adaptable','logo','',NULL),(1617,2,1548772800,'theme_adaptable','pageheaderheight','72px',NULL),(1618,2,1548772800,'theme_adaptable','coursepageheaderhidesitetitle','0',NULL),(1619,2,1548772800,'theme_adaptable','favicon','',NULL),(1620,2,1548772800,'theme_adaptable','sitetitle','default',NULL),(1621,2,1548772800,'theme_adaptable','sitetitletext','         ',NULL),(1622,2,1548772800,'theme_adaptable','enableheading','fullname',NULL),(1623,2,1548772801,'theme_adaptable','sitetitlepaddingtop','0px',NULL),(1624,2,1548772801,'theme_adaptable','sitetitlepaddingleft','0px',NULL),(1625,2,1548772801,'theme_adaptable','sitetitlemaxwidth','50%',NULL),(1626,2,1548772801,'theme_adaptable','coursetitlemaxwidth','20',NULL),(1627,2,1548772801,'theme_adaptable','breadcrumbhome','icon',NULL),(1628,2,1548772801,'theme_adaptable','breadcrumbseparator','angle-right',NULL),(1629,2,1548772801,'theme_adaptable','socialorsearch','search',NULL),(1630,2,1548772802,'theme_adaptable','searchboxpadding','15px 0px 0px 0px',NULL),(1631,2,1548772802,'theme_adaptable','enablesavecanceloverlay','1',NULL),(1632,2,1548772802,'theme_adaptable','enablemenus','1',NULL),(1633,2,1548772802,'theme_adaptable','menuslinkright','1',NULL),(1634,2,1548772802,'theme_adaptable','disablemenuscoursepages','1',NULL),(1635,2,1548772802,'theme_adaptable','menusession','1',NULL),(1636,2,1548772803,'theme_adaptable','menusessionttl','30',NULL),(1637,2,1548772803,'theme_adaptable','menuuseroverride','',NULL),(1638,2,1548772803,'theme_adaptable','menuoverrideprofilefield','topmenusettings',NULL),(1639,2,1548772803,'theme_adaptable','topmenuscount','1',NULL),(1640,2,1548772803,'theme_adaptable','newmenu1title','Menu 1',NULL),(1641,2,1548772803,'theme_adaptable','newmenu1','',NULL),(1642,2,1548772803,'theme_adaptable','newmenu1requirelogin','',NULL),(1643,2,1548772804,'theme_adaptable','newmenu1field','',NULL),(1644,2,1548772804,'theme_adaptable','hideinforum','',NULL),(1645,2,1548772804,'theme_adaptable','enablemy','1',NULL),(1646,2,1548772804,'theme_adaptable','enableprofile','1',NULL),(1647,2,1548772804,'theme_adaptable','enableeditprofile','1',NULL),(1648,2,1548772804,'theme_adaptable','enablecalendar','1',NULL),(1649,2,1548772804,'theme_adaptable','enableprivatefiles','',NULL),(1650,2,1548772804,'theme_adaptable','enablegrades','1',NULL),(1651,2,1548772804,'theme_adaptable','enablebadges','',NULL),(1652,2,1548772804,'theme_adaptable','enablepref','1',NULL),(1653,2,1548772805,'theme_adaptable','enablenote','',NULL),(1654,2,1548772805,'theme_adaptable','enableblog','',NULL),(1655,2,1548772805,'theme_adaptable','enableposts','',NULL),(1656,2,1548772805,'theme_adaptable','enablefeed','',NULL),(1657,2,1548772805,'theme_adaptable','socialsize','32px',NULL),(1658,2,1548772805,'theme_adaptable','socialsizemobile','22px',NULL),(1659,2,1548772805,'theme_adaptable','socialpaddingtop','0%',NULL),(1660,2,1548772805,'theme_adaptable','socialtarget','_self',NULL),(1661,2,1548772805,'theme_adaptable','socialiconlist','',NULL),(1662,2,1548772806,'theme_adaptable','stickynavbar','1',NULL),(1663,2,1548772806,'theme_adaptable','enablehome','1',NULL),(1664,2,1548772806,'theme_adaptable','enablehomeredirect','1',NULL),(1665,2,1548772806,'theme_adaptable','enablemyhome','1',NULL),(1666,2,1548772806,'theme_adaptable','enableevents','1',NULL),(1667,2,1548772806,'theme_adaptable','enablethiscourse','1',NULL),(1668,2,1548772806,'theme_adaptable','enablezoom','1',NULL),(1669,2,1548772806,'theme_adaptable','enableshowhideblocks','1',NULL),(1670,2,1548772806,'theme_adaptable','enablenavbarwhenloggedout','',NULL),(1671,2,1548772807,'theme_adaptable','navbardisplayicons','1',NULL),(1672,2,1548772807,'theme_adaptable','navbardisplaysubmenuarrow','',NULL),(1673,2,1548772807,'theme_adaptable','navbardropdownborderradius','0px',NULL),(1674,2,1548772807,'theme_adaptable','navbardropdownhovercolor','#EEE',NULL),(1675,2,1548772807,'theme_adaptable','navbardropdowntransitiontime','0.2s',NULL),(1676,2,1548772807,'theme_adaptable','enablemysites','excludehidden',NULL),(1677,2,1548772807,'theme_adaptable','enablemysitesrestriction','',NULL),(1678,2,1548772808,'theme_adaptable','mycoursesmenulimit','20',NULL),(1679,2,1548772808,'theme_adaptable','mysitesmaxlength','30',NULL),(1680,2,1548772808,'theme_adaptable','mysitessortoverride','off',NULL),(1681,2,1548772808,'theme_adaptable','mysitessortoverridefield','',NULL),(1682,2,1548772808,'theme_adaptable','mysitesmenudisplay','shortcodehover',NULL),(1683,2,1548772808,'theme_adaptable','displayparticipants','1',NULL),(1684,2,1548772808,'theme_adaptable','displaygrades','1',NULL),(1685,2,1548772808,'theme_adaptable','enablehelp','',NULL),(1686,2,1548772808,'theme_adaptable','helpprofilefield','',NULL),(1687,2,1548772809,'theme_adaptable','enablehelp2','',NULL),(1688,2,1548772809,'theme_adaptable','helpprofilefield2','',NULL),(1689,2,1548772809,'theme_adaptable','helptarget','_blank',NULL),(1690,2,1548772809,'theme_adaptable','disablecustommenu','',NULL),(1691,2,1548772809,'theme_adaptable','enabletoolsmenus','',NULL),(1692,2,1548772809,'theme_adaptable','toolsmenuscount','1',NULL),(1693,2,1548772809,'theme_adaptable','toolsmenu1title','Tools',NULL),(1694,2,1548772809,'theme_adaptable','toolsmenu1','',NULL),(1695,2,1548772809,'theme_adaptable','toolsmenu1field','',NULL),(1696,2,1548772810,'theme_adaptable','enablealerts','',NULL),(1697,2,1548772810,'theme_adaptable','enablealertcoursepages','',NULL),(1698,2,1548772810,'theme_adaptable','alerthiddencourse','warning',NULL),(1699,2,1548772810,'theme_adaptable','enablealertstriptags','1',NULL),(1700,2,1548772810,'theme_adaptable','alertcount','1',NULL),(1701,2,1548772810,'theme_adaptable','enablealert1','',NULL),(1702,2,1548772810,'theme_adaptable','alertkey1','',NULL),(1703,2,1548772810,'theme_adaptable','alerttext1','         ',NULL),(1704,2,1548772810,'theme_adaptable','alerttype1','info',NULL),(1705,2,1548772811,'theme_adaptable','alertaccess1','global',NULL),(1706,2,1548772811,'theme_adaptable','alertprofilefield1','',NULL),(1707,2,1548772811,'theme_adaptable','alertcolorinfo','#3a87ad',NULL),(1708,2,1548772811,'theme_adaptable','alertbackgroundcolorinfo','#d9edf7',NULL),(1709,2,1548772811,'theme_adaptable','alertbordercolorinfo','#bce8f1',NULL),(1710,2,1548772811,'theme_adaptable','alerticoninfo','info-circle',NULL),(1711,2,1548772811,'theme_adaptable','alertcolorsuccess','#468847',NULL),(1712,2,1548772812,'theme_adaptable','alertbackgroundcolorsuccess','#dff0d8',NULL),(1713,2,1548772812,'theme_adaptable','alertbordercolorsuccess','#d6e9c6',NULL),(1714,2,1548772812,'theme_adaptable','alerticonsuccess','bullhorn',NULL),(1715,2,1548772812,'theme_adaptable','alertcolorwarning','#8a6d3b',NULL),(1716,2,1548772812,'theme_adaptable','alertbackgroundcolorwarning','#fcf8e3',NULL),(1717,2,1548772812,'theme_adaptable','alertbordercolorwarning','#fbeed5',NULL),(1718,2,1548772812,'theme_adaptable','alerticonwarning','exclamation-triangle',NULL),(1719,2,1548772813,'theme_adaptable','blockbackgroundcolor','#FFFFFF',NULL),(1720,2,1548772813,'theme_adaptable','blockheaderbackgroundcolor','#FFFFFF',NULL),(1721,2,1548772813,'theme_adaptable','blockbordercolor','#59585D',NULL),(1722,2,1548772814,'theme_adaptable','blockregionbackgroundcolor','transparent',NULL),(1723,2,1548772814,'theme_adaptable','blockheaderbordertopstyle','dashed',NULL),(1724,2,1548772814,'theme_adaptable','blockheadertopradius','0px',NULL),(1725,2,1548772814,'theme_adaptable','blockheaderbottomradius','0px',NULL),(1726,2,1548772814,'theme_adaptable','blockheaderbordertop','1px',NULL),(1727,2,1548772814,'theme_adaptable','blockheaderborderleft','0px',NULL),(1728,2,1548772814,'theme_adaptable','blockheaderborderright','0px',NULL),(1729,2,1548772814,'theme_adaptable','blockheaderborderbottom','0px',NULL),(1730,2,1548772815,'theme_adaptable','blockmainbordertopstyle','none',NULL),(1731,2,1548772815,'theme_adaptable','blockmaintopradius','0px',NULL),(1732,2,1548772815,'theme_adaptable','blockmainbottomradius','0px',NULL),(1733,2,1548772815,'theme_adaptable','blockmainbordertop','0px',NULL),(1734,2,1548772815,'theme_adaptable','blockmainborderleft','0px',NULL),(1735,2,1548772815,'theme_adaptable','blockmainborderright','0px',NULL),(1736,2,1548772815,'theme_adaptable','blockmainborderbottom','0px',NULL),(1737,2,1548772816,'theme_adaptable','fontblockheadersize','22px',NULL),(1738,2,1548772816,'theme_adaptable','fontblockheaderweight','400',NULL),(1739,2,1548772816,'theme_adaptable','fontblockheadercolor','#3A454b',NULL),(1740,2,1548772816,'theme_adaptable','blockicons','1',NULL),(1741,2,1548772816,'theme_adaptable','blockiconsheadersize','20px',NULL),(1742,2,1548772816,'theme_adaptable','frontpageblocksenabled','0',NULL),(1743,2,1548772817,'theme_adaptable','blocklayoutlayoutrow1','3-3-3-3',NULL),(1744,2,1548772817,'theme_adaptable','blocklayoutlayoutrow2','4-4-4-0',NULL),(1745,2,1548772817,'theme_adaptable','blocklayoutlayoutrow3','3-3-3-3',NULL),(1746,2,1548772817,'theme_adaptable','blocklayoutlayoutrow4','0-0-0-0',NULL),(1747,2,1548772817,'theme_adaptable','blocklayoutlayoutrow5','0-0-0-0',NULL),(1748,2,1548772817,'theme_adaptable','blocklayoutlayoutrow6','0-0-0-0',NULL),(1749,2,1548772817,'theme_adaptable','blocklayoutlayoutrow7','0-0-0-0',NULL),(1750,2,1548772818,'theme_adaptable','blocklayoutlayoutrow8','0-0-0-0',NULL),(1751,2,1548772818,'theme_adaptable','infobox','         ',NULL),(1752,2,1548772818,'theme_adaptable','infobox2','         ',NULL),(1753,2,1548772818,'theme_adaptable','infoboxfullscreen','',NULL),(1754,2,1548772818,'theme_adaptable','frontpagemarketenabled','',NULL),(1755,2,1548772818,'theme_adaptable','frontpagemarketoption','covtiles',NULL),(1756,2,1548772818,'theme_adaptable','marketlayoutrow1','3-3-3-3',NULL),(1757,2,1548772818,'theme_adaptable','marketlayoutrow2','0-0-0-0',NULL),(1758,2,1548772819,'theme_adaptable','marketlayoutrow3','0-0-0-0',NULL),(1759,2,1548772819,'theme_adaptable','marketlayoutrow4','0-0-0-0',NULL),(1760,2,1548772819,'theme_adaptable','marketlayoutrow5','0-0-0-0',NULL),(1761,2,1548772819,'theme_adaptable','enableticker','1',NULL),(1762,2,1548772819,'theme_adaptable','enabletickermy','1',NULL),(1763,2,1548772819,'theme_adaptable','tickerwidth','',NULL),(1764,2,1548772819,'theme_adaptable','newstickercount','1',NULL),(1765,2,1548772819,'theme_adaptable','tickertext1','         ',NULL),(1766,2,1548772819,'theme_adaptable','tickertext1profilefield','',NULL),(1767,2,1548772819,'theme_adaptable','sliderenabled','0',NULL),(1768,2,1548772820,'theme_adaptable','sliderfullscreen','0',NULL),(1769,2,1548772820,'theme_adaptable','slidermargintop','20px',NULL),(1770,2,1548772820,'theme_adaptable','slidermarginbottom','20px',NULL),(1771,2,1548772820,'theme_adaptable','slideroption2','slider1',NULL),(1772,2,1548772820,'theme_adaptable','sliderh3color','#ffffff',NULL),(1773,2,1548772820,'theme_adaptable','sliderh4color','#ffffff',NULL),(1774,2,1548772820,'theme_adaptable','slidersubmitcolor','#ffffff',NULL),(1775,2,1548772820,'theme_adaptable','slidersubmitbgcolor','#51666C',NULL),(1776,2,1548772821,'theme_adaptable','slidercount','3',NULL),(1777,2,1548772821,'theme_adaptable','p1','',NULL),(1778,2,1548772821,'theme_adaptable','p1url','',NULL),(1779,2,1548772821,'theme_adaptable','p1cap','         ',NULL),(1780,2,1548772821,'theme_adaptable','p2','',NULL),(1781,2,1548772821,'theme_adaptable','p2url','',NULL),(1782,2,1548772821,'theme_adaptable','p2cap','         ',NULL),(1783,2,1548772821,'theme_adaptable','p3','',NULL),(1784,2,1548772821,'theme_adaptable','p3url','',NULL),(1785,2,1548772821,'theme_adaptable','p3cap','         ',NULL),(1786,2,1548772822,'theme_adaptable','frontpagerenderer','2',NULL),(1787,2,1548772822,'theme_adaptable','frontpagerendererdefaultimage','',NULL),(1788,2,1548772822,'theme_adaptable','tilesshowcontacts','1',NULL),(1789,2,1548772822,'theme_adaptable','tilesshowallcontacts','0',NULL),(1790,2,1548772822,'theme_adaptable','tilescontactstitle','1',NULL),(1791,2,1548772822,'theme_adaptable','covhidebutton','0',NULL),(1792,2,1548772822,'theme_adaptable','enableavailablecourses','none',NULL),(1793,2,1548772823,'theme_adaptable','moodledocs','1',NULL),(1794,2,1548772823,'theme_adaptable','footerblocksplacement','1',NULL),(1795,2,1548772823,'theme_adaptable','showfooterblocks','1',NULL),(1796,2,1548772823,'theme_adaptable','footerlayoutrow1','3-3-3-3',NULL),(1797,2,1548772823,'theme_adaptable','footerlayoutrow2','0-0-0-0',NULL),(1798,2,1548772823,'theme_adaptable','footerlayoutrow3','0-0-0-0',NULL),(1799,2,1548772824,'theme_adaptable','hidefootersocial','1',NULL),(1800,2,1548772824,'theme_adaptable','footnote','         ',NULL),(1801,2,1548772824,'theme_adaptable','homebk','',NULL),(1802,2,1548772824,'theme_adaptable','blockside','0',NULL),(1803,2,1548772824,'theme_adaptable','viewselect','1',NULL),(1804,2,1548772824,'theme_adaptable','fullscreenwidth','98%',NULL),(1805,2,1548772824,'theme_adaptable','emoticonsize','16px',NULL),(1806,2,1548772824,'theme_adaptable','dashblocksenabled','0',NULL),(1807,2,1548772824,'theme_adaptable','dashblocklayoutlayoutrow1','3-3-3-3',NULL),(1808,2,1548772824,'theme_adaptable','dashblocklayoutlayoutrow2','4-4-4-0',NULL),(1809,2,1548772825,'theme_adaptable','dashblocklayoutlayoutrow3','3-3-3-3',NULL),(1810,2,1548772825,'theme_adaptable','dashblocklayoutlayoutrow4','0-0-0-0',NULL),(1811,2,1548772825,'theme_adaptable','dashblocklayoutlayoutrow5','0-0-0-0',NULL),(1812,2,1548772825,'theme_adaptable','dashblocklayoutlayoutrow6','0-0-0-0',NULL),(1813,2,1548772825,'theme_adaptable','dashblocklayoutlayoutrow7','0-0-0-0',NULL),(1814,2,1548772825,'theme_adaptable','dashblocklayoutlayoutrow8','0-0-0-0',NULL),(1815,2,1548772825,'theme_adaptable','coursepagesidebarinfooterenabled','0',NULL),(1816,2,1548772825,'theme_adaptable','showyourprogress','',NULL),(1817,2,1548772826,'theme_adaptable','coursepageblocksliderenabled','0',NULL),(1818,2,1548772826,'theme_adaptable','coursepageblockactivitybottomenabled','0',NULL),(1819,2,1548772826,'theme_adaptable','coursepageblocksenabled','0',NULL),(1820,2,1548772826,'theme_adaptable','coursepageblocklayoutlayouttoprow1','3-3-3-3',NULL),(1821,2,1548772826,'theme_adaptable','coursepageblocklayoutlayoutbottomrow2','3-3-3-3',NULL),(1822,2,1548772826,'theme_adaptable','coursesectionbgcolor','#FFFFFF',NULL),(1823,2,1548772826,'theme_adaptable','coursesectionheaderbg','#FFFFFF',NULL),(1824,2,1548772827,'theme_adaptable','sectionheadingcolor','#3A454b',NULL),(1825,2,1548772827,'theme_adaptable','currentcolor','#d2f2ef',NULL),(1826,2,1548772827,'theme_adaptable','coursesectionheaderborderstyle','none',NULL),(1827,2,1548772827,'theme_adaptable','coursesectionheaderbordercolor','#F3F3F3',NULL),(1828,2,1548772827,'theme_adaptable','coursesectionheaderborderwidth','0px',NULL),(1829,2,1548772827,'theme_adaptable','coursesectionheaderborderradiustop','0px',NULL),(1830,2,1548772827,'theme_adaptable','coursesectionheaderborderradiusbottom','0px',NULL),(1831,2,1548772827,'theme_adaptable','coursesectionborderstyle','solid',NULL),(1832,2,1548772828,'theme_adaptable','coursesectionborderwidth','1px',NULL),(1833,2,1548772828,'theme_adaptable','coursesectionbordercolor','#e8eaeb',NULL),(1834,2,1548772828,'theme_adaptable','coursesectionborderradius','0px',NULL),(1835,2,1548772828,'theme_adaptable','coursesectionactivityuseadaptableicons','1',NULL),(1836,2,1548772828,'theme_adaptable','coursesectionactivityiconsize','24px',NULL),(1837,2,1548772828,'theme_adaptable','coursesectionactivityborderwidth','2px',NULL),(1838,2,1548772828,'theme_adaptable','coursesectionactivityborderstyle','dashed',NULL),(1839,2,1548772829,'theme_adaptable','coursesectionactivitybordercolor','#eeeeee',NULL),(1840,2,1548772829,'theme_adaptable','coursesectionactivityleftborderwidth','3px',NULL),(1841,2,1548772829,'theme_adaptable','coursesectionactivityassignleftbordercolor','#0066cc',NULL),(1842,2,1548772829,'theme_adaptable','coursesectionactivityassignbgcolor','#FFFFFF',NULL),(1843,2,1548772829,'theme_adaptable','coursesectionactivityforumleftbordercolor','#990099',NULL),(1844,2,1548772829,'theme_adaptable','coursesectionactivityforumbgcolor','#FFFFFF',NULL),(1845,2,1548772829,'theme_adaptable','coursesectionactivityquizleftbordercolor','#FF3333',NULL),(1846,2,1548772829,'theme_adaptable','coursesectionactivityquizbgcolor','#FFFFFF',NULL),(1847,2,1548772829,'theme_adaptable','coursesectionactivitymargintop','2px',NULL),(1848,2,1548772830,'theme_adaptable','coursesectionactivitymarginbottom','2px',NULL),(1849,2,1548772830,'theme_adaptable','socialwallbackgroundcolor','#ffffff',NULL),(1850,2,1548772830,'theme_adaptable','socialwallbordercolor','#B9B9B9',NULL),(1851,2,1548772830,'theme_adaptable','socialwallbordertopstyle','solid',NULL),(1852,2,1548772830,'theme_adaptable','socialwallborderwidth','2px',NULL),(1853,2,1548772830,'theme_adaptable','socialwallsectionradius','6px',NULL),(1854,2,1548772830,'theme_adaptable','socialwallactionlinkcolor','#51666C',NULL),(1855,2,1548772830,'theme_adaptable','socialwallactionlinkhovercolor','#009688',NULL),(1856,2,1548772830,'theme_adaptable','coursesectionactivityfurtherinformationassign','1',NULL),(1857,2,1548772831,'theme_adaptable','coursesectionactivityfurtherinformationquiz','1',NULL),(1858,2,1548772831,'theme_adaptable','coursesectionactivityfurtherinformationchoice','1',NULL),(1859,2,1548772831,'theme_adaptable','coursesectionactivityfurtherinformationfeedback','1',NULL),(1860,2,1548772831,'theme_adaptable','coursesectionactivityfurtherinformationlesson','1',NULL),(1861,2,1548772831,'theme_adaptable','coursesectionactivityfurtherinformationdata','1',NULL),(1862,2,1548772831,'theme_adaptable','hidealertsmobile','0',NULL),(1863,2,1548772831,'theme_adaptable','hideheadermobile','1',NULL),(1864,2,1548772832,'theme_adaptable','hidesocialmobile','0',NULL),(1865,2,1548772832,'theme_adaptable','socialboxpaddingtopmobile','10px',NULL),(1866,2,1548772832,'theme_adaptable','socialboxpaddingbottommobile','10px',NULL),(1867,2,1548772832,'theme_adaptable','hidelogomobile','0',NULL),(1868,2,1548772832,'theme_adaptable','hidecoursetitlemobile','0',NULL),(1869,2,1548772832,'theme_adaptable','hideslidermobile','1',NULL),(1870,2,1548772833,'theme_adaptable','hidebreadcrumbmobile','0',NULL),(1871,2,1548772833,'theme_adaptable','hidepagefootermobile','0',NULL),(1872,2,1548772833,'theme_adaptable','enableanalytics','',NULL),(1873,2,1548772833,'theme_adaptable','anonymizega','1',NULL),(1874,2,1548772833,'theme_adaptable','analyticscount','1',NULL),(1875,2,1548772833,'theme_adaptable','piwikenabled','',NULL),(1876,2,1548772833,'theme_adaptable','piwiksiteid','1',NULL),(1877,2,1548772833,'theme_adaptable','piwikimagetrack','1',NULL),(1878,2,1548772834,'theme_adaptable','piwiksiteurl','',NULL),(1879,2,1548772834,'theme_adaptable','piwiktrackadmin','',NULL),(1880,2,1548772834,NULL,'theme_adaptable_putprops','',NULL),(1881,2,1548772834,'theme_adaptable','customcss','',NULL),(1882,2,1548772835,'theme_adaptable','jssection','',NULL),(1883,2,1548772835,'theme_adaptable','jssectionrestricted','',NULL),(1884,2,1548772835,'theme_adaptable','jssectionrestrictedprofilefield','',NULL),(1885,2,1548772835,'theme_adaptable','jssectionrestricteddashboardonly','1',NULL),(1886,2,1548772882,'theme_adaptable','analyticstext1','',NULL),(1887,2,1548772882,'theme_adaptable','analyticsprofilefield1','',NULL),(1888,2,1548773696,'theme_adaptable','headerbgimage','/cover new.jpg',''),(1889,2,1548773697,'theme_adaptable','favicon','/icons8-usb-connector-48.png',''),(1890,2,1548773697,'theme_adaptable','sitetitletext','','         '),(1891,2,1548773809,'theme_adaptable','headerbgimage','/DESIGN THINKING.jpg','/cover new.jpg'),(1892,2,1548773823,'theme_adaptable','sitetitletext','         ',''),(1893,2,1548780620,'theme_adaptable','headerbgimage','','/DESIGN THINKING.jpg'),(1894,2,1548780621,'theme_adaptable','sitetitletext','         \r\n         ','         '),(1895,2,1551237333,'theme_adaptable','market1','         ',NULL),(1896,2,1551237334,'theme_adaptable','market2','         ',NULL),(1897,2,1551237334,'theme_adaptable','market3','         ',NULL),(1898,2,1551237334,'theme_adaptable','market4','         ',NULL),(1899,2,1551237334,'theme_adaptable','footer1header','',NULL),(1900,2,1551237334,'theme_adaptable','footer1content','         ',NULL),(1901,2,1551237334,'theme_adaptable','footer2header','',NULL),(1902,2,1551237334,'theme_adaptable','footer2content','         ',NULL),(1903,2,1551237334,'theme_adaptable','footer3header','',NULL),(1904,2,1551237335,'theme_adaptable','footer3content','         ',NULL),(1905,2,1551237335,'theme_adaptable','footer4header','',NULL),(1906,2,1551237335,'theme_adaptable','footer4content','         ',NULL),(1907,2,1551238789,NULL,'themedesignermode','0','1'),(1908,2,1551238789,NULL,'allowuserthemes','0','1'),(1909,2,1551238789,NULL,'allowcoursethemes','0','1'),(1910,2,1551238789,NULL,'allowcategorythemes','0','1'),(1911,2,1551238789,NULL,'allowcohortthemes','0','1'),(1912,2,1551240635,NULL,'maintenance_enabled','1','0');
/*!40000 ALTER TABLE `mdl_config_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_config_plugins`
--

DROP TABLE IF EXISTS `mdl_config_plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_config_plugins` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `plugin` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'core',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_confplug_plunam_uix` (`plugin`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2149 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Moodle modules and plugins configuration variables';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_config_plugins`
--

LOCK TABLES `mdl_config_plugins` WRITE;
/*!40000 ALTER TABLE `mdl_config_plugins` DISABLE KEYS */;
INSERT INTO `mdl_config_plugins` VALUES (1,'question','multichoice_sortorder','1'),(2,'question','truefalse_sortorder','2'),(3,'question','match_sortorder','3'),(4,'question','shortanswer_sortorder','4'),(5,'question','numerical_sortorder','5'),(6,'question','essay_sortorder','6'),(7,'moodlecourse','visible','1'),(8,'moodlecourse','format','topics'),(9,'moodlecourse','maxsections','52'),(10,'moodlecourse','numsections','4'),(11,'moodlecourse','hiddensections','0'),(12,'moodlecourse','coursedisplay','0'),(13,'moodlecourse','courseenddateenabled','1'),(14,'moodlecourse','courseduration','31536000'),(15,'moodlecourse','lang',''),(16,'moodlecourse','newsitems','5'),(17,'moodlecourse','showgrades','1'),(18,'moodlecourse','showreports','0'),(19,'moodlecourse','maxbytes','0'),(20,'moodlecourse','enablecompletion','1'),(21,'moodlecourse','groupmode','0'),(22,'moodlecourse','groupmodeforce','0'),(23,'backup','loglifetime','30'),(24,'backup','backup_general_users','1'),(25,'backup','backup_general_users_locked',''),(26,'backup','backup_general_anonymize','0'),(27,'backup','backup_general_anonymize_locked',''),(28,'backup','backup_general_role_assignments','1'),(29,'backup','backup_general_role_assignments_locked',''),(30,'backup','backup_general_activities','1'),(31,'backup','backup_general_activities_locked',''),(32,'backup','backup_general_blocks','1'),(33,'backup','backup_general_blocks_locked',''),(34,'backup','backup_general_filters','1'),(35,'backup','backup_general_filters_locked',''),(36,'backup','backup_general_comments','1'),(37,'backup','backup_general_comments_locked',''),(38,'backup','backup_general_badges','1'),(39,'backup','backup_general_badges_locked',''),(40,'backup','backup_general_calendarevents','1'),(41,'backup','backup_general_calendarevents_locked',''),(42,'backup','backup_general_userscompletion','1'),(43,'backup','backup_general_userscompletion_locked',''),(44,'backup','backup_general_logs','0'),(45,'backup','backup_general_logs_locked',''),(46,'backup','backup_general_histories','0'),(47,'backup','backup_general_histories_locked',''),(48,'backup','backup_general_questionbank','1'),(49,'backup','backup_general_questionbank_locked',''),(50,'backup','backup_general_groups','1'),(51,'backup','backup_general_groups_locked',''),(52,'backup','backup_general_competencies','1'),(53,'backup','backup_general_competencies_locked',''),(54,'backup','import_general_maxresults','10'),(55,'backup','import_general_duplicate_admin_allowed','0'),(56,'backup','backup_import_activities','1'),(57,'backup','backup_import_activities_locked',''),(58,'backup','backup_import_blocks','1'),(59,'backup','backup_import_blocks_locked',''),(60,'backup','backup_import_filters','1'),(61,'backup','backup_import_filters_locked',''),(62,'backup','backup_import_calendarevents','1'),(63,'backup','backup_import_calendarevents_locked',''),(64,'backup','backup_import_questionbank','1'),(65,'backup','backup_import_questionbank_locked',''),(66,'backup','backup_import_groups','1'),(67,'backup','backup_import_groups_locked',''),(68,'backup','backup_import_competencies','1'),(69,'backup','backup_import_competencies_locked',''),(70,'backup','backup_auto_active','0'),(71,'backup','backup_auto_weekdays','0000000'),(72,'backup','backup_auto_hour','0'),(73,'backup','backup_auto_minute','0'),(74,'backup','backup_auto_storage','0'),(75,'backup','backup_auto_destination',''),(76,'backup','backup_auto_max_kept','1'),(77,'backup','backup_auto_delete_days','0'),(78,'backup','backup_auto_min_kept','0'),(79,'backup','backup_shortname','0'),(80,'backup','backup_auto_skip_hidden','1'),(81,'backup','backup_auto_skip_modif_days','30'),(82,'backup','backup_auto_skip_modif_prev','0'),(83,'backup','backup_auto_users','1'),(84,'backup','backup_auto_role_assignments','1'),(85,'backup','backup_auto_activities','1'),(86,'backup','backup_auto_blocks','1'),(87,'backup','backup_auto_filters','1'),(88,'backup','backup_auto_comments','1'),(89,'backup','backup_auto_badges','1'),(90,'backup','backup_auto_calendarevents','1'),(91,'backup','backup_auto_userscompletion','1'),(92,'backup','backup_auto_logs','0'),(93,'backup','backup_auto_histories','0'),(94,'backup','backup_auto_questionbank','1'),(95,'backup','backup_auto_groups','1'),(96,'backup','backup_auto_competencies','1'),(97,'restore','restore_general_users','1'),(98,'restore','restore_general_users_locked',''),(99,'restore','restore_general_enrolments','1'),(100,'restore','restore_general_enrolments_locked',''),(101,'restore','restore_general_role_assignments','1'),(102,'restore','restore_general_role_assignments_locked',''),(103,'restore','restore_general_activities','1'),(104,'restore','restore_general_activities_locked',''),(105,'restore','restore_general_blocks','1'),(106,'restore','restore_general_blocks_locked',''),(107,'restore','restore_general_filters','1'),(108,'restore','restore_general_filters_locked',''),(109,'restore','restore_general_comments','1'),(110,'restore','restore_general_comments_locked',''),(111,'restore','restore_general_badges','1'),(112,'restore','restore_general_badges_locked',''),(113,'restore','restore_general_calendarevents','1'),(114,'restore','restore_general_calendarevents_locked',''),(115,'restore','restore_general_userscompletion','1'),(116,'restore','restore_general_userscompletion_locked',''),(117,'restore','restore_general_logs','1'),(118,'restore','restore_general_logs_locked',''),(119,'restore','restore_general_histories','1'),(120,'restore','restore_general_histories_locked',''),(121,'restore','restore_general_groups','1'),(122,'restore','restore_general_groups_locked',''),(123,'restore','restore_general_competencies','1'),(124,'restore','restore_general_competencies_locked',''),(125,'restore','restore_merge_overwrite_conf','0'),(126,'restore','restore_merge_overwrite_conf_locked',''),(127,'restore','restore_merge_course_fullname','1'),(128,'restore','restore_merge_course_fullname_locked',''),(129,'restore','restore_merge_course_shortname','1'),(130,'restore','restore_merge_course_shortname_locked',''),(131,'restore','restore_merge_course_startdate','1'),(132,'restore','restore_merge_course_startdate_locked',''),(133,'restore','restore_replace_overwrite_conf','0'),(134,'restore','restore_replace_overwrite_conf_locked',''),(135,'restore','restore_replace_course_fullname','1'),(136,'restore','restore_replace_course_fullname_locked',''),(137,'restore','restore_replace_course_shortname','1'),(138,'restore','restore_replace_course_shortname_locked',''),(139,'restore','restore_replace_course_startdate','1'),(140,'restore','restore_replace_course_startdate_locked',''),(141,'restore','restore_replace_keep_roles_and_enrolments','0'),(142,'restore','restore_replace_keep_roles_and_enrolments_locked',''),(143,'restore','restore_replace_keep_groups_and_groupings','0'),(144,'restore','restore_replace_keep_groups_and_groupings_locked',''),(145,'analytics','predictionsprocessor','\\mlbackend_php\\processor'),(146,'analytics','timesplittings','\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range'),(147,'analytics','modeloutputdir','/var/www/moodledata/models'),(148,'analytics','onlycli','1'),(149,'analytics','modeltimelimit','1200'),(150,'core_competency','enabled','1'),(151,'core_competency','pushcourseratingstouserplans','1'),(152,'cachestore_apcu','testperformance','0'),(153,'cachestore_memcached','testservers',''),(154,'cachestore_mongodb','testserver',''),(155,'cachestore_redis','test_server',''),(156,'cachestore_redis','test_password',''),(157,'question_preview','behaviour','deferredfeedback'),(158,'question_preview','correctness','1'),(159,'question_preview','marks','2'),(160,'question_preview','markdp','2'),(161,'question_preview','feedback','1'),(162,'question_preview','generalfeedback','1'),(163,'question_preview','rightanswer','1'),(164,'question_preview','history','0'),(165,'tool_task','enablerunnow','1'),(166,'theme_boost','preset','default.scss'),(167,'theme_boost','presetfiles',''),(168,'theme_boost','backgroundimage',''),(169,'theme_boost','brandcolor','#3200E6'),(170,'theme_boost','scsspre',''),(171,'theme_boost','scss',''),(172,'theme_clean','invert','0'),(173,'theme_clean','logo',''),(174,'theme_clean','smalllogo',''),(175,'theme_clean','sitename','1'),(176,'theme_clean','customcss',''),(177,'theme_clean','footnote',''),(178,'theme_more','textcolor','#333366'),(179,'theme_more','linkcolor','#1C00C8'),(180,'theme_more','bodybackground','#FFB7DA'),(181,'theme_more','backgroundimage','/background.jpg'),(182,'theme_more','backgroundrepeat','repeat'),(183,'theme_more','backgroundposition','0'),(184,'theme_more','backgroundfixed','0'),(185,'theme_more','contentbackground','#E2FA0A'),(186,'theme_more','secondarybackground','#AAC6FD'),(187,'theme_more','invert','1'),(188,'theme_more','logo',''),(189,'theme_more','smalllogo',''),(190,'theme_more','sitename','1'),(191,'theme_more','customcss',''),(192,'theme_more','footnote',''),(193,'core_admin','logo',''),(194,'core_admin','logocompact',''),(195,'antivirus_clamav','version','2018120300'),(196,'availability_completion','version','2018120300'),(197,'availability_date','version','2018120300'),(198,'availability_grade','version','2018120300'),(199,'availability_group','version','2018120300'),(200,'availability_grouping','version','2018120300'),(201,'availability_profile','version','2018120300'),(202,'qtype_calculated','version','2018120300'),(203,'qtype_calculatedmulti','version','2018120300'),(204,'qtype_calculatedsimple','version','2018120300'),(205,'qtype_ddimageortext','version','2018120300'),(206,'qtype_ddmarker','version','2018120300'),(207,'qtype_ddwtos','version','2018120300'),(208,'qtype_description','version','2018120300'),(209,'qtype_essay','version','2018120300'),(210,'qtype_gapselect','version','2018120300'),(211,'qtype_match','version','2018120300'),(212,'qtype_missingtype','version','2018120300'),(213,'qtype_multianswer','version','2018120300'),(214,'qtype_multichoice','version','2018120300'),(215,'qtype_numerical','version','2018120300'),(216,'qtype_random','version','2018120301'),(217,'qtype_randomsamatch','version','2018120300'),(218,'qtype_shortanswer','version','2018120300'),(219,'qtype_truefalse','version','2018120300'),(220,'mod_assign','version','2018120300'),(221,'mod_assignment','version','2018120300'),(223,'mod_book','version','2018120300'),(224,'mod_chat','version','2018120300'),(225,'mod_choice','version','2018120300'),(226,'mod_data','version','2018120300'),(227,'mod_feedback','version','2018120300'),(229,'mod_folder','version','2018120300'),(231,'mod_forum','version','2018120300'),(232,'mod_glossary','version','2018120300'),(233,'mod_imscp','version','2018120300'),(235,'mod_label','version','2018120300'),(236,'mod_lesson','version','2018120300'),(237,'mod_lti','version','2018120300'),(238,'mod_page','version','2018120300'),(240,'mod_quiz','version','2018120300'),(241,'mod_resource','version','2018120300'),(242,'mod_scorm','version','2018120300'),(243,'mod_survey','version','2018120300'),(245,'mod_url','version','2018120300'),(247,'mod_wiki','version','2018120300'),(249,'mod_workshop','version','2018120300'),(250,'auth_cas','version','2018120300'),(252,'auth_db','version','2018120300'),(254,'auth_email','version','2018120300'),(255,'auth_ldap','version','2018120300'),(257,'auth_lti','version','2018120300'),(258,'auth_manual','version','2018120300'),(259,'auth_mnet','version','2018120300'),(261,'auth_nologin','version','2018120300'),(262,'auth_none','version','2018120300'),(263,'auth_oauth2','version','2018120300'),(264,'auth_shibboleth','version','2018120300'),(266,'auth_webservice','version','2018120300'),(267,'calendartype_gregorian','version','2018120300'),(268,'enrol_category','version','2018120300'),(270,'enrol_cohort','version','2018120300'),(271,'enrol_database','version','2018120300'),(273,'enrol_flatfile','version','2018120300'),(275,'enrol_flatfile','map_1','manager'),(276,'enrol_flatfile','map_2','coursecreator'),(277,'enrol_flatfile','map_3','editingteacher'),(278,'enrol_flatfile','map_4','teacher'),(279,'enrol_flatfile','map_5','student'),(280,'enrol_flatfile','map_6','guest'),(281,'enrol_flatfile','map_7','user'),(282,'enrol_flatfile','map_8','frontpage'),(283,'enrol_guest','version','2018120300'),(284,'enrol_imsenterprise','version','2018120300'),(286,'enrol_ldap','version','2018120300'),(288,'enrol_lti','version','2018120300'),(289,'enrol_manual','version','2018120300'),(291,'enrol_meta','version','2018120300'),(293,'enrol_mnet','version','2018120300'),(294,'enrol_paypal','version','2018120300'),(295,'enrol_self','version','2018120300'),(297,'message_airnotifier','version','2018120300'),(299,'message','airnotifier_provider_enrol_flatfile_flatfile_enrolment_permitted','permitted'),(300,'message','airnotifier_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted','permitted'),(301,'message','airnotifier_provider_enrol_manual_expiry_notification_permitted','permitted'),(302,'message','airnotifier_provider_enrol_paypal_paypal_enrolment_permitted','permitted'),(303,'message','airnotifier_provider_enrol_self_expiry_notification_permitted','permitted'),(304,'message','airnotifier_provider_mod_assign_assign_notification_permitted','permitted'),(305,'message','airnotifier_provider_mod_assignment_assignment_updates_permitted','permitted'),(306,'message','airnotifier_provider_mod_feedback_submission_permitted','permitted'),(307,'message','airnotifier_provider_mod_feedback_message_permitted','permitted'),(308,'message','airnotifier_provider_mod_forum_posts_permitted','permitted'),(309,'message','airnotifier_provider_mod_forum_digests_permitted','permitted'),(310,'message','airnotifier_provider_mod_lesson_graded_essay_permitted','permitted'),(311,'message','airnotifier_provider_mod_quiz_submission_permitted','permitted'),(312,'message','airnotifier_provider_mod_quiz_confirmation_permitted','permitted'),(313,'message','airnotifier_provider_mod_quiz_attempt_overdue_permitted','permitted'),(314,'message','airnotifier_provider_moodle_notices_permitted','permitted'),(315,'message','airnotifier_provider_moodle_errors_permitted','permitted'),(316,'message','airnotifier_provider_moodle_availableupdate_permitted','permitted'),(317,'message','airnotifier_provider_moodle_instantmessage_permitted','permitted'),(318,'message','airnotifier_provider_moodle_backup_permitted','permitted'),(319,'message','airnotifier_provider_moodle_courserequested_permitted','permitted'),(320,'message','airnotifier_provider_moodle_courserequestapproved_permitted','permitted'),(321,'message','airnotifier_provider_moodle_courserequestrejected_permitted','permitted'),(322,'message','airnotifier_provider_moodle_badgerecipientnotice_permitted','permitted'),(323,'message','airnotifier_provider_moodle_badgecreatornotice_permitted','permitted'),(324,'message','airnotifier_provider_moodle_competencyplancomment_permitted','permitted'),(325,'message','airnotifier_provider_moodle_competencyusercompcomment_permitted','permitted'),(326,'message','airnotifier_provider_moodle_insights_permitted','permitted'),(327,'message','airnotifier_provider_moodle_messagecontactrequests_permitted','permitted'),(328,'message_email','version','2018120300'),(330,'message','email_provider_enrol_flatfile_flatfile_enrolment_permitted','permitted'),(331,'message','message_provider_enrol_flatfile_flatfile_enrolment_loggedin','email'),(332,'message','message_provider_enrol_flatfile_flatfile_enrolment_loggedoff','email'),(333,'message','email_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted','permitted'),(334,'message','message_provider_enrol_imsenterprise_imsenterprise_enrolment_loggedin','email'),(335,'message','message_provider_enrol_imsenterprise_imsenterprise_enrolment_loggedoff','email'),(336,'message','email_provider_enrol_manual_expiry_notification_permitted','permitted'),(337,'message','message_provider_enrol_manual_expiry_notification_loggedin','email'),(338,'message','message_provider_enrol_manual_expiry_notification_loggedoff','email'),(339,'message','email_provider_enrol_paypal_paypal_enrolment_permitted','permitted'),(340,'message','message_provider_enrol_paypal_paypal_enrolment_loggedin','email'),(341,'message','message_provider_enrol_paypal_paypal_enrolment_loggedoff','email'),(342,'message','email_provider_enrol_self_expiry_notification_permitted','permitted'),(343,'message','message_provider_enrol_self_expiry_notification_loggedin','email'),(344,'message','message_provider_enrol_self_expiry_notification_loggedoff','email'),(345,'message','email_provider_mod_assign_assign_notification_permitted','permitted'),(346,'message','message_provider_mod_assign_assign_notification_loggedin','email'),(347,'message','message_provider_mod_assign_assign_notification_loggedoff','email'),(348,'message','email_provider_mod_assignment_assignment_updates_permitted','permitted'),(349,'message','message_provider_mod_assignment_assignment_updates_loggedin','email'),(350,'message','message_provider_mod_assignment_assignment_updates_loggedoff','email'),(351,'message','email_provider_mod_feedback_submission_permitted','permitted'),(352,'message','message_provider_mod_feedback_submission_loggedin','email'),(353,'message','message_provider_mod_feedback_submission_loggedoff','email'),(354,'message','email_provider_mod_feedback_message_permitted','permitted'),(355,'message','message_provider_mod_feedback_message_loggedin','email'),(356,'message','message_provider_mod_feedback_message_loggedoff','email'),(357,'message','email_provider_mod_forum_posts_permitted','permitted'),(358,'message','message_provider_mod_forum_posts_loggedin','email'),(359,'message','message_provider_mod_forum_posts_loggedoff','email'),(360,'message','email_provider_mod_forum_digests_permitted','permitted'),(361,'message','message_provider_mod_forum_digests_loggedin','email'),(362,'message','message_provider_mod_forum_digests_loggedoff','email'),(363,'message','email_provider_mod_lesson_graded_essay_permitted','permitted'),(364,'message','message_provider_mod_lesson_graded_essay_loggedin','email'),(365,'message','message_provider_mod_lesson_graded_essay_loggedoff','email'),(366,'message','email_provider_mod_quiz_submission_permitted','permitted'),(367,'message','message_provider_mod_quiz_submission_loggedin','email'),(368,'message','message_provider_mod_quiz_submission_loggedoff','email'),(369,'message','email_provider_mod_quiz_confirmation_permitted','permitted'),(370,'message','message_provider_mod_quiz_confirmation_loggedin','email'),(371,'message','message_provider_mod_quiz_confirmation_loggedoff','email'),(372,'message','email_provider_mod_quiz_attempt_overdue_permitted','permitted'),(373,'message','message_provider_mod_quiz_attempt_overdue_loggedin','email'),(374,'message','message_provider_mod_quiz_attempt_overdue_loggedoff','email'),(375,'message','email_provider_moodle_notices_permitted','permitted'),(376,'message','message_provider_moodle_notices_loggedin','email'),(377,'message','message_provider_moodle_notices_loggedoff','email'),(378,'message','email_provider_moodle_errors_permitted','permitted'),(379,'message','message_provider_moodle_errors_loggedin','email'),(380,'message','message_provider_moodle_errors_loggedoff','email'),(381,'message','email_provider_moodle_availableupdate_permitted','permitted'),(382,'message','message_provider_moodle_availableupdate_loggedin','email'),(383,'message','message_provider_moodle_availableupdate_loggedoff','email'),(384,'message','email_provider_moodle_instantmessage_permitted','permitted'),(385,'message','message_provider_moodle_instantmessage_loggedoff','popup,email'),(386,'message','email_provider_moodle_backup_permitted','permitted'),(387,'message','message_provider_moodle_backup_loggedin','email'),(388,'message','message_provider_moodle_backup_loggedoff','email'),(389,'message','email_provider_moodle_courserequested_permitted','permitted'),(390,'message','message_provider_moodle_courserequested_loggedin','email'),(391,'message','message_provider_moodle_courserequested_loggedoff','email'),(392,'message','email_provider_moodle_courserequestapproved_permitted','permitted'),(393,'message','message_provider_moodle_courserequestapproved_loggedin','email'),(394,'message','message_provider_moodle_courserequestapproved_loggedoff','email'),(395,'message','email_provider_moodle_courserequestrejected_permitted','permitted'),(396,'message','message_provider_moodle_courserequestrejected_loggedin','email'),(397,'message','message_provider_moodle_courserequestrejected_loggedoff','email'),(398,'message','email_provider_moodle_badgerecipientnotice_permitted','permitted'),(399,'message','message_provider_moodle_badgerecipientnotice_loggedoff','popup,email'),(400,'message','email_provider_moodle_badgecreatornotice_permitted','permitted'),(401,'message','message_provider_moodle_badgecreatornotice_loggedoff','email'),(402,'message','email_provider_moodle_competencyplancomment_permitted','permitted'),(403,'message','message_provider_moodle_competencyplancomment_loggedin','email'),(404,'message','message_provider_moodle_competencyplancomment_loggedoff','email'),(405,'message','email_provider_moodle_competencyusercompcomment_permitted','permitted'),(406,'message','message_provider_moodle_competencyusercompcomment_loggedin','email'),(407,'message','message_provider_moodle_competencyusercompcomment_loggedoff','email'),(408,'message','email_provider_moodle_insights_permitted','permitted'),(409,'message','message_provider_moodle_insights_loggedin','email'),(410,'message','message_provider_moodle_insights_loggedoff','email'),(411,'message','email_provider_moodle_messagecontactrequests_permitted','permitted'),(412,'message','message_provider_moodle_messagecontactrequests_loggedoff','popup,email'),(413,'message_jabber','version','2018120300'),(415,'message','jabber_provider_enrol_flatfile_flatfile_enrolment_permitted','permitted'),(416,'message','jabber_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted','permitted'),(417,'message','jabber_provider_enrol_manual_expiry_notification_permitted','permitted'),(418,'message','jabber_provider_enrol_paypal_paypal_enrolment_permitted','permitted'),(419,'message','jabber_provider_enrol_self_expiry_notification_permitted','permitted'),(420,'message','jabber_provider_mod_assign_assign_notification_permitted','permitted'),(421,'message','jabber_provider_mod_assignment_assignment_updates_permitted','permitted'),(422,'message','jabber_provider_mod_feedback_submission_permitted','permitted'),(423,'message','jabber_provider_mod_feedback_message_permitted','permitted'),(424,'message','jabber_provider_mod_forum_posts_permitted','permitted'),(425,'message','jabber_provider_mod_forum_digests_permitted','permitted'),(426,'message','jabber_provider_mod_lesson_graded_essay_permitted','permitted'),(427,'message','jabber_provider_mod_quiz_submission_permitted','permitted'),(428,'message','jabber_provider_mod_quiz_confirmation_permitted','permitted'),(429,'message','jabber_provider_mod_quiz_attempt_overdue_permitted','permitted'),(430,'message','jabber_provider_moodle_notices_permitted','permitted'),(431,'message','jabber_provider_moodle_errors_permitted','permitted'),(432,'message','jabber_provider_moodle_availableupdate_permitted','permitted'),(433,'message','jabber_provider_moodle_instantmessage_permitted','permitted'),(434,'message','jabber_provider_moodle_backup_permitted','permitted'),(435,'message','jabber_provider_moodle_courserequested_permitted','permitted'),(436,'message','jabber_provider_moodle_courserequestapproved_permitted','permitted'),(437,'message','jabber_provider_moodle_courserequestrejected_permitted','permitted'),(438,'message','jabber_provider_moodle_badgerecipientnotice_permitted','permitted'),(439,'message','jabber_provider_moodle_badgecreatornotice_permitted','permitted'),(440,'message','jabber_provider_moodle_competencyplancomment_permitted','permitted'),(441,'message','jabber_provider_moodle_competencyusercompcomment_permitted','permitted'),(442,'message','jabber_provider_moodle_insights_permitted','permitted'),(443,'message','jabber_provider_moodle_messagecontactrequests_permitted','permitted'),(444,'message_popup','version','2018120300'),(446,'message','popup_provider_enrol_flatfile_flatfile_enrolment_permitted','permitted'),(447,'message','popup_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted','permitted'),(448,'message','popup_provider_enrol_manual_expiry_notification_permitted','permitted'),(449,'message','popup_provider_enrol_paypal_paypal_enrolment_permitted','permitted'),(450,'message','popup_provider_enrol_self_expiry_notification_permitted','permitted'),(451,'message','popup_provider_mod_assign_assign_notification_permitted','permitted'),(452,'message','popup_provider_mod_assignment_assignment_updates_permitted','permitted'),(453,'message','popup_provider_mod_feedback_submission_permitted','permitted'),(454,'message','popup_provider_mod_feedback_message_permitted','permitted'),(455,'message','popup_provider_mod_forum_posts_permitted','permitted'),(456,'message','popup_provider_mod_forum_digests_permitted','permitted'),(457,'message','popup_provider_mod_lesson_graded_essay_permitted','permitted'),(458,'message','popup_provider_mod_quiz_submission_permitted','permitted'),(459,'message','popup_provider_mod_quiz_confirmation_permitted','permitted'),(460,'message','popup_provider_mod_quiz_attempt_overdue_permitted','permitted'),(461,'message','popup_provider_moodle_notices_permitted','permitted'),(462,'message','popup_provider_moodle_errors_permitted','permitted'),(463,'message','popup_provider_moodle_availableupdate_permitted','permitted'),(464,'message','popup_provider_moodle_instantmessage_permitted','permitted'),(465,'message','message_provider_moodle_instantmessage_loggedin','popup'),(466,'message','popup_provider_moodle_backup_permitted','permitted'),(467,'message','popup_provider_moodle_courserequested_permitted','permitted'),(468,'message','popup_provider_moodle_courserequestapproved_permitted','permitted'),(469,'message','popup_provider_moodle_courserequestrejected_permitted','permitted'),(470,'message','popup_provider_moodle_badgerecipientnotice_permitted','permitted'),(471,'message','message_provider_moodle_badgerecipientnotice_loggedin','popup'),(472,'message','popup_provider_moodle_badgecreatornotice_permitted','permitted'),(473,'message','popup_provider_moodle_competencyplancomment_permitted','permitted'),(474,'message','popup_provider_moodle_competencyusercompcomment_permitted','permitted'),(475,'message','popup_provider_moodle_insights_permitted','permitted'),(476,'message','popup_provider_moodle_messagecontactrequests_permitted','permitted'),(477,'message','message_provider_moodle_messagecontactrequests_loggedin','popup'),(478,'block_activity_modules','version','2018120300'),(479,'block_activity_results','version','2018120300'),(480,'block_admin_bookmarks','version','2018120300'),(481,'block_badges','version','2018120300'),(482,'block_blog_menu','version','2018120300'),(483,'block_blog_recent','version','2018120300'),(484,'block_blog_tags','version','2018120300'),(485,'block_calendar_month','version','2018120300'),(486,'block_calendar_upcoming','version','2018120300'),(487,'block_comments','version','2018120300'),(488,'block_community','version','2018120300'),(489,'block_completionstatus','version','2018120300'),(490,'block_course_list','version','2018120300'),(491,'block_course_summary','version','2018120300'),(492,'block_feedback','version','2018120300'),(494,'block_globalsearch','version','2018120300'),(495,'block_glossary_random','version','2018120300'),(496,'block_html','version','2018120300'),(497,'block_login','version','2018120300'),(498,'block_lp','version','2018120300'),(499,'block_mentees','version','2018120300'),(500,'block_mnet_hosts','version','2018120300'),(501,'block_myoverview','version','2018120300'),(502,'block_myprofile','version','2018120300'),(503,'block_navigation','version','2018120300'),(504,'block_news_items','version','2018120300'),(505,'block_online_users','version','2018120300'),(506,'block_participants','version','2018120300'),(507,'block_private_files','version','2018120300'),(508,'block_quiz_results','version','2018120300'),(510,'block_recent_activity','version','2018120300'),(511,'block_recentlyaccessedcourses','version','2018120300'),(513,'block_recentlyaccesseditems','version','2018120301'),(514,'block_rss_client','version','2018120300'),(515,'block_search_forums','version','2018120300'),(516,'block_section_links','version','2018120300'),(517,'block_selfcompletion','version','2018120300'),(518,'block_settings','version','2018120300'),(519,'block_site_main_menu','version','2018120300'),(520,'block_social_activities','version','2018120300'),(521,'block_starredcourses','version','2018120300'),(522,'block_tag_flickr','version','2018120300'),(523,'block_tag_youtube','version','2018120300'),(525,'block_tags','version','2018120300'),(526,'block_timeline','version','2018120300'),(528,'media_html5audio','version','2018120300'),(529,'media_html5video','version','2018120300'),(530,'media_swf','version','2018120300'),(531,'media_videojs','version','2018120300'),(532,'media_vimeo','version','2018120300'),(533,'media_youtube','version','2018120300'),(534,'filter_activitynames','version','2018120300'),(536,'filter_algebra','version','2018120300'),(537,'filter_censor','version','2018120300'),(538,'filter_data','version','2018120300'),(540,'filter_emailprotect','version','2018120300'),(541,'filter_emoticon','version','2018120300'),(542,'filter_glossary','version','2018120300'),(544,'filter_mathjaxloader','version','2018120300'),(546,'filter_mediaplugin','version','2018120300'),(548,'filter_multilang','version','2018120300'),(549,'filter_tex','version','2018120300'),(551,'filter_tidy','version','2018120300'),(552,'filter_urltolink','version','2018120300'),(553,'editor_atto','version','2018120300'),(555,'editor_textarea','version','2018120300'),(556,'editor_tinymce','version','2018120300'),(557,'format_singleactivity','version','2018120300'),(558,'format_social','version','2018120300'),(559,'format_topics','version','2018120300'),(560,'format_weeks','version','2018120300'),(561,'dataformat_csv','version','2018120300'),(562,'dataformat_excel','version','2018120300'),(563,'dataformat_html','version','2018120300'),(564,'dataformat_json','version','2018120300'),(565,'dataformat_ods','version','2018120300'),(566,'profilefield_checkbox','version','2018120300'),(567,'profilefield_datetime','version','2018120300'),(568,'profilefield_menu','version','2018120300'),(569,'profilefield_text','version','2018120300'),(570,'profilefield_textarea','version','2018120300'),(571,'report_backups','version','2018120300'),(572,'report_competency','version','2018120300'),(573,'report_completion','version','2018120300'),(575,'report_configlog','version','2018120300'),(576,'report_courseoverview','version','2018120300'),(577,'report_eventlist','version','2018120300'),(578,'report_insights','version','2018120300'),(579,'report_log','version','2018120300'),(581,'report_loglive','version','2018120300'),(582,'report_outline','version','2018120300'),(584,'report_participation','version','2018120300'),(586,'report_performance','version','2018120300'),(587,'report_progress','version','2018120300'),(589,'report_questioninstances','version','2018120300'),(590,'report_security','version','2018120300'),(591,'report_stats','version','2018120300'),(593,'report_usersessions','version','2018120300'),(594,'gradeexport_ods','version','2018120300'),(595,'gradeexport_txt','version','2018120300'),(596,'gradeexport_xls','version','2018120300'),(597,'gradeexport_xml','version','2018120300'),(598,'gradeimport_csv','version','2018120300'),(599,'gradeimport_direct','version','2018120300'),(600,'gradeimport_xml','version','2018120300'),(601,'gradereport_grader','version','2018120300'),(602,'gradereport_history','version','2018120300'),(603,'gradereport_outcomes','version','2018120300'),(604,'gradereport_overview','version','2018120300'),(605,'gradereport_singleview','version','2018120300'),(606,'gradereport_user','version','2018120300'),(607,'gradingform_guide','version','2018120300'),(608,'gradingform_rubric','version','2018120300'),(609,'mlbackend_php','version','2018120300'),(610,'mlbackend_python','version','2018120300'),(611,'mnetservice_enrol','version','2018120300'),(612,'webservice_rest','version','2018120300'),(613,'webservice_soap','version','2018120300'),(614,'webservice_xmlrpc','version','2018120300'),(615,'repository_areafiles','version','2018120300'),(617,'areafiles','enablecourseinstances','0'),(618,'areafiles','enableuserinstances','0'),(619,'repository_boxnet','version','2018120300'),(620,'repository_coursefiles','version','2018120300'),(621,'repository_dropbox','version','2018120300'),(622,'repository_equella','version','2018120300'),(623,'repository_filesystem','version','2018120300'),(624,'repository_flickr','version','2018120300'),(625,'repository_flickr_public','version','2018120300'),(626,'repository_googledocs','version','2018120300'),(627,'repository_local','version','2018120300'),(629,'local','enablecourseinstances','0'),(630,'local','enableuserinstances','0'),(631,'repository_merlot','version','2018120300'),(632,'repository_nextcloud','version','2018120300'),(633,'repository_onedrive','version','2018120300'),(634,'repository_picasa','version','2018120300'),(635,'repository_recent','version','2018120300'),(637,'recent','enablecourseinstances','0'),(638,'recent','enableuserinstances','0'),(639,'repository_s3','version','2018120300'),(640,'repository_skydrive','version','2018120300'),(641,'repository_upload','version','2018120300'),(643,'upload','enablecourseinstances','0'),(644,'upload','enableuserinstances','0'),(645,'repository_url','version','2018120300'),(647,'url','enablecourseinstances','0'),(648,'url','enableuserinstances','0'),(649,'repository_user','version','2018120300'),(651,'user','enablecourseinstances','0'),(652,'user','enableuserinstances','0'),(653,'repository_webdav','version','2018120300'),(654,'repository_wikimedia','version','2018120300'),(656,'wikimedia','enablecourseinstances','0'),(657,'wikimedia','enableuserinstances','0'),(658,'repository_youtube','version','2018120300'),(660,'portfolio_boxnet','version','2018120300'),(661,'portfolio_download','version','2018120300'),(662,'portfolio_flickr','version','2018120300'),(663,'portfolio_googledocs','version','2018120300'),(664,'portfolio_mahara','version','2018120300'),(665,'portfolio_picasa','version','2018120300'),(666,'search_simpledb','version','2018120300'),(668,'search_solr','version','2018120300'),(669,'qbehaviour_adaptive','version','2018120300'),(670,'qbehaviour_adaptivenopenalty','version','2018120300'),(671,'qbehaviour_deferredcbm','version','2018120300'),(672,'qbehaviour_deferredfeedback','version','2018120300'),(673,'qbehaviour_immediatecbm','version','2018120300'),(674,'qbehaviour_immediatefeedback','version','2018120300'),(675,'qbehaviour_informationitem','version','2018120300'),(676,'qbehaviour_interactive','version','2018120300'),(677,'qbehaviour_interactivecountback','version','2018120300'),(678,'qbehaviour_manualgraded','version','2018120300'),(680,'question','disabledbehaviours','manualgraded'),(681,'qbehaviour_missing','version','2018120300'),(682,'qformat_aiken','version','2018120300'),(683,'qformat_blackboard_six','version','2018120300'),(684,'qformat_examview','version','2018120300'),(685,'qformat_gift','version','2018120300'),(686,'qformat_missingword','version','2018120300'),(687,'qformat_multianswer','version','2018120300'),(688,'qformat_webct','version','2018120300'),(689,'qformat_xhtml','version','2018120300'),(690,'qformat_xml','version','2018120300'),(691,'tool_analytics','version','2018120300'),(692,'tool_availabilityconditions','version','2018120300'),(693,'tool_behat','version','2018120300'),(694,'tool_capability','version','2018120300'),(695,'tool_cohortroles','version','2018120300'),(696,'tool_customlang','version','2018120300'),(698,'tool_dataprivacy','version','2018120300'),(699,'message','airnotifier_provider_tool_dataprivacy_contactdataprotectionofficer_permitted','permitted'),(700,'message','email_provider_tool_dataprivacy_contactdataprotectionofficer_permitted','permitted'),(701,'message','jabber_provider_tool_dataprivacy_contactdataprotectionofficer_permitted','permitted'),(702,'message','popup_provider_tool_dataprivacy_contactdataprotectionofficer_permitted','permitted'),(703,'message','message_provider_tool_dataprivacy_contactdataprotectionofficer_loggedin','email,popup'),(704,'message','message_provider_tool_dataprivacy_contactdataprotectionofficer_loggedoff','email,popup'),(705,'message','airnotifier_provider_tool_dataprivacy_datarequestprocessingresults_permitted','permitted'),(706,'message','email_provider_tool_dataprivacy_datarequestprocessingresults_permitted','permitted'),(707,'message','jabber_provider_tool_dataprivacy_datarequestprocessingresults_permitted','permitted'),(708,'message','popup_provider_tool_dataprivacy_datarequestprocessingresults_permitted','permitted'),(709,'message','message_provider_tool_dataprivacy_datarequestprocessingresults_loggedin','email,popup'),(710,'message','message_provider_tool_dataprivacy_datarequestprocessingresults_loggedoff','email,popup'),(711,'message','airnotifier_provider_tool_dataprivacy_notifyexceptions_permitted','permitted'),(712,'message','email_provider_tool_dataprivacy_notifyexceptions_permitted','permitted'),(713,'message','jabber_provider_tool_dataprivacy_notifyexceptions_permitted','permitted'),(714,'message','popup_provider_tool_dataprivacy_notifyexceptions_permitted','permitted'),(715,'message','message_provider_tool_dataprivacy_notifyexceptions_loggedin','email'),(716,'message','message_provider_tool_dataprivacy_notifyexceptions_loggedoff','email'),(717,'tool_dbtransfer','version','2018120300'),(718,'tool_filetypes','version','2018120300'),(719,'tool_generator','version','2018120300'),(720,'tool_health','version','2018120300'),(721,'tool_httpsreplace','version','2018120300'),(722,'tool_innodb','version','2018120300'),(723,'tool_installaddon','version','2018120300'),(724,'tool_langimport','version','2018120300'),(725,'tool_log','version','2018120300'),(727,'tool_log','enabled_stores','logstore_standard'),(728,'tool_lp','version','2018120300'),(729,'tool_lpimportcsv','version','2018120300'),(730,'tool_lpmigrate','version','2018120300'),(731,'tool_messageinbound','version','2018120300'),(732,'message','airnotifier_provider_tool_messageinbound_invalidrecipienthandler_permitted','permitted'),(733,'message','email_provider_tool_messageinbound_invalidrecipienthandler_permitted','permitted'),(734,'message','jabber_provider_tool_messageinbound_invalidrecipienthandler_permitted','permitted'),(735,'message','popup_provider_tool_messageinbound_invalidrecipienthandler_permitted','permitted'),(736,'message','message_provider_tool_messageinbound_invalidrecipienthandler_loggedin','email'),(737,'message','message_provider_tool_messageinbound_invalidrecipienthandler_loggedoff','email'),(738,'message','airnotifier_provider_tool_messageinbound_messageprocessingerror_permitted','permitted'),(739,'message','email_provider_tool_messageinbound_messageprocessingerror_permitted','permitted'),(740,'message','jabber_provider_tool_messageinbound_messageprocessingerror_permitted','permitted'),(741,'message','popup_provider_tool_messageinbound_messageprocessingerror_permitted','permitted'),(742,'message','message_provider_tool_messageinbound_messageprocessingerror_loggedin','email'),(743,'message','message_provider_tool_messageinbound_messageprocessingerror_loggedoff','email'),(744,'message','airnotifier_provider_tool_messageinbound_messageprocessingsuccess_permitted','permitted'),(745,'message','email_provider_tool_messageinbound_messageprocessingsuccess_permitted','permitted'),(746,'message','jabber_provider_tool_messageinbound_messageprocessingsuccess_permitted','permitted'),(747,'message','popup_provider_tool_messageinbound_messageprocessingsuccess_permitted','permitted'),(748,'message','message_provider_tool_messageinbound_messageprocessingsuccess_loggedin','email'),(749,'message','message_provider_tool_messageinbound_messageprocessingsuccess_loggedoff','email'),(750,'tool_mobile','version','2018120300'),(751,'tool_monitor','version','2018120300'),(752,'message','airnotifier_provider_tool_monitor_notification_permitted','permitted'),(753,'message','email_provider_tool_monitor_notification_permitted','permitted'),(754,'message','jabber_provider_tool_monitor_notification_permitted','permitted'),(755,'message','popup_provider_tool_monitor_notification_permitted','permitted'),(756,'message','message_provider_tool_monitor_notification_loggedin','email'),(757,'message','message_provider_tool_monitor_notification_loggedoff','email'),(758,'tool_multilangupgrade','version','2018120300'),(759,'tool_oauth2','version','2018120300'),(760,'tool_phpunit','version','2018120300'),(761,'tool_policy','version','2018120300'),(762,'tool_profiling','version','2018120300'),(763,'tool_recyclebin','version','2018120300'),(764,'tool_replace','version','2018120300'),(765,'tool_spamcleaner','version','2018120300'),(766,'tool_task','version','2018120300'),(767,'tool_templatelibrary','version','2018120300'),(768,'tool_unsuproles','version','2018120300'),(770,'tool_uploadcourse','version','2018120300'),(771,'tool_uploaduser','version','2018120300'),(772,'tool_usertours','version','2018120300'),(774,'tool_xmldb','version','2018120300'),(775,'cachestore_apcu','version','2018120300'),(776,'cachestore_file','version','2018120300'),(777,'cachestore_memcached','version','2018120300'),(778,'cachestore_mongodb','version','2018120300'),(779,'cachestore_redis','version','2018120300'),(780,'cachestore_session','version','2018120300'),(781,'cachestore_static','version','2018120300'),(782,'cachelock_file','version','2018120300'),(783,'fileconverter_googledrive','version','2018120300'),(784,'fileconverter_unoconv','version','2018120300'),(786,'theme_boost','version','2018120300'),(787,'theme_bootstrapbase','version','2018120300'),(788,'theme_clean','version','2018120300'),(789,'theme_more','version','2018120300'),(791,'assignsubmission_comments','version','2018120300'),(793,'assignsubmission_file','sortorder','1'),(794,'assignsubmission_comments','sortorder','2'),(795,'assignsubmission_onlinetext','sortorder','0'),(796,'assignsubmission_file','version','2018120300'),(797,'assignsubmission_onlinetext','version','2018120300'),(799,'assignfeedback_comments','version','2018120300'),(801,'assignfeedback_comments','sortorder','0'),(802,'assignfeedback_editpdf','sortorder','1'),(803,'assignfeedback_file','sortorder','3'),(804,'assignfeedback_offline','sortorder','2'),(805,'assignfeedback_editpdf','version','2018120300'),(807,'assignfeedback_file','version','2018120300'),(809,'assignfeedback_offline','version','2018120300'),(810,'assignment_offline','version','2018120300'),(811,'assignment_online','version','2018120300'),(812,'assignment_upload','version','2018120300'),(813,'assignment_uploadsingle','version','2018120300'),(814,'booktool_exportimscp','version','2018120300'),(815,'booktool_importhtml','version','2018120300'),(816,'booktool_print','version','2018120300'),(817,'datafield_checkbox','version','2018120300'),(818,'datafield_date','version','2018120300'),(819,'datafield_file','version','2018120300'),(820,'datafield_latlong','version','2018120300'),(821,'datafield_menu','version','2018120300'),(822,'datafield_multimenu','version','2018120300'),(823,'datafield_number','version','2018120300'),(824,'datafield_picture','version','2018120300'),(825,'datafield_radiobutton','version','2018120300'),(826,'datafield_text','version','2018120300'),(827,'datafield_textarea','version','2018120300'),(828,'datafield_url','version','2018120300'),(829,'datapreset_imagegallery','version','2018120300'),(830,'ltiservice_gradebookservices','version','2018120300'),(831,'ltiservice_memberships','version','2018120300'),(832,'ltiservice_profile','version','2018120300'),(833,'ltiservice_toolproxy','version','2018120300'),(834,'ltiservice_toolsettings','version','2018120300'),(835,'quiz_grading','version','2018120300'),(837,'quiz_overview','version','2018120300'),(839,'quiz_responses','version','2018120300'),(841,'quiz_statistics','version','2018120300'),(843,'quizaccess_delaybetweenattempts','version','2018120300'),(844,'quizaccess_ipaddress','version','2018120300'),(845,'quizaccess_numattempts','version','2018120300'),(846,'quizaccess_offlineattempts','version','2018120300'),(847,'quizaccess_openclosedate','version','2018120300'),(848,'quizaccess_password','version','2018120300'),(849,'quizaccess_safebrowser','version','2018120300'),(850,'quizaccess_securewindow','version','2018120300'),(851,'quizaccess_timelimit','version','2018120300'),(852,'scormreport_basic','version','2018120300'),(853,'scormreport_graphs','version','2018120300'),(854,'scormreport_interactions','version','2018120300'),(855,'scormreport_objectives','version','2018120300'),(856,'workshopform_accumulative','version','2018120300'),(858,'workshopform_comments','version','2018120300'),(860,'workshopform_numerrors','version','2018120300'),(862,'workshopform_rubric','version','2018120300'),(864,'workshopallocation_manual','version','2018120300'),(865,'workshopallocation_random','version','2018120300'),(866,'workshopallocation_scheduled','version','2018120300'),(867,'workshopeval_best','version','2018120300'),(868,'atto_accessibilitychecker','version','2018120300'),(869,'atto_accessibilityhelper','version','2018120300'),(870,'atto_align','version','2018120300'),(871,'atto_backcolor','version','2018120300'),(872,'atto_bold','version','2018120300'),(873,'atto_charmap','version','2018120300'),(874,'atto_clear','version','2018120300'),(875,'atto_collapse','version','2018120300'),(876,'atto_emoticon','version','2018120300'),(877,'atto_equation','version','2018120300'),(878,'atto_fontcolor','version','2018120300'),(879,'atto_html','version','2018120300'),(880,'atto_image','version','2018120300'),(881,'atto_indent','version','2018120300'),(882,'atto_italic','version','2018120300'),(883,'atto_link','version','2018120300'),(884,'atto_managefiles','version','2018120300'),(885,'atto_media','version','2018120300'),(886,'atto_noautolink','version','2018120300'),(887,'atto_orderedlist','version','2018120300'),(888,'atto_recordrtc','version','2018120300'),(889,'atto_rtl','version','2018120300'),(890,'atto_strike','version','2018120300'),(891,'atto_subscript','version','2018120300'),(892,'atto_superscript','version','2018120300'),(893,'atto_table','version','2018120300'),(894,'atto_title','version','2018120300'),(895,'atto_underline','version','2018120300'),(896,'atto_undo','version','2018120300'),(897,'atto_unorderedlist','version','2018120300'),(898,'tinymce_ctrlhelp','version','2018120300'),(899,'tinymce_managefiles','version','2018120300'),(900,'tinymce_moodleemoticon','version','2018120300'),(901,'tinymce_moodleimage','version','2018120300'),(902,'tinymce_moodlemedia','version','2018120300'),(903,'tinymce_moodlenolink','version','2018120300'),(904,'tinymce_pdw','version','2018120300'),(905,'tinymce_spellchecker','version','2018120300'),(907,'tinymce_wrap','version','2018120300'),(908,'logstore_database','version','2018120300'),(909,'logstore_legacy','version','2018120300'),(910,'logstore_standard','version','2018120300'),(911,'tool_dataprivacy','contactdataprotectionofficer','0'),(912,'tool_dataprivacy','automaticdeletionrequests','1'),(913,'tool_dataprivacy','privacyrequestexpiry','604800'),(914,'tool_dataprivacy','requireallenddatesforuserdeletion','1'),(915,'tool_dataprivacy','showdataretentionsummary','1'),(916,'tool_log','exportlog','1'),(917,'analytics','logstore','logstore_standard'),(918,'tool_recyclebin','coursebinenable','1'),(919,'tool_recyclebin','coursebinexpiry','604800'),(920,'tool_recyclebin','categorybinenable','1'),(921,'tool_recyclebin','categorybinexpiry','604800'),(922,'tool_recyclebin','autohide','1'),(923,'antivirus_clamav','runningmethod','commandline'),(924,'antivirus_clamav','pathtoclam',''),(925,'antivirus_clamav','pathtounixsocket',''),(926,'antivirus_clamav','clamfailureonupload','donothing'),(927,'block_activity_results','config_showbest','3'),(928,'block_activity_results','config_showbest_locked',''),(929,'block_activity_results','config_showworst','0'),(930,'block_activity_results','config_showworst_locked',''),(931,'block_activity_results','config_usegroups','0'),(932,'block_activity_results','config_usegroups_locked',''),(933,'block_activity_results','config_nameformat','1'),(934,'block_activity_results','config_nameformat_locked',''),(935,'block_activity_results','config_gradeformat','1'),(936,'block_activity_results','config_gradeformat_locked',''),(937,'block_activity_results','config_decimalpoints','2'),(938,'block_activity_results','config_decimalpoints_locked',''),(939,'block_section_links','numsections1','22'),(940,'block_section_links','incby1','2'),(941,'block_section_links','numsections2','40'),(942,'block_section_links','incby2','5'),(943,'block_tag_youtube','apikey',''),(944,'fileconverter_googledrive','issuerid',''),(945,'editor_atto','toolbar','collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist\nlinks = link\nfiles = image, media, recordrtc, managefiles\nstyle2 = underline, strike, subscript, superscript\nalign = align\nindent = indent\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html'),(946,'editor_atto','autosavefrequency','60'),(947,'atto_collapse','showgroups','5'),(948,'atto_equation','librarygroup1','\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n'),(949,'atto_equation','librarygroup2','\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n'),(950,'atto_equation','librarygroup3','\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n'),(951,'atto_equation','librarygroup4','\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n'),(952,'atto_recordrtc','allowedtypes','both'),(953,'atto_recordrtc','audiobitrate','128000'),(954,'atto_recordrtc','videobitrate','2500000'),(955,'atto_recordrtc','timelimit','120'),(956,'atto_table','allowborders','0'),(957,'atto_table','allowbackgroundcolour','0'),(958,'atto_table','allowwidth','0'),(959,'editor_tinymce','customtoolbar','wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen'),(960,'editor_tinymce','fontselectlist','Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings'),(961,'editor_tinymce','customconfig',''),(962,'tinymce_moodleemoticon','requireemoticon','1'),(963,'tinymce_spellchecker','spellengine',''),(964,'tinymce_spellchecker','spelllanguagelist','+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv'),(965,'format_singleactivity','activitytype','forum'),(966,'logstore_database','dbdriver',''),(967,'logstore_database','dbhost',''),(968,'logstore_database','dbuser',''),(969,'logstore_database','dbpass',''),(970,'logstore_database','dbname',''),(971,'logstore_database','dbtable',''),(972,'logstore_database','dbpersist','0'),(973,'logstore_database','dbsocket',''),(974,'logstore_database','dbport',''),(975,'logstore_database','dbschema',''),(976,'logstore_database','dbcollation',''),(977,'logstore_database','dbhandlesoptions','0'),(978,'logstore_database','buffersize','50'),(979,'logstore_database','logguests','0'),(980,'logstore_database','includelevels','1,2,0'),(981,'logstore_database','includeactions','c,r,u,d'),(982,'logstore_legacy','loglegacy','0'),(983,'logstore_standard','logguests','1'),(984,'logstore_standard','loglifetime','0'),(985,'logstore_standard','buffersize','50'),(986,'media_videojs','videoextensions','html_video,.f4v,.flv'),(987,'media_videojs','audioextensions','html_audio'),(988,'media_videojs','rtmp','0'),(989,'media_videojs','useflash','0'),(990,'media_videojs','youtube','1'),(991,'media_videojs','videocssclass','video-js'),(992,'media_videojs','audiocssclass','video-js'),(993,'media_videojs','limitsize','1'),(994,'assign','feedback_plugin_for_gradebook','assignfeedback_comments'),(995,'assign','showrecentsubmissions','0'),(996,'assign','submissionreceipts','1'),(997,'assign','submissionstatement','This assignment is my own work, except where I have acknowledged the use of the works of other people.'),(998,'assign','maxperpage','-1'),(999,'assign','alwaysshowdescription','1'),(1000,'assign','alwaysshowdescription_adv',''),(1001,'assign','alwaysshowdescription_locked',''),(1002,'assign','allowsubmissionsfromdate','0'),(1003,'assign','allowsubmissionsfromdate_enabled','1'),(1004,'assign','allowsubmissionsfromdate_adv',''),(1005,'assign','duedate','604800'),(1006,'assign','duedate_enabled','1'),(1007,'assign','duedate_adv',''),(1008,'assign','cutoffdate','1209600'),(1009,'assign','cutoffdate_enabled',''),(1010,'assign','cutoffdate_adv',''),(1011,'assign','gradingduedate','1209600'),(1012,'assign','gradingduedate_enabled','1'),(1013,'assign','gradingduedate_adv',''),(1014,'assign','submissiondrafts','0'),(1015,'assign','submissiondrafts_adv',''),(1016,'assign','submissiondrafts_locked',''),(1017,'assign','requiresubmissionstatement','0'),(1018,'assign','requiresubmissionstatement_adv',''),(1019,'assign','requiresubmissionstatement_locked',''),(1020,'assign','attemptreopenmethod','none'),(1021,'assign','attemptreopenmethod_adv',''),(1022,'assign','attemptreopenmethod_locked',''),(1023,'assign','maxattempts','-1'),(1024,'assign','maxattempts_adv',''),(1025,'assign','maxattempts_locked',''),(1026,'assign','teamsubmission','0'),(1027,'assign','teamsubmission_adv',''),(1028,'assign','teamsubmission_locked',''),(1029,'assign','preventsubmissionnotingroup','0'),(1030,'assign','preventsubmissionnotingroup_adv',''),(1031,'assign','preventsubmissionnotingroup_locked',''),(1032,'assign','requireallteammemberssubmit','0'),(1033,'assign','requireallteammemberssubmit_adv',''),(1034,'assign','requireallteammemberssubmit_locked',''),(1035,'assign','teamsubmissiongroupingid',''),(1036,'assign','teamsubmissiongroupingid_adv',''),(1037,'assign','sendnotifications','0'),(1038,'assign','sendnotifications_adv',''),(1039,'assign','sendnotifications_locked',''),(1040,'assign','sendlatenotifications','0'),(1041,'assign','sendlatenotifications_adv',''),(1042,'assign','sendlatenotifications_locked',''),(1043,'assign','sendstudentnotifications','1'),(1044,'assign','sendstudentnotifications_adv',''),(1045,'assign','sendstudentnotifications_locked',''),(1046,'assign','blindmarking','0'),(1047,'assign','blindmarking_adv',''),(1048,'assign','blindmarking_locked',''),(1049,'assign','markingworkflow','0'),(1050,'assign','markingworkflow_adv',''),(1051,'assign','markingworkflow_locked',''),(1052,'assign','markingallocation','0'),(1053,'assign','markingallocation_adv',''),(1054,'assign','markingallocation_locked',''),(1055,'assignsubmission_file','default','1'),(1056,'assignsubmission_file','maxfiles','20'),(1057,'assignsubmission_file','filetypes',''),(1058,'assignsubmission_file','maxbytes','0'),(1059,'assignsubmission_onlinetext','default','0'),(1060,'assignfeedback_comments','default','1'),(1061,'assignfeedback_comments','inline','0'),(1062,'assignfeedback_comments','inline_adv',''),(1063,'assignfeedback_comments','inline_locked',''),(1064,'assignfeedback_editpdf','default','1'),(1065,'assignfeedback_editpdf','stamps',''),(1066,'assignfeedback_file','default','0'),(1067,'assignfeedback_offline','default','0'),(1068,'book','numberingoptions','0,1,2,3'),(1069,'book','navoptions','0,1,2'),(1070,'book','numbering','1'),(1071,'book','navstyle','1'),(1072,'resource','framesize','130'),(1073,'resource','displayoptions','0,1,4,5,6'),(1074,'resource','printintro','1'),(1075,'resource','display','0'),(1076,'resource','showsize','0'),(1077,'resource','showtype','0'),(1078,'resource','showdate','0'),(1079,'resource','popupwidth','620'),(1080,'resource','popupheight','450'),(1081,'resource','filterfiles','0'),(1082,'folder','showexpanded','1'),(1083,'folder','maxsizetodownload','0'),(1084,'imscp','keepold','1'),(1085,'imscp','keepold_adv',''),(1086,'quiz','timelimit','0'),(1087,'quiz','timelimit_adv',''),(1088,'quiz','overduehandling','autosubmit'),(1089,'quiz','overduehandling_adv',''),(1090,'quiz','graceperiod','86400'),(1091,'quiz','graceperiod_adv',''),(1092,'quiz','graceperiodmin','60'),(1093,'quiz','attempts','0'),(1094,'quiz','attempts_adv',''),(1095,'quiz','grademethod','1'),(1096,'quiz','grademethod_adv',''),(1097,'quiz','maximumgrade','10'),(1098,'quiz','questionsperpage','1'),(1099,'quiz','questionsperpage_adv',''),(1100,'quiz','navmethod','free'),(1101,'quiz','navmethod_adv','1'),(1102,'quiz','shuffleanswers','1'),(1103,'quiz','shuffleanswers_adv',''),(1104,'quiz','preferredbehaviour','deferredfeedback'),(1105,'quiz','canredoquestions','0'),(1106,'quiz','canredoquestions_adv','1'),(1107,'quiz','attemptonlast','0'),(1108,'quiz','attemptonlast_adv','1'),(1109,'quiz','reviewattempt','69904'),(1110,'quiz','reviewcorrectness','69904'),(1111,'quiz','reviewmarks','69904'),(1112,'quiz','reviewspecificfeedback','69904'),(1113,'quiz','reviewgeneralfeedback','69904'),(1114,'quiz','reviewrightanswer','69904'),(1115,'quiz','reviewoverallfeedback','4368'),(1116,'quiz','showuserpicture','0'),(1117,'quiz','showuserpicture_adv',''),(1118,'quiz','decimalpoints','2'),(1119,'quiz','decimalpoints_adv',''),(1120,'quiz','questiondecimalpoints','-1'),(1121,'quiz','questiondecimalpoints_adv','1'),(1122,'quiz','showblocks','0'),(1123,'quiz','showblocks_adv','1'),(1124,'quiz','password',''),(1125,'quiz','password_adv',''),(1126,'quiz','subnet',''),(1127,'quiz','subnet_adv','1'),(1128,'quiz','delay1','0'),(1129,'quiz','delay1_adv','1'),(1130,'quiz','delay2','0'),(1131,'quiz','delay2_adv','1'),(1132,'quiz','browsersecurity','-'),(1133,'quiz','browsersecurity_adv','1'),(1134,'quiz','initialnumfeedbacks','2'),(1135,'quiz','autosaveperiod','60'),(1136,'label','dndmedia','1'),(1137,'label','dndresizewidth','400'),(1138,'label','dndresizeheight','400'),(1139,'page','displayoptions','5'),(1140,'page','printheading','1'),(1141,'page','printintro','0'),(1142,'page','printlastmodified','1'),(1143,'page','display','5'),(1144,'page','popupwidth','620'),(1145,'page','popupheight','450'),(1146,'mod_lesson','mediafile',''),(1147,'mod_lesson','mediafile_adv','1'),(1148,'mod_lesson','mediawidth','640'),(1149,'mod_lesson','mediaheight','480'),(1150,'mod_lesson','mediaclose','0'),(1151,'mod_lesson','progressbar','0'),(1152,'mod_lesson','progressbar_adv',''),(1153,'mod_lesson','ongoing','0'),(1154,'mod_lesson','ongoing_adv','1'),(1155,'mod_lesson','displayleftmenu','0'),(1156,'mod_lesson','displayleftmenu_adv',''),(1157,'mod_lesson','displayleftif','0'),(1158,'mod_lesson','displayleftif_adv','1'),(1159,'mod_lesson','slideshow','0'),(1160,'mod_lesson','slideshow_adv','1'),(1161,'mod_lesson','slideshowwidth','640'),(1162,'mod_lesson','slideshowheight','480'),(1163,'mod_lesson','slideshowbgcolor','#FFFFFF'),(1164,'mod_lesson','maxanswers','5'),(1165,'mod_lesson','maxanswers_adv','1'),(1166,'mod_lesson','defaultfeedback','0'),(1167,'mod_lesson','defaultfeedback_adv','1'),(1168,'mod_lesson','activitylink',''),(1169,'mod_lesson','activitylink_adv','1'),(1170,'mod_lesson','timelimit','0'),(1171,'mod_lesson','timelimit_adv',''),(1172,'mod_lesson','password','0'),(1173,'mod_lesson','password_adv','1'),(1174,'mod_lesson','modattempts','0'),(1175,'mod_lesson','modattempts_adv',''),(1176,'mod_lesson','displayreview','0'),(1177,'mod_lesson','displayreview_adv',''),(1178,'mod_lesson','maximumnumberofattempts','1'),(1179,'mod_lesson','maximumnumberofattempts_adv',''),(1180,'mod_lesson','defaultnextpage','0'),(1181,'mod_lesson','defaultnextpage_adv','1'),(1182,'mod_lesson','numberofpagestoshow','1'),(1183,'mod_lesson','numberofpagestoshow_adv','1'),(1184,'mod_lesson','practice','0'),(1185,'mod_lesson','practice_adv',''),(1186,'mod_lesson','customscoring','1'),(1187,'mod_lesson','customscoring_adv','1'),(1188,'mod_lesson','retakesallowed','0'),(1189,'mod_lesson','retakesallowed_adv',''),(1190,'mod_lesson','handlingofretakes','0'),(1191,'mod_lesson','handlingofretakes_adv','1'),(1192,'mod_lesson','minimumnumberofquestions','0'),(1193,'mod_lesson','minimumnumberofquestions_adv','1'),(1194,'scorm','displaycoursestructure','0'),(1195,'scorm','displaycoursestructure_adv',''),(1196,'scorm','popup','0'),(1197,'scorm','popup_adv',''),(1198,'scorm','displayactivityname','1'),(1199,'scorm','framewidth','100'),(1200,'scorm','framewidth_adv','1'),(1201,'scorm','frameheight','500'),(1202,'scorm','frameheight_adv','1'),(1203,'scorm','winoptgrp_adv','1'),(1204,'scorm','scrollbars','0'),(1205,'scorm','directories','0'),(1206,'scorm','location','0'),(1207,'scorm','menubar','0'),(1208,'scorm','toolbar','0'),(1209,'scorm','status','0'),(1210,'scorm','skipview','0'),(1211,'scorm','skipview_adv','1'),(1212,'scorm','hidebrowse','0'),(1213,'scorm','hidebrowse_adv','1'),(1214,'scorm','hidetoc','0'),(1215,'scorm','hidetoc_adv','1'),(1216,'scorm','nav','1'),(1217,'scorm','nav_adv','1'),(1218,'scorm','navpositionleft','-100'),(1219,'scorm','navpositionleft_adv','1'),(1220,'scorm','navpositiontop','-100'),(1221,'scorm','navpositiontop_adv','1'),(1222,'scorm','collapsetocwinsize','767'),(1223,'scorm','collapsetocwinsize_adv','1'),(1224,'scorm','displayattemptstatus','1'),(1225,'scorm','displayattemptstatus_adv',''),(1226,'scorm','grademethod','1'),(1227,'scorm','maxgrade','100'),(1228,'scorm','maxattempt','0'),(1229,'scorm','whatgrade','0'),(1230,'scorm','forcecompleted','0'),(1231,'scorm','forcenewattempt','0'),(1232,'scorm','autocommit','0'),(1233,'scorm','masteryoverride','1'),(1234,'scorm','lastattemptlock','0'),(1235,'scorm','auto','0'),(1236,'scorm','updatefreq','0'),(1237,'scorm','scormstandard','0'),(1238,'scorm','allowtypeexternal','0'),(1239,'scorm','allowtypelocalsync','0'),(1240,'scorm','allowtypeexternalaicc','0'),(1241,'scorm','allowaicchacp','0'),(1242,'scorm','aicchacptimeout','30'),(1243,'scorm','aicchacpkeepsessiondata','1'),(1244,'scorm','aiccuserid','1'),(1245,'scorm','forcejavascript','1'),(1246,'scorm','allowapidebug','0'),(1247,'scorm','apidebugmask','.*'),(1248,'scorm','protectpackagedownloads','0'),(1249,'url','framesize','130'),(1250,'url','secretphrase',''),(1251,'url','rolesinparams','0'),(1252,'url','displayoptions','0,1,5,6'),(1253,'url','printintro','1'),(1254,'url','display','0'),(1255,'url','popupwidth','620'),(1256,'url','popupheight','450'),(1257,'workshop','grade','80'),(1258,'workshop','gradinggrade','20'),(1259,'workshop','gradedecimals','0'),(1260,'workshop','maxbytes','0'),(1261,'workshop','strategy','accumulative'),(1262,'workshop','examplesmode','0'),(1263,'workshopallocation_random','numofreviews','5'),(1264,'workshopform_numerrors','grade0','Tidak'),(1265,'workshopform_numerrors','grade1','Ya'),(1266,'workshopeval_best','comparison','5'),(1267,'auth_cas','field_map_firstname',''),(1268,'auth_cas','field_updatelocal_firstname','oncreate'),(1269,'auth_cas','field_updateremote_firstname','0'),(1270,'auth_cas','field_lock_firstname','unlocked'),(1271,'auth_cas','field_map_lastname',''),(1272,'auth_cas','field_updatelocal_lastname','oncreate'),(1273,'auth_cas','field_updateremote_lastname','0'),(1274,'auth_cas','field_lock_lastname','unlocked'),(1275,'auth_cas','field_map_email',''),(1276,'auth_cas','field_updatelocal_email','oncreate'),(1277,'auth_cas','field_updateremote_email','0'),(1278,'auth_cas','field_lock_email','unlocked'),(1279,'auth_cas','field_map_city',''),(1280,'auth_cas','field_updatelocal_city','oncreate'),(1281,'auth_cas','field_updateremote_city','0'),(1282,'auth_cas','field_lock_city','unlocked'),(1283,'auth_cas','field_map_country',''),(1284,'auth_cas','field_updatelocal_country','oncreate'),(1285,'auth_cas','field_updateremote_country','0'),(1286,'auth_cas','field_lock_country','unlocked'),(1287,'auth_cas','field_map_lang',''),(1288,'auth_cas','field_updatelocal_lang','oncreate'),(1289,'auth_cas','field_updateremote_lang','0'),(1290,'auth_cas','field_lock_lang','unlocked'),(1291,'auth_cas','field_map_description',''),(1292,'auth_cas','field_updatelocal_description','oncreate'),(1293,'auth_cas','field_updateremote_description','0'),(1294,'auth_cas','field_lock_description','unlocked'),(1295,'auth_cas','field_map_url',''),(1296,'auth_cas','field_updatelocal_url','oncreate'),(1297,'auth_cas','field_updateremote_url','0'),(1298,'auth_cas','field_lock_url','unlocked'),(1299,'auth_cas','field_map_idnumber',''),(1300,'auth_cas','field_updatelocal_idnumber','oncreate'),(1301,'auth_cas','field_updateremote_idnumber','0'),(1302,'auth_cas','field_lock_idnumber','unlocked'),(1303,'auth_cas','field_map_institution',''),(1304,'auth_cas','field_updatelocal_institution','oncreate'),(1305,'auth_cas','field_updateremote_institution','0'),(1306,'auth_cas','field_lock_institution','unlocked'),(1307,'auth_cas','field_map_department',''),(1308,'auth_cas','field_updatelocal_department','oncreate'),(1309,'auth_cas','field_updateremote_department','0'),(1310,'auth_cas','field_lock_department','unlocked'),(1311,'auth_cas','field_map_phone1',''),(1312,'auth_cas','field_updatelocal_phone1','oncreate'),(1313,'auth_cas','field_updateremote_phone1','0'),(1314,'auth_cas','field_lock_phone1','unlocked'),(1315,'auth_cas','field_map_phone2',''),(1316,'auth_cas','field_updatelocal_phone2','oncreate'),(1317,'auth_cas','field_updateremote_phone2','0'),(1318,'auth_cas','field_lock_phone2','unlocked'),(1319,'auth_cas','field_map_address',''),(1320,'auth_cas','field_updatelocal_address','oncreate'),(1321,'auth_cas','field_updateremote_address','0'),(1322,'auth_cas','field_lock_address','unlocked'),(1323,'auth_cas','field_map_firstnamephonetic',''),(1324,'auth_cas','field_updatelocal_firstnamephonetic','oncreate'),(1325,'auth_cas','field_updateremote_firstnamephonetic','0'),(1326,'auth_cas','field_lock_firstnamephonetic','unlocked'),(1327,'auth_cas','field_map_lastnamephonetic',''),(1328,'auth_cas','field_updatelocal_lastnamephonetic','oncreate'),(1329,'auth_cas','field_updateremote_lastnamephonetic','0'),(1330,'auth_cas','field_lock_lastnamephonetic','unlocked'),(1331,'auth_cas','field_map_middlename',''),(1332,'auth_cas','field_updatelocal_middlename','oncreate'),(1333,'auth_cas','field_updateremote_middlename','0'),(1334,'auth_cas','field_lock_middlename','unlocked'),(1335,'auth_cas','field_map_alternatename',''),(1336,'auth_cas','field_updatelocal_alternatename','oncreate'),(1337,'auth_cas','field_updateremote_alternatename','0'),(1338,'auth_cas','field_lock_alternatename','unlocked'),(1339,'auth_db','host','127.0.0.1'),(1340,'auth_db','type','mysqli'),(1341,'auth_db','sybasequoting','0'),(1342,'auth_db','name',''),(1343,'auth_db','user',''),(1344,'auth_db','pass',''),(1345,'auth_db','table',''),(1346,'auth_db','fielduser',''),(1347,'auth_db','fieldpass',''),(1348,'auth_db','passtype','plaintext'),(1349,'auth_db','extencoding','utf-8'),(1350,'auth_db','setupsql',''),(1351,'auth_db','debugauthdb','0'),(1352,'auth_db','changepasswordurl',''),(1353,'auth_db','removeuser','0'),(1354,'auth_db','updateusers','0'),(1355,'auth_db','field_map_firstname',''),(1356,'auth_db','field_updatelocal_firstname','oncreate'),(1357,'auth_db','field_updateremote_firstname','0'),(1358,'auth_db','field_lock_firstname','unlocked'),(1359,'auth_db','field_map_lastname',''),(1360,'auth_db','field_updatelocal_lastname','oncreate'),(1361,'auth_db','field_updateremote_lastname','0'),(1362,'auth_db','field_lock_lastname','unlocked'),(1363,'auth_db','field_map_email',''),(1364,'auth_db','field_updatelocal_email','oncreate'),(1365,'auth_db','field_updateremote_email','0'),(1366,'auth_db','field_lock_email','unlocked'),(1367,'auth_db','field_map_city',''),(1368,'auth_db','field_updatelocal_city','oncreate'),(1369,'auth_db','field_updateremote_city','0'),(1370,'auth_db','field_lock_city','unlocked'),(1371,'auth_db','field_map_country',''),(1372,'auth_db','field_updatelocal_country','oncreate'),(1373,'auth_db','field_updateremote_country','0'),(1374,'auth_db','field_lock_country','unlocked'),(1375,'auth_db','field_map_lang',''),(1376,'auth_db','field_updatelocal_lang','oncreate'),(1377,'auth_db','field_updateremote_lang','0'),(1378,'auth_db','field_lock_lang','unlocked'),(1379,'auth_db','field_map_description',''),(1380,'auth_db','field_updatelocal_description','oncreate'),(1381,'auth_db','field_updateremote_description','0'),(1382,'auth_db','field_lock_description','unlocked'),(1383,'auth_db','field_map_url',''),(1384,'auth_db','field_updatelocal_url','oncreate'),(1385,'auth_db','field_updateremote_url','0'),(1386,'auth_db','field_lock_url','unlocked'),(1387,'auth_db','field_map_idnumber',''),(1388,'auth_db','field_updatelocal_idnumber','oncreate'),(1389,'auth_db','field_updateremote_idnumber','0'),(1390,'auth_db','field_lock_idnumber','unlocked'),(1391,'auth_db','field_map_institution',''),(1392,'auth_db','field_updatelocal_institution','oncreate'),(1393,'auth_db','field_updateremote_institution','0'),(1394,'auth_db','field_lock_institution','unlocked'),(1395,'auth_db','field_map_department',''),(1396,'auth_db','field_updatelocal_department','oncreate'),(1397,'auth_db','field_updateremote_department','0'),(1398,'auth_db','field_lock_department','unlocked'),(1399,'auth_db','field_map_phone1',''),(1400,'auth_db','field_updatelocal_phone1','oncreate'),(1401,'auth_db','field_updateremote_phone1','0'),(1402,'auth_db','field_lock_phone1','unlocked'),(1403,'auth_db','field_map_phone2',''),(1404,'auth_db','field_updatelocal_phone2','oncreate'),(1405,'auth_db','field_updateremote_phone2','0'),(1406,'auth_db','field_lock_phone2','unlocked'),(1407,'auth_db','field_map_address',''),(1408,'auth_db','field_updatelocal_address','oncreate'),(1409,'auth_db','field_updateremote_address','0'),(1410,'auth_db','field_lock_address','unlocked'),(1411,'auth_db','field_map_firstnamephonetic',''),(1412,'auth_db','field_updatelocal_firstnamephonetic','oncreate'),(1413,'auth_db','field_updateremote_firstnamephonetic','0'),(1414,'auth_db','field_lock_firstnamephonetic','unlocked'),(1415,'auth_db','field_map_lastnamephonetic',''),(1416,'auth_db','field_updatelocal_lastnamephonetic','oncreate'),(1417,'auth_db','field_updateremote_lastnamephonetic','0'),(1418,'auth_db','field_lock_lastnamephonetic','unlocked'),(1419,'auth_db','field_map_middlename',''),(1420,'auth_db','field_updatelocal_middlename','oncreate'),(1421,'auth_db','field_updateremote_middlename','0'),(1422,'auth_db','field_lock_middlename','unlocked'),(1423,'auth_db','field_map_alternatename',''),(1424,'auth_db','field_updatelocal_alternatename','oncreate'),(1425,'auth_db','field_updateremote_alternatename','0'),(1426,'auth_db','field_lock_alternatename','unlocked'),(1427,'auth_ldap','field_map_firstname',''),(1428,'auth_ldap','field_updatelocal_firstname','oncreate'),(1429,'auth_ldap','field_updateremote_firstname','0'),(1430,'auth_ldap','field_lock_firstname','unlocked'),(1431,'auth_ldap','field_map_lastname',''),(1432,'auth_ldap','field_updatelocal_lastname','oncreate'),(1433,'auth_ldap','field_updateremote_lastname','0'),(1434,'auth_ldap','field_lock_lastname','unlocked'),(1435,'auth_ldap','field_map_email',''),(1436,'auth_ldap','field_updatelocal_email','oncreate'),(1437,'auth_ldap','field_updateremote_email','0'),(1438,'auth_ldap','field_lock_email','unlocked'),(1439,'auth_ldap','field_map_city',''),(1440,'auth_ldap','field_updatelocal_city','oncreate'),(1441,'auth_ldap','field_updateremote_city','0'),(1442,'auth_ldap','field_lock_city','unlocked'),(1443,'auth_ldap','field_map_country',''),(1444,'auth_ldap','field_updatelocal_country','oncreate'),(1445,'auth_ldap','field_updateremote_country','0'),(1446,'auth_ldap','field_lock_country','unlocked'),(1447,'auth_ldap','field_map_lang',''),(1448,'auth_ldap','field_updatelocal_lang','oncreate'),(1449,'auth_ldap','field_updateremote_lang','0'),(1450,'auth_ldap','field_lock_lang','unlocked'),(1451,'auth_ldap','field_map_description',''),(1452,'auth_ldap','field_updatelocal_description','oncreate'),(1453,'auth_ldap','field_updateremote_description','0'),(1454,'auth_ldap','field_lock_description','unlocked'),(1455,'auth_ldap','field_map_url',''),(1456,'auth_ldap','field_updatelocal_url','oncreate'),(1457,'auth_ldap','field_updateremote_url','0'),(1458,'auth_ldap','field_lock_url','unlocked'),(1459,'auth_ldap','field_map_idnumber',''),(1460,'auth_ldap','field_updatelocal_idnumber','oncreate'),(1461,'auth_ldap','field_updateremote_idnumber','0'),(1462,'auth_ldap','field_lock_idnumber','unlocked'),(1463,'auth_ldap','field_map_institution',''),(1464,'auth_ldap','field_updatelocal_institution','oncreate'),(1465,'auth_ldap','field_updateremote_institution','0'),(1466,'auth_ldap','field_lock_institution','unlocked'),(1467,'auth_ldap','field_map_department',''),(1468,'auth_ldap','field_updatelocal_department','oncreate'),(1469,'auth_ldap','field_updateremote_department','0'),(1470,'auth_ldap','field_lock_department','unlocked'),(1471,'auth_ldap','field_map_phone1',''),(1472,'auth_ldap','field_updatelocal_phone1','oncreate'),(1473,'auth_ldap','field_updateremote_phone1','0'),(1474,'auth_ldap','field_lock_phone1','unlocked'),(1475,'auth_ldap','field_map_phone2',''),(1476,'auth_ldap','field_updatelocal_phone2','oncreate'),(1477,'auth_ldap','field_updateremote_phone2','0'),(1478,'auth_ldap','field_lock_phone2','unlocked'),(1479,'auth_ldap','field_map_address',''),(1480,'auth_ldap','field_updatelocal_address','oncreate'),(1481,'auth_ldap','field_updateremote_address','0'),(1482,'auth_ldap','field_lock_address','unlocked'),(1483,'auth_ldap','field_map_firstnamephonetic',''),(1484,'auth_ldap','field_updatelocal_firstnamephonetic','oncreate'),(1485,'auth_ldap','field_updateremote_firstnamephonetic','0'),(1486,'auth_ldap','field_lock_firstnamephonetic','unlocked'),(1487,'auth_ldap','field_map_lastnamephonetic',''),(1488,'auth_ldap','field_updatelocal_lastnamephonetic','oncreate'),(1489,'auth_ldap','field_updateremote_lastnamephonetic','0'),(1490,'auth_ldap','field_lock_lastnamephonetic','unlocked'),(1491,'auth_ldap','field_map_middlename',''),(1492,'auth_ldap','field_updatelocal_middlename','oncreate'),(1493,'auth_ldap','field_updateremote_middlename','0'),(1494,'auth_ldap','field_lock_middlename','unlocked'),(1495,'auth_ldap','field_map_alternatename',''),(1496,'auth_ldap','field_updatelocal_alternatename','oncreate'),(1497,'auth_ldap','field_updateremote_alternatename','0'),(1498,'auth_ldap','field_lock_alternatename','unlocked'),(1499,'auth_manual','expiration','0'),(1500,'auth_manual','expirationtime','30'),(1501,'auth_manual','expiration_warning','0'),(1502,'auth_manual','field_lock_firstname','unlocked'),(1503,'auth_manual','field_lock_lastname','unlocked'),(1504,'auth_manual','field_lock_email','unlocked'),(1505,'auth_manual','field_lock_city','unlocked'),(1506,'auth_manual','field_lock_country','unlocked'),(1507,'auth_manual','field_lock_lang','unlocked'),(1508,'auth_manual','field_lock_description','unlocked'),(1509,'auth_manual','field_lock_url','unlocked'),(1510,'auth_manual','field_lock_idnumber','unlocked'),(1511,'auth_manual','field_lock_institution','unlocked'),(1512,'auth_manual','field_lock_department','unlocked'),(1513,'auth_manual','field_lock_phone1','unlocked'),(1514,'auth_manual','field_lock_phone2','unlocked'),(1515,'auth_manual','field_lock_address','unlocked'),(1516,'auth_manual','field_lock_firstnamephonetic','unlocked'),(1517,'auth_manual','field_lock_lastnamephonetic','unlocked'),(1518,'auth_manual','field_lock_middlename','unlocked'),(1519,'auth_manual','field_lock_alternatename','unlocked'),(1520,'auth_mnet','rpc_negotiation_timeout','30'),(1521,'auth_oauth2','field_lock_firstname','unlocked'),(1522,'auth_oauth2','field_lock_lastname','unlocked'),(1523,'auth_oauth2','field_lock_email','unlocked'),(1524,'auth_oauth2','field_lock_city','unlocked'),(1525,'auth_oauth2','field_lock_country','unlocked'),(1526,'auth_oauth2','field_lock_lang','unlocked'),(1527,'auth_oauth2','field_lock_description','unlocked'),(1528,'auth_oauth2','field_lock_url','unlocked'),(1529,'auth_oauth2','field_lock_idnumber','unlocked'),(1530,'auth_oauth2','field_lock_institution','unlocked'),(1531,'auth_oauth2','field_lock_department','unlocked'),(1532,'auth_oauth2','field_lock_phone1','unlocked'),(1533,'auth_oauth2','field_lock_phone2','unlocked'),(1534,'auth_oauth2','field_lock_address','unlocked'),(1535,'auth_oauth2','field_lock_firstnamephonetic','unlocked'),(1536,'auth_oauth2','field_lock_lastnamephonetic','unlocked'),(1537,'auth_oauth2','field_lock_middlename','unlocked'),(1538,'auth_oauth2','field_lock_alternatename','unlocked'),(1539,'auth_email','recaptcha','0'),(1540,'auth_email','field_lock_firstname','unlocked'),(1541,'auth_email','field_lock_lastname','unlocked'),(1542,'auth_email','field_lock_email','unlocked'),(1543,'auth_email','field_lock_city','unlocked'),(1544,'auth_email','field_lock_country','unlocked'),(1545,'auth_email','field_lock_lang','unlocked'),(1546,'auth_email','field_lock_description','unlocked'),(1547,'auth_email','field_lock_url','unlocked'),(1548,'auth_email','field_lock_idnumber','unlocked'),(1549,'auth_email','field_lock_institution','unlocked'),(1550,'auth_email','field_lock_department','unlocked'),(1551,'auth_email','field_lock_phone1','unlocked'),(1552,'auth_email','field_lock_phone2','unlocked'),(1553,'auth_email','field_lock_address','unlocked'),(1554,'auth_email','field_lock_firstnamephonetic','unlocked'),(1555,'auth_email','field_lock_lastnamephonetic','unlocked'),(1556,'auth_email','field_lock_middlename','unlocked'),(1557,'auth_email','field_lock_alternatename','unlocked'),(1558,'auth_shibboleth','user_attribute',''),(1559,'auth_shibboleth','convert_data',''),(1560,'auth_shibboleth','alt_login','off'),(1561,'auth_shibboleth','organization_selection','urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai'),(1562,'auth_shibboleth','logout_handler',''),(1563,'auth_shibboleth','logout_return_url',''),(1564,'auth_shibboleth','login_name','Shibboleth Login'),(1565,'auth_shibboleth','auth_logo',''),(1566,'auth_shibboleth','auth_instructions','Use the <a href=\"http://localhost/hr-assessment/auth/shibboleth/index.php\">Shibboleth login</a> to get access via Shibboleth, if your institution supports it.<br />Otherwise, use the normal login form shown here.'),(1567,'auth_shibboleth','changepasswordurl',''),(1568,'auth_shibboleth','field_map_firstname',''),(1569,'auth_shibboleth','field_updatelocal_firstname','oncreate'),(1570,'auth_shibboleth','field_lock_firstname','unlocked'),(1571,'auth_shibboleth','field_map_lastname',''),(1572,'auth_shibboleth','field_updatelocal_lastname','oncreate'),(1573,'auth_shibboleth','field_lock_lastname','unlocked'),(1574,'auth_shibboleth','field_map_email',''),(1575,'auth_shibboleth','field_updatelocal_email','oncreate'),(1576,'auth_shibboleth','field_lock_email','unlocked'),(1577,'auth_shibboleth','field_map_city',''),(1578,'auth_shibboleth','field_updatelocal_city','oncreate'),(1579,'auth_shibboleth','field_lock_city','unlocked'),(1580,'auth_shibboleth','field_map_country',''),(1581,'auth_shibboleth','field_updatelocal_country','oncreate'),(1582,'auth_shibboleth','field_lock_country','unlocked'),(1583,'auth_shibboleth','field_map_lang',''),(1584,'auth_shibboleth','field_updatelocal_lang','oncreate'),(1585,'auth_shibboleth','field_lock_lang','unlocked'),(1586,'auth_shibboleth','field_map_description',''),(1587,'auth_shibboleth','field_updatelocal_description','oncreate'),(1588,'auth_shibboleth','field_lock_description','unlocked'),(1589,'auth_shibboleth','field_map_url',''),(1590,'auth_shibboleth','field_updatelocal_url','oncreate'),(1591,'auth_shibboleth','field_lock_url','unlocked'),(1592,'auth_shibboleth','field_map_idnumber',''),(1593,'auth_shibboleth','field_updatelocal_idnumber','oncreate'),(1594,'auth_shibboleth','field_lock_idnumber','unlocked'),(1595,'auth_shibboleth','field_map_institution',''),(1596,'auth_shibboleth','field_updatelocal_institution','oncreate'),(1597,'auth_shibboleth','field_lock_institution','unlocked'),(1598,'auth_shibboleth','field_map_department',''),(1599,'auth_shibboleth','field_updatelocal_department','oncreate'),(1600,'auth_shibboleth','field_lock_department','unlocked'),(1601,'auth_shibboleth','field_map_phone1',''),(1602,'auth_shibboleth','field_updatelocal_phone1','oncreate'),(1603,'auth_shibboleth','field_lock_phone1','unlocked'),(1604,'auth_shibboleth','field_map_phone2',''),(1605,'auth_shibboleth','field_updatelocal_phone2','oncreate'),(1606,'auth_shibboleth','field_lock_phone2','unlocked'),(1607,'auth_shibboleth','field_map_address',''),(1608,'auth_shibboleth','field_updatelocal_address','oncreate'),(1609,'auth_shibboleth','field_lock_address','unlocked'),(1610,'auth_shibboleth','field_map_firstnamephonetic',''),(1611,'auth_shibboleth','field_updatelocal_firstnamephonetic','oncreate'),(1612,'auth_shibboleth','field_lock_firstnamephonetic','unlocked'),(1613,'auth_shibboleth','field_map_lastnamephonetic',''),(1614,'auth_shibboleth','field_updatelocal_lastnamephonetic','oncreate'),(1615,'auth_shibboleth','field_lock_lastnamephonetic','unlocked'),(1616,'auth_shibboleth','field_map_middlename',''),(1617,'auth_shibboleth','field_updatelocal_middlename','oncreate'),(1618,'auth_shibboleth','field_lock_middlename','unlocked'),(1619,'auth_shibboleth','field_map_alternatename',''),(1620,'auth_shibboleth','field_updatelocal_alternatename','oncreate'),(1621,'auth_shibboleth','field_lock_alternatename','unlocked'),(1622,'auth_none','field_lock_firstname','unlocked'),(1623,'auth_none','field_lock_lastname','unlocked'),(1624,'auth_none','field_lock_email','unlocked'),(1625,'auth_none','field_lock_city','unlocked'),(1626,'auth_none','field_lock_country','unlocked'),(1627,'auth_none','field_lock_lang','unlocked'),(1628,'auth_none','field_lock_description','unlocked'),(1629,'auth_none','field_lock_url','unlocked'),(1630,'auth_none','field_lock_idnumber','unlocked'),(1631,'auth_none','field_lock_institution','unlocked'),(1632,'auth_none','field_lock_department','unlocked'),(1633,'auth_none','field_lock_phone1','unlocked'),(1634,'auth_none','field_lock_phone2','unlocked'),(1635,'auth_none','field_lock_address','unlocked'),(1636,'auth_none','field_lock_firstnamephonetic','unlocked'),(1637,'auth_none','field_lock_lastnamephonetic','unlocked'),(1638,'auth_none','field_lock_middlename','unlocked'),(1639,'auth_none','field_lock_alternatename','unlocked'),(1640,'enrol_cohort','roleid','5'),(1641,'enrol_cohort','unenrolaction','0'),(1642,'enrol_meta','nosyncroleids',''),(1643,'enrol_meta','syncall','1'),(1644,'enrol_meta','unenrolaction','3'),(1645,'enrol_meta','coursesort','sortorder'),(1646,'enrol_database','dbtype',''),(1647,'enrol_database','dbhost','localhost'),(1648,'enrol_database','dbuser',''),(1649,'enrol_database','dbpass',''),(1650,'enrol_database','dbname',''),(1651,'enrol_database','dbencoding','utf-8'),(1652,'enrol_database','dbsetupsql',''),(1653,'enrol_database','dbsybasequoting','0'),(1654,'enrol_database','debugdb','0'),(1655,'enrol_database','localcoursefield','idnumber'),(1656,'enrol_database','localuserfield','idnumber'),(1657,'enrol_database','localrolefield','shortname'),(1658,'enrol_database','localcategoryfield','id'),(1659,'enrol_database','remoteenroltable',''),(1660,'enrol_database','remotecoursefield',''),(1661,'enrol_database','remoteuserfield',''),(1662,'enrol_database','remoterolefield',''),(1663,'enrol_database','remoteotheruserfield',''),(1664,'enrol_database','defaultrole','5'),(1665,'enrol_database','ignorehiddencourses','0'),(1666,'enrol_database','unenrolaction','0'),(1667,'enrol_database','newcoursetable',''),(1668,'enrol_database','newcoursefullname','fullname'),(1669,'enrol_database','newcourseshortname','shortname'),(1670,'enrol_database','newcourseidnumber','idnumber'),(1671,'enrol_database','newcoursecategory',''),(1672,'enrol_database','defaultcategory','1'),(1673,'enrol_database','templatecourse',''),(1674,'enrol_flatfile','location',''),(1675,'enrol_flatfile','encoding','UTF-8'),(1676,'enrol_flatfile','mailstudents','0'),(1677,'enrol_flatfile','mailteachers','0'),(1678,'enrol_flatfile','mailadmins','0'),(1679,'enrol_flatfile','unenrolaction','3'),(1680,'enrol_flatfile','expiredaction','3'),(1681,'enrol_guest','requirepassword','0'),(1682,'enrol_guest','usepasswordpolicy','0'),(1683,'enrol_guest','showhint','0'),(1684,'enrol_guest','defaultenrol','1'),(1685,'enrol_guest','status','1'),(1686,'enrol_guest','status_adv',''),(1687,'enrol_imsenterprise','imsfilelocation',''),(1688,'enrol_imsenterprise','logtolocation',''),(1689,'enrol_imsenterprise','mailadmins','0'),(1690,'enrol_imsenterprise','createnewusers','0'),(1691,'enrol_imsenterprise','imsupdateusers','0'),(1692,'enrol_imsenterprise','imsdeleteusers','0'),(1693,'enrol_imsenterprise','fixcaseusernames','0'),(1694,'enrol_imsenterprise','fixcasepersonalnames','0'),(1695,'enrol_imsenterprise','imssourcedidfallback','0'),(1696,'enrol_imsenterprise','imsrolemap01','5'),(1697,'enrol_imsenterprise','imsrolemap02','3'),(1698,'enrol_imsenterprise','imsrolemap03','3'),(1699,'enrol_imsenterprise','imsrolemap04','5'),(1700,'enrol_imsenterprise','imsrolemap05','0'),(1701,'enrol_imsenterprise','imsrolemap06','4'),(1702,'enrol_imsenterprise','imsrolemap07','0'),(1703,'enrol_imsenterprise','imsrolemap08','4'),(1704,'enrol_imsenterprise','truncatecoursecodes','0'),(1705,'enrol_imsenterprise','createnewcourses','0'),(1706,'enrol_imsenterprise','updatecourses','0'),(1707,'enrol_imsenterprise','createnewcategories','0'),(1708,'enrol_imsenterprise','nestedcategories','0'),(1709,'enrol_imsenterprise','categoryidnumber','0'),(1710,'enrol_imsenterprise','categoryseparator',''),(1711,'enrol_imsenterprise','imsunenrol','0'),(1712,'enrol_imsenterprise','imscoursemapshortname','coursecode'),(1713,'enrol_imsenterprise','imscoursemapfullname','short'),(1714,'enrol_imsenterprise','imscoursemapsummary','ignore'),(1715,'enrol_imsenterprise','imsrestricttarget',''),(1716,'enrol_imsenterprise','imscapitafix','0'),(1717,'enrol_manual','expiredaction','1'),(1718,'enrol_manual','expirynotifyhour','6'),(1719,'enrol_manual','defaultenrol','1'),(1720,'enrol_manual','status','0'),(1721,'enrol_manual','roleid','5'),(1722,'enrol_manual','enrolstart','4'),(1723,'enrol_manual','enrolperiod','0'),(1724,'enrol_manual','expirynotify','0'),(1725,'enrol_manual','expirythreshold','86400'),(1726,'enrol_mnet','roleid','5'),(1727,'enrol_mnet','roleid_adv','1'),(1728,'enrol_paypal','paypalbusiness',''),(1729,'enrol_paypal','mailstudents','0'),(1730,'enrol_paypal','mailteachers','0'),(1731,'enrol_paypal','mailadmins','0'),(1732,'enrol_paypal','expiredaction','3'),(1733,'enrol_paypal','status','1'),(1734,'enrol_paypal','cost','0'),(1735,'enrol_paypal','currency','USD'),(1736,'enrol_paypal','roleid','5'),(1737,'enrol_paypal','enrolperiod','0'),(1738,'enrol_lti','emaildisplay','2'),(1739,'enrol_lti','city',''),(1740,'enrol_lti','country',''),(1741,'enrol_lti','timezone','99'),(1742,'enrol_lti','lang','id'),(1743,'enrol_lti','institution',''),(1744,'enrol_self','requirepassword','0'),(1745,'enrol_self','usepasswordpolicy','0'),(1746,'enrol_self','showhint','0'),(1747,'enrol_self','expiredaction','1'),(1748,'enrol_self','expirynotifyhour','6'),(1749,'enrol_self','defaultenrol','1'),(1750,'enrol_self','status','1'),(1751,'enrol_self','newenrols','1'),(1752,'enrol_self','groupkey','0'),(1753,'enrol_self','roleid','5'),(1754,'enrol_self','enrolperiod','0'),(1755,'enrol_self','expirynotify','0'),(1756,'enrol_self','expirythreshold','86400'),(1757,'enrol_self','longtimenosee','0'),(1758,'enrol_self','maxenrolled','0'),(1759,'enrol_self','sendcoursewelcomemessage','1'),(1760,'filter_urltolink','formats','0'),(1761,'filter_urltolink','embedimages','1'),(1762,'filter_emoticon','formats','1,4,0'),(1763,'filter_mathjaxloader','httpsurl','https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.2/MathJax.js'),(1764,'filter_mathjaxloader','texfiltercompatibility','0'),(1765,'filter_mathjaxloader','mathjaxconfig','\nMathJax.Hub.Config({\n    config: [\"Accessible.js\", \"Safe.js\"],\n    errorSettings: { message: [\"!\"] },\n    skipStartupTypeset: true,\n    messageStyle: \"none\"\n});\n'),(1766,'filter_mathjaxloader','additionaldelimiters',''),(1767,'filter_tex','latexpreamble','\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n'),(1768,'filter_tex','latexbackground','#FFFFFF'),(1769,'filter_tex','density','120'),(1770,'filter_tex','pathlatex','/usr/bin/latex'),(1771,'filter_tex','pathdvips','/usr/bin/dvips'),(1772,'filter_tex','pathconvert','/usr/bin/convert'),(1773,'filter_tex','pathdvisvgm','/usr/bin/dvisvgm'),(1774,'filter_tex','pathmimetex',''),(1775,'filter_tex','convertformat','gif'),(1776,'qtype_multichoice','answerhowmany','1'),(1777,'qtype_multichoice','shuffleanswers','1'),(1778,'qtype_multichoice','answernumbering','abc'),(1779,'tool_mobile','apppolicy',''),(1780,'mod_bigbluebuttonbn','version','2017101017'),(1781,'block_mylivechat','version','2011110400'),(1782,'enrol_ldap','objectclass','(objectClass=*)'),(1783,'theme_adaptable','version','2019011700'),(1784,'theme_adaptable','maincolor','#3A454b'),(1785,'theme_adaptable','backcolor','#FFF'),(1786,'theme_adaptable','regionmaincolor','#FFF'),(1787,'theme_adaptable','linkcolor','#51666C'),(1788,'theme_adaptable','linkhover','#009688'),(1789,'theme_adaptable','selectiontext','#000000'),(1790,'theme_adaptable','selectionbackground','#00B3A1'),(1791,'theme_adaptable','loadingcolor','#00B3A1'),(1792,'theme_adaptable','msgbadgecolor','#E53935'),(1793,'theme_adaptable','messagingbackgroundcolor','#FFFFFF'),(1794,'theme_adaptable','headerbkcolor','#00796B'),(1795,'theme_adaptable','headertextcolor','#ffffff'),(1796,'theme_adaptable','headerbkcolor2','#009688'),(1797,'theme_adaptable','headertextcolor2','#ffffff'),(1798,'theme_adaptable','menubkcolor','#ffffff'),(1799,'theme_adaptable','menufontcolor','#222222'),(1800,'theme_adaptable','menuhovercolor','#00B3A1'),(1801,'theme_adaptable','menubordercolor','#00B3A1'),(1802,'theme_adaptable','mobilemenubkcolor','#F9F9F9'),(1803,'theme_adaptable','mobilemenufontcolor','#000000'),(1804,'theme_adaptable','marketblockbordercolor','#e8eaeb'),(1805,'theme_adaptable','marketblocksbackgroundcolor','transparent'),(1806,'theme_adaptable','rendereroverlaycolor','#3A454b'),(1807,'theme_adaptable','rendereroverlayfontcolor','#FFF'),(1808,'theme_adaptable','tilesbordercolor','#3A454b'),(1809,'theme_adaptable','covbkcolor','#3A454b'),(1810,'theme_adaptable','covfontcolor','#ffffff'),(1811,'theme_adaptable','dividingline','#ffffff'),(1812,'theme_adaptable','dividingline2','#ffffff'),(1813,'theme_adaptable','breadcrumb','#f5f5f5'),(1814,'theme_adaptable','breadcrumbtextcolor','#444444'),(1815,'theme_adaptable','messagepopupbackground','#fff000'),(1816,'theme_adaptable','messagepopupcolor','#333333'),(1817,'theme_adaptable','footerbkcolor','#424242'),(1818,'theme_adaptable','footertextcolor','#ffffff'),(1819,'theme_adaptable','footertextcolor2','#ffffff'),(1820,'theme_adaptable','footerlinkcolor','#ffffff'),(1821,'theme_adaptable','forumheaderbackgroundcolor','#ffffff'),(1822,'theme_adaptable','forumbodybackgroundcolor','#ffffff'),(1823,'theme_adaptable','fontname','Open Sans'),(1824,'theme_adaptable','fontsubset',''),(1825,'theme_adaptable','fontsize','95%'),(1826,'theme_adaptable','fontweight','400'),(1827,'theme_adaptable','fontcolor','#333333'),(1828,'theme_adaptable','topmenufontsize','14px'),(1829,'theme_adaptable','menufontsize','14px'),(1830,'theme_adaptable','menufontpadding','20px'),(1831,'theme_adaptable','fontheadername','Roboto'),(1832,'theme_adaptable','fontheaderweight','400'),(1833,'theme_adaptable','fontheadercolor','#333333'),(1834,'theme_adaptable','fonttitlename','Roboto Condensed'),(1835,'theme_adaptable','fonttitlesize','48px'),(1836,'theme_adaptable','fonttitleweight','400'),(1837,'theme_adaptable','fonttitlecolor','#ffffff'),(1838,'theme_adaptable','fonttitlecolorcourse','#ffffff'),(1839,'theme_adaptable','buttonradius','5px'),(1840,'theme_adaptable','buttoncolor','#51666C'),(1841,'theme_adaptable','buttonhovercolor','#009688'),(1842,'theme_adaptable','buttontextcolor','#ffffff'),(1843,'theme_adaptable','editonbk','#4caf50'),(1844,'theme_adaptable','editoffbk','#f44336'),(1845,'theme_adaptable','editfont','#ffffff'),(1846,'theme_adaptable','editverticalpadding','4px'),(1847,'theme_adaptable','edithorizontalpadding','6px'),(1848,'theme_adaptable','edittopmargin','1px'),(1849,'theme_adaptable','buttonlogincolor','#ef5350'),(1850,'theme_adaptable','buttonloginhovercolor','#e53935'),(1851,'theme_adaptable','buttonlogintextcolor','#FFFFFF'),(1852,'theme_adaptable','buttonloginpadding','0px'),(1853,'theme_adaptable','buttonloginheight','24px'),(1854,'theme_adaptable','buttonloginmargintop','2px'),(1855,'theme_adaptable','buttoncancelbackgroundcolor','#d8d5d5'),(1856,'theme_adaptable','buttoncancelcolor','#1d1c1c'),(1857,'theme_adaptable','buttondropshadow','0px'),(1858,'theme_adaptable','headerbgimage',''),(1859,'theme_adaptable','frontpagelogin','1'),(1860,'theme_adaptable','displaylogin','button'),(1861,'theme_adaptable','enablemessagemenu','1'),(1862,'theme_adaptable','filteradminmessages',''),(1863,'theme_adaptable','logo',''),(1864,'theme_adaptable','pageheaderheight','72px'),(1865,'theme_adaptable','coursepageheaderhidesitetitle','0'),(1866,'theme_adaptable','favicon','/icons8-usb-connector-48.png'),(1867,'theme_adaptable','sitetitle','default'),(1868,'theme_adaptable','sitetitletext','         \r\n         '),(1869,'theme_adaptable','enableheading','fullname'),(1870,'theme_adaptable','sitetitlepaddingtop','0px'),(1871,'theme_adaptable','sitetitlepaddingleft','0px'),(1872,'theme_adaptable','sitetitlemaxwidth','50%'),(1873,'theme_adaptable','coursetitlemaxwidth','20'),(1874,'theme_adaptable','breadcrumbhome','icon'),(1875,'theme_adaptable','breadcrumbseparator','angle-right'),(1876,'theme_adaptable','socialorsearch','search'),(1877,'theme_adaptable','searchboxpadding','15px 0px 0px 0px'),(1878,'theme_adaptable','enablesavecanceloverlay','1'),(1879,'theme_adaptable','enablemenus','1'),(1880,'theme_adaptable','menuslinkright','1'),(1881,'theme_adaptable','disablemenuscoursepages','1'),(1882,'theme_adaptable','menusession','1'),(1883,'theme_adaptable','menusessionttl','30'),(1884,'theme_adaptable','menuuseroverride',''),(1885,'theme_adaptable','menuoverrideprofilefield','topmenusettings'),(1886,'theme_adaptable','topmenuscount','1'),(1887,'theme_adaptable','newmenu1title','Menu 1'),(1888,'theme_adaptable','newmenu1',''),(1889,'theme_adaptable','newmenu1requirelogin',''),(1890,'theme_adaptable','newmenu1field',''),(1891,'theme_adaptable','hideinforum',''),(1892,'theme_adaptable','enablemy','1'),(1893,'theme_adaptable','enableprofile','1'),(1894,'theme_adaptable','enableeditprofile','1'),(1895,'theme_adaptable','enablecalendar','1'),(1896,'theme_adaptable','enableprivatefiles',''),(1897,'theme_adaptable','enablegrades','1'),(1898,'theme_adaptable','enablebadges',''),(1899,'theme_adaptable','enablepref','1'),(1900,'theme_adaptable','enablenote',''),(1901,'theme_adaptable','enableblog',''),(1902,'theme_adaptable','enableposts',''),(1903,'theme_adaptable','enablefeed',''),(1904,'theme_adaptable','socialsize','32px'),(1905,'theme_adaptable','socialsizemobile','22px'),(1906,'theme_adaptable','socialpaddingtop','0%'),(1907,'theme_adaptable','socialtarget','_self'),(1908,'theme_adaptable','socialiconlist',''),(1909,'theme_adaptable','stickynavbar','1'),(1910,'theme_adaptable','enablehome','1'),(1911,'theme_adaptable','enablehomeredirect','1'),(1912,'theme_adaptable','enablemyhome','1'),(1913,'theme_adaptable','enableevents','1'),(1914,'theme_adaptable','enablethiscourse','1'),(1915,'theme_adaptable','enablezoom','1'),(1916,'theme_adaptable','enableshowhideblocks','1'),(1917,'theme_adaptable','enablenavbarwhenloggedout',''),(1918,'theme_adaptable','navbardisplayicons','1'),(1919,'theme_adaptable','navbardisplaysubmenuarrow',''),(1920,'theme_adaptable','navbardropdownborderradius','0px'),(1921,'theme_adaptable','navbardropdownhovercolor','#EEE'),(1922,'theme_adaptable','navbardropdowntransitiontime','0.2s'),(1923,'theme_adaptable','enablemysites','excludehidden'),(1924,'theme_adaptable','enablemysitesrestriction',''),(1925,'theme_adaptable','mycoursesmenulimit','20'),(1926,'theme_adaptable','mysitesmaxlength','30'),(1927,'theme_adaptable','mysitessortoverride','off'),(1928,'theme_adaptable','mysitessortoverridefield',''),(1929,'theme_adaptable','mysitesmenudisplay','shortcodehover'),(1930,'theme_adaptable','displayparticipants','1'),(1931,'theme_adaptable','displaygrades','1'),(1932,'theme_adaptable','enablehelp',''),(1933,'theme_adaptable','helpprofilefield',''),(1934,'theme_adaptable','enablehelp2',''),(1935,'theme_adaptable','helpprofilefield2',''),(1936,'theme_adaptable','helptarget','_blank'),(1937,'theme_adaptable','disablecustommenu',''),(1938,'theme_adaptable','enabletoolsmenus',''),(1939,'theme_adaptable','toolsmenuscount','1'),(1940,'theme_adaptable','toolsmenu1title','Tools'),(1941,'theme_adaptable','toolsmenu1',''),(1942,'theme_adaptable','toolsmenu1field',''),(1943,'theme_adaptable','enablealerts',''),(1944,'theme_adaptable','enablealertcoursepages',''),(1945,'theme_adaptable','alerthiddencourse','warning'),(1946,'theme_adaptable','enablealertstriptags','1'),(1947,'theme_adaptable','alertcount','1'),(1948,'theme_adaptable','enablealert1',''),(1949,'theme_adaptable','alertkey1',''),(1950,'theme_adaptable','alerttext1','         '),(1951,'theme_adaptable','alerttype1','info'),(1952,'theme_adaptable','alertaccess1','global'),(1953,'theme_adaptable','alertprofilefield1',''),(1954,'theme_adaptable','alertcolorinfo','#3a87ad'),(1955,'theme_adaptable','alertbackgroundcolorinfo','#d9edf7'),(1956,'theme_adaptable','alertbordercolorinfo','#bce8f1'),(1957,'theme_adaptable','alerticoninfo','info-circle'),(1958,'theme_adaptable','alertcolorsuccess','#468847'),(1959,'theme_adaptable','alertbackgroundcolorsuccess','#dff0d8'),(1960,'theme_adaptable','alertbordercolorsuccess','#d6e9c6'),(1961,'theme_adaptable','alerticonsuccess','bullhorn'),(1962,'theme_adaptable','alertcolorwarning','#8a6d3b'),(1963,'theme_adaptable','alertbackgroundcolorwarning','#fcf8e3'),(1964,'theme_adaptable','alertbordercolorwarning','#fbeed5'),(1965,'theme_adaptable','alerticonwarning','exclamation-triangle'),(1966,'theme_adaptable','blockbackgroundcolor','#FFFFFF'),(1967,'theme_adaptable','blockheaderbackgroundcolor','#FFFFFF'),(1968,'theme_adaptable','blockbordercolor','#59585D'),(1969,'theme_adaptable','blockregionbackgroundcolor','transparent'),(1970,'theme_adaptable','blockheaderbordertopstyle','dashed'),(1971,'theme_adaptable','blockheadertopradius','0px'),(1972,'theme_adaptable','blockheaderbottomradius','0px'),(1973,'theme_adaptable','blockheaderbordertop','1px'),(1974,'theme_adaptable','blockheaderborderleft','0px'),(1975,'theme_adaptable','blockheaderborderright','0px'),(1976,'theme_adaptable','blockheaderborderbottom','0px'),(1977,'theme_adaptable','blockmainbordertopstyle','none'),(1978,'theme_adaptable','blockmaintopradius','0px'),(1979,'theme_adaptable','blockmainbottomradius','0px'),(1980,'theme_adaptable','blockmainbordertop','0px'),(1981,'theme_adaptable','blockmainborderleft','0px'),(1982,'theme_adaptable','blockmainborderright','0px'),(1983,'theme_adaptable','blockmainborderbottom','0px'),(1984,'theme_adaptable','fontblockheadersize','22px'),(1985,'theme_adaptable','fontblockheaderweight','400'),(1986,'theme_adaptable','fontblockheadercolor','#3A454b'),(1987,'theme_adaptable','blockicons','1'),(1988,'theme_adaptable','blockiconsheadersize','20px'),(1989,'theme_adaptable','frontpageblocksenabled','0'),(1990,'theme_adaptable','blocklayoutlayoutrow1','3-3-3-3'),(1991,'theme_adaptable','blocklayoutlayoutrow2','4-4-4-0'),(1992,'theme_adaptable','blocklayoutlayoutrow3','3-3-3-3'),(1993,'theme_adaptable','blocklayoutlayoutrow4','0-0-0-0'),(1994,'theme_adaptable','blocklayoutlayoutrow5','0-0-0-0'),(1995,'theme_adaptable','blocklayoutlayoutrow6','0-0-0-0'),(1996,'theme_adaptable','blocklayoutlayoutrow7','0-0-0-0'),(1997,'theme_adaptable','blocklayoutlayoutrow8','0-0-0-0'),(1998,'theme_adaptable','infobox','         '),(1999,'theme_adaptable','infobox2','         '),(2000,'theme_adaptable','infoboxfullscreen',''),(2001,'theme_adaptable','frontpagemarketenabled',''),(2002,'theme_adaptable','frontpagemarketoption','covtiles'),(2003,'theme_adaptable','marketlayoutrow1','3-3-3-3'),(2004,'theme_adaptable','marketlayoutrow2','0-0-0-0'),(2005,'theme_adaptable','marketlayoutrow3','0-0-0-0'),(2006,'theme_adaptable','marketlayoutrow4','0-0-0-0'),(2007,'theme_adaptable','marketlayoutrow5','0-0-0-0'),(2008,'theme_adaptable','enableticker','1'),(2009,'theme_adaptable','enabletickermy','1'),(2010,'theme_adaptable','tickerwidth',''),(2011,'theme_adaptable','newstickercount','1'),(2012,'theme_adaptable','tickertext1','         '),(2013,'theme_adaptable','tickertext1profilefield',''),(2014,'theme_adaptable','sliderenabled','0'),(2015,'theme_adaptable','sliderfullscreen','0'),(2016,'theme_adaptable','slidermargintop','20px'),(2017,'theme_adaptable','slidermarginbottom','20px'),(2018,'theme_adaptable','slideroption2','slider1'),(2019,'theme_adaptable','sliderh3color','#ffffff'),(2020,'theme_adaptable','sliderh4color','#ffffff'),(2021,'theme_adaptable','slidersubmitcolor','#ffffff'),(2022,'theme_adaptable','slidersubmitbgcolor','#51666C'),(2023,'theme_adaptable','slidercount','3'),(2024,'theme_adaptable','p1',''),(2025,'theme_adaptable','p1url',''),(2026,'theme_adaptable','p1cap','         '),(2027,'theme_adaptable','p2',''),(2028,'theme_adaptable','p2url',''),(2029,'theme_adaptable','p2cap','         '),(2030,'theme_adaptable','p3',''),(2031,'theme_adaptable','p3url',''),(2032,'theme_adaptable','p3cap','         '),(2033,'theme_adaptable','frontpagerenderer','2'),(2034,'theme_adaptable','frontpagerendererdefaultimage',''),(2035,'theme_adaptable','tilesshowcontacts','1'),(2036,'theme_adaptable','tilesshowallcontacts','0'),(2037,'theme_adaptable','tilescontactstitle','1'),(2038,'theme_adaptable','covhidebutton','0'),(2039,'theme_adaptable','enableavailablecourses','none'),(2040,'theme_adaptable','moodledocs','1'),(2041,'theme_adaptable','footerblocksplacement','1'),(2042,'theme_adaptable','showfooterblocks','1'),(2043,'theme_adaptable','footerlayoutrow1','3-3-3-3'),(2044,'theme_adaptable','footerlayoutrow2','0-0-0-0'),(2045,'theme_adaptable','footerlayoutrow3','0-0-0-0'),(2046,'theme_adaptable','hidefootersocial','1'),(2047,'theme_adaptable','footnote','         '),(2048,'theme_adaptable','homebk',''),(2049,'theme_adaptable','blockside','0'),(2050,'theme_adaptable','viewselect','1'),(2051,'theme_adaptable','fullscreenwidth','98%'),(2052,'theme_adaptable','emoticonsize','16px'),(2053,'theme_adaptable','dashblocksenabled','0'),(2054,'theme_adaptable','dashblocklayoutlayoutrow1','3-3-3-3'),(2055,'theme_adaptable','dashblocklayoutlayoutrow2','4-4-4-0'),(2056,'theme_adaptable','dashblocklayoutlayoutrow3','3-3-3-3'),(2057,'theme_adaptable','dashblocklayoutlayoutrow4','0-0-0-0'),(2058,'theme_adaptable','dashblocklayoutlayoutrow5','0-0-0-0'),(2059,'theme_adaptable','dashblocklayoutlayoutrow6','0-0-0-0'),(2060,'theme_adaptable','dashblocklayoutlayoutrow7','0-0-0-0'),(2061,'theme_adaptable','dashblocklayoutlayoutrow8','0-0-0-0'),(2062,'theme_adaptable','coursepagesidebarinfooterenabled','0'),(2063,'theme_adaptable','showyourprogress',''),(2064,'theme_adaptable','coursepageblocksliderenabled','0'),(2065,'theme_adaptable','coursepageblockactivitybottomenabled','0'),(2066,'theme_adaptable','coursepageblocksenabled','0'),(2067,'theme_adaptable','coursepageblocklayoutlayouttoprow1','3-3-3-3'),(2068,'theme_adaptable','coursepageblocklayoutlayoutbottomrow2','3-3-3-3'),(2069,'theme_adaptable','coursesectionbgcolor','#FFFFFF'),(2070,'theme_adaptable','coursesectionheaderbg','#FFFFFF'),(2071,'theme_adaptable','sectionheadingcolor','#3A454b'),(2072,'theme_adaptable','currentcolor','#d2f2ef'),(2073,'theme_adaptable','coursesectionheaderborderstyle','none'),(2074,'theme_adaptable','coursesectionheaderbordercolor','#F3F3F3'),(2075,'theme_adaptable','coursesectionheaderborderwidth','0px'),(2076,'theme_adaptable','coursesectionheaderborderradiustop','0px'),(2077,'theme_adaptable','coursesectionheaderborderradiusbottom','0px'),(2078,'theme_adaptable','coursesectionborderstyle','solid'),(2079,'theme_adaptable','coursesectionborderwidth','1px'),(2080,'theme_adaptable','coursesectionbordercolor','#e8eaeb'),(2081,'theme_adaptable','coursesectionborderradius','0px'),(2082,'theme_adaptable','coursesectionactivityuseadaptableicons','1'),(2083,'theme_adaptable','coursesectionactivityiconsize','24px'),(2084,'theme_adaptable','coursesectionactivityborderwidth','2px'),(2085,'theme_adaptable','coursesectionactivityborderstyle','dashed'),(2086,'theme_adaptable','coursesectionactivitybordercolor','#eeeeee'),(2087,'theme_adaptable','coursesectionactivityleftborderwidth','3px'),(2088,'theme_adaptable','coursesectionactivityassignleftbordercolor','#0066cc'),(2089,'theme_adaptable','coursesectionactivityassignbgcolor','#FFFFFF'),(2090,'theme_adaptable','coursesectionactivityforumleftbordercolor','#990099'),(2091,'theme_adaptable','coursesectionactivityforumbgcolor','#FFFFFF'),(2092,'theme_adaptable','coursesectionactivityquizleftbordercolor','#FF3333'),(2093,'theme_adaptable','coursesectionactivityquizbgcolor','#FFFFFF'),(2094,'theme_adaptable','coursesectionactivitymargintop','2px'),(2095,'theme_adaptable','coursesectionactivitymarginbottom','2px'),(2096,'theme_adaptable','socialwallbackgroundcolor','#ffffff'),(2097,'theme_adaptable','socialwallbordercolor','#B9B9B9'),(2098,'theme_adaptable','socialwallbordertopstyle','solid'),(2099,'theme_adaptable','socialwallborderwidth','2px'),(2100,'theme_adaptable','socialwallsectionradius','6px'),(2101,'theme_adaptable','socialwallactionlinkcolor','#51666C'),(2102,'theme_adaptable','socialwallactionlinkhovercolor','#009688'),(2103,'theme_adaptable','coursesectionactivityfurtherinformationassign','1'),(2104,'theme_adaptable','coursesectionactivityfurtherinformationquiz','1'),(2105,'theme_adaptable','coursesectionactivityfurtherinformationchoice','1'),(2106,'theme_adaptable','coursesectionactivityfurtherinformationfeedback','1'),(2107,'theme_adaptable','coursesectionactivityfurtherinformationlesson','1'),(2108,'theme_adaptable','coursesectionactivityfurtherinformationdata','1'),(2109,'theme_adaptable','hidealertsmobile','0'),(2110,'theme_adaptable','hideheadermobile','1'),(2111,'theme_adaptable','hidesocialmobile','0'),(2112,'theme_adaptable','socialboxpaddingtopmobile','10px'),(2113,'theme_adaptable','socialboxpaddingbottommobile','10px'),(2114,'theme_adaptable','hidelogomobile','0'),(2115,'theme_adaptable','hidecoursetitlemobile','0'),(2116,'theme_adaptable','hideslidermobile','1'),(2117,'theme_adaptable','hidebreadcrumbmobile','0'),(2118,'theme_adaptable','hidepagefootermobile','0'),(2119,'theme_adaptable','enableanalytics',''),(2120,'theme_adaptable','anonymizega','1'),(2121,'theme_adaptable','analyticscount','1'),(2122,'theme_adaptable','piwikenabled',''),(2123,'theme_adaptable','piwiksiteid','1'),(2124,'theme_adaptable','piwikimagetrack','1'),(2125,'theme_adaptable','piwiksiteurl',''),(2126,'theme_adaptable','piwiktrackadmin',''),(2127,'theme_adaptable','customcss',''),(2128,'theme_adaptable','jssection',''),(2129,'theme_adaptable','jssectionrestricted',''),(2130,'theme_adaptable','jssectionrestrictedprofilefield',''),(2131,'theme_adaptable','jssectionrestricteddashboardonly','1'),(2132,'theme_adaptable','analyticstext1',''),(2133,'theme_adaptable','analyticsprofilefield1',''),(2134,'availability_paypal','version','2018121902'),(2135,'theme_adaptable','market1','         '),(2136,'theme_adaptable','market2','         '),(2137,'theme_adaptable','market3','         '),(2138,'theme_adaptable','market4','         '),(2139,'theme_adaptable','footer1header',''),(2140,'theme_adaptable','footer1content','         '),(2141,'theme_adaptable','footer2header',''),(2142,'theme_adaptable','footer2content','         '),(2143,'theme_adaptable','footer3header',''),(2144,'theme_adaptable','footer3content','         '),(2145,'theme_adaptable','footer4header',''),(2146,'theme_adaptable','footer4content','         '),(2147,'core_plugin','recentfetch','1551237539'),(2148,'core_plugin','recentresponse','{\"status\":\"OK\",\"provider\":\"https:\\/\\/download.moodle.org\\/api\\/1.3\\/updates.php\",\"apiver\":\"1.3\",\"timegenerated\":1551237540,\"ticket\":\"JUM5JTkxNCVGRTQlODUlMkElN0UlQjAlQzMlOEElRDclQjI2RSVCNyUxRCVDRCU5NCVBRFQzJTlCKyUyQiVCMCVBOU9rJUE2eSUwQiU4REIlMUIlODUlN0IlOEElODlM\",\"forbranch\":\"3.6\",\"forversion\":\"2018120301.05\",\"updates\":{\"core\":[{\"version\":2018120302.1,\"release\":\"3.6.2+ (Build: 20190222)\",\"branch\":\"3.6\",\"maturity\":200,\"url\":\"https:\\/\\/download.moodle.org\",\"download\":\"https:\\/\\/download.moodle.org\\/download.php\\/direct\\/stable36\\/moodle-latest-36.zip\"},{\"version\":2019022200,\"release\":\"3.7dev (Build: 20190222)\",\"branch\":\"3.7\",\"maturity\":50,\"url\":\"https:\\/\\/download.moodle.org\",\"download\":\"https:\\/\\/download.moodle.org\\/download.php\\/direct\\/moodle\\/moodle-latest.zip\"}],\"mod_bigbluebuttonbn\":[{\"version\":\"2017101018\",\"release\":\"2.2.10\",\"maturity\":200,\"url\":\"https:\\/\\/moodle.org\\/plugins\\/pluginversion.php?id=18893\",\"download\":\"https:\\/\\/moodle.org\\/plugins\\/download.php\\/18893\\/mod_bigbluebuttonbn_moodle36_2017101018.zip\",\"downloadmd5\":\"748145cae3914459d4b9db108497aeaf\"}],\"availability_paypal\":[{\"version\":\"2018121902\",\"release\":\"7\",\"maturity\":200,\"url\":\"https:\\/\\/moodle.org\\/plugins\\/pluginversion.php?id=18581\",\"download\":\"https:\\/\\/moodle.org\\/plugins\\/download.php\\/18581\\/availability_paypal_moodle36_2018121902.zip\",\"downloadmd5\":\"afcf2d14f448832a92917297c14ebaae\"}],\"theme_adaptable\":[{\"version\":\"2019011701\",\"release\":\"1.8.0.1\",\"maturity\":200,\"url\":\"https:\\/\\/moodle.org\\/plugins\\/pluginversion.php?id=18884\",\"download\":\"https:\\/\\/moodle.org\\/plugins\\/download.php\\/18884\\/theme_adaptable_moodle36_2019011701.zip\",\"downloadmd5\":\"87442bc4165b20d48a387a73cb4ff402\"}]}}');
/*!40000 ALTER TABLE `mdl_config_plugins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_context`
--

DROP TABLE IF EXISTS `mdl_context`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_context` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextlevel` bigint(10) NOT NULL DEFAULT '0',
  `instanceid` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `depth` tinyint(2) NOT NULL DEFAULT '0',
  `locked` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_cont_conins_uix` (`contextlevel`,`instanceid`),
  KEY `mdl_cont_ins_ix` (`instanceid`),
  KEY `mdl_cont_pat_ix` (`path`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='one of these must be set';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_context`
--

LOCK TABLES `mdl_context` WRITE;
/*!40000 ALTER TABLE `mdl_context` DISABLE KEYS */;
INSERT INTO `mdl_context` VALUES (1,10,0,'/1',1,0),(2,50,1,'/1/2',2,0),(3,40,1,'/1/3',2,0),(4,30,1,'/1/4',2,0),(5,30,2,'/1/5',2,0),(6,80,1,'/1/6',2,0),(7,80,2,'/1/7',2,0),(8,80,3,'/1/8',2,0),(9,80,4,'/1/9',2,0),(10,80,5,'/1/10',2,0),(11,80,6,'/1/11',2,0),(12,80,7,'/1/12',2,0),(13,80,8,'/1/13',2,0),(14,80,9,'/1/14',2,0),(15,80,10,'/1/15',2,0),(16,80,11,'/1/5/16',3,0),(17,80,12,'/1/5/17',3,0),(18,80,13,'/1/5/18',3,0),(19,80,14,'/1/5/19',3,0),(20,80,15,'/1/5/20',3,0),(21,80,16,'/1/5/21',3,0),(22,80,17,'/1/5/22',3,0),(23,80,18,'/1/5/23',3,0),(24,80,19,'/1/5/24',3,0),(25,40,2,'/1/25',2,0),(26,50,2,'/1/25/26',3,0),(27,70,1,'/1/25/26/27',4,0),(28,70,2,'/1/25/26/28',4,0),(29,80,20,'/1/29',2,0),(30,80,21,'/1/30',2,0),(31,30,3,'/1/31',2,0),(32,80,22,'/1/31/32',3,0),(33,80,23,'/1/31/33',3,0),(34,80,24,'/1/31/34',3,0),(35,80,25,'/1/31/35',3,0),(36,80,26,'/1/31/36',3,0),(37,80,27,'/1/31/37',3,0),(38,80,28,'/1/31/38',3,0),(39,80,29,'/1/31/39',3,0),(40,80,30,'/1/31/40',3,0),(41,70,3,'/1/25/26/41',4,0),(42,70,4,'/1/25/26/42',4,0),(43,70,5,'/1/25/26/43',4,0);
/*!40000 ALTER TABLE `mdl_context` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_context_temp`
--

DROP TABLE IF EXISTS `mdl_context_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_context_temp` (
  `id` bigint(10) NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `depth` tinyint(2) NOT NULL,
  `locked` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Used by build_context_path() in upgrade and cron to keep con';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_context_temp`
--

LOCK TABLES `mdl_context_temp` WRITE;
/*!40000 ALTER TABLE `mdl_context_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_context_temp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course`
--

DROP TABLE IF EXISTS `mdl_course`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `category` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `fullname` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `shortname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `summary` longtext COLLATE utf8mb4_unicode_ci,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `format` varchar(21) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'topics',
  `showgrades` tinyint(2) NOT NULL DEFAULT '1',
  `newsitems` mediumint(5) NOT NULL DEFAULT '1',
  `startdate` bigint(10) NOT NULL DEFAULT '0',
  `enddate` bigint(10) NOT NULL DEFAULT '0',
  `marker` bigint(10) NOT NULL DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '0',
  `legacyfiles` smallint(4) NOT NULL DEFAULT '0',
  `showreports` smallint(4) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `groupmode` smallint(4) NOT NULL DEFAULT '0',
  `groupmodeforce` smallint(4) NOT NULL DEFAULT '0',
  `defaultgroupingid` bigint(10) NOT NULL DEFAULT '0',
  `lang` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `calendartype` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `theme` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `requested` tinyint(1) NOT NULL DEFAULT '0',
  `enablecompletion` tinyint(1) NOT NULL DEFAULT '0',
  `completionnotify` tinyint(1) NOT NULL DEFAULT '0',
  `cacherev` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_cour_cat_ix` (`category`),
  KEY `mdl_cour_idn_ix` (`idnumber`),
  KEY `mdl_cour_sho_ix` (`shortname`),
  KEY `mdl_cour_sor_ix` (`sortorder`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Central course table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course`
--

LOCK TABLES `mdl_course` WRITE;
/*!40000 ALTER TABLE `mdl_course` DISABLE KEYS */;
INSERT INTO `mdl_course` VALUES (1,0,1,'HR Assessment Online','HR Assessment','','',0,'site',1,3,0,0,0,0,0,0,1,1,0,0,0,'','','',1547809378,1547810149,0,0,0,1551237298),(2,2,20001,'Assessment Test','Assessment Test','INT29012019','',1,'topics',1,5,1548781200,1580317200,0,0,0,0,1,1,0,0,0,'','','',1548760374,1551208292,0,1,0,1551237298);
/*!40000 ALTER TABLE `mdl_course` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_categories`
--

DROP TABLE IF EXISTS `mdl_course_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `parent` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `coursecount` bigint(10) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `depth` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `theme` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_courcate_par_ix` (`parent`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Course categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_categories`
--

LOCK TABLES `mdl_course_categories` WRITE;
/*!40000 ALTER TABLE `mdl_course_categories` DISABLE KEYS */;
INSERT INTO `mdl_course_categories` VALUES (1,'Lain-lain',NULL,NULL,0,0,10000,0,1,1,1547809378,1,'/1',NULL),(2,'Tester','','',1,0,20000,1,1,1,1547824320,1,'/2',NULL);
/*!40000 ALTER TABLE `mdl_course_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_completion_aggr_methd`
--

DROP TABLE IF EXISTS `mdl_course_completion_aggr_methd`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_completion_aggr_methd` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '0',
  `value` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courcompaggrmeth_coucr_uix` (`course`,`criteriatype`),
  KEY `mdl_courcompaggrmeth_cou_ix` (`course`),
  KEY `mdl_courcompaggrmeth_cri_ix` (`criteriatype`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Course completion aggregation methods for criteria';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_completion_aggr_methd`
--

LOCK TABLES `mdl_course_completion_aggr_methd` WRITE;
/*!40000 ALTER TABLE `mdl_course_completion_aggr_methd` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_completion_aggr_methd` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_completion_crit_compl`
--

DROP TABLE IF EXISTS `mdl_course_completion_crit_compl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_completion_crit_compl` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriaid` bigint(10) NOT NULL DEFAULT '0',
  `gradefinal` decimal(10,5) DEFAULT NULL,
  `unenroled` bigint(10) DEFAULT NULL,
  `timecompleted` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courcompcritcomp_useco_uix` (`userid`,`course`,`criteriaid`),
  KEY `mdl_courcompcritcomp_use_ix` (`userid`),
  KEY `mdl_courcompcritcomp_cou_ix` (`course`),
  KEY `mdl_courcompcritcomp_cri_ix` (`criteriaid`),
  KEY `mdl_courcompcritcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Course completion user records';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_completion_crit_compl`
--

LOCK TABLES `mdl_course_completion_crit_compl` WRITE;
/*!40000 ALTER TABLE `mdl_course_completion_crit_compl` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_completion_crit_compl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_completion_criteria`
--

DROP TABLE IF EXISTS `mdl_course_completion_criteria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_completion_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) NOT NULL DEFAULT '0',
  `module` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `moduleinstance` bigint(10) DEFAULT NULL,
  `courseinstance` bigint(10) DEFAULT NULL,
  `enrolperiod` bigint(10) DEFAULT NULL,
  `timeend` bigint(10) DEFAULT NULL,
  `gradepass` decimal(10,5) DEFAULT NULL,
  `role` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_courcompcrit_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Course completion criteria';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_completion_criteria`
--

LOCK TABLES `mdl_course_completion_criteria` WRITE;
/*!40000 ALTER TABLE `mdl_course_completion_criteria` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_completion_criteria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_completion_defaults`
--

DROP TABLE IF EXISTS `mdl_course_completion_defaults`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_completion_defaults` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL,
  `module` bigint(10) NOT NULL,
  `completion` tinyint(1) NOT NULL DEFAULT '0',
  `completionview` tinyint(1) NOT NULL DEFAULT '0',
  `completionusegrade` tinyint(1) NOT NULL DEFAULT '0',
  `completionexpected` bigint(10) NOT NULL DEFAULT '0',
  `customrules` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courcompdefa_coumod_uix` (`course`,`module`),
  KEY `mdl_courcompdefa_mod_ix` (`module`),
  KEY `mdl_courcompdefa_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Default settings for activities completion';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_completion_defaults`
--

LOCK TABLES `mdl_course_completion_defaults` WRITE;
/*!40000 ALTER TABLE `mdl_course_completion_defaults` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_completion_defaults` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_completions`
--

DROP TABLE IF EXISTS `mdl_course_completions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_completions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `timeenrolled` bigint(10) NOT NULL DEFAULT '0',
  `timestarted` bigint(10) NOT NULL DEFAULT '0',
  `timecompleted` bigint(10) DEFAULT NULL,
  `reaggregate` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courcomp_usecou_uix` (`userid`,`course`),
  KEY `mdl_courcomp_use_ix` (`userid`),
  KEY `mdl_courcomp_cou_ix` (`course`),
  KEY `mdl_courcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Course completion records';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_completions`
--

LOCK TABLES `mdl_course_completions` WRITE;
/*!40000 ALTER TABLE `mdl_course_completions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_completions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_format_options`
--

DROP TABLE IF EXISTS `mdl_course_format_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_format_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `format` varchar(21) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sectionid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courformopti_couforsec_uix` (`courseid`,`format`,`sectionid`,`name`),
  KEY `mdl_courformopti_cou_ix` (`courseid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores format-specific options for the course or course sect';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_format_options`
--

LOCK TABLES `mdl_course_format_options` WRITE;
/*!40000 ALTER TABLE `mdl_course_format_options` DISABLE KEYS */;
INSERT INTO `mdl_course_format_options` VALUES (1,1,'site',0,'numsections','1'),(2,2,'topics',0,'hiddensections','0'),(3,2,'topics',0,'coursedisplay','0');
/*!40000 ALTER TABLE `mdl_course_format_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_modules`
--

DROP TABLE IF EXISTS `mdl_course_modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_modules` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `module` bigint(10) NOT NULL DEFAULT '0',
  `instance` bigint(10) NOT NULL DEFAULT '0',
  `section` bigint(10) NOT NULL DEFAULT '0',
  `idnumber` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added` bigint(10) NOT NULL DEFAULT '0',
  `score` smallint(4) NOT NULL DEFAULT '0',
  `indent` mediumint(5) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleoncoursepage` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `groupmode` smallint(4) NOT NULL DEFAULT '0',
  `groupingid` bigint(10) NOT NULL DEFAULT '0',
  `completion` tinyint(1) NOT NULL DEFAULT '0',
  `completiongradeitemnumber` bigint(10) DEFAULT NULL,
  `completionview` tinyint(1) NOT NULL DEFAULT '0',
  `completionexpected` bigint(10) NOT NULL DEFAULT '0',
  `showdescription` tinyint(1) NOT NULL DEFAULT '0',
  `availability` longtext COLLATE utf8mb4_unicode_ci,
  `deletioninprogress` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_courmodu_vis_ix` (`visible`),
  KEY `mdl_courmodu_cou_ix` (`course`),
  KEY `mdl_courmodu_mod_ix` (`module`),
  KEY `mdl_courmodu_ins_ix` (`instance`),
  KEY `mdl_courmodu_idncou_ix` (`idnumber`,`course`),
  KEY `mdl_courmodu_gro_ix` (`groupingid`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='course_modules table retrofitted from MySQL';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_modules`
--

LOCK TABLES `mdl_course_modules` WRITE;
/*!40000 ALTER TABLE `mdl_course_modules` DISABLE KEYS */;
INSERT INTO `mdl_course_modules` VALUES (1,2,9,1,1,NULL,1548760376,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(2,2,1,1,2,'',1548770536,0,0,1,1,1,0,0,1,NULL,0,0,0,NULL,0),(3,2,23,1,3,'',1551203143,0,0,1,1,1,0,0,1,NULL,0,0,0,NULL,0),(4,2,7,1,4,'',1551203331,0,0,1,1,1,0,0,1,NULL,0,0,0,NULL,0),(5,2,16,1,5,'',1551206446,0,0,1,1,1,0,0,1,NULL,0,0,0,NULL,0);
/*!40000 ALTER TABLE `mdl_course_modules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_modules_completion`
--

DROP TABLE IF EXISTS `mdl_course_modules_completion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_modules_completion` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `coursemoduleid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `completionstate` tinyint(1) NOT NULL,
  `viewed` tinyint(1) DEFAULT NULL,
  `overrideby` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courmoducomp_usecou_uix` (`userid`,`coursemoduleid`),
  KEY `mdl_courmoducomp_cou_ix` (`coursemoduleid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the completion state (completed or not completed, etc';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_modules_completion`
--

LOCK TABLES `mdl_course_modules_completion` WRITE;
/*!40000 ALTER TABLE `mdl_course_modules_completion` DISABLE KEYS */;
INSERT INTO `mdl_course_modules_completion` VALUES (1,2,2,1,0,NULL,1548780810);
/*!40000 ALTER TABLE `mdl_course_modules_completion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_published`
--

DROP TABLE IF EXISTS `mdl_course_published`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_published` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `huburl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `courseid` bigint(10) NOT NULL,
  `timepublished` bigint(10) NOT NULL,
  `enrollable` tinyint(1) NOT NULL DEFAULT '1',
  `hubcourseid` bigint(10) NOT NULL,
  `status` tinyint(1) DEFAULT '0',
  `timechecked` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Information about how and when an local courses were publish';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_published`
--

LOCK TABLES `mdl_course_published` WRITE;
/*!40000 ALTER TABLE `mdl_course_published` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_published` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_request`
--

DROP TABLE IF EXISTS `mdl_course_request`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_request` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `fullname` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `shortname` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `summary` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `category` bigint(10) NOT NULL DEFAULT '0',
  `reason` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `requester` bigint(10) NOT NULL DEFAULT '0',
  `password` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_courrequ_sho_ix` (`shortname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='course requests';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_request`
--

LOCK TABLES `mdl_course_request` WRITE;
/*!40000 ALTER TABLE `mdl_course_request` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_request` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_sections`
--

DROP TABLE IF EXISTS `mdl_course_sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_sections` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `section` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `summary` longtext COLLATE utf8mb4_unicode_ci,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `sequence` longtext COLLATE utf8mb4_unicode_ci,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `availability` longtext COLLATE utf8mb4_unicode_ci,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_coursect_cousec_uix` (`course`,`section`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='to define the sections for each course';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_sections`
--

LOCK TABLES `mdl_course_sections` WRITE;
/*!40000 ALTER TABLE `mdl_course_sections` DISABLE KEYS */;
INSERT INTO `mdl_course_sections` VALUES (1,2,0,NULL,'',1,'1',1,NULL,1548760376),(2,2,1,'Pendahuluan','',1,'2',1,NULL,1548771254),(3,2,2,'Interview','',1,'3',1,NULL,1551208046),(4,2,3,'Personality','',1,'4',1,NULL,1551208051),(5,2,4,'Reasoning','',1,'5',1,NULL,1551208060),(6,1,1,NULL,'',1,'',1,NULL,1548773119);
/*!40000 ALTER TABLE `mdl_course_sections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_data`
--

DROP TABLE IF EXISTS `mdl_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_data` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `comments` smallint(4) NOT NULL DEFAULT '0',
  `timeavailablefrom` bigint(10) NOT NULL DEFAULT '0',
  `timeavailableto` bigint(10) NOT NULL DEFAULT '0',
  `timeviewfrom` bigint(10) NOT NULL DEFAULT '0',
  `timeviewto` bigint(10) NOT NULL DEFAULT '0',
  `requiredentries` int(8) NOT NULL DEFAULT '0',
  `requiredentriestoview` int(8) NOT NULL DEFAULT '0',
  `maxentries` int(8) NOT NULL DEFAULT '0',
  `rssarticles` smallint(4) NOT NULL DEFAULT '0',
  `singletemplate` longtext COLLATE utf8mb4_unicode_ci,
  `listtemplate` longtext COLLATE utf8mb4_unicode_ci,
  `listtemplateheader` longtext COLLATE utf8mb4_unicode_ci,
  `listtemplatefooter` longtext COLLATE utf8mb4_unicode_ci,
  `addtemplate` longtext COLLATE utf8mb4_unicode_ci,
  `rsstemplate` longtext COLLATE utf8mb4_unicode_ci,
  `rsstitletemplate` longtext COLLATE utf8mb4_unicode_ci,
  `csstemplate` longtext COLLATE utf8mb4_unicode_ci,
  `jstemplate` longtext COLLATE utf8mb4_unicode_ci,
  `asearchtemplate` longtext COLLATE utf8mb4_unicode_ci,
  `approval` smallint(4) NOT NULL DEFAULT '0',
  `manageapproved` smallint(4) NOT NULL DEFAULT '1',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `assessed` bigint(10) NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) NOT NULL DEFAULT '0',
  `defaultsort` bigint(10) NOT NULL DEFAULT '0',
  `defaultsortdir` smallint(4) NOT NULL DEFAULT '0',
  `editany` smallint(4) NOT NULL DEFAULT '0',
  `notification` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `config` longtext COLLATE utf8mb4_unicode_ci,
  `completionentries` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_data_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='all database activities';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_data`
--

LOCK TABLES `mdl_data` WRITE;
/*!40000 ALTER TABLE `mdl_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_data_content`
--

DROP TABLE IF EXISTS `mdl_data_content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_data_content` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `fieldid` bigint(10) NOT NULL DEFAULT '0',
  `recordid` bigint(10) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `content1` longtext COLLATE utf8mb4_unicode_ci,
  `content2` longtext COLLATE utf8mb4_unicode_ci,
  `content3` longtext COLLATE utf8mb4_unicode_ci,
  `content4` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_datacont_rec_ix` (`recordid`),
  KEY `mdl_datacont_fie_ix` (`fieldid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='the content introduced in each record/fields';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_data_content`
--

LOCK TABLES `mdl_data_content` WRITE;
/*!40000 ALTER TABLE `mdl_data_content` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_data_content` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_data_fields`
--

DROP TABLE IF EXISTS `mdl_data_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_data_fields` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `dataid` bigint(10) NOT NULL DEFAULT '0',
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `param1` longtext COLLATE utf8mb4_unicode_ci,
  `param2` longtext COLLATE utf8mb4_unicode_ci,
  `param3` longtext COLLATE utf8mb4_unicode_ci,
  `param4` longtext COLLATE utf8mb4_unicode_ci,
  `param5` longtext COLLATE utf8mb4_unicode_ci,
  `param6` longtext COLLATE utf8mb4_unicode_ci,
  `param7` longtext COLLATE utf8mb4_unicode_ci,
  `param8` longtext COLLATE utf8mb4_unicode_ci,
  `param9` longtext COLLATE utf8mb4_unicode_ci,
  `param10` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_datafiel_typdat_ix` (`type`,`dataid`),
  KEY `mdl_datafiel_dat_ix` (`dataid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='every field available';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_data_fields`
--

LOCK TABLES `mdl_data_fields` WRITE;
/*!40000 ALTER TABLE `mdl_data_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_data_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_data_records`
--

DROP TABLE IF EXISTS `mdl_data_records`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_data_records` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `dataid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `approved` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_datareco_dat_ix` (`dataid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='every record introduced';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_data_records`
--

LOCK TABLES `mdl_data_records` WRITE;
/*!40000 ALTER TABLE `mdl_data_records` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_data_records` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_editor_atto_autosave`
--

DROP TABLE IF EXISTS `mdl_editor_atto_autosave`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_editor_atto_autosave` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `elementid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `pagehash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `userid` bigint(10) NOT NULL,
  `drafttext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `draftid` bigint(10) DEFAULT NULL,
  `pageinstance` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_editattoauto_eleconuse_uix` (`elementid`,`contextid`,`userid`,`pagehash`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Draft text that is auto-saved every 5 seconds while an edito';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_editor_atto_autosave`
--

LOCK TABLES `mdl_editor_atto_autosave` WRITE;
/*!40000 ALTER TABLE `mdl_editor_atto_autosave` DISABLE KEYS */;
INSERT INTO `mdl_editor_atto_autosave` VALUES (3,'id_summary_editor',25,'9febb532ede6332a4505a386e0c27a0d6ad314d5',2,'',635604555,'yui_3_17_2_1_1547825312162_285',1547825315),(7,'id_s_theme_more_footnote',1,'0902f6fd78348d4c19ad4672090a610bd42cd53d',2,'',-1,'yui_3_17_2_1_1548772028065_121',1548772030),(11,'id_s_theme_clean_footnote',1,'2d487106e78889e1a15559ee5ac9358cc9f07612',2,'',-1,'yui_3_17_2_1_1548772115853_49',1548772117),(14,'id_s_theme_clean_footnote',1,'2319a6e8c5a5d379610d6c331cc4f1f07c8254ab',2,'',-1,'yui_3_17_2_1_1548772309526_67',1548772313),(15,'id_s_theme_more_footnote',1,'2319a6e8c5a5d379610d6c331cc4f1f07c8254ab',2,'',-1,'yui_3_17_2_1_1548772309526_404',1548772313),(25,'id_s__summary',1,'cc64565ea334d2b8c0236d567023cbf89c286666',2,'',-1,'yui_3_17_2_1_1548773251139_112',1548773256),(47,'id_s_theme_adaptable_sitetitletext',5,'e5ff97d1f14126c3ec8e17060c2b5ddf16a5fa3d',2,'',247070505,'yui_3_17_2_1_1548780625626_116',1548780628),(48,'id_assignfeedbackcomments_editor',28,'8597fbda04306f6f7d1fd5930a1ae00331ec3aaf',2,'',764804899,'yui_3_17_2_1_1548780966819_2626',1548780993),(55,'id_introeditor',26,'90d4a76d7c64750f2915f3f06a89ab096fd6cd8a',2,'',NULL,'yui_3_17_2_1_1551200161462_416',1551201666),(58,'id_s__maintenance_message',1,'2c7a1a9fb89f6c9fb1dddf91e391933b053d9d68',2,'',-1,'yui_3_17_2_1_1551240637940_111',1551240639);
/*!40000 ALTER TABLE `mdl_editor_atto_autosave` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol`
--

DROP TABLE IF EXISTS `mdl_enrol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `enrol` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enrolperiod` bigint(10) DEFAULT '0',
  `enrolstartdate` bigint(10) DEFAULT '0',
  `enrolenddate` bigint(10) DEFAULT '0',
  `expirynotify` tinyint(1) DEFAULT '0',
  `expirythreshold` bigint(10) DEFAULT '0',
  `notifyall` tinyint(1) DEFAULT '0',
  `password` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `roleid` bigint(10) DEFAULT '0',
  `customint1` bigint(10) DEFAULT NULL,
  `customint2` bigint(10) DEFAULT NULL,
  `customint3` bigint(10) DEFAULT NULL,
  `customint4` bigint(10) DEFAULT NULL,
  `customint5` bigint(10) DEFAULT NULL,
  `customint6` bigint(10) DEFAULT NULL,
  `customint7` bigint(10) DEFAULT NULL,
  `customint8` bigint(10) DEFAULT NULL,
  `customchar1` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customchar2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customchar3` varchar(1333) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customdec1` decimal(12,7) DEFAULT NULL,
  `customdec2` decimal(12,7) DEFAULT NULL,
  `customtext1` longtext COLLATE utf8mb4_unicode_ci,
  `customtext2` longtext COLLATE utf8mb4_unicode_ci,
  `customtext3` longtext COLLATE utf8mb4_unicode_ci,
  `customtext4` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_enro_enr_ix` (`enrol`),
  KEY `mdl_enro_cou_ix` (`courseid`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Instances of enrolment plugins used in courses, fields marke';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol`
--

LOCK TABLES `mdl_enrol` WRITE;
/*!40000 ALTER TABLE `mdl_enrol` DISABLE KEYS */;
INSERT INTO `mdl_enrol` VALUES (1,'manual',1,2,1,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1548760377,1548760377),(2,'guest',1,2,2,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1548760377,1548760377),(3,'self',1,2,3,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1548760377,1548760377),(4,'paypal',0,2,0,'PayPal',2592000,1551238380,1561606380,0,0,0,NULL,'1','USD',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1551238114,1551238437);
/*!40000 ALTER TABLE `mdl_enrol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_flatfile`
--

DROP TABLE IF EXISTS `mdl_enrol_flatfile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_flatfile` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `roleid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_enroflat_cou_ix` (`courseid`),
  KEY `mdl_enroflat_use_ix` (`userid`),
  KEY `mdl_enroflat_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='enrol_flatfile table retrofitted from MySQL';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_flatfile`
--

LOCK TABLES `mdl_enrol_flatfile` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_flatfile` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_flatfile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_lti2_consumer`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_lti2_consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_lti2_consumer` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `consumerkey256` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `consumerkey` longtext COLLATE utf8mb4_unicode_ci,
  `secret` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ltiversion` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `consumername` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `consumerversion` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `consumerguid` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profile` longtext COLLATE utf8mb4_unicode_ci,
  `toolproxy` longtext COLLATE utf8mb4_unicode_ci,
  `settings` longtext COLLATE utf8mb4_unicode_ci,
  `protected` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `enablefrom` bigint(10) DEFAULT NULL,
  `enableuntil` bigint(10) DEFAULT NULL,
  `lastaccess` bigint(10) DEFAULT NULL,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_enroltilti2cons_con_uix` (`consumerkey256`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='LTI consumers interacting with moodle';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_lti2_consumer`
--

LOCK TABLES `mdl_enrol_lti_lti2_consumer` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_lti2_context`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_lti2_context`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_lti2_context` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `consumerid` bigint(11) NOT NULL,
  `lticontextkey` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `settings` longtext COLLATE utf8mb4_unicode_ci,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_enroltilti2cont_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Information about a specific LTI contexts from the consumers';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_lti2_context`
--

LOCK TABLES `mdl_enrol_lti_lti2_context` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_context` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_context` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_lti2_nonce`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_lti2_nonce`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_lti2_nonce` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `consumerid` bigint(11) NOT NULL,
  `value` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `expires` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_enroltilti2nonc_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Nonce used for authentication between moodle and a consumer';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_lti2_nonce`
--

LOCK TABLES `mdl_enrol_lti_lti2_nonce` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_nonce` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_nonce` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_lti2_resource_link`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_lti2_resource_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_lti2_resource_link` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(11) DEFAULT NULL,
  `consumerid` bigint(11) DEFAULT NULL,
  `ltiresourcelinkkey` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `settings` longtext COLLATE utf8mb4_unicode_ci,
  `primaryresourcelinkid` bigint(11) DEFAULT NULL,
  `shareapproved` tinyint(1) DEFAULT NULL,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_enroltilti2resolink_con_ix` (`contextid`),
  KEY `mdl_enroltilti2resolink_pri_ix` (`primaryresourcelinkid`),
  KEY `mdl_enroltilti2resolink_co2_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link from the consumer to the tool';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_lti2_resource_link`
--

LOCK TABLES `mdl_enrol_lti_lti2_resource_link` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_resource_link` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_resource_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_lti2_share_key`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_lti2_share_key`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_lti2_share_key` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `sharekey` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `resourcelinkid` bigint(11) NOT NULL,
  `autoapprove` tinyint(1) NOT NULL,
  `expires` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_enroltilti2sharkey_sha_uix` (`sharekey`),
  UNIQUE KEY `mdl_enroltilti2sharkey_res_uix` (`resourcelinkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Resource link share key';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_lti2_share_key`
--

LOCK TABLES `mdl_enrol_lti_lti2_share_key` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_share_key` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_share_key` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_lti2_tool_proxy`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_lti2_tool_proxy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_lti2_tool_proxy` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `toolproxykey` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `consumerid` bigint(11) NOT NULL,
  `toolproxy` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_enroltilti2toolprox_to_uix` (`toolproxykey`),
  KEY `mdl_enroltilti2toolprox_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='A tool proxy between moodle and a consumer';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_lti2_tool_proxy`
--

LOCK TABLES `mdl_enrol_lti_lti2_tool_proxy` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_tool_proxy` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_tool_proxy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_lti2_user_result`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_lti2_user_result`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_lti2_user_result` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `resourcelinkid` bigint(11) NOT NULL,
  `ltiuserkey` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ltiresultsourcedid` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_enroltilti2userresu_res_ix` (`resourcelinkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Results for each user for each resource link';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_lti2_user_result`
--

LOCK TABLES `mdl_enrol_lti_lti2_user_result` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_user_result` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_user_result` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_tool_consumer_map`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_tool_consumer_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_tool_consumer_map` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `toolid` bigint(11) NOT NULL,
  `consumerid` bigint(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_enroltitoolconsmap_too_ix` (`toolid`),
  KEY `mdl_enroltitoolconsmap_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Table that maps the published tool to tool consumers.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_tool_consumer_map`
--

LOCK TABLES `mdl_enrol_lti_tool_consumer_map` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_tool_consumer_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_tool_consumer_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_tools`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_tools`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_tools` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `enrolid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `institution` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lang` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `timezone` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '99',
  `maxenrolled` bigint(10) NOT NULL DEFAULT '0',
  `maildisplay` tinyint(2) NOT NULL DEFAULT '2',
  `city` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `gradesync` tinyint(1) NOT NULL DEFAULT '0',
  `gradesynccompletion` tinyint(1) NOT NULL DEFAULT '0',
  `membersync` tinyint(1) NOT NULL DEFAULT '0',
  `membersyncmode` tinyint(1) NOT NULL DEFAULT '0',
  `roleinstructor` bigint(10) NOT NULL,
  `rolelearner` bigint(10) NOT NULL,
  `secret` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_enroltitool_enr_ix` (`enrolid`),
  KEY `mdl_enroltitool_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='List of tools provided to the remote system';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_tools`
--

LOCK TABLES `mdl_enrol_lti_tools` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_tools` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_tools` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_users`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_users` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `toolid` bigint(10) NOT NULL,
  `serviceurl` longtext COLLATE utf8mb4_unicode_ci,
  `sourceid` longtext COLLATE utf8mb4_unicode_ci,
  `consumerkey` longtext COLLATE utf8mb4_unicode_ci,
  `consumersecret` longtext COLLATE utf8mb4_unicode_ci,
  `membershipsurl` longtext COLLATE utf8mb4_unicode_ci,
  `membershipsid` longtext COLLATE utf8mb4_unicode_ci,
  `lastgrade` decimal(10,5) DEFAULT NULL,
  `lastaccess` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_enroltiuser_use_ix` (`userid`),
  KEY `mdl_enroltiuser_too_ix` (`toolid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='User access log and gradeback data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_users`
--

LOCK TABLES `mdl_enrol_lti_users` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_paypal`
--

DROP TABLE IF EXISTS `mdl_enrol_paypal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_paypal` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `business` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `receiver_email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `receiver_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `item_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `instanceid` bigint(10) NOT NULL DEFAULT '0',
  `memo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_name1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_selection1_x` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_name2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_selection2_x` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `payment_status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pending_reason` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `reason_code` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `txn_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parent_txn_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `payment_type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timeupdated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_enropayp_bus_ix` (`business`),
  KEY `mdl_enropayp_rec_ix` (`receiver_email`),
  KEY `mdl_enropayp_cou_ix` (`courseid`),
  KEY `mdl_enropayp_use_ix` (`userid`),
  KEY `mdl_enropayp_ins_ix` (`instanceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Holds all known information about PayPal transactions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_paypal`
--

LOCK TABLES `mdl_enrol_paypal` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_paypal` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_paypal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_event`
--

DROP TABLE IF EXISTS `mdl_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_event` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `format` smallint(4) NOT NULL DEFAULT '0',
  `categoryid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `repeatid` bigint(10) NOT NULL DEFAULT '0',
  `modulename` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `instance` bigint(10) NOT NULL DEFAULT '0',
  `type` smallint(4) NOT NULL DEFAULT '0',
  `eventtype` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeduration` bigint(10) NOT NULL DEFAULT '0',
  `timesort` bigint(10) DEFAULT NULL,
  `visible` smallint(4) NOT NULL DEFAULT '1',
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sequence` bigint(10) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `subscriptionid` bigint(10) DEFAULT NULL,
  `priority` bigint(10) DEFAULT NULL,
  `location` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_even_cou_ix` (`courseid`),
  KEY `mdl_even_use_ix` (`userid`),
  KEY `mdl_even_tim_ix` (`timestart`),
  KEY `mdl_even_tim2_ix` (`timeduration`),
  KEY `mdl_even_uui_ix` (`uuid`),
  KEY `mdl_even_typtim_ix` (`type`,`timesort`),
  KEY `mdl_even_grocoucatvisuse_ix` (`groupid`,`courseid`,`categoryid`,`visible`,`userid`),
  KEY `mdl_even_cat_ix` (`categoryid`),
  KEY `mdl_even_sub_ix` (`subscriptionid`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='For everything with a time associated to it';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_event`
--

LOCK TABLES `mdl_event` WRITE;
/*!40000 ALTER TABLE `mdl_event` DISABLE KEYS */;
INSERT INTO `mdl_event` VALUES (1,'Absensi is due','',1,0,2,0,2,0,'assign',1,1,'due',1549299600,0,1549299600,1,'',1,1548770537,NULL,NULL,NULL),(2,'Absensi is due to be graded','',1,0,2,0,2,0,'assign',1,1,'gradingdue',1549904400,0,1549904400,1,'',1,1548770537,NULL,NULL,NULL);
/*!40000 ALTER TABLE `mdl_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_event_subscriptions`
--

DROP TABLE IF EXISTS `mdl_event_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_event_subscriptions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `categoryid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `eventtype` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pollinterval` bigint(10) NOT NULL DEFAULT '0',
  `lastupdated` bigint(10) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Tracks subscriptions to remote calendars.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_event_subscriptions`
--

LOCK TABLES `mdl_event_subscriptions` WRITE;
/*!40000 ALTER TABLE `mdl_event_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_event_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_events_handlers`
--

DROP TABLE IF EXISTS `mdl_events_handlers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_events_handlers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventname` varchar(166) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `component` varchar(166) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `handlerfile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `handlerfunction` longtext COLLATE utf8mb4_unicode_ci,
  `schedule` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `internal` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_evenhand_evecom_uix` (`eventname`,`component`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table is for storing which components requests what typ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_events_handlers`
--

LOCK TABLES `mdl_events_handlers` WRITE;
/*!40000 ALTER TABLE `mdl_events_handlers` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_events_handlers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_events_queue`
--

DROP TABLE IF EXISTS `mdl_events_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_events_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventdata` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `stackdump` longtext COLLATE utf8mb4_unicode_ci,
  `userid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_evenqueu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table is for storing queued events. It stores only one ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_events_queue`
--

LOCK TABLES `mdl_events_queue` WRITE;
/*!40000 ALTER TABLE `mdl_events_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_events_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_events_queue_handlers`
--

DROP TABLE IF EXISTS `mdl_events_queue_handlers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_events_queue_handlers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `queuedeventid` bigint(10) NOT NULL,
  `handlerid` bigint(10) NOT NULL,
  `status` bigint(10) DEFAULT NULL,
  `errormessage` longtext COLLATE utf8mb4_unicode_ci,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_evenqueuhand_que_ix` (`queuedeventid`),
  KEY `mdl_evenqueuhand_han_ix` (`handlerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This is the list of queued handlers for processing. The even';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_events_queue_handlers`
--

LOCK TABLES `mdl_events_queue_handlers` WRITE;
/*!40000 ALTER TABLE `mdl_events_queue_handlers` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_events_queue_handlers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_functions`
--

DROP TABLE IF EXISTS `mdl_external_functions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_functions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `classname` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `methodname` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `classpath` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `capabilities` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `services` varchar(1333) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_extefunc_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=535 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='list of all external functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_functions`
--

LOCK TABLES `mdl_external_functions` WRITE;
/*!40000 ALTER TABLE `mdl_external_functions` DISABLE KEYS */;
INSERT INTO `mdl_external_functions` VALUES (1,'core_auth_confirm_user','core_auth_external','confirm_user',NULL,'moodle','',NULL),(2,'core_auth_request_password_reset','core_auth_external','request_password_reset',NULL,'moodle','',NULL),(3,'core_auth_is_minor','core_auth_external','is_minor',NULL,'moodle','',NULL),(4,'core_auth_is_age_digital_consent_verification_enabled','core_auth_external','is_age_digital_consent_verification_enabled',NULL,'moodle','',NULL),(5,'core_auth_resend_confirmation_email','core_auth_external','resend_confirmation_email',NULL,'moodle','',NULL),(6,'core_badges_get_user_badges','core_badges_external','get_user_badges',NULL,'moodle','moodle/badges:viewotherbadges','moodle_mobile_app'),(7,'core_blog_get_entries','core_blog\\external','get_entries',NULL,'moodle','','moodle_mobile_app'),(8,'core_blog_view_entries','core_blog\\external','view_entries',NULL,'moodle','','moodle_mobile_app'),(9,'core_calendar_get_calendar_monthly_view','core_calendar_external','get_calendar_monthly_view','calendar/externallib.php','moodle','','moodle_mobile_app'),(10,'core_calendar_get_calendar_day_view','core_calendar_external','get_calendar_day_view','calendar/externallib.php','moodle','','moodle_mobile_app'),(11,'core_calendar_get_calendar_upcoming_view','core_calendar_external','get_calendar_upcoming_view','calendar/externallib.php','moodle','','moodle_mobile_app'),(12,'core_calendar_update_event_start_day','core_calendar_external','update_event_start_day','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries',NULL),(13,'core_calendar_create_calendar_events','core_calendar_external','create_calendar_events','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(14,'core_calendar_delete_calendar_events','core_calendar_external','delete_calendar_events','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(15,'core_calendar_get_calendar_events','core_calendar_external','get_calendar_events','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(16,'core_calendar_get_action_events_by_timesort','core_calendar_external','get_calendar_action_events_by_timesort','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(17,'core_calendar_get_action_events_by_course','core_calendar_external','get_calendar_action_events_by_course','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(18,'core_calendar_get_action_events_by_courses','core_calendar_external','get_calendar_action_events_by_courses','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(19,'core_calendar_get_calendar_event_by_id','core_calendar_external','get_calendar_event_by_id','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(20,'core_calendar_submit_create_update_form','core_calendar_external','submit_create_update_form','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries',NULL),(21,'core_cohort_add_cohort_members','core_cohort_external','add_cohort_members','cohort/externallib.php','moodle','moodle/cohort:assign',NULL),(22,'core_cohort_create_cohorts','core_cohort_external','create_cohorts','cohort/externallib.php','moodle','moodle/cohort:manage',NULL),(23,'core_cohort_delete_cohort_members','core_cohort_external','delete_cohort_members','cohort/externallib.php','moodle','moodle/cohort:assign',NULL),(24,'core_cohort_delete_cohorts','core_cohort_external','delete_cohorts','cohort/externallib.php','moodle','moodle/cohort:manage',NULL),(25,'core_cohort_get_cohort_members','core_cohort_external','get_cohort_members','cohort/externallib.php','moodle','moodle/cohort:view',NULL),(26,'core_cohort_search_cohorts','core_cohort_external','search_cohorts','cohort/externallib.php','moodle','moodle/cohort:view',NULL),(27,'core_cohort_get_cohorts','core_cohort_external','get_cohorts','cohort/externallib.php','moodle','moodle/cohort:view',NULL),(28,'core_cohort_update_cohorts','core_cohort_external','update_cohorts','cohort/externallib.php','moodle','moodle/cohort:manage',NULL),(29,'core_comment_get_comments','core_comment_external','get_comments',NULL,'moodle','moodle/comment:view','moodle_mobile_app'),(30,'core_completion_get_activities_completion_status','core_completion_external','get_activities_completion_status',NULL,'moodle','','moodle_mobile_app'),(31,'core_completion_get_course_completion_status','core_completion_external','get_course_completion_status',NULL,'moodle','report/completion:view','moodle_mobile_app'),(32,'core_completion_mark_course_self_completed','core_completion_external','mark_course_self_completed',NULL,'moodle','','moodle_mobile_app'),(33,'core_completion_update_activity_completion_status_manually','core_completion_external','update_activity_completion_status_manually',NULL,'moodle','','moodle_mobile_app'),(34,'core_completion_override_activity_completion_status','core_completion_external','override_activity_completion_status',NULL,'moodle','moodle/course:overridecompletion',NULL),(35,'core_course_create_categories','core_course_external','create_categories','course/externallib.php','moodle','moodle/category:manage',NULL),(36,'core_course_create_courses','core_course_external','create_courses','course/externallib.php','moodle','moodle/course:create, moodle/course:visibility',NULL),(37,'core_course_delete_categories','core_course_external','delete_categories','course/externallib.php','moodle','moodle/category:manage',NULL),(38,'core_course_delete_courses','core_course_external','delete_courses','course/externallib.php','moodle','moodle/course:delete',NULL),(39,'core_course_delete_modules','core_course_external','delete_modules','course/externallib.php','moodle','moodle/course:manageactivities',NULL),(40,'core_course_duplicate_course','core_course_external','duplicate_course','course/externallib.php','moodle','moodle/backup:backupcourse, moodle/restore:restorecourse, moodle/course:create',NULL),(41,'core_course_get_categories','core_course_external','get_categories','course/externallib.php','moodle','moodle/category:viewhiddencategories','moodle_mobile_app'),(42,'core_course_get_contents','core_course_external','get_course_contents','course/externallib.php','moodle','moodle/course:update, moodle/course:viewhiddencourses','moodle_mobile_app'),(43,'core_course_get_course_module','core_course_external','get_course_module','course/externallib.php','moodle','','moodle_mobile_app'),(44,'core_course_get_course_module_by_instance','core_course_external','get_course_module_by_instance','course/externallib.php','moodle','','moodle_mobile_app'),(45,'core_course_get_module','core_course_external','get_module','course/externallib.php','moodle','',NULL),(46,'core_course_edit_module','core_course_external','edit_module','course/externallib.php','moodle','',NULL),(47,'core_course_edit_section','core_course_external','edit_section','course/externallib.php','moodle','',NULL),(48,'core_course_get_courses','core_course_external','get_courses','course/externallib.php','moodle','moodle/course:view, moodle/course:update, moodle/course:viewhiddencourses','moodle_mobile_app'),(49,'core_course_import_course','core_course_external','import_course','course/externallib.php','moodle','moodle/backup:backuptargetimport, moodle/restore:restoretargetimport',NULL),(50,'core_course_search_courses','core_course_external','search_courses','course/externallib.php','moodle','','moodle_mobile_app'),(51,'core_course_update_categories','core_course_external','update_categories','course/externallib.php','moodle','moodle/category:manage',NULL),(52,'core_course_update_courses','core_course_external','update_courses','course/externallib.php','moodle','moodle/course:update, moodle/course:changecategory, moodle/course:changefullname, moodle/course:changeshortname, moodle/course:changeidnumber, moodle/course:changesummary, moodle/course:visibility',NULL),(53,'core_course_view_course','core_course_external','view_course','course/externallib.php','moodle','','moodle_mobile_app'),(54,'core_course_get_activities_overview','core_course_external','get_activities_overview','course/externallib.php','moodle','','moodle_mobile_app'),(55,'core_course_get_user_navigation_options','core_course_external','get_user_navigation_options','course/externallib.php','moodle','','moodle_mobile_app'),(56,'core_course_get_user_administration_options','core_course_external','get_user_administration_options','course/externallib.php','moodle','','moodle_mobile_app'),(57,'core_course_get_courses_by_field','core_course_external','get_courses_by_field','course/externallib.php','moodle','','moodle_mobile_app'),(58,'core_course_check_updates','core_course_external','check_updates','course/externallib.php','moodle','','moodle_mobile_app'),(59,'core_course_get_updates_since','core_course_external','get_updates_since','course/externallib.php','moodle','','moodle_mobile_app'),(60,'core_course_get_enrolled_courses_by_timeline_classification','core_course_external','get_enrolled_courses_by_timeline_classification','course/externallib.php','moodle','','moodle_mobile_app'),(61,'core_course_get_recent_courses','core_course_external','get_recent_courses','course/externallib.php','moodle','','moodle_mobile_app'),(62,'core_course_set_favourite_courses','core_course_external','set_favourite_courses','course/externallib.php','moodle','','moodle_mobile_app'),(63,'core_enrol_get_course_enrolment_methods','core_enrol_external','get_course_enrolment_methods','enrol/externallib.php','moodle','','moodle_mobile_app'),(64,'core_enrol_get_enrolled_users','core_enrol_external','get_enrolled_users','enrol/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups','moodle_mobile_app'),(65,'core_enrol_get_enrolled_users_with_capability','core_enrol_external','get_enrolled_users_with_capability','enrol/externallib.php','moodle','',NULL),(66,'core_enrol_get_potential_users','core_enrol_external','get_potential_users','enrol/externallib.php','moodle','moodle/course:enrolreview',NULL),(67,'core_enrol_get_users_courses','core_enrol_external','get_users_courses','enrol/externallib.php','moodle','moodle/course:viewparticipants','moodle_mobile_app'),(68,'core_enrol_edit_user_enrolment','core_enrol_external','edit_user_enrolment','enrol/externallib.php','moodle','',NULL),(69,'core_enrol_unenrol_user_enrolment','core_enrol_external','unenrol_user_enrolment','enrol/externallib.php','moodle','',NULL),(70,'core_fetch_notifications','core_external','fetch_notifications','lib/external/externallib.php','moodle','',NULL),(71,'core_files_get_files','core_files_external','get_files','files/externallib.php','moodle','','moodle_mobile_app'),(72,'core_files_upload','core_files_external','upload','files/externallib.php','moodle','',NULL),(73,'core_form_get_filetypes_browser_data','core_form\\external','get_filetypes_browser_data',NULL,'moodle','',NULL),(74,'core_get_component_strings','core_external','get_component_strings','lib/external/externallib.php','moodle','','moodle_mobile_app'),(75,'core_get_fragment','core_external','get_fragment','lib/external/externallib.php','moodle','',NULL),(76,'core_get_string','core_external','get_string','lib/external/externallib.php','moodle','',NULL),(77,'core_get_strings','core_external','get_strings','lib/external/externallib.php','moodle','',NULL),(78,'core_get_user_dates','core_external','get_user_dates','lib/external/externallib.php','moodle','',NULL),(79,'core_grades_get_grades','core_grades_external','get_grades',NULL,'moodle','moodle/grade:view, moodle/grade:viewall, moodle/grade:viewhidden',NULL),(80,'core_grades_update_grades','core_grades_external','update_grades',NULL,'moodle','',NULL),(81,'core_grading_get_definitions','core_grading_external','get_definitions',NULL,'moodle','',NULL),(82,'core_grading_get_gradingform_instances','core_grading_external','get_gradingform_instances',NULL,'moodle','',NULL),(83,'core_grading_save_definitions','core_grading_external','save_definitions',NULL,'moodle','',NULL),(84,'core_group_add_group_members','core_group_external','add_group_members','group/externallib.php','moodle','moodle/course:managegroups',NULL),(85,'core_group_assign_grouping','core_group_external','assign_grouping','group/externallib.php','moodle','',NULL),(86,'core_group_create_groupings','core_group_external','create_groupings','group/externallib.php','moodle','',NULL),(87,'core_group_create_groups','core_group_external','create_groups','group/externallib.php','moodle','moodle/course:managegroups',NULL),(88,'core_group_delete_group_members','core_group_external','delete_group_members','group/externallib.php','moodle','moodle/course:managegroups',NULL),(89,'core_group_delete_groupings','core_group_external','delete_groupings','group/externallib.php','moodle','',NULL),(90,'core_group_delete_groups','core_group_external','delete_groups','group/externallib.php','moodle','moodle/course:managegroups',NULL),(91,'core_group_get_activity_allowed_groups','core_group_external','get_activity_allowed_groups','group/externallib.php','moodle','','moodle_mobile_app'),(92,'core_group_get_activity_groupmode','core_group_external','get_activity_groupmode','group/externallib.php','moodle','','moodle_mobile_app'),(93,'core_group_get_course_groupings','core_group_external','get_course_groupings','group/externallib.php','moodle','',NULL),(94,'core_group_get_course_groups','core_group_external','get_course_groups','group/externallib.php','moodle','moodle/course:managegroups',NULL),(95,'core_group_get_course_user_groups','core_group_external','get_course_user_groups','group/externallib.php','moodle','moodle/course:managegroups','moodle_mobile_app'),(96,'core_group_get_group_members','core_group_external','get_group_members','group/externallib.php','moodle','moodle/course:managegroups',NULL),(97,'core_group_get_groupings','core_group_external','get_groupings','group/externallib.php','moodle','',NULL),(98,'core_group_get_groups','core_group_external','get_groups','group/externallib.php','moodle','moodle/course:managegroups',NULL),(99,'core_group_unassign_grouping','core_group_external','unassign_grouping','group/externallib.php','moodle','',NULL),(100,'core_group_update_groupings','core_group_external','update_groupings','group/externallib.php','moodle','',NULL),(101,'core_group_update_groups','core_group_external','update_groups','group/externallib.php','moodle','moodle/course:managegroups',NULL),(102,'core_message_block_user','core_message_external','block_user','message/externallib.php','moodle','','moodle_mobile_app'),(103,'core_message_block_contacts','core_message_external','block_contacts','message/externallib.php','moodle','','moodle_mobile_app'),(104,'core_message_create_contacts','core_message_external','create_contacts','message/externallib.php','moodle','','moodle_mobile_app'),(105,'core_message_get_contact_requests','core_message_external','get_contact_requests','message/externallib.php','moodle','','moodle_mobile_app'),(106,'core_message_create_contact_request','core_message_external','create_contact_request','message/externallib.php','moodle','','moodle_mobile_app'),(107,'core_message_confirm_contact_request','core_message_external','confirm_contact_request','message/externallib.php','moodle','','moodle_mobile_app'),(108,'core_message_decline_contact_request','core_message_external','decline_contact_request','message/externallib.php','moodle','','moodle_mobile_app'),(109,'core_message_get_received_contact_requests_count','core_message_external','get_received_contact_requests_count','message/externallib.php','moodle','','moodle_mobile_app'),(110,'core_message_delete_contacts','core_message_external','delete_contacts','message/externallib.php','moodle','','moodle_mobile_app'),(111,'core_message_delete_conversation','core_message_external','delete_conversation','message/externallib.php','moodle','moodle/site:deleteownmessage','moodle_mobile_app'),(112,'core_message_delete_conversations_by_id','core_message_external','delete_conversations_by_id','message/externallib.php','moodle','moodle/site:deleteownmessage','moodle_mobile_app'),(113,'core_message_delete_message','core_message_external','delete_message','message/externallib.php','moodle','moodle/site:deleteownmessage','moodle_mobile_app'),(114,'core_message_get_blocked_users','core_message_external','get_blocked_users','message/externallib.php','moodle','','moodle_mobile_app'),(115,'core_message_data_for_messagearea_search_messages','core_message_external','data_for_messagearea_search_messages','message/externallib.php','moodle','','moodle_mobile_app'),(116,'core_message_data_for_messagearea_search_users','core_message_external','data_for_messagearea_search_users','message/externallib.php','moodle','',NULL),(117,'core_message_data_for_messagearea_search_users_in_course','core_message_external','data_for_messagearea_search_users_in_course','message/externallib.php','moodle','',NULL),(118,'core_message_message_search_users','core_message_external','message_search_users','message/externallib.php','moodle','','moodle_mobile_app'),(119,'core_message_data_for_messagearea_conversations','core_message_external','data_for_messagearea_conversations','message/externallib.php','moodle','','moodle_mobile_app'),(120,'core_message_data_for_messagearea_contacts','core_message_external','data_for_messagearea_contacts','message/externallib.php','moodle','','moodle_mobile_app'),(121,'core_message_data_for_messagearea_messages','core_message_external','data_for_messagearea_messages','message/externallib.php','moodle','','moodle_mobile_app'),(122,'core_message_data_for_messagearea_get_most_recent_message','core_message_external','data_for_messagearea_get_most_recent_message','message/externallib.php','moodle','',NULL),(123,'core_message_data_for_messagearea_get_profile','core_message_external','data_for_messagearea_get_profile','message/externallib.php','moodle','',NULL),(124,'core_message_get_contacts','core_message_external','get_contacts','message/externallib.php','moodle','','moodle_mobile_app'),(125,'core_message_get_user_contacts','core_message_external','get_user_contacts','message/externallib.php','moodle','','moodle_mobile_app'),(126,'core_message_get_conversations','core_message_external','get_conversations','message/externallib.php','moodle','','moodle_mobile_app'),(127,'core_message_get_conversation','core_message_external','get_conversation','message/externallib.php','moodle','','moodle_mobile_app'),(128,'core_message_get_conversation_between_users','core_message_external','get_conversation_between_users','message/externallib.php','moodle','','moodle_mobile_app'),(129,'core_message_get_messages','core_message_external','get_messages','message/externallib.php','moodle','','moodle_mobile_app'),(130,'core_message_get_conversation_counts','core_message_external','get_conversation_counts','message/externallib.php','moodle','','moodle_mobile_app'),(131,'core_message_get_unread_conversation_counts','core_message_external','get_unread_conversation_counts','message/externallib.php','moodle','','moodle_mobile_app'),(132,'core_message_get_conversation_members','core_message_external','get_conversation_members','message/externallib.php','moodle','','moodle_mobile_app'),(133,'core_message_get_member_info','core_message_external','get_member_info','message/externallib.php','moodle','','moodle_mobile_app'),(134,'core_message_get_unread_conversations_count','core_message_external','get_unread_conversations_count','message/externallib.php','moodle','','moodle_mobile_app'),(135,'core_message_mark_all_notifications_as_read','core_message_external','mark_all_notifications_as_read','message/externallib.php','moodle','','moodle_mobile_app'),(136,'core_message_mark_all_messages_as_read','core_message_external','mark_all_messages_as_read','message/externallib.php','moodle','','moodle_mobile_app'),(137,'core_message_mark_all_conversation_messages_as_read','core_message_external','mark_all_conversation_messages_as_read','message/externallib.php','moodle','','moodle_mobile_app'),(138,'core_message_mark_message_read','core_message_external','mark_message_read','message/externallib.php','moodle','','moodle_mobile_app'),(139,'core_message_mark_notification_read','core_message_external','mark_notification_read','message/externallib.php','moodle','','moodle_mobile_app'),(140,'core_message_message_processor_config_form','core_message_external','message_processor_config_form','message/externallib.php','moodle','','moodle_mobile_app'),(141,'core_message_get_message_processor','core_message_external','get_message_processor','message/externallib.php','moodle','',NULL),(142,'core_message_search_contacts','core_message_external','search_contacts','message/externallib.php','moodle','','moodle_mobile_app'),(143,'core_message_send_instant_messages','core_message_external','send_instant_messages','message/externallib.php','moodle','moodle/site:sendmessage','moodle_mobile_app'),(144,'core_message_send_messages_to_conversation','core_message_external','send_messages_to_conversation','message/externallib.php','moodle','moodle/site:sendmessage','moodle_mobile_app'),(145,'core_message_get_conversation_messages','core_message_external','get_conversation_messages','message/externallib.php','moodle','','moodle_mobile_app'),(146,'core_message_unblock_user','core_message_external','unblock_user','message/externallib.php','moodle','','moodle_mobile_app'),(147,'core_message_unblock_contacts','core_message_external','unblock_contacts','message/externallib.php','moodle','','moodle_mobile_app'),(148,'core_message_get_user_notification_preferences','core_message_external','get_user_notification_preferences','message/externallib.php','moodle','moodle/user:editownmessageprofile','moodle_mobile_app'),(149,'core_message_get_user_message_preferences','core_message_external','get_user_message_preferences','message/externallib.php','moodle','moodle/user:editownmessageprofile','moodle_mobile_app'),(150,'core_message_set_favourite_conversations','core_message_external','set_favourite_conversations','message/externallib.php','moodle','','moodle_mobile_app'),(151,'core_message_unset_favourite_conversations','core_message_external','unset_favourite_conversations','message/externallib.php','moodle','','moodle_mobile_app'),(152,'core_notes_create_notes','core_notes_external','create_notes','notes/externallib.php','moodle','moodle/notes:manage','moodle_mobile_app'),(153,'core_notes_delete_notes','core_notes_external','delete_notes','notes/externallib.php','moodle','moodle/notes:manage','moodle_mobile_app'),(154,'core_notes_get_course_notes','core_notes_external','get_course_notes','notes/externallib.php','moodle','moodle/notes:view','moodle_mobile_app'),(155,'core_notes_get_notes','core_notes_external','get_notes','notes/externallib.php','moodle','moodle/notes:view',NULL),(156,'core_notes_update_notes','core_notes_external','update_notes','notes/externallib.php','moodle','moodle/notes:manage',NULL),(157,'core_notes_view_notes','core_notes_external','view_notes','notes/externallib.php','moodle','moodle/notes:view','moodle_mobile_app'),(158,'core_output_load_template','core\\output\\external','load_template',NULL,'moodle','',NULL),(159,'core_output_load_fontawesome_icon_map','core\\output\\external','load_fontawesome_icon_map',NULL,'moodle','',NULL),(160,'core_question_update_flag','core_question_external','update_flag',NULL,'moodle','moodle/question:flag','moodle_mobile_app'),(161,'core_question_submit_tags_form','core_question_external','submit_tags_form',NULL,'moodle','',NULL),(162,'core_question_get_random_question_summaries','core_question_external','get_random_question_summaries',NULL,'moodle','',NULL),(163,'core_rating_get_item_ratings','core_rating_external','get_item_ratings',NULL,'moodle','moodle/rating:view','moodle_mobile_app'),(164,'core_rating_add_rating','core_rating_external','add_rating',NULL,'moodle','moodle/rating:rate','moodle_mobile_app'),(165,'core_role_assign_roles','core_role_external','assign_roles','enrol/externallib.php','moodle','moodle/role:assign',NULL),(166,'core_role_unassign_roles','core_role_external','unassign_roles','enrol/externallib.php','moodle','moodle/role:assign',NULL),(167,'core_search_get_relevant_users','\\core_search\\external','get_relevant_users',NULL,'moodle','',NULL),(168,'core_tag_get_tagindex','core_tag_external','get_tagindex',NULL,'moodle','',NULL),(169,'core_tag_get_tags','core_tag_external','get_tags',NULL,'moodle','',NULL),(170,'core_tag_update_tags','core_tag_external','update_tags',NULL,'moodle','',NULL),(171,'core_update_inplace_editable','core_external','update_inplace_editable','lib/external/externallib.php','moodle','',NULL),(172,'core_user_add_user_device','core_user_external','add_user_device','user/externallib.php','moodle','','moodle_mobile_app'),(173,'core_user_add_user_private_files','core_user_external','add_user_private_files','user/externallib.php','moodle','moodle/user:manageownfiles','moodle_mobile_app'),(174,'core_user_create_users','core_user_external','create_users','user/externallib.php','moodle','moodle/user:create',NULL),(175,'core_user_delete_users','core_user_external','delete_users','user/externallib.php','moodle','moodle/user:delete',NULL),(176,'core_user_get_course_user_profiles','core_user_external','get_course_user_profiles','user/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups','moodle_mobile_app'),(177,'core_user_get_users','core_user_external','get_users','user/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update',NULL),(178,'core_user_get_users_by_field','core_user_external','get_users_by_field','user/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update','moodle_mobile_app'),(179,'core_user_remove_user_device','core_user_external','remove_user_device','user/externallib.php','moodle','','moodle_mobile_app'),(180,'core_user_update_users','core_user_external','update_users','user/externallib.php','moodle','moodle/user:update',NULL),(181,'core_user_update_user_preferences','core_user_external','update_user_preferences','user/externallib.php','moodle','moodle/user:editownmessageprofile, moodle/user:editmessageprofile','moodle_mobile_app'),(182,'core_user_view_user_list','core_user_external','view_user_list','user/externallib.php','moodle','moodle/course:viewparticipants','moodle_mobile_app'),(183,'core_user_view_user_profile','core_user_external','view_user_profile','user/externallib.php','moodle','moodle/user:viewdetails','moodle_mobile_app'),(184,'core_user_get_user_preferences','core_user_external','get_user_preferences','user/externallib.php','moodle','','moodle_mobile_app'),(185,'core_user_update_picture','core_user_external','update_picture','user/externallib.php','moodle','moodle/user:editownprofile, moodle/user:editprofile','moodle_mobile_app'),(186,'core_user_set_user_preferences','core_user_external','set_user_preferences','user/externallib.php','moodle','moodle/site:config','moodle_mobile_app'),(187,'core_user_agree_site_policy','core_user_external','agree_site_policy','user/externallib.php','moodle','','moodle_mobile_app'),(188,'core_user_get_private_files_info','core_user_external','get_private_files_info','user/externallib.php','moodle','moodle/user:manageownfiles','moodle_mobile_app'),(189,'core_competency_create_competency_framework','core_competency\\external','create_competency_framework',NULL,'moodle','moodle/competency:competencymanage',NULL),(190,'core_competency_read_competency_framework','core_competency\\external','read_competency_framework',NULL,'moodle','moodle/competency:competencyview',NULL),(191,'core_competency_duplicate_competency_framework','core_competency\\external','duplicate_competency_framework',NULL,'moodle','moodle/competency:competencymanage',NULL),(192,'core_competency_delete_competency_framework','core_competency\\external','delete_competency_framework',NULL,'moodle','moodle/competency:competencymanage',NULL),(193,'core_competency_update_competency_framework','core_competency\\external','update_competency_framework',NULL,'moodle','moodle/competency:competencymanage',NULL),(194,'core_competency_list_competency_frameworks','core_competency\\external','list_competency_frameworks',NULL,'moodle','moodle/competency:competencyview',NULL),(195,'core_competency_count_competency_frameworks','core_competency\\external','count_competency_frameworks',NULL,'moodle','moodle/competency:competencyview',NULL),(196,'core_competency_competency_framework_viewed','core_competency\\external','competency_framework_viewed',NULL,'moodle','moodle/competency:competencyview',NULL),(197,'core_competency_create_competency','core_competency\\external','create_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(198,'core_competency_read_competency','core_competency\\external','read_competency',NULL,'moodle','moodle/competency:competencyview',NULL),(199,'core_competency_competency_viewed','core_competency\\external','competency_viewed',NULL,'moodle','moodle/competency:competencyview','moodle_mobile_app'),(200,'core_competency_delete_competency','core_competency\\external','delete_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(201,'core_competency_update_competency','core_competency\\external','update_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(202,'core_competency_list_competencies','core_competency\\external','list_competencies',NULL,'moodle','moodle/competency:competencyview',NULL),(203,'core_competency_list_competencies_in_template','core_competency\\external','list_competencies_in_template',NULL,'moodle','moodle/competency:competencyview',NULL),(204,'core_competency_count_competencies','core_competency\\external','count_competencies',NULL,'moodle','moodle/competency:competencyview',NULL),(205,'core_competency_count_competencies_in_template','core_competency\\external','count_competencies_in_template',NULL,'moodle','moodle/competency:competencyview',NULL),(206,'core_competency_search_competencies','core_competency\\external','search_competencies',NULL,'moodle','moodle/competency:competencyview',NULL),(207,'core_competency_set_parent_competency','core_competency\\external','set_parent_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(208,'core_competency_move_up_competency','core_competency\\external','move_up_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(209,'core_competency_move_down_competency','core_competency\\external','move_down_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(210,'core_competency_list_course_competencies','core_competency\\external','list_course_competencies',NULL,'moodle','moodle/competency:coursecompetencyview','moodle_mobile_app'),(211,'core_competency_count_competencies_in_course','core_competency\\external','count_competencies_in_course',NULL,'moodle','moodle/competency:coursecompetencyview',NULL),(212,'core_competency_count_courses_using_competency','core_competency\\external','count_courses_using_competency',NULL,'moodle','moodle/competency:coursecompetencyview',NULL),(213,'core_competency_add_competency_to_course','core_competency\\external','add_competency_to_course',NULL,'moodle','moodle/competency:coursecompetencymanage',NULL),(214,'core_competency_add_competency_to_template','core_competency\\external','add_competency_to_template',NULL,'moodle','moodle/competency:templatemanage',NULL),(215,'core_competency_remove_competency_from_course','core_competency\\external','remove_competency_from_course',NULL,'moodle','moodle/competency:coursecompetencymanage',NULL),(216,'core_competency_set_course_competency_ruleoutcome','core_competency\\external','set_course_competency_ruleoutcome',NULL,'moodle','moodle/competency:coursecompetencymanage',NULL),(217,'core_competency_remove_competency_from_template','core_competency\\external','remove_competency_from_template',NULL,'moodle','moodle/competency:templatemanage',NULL),(218,'core_competency_reorder_course_competency','core_competency\\external','reorder_course_competency',NULL,'moodle','moodle/competency:coursecompetencymanage',NULL),(219,'core_competency_reorder_template_competency','core_competency\\external','reorder_template_competency',NULL,'moodle','moodle/competency:templatemanage',NULL),(220,'core_competency_create_template','core_competency\\external','create_template',NULL,'moodle','moodle/competency:templatemanage',NULL),(221,'core_competency_duplicate_template','core_competency\\external','duplicate_template',NULL,'moodle','moodle/competency:templatemanage',NULL),(222,'core_competency_read_template','core_competency\\external','read_template',NULL,'moodle','moodle/competency:templateview',NULL),(223,'core_competency_delete_template','core_competency\\external','delete_template',NULL,'moodle','moodle/competency:templatemanage',NULL),(224,'core_competency_update_template','core_competency\\external','update_template',NULL,'moodle','moodle/competency:templatemanage',NULL),(225,'core_competency_list_templates','core_competency\\external','list_templates',NULL,'moodle','moodle/competency:templateview',NULL),(226,'core_competency_list_templates_using_competency','core_competency\\external','list_templates_using_competency',NULL,'moodle','moodle/competency:templateview',NULL),(227,'core_competency_count_templates','core_competency\\external','count_templates',NULL,'moodle','moodle/competency:templateview',NULL),(228,'core_competency_count_templates_using_competency','core_competency\\external','count_templates_using_competency',NULL,'moodle','moodle/competency:templateview',NULL),(229,'core_competency_create_plan','core_competency\\external','create_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(230,'core_competency_update_plan','core_competency\\external','update_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(231,'core_competency_complete_plan','core_competency\\external','complete_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(232,'core_competency_reopen_plan','core_competency\\external','reopen_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(233,'core_competency_read_plan','core_competency\\external','read_plan',NULL,'moodle','moodle/competency:planviewown',NULL),(234,'core_competency_delete_plan','core_competency\\external','delete_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(235,'core_competency_list_user_plans','core_competency\\external','list_user_plans',NULL,'moodle','moodle/competency:planviewown',NULL),(236,'core_competency_list_plan_competencies','core_competency\\external','list_plan_competencies',NULL,'moodle','moodle/competency:planviewown',NULL),(237,'core_competency_add_competency_to_plan','core_competency\\external','add_competency_to_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(238,'core_competency_remove_competency_from_plan','core_competency\\external','remove_competency_from_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(239,'core_competency_reorder_plan_competency','core_competency\\external','reorder_plan_competency',NULL,'moodle','moodle/competency:planmanage',NULL),(240,'core_competency_plan_request_review','core_competency\\external','plan_request_review',NULL,'moodle','moodle/competency:planmanagedraft',NULL),(241,'core_competency_plan_start_review','core_competency\\external','plan_start_review',NULL,'moodle','moodle/competency:planmanage',NULL),(242,'core_competency_plan_stop_review','core_competency\\external','plan_stop_review',NULL,'moodle','moodle/competency:planmanage',NULL),(243,'core_competency_plan_cancel_review_request','core_competency\\external','plan_cancel_review_request',NULL,'moodle','moodle/competency:planmanagedraft',NULL),(244,'core_competency_approve_plan','core_competency\\external','approve_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(245,'core_competency_unapprove_plan','core_competency\\external','unapprove_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(246,'core_competency_template_has_related_data','core_competency\\external','template_has_related_data',NULL,'moodle','moodle/competency:templateview',NULL),(247,'core_competency_get_scale_values','core_competency\\external','get_scale_values',NULL,'moodle','moodle/competency:competencymanage','moodle_mobile_app'),(248,'core_competency_add_related_competency','core_competency\\external','add_related_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(249,'core_competency_remove_related_competency','core_competency\\external','remove_related_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(250,'core_competency_read_user_evidence','core_competency\\external','read_user_evidence',NULL,'moodle','moodle/competency:userevidenceview',NULL),(251,'core_competency_delete_user_evidence','core_competency\\external','delete_user_evidence',NULL,'moodle','moodle/competency:userevidencemanageown',NULL),(252,'core_competency_create_user_evidence_competency','core_competency\\external','create_user_evidence_competency',NULL,'moodle','moodle/competency:userevidencemanageown, moodle/competency:competencyview',NULL),(253,'core_competency_delete_user_evidence_competency','core_competency\\external','delete_user_evidence_competency',NULL,'moodle','moodle/competency:userevidencemanageown',NULL),(254,'core_competency_user_competency_cancel_review_request','core_competency\\external','user_competency_cancel_review_request',NULL,'moodle','moodle/competency:userevidencemanageown',NULL),(255,'core_competency_user_competency_request_review','core_competency\\external','user_competency_request_review',NULL,'moodle','moodle/competency:userevidencemanageown',NULL),(256,'core_competency_user_competency_start_review','core_competency\\external','user_competency_start_review',NULL,'moodle','moodle/competency:competencygrade',NULL),(257,'core_competency_user_competency_stop_review','core_competency\\external','user_competency_stop_review',NULL,'moodle','moodle/competency:competencygrade',NULL),(258,'core_competency_user_competency_viewed','core_competency\\external','user_competency_viewed',NULL,'moodle','moodle/competency:usercompetencyview','moodle_mobile_app'),(259,'core_competency_user_competency_viewed_in_plan','core_competency\\external','user_competency_viewed_in_plan',NULL,'moodle','moodle/competency:usercompetencyview','moodle_mobile_app'),(260,'core_competency_user_competency_viewed_in_course','core_competency\\external','user_competency_viewed_in_course',NULL,'moodle','moodle/competency:usercompetencyview','moodle_mobile_app'),(261,'core_competency_user_competency_plan_viewed','core_competency\\external','user_competency_plan_viewed',NULL,'moodle','moodle/competency:usercompetencyview','moodle_mobile_app'),(262,'core_competency_grade_competency','core_competency\\external','grade_competency',NULL,'moodle','moodle/competency:competencygrade',NULL),(263,'core_competency_grade_competency_in_plan','core_competency\\external','grade_competency_in_plan',NULL,'moodle','moodle/competency:competencygrade',NULL),(264,'core_competency_grade_competency_in_course','core_competency\\external','grade_competency_in_course',NULL,'moodle','moodle/competency:competencygrade','moodle_mobile_app'),(265,'core_competency_unlink_plan_from_template','core_competency\\external','unlink_plan_from_template',NULL,'moodle','moodle/competency:planmanage',NULL),(266,'core_competency_template_viewed','core_competency\\external','template_viewed',NULL,'moodle','moodle/competency:templateview',NULL),(267,'core_competency_request_review_of_user_evidence_linked_competencies','core_competency\\external','request_review_of_user_evidence_linked_competencies',NULL,'moodle','moodle/competency:userevidencemanageown',NULL),(268,'core_competency_update_course_competency_settings','core_competency\\external','update_course_competency_settings',NULL,'moodle','moodle/competency:coursecompetencyconfigure',NULL),(269,'core_competency_delete_evidence','core_competency\\external','delete_evidence',NULL,'moodle','moodle/competency:evidencedelete','moodle_mobile_app'),(270,'core_webservice_get_site_info','core_webservice_external','get_site_info','webservice/externallib.php','moodle','','moodle_mobile_app'),(271,'core_block_get_course_blocks','core_block_external','get_course_blocks',NULL,'moodle','','moodle_mobile_app'),(272,'core_block_get_dashboard_blocks','core_block_external','get_dashboard_blocks',NULL,'moodle','','moodle_mobile_app'),(273,'core_filters_get_available_in_context','core_filters\\external','get_available_in_context',NULL,'moodle','','moodle_mobile_app'),(274,'mod_assign_copy_previous_attempt','mod_assign_external','copy_previous_attempt','mod/assign/externallib.php','mod_assign','mod/assign:view, mod/assign:submit',NULL),(275,'mod_assign_get_grades','mod_assign_external','get_grades','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(276,'mod_assign_get_assignments','mod_assign_external','get_assignments','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(277,'mod_assign_get_submissions','mod_assign_external','get_submissions','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(278,'mod_assign_get_user_flags','mod_assign_external','get_user_flags','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(279,'mod_assign_set_user_flags','mod_assign_external','set_user_flags','mod/assign/externallib.php','mod_assign','mod/assign:grade','moodle_mobile_app'),(280,'mod_assign_get_user_mappings','mod_assign_external','get_user_mappings','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(281,'mod_assign_revert_submissions_to_draft','mod_assign_external','revert_submissions_to_draft','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(282,'mod_assign_lock_submissions','mod_assign_external','lock_submissions','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(283,'mod_assign_unlock_submissions','mod_assign_external','unlock_submissions','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(284,'mod_assign_save_submission','mod_assign_external','save_submission','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(285,'mod_assign_submit_for_grading','mod_assign_external','submit_for_grading','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(286,'mod_assign_save_grade','mod_assign_external','save_grade','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(287,'mod_assign_save_grades','mod_assign_external','save_grades','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(288,'mod_assign_save_user_extensions','mod_assign_external','save_user_extensions','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(289,'mod_assign_reveal_identities','mod_assign_external','reveal_identities','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(290,'mod_assign_view_grading_table','mod_assign_external','view_grading_table','mod/assign/externallib.php','mod_assign','mod/assign:view, mod/assign:viewgrades','moodle_mobile_app'),(291,'mod_assign_view_submission_status','mod_assign_external','view_submission_status','mod/assign/externallib.php','mod_assign','mod/assign:view','moodle_mobile_app'),(292,'mod_assign_get_submission_status','mod_assign_external','get_submission_status','mod/assign/externallib.php','mod_assign','mod/assign:view','moodle_mobile_app'),(293,'mod_assign_list_participants','mod_assign_external','list_participants','mod/assign/externallib.php','mod_assign','mod/assign:view, mod/assign:viewgrades','moodle_mobile_app'),(294,'mod_assign_submit_grading_form','mod_assign_external','submit_grading_form','mod/assign/externallib.php','mod_assign','mod/assign:grade','moodle_mobile_app'),(295,'mod_assign_get_participant','mod_assign_external','get_participant','mod/assign/externallib.php','mod_assign','mod/assign:view, mod/assign:viewgrades','moodle_mobile_app'),(296,'mod_assign_view_assign','mod_assign_external','view_assign','mod/assign/externallib.php','mod_assign','mod/assign:view','moodle_mobile_app'),(297,'mod_book_view_book','mod_book_external','view_book',NULL,'mod_book','mod/book:read','moodle_mobile_app'),(298,'mod_book_get_books_by_courses','mod_book_external','get_books_by_courses',NULL,'mod_book','','moodle_mobile_app'),(299,'mod_chat_login_user','mod_chat_external','login_user',NULL,'mod_chat','mod/chat:chat','moodle_mobile_app'),(300,'mod_chat_get_chat_users','mod_chat_external','get_chat_users',NULL,'mod_chat','mod/chat:chat','moodle_mobile_app'),(301,'mod_chat_send_chat_message','mod_chat_external','send_chat_message',NULL,'mod_chat','mod/chat:chat','moodle_mobile_app'),(302,'mod_chat_get_chat_latest_messages','mod_chat_external','get_chat_latest_messages',NULL,'mod_chat','mod/chat:chat','moodle_mobile_app'),(303,'mod_chat_view_chat','mod_chat_external','view_chat',NULL,'mod_chat','mod/chat:chat','moodle_mobile_app'),(304,'mod_chat_get_chats_by_courses','mod_chat_external','get_chats_by_courses',NULL,'mod_chat','','moodle_mobile_app'),(305,'mod_chat_get_sessions','mod_chat_external','get_sessions',NULL,'mod_chat','','moodle_mobile_app'),(306,'mod_chat_get_session_messages','mod_chat_external','get_session_messages',NULL,'mod_chat','','moodle_mobile_app'),(307,'mod_choice_get_choice_results','mod_choice_external','get_choice_results',NULL,'mod_choice','','moodle_mobile_app'),(308,'mod_choice_get_choice_options','mod_choice_external','get_choice_options',NULL,'mod_choice','mod/choice:choose','moodle_mobile_app'),(309,'mod_choice_submit_choice_response','mod_choice_external','submit_choice_response',NULL,'mod_choice','mod/choice:choose','moodle_mobile_app'),(310,'mod_choice_view_choice','mod_choice_external','view_choice',NULL,'mod_choice','','moodle_mobile_app'),(311,'mod_choice_get_choices_by_courses','mod_choice_external','get_choices_by_courses',NULL,'mod_choice','','moodle_mobile_app'),(312,'mod_choice_delete_choice_responses','mod_choice_external','delete_choice_responses',NULL,'mod_choice','mod/choice:choose','moodle_mobile_app'),(313,'mod_data_get_databases_by_courses','mod_data_external','get_databases_by_courses',NULL,'mod_data','mod/data:viewentry','moodle_mobile_app'),(314,'mod_data_view_database','mod_data_external','view_database',NULL,'mod_data','mod/data:viewentry','moodle_mobile_app'),(315,'mod_data_get_data_access_information','mod_data_external','get_data_access_information',NULL,'mod_data','mod/data:viewentry','moodle_mobile_app'),(316,'mod_data_get_entries','mod_data_external','get_entries',NULL,'mod_data','mod/data:viewentry','moodle_mobile_app'),(317,'mod_data_get_entry','mod_data_external','get_entry',NULL,'mod_data','mod/data:viewentry','moodle_mobile_app'),(318,'mod_data_get_fields','mod_data_external','get_fields',NULL,'mod_data','mod/data:viewentry','moodle_mobile_app'),(319,'mod_data_search_entries','mod_data_external','search_entries',NULL,'mod_data','mod/data:viewentry','moodle_mobile_app'),(320,'mod_data_approve_entry','mod_data_external','approve_entry',NULL,'mod_data','mod/data:approve','moodle_mobile_app'),(321,'mod_data_delete_entry','mod_data_external','delete_entry',NULL,'mod_data','mod/data:manageentries','moodle_mobile_app'),(322,'mod_data_add_entry','mod_data_external','add_entry',NULL,'mod_data','mod/data:writeentry','moodle_mobile_app'),(323,'mod_data_update_entry','mod_data_external','update_entry',NULL,'mod_data','mod/data:writeentry','moodle_mobile_app'),(324,'mod_feedback_get_feedbacks_by_courses','mod_feedback_external','get_feedbacks_by_courses',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(325,'mod_feedback_get_feedback_access_information','mod_feedback_external','get_feedback_access_information',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(326,'mod_feedback_view_feedback','mod_feedback_external','view_feedback',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(327,'mod_feedback_get_current_completed_tmp','mod_feedback_external','get_current_completed_tmp',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(328,'mod_feedback_get_items','mod_feedback_external','get_items',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(329,'mod_feedback_launch_feedback','mod_feedback_external','launch_feedback',NULL,'mod_feedback','mod/feedback:complete','moodle_mobile_app'),(330,'mod_feedback_get_page_items','mod_feedback_external','get_page_items',NULL,'mod_feedback','mod/feedback:complete','moodle_mobile_app'),(331,'mod_feedback_process_page','mod_feedback_external','process_page',NULL,'mod_feedback','mod/feedback:complete','moodle_mobile_app'),(332,'mod_feedback_get_analysis','mod_feedback_external','get_analysis',NULL,'mod_feedback','mod/feedback:viewanalysepage','moodle_mobile_app'),(333,'mod_feedback_get_unfinished_responses','mod_feedback_external','get_unfinished_responses',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(334,'mod_feedback_get_finished_responses','mod_feedback_external','get_finished_responses',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(335,'mod_feedback_get_non_respondents','mod_feedback_external','get_non_respondents',NULL,'mod_feedback','mod/feedback:viewreports','moodle_mobile_app'),(336,'mod_feedback_get_responses_analysis','mod_feedback_external','get_responses_analysis',NULL,'mod_feedback','mod/feedback:viewreports','moodle_mobile_app'),(337,'mod_feedback_get_last_completed','mod_feedback_external','get_last_completed',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(338,'mod_folder_view_folder','mod_folder_external','view_folder',NULL,'mod_folder','mod/folder:view','moodle_mobile_app'),(339,'mod_folder_get_folders_by_courses','mod_folder_external','get_folders_by_courses',NULL,'mod_folder','mod/folder:view','moodle_mobile_app'),(340,'mod_forum_get_forums_by_courses','mod_forum_external','get_forums_by_courses','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion','moodle_mobile_app'),(341,'mod_forum_get_forum_discussion_posts','mod_forum_external','get_forum_discussion_posts','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting','moodle_mobile_app'),(342,'mod_forum_get_forum_discussions_paginated','mod_forum_external','get_forum_discussions_paginated','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting','moodle_mobile_app'),(343,'mod_forum_view_forum','mod_forum_external','view_forum','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion','moodle_mobile_app'),(344,'mod_forum_view_forum_discussion','mod_forum_external','view_forum_discussion','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion','moodle_mobile_app'),(345,'mod_forum_add_discussion_post','mod_forum_external','add_discussion_post','mod/forum/externallib.php','mod_forum','mod/forum:replypost','moodle_mobile_app'),(346,'mod_forum_add_discussion','mod_forum_external','add_discussion','mod/forum/externallib.php','mod_forum','mod/forum:startdiscussion','moodle_mobile_app'),(347,'mod_forum_can_add_discussion','mod_forum_external','can_add_discussion','mod/forum/externallib.php','mod_forum','','moodle_mobile_app'),(348,'mod_glossary_get_glossaries_by_courses','mod_glossary_external','get_glossaries_by_courses',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(349,'mod_glossary_view_glossary','mod_glossary_external','view_glossary',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(350,'mod_glossary_view_entry','mod_glossary_external','view_entry',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(351,'mod_glossary_get_entries_by_letter','mod_glossary_external','get_entries_by_letter',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(352,'mod_glossary_get_entries_by_date','mod_glossary_external','get_entries_by_date',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(353,'mod_glossary_get_categories','mod_glossary_external','get_categories',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(354,'mod_glossary_get_entries_by_category','mod_glossary_external','get_entries_by_category',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(355,'mod_glossary_get_authors','mod_glossary_external','get_authors',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(356,'mod_glossary_get_entries_by_author','mod_glossary_external','get_entries_by_author',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(357,'mod_glossary_get_entries_by_author_id','mod_glossary_external','get_entries_by_author_id',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(358,'mod_glossary_get_entries_by_search','mod_glossary_external','get_entries_by_search',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(359,'mod_glossary_get_entries_by_term','mod_glossary_external','get_entries_by_term',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(360,'mod_glossary_get_entries_to_approve','mod_glossary_external','get_entries_to_approve',NULL,'mod_glossary','mod/glossary:approve','moodle_mobile_app'),(361,'mod_glossary_get_entry_by_id','mod_glossary_external','get_entry_by_id',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(362,'mod_glossary_add_entry','mod_glossary_external','add_entry',NULL,'mod_glossary','mod/glossary:write','moodle_mobile_app'),(363,'mod_imscp_view_imscp','mod_imscp_external','view_imscp',NULL,'mod_imscp','mod/imscp:view','moodle_mobile_app'),(364,'mod_imscp_get_imscps_by_courses','mod_imscp_external','get_imscps_by_courses',NULL,'mod_imscp','mod/imscp:view','moodle_mobile_app'),(365,'mod_label_get_labels_by_courses','mod_label_external','get_labels_by_courses',NULL,'mod_label','mod/label:view','moodle_mobile_app'),(366,'mod_lesson_get_lessons_by_courses','mod_lesson_external','get_lessons_by_courses',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(367,'mod_lesson_get_lesson_access_information','mod_lesson_external','get_lesson_access_information',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(368,'mod_lesson_view_lesson','mod_lesson_external','view_lesson',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(369,'mod_lesson_get_questions_attempts','mod_lesson_external','get_questions_attempts',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(370,'mod_lesson_get_user_grade','mod_lesson_external','get_user_grade',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(371,'mod_lesson_get_user_attempt_grade','mod_lesson_external','get_user_attempt_grade',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(372,'mod_lesson_get_content_pages_viewed','mod_lesson_external','get_content_pages_viewed',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(373,'mod_lesson_get_user_timers','mod_lesson_external','get_user_timers',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(374,'mod_lesson_get_pages','mod_lesson_external','get_pages',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(375,'mod_lesson_launch_attempt','mod_lesson_external','launch_attempt',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(376,'mod_lesson_get_page_data','mod_lesson_external','get_page_data',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(377,'mod_lesson_process_page','mod_lesson_external','process_page',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(378,'mod_lesson_finish_attempt','mod_lesson_external','finish_attempt',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(379,'mod_lesson_get_attempts_overview','mod_lesson_external','get_attempts_overview',NULL,'mod_lesson','mod/lesson:viewreports','moodle_mobile_app'),(380,'mod_lesson_get_user_attempt','mod_lesson_external','get_user_attempt',NULL,'mod_lesson','mod/lesson:viewreports','moodle_mobile_app'),(381,'mod_lesson_get_pages_possible_jumps','mod_lesson_external','get_pages_possible_jumps',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(382,'mod_lesson_get_lesson','mod_lesson_external','get_lesson',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(383,'mod_lti_get_tool_launch_data','mod_lti_external','get_tool_launch_data',NULL,'mod_lti','mod/lti:view','moodle_mobile_app'),(384,'mod_lti_get_ltis_by_courses','mod_lti_external','get_ltis_by_courses',NULL,'mod_lti','mod/lti:view','moodle_mobile_app'),(385,'mod_lti_view_lti','mod_lti_external','view_lti',NULL,'mod_lti','mod/lti:view','moodle_mobile_app'),(386,'mod_lti_get_tool_proxies','mod_lti_external','get_tool_proxies',NULL,'mod_lti','moodle/site:config',NULL),(387,'mod_lti_create_tool_proxy','mod_lti_external','create_tool_proxy',NULL,'mod_lti','moodle/site:config',NULL),(388,'mod_lti_delete_tool_proxy','mod_lti_external','delete_tool_proxy',NULL,'mod_lti','moodle/site:config',NULL),(389,'mod_lti_get_tool_proxy_registration_request','mod_lti_external','get_tool_proxy_registration_request',NULL,'mod_lti','moodle/site:config',NULL),(390,'mod_lti_get_tool_types','mod_lti_external','get_tool_types',NULL,'mod_lti','moodle/site:config',NULL),(391,'mod_lti_create_tool_type','mod_lti_external','create_tool_type',NULL,'mod_lti','moodle/site:config',NULL),(392,'mod_lti_update_tool_type','mod_lti_external','update_tool_type',NULL,'mod_lti','moodle/site:config',NULL),(393,'mod_lti_delete_tool_type','mod_lti_external','delete_tool_type',NULL,'mod_lti','moodle/site:config',NULL),(394,'mod_lti_is_cartridge','mod_lti_external','is_cartridge',NULL,'mod_lti','moodle/site:config',NULL),(395,'mod_page_view_page','mod_page_external','view_page',NULL,'mod_page','mod/page:view','moodle_mobile_app'),(396,'mod_page_get_pages_by_courses','mod_page_external','get_pages_by_courses',NULL,'mod_page','mod/page:view','moodle_mobile_app'),(397,'mod_quiz_get_quizzes_by_courses','mod_quiz_external','get_quizzes_by_courses',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(398,'mod_quiz_view_quiz','mod_quiz_external','view_quiz',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(399,'mod_quiz_get_user_attempts','mod_quiz_external','get_user_attempts',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(400,'mod_quiz_get_user_best_grade','mod_quiz_external','get_user_best_grade',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(401,'mod_quiz_get_combined_review_options','mod_quiz_external','get_combined_review_options',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(402,'mod_quiz_start_attempt','mod_quiz_external','start_attempt',NULL,'mod_quiz','mod/quiz:attempt','moodle_mobile_app'),(403,'mod_quiz_get_attempt_data','mod_quiz_external','get_attempt_data',NULL,'mod_quiz','mod/quiz:attempt','moodle_mobile_app'),(404,'mod_quiz_get_attempt_summary','mod_quiz_external','get_attempt_summary',NULL,'mod_quiz','mod/quiz:attempt','moodle_mobile_app'),(405,'mod_quiz_save_attempt','mod_quiz_external','save_attempt',NULL,'mod_quiz','mod/quiz:attempt','moodle_mobile_app'),(406,'mod_quiz_process_attempt','mod_quiz_external','process_attempt',NULL,'mod_quiz','mod/quiz:attempt','moodle_mobile_app'),(407,'mod_quiz_get_attempt_review','mod_quiz_external','get_attempt_review',NULL,'mod_quiz','mod/quiz:reviewmyattempts','moodle_mobile_app'),(408,'mod_quiz_view_attempt','mod_quiz_external','view_attempt',NULL,'mod_quiz','mod/quiz:attempt','moodle_mobile_app'),(409,'mod_quiz_view_attempt_summary','mod_quiz_external','view_attempt_summary',NULL,'mod_quiz','mod/quiz:attempt','moodle_mobile_app'),(410,'mod_quiz_view_attempt_review','mod_quiz_external','view_attempt_review',NULL,'mod_quiz','mod/quiz:reviewmyattempts','moodle_mobile_app'),(411,'mod_quiz_get_quiz_feedback_for_grade','mod_quiz_external','get_quiz_feedback_for_grade',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(412,'mod_quiz_get_quiz_access_information','mod_quiz_external','get_quiz_access_information',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(413,'mod_quiz_get_attempt_access_information','mod_quiz_external','get_attempt_access_information',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(414,'mod_quiz_get_quiz_required_qtypes','mod_quiz_external','get_quiz_required_qtypes',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(415,'mod_resource_view_resource','mod_resource_external','view_resource',NULL,'mod_resource','mod/resource:view','moodle_mobile_app'),(416,'mod_resource_get_resources_by_courses','mod_resource_external','get_resources_by_courses',NULL,'mod_resource','mod/resource:view','moodle_mobile_app'),(417,'mod_scorm_view_scorm','mod_scorm_external','view_scorm',NULL,'mod_scorm','','moodle_mobile_app'),(418,'mod_scorm_get_scorm_attempt_count','mod_scorm_external','get_scorm_attempt_count',NULL,'mod_scorm','','moodle_mobile_app'),(419,'mod_scorm_get_scorm_scoes','mod_scorm_external','get_scorm_scoes',NULL,'mod_scorm','','moodle_mobile_app'),(420,'mod_scorm_get_scorm_user_data','mod_scorm_external','get_scorm_user_data',NULL,'mod_scorm','','moodle_mobile_app'),(421,'mod_scorm_insert_scorm_tracks','mod_scorm_external','insert_scorm_tracks',NULL,'mod_scorm','mod/scorm:savetrack','moodle_mobile_app'),(422,'mod_scorm_get_scorm_sco_tracks','mod_scorm_external','get_scorm_sco_tracks',NULL,'mod_scorm','','moodle_mobile_app'),(423,'mod_scorm_get_scorms_by_courses','mod_scorm_external','get_scorms_by_courses',NULL,'mod_scorm','','moodle_mobile_app'),(424,'mod_scorm_launch_sco','mod_scorm_external','launch_sco',NULL,'mod_scorm','','moodle_mobile_app'),(425,'mod_survey_get_surveys_by_courses','mod_survey_external','get_surveys_by_courses',NULL,'mod_survey','','moodle_mobile_app'),(426,'mod_survey_view_survey','mod_survey_external','view_survey',NULL,'mod_survey','mod/survey:participate','moodle_mobile_app'),(427,'mod_survey_get_questions','mod_survey_external','get_questions',NULL,'mod_survey','mod/survey:participate','moodle_mobile_app'),(428,'mod_survey_submit_answers','mod_survey_external','submit_answers',NULL,'mod_survey','mod/survey:participate','moodle_mobile_app'),(429,'mod_url_view_url','mod_url_external','view_url',NULL,'mod_url','mod/url:view','moodle_mobile_app'),(430,'mod_url_get_urls_by_courses','mod_url_external','get_urls_by_courses',NULL,'mod_url','mod/url:view','moodle_mobile_app'),(431,'mod_wiki_get_wikis_by_courses','mod_wiki_external','get_wikis_by_courses',NULL,'mod_wiki','mod/wiki:viewpage','moodle_mobile_app'),(432,'mod_wiki_view_wiki','mod_wiki_external','view_wiki',NULL,'mod_wiki','mod/wiki:viewpage','moodle_mobile_app'),(433,'mod_wiki_view_page','mod_wiki_external','view_page',NULL,'mod_wiki','mod/wiki:viewpage','moodle_mobile_app'),(434,'mod_wiki_get_subwikis','mod_wiki_external','get_subwikis',NULL,'mod_wiki','mod/wiki:viewpage','moodle_mobile_app'),(435,'mod_wiki_get_subwiki_pages','mod_wiki_external','get_subwiki_pages',NULL,'mod_wiki','mod/wiki:viewpage','moodle_mobile_app'),(436,'mod_wiki_get_subwiki_files','mod_wiki_external','get_subwiki_files',NULL,'mod_wiki','mod/wiki:viewpage','moodle_mobile_app'),(437,'mod_wiki_get_page_contents','mod_wiki_external','get_page_contents',NULL,'mod_wiki','mod/wiki:viewpage','moodle_mobile_app'),(438,'mod_wiki_get_page_for_editing','mod_wiki_external','get_page_for_editing',NULL,'mod_wiki','mod/wiki:editpage','moodle_mobile_app'),(439,'mod_wiki_new_page','mod_wiki_external','new_page',NULL,'mod_wiki','mod/wiki:editpage','moodle_mobile_app'),(440,'mod_wiki_edit_page','mod_wiki_external','edit_page',NULL,'mod_wiki','mod/wiki:editpage','moodle_mobile_app'),(441,'mod_workshop_get_workshops_by_courses','mod_workshop_external','get_workshops_by_courses',NULL,'mod_workshop','mod/workshop:view','moodle_mobile_app'),(442,'mod_workshop_get_workshop_access_information','mod_workshop_external','get_workshop_access_information',NULL,'mod_workshop','mod/workshop:view','moodle_mobile_app'),(443,'mod_workshop_get_user_plan','mod_workshop_external','get_user_plan',NULL,'mod_workshop','mod/workshop:view','moodle_mobile_app'),(444,'mod_workshop_view_workshop','mod_workshop_external','view_workshop',NULL,'mod_workshop','mod/workshop:view','moodle_mobile_app'),(445,'mod_workshop_add_submission','mod_workshop_external','add_submission',NULL,'mod_workshop','mod/workshop:submit','moodle_mobile_app'),(446,'mod_workshop_update_submission','mod_workshop_external','update_submission',NULL,'mod_workshop','mod/workshop:submit','moodle_mobile_app'),(447,'mod_workshop_delete_submission','mod_workshop_external','delete_submission',NULL,'mod_workshop','mod/workshop:submit','moodle_mobile_app'),(448,'mod_workshop_get_submissions','mod_workshop_external','get_submissions',NULL,'mod_workshop','','moodle_mobile_app'),(449,'mod_workshop_get_submission','mod_workshop_external','get_submission',NULL,'mod_workshop','','moodle_mobile_app'),(450,'mod_workshop_get_submission_assessments','mod_workshop_external','get_submission_assessments',NULL,'mod_workshop','','moodle_mobile_app'),(451,'mod_workshop_get_assessment','mod_workshop_external','get_assessment',NULL,'mod_workshop','','moodle_mobile_app'),(452,'mod_workshop_get_assessment_form_definition','mod_workshop_external','get_assessment_form_definition',NULL,'mod_workshop','','moodle_mobile_app'),(453,'mod_workshop_get_reviewer_assessments','mod_workshop_external','get_reviewer_assessments',NULL,'mod_workshop','','moodle_mobile_app'),(454,'mod_workshop_update_assessment','mod_workshop_external','update_assessment',NULL,'mod_workshop','','moodle_mobile_app'),(455,'mod_workshop_get_grades','mod_workshop_external','get_grades',NULL,'mod_workshop','','moodle_mobile_app'),(456,'mod_workshop_evaluate_assessment','mod_workshop_external','evaluate_assessment',NULL,'mod_workshop','','moodle_mobile_app'),(457,'mod_workshop_get_grades_report','mod_workshop_external','get_grades_report',NULL,'mod_workshop','','moodle_mobile_app'),(458,'mod_workshop_view_submission','mod_workshop_external','view_submission',NULL,'mod_workshop','mod/workshop:view','moodle_mobile_app'),(459,'mod_workshop_evaluate_submission','mod_workshop_external','evaluate_submission',NULL,'mod_workshop','','moodle_mobile_app'),(460,'auth_email_get_signup_settings','auth_email_external','get_signup_settings',NULL,'auth_email','',NULL),(461,'auth_email_signup_user','auth_email_external','signup_user',NULL,'auth_email','',NULL),(462,'enrol_guest_get_instance_info','enrol_guest_external','get_instance_info',NULL,'enrol_guest','','moodle_mobile_app'),(463,'enrol_manual_enrol_users','enrol_manual_external','enrol_users','enrol/manual/externallib.php','enrol_manual','enrol/manual:enrol',NULL),(464,'enrol_manual_unenrol_users','enrol_manual_external','unenrol_users','enrol/manual/externallib.php','enrol_manual','enrol/manual:unenrol',NULL),(465,'enrol_self_get_instance_info','enrol_self_external','get_instance_info','enrol/self/externallib.php','enrol_self','','moodle_mobile_app'),(466,'enrol_self_enrol_user','enrol_self_external','enrol_user','enrol/self/externallib.php','enrol_self','','moodle_mobile_app'),(467,'message_airnotifier_is_system_configured','message_airnotifier_external','is_system_configured','message/output/airnotifier/externallib.php','message_airnotifier','','moodle_mobile_app'),(468,'message_airnotifier_are_notification_preferences_configured','message_airnotifier_external','are_notification_preferences_configured','message/output/airnotifier/externallib.php','message_airnotifier','','moodle_mobile_app'),(469,'message_airnotifier_get_user_devices','message_airnotifier_external','get_user_devices','message/output/airnotifier/externallib.php','message_airnotifier','','moodle_mobile_app'),(470,'message_airnotifier_enable_device','message_airnotifier_external','enable_device','message/output/airnotifier/externallib.php','message_airnotifier','message/airnotifier:managedevice','moodle_mobile_app'),(471,'message_popup_get_popup_notifications','message_popup_external','get_popup_notifications','message/output/popup/externallib.php','message_popup','','moodle_mobile_app'),(472,'message_popup_get_unread_popup_notification_count','message_popup_external','get_unread_popup_notification_count','message/output/popup/externallib.php','message_popup','','moodle_mobile_app'),(473,'block_recentlyaccesseditems_get_recent_items','block_recentlyaccesseditems\\external','get_recent_items',NULL,'block_recentlyaccesseditems','','moodle_mobile_app'),(474,'block_starredcourses_get_starred_courses','block_starredcourses_external','get_starred_courses','block/starredcourses/classes/external.php','block_starredcourses','','moodle_mobile_app'),(475,'report_competency_data_for_report','report_competency\\external','data_for_report',NULL,'report_competency','moodle/competency:coursecompetencyview',NULL),(476,'report_insights_set_notuseful_prediction','report_insights\\external','set_notuseful_prediction',NULL,'report_insights','','moodle_mobile_app'),(477,'report_insights_set_fixed_prediction','report_insights\\external','set_fixed_prediction',NULL,'report_insights','','moodle_mobile_app'),(478,'gradereport_overview_get_course_grades','gradereport_overview_external','get_course_grades',NULL,'gradereport_overview','','moodle_mobile_app'),(479,'gradereport_overview_view_grade_report','gradereport_overview_external','view_grade_report',NULL,'gradereport_overview','gradereport/overview:view','moodle_mobile_app'),(480,'gradereport_user_get_grades_table','gradereport_user_external','get_grades_table','grade/report/user/externallib.php','gradereport_user','gradereport/user:view','moodle_mobile_app'),(481,'gradereport_user_view_grade_report','gradereport_user_external','view_grade_report','grade/report/user/externallib.php','gradereport_user','gradereport/user:view','moodle_mobile_app'),(482,'gradereport_user_get_grade_items','gradereport_user_external','get_grade_items','grade/report/user/externallib.php','gradereport_user','gradereport/user:view','moodle_mobile_app'),(483,'tool_dataprivacy_cancel_data_request','tool_dataprivacy\\external','cancel_data_request',NULL,'tool_dataprivacy','',NULL),(484,'tool_dataprivacy_contact_dpo','tool_dataprivacy\\external','contact_dpo',NULL,'tool_dataprivacy','',NULL),(485,'tool_dataprivacy_mark_complete','tool_dataprivacy\\external','mark_complete',NULL,'tool_dataprivacy','tool/dataprivacy:managedatarequests',NULL),(486,'tool_dataprivacy_get_data_request','tool_dataprivacy\\external','get_data_request',NULL,'tool_dataprivacy','tool/dataprivacy:managedatarequests',NULL),(487,'tool_dataprivacy_approve_data_request','tool_dataprivacy\\external','approve_data_request',NULL,'tool_dataprivacy','tool/dataprivacy:managedatarequests',NULL),(488,'tool_dataprivacy_bulk_approve_data_requests','tool_dataprivacy\\external','bulk_approve_data_requests',NULL,'tool_dataprivacy','tool/dataprivacy:managedatarequests',NULL),(489,'tool_dataprivacy_deny_data_request','tool_dataprivacy\\external','deny_data_request',NULL,'tool_dataprivacy','tool/dataprivacy:managedatarequests',NULL),(490,'tool_dataprivacy_bulk_deny_data_requests','tool_dataprivacy\\external','bulk_deny_data_requests',NULL,'tool_dataprivacy','tool/dataprivacy:managedatarequests',NULL),(491,'tool_dataprivacy_get_users','tool_dataprivacy\\external','get_users',NULL,'tool_dataprivacy','tool/dataprivacy:managedatarequests',NULL),(492,'tool_dataprivacy_create_purpose_form','tool_dataprivacy\\external','create_purpose_form',NULL,'tool_dataprivacy','',NULL),(493,'tool_dataprivacy_create_category_form','tool_dataprivacy\\external','create_category_form',NULL,'tool_dataprivacy','',NULL),(494,'tool_dataprivacy_delete_purpose','tool_dataprivacy\\external','delete_purpose',NULL,'tool_dataprivacy','',NULL),(495,'tool_dataprivacy_delete_category','tool_dataprivacy\\external','delete_category',NULL,'tool_dataprivacy','',NULL),(496,'tool_dataprivacy_set_contextlevel_form','tool_dataprivacy\\external','set_contextlevel_form',NULL,'tool_dataprivacy','',NULL),(497,'tool_dataprivacy_set_context_form','tool_dataprivacy\\external','set_context_form',NULL,'tool_dataprivacy','',NULL),(498,'tool_dataprivacy_tree_extra_branches','tool_dataprivacy\\external','tree_extra_branches',NULL,'tool_dataprivacy','',NULL),(499,'tool_dataprivacy_confirm_contexts_for_deletion','tool_dataprivacy\\external','confirm_contexts_for_deletion',NULL,'tool_dataprivacy','',NULL),(500,'tool_dataprivacy_set_context_defaults','tool_dataprivacy\\external','set_context_defaults',NULL,'tool_dataprivacy','tool/dataprivacy:managedataregistry',NULL),(501,'tool_dataprivacy_get_category_options','tool_dataprivacy\\external','get_category_options',NULL,'tool_dataprivacy','tool/dataprivacy:managedataregistry',NULL),(502,'tool_dataprivacy_get_purpose_options','tool_dataprivacy\\external','get_purpose_options',NULL,'tool_dataprivacy','tool/dataprivacy:managedataregistry',NULL),(503,'tool_dataprivacy_get_activity_options','tool_dataprivacy\\external','get_activity_options',NULL,'tool_dataprivacy','tool/dataprivacy:managedataregistry',NULL),(504,'tool_lp_data_for_competency_frameworks_manage_page','tool_lp\\external','data_for_competency_frameworks_manage_page',NULL,'tool_lp','moodle/competency:competencyview',NULL),(505,'tool_lp_data_for_competency_summary','tool_lp\\external','data_for_competency_summary',NULL,'tool_lp','moodle/competency:competencyview',NULL),(506,'tool_lp_data_for_competencies_manage_page','tool_lp\\external','data_for_competencies_manage_page',NULL,'tool_lp','moodle/competency:competencyview',NULL),(507,'tool_lp_list_courses_using_competency','tool_lp\\external','list_courses_using_competency',NULL,'tool_lp','moodle/competency:coursecompetencyview',NULL),(508,'tool_lp_data_for_course_competencies_page','tool_lp\\external','data_for_course_competencies_page',NULL,'tool_lp','moodle/competency:coursecompetencyview','moodle_mobile_app'),(509,'tool_lp_data_for_template_competencies_page','tool_lp\\external','data_for_template_competencies_page',NULL,'tool_lp','moodle/competency:templateview',NULL),(510,'tool_lp_data_for_templates_manage_page','tool_lp\\external','data_for_templates_manage_page',NULL,'tool_lp','moodle/competency:templateview',NULL),(511,'tool_lp_data_for_plans_page','tool_lp\\external','data_for_plans_page',NULL,'tool_lp','moodle/competency:planviewown','moodle_mobile_app'),(512,'tool_lp_data_for_plan_page','tool_lp\\external','data_for_plan_page',NULL,'tool_lp','moodle/competency:planview','moodle_mobile_app'),(513,'tool_lp_data_for_related_competencies_section','tool_lp\\external','data_for_related_competencies_section',NULL,'tool_lp','moodle/competency:competencyview',NULL),(514,'tool_lp_search_users','tool_lp\\external','search_users',NULL,'tool_lp','',NULL),(515,'tool_lp_search_cohorts','core_cohort_external','search_cohorts','cohort/externallib.php','tool_lp','moodle/cohort:view',NULL),(516,'tool_lp_data_for_user_evidence_list_page','tool_lp\\external','data_for_user_evidence_list_page',NULL,'tool_lp','moodle/competency:userevidenceview','moodle_mobile_app'),(517,'tool_lp_data_for_user_evidence_page','tool_lp\\external','data_for_user_evidence_page',NULL,'tool_lp','moodle/competency:userevidenceview','moodle_mobile_app'),(518,'tool_lp_data_for_user_competency_summary','tool_lp\\external','data_for_user_competency_summary',NULL,'tool_lp','moodle/competency:planview','moodle_mobile_app'),(519,'tool_lp_data_for_user_competency_summary_in_plan','tool_lp\\external','data_for_user_competency_summary_in_plan',NULL,'tool_lp','moodle/competency:planview','moodle_mobile_app'),(520,'tool_lp_data_for_user_competency_summary_in_course','tool_lp\\external','data_for_user_competency_summary_in_course',NULL,'tool_lp','moodle/competency:coursecompetencyview','moodle_mobile_app'),(521,'tool_mobile_get_plugins_supporting_mobile','tool_mobile\\external','get_plugins_supporting_mobile',NULL,'tool_mobile','','moodle_mobile_app'),(522,'tool_mobile_get_public_config','tool_mobile\\external','get_public_config',NULL,'tool_mobile','','moodle_mobile_app'),(523,'tool_mobile_get_config','tool_mobile\\external','get_config',NULL,'tool_mobile','','moodle_mobile_app'),(524,'tool_mobile_get_autologin_key','tool_mobile\\external','get_autologin_key',NULL,'tool_mobile','','moodle_mobile_app'),(525,'tool_mobile_get_content','tool_mobile\\external','get_content',NULL,'tool_mobile','','moodle_mobile_app'),(526,'tool_policy_get_policy_version','tool_policy\\external','get_policy_version',NULL,'tool_policy','',NULL),(527,'tool_policy_submit_accept_on_behalf','tool_policy\\external','submit_accept_on_behalf',NULL,'tool_policy','',NULL),(528,'tool_templatelibrary_list_templates','tool_templatelibrary\\external','list_templates',NULL,'tool_templatelibrary','',NULL),(529,'tool_templatelibrary_load_canonical_template','tool_templatelibrary\\external','load_canonical_template',NULL,'tool_templatelibrary','',NULL),(530,'tool_usertours_fetch_and_start_tour','tool_usertours\\external\\tour','fetch_and_start_tour',NULL,'tool_usertours','',NULL),(531,'tool_usertours_step_shown','tool_usertours\\external\\tour','step_shown',NULL,'tool_usertours','',NULL),(532,'tool_usertours_complete_tour','tool_usertours\\external\\tour','complete_tour',NULL,'tool_usertours','',NULL),(533,'tool_usertours_reset_tour','tool_usertours\\external\\tour','reset_tour',NULL,'tool_usertours','',NULL),(534,'tool_xmldb_invoke_move_action','tool_xmldb_external','invoke_move_action',NULL,'tool_xmldb','',NULL);
/*!40000 ALTER TABLE `mdl_external_functions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_services`
--

DROP TABLE IF EXISTS `mdl_external_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_services` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL,
  `requiredcapability` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `restrictedusers` tinyint(1) NOT NULL,
  `component` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `shortname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `downloadfiles` tinyint(1) NOT NULL DEFAULT '0',
  `uploadfiles` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_exteserv_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='built in and custom external services';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_services`
--

LOCK TABLES `mdl_external_services` WRITE;
/*!40000 ALTER TABLE `mdl_external_services` DISABLE KEYS */;
INSERT INTO `mdl_external_services` VALUES (1,'Moodle mobile web service',0,NULL,0,'moodle',1547809433,1547810083,'moodle_mobile_app',1,1);
/*!40000 ALTER TABLE `mdl_external_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_services_functions`
--

DROP TABLE IF EXISTS `mdl_external_services_functions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_services_functions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint(10) NOT NULL,
  `functionname` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_exteservfunc_ext_ix` (`externalserviceid`)
) ENGINE=InnoDB AUTO_INCREMENT=328 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='lists functions available in each service group';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_services_functions`
--

LOCK TABLES `mdl_external_services_functions` WRITE;
/*!40000 ALTER TABLE `mdl_external_services_functions` DISABLE KEYS */;
INSERT INTO `mdl_external_services_functions` VALUES (1,1,'core_badges_get_user_badges'),(2,1,'core_blog_get_entries'),(3,1,'core_blog_view_entries'),(4,1,'core_calendar_get_calendar_monthly_view'),(5,1,'core_calendar_get_calendar_day_view'),(6,1,'core_calendar_get_calendar_upcoming_view'),(7,1,'core_calendar_create_calendar_events'),(8,1,'core_calendar_delete_calendar_events'),(9,1,'core_calendar_get_calendar_events'),(10,1,'core_calendar_get_action_events_by_timesort'),(11,1,'core_calendar_get_action_events_by_course'),(12,1,'core_calendar_get_action_events_by_courses'),(13,1,'core_calendar_get_calendar_event_by_id'),(14,1,'core_comment_get_comments'),(15,1,'core_completion_get_activities_completion_status'),(16,1,'core_completion_get_course_completion_status'),(17,1,'core_completion_mark_course_self_completed'),(18,1,'core_completion_update_activity_completion_status_manually'),(19,1,'core_course_get_categories'),(20,1,'core_course_get_contents'),(21,1,'core_course_get_course_module'),(22,1,'core_course_get_course_module_by_instance'),(23,1,'core_course_get_courses'),(24,1,'core_course_search_courses'),(25,1,'core_course_view_course'),(26,1,'core_course_get_activities_overview'),(27,1,'core_course_get_user_navigation_options'),(28,1,'core_course_get_user_administration_options'),(29,1,'core_course_get_courses_by_field'),(30,1,'core_course_check_updates'),(31,1,'core_course_get_updates_since'),(32,1,'core_course_get_enrolled_courses_by_timeline_classification'),(33,1,'core_course_get_recent_courses'),(34,1,'core_course_set_favourite_courses'),(35,1,'core_enrol_get_course_enrolment_methods'),(36,1,'core_enrol_get_enrolled_users'),(37,1,'core_enrol_get_users_courses'),(38,1,'core_files_get_files'),(39,1,'core_get_component_strings'),(40,1,'core_group_get_activity_allowed_groups'),(41,1,'core_group_get_activity_groupmode'),(42,1,'core_group_get_course_user_groups'),(43,1,'core_message_block_user'),(44,1,'core_message_block_contacts'),(45,1,'core_message_create_contacts'),(46,1,'core_message_get_contact_requests'),(47,1,'core_message_create_contact_request'),(48,1,'core_message_confirm_contact_request'),(49,1,'core_message_decline_contact_request'),(50,1,'core_message_get_received_contact_requests_count'),(51,1,'core_message_delete_contacts'),(52,1,'core_message_delete_conversation'),(53,1,'core_message_delete_conversations_by_id'),(54,1,'core_message_delete_message'),(55,1,'core_message_get_blocked_users'),(56,1,'core_message_data_for_messagearea_search_messages'),(57,1,'core_message_message_search_users'),(58,1,'core_message_data_for_messagearea_conversations'),(59,1,'core_message_data_for_messagearea_contacts'),(60,1,'core_message_data_for_messagearea_messages'),(61,1,'core_message_get_contacts'),(62,1,'core_message_get_user_contacts'),(63,1,'core_message_get_conversations'),(64,1,'core_message_get_conversation'),(65,1,'core_message_get_conversation_between_users'),(66,1,'core_message_get_messages'),(67,1,'core_message_get_conversation_counts'),(68,1,'core_message_get_unread_conversation_counts'),(69,1,'core_message_get_conversation_members'),(70,1,'core_message_get_member_info'),(71,1,'core_message_get_unread_conversations_count'),(72,1,'core_message_mark_all_notifications_as_read'),(73,1,'core_message_mark_all_messages_as_read'),(74,1,'core_message_mark_all_conversation_messages_as_read'),(75,1,'core_message_mark_message_read'),(76,1,'core_message_mark_notification_read'),(77,1,'core_message_message_processor_config_form'),(78,1,'core_message_search_contacts'),(79,1,'core_message_send_instant_messages'),(80,1,'core_message_send_messages_to_conversation'),(81,1,'core_message_get_conversation_messages'),(82,1,'core_message_unblock_user'),(83,1,'core_message_unblock_contacts'),(84,1,'core_message_get_user_notification_preferences'),(85,1,'core_message_get_user_message_preferences'),(86,1,'core_message_set_favourite_conversations'),(87,1,'core_message_unset_favourite_conversations'),(88,1,'core_notes_create_notes'),(89,1,'core_notes_delete_notes'),(90,1,'core_notes_get_course_notes'),(91,1,'core_notes_view_notes'),(92,1,'core_question_update_flag'),(93,1,'core_rating_get_item_ratings'),(94,1,'core_rating_add_rating'),(95,1,'core_user_add_user_device'),(96,1,'core_user_add_user_private_files'),(97,1,'core_user_get_course_user_profiles'),(98,1,'core_user_get_users_by_field'),(99,1,'core_user_remove_user_device'),(100,1,'core_user_update_user_preferences'),(101,1,'core_user_view_user_list'),(102,1,'core_user_view_user_profile'),(103,1,'core_user_get_user_preferences'),(104,1,'core_user_update_picture'),(105,1,'core_user_set_user_preferences'),(106,1,'core_user_agree_site_policy'),(107,1,'core_user_get_private_files_info'),(108,1,'core_competency_competency_viewed'),(109,1,'core_competency_list_course_competencies'),(110,1,'core_competency_get_scale_values'),(111,1,'core_competency_user_competency_viewed'),(112,1,'core_competency_user_competency_viewed_in_plan'),(113,1,'core_competency_user_competency_viewed_in_course'),(114,1,'core_competency_user_competency_plan_viewed'),(115,1,'core_competency_grade_competency_in_course'),(116,1,'core_competency_delete_evidence'),(117,1,'core_webservice_get_site_info'),(118,1,'core_block_get_course_blocks'),(119,1,'core_block_get_dashboard_blocks'),(120,1,'core_filters_get_available_in_context'),(121,1,'mod_assign_get_grades'),(122,1,'mod_assign_get_assignments'),(123,1,'mod_assign_get_submissions'),(124,1,'mod_assign_get_user_flags'),(125,1,'mod_assign_set_user_flags'),(126,1,'mod_assign_get_user_mappings'),(127,1,'mod_assign_revert_submissions_to_draft'),(128,1,'mod_assign_lock_submissions'),(129,1,'mod_assign_unlock_submissions'),(130,1,'mod_assign_save_submission'),(131,1,'mod_assign_submit_for_grading'),(132,1,'mod_assign_save_grade'),(133,1,'mod_assign_save_grades'),(134,1,'mod_assign_save_user_extensions'),(135,1,'mod_assign_reveal_identities'),(136,1,'mod_assign_view_grading_table'),(137,1,'mod_assign_view_submission_status'),(138,1,'mod_assign_get_submission_status'),(139,1,'mod_assign_list_participants'),(140,1,'mod_assign_submit_grading_form'),(141,1,'mod_assign_get_participant'),(142,1,'mod_assign_view_assign'),(143,1,'mod_book_view_book'),(144,1,'mod_book_get_books_by_courses'),(145,1,'mod_chat_login_user'),(146,1,'mod_chat_get_chat_users'),(147,1,'mod_chat_send_chat_message'),(148,1,'mod_chat_get_chat_latest_messages'),(149,1,'mod_chat_view_chat'),(150,1,'mod_chat_get_chats_by_courses'),(151,1,'mod_chat_get_sessions'),(152,1,'mod_chat_get_session_messages'),(153,1,'mod_choice_get_choice_results'),(154,1,'mod_choice_get_choice_options'),(155,1,'mod_choice_submit_choice_response'),(156,1,'mod_choice_view_choice'),(157,1,'mod_choice_get_choices_by_courses'),(158,1,'mod_choice_delete_choice_responses'),(159,1,'mod_data_get_databases_by_courses'),(160,1,'mod_data_view_database'),(161,1,'mod_data_get_data_access_information'),(162,1,'mod_data_get_entries'),(163,1,'mod_data_get_entry'),(164,1,'mod_data_get_fields'),(165,1,'mod_data_search_entries'),(166,1,'mod_data_approve_entry'),(167,1,'mod_data_delete_entry'),(168,1,'mod_data_add_entry'),(169,1,'mod_data_update_entry'),(170,1,'mod_feedback_get_feedbacks_by_courses'),(171,1,'mod_feedback_get_feedback_access_information'),(172,1,'mod_feedback_view_feedback'),(173,1,'mod_feedback_get_current_completed_tmp'),(174,1,'mod_feedback_get_items'),(175,1,'mod_feedback_launch_feedback'),(176,1,'mod_feedback_get_page_items'),(177,1,'mod_feedback_process_page'),(178,1,'mod_feedback_get_analysis'),(179,1,'mod_feedback_get_unfinished_responses'),(180,1,'mod_feedback_get_finished_responses'),(181,1,'mod_feedback_get_non_respondents'),(182,1,'mod_feedback_get_responses_analysis'),(183,1,'mod_feedback_get_last_completed'),(184,1,'mod_folder_view_folder'),(185,1,'mod_folder_get_folders_by_courses'),(186,1,'mod_forum_get_forums_by_courses'),(187,1,'mod_forum_get_forum_discussion_posts'),(188,1,'mod_forum_get_forum_discussions_paginated'),(189,1,'mod_forum_view_forum'),(190,1,'mod_forum_view_forum_discussion'),(191,1,'mod_forum_add_discussion_post'),(192,1,'mod_forum_add_discussion'),(193,1,'mod_forum_can_add_discussion'),(194,1,'mod_glossary_get_glossaries_by_courses'),(195,1,'mod_glossary_view_glossary'),(196,1,'mod_glossary_view_entry'),(197,1,'mod_glossary_get_entries_by_letter'),(198,1,'mod_glossary_get_entries_by_date'),(199,1,'mod_glossary_get_categories'),(200,1,'mod_glossary_get_entries_by_category'),(201,1,'mod_glossary_get_authors'),(202,1,'mod_glossary_get_entries_by_author'),(203,1,'mod_glossary_get_entries_by_author_id'),(204,1,'mod_glossary_get_entries_by_search'),(205,1,'mod_glossary_get_entries_by_term'),(206,1,'mod_glossary_get_entries_to_approve'),(207,1,'mod_glossary_get_entry_by_id'),(208,1,'mod_glossary_add_entry'),(209,1,'mod_imscp_view_imscp'),(210,1,'mod_imscp_get_imscps_by_courses'),(211,1,'mod_label_get_labels_by_courses'),(212,1,'mod_lesson_get_lessons_by_courses'),(213,1,'mod_lesson_get_lesson_access_information'),(214,1,'mod_lesson_view_lesson'),(215,1,'mod_lesson_get_questions_attempts'),(216,1,'mod_lesson_get_user_grade'),(217,1,'mod_lesson_get_user_attempt_grade'),(218,1,'mod_lesson_get_content_pages_viewed'),(219,1,'mod_lesson_get_user_timers'),(220,1,'mod_lesson_get_pages'),(221,1,'mod_lesson_launch_attempt'),(222,1,'mod_lesson_get_page_data'),(223,1,'mod_lesson_process_page'),(224,1,'mod_lesson_finish_attempt'),(225,1,'mod_lesson_get_attempts_overview'),(226,1,'mod_lesson_get_user_attempt'),(227,1,'mod_lesson_get_pages_possible_jumps'),(228,1,'mod_lesson_get_lesson'),(229,1,'mod_lti_get_tool_launch_data'),(230,1,'mod_lti_get_ltis_by_courses'),(231,1,'mod_lti_view_lti'),(232,1,'mod_page_view_page'),(233,1,'mod_page_get_pages_by_courses'),(234,1,'mod_quiz_get_quizzes_by_courses'),(235,1,'mod_quiz_view_quiz'),(236,1,'mod_quiz_get_user_attempts'),(237,1,'mod_quiz_get_user_best_grade'),(238,1,'mod_quiz_get_combined_review_options'),(239,1,'mod_quiz_start_attempt'),(240,1,'mod_quiz_get_attempt_data'),(241,1,'mod_quiz_get_attempt_summary'),(242,1,'mod_quiz_save_attempt'),(243,1,'mod_quiz_process_attempt'),(244,1,'mod_quiz_get_attempt_review'),(245,1,'mod_quiz_view_attempt'),(246,1,'mod_quiz_view_attempt_summary'),(247,1,'mod_quiz_view_attempt_review'),(248,1,'mod_quiz_get_quiz_feedback_for_grade'),(249,1,'mod_quiz_get_quiz_access_information'),(250,1,'mod_quiz_get_attempt_access_information'),(251,1,'mod_quiz_get_quiz_required_qtypes'),(252,1,'mod_resource_view_resource'),(253,1,'mod_resource_get_resources_by_courses'),(254,1,'mod_scorm_view_scorm'),(255,1,'mod_scorm_get_scorm_attempt_count'),(256,1,'mod_scorm_get_scorm_scoes'),(257,1,'mod_scorm_get_scorm_user_data'),(258,1,'mod_scorm_insert_scorm_tracks'),(259,1,'mod_scorm_get_scorm_sco_tracks'),(260,1,'mod_scorm_get_scorms_by_courses'),(261,1,'mod_scorm_launch_sco'),(262,1,'mod_survey_get_surveys_by_courses'),(263,1,'mod_survey_view_survey'),(264,1,'mod_survey_get_questions'),(265,1,'mod_survey_submit_answers'),(266,1,'mod_url_view_url'),(267,1,'mod_url_get_urls_by_courses'),(268,1,'mod_wiki_get_wikis_by_courses'),(269,1,'mod_wiki_view_wiki'),(270,1,'mod_wiki_view_page'),(271,1,'mod_wiki_get_subwikis'),(272,1,'mod_wiki_get_subwiki_pages'),(273,1,'mod_wiki_get_subwiki_files'),(274,1,'mod_wiki_get_page_contents'),(275,1,'mod_wiki_get_page_for_editing'),(276,1,'mod_wiki_new_page'),(277,1,'mod_wiki_edit_page'),(278,1,'mod_workshop_get_workshops_by_courses'),(279,1,'mod_workshop_get_workshop_access_information'),(280,1,'mod_workshop_get_user_plan'),(281,1,'mod_workshop_view_workshop'),(282,1,'mod_workshop_add_submission'),(283,1,'mod_workshop_update_submission'),(284,1,'mod_workshop_delete_submission'),(285,1,'mod_workshop_get_submissions'),(286,1,'mod_workshop_get_submission'),(287,1,'mod_workshop_get_submission_assessments'),(288,1,'mod_workshop_get_assessment'),(289,1,'mod_workshop_get_assessment_form_definition'),(290,1,'mod_workshop_get_reviewer_assessments'),(291,1,'mod_workshop_update_assessment'),(292,1,'mod_workshop_get_grades'),(293,1,'mod_workshop_evaluate_assessment'),(294,1,'mod_workshop_get_grades_report'),(295,1,'mod_workshop_view_submission'),(296,1,'mod_workshop_evaluate_submission'),(297,1,'enrol_guest_get_instance_info'),(298,1,'enrol_self_get_instance_info'),(299,1,'enrol_self_enrol_user'),(300,1,'message_airnotifier_is_system_configured'),(301,1,'message_airnotifier_are_notification_preferences_configured'),(302,1,'message_airnotifier_get_user_devices'),(303,1,'message_airnotifier_enable_device'),(304,1,'message_popup_get_popup_notifications'),(305,1,'message_popup_get_unread_popup_notification_count'),(306,1,'block_recentlyaccesseditems_get_recent_items'),(307,1,'block_starredcourses_get_starred_courses'),(308,1,'report_insights_set_notuseful_prediction'),(309,1,'report_insights_set_fixed_prediction'),(310,1,'gradereport_overview_get_course_grades'),(311,1,'gradereport_overview_view_grade_report'),(312,1,'gradereport_user_get_grades_table'),(313,1,'gradereport_user_view_grade_report'),(314,1,'gradereport_user_get_grade_items'),(315,1,'tool_lp_data_for_course_competencies_page'),(316,1,'tool_lp_data_for_plans_page'),(317,1,'tool_lp_data_for_plan_page'),(318,1,'tool_lp_data_for_user_evidence_list_page'),(319,1,'tool_lp_data_for_user_evidence_page'),(320,1,'tool_lp_data_for_user_competency_summary'),(321,1,'tool_lp_data_for_user_competency_summary_in_plan'),(322,1,'tool_lp_data_for_user_competency_summary_in_course'),(323,1,'tool_mobile_get_plugins_supporting_mobile'),(324,1,'tool_mobile_get_public_config'),(325,1,'tool_mobile_get_config'),(326,1,'tool_mobile_get_autologin_key'),(327,1,'tool_mobile_get_content');
/*!40000 ALTER TABLE `mdl_external_services_functions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_services_users`
--

DROP TABLE IF EXISTS `mdl_external_services_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_services_users` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `iprestriction` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `validuntil` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_exteservuser_ext_ix` (`externalserviceid`),
  KEY `mdl_exteservuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='users allowed to use services with restricted users flag';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_services_users`
--

LOCK TABLES `mdl_external_services_users` WRITE;
/*!40000 ALTER TABLE `mdl_external_services_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_external_services_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_tokens`
--

DROP TABLE IF EXISTS `mdl_external_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_tokens` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `token` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `privatetoken` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tokentype` smallint(4) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `externalserviceid` bigint(10) NOT NULL,
  `sid` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contextid` bigint(10) NOT NULL,
  `creatorid` bigint(10) NOT NULL DEFAULT '1',
  `iprestriction` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `validuntil` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `lastaccess` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_extetoke_use_ix` (`userid`),
  KEY `mdl_extetoke_ext_ix` (`externalserviceid`),
  KEY `mdl_extetoke_con_ix` (`contextid`),
  KEY `mdl_extetoke_cre_ix` (`creatorid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Security tokens for accessing of external services';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_tokens`
--

LOCK TABLES `mdl_external_tokens` WRITE;
/*!40000 ALTER TABLE `mdl_external_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_external_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_favourite`
--

DROP TABLE IF EXISTS `mdl_favourite`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_favourite` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemtype` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `ordering` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_favo_comiteiteconuse_uix` (`component`,`itemtype`,`itemid`,`contextid`,`userid`),
  KEY `mdl_favo_con_ix` (`contextid`),
  KEY `mdl_favo_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the relationship between an arbitrary item (itemtype,';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_favourite`
--

LOCK TABLES `mdl_favourite` WRITE;
/*!40000 ALTER TABLE `mdl_favourite` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_favourite` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback`
--

DROP TABLE IF EXISTS `mdl_feedback`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `anonymous` tinyint(1) NOT NULL DEFAULT '1',
  `email_notification` tinyint(1) NOT NULL DEFAULT '1',
  `multiple_submit` tinyint(1) NOT NULL DEFAULT '1',
  `autonumbering` tinyint(1) NOT NULL DEFAULT '1',
  `site_after_submit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `page_after_submit` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_after_submitformat` tinyint(2) NOT NULL DEFAULT '0',
  `publish_stats` tinyint(1) NOT NULL DEFAULT '0',
  `timeopen` bigint(10) NOT NULL DEFAULT '0',
  `timeclose` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_feed_cou_ix` (`course`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='all feedbacks';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback`
--

LOCK TABLES `mdl_feedback` WRITE;
/*!40000 ALTER TABLE `mdl_feedback` DISABLE KEYS */;
INSERT INTO `mdl_feedback` VALUES (1,2,'Personality Test','<p></p><h3>Aturan Penilaian</h3><p>Anda mungkin diminta untuk menilai diri A\\anda berdasarkan sejumlah frasa atau pernyataan. Dalam hal ini tidak ada jawaban benar atau salah, pilihlah jawaban yang sesuai dengan diri anda. Setelah membaca tiap pernyataan Anda akan menandai jawaban Anda berdasarkan aturan berikut :</p><p>1. Sangat Tidak Setuju</p><p>2. Tidak Setuju</p><p>3. Setuju</p><p>4. Sangat Setuju</p><br><p></p>',1,1,0,0,0,'','',1,0,0,0,1551208020,0);
/*!40000 ALTER TABLE `mdl_feedback` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_completed`
--

DROP TABLE IF EXISTS `mdl_feedback_completed`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_completed` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `random_response` bigint(10) NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_feedcomp_use_ix` (`userid`),
  KEY `mdl_feedcomp_fee_ix` (`feedback`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='filled out feedback';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_completed`
--

LOCK TABLES `mdl_feedback_completed` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_completed` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_completed` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_completedtmp`
--

DROP TABLE IF EXISTS `mdl_feedback_completedtmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_completedtmp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `guestid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `random_response` bigint(10) NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_feedcomp_use2_ix` (`userid`),
  KEY `mdl_feedcomp_fee2_ix` (`feedback`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='filled out feedback';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_completedtmp`
--

LOCK TABLES `mdl_feedback_completedtmp` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_completedtmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_completedtmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_item`
--

DROP TABLE IF EXISTS `mdl_feedback_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_item` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `template` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `presentation` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `typ` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hasvalue` tinyint(1) NOT NULL DEFAULT '0',
  `position` smallint(3) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `dependitem` bigint(10) NOT NULL DEFAULT '0',
  `dependvalue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `options` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_feeditem_fee_ix` (`feedback`),
  KEY `mdl_feeditem_tem_ix` (`template`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='feedback_items';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_item`
--

LOCK TABLES `mdl_feedback_item` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_item` DISABLE KEYS */;
INSERT INTO `mdl_feedback_item` VALUES (1,1,0,'Saya memiliki kemauan yang sangat kuat dan keras kepala. Saya akan melakukan apa saja untuk mendapatkan apa yang Saya inginkan. ','1','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,1,1,0,'',''),(2,1,0,'Saya tidak pernah santai/rileks. Saya selalu ingin bekerja walaupun waktunya sudah selesai. ','2','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,2,1,0,'',''),(3,1,0,'Saya lebih sering menunjukkan perilaku yang menyenangkan. Saya lebih banyak tertawa dan tersenyum daripada berwajah muram. ','3','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,3,1,0,'',''),(4,1,0,'Saya jika pertama kali bertemu dengan orang yang asing, biasanya Saya akan merasa agak sungkan. Saya lambat menerima orang baru. Mula-mula saya akan menarik diri dan kemudian akan menyesuaikan diri dengan perlahan-lahan. ','4','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,4,1,0,'',''),(5,1,0,'Saya bertindak dengan cepat dan mandiri dan suka mengerjakan sesuatu sendiri.','5','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,5,1,0,'',''),(6,1,0,'Saya menunjukkan perubahan emosi yang jelas. Saya bertindak berdasarkan perasaannya dan memiliki bakat untuk mengerjakan sesuatu dengan dramatis. ','6','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,6,1,0,'',''),(7,1,0,'Saya sering tampak tenang dan ramah. Saya umumnya memiliki reaksi yang tenang dan lembut terhadap suatu keadaan. ','7','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,7,1,0,'',''),(8,1,0,'Saya menyukai privasi dan kadang kala menyendiri dan jarang bergaul. ','8','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,8,1,0,'',''),(9,1,0,'Saya umumnya tidak memberikan tanggapan yang berlebihan atas kasih sayang yang ditujukan kepada Saya. ','9','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,9,1,0,'',''),(10,1,0,'Saya umumnya optimis dan antusias dalam dalam hampir setiap situasi.','10','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,10,1,0,'',''),(11,1,0,'Saya kurang aktif dalam mencoba hal-hal baru dan biasanya lebih suka melakukan hal yang telah saya ketahui dan saya kenal. ','11','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,11,1,0,'',''),(12,1,0,'Saya mengajukan banyak pertanyaan dan lebih suka memikirkan sesuatu secara mendalam sebelum mengambil keputusan.','12','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,12,1,0,'',''),(13,1,0,'Saya seringkali sangat aktif. Saya suka menjelajah mencoba hal baru, dan suka mengambil risiko.','13','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,13,1,0,'',''),(14,1,0,'Saya mudah bekerjasama dengan orang lain dan biasanya mudah cocok dengan orang lain. ','14','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,14,1,0,'',''),(15,1,0,'Saya seringkali mengambil suatu pendekatan yang berhati-hati terhadap suatu hal atau keadaan yang baru.','15','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,15,1,0,'',''),(16,1,0,'Saya terkadang sulit dipimpin dan sangat memilih terhadap siapa saya akan mengikuti.','16','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,16,1,0,'',''),(17,1,0,'Saya kerap berpindah dari suatu kegiatan ke kegiatan lain, sering tanpa menyelesaikan kegiatan itu. ','17','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,17,1,0,'',''),(18,1,0,'Saya terkadang segera menyerah bila mendapat tekanan dan mungkin meniru perilaku, aturan dan sifat orang lain secara berlebihan. ','18','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,18,1,0,'',''),(19,1,0,'Level kegiatan fisik (tingkat aktivitas) Saya biasanya terlihat rendah atau rata-rata.','19','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,19,1,0,'',''),(20,1,0,'Saya mudah marah dan memaksa untuk bisa mendapatkan yang Saya inginkan.','20','r>>>>>1\r|2\r|3\r|4<<<<<1','multichoice',1,20,1,0,'','');
/*!40000 ALTER TABLE `mdl_feedback_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_sitecourse_map`
--

DROP TABLE IF EXISTS `mdl_feedback_sitecourse_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_sitecourse_map` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedbackid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_feedsitemap_cou_ix` (`courseid`),
  KEY `mdl_feedsitemap_fee_ix` (`feedbackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='feedback sitecourse map';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_sitecourse_map`
--

LOCK TABLES `mdl_feedback_sitecourse_map` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_sitecourse_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_sitecourse_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_template`
--

DROP TABLE IF EXISTS `mdl_feedback_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_template` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `ispublic` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_feedtemp_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='templates of feedbackstructures';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_template`
--

LOCK TABLES `mdl_feedback_template` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_value`
--

DROP TABLE IF EXISTS `mdl_feedback_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_value` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course_id` bigint(10) NOT NULL DEFAULT '0',
  `item` bigint(10) NOT NULL DEFAULT '0',
  `completed` bigint(10) NOT NULL DEFAULT '0',
  `tmp_completed` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_feedvalu_comitecou_uix` (`completed`,`item`,`course_id`),
  KEY `mdl_feedvalu_cou_ix` (`course_id`),
  KEY `mdl_feedvalu_ite_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='values of the completeds';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_value`
--

LOCK TABLES `mdl_feedback_value` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_valuetmp`
--

DROP TABLE IF EXISTS `mdl_feedback_valuetmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_valuetmp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course_id` bigint(10) NOT NULL DEFAULT '0',
  `item` bigint(10) NOT NULL DEFAULT '0',
  `completed` bigint(10) NOT NULL DEFAULT '0',
  `tmp_completed` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_feedvalu_comitecou2_uix` (`completed`,`item`,`course_id`),
  KEY `mdl_feedvalu_cou2_ix` (`course_id`),
  KEY `mdl_feedvalu_ite2_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='values of the completedstmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_valuetmp`
--

LOCK TABLES `mdl_feedback_valuetmp` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_valuetmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_valuetmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_file_conversion`
--

DROP TABLE IF EXISTS `mdl_file_conversion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_file_conversion` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `sourcefileid` bigint(10) NOT NULL,
  `targetformat` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` bigint(10) DEFAULT '0',
  `statusmessage` longtext COLLATE utf8mb4_unicode_ci,
  `converter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `destfileid` bigint(10) DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_fileconv_sou_ix` (`sourcefileid`),
  KEY `mdl_fileconv_des_ix` (`destfileid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Table to track file conversions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_file_conversion`
--

LOCK TABLES `mdl_file_conversion` WRITE;
/*!40000 ALTER TABLE `mdl_file_conversion` DISABLE KEYS */;
INSERT INTO `mdl_file_conversion` VALUES (1,2,1548780970,1548780993,62,'pdf',-1,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `mdl_file_conversion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_files`
--

DROP TABLE IF EXISTS `mdl_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_files` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contenthash` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pathnamehash` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `filearea` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `filepath` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `filename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `userid` bigint(10) DEFAULT NULL,
  `filesize` bigint(10) NOT NULL,
  `mimetype` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `source` longtext COLLATE utf8mb4_unicode_ci,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `referencefileid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_file_pat_uix` (`pathnamehash`),
  KEY `mdl_file_comfilconite_ix` (`component`,`filearea`,`contextid`,`itemid`),
  KEY `mdl_file_con_ix` (`contenthash`),
  KEY `mdl_file_con2_ix` (`contextid`),
  KEY `mdl_file_use_ix` (`userid`),
  KEY `mdl_file_ref_ix` (`referencefileid`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='description of files, content is stored in sha1 file pool';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_files`
--

LOCK TABLES `mdl_files` WRITE;
/*!40000 ALTER TABLE `mdl_files` DISABLE KEYS */;
INSERT INTO `mdl_files` VALUES (1,'41cfeee5884a43a4650a851f4f85e7b28316fcc9','a48e186a2cc853a9e94e9305f4e9bc086391212d',1,'theme_more','backgroundimage',0,'/','background.jpg',2,4451,'image/jpeg',0,NULL,NULL,NULL,1547809763,1547809763,0,NULL),(2,'da39a3ee5e6b4b0d3255bfef95601890afd80709','d1da7ab1bb9c08a926037367bf8ce9a838034ead',1,'theme_more','backgroundimage',0,'/','.',2,0,NULL,0,NULL,NULL,NULL,1547809763,1548772163,0,NULL),(3,'5f8e911d0da441e36f47c5c46f4393269211ca56','508e674d49c30d4fde325fe6c7f6fd3d56b247e1',1,'assignfeedback_editpdf','stamps',0,'/','smile.png',2,1085,'image/png',0,NULL,NULL,NULL,1547809768,1547809768,0,NULL),(4,'da39a3ee5e6b4b0d3255bfef95601890afd80709','70b7cdade7b4e27d4e83f0cdaad10d6a3c0cccb5',1,'assignfeedback_editpdf','stamps',0,'/','.',2,0,NULL,0,NULL,NULL,NULL,1547809768,1547809768,0,NULL),(5,'75c101cb8cb34ea573cd25ac38f8157b1de901b8','68317eab56c67d32aeaee5acf509a0c4aa828b6b',1,'assignfeedback_editpdf','stamps',0,'/','sad.png',2,966,'image/png',0,NULL,NULL,NULL,1547809768,1547809768,0,NULL),(6,'0c5190a24c3943966541401c883eacaa20ca20cb','695a55ff780e61c9e59428aa425430b0d6bde53b',1,'assignfeedback_editpdf','stamps',0,'/','tick.png',2,1039,'image/png',0,NULL,NULL,NULL,1547809768,1547809768,0,NULL),(7,'8c96a486d5801e0f4ab8c411f561f1c687e1f865','373e63af262a9b8466ba8632551520be793c37ff',1,'assignfeedback_editpdf','stamps',0,'/','cross.png',2,861,'image/png',0,NULL,NULL,NULL,1547809768,1547809768,0,NULL),(8,'1993f0484931536fd6998712cd1bf708cbafbe9a','5fc08be8f9a0c418bd034a7f73e42395b28bd47e',5,'user','draft',826335921,'/','block_mylivechat_moodle25_2013070740.zip',2,5952,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:40:\"block_mylivechat_moodle25_2013070740.zip\";}','Muhammad Ainul Yaqin','allrightsreserved',1547828425,1547828425,0,NULL),(9,'da39a3ee5e6b4b0d3255bfef95601890afd80709','740f3f2a53e8d5004911666b6642c8c02da91d83',5,'user','draft',826335921,'/','.',2,0,NULL,0,NULL,NULL,NULL,1547828425,1547828425,0,NULL),(10,'41cfeee5884a43a4650a851f4f85e7b28316fcc9','496860dae9c37571c099b45a3a0bbe4c8a88f23b',5,'user','draft',558629611,'/','background.jpg',2,4451,'image/jpeg',0,'O:8:\"stdClass\":2:{s:6:\"source\";N;s:8:\"original\";s:236:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aToxO3M6OToiY29tcG9uZW50IjtzOjEwOiJ0aGVtZV9tb3JlIjtzOjY6Iml0ZW1pZCI7aTowO3M6ODoiZmlsZWFyZWEiO3M6MTU6ImJhY2tncm91bmRpbWFnZSI7czo4OiJmaWxlcGF0aCI7czoxOiIvIjtzOjg6ImZpbGVuYW1lIjtzOjE0OiJiYWNrZ3JvdW5kLmpwZyI7fQ==\";}',NULL,NULL,1547809763,1547809763,0,NULL),(11,'da39a3ee5e6b4b0d3255bfef95601890afd80709','cb8b8f24d749eacedbc3d2f24f2dcb009819b509',5,'user','draft',558629611,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548771968,1548771968,0,NULL),(12,'403ebc62497c996d56845652d465d96c5c2d61dd','dac5349202a9b83a50d38beac58b291f4905a98f',1,'core','preview',0,'/thumb/','41cfeee5884a43a4650a851f4f85e7b28316fcc9',NULL,8910,'image/png',0,NULL,NULL,NULL,1548771973,1548771973,0,NULL),(13,'da39a3ee5e6b4b0d3255bfef95601890afd80709','74c104d54c05b5f8c633a36da516d37e6c5279e4',1,'core','preview',0,'/thumb/','.',NULL,0,NULL,0,NULL,NULL,NULL,1548771973,1548771973,0,NULL),(14,'da39a3ee5e6b4b0d3255bfef95601890afd80709','884555719c50529b9df662a38619d04b5b11e25c',1,'core','preview',0,'/','.',NULL,0,NULL,0,NULL,NULL,NULL,1548771973,1548771973,0,NULL),(15,'41cfeee5884a43a4650a851f4f85e7b28316fcc9','6ae70ef84c1efbfa5f58e6873dd378615c68f175',5,'user','draft',249072748,'/','background.jpg',2,4451,'image/jpeg',0,'O:8:\"stdClass\":2:{s:6:\"source\";N;s:8:\"original\";s:236:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aToxO3M6OToiY29tcG9uZW50IjtzOjEwOiJ0aGVtZV9tb3JlIjtzOjY6Iml0ZW1pZCI7aTowO3M6ODoiZmlsZWFyZWEiO3M6MTU6ImJhY2tncm91bmRpbWFnZSI7czo4OiJmaWxlcGF0aCI7czoxOiIvIjtzOjg6ImZpbGVuYW1lIjtzOjE0OiJiYWNrZ3JvdW5kLmpwZyI7fQ==\";}',NULL,NULL,1547809763,1547809763,0,NULL),(16,'da39a3ee5e6b4b0d3255bfef95601890afd80709','365b4eb67dd5d763f2e27e34722d012e9a118314',5,'user','draft',249072748,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548771995,1548771995,0,NULL),(17,'41cfeee5884a43a4650a851f4f85e7b28316fcc9','6380d47cc34b112040113e2914f589311aa1fceb',5,'user','draft',654544132,'/','background.jpg',2,4451,'image/jpeg',0,'O:8:\"stdClass\":2:{s:6:\"source\";N;s:8:\"original\";s:236:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aToxO3M6OToiY29tcG9uZW50IjtzOjEwOiJ0aGVtZV9tb3JlIjtzOjY6Iml0ZW1pZCI7aTowO3M6ODoiZmlsZWFyZWEiO3M6MTU6ImJhY2tncm91bmRpbWFnZSI7czo4OiJmaWxlcGF0aCI7czoxOiIvIjtzOjg6ImZpbGVuYW1lIjtzOjE0OiJiYWNrZ3JvdW5kLmpwZyI7fQ==\";}',NULL,NULL,1547809763,1547809763,0,NULL),(18,'da39a3ee5e6b4b0d3255bfef95601890afd80709','950844076bd2432dd9826360f7d7f80f69e358bc',5,'user','draft',654544132,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548772033,1548772033,0,NULL),(19,'41cfeee5884a43a4650a851f4f85e7b28316fcc9','c7c6e5b67bd6cc75e74581ec16bdd8013f0f55c1',5,'user','draft',410069204,'/','background.jpg',2,4451,'image/jpeg',0,'O:8:\"stdClass\":2:{s:6:\"source\";N;s:8:\"original\";s:236:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aToxO3M6OToiY29tcG9uZW50IjtzOjEwOiJ0aGVtZV9tb3JlIjtzOjY6Iml0ZW1pZCI7aTowO3M6ODoiZmlsZWFyZWEiO3M6MTU6ImJhY2tncm91bmRpbWFnZSI7czo4OiJmaWxlcGF0aCI7czoxOiIvIjtzOjg6ImZpbGVuYW1lIjtzOjE0OiJiYWNrZ3JvdW5kLmpwZyI7fQ==\";}',NULL,NULL,1547809763,1547809763,0,NULL),(20,'da39a3ee5e6b4b0d3255bfef95601890afd80709','79127c22ca7492e797d578b4039d5f08547d6684',5,'user','draft',410069204,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548772163,1548772163,0,NULL),(21,'e712c7ff73512b28e7b24c61f6528321d35adaa0','0bca5323b31cca5e42d17380fcbc9b03ab3db318',5,'user','draft',72913428,'/','theme_adaptable_moodle36_2019011700.zip',2,1432131,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:39:\"theme_adaptable_moodle36_2019011700.zip\";}','Muhammad Ainul Yaqin','allrightsreserved',1548772607,1548772607,0,NULL),(22,'da39a3ee5e6b4b0d3255bfef95601890afd80709','a3ee3ea6574166d7d6c5ce2b822e6ad445b936ad',5,'user','draft',72913428,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548772607,1548772607,0,NULL),(23,'1103beaba9c044ab93c8c1fd68dc7734e0f8e468','822f79640fa8bb8f1538d82a159f795392bd4d81',5,'user','draft',669701811,'/','cover new.jpg',2,8200376,'image/jpeg',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:13:\"cover new.jpg\";}','Muhammad Ainul Yaqin','allrightsreserved',1548773488,1548773488,0,NULL),(24,'da39a3ee5e6b4b0d3255bfef95601890afd80709','6ad6cc576ca3a3f7930dd5d67f975bf3eb063c0d',5,'user','draft',669701811,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548773488,1548773488,0,NULL),(25,'9570873f50d54accfbdbc8c7f40af74f0095de6e','0097dec1ce207a9dfe7d95dbc1c9373d5cf342e5',1,'core','preview',0,'/thumb/','1103beaba9c044ab93c8c1fd68dc7734e0f8e468',NULL,9135,'image/png',0,NULL,NULL,NULL,1548773492,1548773492,0,NULL),(26,'b7b00247d9de14419e39d6c5b547a545d9ba7cf2','c4556b6b21285d871334431a7b5563d4f279aad5',5,'user','draft',476390552,'/','icons8-usb-connector-48.png',2,800,'image/png',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:27:\"icons8-usb-connector-48.png\";}','Muhammad Ainul Yaqin','allrightsreserved',1548773684,1548773684,0,NULL),(27,'da39a3ee5e6b4b0d3255bfef95601890afd80709','8a2db47e56a0c06e287f445f54094dfd1c4ebbb1',5,'user','draft',476390552,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548773684,1548773684,0,NULL),(28,'54531c96ffcc00a0744ae179b6ca0e7de9803724','d15b30c9423b37f7c52d29f80e1712677e19424a',1,'core','preview',0,'/thumb/','b7b00247d9de14419e39d6c5b547a545d9ba7cf2',NULL,1184,'image/png',0,NULL,NULL,NULL,1548773685,1548773685,0,NULL),(30,'da39a3ee5e6b4b0d3255bfef95601890afd80709','eac2fee73a069304d6598cd316d7acc9c89281c0',1,'theme_adaptable','headerbgimage',0,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548773488,1548780601,0,NULL),(31,'b7b00247d9de14419e39d6c5b547a545d9ba7cf2','cc44b962436fdc21ad1bc3f059dcd8d8149dfbfd',1,'theme_adaptable','favicon',0,'/','icons8-usb-connector-48.png',2,800,'image/png',0,'icons8-usb-connector-48.png','Muhammad Ainul Yaqin','allrightsreserved',1548773684,1548773697,0,NULL),(32,'da39a3ee5e6b4b0d3255bfef95601890afd80709','7803911e19941a23a70c504ac76f67cbcde61c75',1,'theme_adaptable','favicon',0,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548773684,1548780602,0,NULL),(34,'da39a3ee5e6b4b0d3255bfef95601890afd80709','445761b14f1d9f03e22d6e35c36734ce2b25b46c',5,'user','draft',661151177,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548773700,1548773700,0,NULL),(35,'b7b00247d9de14419e39d6c5b547a545d9ba7cf2','af3740fec525f74be3aacd8e700802ee94ff3963',5,'user','draft',169854971,'/','icons8-usb-connector-48.png',2,800,'image/png',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:27:\"icons8-usb-connector-48.png\";s:8:\"original\";s:248:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aToxO3M6OToiY29tcG9uZW50IjtzOjE1OiJ0aGVtZV9hZGFwdGFibGUiO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJmYXZpY29uIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6Mjc6Imljb25zOC11c2ItY29ubmVjdG9yLTQ4LnBuZyI7fQ==\";}','Muhammad Ainul Yaqin','allrightsreserved',1548773684,1548773697,0,NULL),(36,'da39a3ee5e6b4b0d3255bfef95601890afd80709','ba0c84de21dcd04f46fdd3d8ebfe836a0aefc673',5,'user','draft',169854971,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548773700,1548773700,0,NULL),(37,'14f7d742ea7e26d982d00e4daaac2fc7f7b64834','e4361da3b16f9c3eda9e0ebb16dafae92bbb71cf',5,'user','draft',804892649,'/','File.zip',2,7628497,'application/zip',0,NULL,NULL,NULL,1548773747,1548773747,0,NULL),(38,'da39a3ee5e6b4b0d3255bfef95601890afd80709','b56b3aa8e56c36eee6a53b5d69d0665d06166ca0',5,'user','draft',804892649,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548773748,1548773748,0,NULL),(39,'e456763e048e3552c9733948a6b3d323103b321b','1fd464b51cdf1a4924ce01dcb9908d797541da05',5,'user','draft',661151177,'/','DESIGN THINKING.jpg',2,927906,'image/jpeg',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:19:\"DESIGN THINKING.jpg\";}','Muhammad Ainul Yaqin','allrightsreserved',1548773797,1548773797,0,NULL),(40,'110395daca911cb80a8816a696f6b6900fe302c4','0d190c8a3a1c822b2d4fdba3f2a710c0c1b7af72',1,'core','preview',0,'/thumb/','e456763e048e3552c9733948a6b3d323103b321b',NULL,5566,'image/png',0,NULL,NULL,NULL,1548773798,1548773798,0,NULL),(42,'e456763e048e3552c9733948a6b3d323103b321b','0206f35fe32e556d396f21e2d30a71b2538f7f53',5,'user','draft',951730773,'/','DESIGN THINKING.jpg',2,927906,'image/jpeg',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:19:\"DESIGN THINKING.jpg\";s:8:\"original\";s:244:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aToxO3M6OToiY29tcG9uZW50IjtzOjE1OiJ0aGVtZV9hZGFwdGFibGUiO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czoxMzoiaGVhZGVyYmdpbWFnZSI7czo4OiJmaWxlcGF0aCI7czoxOiIvIjtzOjg6ImZpbGVuYW1lIjtzOjE5OiJERVNJR04gVEhJTktJTkcuanBnIjt9\";}','Muhammad Ainul Yaqin','allrightsreserved',1548773797,1548773808,0,NULL),(43,'da39a3ee5e6b4b0d3255bfef95601890afd80709','24bebde3466931857f41dc39bb280ab115ab24c2',5,'user','draft',951730773,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548773812,1548773812,0,NULL),(44,'b7b00247d9de14419e39d6c5b547a545d9ba7cf2','a7ebb3c42d1d3ae27eb2938df94ff896b4e682b0',5,'user','draft',24274938,'/','icons8-usb-connector-48.png',2,800,'image/png',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:27:\"icons8-usb-connector-48.png\";s:8:\"original\";s:248:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aToxO3M6OToiY29tcG9uZW50IjtzOjE1OiJ0aGVtZV9hZGFwdGFibGUiO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJmYXZpY29uIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6Mjc6Imljb25zOC11c2ItY29ubmVjdG9yLTQ4LnBuZyI7fQ==\";}','Muhammad Ainul Yaqin','allrightsreserved',1548773684,1548773697,0,NULL),(45,'da39a3ee5e6b4b0d3255bfef95601890afd80709','52910ca0a9c8317d24b21978372168182db0f3c4',5,'user','draft',24274938,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548773812,1548773812,0,NULL),(46,'e456763e048e3552c9733948a6b3d323103b321b','e7cc65e30298fcafd0c9edb1bba1e01768921040',5,'user','draft',97356688,'/','DESIGN THINKING.jpg',2,927906,'image/jpeg',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:19:\"DESIGN THINKING.jpg\";s:8:\"original\";s:244:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aToxO3M6OToiY29tcG9uZW50IjtzOjE1OiJ0aGVtZV9hZGFwdGFibGUiO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czoxMzoiaGVhZGVyYmdpbWFnZSI7czo4OiJmaWxlcGF0aCI7czoxOiIvIjtzOjg6ImZpbGVuYW1lIjtzOjE5OiJERVNJR04gVEhJTktJTkcuanBnIjt9\";}','Muhammad Ainul Yaqin','allrightsreserved',1548773797,1548773808,0,NULL),(47,'da39a3ee5e6b4b0d3255bfef95601890afd80709','e0355db54c88b42ce2907f34e36a4c0bc67a6ff5',5,'user','draft',97356688,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548773826,1548773826,0,NULL),(48,'b7b00247d9de14419e39d6c5b547a545d9ba7cf2','a7f538c85afe6014b52ed8ab24ed1d9a6af628bb',5,'user','draft',317515333,'/','icons8-usb-connector-48.png',2,800,'image/png',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:27:\"icons8-usb-connector-48.png\";s:8:\"original\";s:248:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aToxO3M6OToiY29tcG9uZW50IjtzOjE1OiJ0aGVtZV9hZGFwdGFibGUiO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJmYXZpY29uIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6Mjc6Imljb25zOC11c2ItY29ubmVjdG9yLTQ4LnBuZyI7fQ==\";}','Muhammad Ainul Yaqin','allrightsreserved',1548773684,1548773697,0,NULL),(49,'da39a3ee5e6b4b0d3255bfef95601890afd80709','d8fb19a04dc810f05e1c63321265ba872c7bd45f',5,'user','draft',317515333,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548773826,1548773826,0,NULL),(50,'e456763e048e3552c9733948a6b3d323103b321b','a530e55cddd07cf37d646efa4a91127a133e6e47',5,'user','draft',722160283,'/','DESIGN THINKING.jpg',2,927906,'image/jpeg',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:19:\"DESIGN THINKING.jpg\";s:8:\"original\";s:244:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aToxO3M6OToiY29tcG9uZW50IjtzOjE1OiJ0aGVtZV9hZGFwdGFibGUiO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czoxMzoiaGVhZGVyYmdpbWFnZSI7czo4OiJmaWxlcGF0aCI7czoxOiIvIjtzOjg6ImZpbGVuYW1lIjtzOjE5OiJERVNJR04gVEhJTktJTkcuanBnIjt9\";}','Muhammad Ainul Yaqin','allrightsreserved',1548773797,1548773808,0,NULL),(51,'da39a3ee5e6b4b0d3255bfef95601890afd80709','be0b11d9680c2532ccab868be245df5a81101108',5,'user','draft',722160283,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548780598,1548780598,0,NULL),(52,'b7b00247d9de14419e39d6c5b547a545d9ba7cf2','b3f650f5d3aadd60cc9c89dd3327c3969b95da87',5,'user','draft',289900654,'/','icons8-usb-connector-48.png',2,800,'image/png',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:27:\"icons8-usb-connector-48.png\";s:8:\"original\";s:248:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aToxO3M6OToiY29tcG9uZW50IjtzOjE1OiJ0aGVtZV9hZGFwdGFibGUiO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJmYXZpY29uIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6Mjc6Imljb25zOC11c2ItY29ubmVjdG9yLTQ4LnBuZyI7fQ==\";}','Muhammad Ainul Yaqin','allrightsreserved',1548773684,1548773697,0,NULL),(53,'da39a3ee5e6b4b0d3255bfef95601890afd80709','50aa2969344a4af5c3056a68e1e5e6e70f611bd2',5,'user','draft',289900654,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548780599,1548780599,0,NULL),(55,'da39a3ee5e6b4b0d3255bfef95601890afd80709','b5d6c6485551669019df7f62b8157c1a8ab34930',5,'user','draft',952388773,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548780601,1548780601,0,NULL),(56,'b7b00247d9de14419e39d6c5b547a545d9ba7cf2','911ae6494a73cd8aef9860c1dc58f268e9950899',5,'user','draft',121512731,'/','icons8-usb-connector-48.png',2,800,'image/png',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:27:\"icons8-usb-connector-48.png\";s:8:\"original\";s:248:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aToxO3M6OToiY29tcG9uZW50IjtzOjE1OiJ0aGVtZV9hZGFwdGFibGUiO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJmYXZpY29uIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6Mjc6Imljb25zOC11c2ItY29ubmVjdG9yLTQ4LnBuZyI7fQ==\";}','Muhammad Ainul Yaqin','allrightsreserved',1548773684,1548773697,0,NULL),(57,'da39a3ee5e6b4b0d3255bfef95601890afd80709','f5bc1310a2f86af4bcac529440a870a9680c9b10',5,'user','draft',121512731,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548780602,1548780602,0,NULL),(58,'b7b00247d9de14419e39d6c5b547a545d9ba7cf2','309f062d8fc62e374e037e7adea0827fa81fd6d5',5,'user','draft',704095038,'/','icons8-usb-connector-48.png',2,800,'image/png',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:27:\"icons8-usb-connector-48.png\";s:8:\"original\";s:248:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aToxO3M6OToiY29tcG9uZW50IjtzOjE1OiJ0aGVtZV9hZGFwdGFibGUiO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJmYXZpY29uIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6Mjc6Imljb25zOC11c2ItY29ubmVjdG9yLTQ4LnBuZyI7fQ==\";}','Muhammad Ainul Yaqin','allrightsreserved',1548773684,1548773697,0,NULL),(59,'da39a3ee5e6b4b0d3255bfef95601890afd80709','580318b00209b2d58ef3c2995ec6217bb48d937f',5,'user','draft',704095038,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548780623,1548780623,0,NULL),(60,'ce74ae9822c4da9e11e43735136a1d15a1ad912d','f91c880430d197118ff5d2329266bc77c355f391',5,'user','draft',37644341,'/','Foto5.jpg',2,8008394,'image/jpeg',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:9:\"Foto5.jpg\";}','Muhammad Ainul Yaqin','allrightsreserved',1548780807,1548780807,0,NULL),(61,'da39a3ee5e6b4b0d3255bfef95601890afd80709','0588e0f7aee10cf5e122a2480f22bf49a6ed1108',5,'user','draft',37644341,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548780808,1548780808,0,NULL),(62,'ce74ae9822c4da9e11e43735136a1d15a1ad912d','bb4c0790775d0bc40b0e8de536ed973ad87e6ce9',28,'assignsubmission_file','submission_files',1,'/','Foto5.jpg',2,8008394,'image/jpeg',0,'Foto5.jpg','Muhammad Ainul Yaqin','allrightsreserved',1548780807,1548780809,0,NULL),(63,'da39a3ee5e6b4b0d3255bfef95601890afd80709','6f0a1ae121b0c2c035807d41d9de903397a12546',28,'assignsubmission_file','submission_files',1,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548780808,1548780809,0,NULL),(64,'4a4a70ca76bde953ed69c0d46d89b3f850005e9a','4efe5ecb7803b878e9017651f1fc2a292523f38a',1,'core','preview',0,'/thumb/','ce74ae9822c4da9e11e43735136a1d15a1ad912d',NULL,9090,'image/png',0,NULL,NULL,NULL,1548780811,1548780811,0,NULL),(65,'8c96a486d5801e0f4ab8c411f561f1c687e1f865','d4f0d57f97fd398ecd9cb5bc9b4e61d6937f3b1d',28,'assignfeedback_editpdf','stamps',1,'/','cross.png',2,861,'image/png',0,NULL,NULL,NULL,1547809768,1547809768,0,NULL),(66,'da39a3ee5e6b4b0d3255bfef95601890afd80709','72bceb6757d33d75b372157a9f1c95591cfb3348',28,'assignfeedback_editpdf','stamps',1,'/','.',2,0,NULL,0,NULL,NULL,NULL,1548780969,1548780969,0,NULL),(67,'75c101cb8cb34ea573cd25ac38f8157b1de901b8','6afdb533879a9ed7436f5514a7a067f5c2a6f161',28,'assignfeedback_editpdf','stamps',1,'/','sad.png',2,966,'image/png',0,NULL,NULL,NULL,1547809768,1547809768,0,NULL),(68,'5f8e911d0da441e36f47c5c46f4393269211ca56','f5e9f360fc3a678634a2992b4ab1362f3ae5f060',28,'assignfeedback_editpdf','stamps',1,'/','smile.png',2,1085,'image/png',0,NULL,NULL,NULL,1547809768,1547809768,0,NULL),(69,'0c5190a24c3943966541401c883eacaa20ca20cb','666938324a84c958f16f3204caef24a62a7d8349',28,'assignfeedback_editpdf','stamps',1,'/','tick.png',2,1039,'image/png',0,NULL,NULL,NULL,1547809768,1547809768,0,NULL),(82,'4c803c92c71f21b423d13de570c8a09e0a31c718','527868e03f2531dfcfc048bd39c4be3fa8e9b304',28,'assignfeedback_editpdf','combined',1,'/','combined.pdf',NULL,1114,'application/pdf',0,NULL,NULL,NULL,1548780993,1548780993,0,NULL),(83,'da39a3ee5e6b4b0d3255bfef95601890afd80709','30e38e88c2b93b3878319610e5cc7b658f9decce',28,'assignfeedback_editpdf','combined',1,'/','.',NULL,0,NULL,0,NULL,NULL,NULL,1548780993,1548780993,0,NULL),(84,'79fedf529853d6121d87ce6b159b02405ce0740d','9f553b7285efbeec82bb47e0ecc77ecaf1fc12cc',28,'assignfeedback_editpdf','pages',1,'/','image_page0.png',NULL,7921,'image/png',0,NULL,NULL,NULL,1548780993,1548780993,0,NULL),(85,'da39a3ee5e6b4b0d3255bfef95601890afd80709','3e6846b92a5dedcaba76663c6fa91c67ab6ce77b',28,'assignfeedback_editpdf','pages',1,'/','.',NULL,0,NULL,0,NULL,NULL,NULL,1548780993,1548780993,0,NULL),(86,'486c513f206a7b733ff8ef2d3a6445ec572d566f','1d98ecf933365259f95e7668485953dc399a84b3',5,'user','draft',247767221,'/','contohsoal.txt',2,3466,'text/plain',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:14:\"contohsoal.txt\";}','Muhammad Ainul Yaqin','allrightsreserved',1551207193,1551207193,0,NULL),(87,'da39a3ee5e6b4b0d3255bfef95601890afd80709','ec9499b8ce7f3b3e1f14e6046489a493472cbcdf',5,'user','draft',247767221,'/','.',2,0,NULL,0,NULL,NULL,NULL,1551207193,1551207193,0,NULL),(88,'cd5fd2238bfea2ca301859e63697645f2a744d62','915fbc9ff8b6312a97b670fbc6d1b60f0c874037',5,'user','draft',308780616,'/','Employer-Assessment-Test.png',2,328293,'image/png',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:28:\"Employer-Assessment-Test.png\";}','Muhammad Ainul Yaqin','allrightsreserved',1551208289,1551208289,0,NULL),(89,'da39a3ee5e6b4b0d3255bfef95601890afd80709','295bdae2787b9c18aec2e6bb075f86f27b3997ad',5,'user','draft',308780616,'/','.',2,0,NULL,0,NULL,NULL,NULL,1551208289,1551208289,0,NULL),(90,'f9a7bbfb944d6392079090955010d651ae57c8f6','cdaa99934c4994d017cead2e650109c1e452953a',1,'core','preview',0,'/thumb/','cd5fd2238bfea2ca301859e63697645f2a744d62',NULL,5608,'image/png',0,NULL,NULL,NULL,1551208290,1551208290,0,NULL),(91,'cd5fd2238bfea2ca301859e63697645f2a744d62','a548133d4339bd4c19c94da40b215cd319611632',26,'course','overviewfiles',0,'/','Employer-Assessment-Test.png',2,328293,'image/png',0,'Employer-Assessment-Test.png','Muhammad Ainul Yaqin','allrightsreserved',1551208289,1551208292,0,NULL),(92,'da39a3ee5e6b4b0d3255bfef95601890afd80709','7e99050b4f914c90b53eecefb159f28b6347a6f4',26,'course','overviewfiles',0,'/','.',2,0,NULL,0,NULL,NULL,NULL,1551208289,1551208292,0,NULL),(93,'89d42c99f56532607030c53b733fe9b76dc4a50c','0f6712fb40b4d56b602be162088241b86884c560',5,'user','draft',786648591,'/','availability_paypal_moodle36_2018121902.zip',2,36201,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:43:\"availability_paypal_moodle36_2018121902.zip\";}','Muhammad Ainul Yaqin','allrightsreserved',1551237246,1551237246,0,NULL),(94,'da39a3ee5e6b4b0d3255bfef95601890afd80709','c253ef05c9c71f9680f4f01673e108884385cf72',5,'user','draft',786648591,'/','.',2,0,NULL,0,NULL,NULL,NULL,1551237246,1551237246,0,NULL),(95,'b7b00247d9de14419e39d6c5b547a545d9ba7cf2','6e98106dc4dbb4e9d6eed82a96675b4b4c367869',5,'user','draft',706246892,'/','icons8-usb-connector-48.png',2,800,'image/png',0,'O:8:\"stdClass\":2:{s:6:\"source\";s:27:\"icons8-usb-connector-48.png\";s:8:\"original\";s:248:\"YTo2OntzOjk6ImNvbnRleHRpZCI7aToxO3M6OToiY29tcG9uZW50IjtzOjE1OiJ0aGVtZV9hZGFwdGFibGUiO3M6NjoiaXRlbWlkIjtpOjA7czo4OiJmaWxlYXJlYSI7czo3OiJmYXZpY29uIjtzOjg6ImZpbGVwYXRoIjtzOjE6Ii8iO3M6ODoiZmlsZW5hbWUiO3M6Mjc6Imljb25zOC11c2ItY29ubmVjdG9yLTQ4LnBuZyI7fQ==\";}','Muhammad Ainul Yaqin','allrightsreserved',1548773684,1548773697,0,NULL),(96,'da39a3ee5e6b4b0d3255bfef95601890afd80709','aac279bae9875a40ff1a01cdf1c09677b490bf2a',5,'user','draft',706246892,'/','.',2,0,NULL,0,NULL,NULL,NULL,1551238600,1551238600,0,NULL);
/*!40000 ALTER TABLE `mdl_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_files_reference`
--

DROP TABLE IF EXISTS `mdl_files_reference`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_files_reference` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `repositoryid` bigint(10) NOT NULL,
  `lastsync` bigint(10) DEFAULT NULL,
  `reference` longtext COLLATE utf8mb4_unicode_ci,
  `referencehash` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_filerefe_refrep_uix` (`referencehash`,`repositoryid`),
  KEY `mdl_filerefe_rep_ix` (`repositoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Store files references';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_files_reference`
--

LOCK TABLES `mdl_files_reference` WRITE;
/*!40000 ALTER TABLE `mdl_files_reference` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_files_reference` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_filter_active`
--

DROP TABLE IF EXISTS `mdl_filter_active`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_filter_active` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `active` smallint(4) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_filtacti_confil_uix` (`contextid`,`filter`),
  KEY `mdl_filtacti_con_ix` (`contextid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores information about which filters are active in which c';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_filter_active`
--

LOCK TABLES `mdl_filter_active` WRITE;
/*!40000 ALTER TABLE `mdl_filter_active` DISABLE KEYS */;
INSERT INTO `mdl_filter_active` VALUES (1,'activitynames',1,1,2),(2,'mathjaxloader',1,1,1),(3,'mediaplugin',1,1,3);
/*!40000 ALTER TABLE `mdl_filter_active` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_filter_config`
--

DROP TABLE IF EXISTS `mdl_filter_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_filter_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_filtconf_confilnam_uix` (`contextid`,`filter`,`name`),
  KEY `mdl_filtconf_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores per-context configuration settings for filters which ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_filter_config`
--

LOCK TABLES `mdl_filter_config` WRITE;
/*!40000 ALTER TABLE `mdl_filter_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_filter_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_folder`
--

DROP TABLE IF EXISTS `mdl_folder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_folder` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `display` smallint(4) NOT NULL DEFAULT '0',
  `showexpanded` tinyint(1) NOT NULL DEFAULT '1',
  `showdownloadfolder` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdl_fold_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='each record is one folder resource';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_folder`
--

LOCK TABLES `mdl_folder` WRITE;
/*!40000 ALTER TABLE `mdl_folder` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_folder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum`
--

DROP TABLE IF EXISTS `mdl_forum`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'general',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `assessed` bigint(10) NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) NOT NULL DEFAULT '0',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '0',
  `maxattachments` bigint(10) NOT NULL DEFAULT '1',
  `forcesubscribe` tinyint(1) NOT NULL DEFAULT '0',
  `trackingtype` tinyint(2) NOT NULL DEFAULT '1',
  `rsstype` tinyint(2) NOT NULL DEFAULT '0',
  `rssarticles` tinyint(2) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `warnafter` bigint(10) NOT NULL DEFAULT '0',
  `blockafter` bigint(10) NOT NULL DEFAULT '0',
  `blockperiod` bigint(10) NOT NULL DEFAULT '0',
  `completiondiscussions` int(9) NOT NULL DEFAULT '0',
  `completionreplies` int(9) NOT NULL DEFAULT '0',
  `completionposts` int(9) NOT NULL DEFAULT '0',
  `displaywordcount` tinyint(1) NOT NULL DEFAULT '0',
  `lockdiscussionafter` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_foru_cou_ix` (`course`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Forums contain and structure discussion';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum`
--

LOCK TABLES `mdl_forum` WRITE;
/*!40000 ALTER TABLE `mdl_forum` DISABLE KEYS */;
INSERT INTO `mdl_forum` VALUES (1,2,'news','Announcements','General news and announcements',1,0,0,0,0,0,1,1,1,0,0,1548760376,0,0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `mdl_forum` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_digests`
--

DROP TABLE IF EXISTS `mdl_forum_digests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_digests` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `forum` bigint(10) NOT NULL,
  `maildigest` tinyint(1) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_forudige_forusemai_uix` (`forum`,`userid`,`maildigest`),
  KEY `mdl_forudige_use_ix` (`userid`),
  KEY `mdl_forudige_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Keeps track of user mail delivery preferences for each forum';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_digests`
--

LOCK TABLES `mdl_forum_digests` WRITE;
/*!40000 ALTER TABLE `mdl_forum_digests` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_digests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_discussion_subs`
--

DROP TABLE IF EXISTS `mdl_forum_discussion_subs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_discussion_subs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `forum` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `discussion` bigint(10) NOT NULL,
  `preference` bigint(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_forudiscsubs_usedis_uix` (`userid`,`discussion`),
  KEY `mdl_forudiscsubs_for_ix` (`forum`),
  KEY `mdl_forudiscsubs_use_ix` (`userid`),
  KEY `mdl_forudiscsubs_dis_ix` (`discussion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Users may choose to subscribe and unsubscribe from specific ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_discussion_subs`
--

LOCK TABLES `mdl_forum_discussion_subs` WRITE;
/*!40000 ALTER TABLE `mdl_forum_discussion_subs` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_discussion_subs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_discussions`
--

DROP TABLE IF EXISTS `mdl_forum_discussions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_discussions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `forum` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `firstpost` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '-1',
  `assessed` tinyint(1) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) NOT NULL DEFAULT '0',
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_forudisc_use_ix` (`userid`),
  KEY `mdl_forudisc_cou_ix` (`course`),
  KEY `mdl_forudisc_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Forums are composed of discussions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_discussions`
--

LOCK TABLES `mdl_forum_discussions` WRITE;
/*!40000 ALTER TABLE `mdl_forum_discussions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_discussions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_posts`
--

DROP TABLE IF EXISTS `mdl_forum_posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_posts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `discussion` bigint(10) NOT NULL DEFAULT '0',
  `parent` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `created` bigint(10) NOT NULL DEFAULT '0',
  `modified` bigint(10) NOT NULL DEFAULT '0',
  `mailed` tinyint(2) NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `messageformat` tinyint(2) NOT NULL DEFAULT '0',
  `messagetrust` tinyint(2) NOT NULL DEFAULT '0',
  `attachment` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `totalscore` smallint(4) NOT NULL DEFAULT '0',
  `mailnow` bigint(10) NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_forupost_use_ix` (`userid`),
  KEY `mdl_forupost_cre_ix` (`created`),
  KEY `mdl_forupost_mai_ix` (`mailed`),
  KEY `mdl_forupost_dis_ix` (`discussion`),
  KEY `mdl_forupost_par_ix` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='All posts are stored in this table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_posts`
--

LOCK TABLES `mdl_forum_posts` WRITE;
/*!40000 ALTER TABLE `mdl_forum_posts` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_queue`
--

DROP TABLE IF EXISTS `mdl_forum_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `discussionid` bigint(10) NOT NULL DEFAULT '0',
  `postid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_foruqueu_use_ix` (`userid`),
  KEY `mdl_foruqueu_dis_ix` (`discussionid`),
  KEY `mdl_foruqueu_pos_ix` (`postid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='For keeping track of posts that will be mailed in digest for';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_queue`
--

LOCK TABLES `mdl_forum_queue` WRITE;
/*!40000 ALTER TABLE `mdl_forum_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_read`
--

DROP TABLE IF EXISTS `mdl_forum_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_read` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `forumid` bigint(10) NOT NULL DEFAULT '0',
  `discussionid` bigint(10) NOT NULL DEFAULT '0',
  `postid` bigint(10) NOT NULL DEFAULT '0',
  `firstread` bigint(10) NOT NULL DEFAULT '0',
  `lastread` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_foruread_usefor_ix` (`userid`,`forumid`),
  KEY `mdl_foruread_usedis_ix` (`userid`,`discussionid`),
  KEY `mdl_foruread_posuse_ix` (`postid`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Tracks each users read posts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_read`
--

LOCK TABLES `mdl_forum_read` WRITE;
/*!40000 ALTER TABLE `mdl_forum_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_subscriptions`
--

DROP TABLE IF EXISTS `mdl_forum_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_subscriptions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `forum` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_forusubs_usefor_uix` (`userid`,`forum`),
  KEY `mdl_forusubs_use_ix` (`userid`),
  KEY `mdl_forusubs_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Keeps track of who is subscribed to what forum';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_subscriptions`
--

LOCK TABLES `mdl_forum_subscriptions` WRITE;
/*!40000 ALTER TABLE `mdl_forum_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_track_prefs`
--

DROP TABLE IF EXISTS `mdl_forum_track_prefs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_track_prefs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `forumid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_forutracpref_usefor_ix` (`userid`,`forumid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Tracks each users untracked forums';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_track_prefs`
--

LOCK TABLES `mdl_forum_track_prefs` WRITE;
/*!40000 ALTER TABLE `mdl_forum_track_prefs` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_track_prefs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_glossary`
--

DROP TABLE IF EXISTS `mdl_glossary`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_glossary` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `allowduplicatedentries` tinyint(2) NOT NULL DEFAULT '0',
  `displayformat` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'dictionary',
  `mainglossary` tinyint(2) NOT NULL DEFAULT '0',
  `showspecial` tinyint(2) NOT NULL DEFAULT '1',
  `showalphabet` tinyint(2) NOT NULL DEFAULT '1',
  `showall` tinyint(2) NOT NULL DEFAULT '1',
  `allowcomments` tinyint(2) NOT NULL DEFAULT '0',
  `allowprintview` tinyint(2) NOT NULL DEFAULT '1',
  `usedynalink` tinyint(2) NOT NULL DEFAULT '1',
  `defaultapproval` tinyint(2) NOT NULL DEFAULT '1',
  `approvaldisplayformat` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `globalglossary` tinyint(2) NOT NULL DEFAULT '0',
  `entbypage` smallint(3) NOT NULL DEFAULT '10',
  `editalways` tinyint(2) NOT NULL DEFAULT '0',
  `rsstype` tinyint(2) NOT NULL DEFAULT '0',
  `rssarticles` tinyint(2) NOT NULL DEFAULT '0',
  `assessed` bigint(10) NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) NOT NULL DEFAULT '0',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionentries` int(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_glos_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='all glossaries';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_glossary`
--

LOCK TABLES `mdl_glossary` WRITE;
/*!40000 ALTER TABLE `mdl_glossary` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_glossary` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_glossary_alias`
--

DROP TABLE IF EXISTS `mdl_glossary_alias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_glossary_alias` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `entryid` bigint(10) NOT NULL DEFAULT '0',
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_glosalia_ent_ix` (`entryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='entries alias';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_glossary_alias`
--

LOCK TABLES `mdl_glossary_alias` WRITE;
/*!40000 ALTER TABLE `mdl_glossary_alias` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_glossary_alias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_glossary_categories`
--

DROP TABLE IF EXISTS `mdl_glossary_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_glossary_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `glossaryid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `usedynalink` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdl_gloscate_glo_ix` (`glossaryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='all categories for glossary entries';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_glossary_categories`
--

LOCK TABLES `mdl_glossary_categories` WRITE;
/*!40000 ALTER TABLE `mdl_glossary_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_glossary_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_glossary_entries`
--

DROP TABLE IF EXISTS `mdl_glossary_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_glossary_entries` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `glossaryid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `concept` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `definition` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `definitionformat` tinyint(2) NOT NULL DEFAULT '0',
  `definitiontrust` tinyint(2) NOT NULL DEFAULT '0',
  `attachment` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `teacherentry` tinyint(2) NOT NULL DEFAULT '0',
  `sourceglossaryid` bigint(10) NOT NULL DEFAULT '0',
  `usedynalink` tinyint(2) NOT NULL DEFAULT '1',
  `casesensitive` tinyint(2) NOT NULL DEFAULT '0',
  `fullmatch` tinyint(2) NOT NULL DEFAULT '1',
  `approved` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdl_glosentr_use_ix` (`userid`),
  KEY `mdl_glosentr_con_ix` (`concept`),
  KEY `mdl_glosentr_glo_ix` (`glossaryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='all glossary entries';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_glossary_entries`
--

LOCK TABLES `mdl_glossary_entries` WRITE;
/*!40000 ALTER TABLE `mdl_glossary_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_glossary_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_glossary_entries_categories`
--

DROP TABLE IF EXISTS `mdl_glossary_entries_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_glossary_entries_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `categoryid` bigint(10) NOT NULL DEFAULT '0',
  `entryid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_glosentrcate_cat_ix` (`categoryid`),
  KEY `mdl_glosentrcate_ent_ix` (`entryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='categories of each glossary entry';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_glossary_entries_categories`
--

LOCK TABLES `mdl_glossary_entries_categories` WRITE;
/*!40000 ALTER TABLE `mdl_glossary_entries_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_glossary_entries_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_glossary_formats`
--

DROP TABLE IF EXISTS `mdl_glossary_formats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_glossary_formats` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `popupformatname` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `visible` tinyint(2) NOT NULL DEFAULT '1',
  `showgroup` tinyint(2) NOT NULL DEFAULT '1',
  `showtabs` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `defaultmode` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `defaulthook` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortkey` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortorder` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Setting of the display formats';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_glossary_formats`
--

LOCK TABLES `mdl_glossary_formats` WRITE;
/*!40000 ALTER TABLE `mdl_glossary_formats` DISABLE KEYS */;
INSERT INTO `mdl_glossary_formats` VALUES (1,'continuous','continuous',1,1,'standard,category,date','','','',''),(2,'dictionary','dictionary',1,1,'standard','','','',''),(3,'encyclopedia','encyclopedia',1,1,'standard,category,date,author','','','',''),(4,'entrylist','entrylist',1,1,'standard,category,date,author','','','',''),(5,'faq','faq',1,1,'standard,category,date,author','','','',''),(6,'fullwithauthor','fullwithauthor',1,1,'standard,category,date,author','','','',''),(7,'fullwithoutauthor','fullwithoutauthor',1,1,'standard,category,date','','','','');
/*!40000 ALTER TABLE `mdl_glossary_formats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_categories`
--

DROP TABLE IF EXISTS `mdl_grade_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `parent` bigint(10) DEFAULT NULL,
  `depth` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fullname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `aggregation` bigint(10) NOT NULL DEFAULT '0',
  `keephigh` bigint(10) NOT NULL DEFAULT '0',
  `droplow` bigint(10) NOT NULL DEFAULT '0',
  `aggregateonlygraded` tinyint(1) NOT NULL DEFAULT '0',
  `aggregateoutcomes` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_gradcate_cou_ix` (`courseid`),
  KEY `mdl_gradcate_par_ix` (`parent`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table keeps information about categories, used for grou';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_categories`
--

LOCK TABLES `mdl_grade_categories` WRITE;
/*!40000 ALTER TABLE `mdl_grade_categories` DISABLE KEYS */;
INSERT INTO `mdl_grade_categories` VALUES (1,2,NULL,1,'/1/','?',13,0,0,1,0,1548769863,1548769863,0);
/*!40000 ALTER TABLE `mdl_grade_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_categories_history`
--

DROP TABLE IF EXISTS `mdl_grade_categories_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_categories_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) NOT NULL,
  `parent` bigint(10) DEFAULT NULL,
  `depth` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fullname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `aggregation` bigint(10) NOT NULL DEFAULT '0',
  `keephigh` bigint(10) NOT NULL DEFAULT '0',
  `droplow` bigint(10) NOT NULL DEFAULT '0',
  `aggregateonlygraded` tinyint(1) NOT NULL DEFAULT '0',
  `aggregateoutcomes` tinyint(1) NOT NULL DEFAULT '0',
  `aggregatesubcats` tinyint(1) NOT NULL DEFAULT '0',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_gradcatehist_act_ix` (`action`),
  KEY `mdl_gradcatehist_tim_ix` (`timemodified`),
  KEY `mdl_gradcatehist_old_ix` (`oldid`),
  KEY `mdl_gradcatehist_cou_ix` (`courseid`),
  KEY `mdl_gradcatehist_par_ix` (`parent`),
  KEY `mdl_gradcatehist_log_ix` (`loggeduser`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='History of grade_categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_categories_history`
--

LOCK TABLES `mdl_grade_categories_history` WRITE;
/*!40000 ALTER TABLE `mdl_grade_categories_history` DISABLE KEYS */;
INSERT INTO `mdl_grade_categories_history` VALUES (1,1,1,'system',1548769863,2,2,NULL,0,NULL,'?',13,0,0,1,0,0,0),(2,2,1,'system',1548769863,2,2,NULL,1,'/1/','?',13,0,0,1,0,0,0);
/*!40000 ALTER TABLE `mdl_grade_categories_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_grades`
--

DROP TABLE IF EXISTS `mdl_grade_grades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `itemid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `rawgrademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `rawgrademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `rawscaleid` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `exported` bigint(10) NOT NULL DEFAULT '0',
  `overridden` bigint(10) NOT NULL DEFAULT '0',
  `excluded` bigint(10) NOT NULL DEFAULT '0',
  `feedback` longtext COLLATE utf8mb4_unicode_ci,
  `feedbackformat` bigint(10) NOT NULL DEFAULT '0',
  `information` longtext COLLATE utf8mb4_unicode_ci,
  `informationformat` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `aggregationstatus` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unknown',
  `aggregationweight` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradgrad_useite_uix` (`userid`,`itemid`),
  KEY `mdl_gradgrad_locloc_ix` (`locked`,`locktime`),
  KEY `mdl_gradgrad_ite_ix` (`itemid`),
  KEY `mdl_gradgrad_use_ix` (`userid`),
  KEY `mdl_gradgrad_raw_ix` (`rawscaleid`),
  KEY `mdl_gradgrad_use2_ix` (`usermodified`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='grade_grades  This table keeps individual grades for each us';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_grades`
--

LOCK TABLES `mdl_grade_grades` WRITE;
/*!40000 ALTER TABLE `mdl_grade_grades` DISABLE KEYS */;
INSERT INTO `mdl_grade_grades` VALUES (1,2,2,80.00000,100.00000,0.00000,NULL,2,80.00000,0,0,0,0,0,0,NULL,0,NULL,0,NULL,1548780991,'used',1.00000),(2,1,2,NULL,100.00000,0.00000,NULL,NULL,80.00000,0,0,0,0,0,0,NULL,0,NULL,0,NULL,1548780984,'unknown',NULL),(3,3,2,NULL,10.00000,0.00000,NULL,NULL,NULL,0,0,0,0,0,0,NULL,0,NULL,0,NULL,NULL,'novalue',0.00000);
/*!40000 ALTER TABLE `mdl_grade_grades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_grades_history`
--

DROP TABLE IF EXISTS `mdl_grade_grades_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_grades_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `itemid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `rawgrademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `rawgrademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `rawscaleid` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `exported` bigint(10) NOT NULL DEFAULT '0',
  `overridden` bigint(10) NOT NULL DEFAULT '0',
  `excluded` bigint(10) NOT NULL DEFAULT '0',
  `feedback` longtext COLLATE utf8mb4_unicode_ci,
  `feedbackformat` bigint(10) NOT NULL DEFAULT '0',
  `information` longtext COLLATE utf8mb4_unicode_ci,
  `informationformat` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_gradgradhist_act_ix` (`action`),
  KEY `mdl_gradgradhist_tim_ix` (`timemodified`),
  KEY `mdl_gradgradhist_useitetim_ix` (`userid`,`itemid`,`timemodified`),
  KEY `mdl_gradgradhist_old_ix` (`oldid`),
  KEY `mdl_gradgradhist_ite_ix` (`itemid`),
  KEY `mdl_gradgradhist_use_ix` (`userid`),
  KEY `mdl_gradgradhist_raw_ix` (`rawscaleid`),
  KEY `mdl_gradgradhist_use2_ix` (`usermodified`),
  KEY `mdl_gradgradhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='History table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_grades_history`
--

LOCK TABLES `mdl_grade_grades_history` WRITE;
/*!40000 ALTER TABLE `mdl_grade_grades_history` DISABLE KEYS */;
INSERT INTO `mdl_grade_grades_history` VALUES (1,1,1,'mod/assign',1548780810,2,2,2,NULL,100.00000,0.00000,NULL,2,NULL,0,0,0,0,0,0,NULL,0,NULL,0),(2,1,2,'system',1548780810,2,1,2,NULL,100.00000,0.00000,NULL,NULL,NULL,0,0,0,0,0,0,NULL,0,NULL,0),(3,2,1,'mod/assign',1548780984,2,2,2,80.00000,100.00000,0.00000,NULL,2,80.00000,0,0,0,0,0,0,NULL,0,NULL,0),(4,2,2,'aggregation',1548780984,2,1,2,NULL,100.00000,0.00000,NULL,NULL,80.00000,0,0,0,0,0,0,NULL,0,NULL,0),(5,2,1,'mod/assign',1548780991,2,2,2,80.00000,100.00000,0.00000,NULL,2,80.00000,0,0,0,0,0,0,NULL,0,NULL,0),(6,1,3,'system',1551206452,2,3,2,NULL,10.00000,0.00000,NULL,NULL,NULL,0,0,0,0,0,0,NULL,0,NULL,0);
/*!40000 ALTER TABLE `mdl_grade_grades_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_import_newitem`
--

DROP TABLE IF EXISTS `mdl_grade_import_newitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_import_newitem` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `itemname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `importcode` bigint(10) NOT NULL,
  `importer` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_gradimponewi_imp_ix` (`importer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='temporary table for storing new grade_item names from grade ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_import_newitem`
--

LOCK TABLES `mdl_grade_import_newitem` WRITE;
/*!40000 ALTER TABLE `mdl_grade_import_newitem` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grade_import_newitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_import_values`
--

DROP TABLE IF EXISTS `mdl_grade_import_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_import_values` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `itemid` bigint(10) DEFAULT NULL,
  `newgradeitem` bigint(10) DEFAULT NULL,
  `userid` bigint(10) NOT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `feedback` longtext COLLATE utf8mb4_unicode_ci,
  `importcode` bigint(10) NOT NULL,
  `importer` bigint(10) DEFAULT NULL,
  `importonlyfeedback` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_gradimpovalu_ite_ix` (`itemid`),
  KEY `mdl_gradimpovalu_new_ix` (`newgradeitem`),
  KEY `mdl_gradimpovalu_imp_ix` (`importer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Temporary table for importing grades';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_import_values`
--

LOCK TABLES `mdl_grade_import_values` WRITE;
/*!40000 ALTER TABLE `mdl_grade_import_values` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grade_import_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_items`
--

DROP TABLE IF EXISTS `mdl_grade_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_items` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  `itemname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `itemtype` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemmodule` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iteminstance` bigint(10) DEFAULT NULL,
  `itemnumber` bigint(10) DEFAULT NULL,
  `iteminfo` longtext COLLATE utf8mb4_unicode_ci,
  `idnumber` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `calculation` longtext COLLATE utf8mb4_unicode_ci,
  `gradetype` smallint(4) NOT NULL DEFAULT '1',
  `grademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `grademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `scaleid` bigint(10) DEFAULT NULL,
  `outcomeid` bigint(10) DEFAULT NULL,
  `gradepass` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `multfactor` decimal(10,5) NOT NULL DEFAULT '1.00000',
  `plusfactor` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef2` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `display` bigint(10) NOT NULL DEFAULT '0',
  `decimals` tinyint(1) DEFAULT NULL,
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `needsupdate` bigint(10) NOT NULL DEFAULT '0',
  `weightoverride` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_graditem_locloc_ix` (`locked`,`locktime`),
  KEY `mdl_graditem_itenee_ix` (`itemtype`,`needsupdate`),
  KEY `mdl_graditem_gra_ix` (`gradetype`),
  KEY `mdl_graditem_idncou_ix` (`idnumber`,`courseid`),
  KEY `mdl_graditem_cou_ix` (`courseid`),
  KEY `mdl_graditem_cat_ix` (`categoryid`),
  KEY `mdl_graditem_sca_ix` (`scaleid`),
  KEY `mdl_graditem_out_ix` (`outcomeid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table keeps information about gradeable items (ie colum';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_items`
--

LOCK TABLES `mdl_grade_items` WRITE;
/*!40000 ALTER TABLE `mdl_grade_items` DISABLE KEYS */;
INSERT INTO `mdl_grade_items` VALUES (1,2,NULL,NULL,'course',NULL,1,NULL,NULL,NULL,NULL,1,110.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,NULL,0,0,0,0,0,1548769863,1551206451),(2,2,1,'Absensi','mod','assign',1,0,NULL,'',NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.90909,2,0,NULL,0,0,0,0,0,1548770537,1551206450),(3,2,1,'Verbal Reasoning Test','mod','quiz',1,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.09091,3,0,NULL,0,0,0,0,0,1551206449,1551207341);
/*!40000 ALTER TABLE `mdl_grade_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_items_history`
--

DROP TABLE IF EXISTS `mdl_grade_items_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_items_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  `itemname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `itemtype` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemmodule` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iteminstance` bigint(10) DEFAULT NULL,
  `itemnumber` bigint(10) DEFAULT NULL,
  `iteminfo` longtext COLLATE utf8mb4_unicode_ci,
  `idnumber` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `calculation` longtext COLLATE utf8mb4_unicode_ci,
  `gradetype` smallint(4) NOT NULL DEFAULT '1',
  `grademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `grademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `scaleid` bigint(10) DEFAULT NULL,
  `outcomeid` bigint(10) DEFAULT NULL,
  `gradepass` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `multfactor` decimal(10,5) NOT NULL DEFAULT '1.00000',
  `plusfactor` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef2` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `needsupdate` bigint(10) NOT NULL DEFAULT '0',
  `display` bigint(10) NOT NULL DEFAULT '0',
  `decimals` tinyint(1) DEFAULT NULL,
  `weightoverride` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_graditemhist_act_ix` (`action`),
  KEY `mdl_graditemhist_tim_ix` (`timemodified`),
  KEY `mdl_graditemhist_old_ix` (`oldid`),
  KEY `mdl_graditemhist_cou_ix` (`courseid`),
  KEY `mdl_graditemhist_cat_ix` (`categoryid`),
  KEY `mdl_graditemhist_sca_ix` (`scaleid`),
  KEY `mdl_graditemhist_out_ix` (`outcomeid`),
  KEY `mdl_graditemhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='History of grade_items';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_items_history`
--

LOCK TABLES `mdl_grade_items_history` WRITE;
/*!40000 ALTER TABLE `mdl_grade_items_history` DISABLE KEYS */;
INSERT INTO `mdl_grade_items_history` VALUES (1,1,1,'system',1548769863,2,2,NULL,NULL,'course',NULL,1,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(2,2,1,'aggregation',1548769864,2,2,NULL,NULL,'course',NULL,1,NULL,NULL,NULL,NULL,1,0.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(3,1,2,NULL,1548770537,2,2,1,'Absensi','mod','assign',1,0,NULL,'2',NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,2,0,0,0,1,0,NULL,0),(4,2,2,NULL,1548770537,2,2,1,'Absensi','mod','assign',1,0,NULL,'',NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,2,0,0,0,1,0,NULL,0),(5,2,2,NULL,1548770537,2,2,1,'Absensi','mod','assign',1,0,NULL,'',NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,1.00000,2,0,0,0,1,0,NULL,0),(6,2,1,'aggregation',1548770537,2,2,NULL,NULL,'course',NULL,1,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(7,1,3,NULL,1551206449,2,2,1,'Test Penalaran Verbal','mod','quiz',1,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,3,0,0,0,1,0,NULL,0),(8,2,2,NULL,1551206450,2,2,1,'Absensi','mod','assign',1,0,NULL,'',NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.90909,2,0,0,0,1,0,NULL,0),(9,2,3,NULL,1551206450,2,2,1,'Test Penalaran Verbal','mod','quiz',1,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.09091,3,0,0,0,1,0,NULL,0),(10,2,1,'aggregation',1551206451,2,2,NULL,NULL,'course',NULL,1,NULL,NULL,NULL,NULL,1,110.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(11,2,3,NULL,1551207325,2,2,1,'Verbal Reasioning Test','mod','quiz',1,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.09091,3,0,0,0,0,0,NULL,0),(12,2,3,NULL,1551207341,2,2,1,'Verbal Reasoning Test','mod','quiz',1,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.09091,3,0,0,0,0,0,NULL,0);
/*!40000 ALTER TABLE `mdl_grade_items_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_letters`
--

DROP TABLE IF EXISTS `mdl_grade_letters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_letters` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `lowerboundary` decimal(10,5) NOT NULL,
  `letter` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradlett_conlowlet_uix` (`contextid`,`lowerboundary`,`letter`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Repository for grade letters, for courses and other moodle e';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_letters`
--

LOCK TABLES `mdl_grade_letters` WRITE;
/*!40000 ALTER TABLE `mdl_grade_letters` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grade_letters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_outcomes`
--

DROP TABLE IF EXISTS `mdl_grade_outcomes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_outcomes` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) DEFAULT NULL,
  `shortname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fullname` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `scaleid` bigint(10) DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradoutc_cousho_uix` (`courseid`,`shortname`),
  KEY `mdl_gradoutc_cou_ix` (`courseid`),
  KEY `mdl_gradoutc_sca_ix` (`scaleid`),
  KEY `mdl_gradoutc_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table describes the outcomes used in the system. An out';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_outcomes`
--

LOCK TABLES `mdl_grade_outcomes` WRITE;
/*!40000 ALTER TABLE `mdl_grade_outcomes` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grade_outcomes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_outcomes_courses`
--

DROP TABLE IF EXISTS `mdl_grade_outcomes_courses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_outcomes_courses` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `outcomeid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradoutccour_couout_uix` (`courseid`,`outcomeid`),
  KEY `mdl_gradoutccour_cou_ix` (`courseid`),
  KEY `mdl_gradoutccour_out_ix` (`outcomeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='stores what outcomes are used in what courses.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_outcomes_courses`
--

LOCK TABLES `mdl_grade_outcomes_courses` WRITE;
/*!40000 ALTER TABLE `mdl_grade_outcomes_courses` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grade_outcomes_courses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_outcomes_history`
--

DROP TABLE IF EXISTS `mdl_grade_outcomes_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_outcomes_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) DEFAULT NULL,
  `shortname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fullname` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `scaleid` bigint(10) DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_gradoutchist_act_ix` (`action`),
  KEY `mdl_gradoutchist_tim_ix` (`timemodified`),
  KEY `mdl_gradoutchist_old_ix` (`oldid`),
  KEY `mdl_gradoutchist_cou_ix` (`courseid`),
  KEY `mdl_gradoutchist_sca_ix` (`scaleid`),
  KEY `mdl_gradoutchist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='History table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_outcomes_history`
--

LOCK TABLES `mdl_grade_outcomes_history` WRITE;
/*!40000 ALTER TABLE `mdl_grade_outcomes_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grade_outcomes_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_settings`
--

DROP TABLE IF EXISTS `mdl_grade_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_settings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradsett_counam_uix` (`courseid`,`name`),
  KEY `mdl_gradsett_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='gradebook settings';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_settings`
--

LOCK TABLES `mdl_grade_settings` WRITE;
/*!40000 ALTER TABLE `mdl_grade_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grade_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grading_areas`
--

DROP TABLE IF EXISTS `mdl_grading_areas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grading_areas` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `areaname` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `activemethod` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradarea_concomare_uix` (`contextid`,`component`,`areaname`),
  KEY `mdl_gradarea_con_ix` (`contextid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Identifies gradable areas where advanced grading can happen.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grading_areas`
--

LOCK TABLES `mdl_grading_areas` WRITE;
/*!40000 ALTER TABLE `mdl_grading_areas` DISABLE KEYS */;
INSERT INTO `mdl_grading_areas` VALUES (1,28,'mod_assign','submissions',NULL);
/*!40000 ALTER TABLE `mdl_grading_areas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grading_definitions`
--

DROP TABLE IF EXISTS `mdl_grading_definitions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grading_definitions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `areaid` bigint(10) NOT NULL,
  `method` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `copiedfromid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `usercreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `timecopied` bigint(10) DEFAULT '0',
  `options` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_graddefi_aremet_uix` (`areaid`,`method`),
  KEY `mdl_graddefi_are_ix` (`areaid`),
  KEY `mdl_graddefi_use_ix` (`usermodified`),
  KEY `mdl_graddefi_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Contains the basic information about an advanced grading for';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grading_definitions`
--

LOCK TABLES `mdl_grading_definitions` WRITE;
/*!40000 ALTER TABLE `mdl_grading_definitions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grading_definitions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grading_instances`
--

DROP TABLE IF EXISTS `mdl_grading_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grading_instances` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `raterid` bigint(10) NOT NULL,
  `itemid` bigint(10) DEFAULT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `feedback` longtext COLLATE utf8mb4_unicode_ci,
  `feedbackformat` tinyint(2) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_gradinst_def_ix` (`definitionid`),
  KEY `mdl_gradinst_rat_ix` (`raterid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Grading form instance is an assessment record for one gradab';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grading_instances`
--

LOCK TABLES `mdl_grading_instances` WRITE;
/*!40000 ALTER TABLE `mdl_grading_instances` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grading_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_gradingform_guide_comments`
--

DROP TABLE IF EXISTS `mdl_gradingform_guide_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_gradingform_guide_comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_gradguidcomm_def_ix` (`definitionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='frequently used comments used in marking guide';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_gradingform_guide_comments`
--

LOCK TABLES `mdl_gradingform_guide_comments` WRITE;
/*!40000 ALTER TABLE `mdl_gradingform_guide_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_gradingform_guide_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_gradingform_guide_criteria`
--

DROP TABLE IF EXISTS `mdl_gradingform_guide_criteria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_gradingform_guide_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `shortname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  `descriptionmarkers` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionmarkersformat` tinyint(2) DEFAULT NULL,
  `maxscore` decimal(10,5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_gradguidcrit_def_ix` (`definitionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the rows of the criteria grid.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_gradingform_guide_criteria`
--

LOCK TABLES `mdl_gradingform_guide_criteria` WRITE;
/*!40000 ALTER TABLE `mdl_gradingform_guide_criteria` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_gradingform_guide_criteria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_gradingform_guide_fillings`
--

DROP TABLE IF EXISTS `mdl_gradingform_guide_fillings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_gradingform_guide_fillings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `instanceid` bigint(10) NOT NULL,
  `criterionid` bigint(10) NOT NULL,
  `remark` longtext COLLATE utf8mb4_unicode_ci,
  `remarkformat` tinyint(2) DEFAULT NULL,
  `score` decimal(10,5) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradguidfill_inscri_uix` (`instanceid`,`criterionid`),
  KEY `mdl_gradguidfill_ins_ix` (`instanceid`),
  KEY `mdl_gradguidfill_cri_ix` (`criterionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the data of how the guide is filled by a particular r';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_gradingform_guide_fillings`
--

LOCK TABLES `mdl_gradingform_guide_fillings` WRITE;
/*!40000 ALTER TABLE `mdl_gradingform_guide_fillings` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_gradingform_guide_fillings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_gradingform_rubric_criteria`
--

DROP TABLE IF EXISTS `mdl_gradingform_rubric_criteria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_gradingform_rubric_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_gradrubrcrit_def_ix` (`definitionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the rows of the rubric grid.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_gradingform_rubric_criteria`
--

LOCK TABLES `mdl_gradingform_rubric_criteria` WRITE;
/*!40000 ALTER TABLE `mdl_gradingform_rubric_criteria` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_gradingform_rubric_criteria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_gradingform_rubric_fillings`
--

DROP TABLE IF EXISTS `mdl_gradingform_rubric_fillings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_gradingform_rubric_fillings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `instanceid` bigint(10) NOT NULL,
  `criterionid` bigint(10) NOT NULL,
  `levelid` bigint(10) DEFAULT NULL,
  `remark` longtext COLLATE utf8mb4_unicode_ci,
  `remarkformat` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradrubrfill_inscri_uix` (`instanceid`,`criterionid`),
  KEY `mdl_gradrubrfill_lev_ix` (`levelid`),
  KEY `mdl_gradrubrfill_ins_ix` (`instanceid`),
  KEY `mdl_gradrubrfill_cri_ix` (`criterionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the data of how the rubric is filled by a particular ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_gradingform_rubric_fillings`
--

LOCK TABLES `mdl_gradingform_rubric_fillings` WRITE;
/*!40000 ALTER TABLE `mdl_gradingform_rubric_fillings` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_gradingform_rubric_fillings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_gradingform_rubric_levels`
--

DROP TABLE IF EXISTS `mdl_gradingform_rubric_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_gradingform_rubric_levels` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `criterionid` bigint(10) NOT NULL,
  `score` decimal(10,5) NOT NULL,
  `definition` longtext COLLATE utf8mb4_unicode_ci,
  `definitionformat` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_gradrubrleve_cri_ix` (`criterionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the columns of the rubric grid.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_gradingform_rubric_levels`
--

LOCK TABLES `mdl_gradingform_rubric_levels` WRITE;
/*!40000 ALTER TABLE `mdl_gradingform_rubric_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_gradingform_rubric_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_groupings`
--

DROP TABLE IF EXISTS `mdl_groupings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_groupings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `configdata` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_grou_idn2_ix` (`idnumber`),
  KEY `mdl_grou_cou2_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='A grouping is a collection of groups. WAS: groups_groupings';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_groupings`
--

LOCK TABLES `mdl_groupings` WRITE;
/*!40000 ALTER TABLE `mdl_groupings` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_groupings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_groupings_groups`
--

DROP TABLE IF EXISTS `mdl_groupings_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_groupings_groups` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `groupingid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `timeadded` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_grougrou_gro_ix` (`groupingid`),
  KEY `mdl_grougrou_gro2_ix` (`groupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link a grouping to a group (note, groups can be in multiple ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_groupings_groups`
--

LOCK TABLES `mdl_groupings_groups` WRITE;
/*!40000 ALTER TABLE `mdl_groupings_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_groupings_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_groups`
--

DROP TABLE IF EXISTS `mdl_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_groups` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `idnumber` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `enrolmentkey` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `picture` bigint(10) NOT NULL DEFAULT '0',
  `hidepicture` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_grou_idn_ix` (`idnumber`),
  KEY `mdl_grou_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Each record represents a group.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_groups`
--

LOCK TABLES `mdl_groups` WRITE;
/*!40000 ALTER TABLE `mdl_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_groups_members`
--

DROP TABLE IF EXISTS `mdl_groups_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_groups_members` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timeadded` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_groumemb_gro_ix` (`groupid`),
  KEY `mdl_groumemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link a user to a group.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_groups_members`
--

LOCK TABLES `mdl_groups_members` WRITE;
/*!40000 ALTER TABLE `mdl_groups_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_groups_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_imscp`
--

DROP TABLE IF EXISTS `mdl_imscp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_imscp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `keepold` bigint(10) NOT NULL DEFAULT '-1',
  `structure` longtext COLLATE utf8mb4_unicode_ci,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_imsc_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='each record is one imscp resource';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_imscp`
--

LOCK TABLES `mdl_imscp` WRITE;
/*!40000 ALTER TABLE `mdl_imscp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_imscp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_label`
--

DROP TABLE IF EXISTS `mdl_label`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_label` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_labe_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines labels';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_label`
--

LOCK TABLES `mdl_label` WRITE;
/*!40000 ALTER TABLE `mdl_label` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_label` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_lesson`
--

DROP TABLE IF EXISTS `mdl_lesson`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_lesson` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `practice` smallint(3) NOT NULL DEFAULT '0',
  `modattempts` smallint(3) NOT NULL DEFAULT '0',
  `usepassword` smallint(3) NOT NULL DEFAULT '0',
  `password` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `dependency` bigint(10) NOT NULL DEFAULT '0',
  `conditions` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `custom` smallint(3) NOT NULL DEFAULT '0',
  `ongoing` smallint(3) NOT NULL DEFAULT '0',
  `usemaxgrade` smallint(3) NOT NULL DEFAULT '0',
  `maxanswers` smallint(3) NOT NULL DEFAULT '4',
  `maxattempts` smallint(3) NOT NULL DEFAULT '5',
  `review` smallint(3) NOT NULL DEFAULT '0',
  `nextpagedefault` smallint(3) NOT NULL DEFAULT '0',
  `feedback` smallint(3) NOT NULL DEFAULT '1',
  `minquestions` smallint(3) NOT NULL DEFAULT '0',
  `maxpages` smallint(3) NOT NULL DEFAULT '0',
  `timelimit` bigint(10) NOT NULL DEFAULT '0',
  `retake` smallint(3) NOT NULL DEFAULT '1',
  `activitylink` bigint(10) NOT NULL DEFAULT '0',
  `mediafile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mediaheight` bigint(10) NOT NULL DEFAULT '100',
  `mediawidth` bigint(10) NOT NULL DEFAULT '650',
  `mediaclose` smallint(3) NOT NULL DEFAULT '0',
  `slideshow` smallint(3) NOT NULL DEFAULT '0',
  `width` bigint(10) NOT NULL DEFAULT '640',
  `height` bigint(10) NOT NULL DEFAULT '480',
  `bgcolor` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#FFFFFF',
  `displayleft` smallint(3) NOT NULL DEFAULT '0',
  `displayleftif` smallint(3) NOT NULL DEFAULT '0',
  `progressbar` smallint(3) NOT NULL DEFAULT '0',
  `available` bigint(10) NOT NULL DEFAULT '0',
  `deadline` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionendreached` tinyint(1) DEFAULT '0',
  `completiontimespent` bigint(11) DEFAULT '0',
  `allowofflineattempts` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_less_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines lesson';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_lesson`
--

LOCK TABLES `mdl_lesson` WRITE;
/*!40000 ALTER TABLE `mdl_lesson` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_lesson` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_lesson_answers`
--

DROP TABLE IF EXISTS `mdl_lesson_answers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_lesson_answers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `pageid` bigint(10) NOT NULL DEFAULT '0',
  `jumpto` bigint(11) NOT NULL DEFAULT '0',
  `grade` smallint(4) NOT NULL DEFAULT '0',
  `score` bigint(10) NOT NULL DEFAULT '0',
  `flags` smallint(3) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `answer` longtext COLLATE utf8mb4_unicode_ci,
  `answerformat` tinyint(2) NOT NULL DEFAULT '0',
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `responseformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_lessansw_les_ix` (`lessonid`),
  KEY `mdl_lessansw_pag_ix` (`pageid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines lesson_answers';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_lesson_answers`
--

LOCK TABLES `mdl_lesson_answers` WRITE;
/*!40000 ALTER TABLE `mdl_lesson_answers` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_lesson_answers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_lesson_attempts`
--

DROP TABLE IF EXISTS `mdl_lesson_attempts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_lesson_attempts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `pageid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `answerid` bigint(10) NOT NULL DEFAULT '0',
  `retry` smallint(3) NOT NULL DEFAULT '0',
  `correct` bigint(10) NOT NULL DEFAULT '0',
  `useranswer` longtext COLLATE utf8mb4_unicode_ci,
  `timeseen` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_lessatte_use_ix` (`userid`),
  KEY `mdl_lessatte_les_ix` (`lessonid`),
  KEY `mdl_lessatte_pag_ix` (`pageid`),
  KEY `mdl_lessatte_ans_ix` (`answerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines lesson_attempts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_lesson_attempts`
--

LOCK TABLES `mdl_lesson_attempts` WRITE;
/*!40000 ALTER TABLE `mdl_lesson_attempts` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_lesson_attempts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_lesson_branch`
--

DROP TABLE IF EXISTS `mdl_lesson_branch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_lesson_branch` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `pageid` bigint(10) NOT NULL DEFAULT '0',
  `retry` bigint(10) NOT NULL DEFAULT '0',
  `flag` smallint(3) NOT NULL DEFAULT '0',
  `timeseen` bigint(10) NOT NULL DEFAULT '0',
  `nextpageid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_lessbran_use_ix` (`userid`),
  KEY `mdl_lessbran_les_ix` (`lessonid`),
  KEY `mdl_lessbran_pag_ix` (`pageid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='branches for each lesson/user';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_lesson_branch`
--

LOCK TABLES `mdl_lesson_branch` WRITE;
/*!40000 ALTER TABLE `mdl_lesson_branch` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_lesson_branch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_lesson_grades`
--

DROP TABLE IF EXISTS `mdl_lesson_grades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_lesson_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `grade` double NOT NULL DEFAULT '0',
  `late` smallint(3) NOT NULL DEFAULT '0',
  `completed` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_lessgrad_use_ix` (`userid`),
  KEY `mdl_lessgrad_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines lesson_grades';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_lesson_grades`
--

LOCK TABLES `mdl_lesson_grades` WRITE;
/*!40000 ALTER TABLE `mdl_lesson_grades` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_lesson_grades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_lesson_overrides`
--

DROP TABLE IF EXISTS `mdl_lesson_overrides`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_lesson_overrides` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) DEFAULT NULL,
  `userid` bigint(10) DEFAULT NULL,
  `available` bigint(10) DEFAULT NULL,
  `deadline` bigint(10) DEFAULT NULL,
  `timelimit` bigint(10) DEFAULT NULL,
  `review` smallint(3) DEFAULT NULL,
  `maxattempts` smallint(3) DEFAULT NULL,
  `retake` smallint(3) DEFAULT NULL,
  `password` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_lessover_les_ix` (`lessonid`),
  KEY `mdl_lessover_gro_ix` (`groupid`),
  KEY `mdl_lessover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The overrides to lesson settings.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_lesson_overrides`
--

LOCK TABLES `mdl_lesson_overrides` WRITE;
/*!40000 ALTER TABLE `mdl_lesson_overrides` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_lesson_overrides` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_lesson_pages`
--

DROP TABLE IF EXISTS `mdl_lesson_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_lesson_pages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `prevpageid` bigint(10) NOT NULL DEFAULT '0',
  `nextpageid` bigint(10) NOT NULL DEFAULT '0',
  `qtype` smallint(3) NOT NULL DEFAULT '0',
  `qoption` smallint(3) NOT NULL DEFAULT '0',
  `layout` smallint(3) NOT NULL DEFAULT '1',
  `display` smallint(3) NOT NULL DEFAULT '1',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contents` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contentsformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_lesspage_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines lesson_pages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_lesson_pages`
--

LOCK TABLES `mdl_lesson_pages` WRITE;
/*!40000 ALTER TABLE `mdl_lesson_pages` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_lesson_pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_lesson_timer`
--

DROP TABLE IF EXISTS `mdl_lesson_timer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_lesson_timer` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `starttime` bigint(10) NOT NULL DEFAULT '0',
  `lessontime` bigint(10) NOT NULL DEFAULT '0',
  `completed` tinyint(1) DEFAULT '0',
  `timemodifiedoffline` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_lesstime_use_ix` (`userid`),
  KEY `mdl_lesstime_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='lesson timer for each lesson';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_lesson_timer`
--

LOCK TABLES `mdl_lesson_timer` WRITE;
/*!40000 ALTER TABLE `mdl_lesson_timer` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_lesson_timer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_license`
--

DROP TABLE IF EXISTS `mdl_license`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_license` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fullname` longtext COLLATE utf8mb4_unicode_ci,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `version` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='store licenses used by moodle';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_license`
--

LOCK TABLES `mdl_license` WRITE;
/*!40000 ALTER TABLE `mdl_license` DISABLE KEYS */;
INSERT INTO `mdl_license` VALUES (1,'unknown','Unknown license','',1,2010033100),(2,'allrightsreserved','All rights reserved','http://en.wikipedia.org/wiki/All_rights_reserved',1,2010033100),(3,'public','Public Domain','http://creativecommons.org/licenses/publicdomain/',1,2010033100),(4,'cc','Creative Commons','http://creativecommons.org/licenses/by/3.0/',1,2010033100),(5,'cc-nd','Creative Commons - NoDerivs','http://creativecommons.org/licenses/by-nd/3.0/',1,2010033100),(6,'cc-nc-nd','Creative Commons - No Commercial NoDerivs','http://creativecommons.org/licenses/by-nc-nd/3.0/',1,2010033100),(7,'cc-nc','Creative Commons - No Commercial','http://creativecommons.org/licenses/by-nc/3.0/',1,2013051500),(8,'cc-nc-sa','Creative Commons - No Commercial ShareAlike','http://creativecommons.org/licenses/by-nc-sa/3.0/',1,2010033100),(9,'cc-sa','Creative Commons - ShareAlike','http://creativecommons.org/licenses/by-sa/3.0/',1,2010033100);
/*!40000 ALTER TABLE `mdl_license` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_lock_db`
--

DROP TABLE IF EXISTS `mdl_lock_db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_lock_db` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `resourcekey` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `expires` bigint(10) DEFAULT NULL,
  `owner` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_lockdb_res_uix` (`resourcekey`),
  KEY `mdl_lockdb_exp_ix` (`expires`),
  KEY `mdl_lockdb_own_ix` (`owner`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores active and inactive lock types for db locking method.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_lock_db`
--

LOCK TABLES `mdl_lock_db` WRITE;
/*!40000 ALTER TABLE `mdl_lock_db` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_lock_db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_log`
--

DROP TABLE IF EXISTS `mdl_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `time` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `module` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cmid` bigint(10) NOT NULL DEFAULT '0',
  `action` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `info` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_log_coumodact_ix` (`course`,`module`,`action`),
  KEY `mdl_log_tim_ix` (`time`),
  KEY `mdl_log_act_ix` (`action`),
  KEY `mdl_log_usecou_ix` (`userid`,`course`),
  KEY `mdl_log_cmi_ix` (`cmid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Every action is logged as far as possible';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_log`
--

LOCK TABLES `mdl_log` WRITE;
/*!40000 ALTER TABLE `mdl_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_log_display`
--

DROP TABLE IF EXISTS `mdl_log_display`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_log_display` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `module` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `action` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mtable` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `field` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_logdisp_modact_uix` (`module`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=201 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='For a particular module/action, specifies a moodle table/fie';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_log_display`
--

LOCK TABLES `mdl_log_display` WRITE;
/*!40000 ALTER TABLE `mdl_log_display` DISABLE KEYS */;
INSERT INTO `mdl_log_display` VALUES (1,'course','user report','user','CONCAT(firstname, \' \', lastname)','moodle'),(2,'course','view','course','fullname','moodle'),(3,'course','view section','course_sections','name','moodle'),(4,'course','update','course','fullname','moodle'),(5,'course','hide','course','fullname','moodle'),(6,'course','show','course','fullname','moodle'),(7,'course','move','course','fullname','moodle'),(8,'course','enrol','course','fullname','moodle'),(9,'course','unenrol','course','fullname','moodle'),(10,'course','report log','course','fullname','moodle'),(11,'course','report live','course','fullname','moodle'),(12,'course','report outline','course','fullname','moodle'),(13,'course','report participation','course','fullname','moodle'),(14,'course','report stats','course','fullname','moodle'),(15,'category','add','course_categories','name','moodle'),(16,'category','hide','course_categories','name','moodle'),(17,'category','move','course_categories','name','moodle'),(18,'category','show','course_categories','name','moodle'),(19,'category','update','course_categories','name','moodle'),(20,'message','write','user','CONCAT(firstname, \' \', lastname)','moodle'),(21,'message','read','user','CONCAT(firstname, \' \', lastname)','moodle'),(22,'message','add contact','user','CONCAT(firstname, \' \', lastname)','moodle'),(23,'message','remove contact','user','CONCAT(firstname, \' \', lastname)','moodle'),(24,'message','block contact','user','CONCAT(firstname, \' \', lastname)','moodle'),(25,'message','unblock contact','user','CONCAT(firstname, \' \', lastname)','moodle'),(26,'group','view','groups','name','moodle'),(27,'tag','update','tag','name','moodle'),(28,'tag','flag','tag','name','moodle'),(29,'user','view','user','CONCAT(firstname, \' \', lastname)','moodle'),(30,'assign','add','assign','name','mod_assign'),(31,'assign','delete mod','assign','name','mod_assign'),(32,'assign','download all submissions','assign','name','mod_assign'),(33,'assign','grade submission','assign','name','mod_assign'),(34,'assign','lock submission','assign','name','mod_assign'),(35,'assign','reveal identities','assign','name','mod_assign'),(36,'assign','revert submission to draft','assign','name','mod_assign'),(37,'assign','set marking workflow state','assign','name','mod_assign'),(38,'assign','submission statement accepted','assign','name','mod_assign'),(39,'assign','submit','assign','name','mod_assign'),(40,'assign','submit for grading','assign','name','mod_assign'),(41,'assign','unlock submission','assign','name','mod_assign'),(42,'assign','update','assign','name','mod_assign'),(43,'assign','upload','assign','name','mod_assign'),(44,'assign','view','assign','name','mod_assign'),(45,'assign','view all','course','fullname','mod_assign'),(46,'assign','view confirm submit assignment form','assign','name','mod_assign'),(47,'assign','view grading form','assign','name','mod_assign'),(48,'assign','view submission','assign','name','mod_assign'),(49,'assign','view submission grading table','assign','name','mod_assign'),(50,'assign','view submit assignment form','assign','name','mod_assign'),(51,'assign','view feedback','assign','name','mod_assign'),(52,'assign','view batch set marking workflow state','assign','name','mod_assign'),(53,'assignment','view','assignment','name','mod_assignment'),(54,'assignment','add','assignment','name','mod_assignment'),(55,'assignment','update','assignment','name','mod_assignment'),(56,'assignment','view submission','assignment','name','mod_assignment'),(57,'assignment','upload','assignment','name','mod_assignment'),(58,'book','add','book','name','mod_book'),(59,'book','update','book','name','mod_book'),(60,'book','view','book','name','mod_book'),(61,'book','add chapter','book_chapters','title','mod_book'),(62,'book','update chapter','book_chapters','title','mod_book'),(63,'book','view chapter','book_chapters','title','mod_book'),(64,'chat','view','chat','name','mod_chat'),(65,'chat','add','chat','name','mod_chat'),(66,'chat','update','chat','name','mod_chat'),(67,'chat','report','chat','name','mod_chat'),(68,'chat','talk','chat','name','mod_chat'),(69,'choice','view','choice','name','mod_choice'),(70,'choice','update','choice','name','mod_choice'),(71,'choice','add','choice','name','mod_choice'),(72,'choice','report','choice','name','mod_choice'),(73,'choice','choose','choice','name','mod_choice'),(74,'choice','choose again','choice','name','mod_choice'),(75,'data','view','data','name','mod_data'),(76,'data','add','data','name','mod_data'),(77,'data','update','data','name','mod_data'),(78,'data','record delete','data','name','mod_data'),(79,'data','fields add','data_fields','name','mod_data'),(80,'data','fields update','data_fields','name','mod_data'),(81,'data','templates saved','data','name','mod_data'),(82,'data','templates def','data','name','mod_data'),(83,'feedback','startcomplete','feedback','name','mod_feedback'),(84,'feedback','submit','feedback','name','mod_feedback'),(85,'feedback','delete','feedback','name','mod_feedback'),(86,'feedback','view','feedback','name','mod_feedback'),(87,'feedback','view all','course','shortname','mod_feedback'),(88,'folder','view','folder','name','mod_folder'),(89,'folder','view all','folder','name','mod_folder'),(90,'folder','update','folder','name','mod_folder'),(91,'folder','add','folder','name','mod_folder'),(92,'forum','add','forum','name','mod_forum'),(93,'forum','update','forum','name','mod_forum'),(94,'forum','add discussion','forum_discussions','name','mod_forum'),(95,'forum','add post','forum_posts','subject','mod_forum'),(96,'forum','update post','forum_posts','subject','mod_forum'),(97,'forum','user report','user','CONCAT(firstname, \' \', lastname)','mod_forum'),(98,'forum','move discussion','forum_discussions','name','mod_forum'),(99,'forum','view subscribers','forum','name','mod_forum'),(100,'forum','view discussion','forum_discussions','name','mod_forum'),(101,'forum','view forum','forum','name','mod_forum'),(102,'forum','subscribe','forum','name','mod_forum'),(103,'forum','unsubscribe','forum','name','mod_forum'),(104,'forum','pin discussion','forum_discussions','name','mod_forum'),(105,'forum','unpin discussion','forum_discussions','name','mod_forum'),(106,'glossary','add','glossary','name','mod_glossary'),(107,'glossary','update','glossary','name','mod_glossary'),(108,'glossary','view','glossary','name','mod_glossary'),(109,'glossary','view all','glossary','name','mod_glossary'),(110,'glossary','add entry','glossary','name','mod_glossary'),(111,'glossary','update entry','glossary','name','mod_glossary'),(112,'glossary','add category','glossary','name','mod_glossary'),(113,'glossary','update category','glossary','name','mod_glossary'),(114,'glossary','delete category','glossary','name','mod_glossary'),(115,'glossary','approve entry','glossary','name','mod_glossary'),(116,'glossary','disapprove entry','glossary','name','mod_glossary'),(117,'glossary','view entry','glossary_entries','concept','mod_glossary'),(118,'imscp','view','imscp','name','mod_imscp'),(119,'imscp','view all','imscp','name','mod_imscp'),(120,'imscp','update','imscp','name','mod_imscp'),(121,'imscp','add','imscp','name','mod_imscp'),(122,'label','add','label','name','mod_label'),(123,'label','update','label','name','mod_label'),(124,'lesson','start','lesson','name','mod_lesson'),(125,'lesson','end','lesson','name','mod_lesson'),(126,'lesson','view','lesson_pages','title','mod_lesson'),(127,'lti','view','lti','name','mod_lti'),(128,'lti','launch','lti','name','mod_lti'),(129,'lti','view all','lti','name','mod_lti'),(130,'page','view','page','name','mod_page'),(131,'page','view all','page','name','mod_page'),(132,'page','update','page','name','mod_page'),(133,'page','add','page','name','mod_page'),(134,'quiz','add','quiz','name','mod_quiz'),(135,'quiz','update','quiz','name','mod_quiz'),(136,'quiz','view','quiz','name','mod_quiz'),(137,'quiz','report','quiz','name','mod_quiz'),(138,'quiz','attempt','quiz','name','mod_quiz'),(139,'quiz','submit','quiz','name','mod_quiz'),(140,'quiz','review','quiz','name','mod_quiz'),(141,'quiz','editquestions','quiz','name','mod_quiz'),(142,'quiz','preview','quiz','name','mod_quiz'),(143,'quiz','start attempt','quiz','name','mod_quiz'),(144,'quiz','close attempt','quiz','name','mod_quiz'),(145,'quiz','continue attempt','quiz','name','mod_quiz'),(146,'quiz','edit override','quiz','name','mod_quiz'),(147,'quiz','delete override','quiz','name','mod_quiz'),(148,'quiz','view summary','quiz','name','mod_quiz'),(149,'resource','view','resource','name','mod_resource'),(150,'resource','view all','resource','name','mod_resource'),(151,'resource','update','resource','name','mod_resource'),(152,'resource','add','resource','name','mod_resource'),(153,'scorm','view','scorm','name','mod_scorm'),(154,'scorm','review','scorm','name','mod_scorm'),(155,'scorm','update','scorm','name','mod_scorm'),(156,'scorm','add','scorm','name','mod_scorm'),(157,'survey','add','survey','name','mod_survey'),(158,'survey','update','survey','name','mod_survey'),(159,'survey','download','survey','name','mod_survey'),(160,'survey','view form','survey','name','mod_survey'),(161,'survey','view graph','survey','name','mod_survey'),(162,'survey','view report','survey','name','mod_survey'),(163,'survey','submit','survey','name','mod_survey'),(164,'url','view','url','name','mod_url'),(165,'url','view all','url','name','mod_url'),(166,'url','update','url','name','mod_url'),(167,'url','add','url','name','mod_url'),(168,'workshop','add','workshop','name','mod_workshop'),(169,'workshop','update','workshop','name','mod_workshop'),(170,'workshop','view','workshop','name','mod_workshop'),(171,'workshop','view all','workshop','name','mod_workshop'),(172,'workshop','add submission','workshop_submissions','title','mod_workshop'),(173,'workshop','update submission','workshop_submissions','title','mod_workshop'),(174,'workshop','view submission','workshop_submissions','title','mod_workshop'),(175,'workshop','add assessment','workshop_submissions','title','mod_workshop'),(176,'workshop','update assessment','workshop_submissions','title','mod_workshop'),(177,'workshop','add example','workshop_submissions','title','mod_workshop'),(178,'workshop','update example','workshop_submissions','title','mod_workshop'),(179,'workshop','view example','workshop_submissions','title','mod_workshop'),(180,'workshop','add reference assessment','workshop_submissions','title','mod_workshop'),(181,'workshop','update reference assessment','workshop_submissions','title','mod_workshop'),(182,'workshop','add example assessment','workshop_submissions','title','mod_workshop'),(183,'workshop','update example assessment','workshop_submissions','title','mod_workshop'),(184,'workshop','update aggregate grades','workshop','name','mod_workshop'),(185,'workshop','update clear aggregated grades','workshop','name','mod_workshop'),(186,'workshop','update clear assessments','workshop','name','mod_workshop'),(187,'book','exportimscp','book','name','booktool_exportimscp'),(188,'book','print','book','name','booktool_print'),(189,'book','print chapter','book_chapters','title','booktool_print'),(190,'bigbluebuttonbn','add','bigbluebuttonbn','name','mod_bigbluebuttonbn'),(191,'bigbluebuttonbn','update','bigbluebuttonbn','name','mod_bigbluebuttonbn'),(192,'bigbluebuttonbn','view','bigbluebuttonbn','name','mod_bigbluebuttonbn'),(193,'bigbluebuttonbn','view all','bigbluebuttonbn','name','mod_bigbluebuttonbn'),(194,'bigbluebuttonbn','create','bigbluebuttonbn','name','mod_bigbluebuttonbn'),(195,'bigbluebuttonbn','end','bigbluebuttonbn','name','mod_bigbluebuttonbn'),(196,'bigbluebuttonbn','join','bigbluebuttonbn','name','mod_bigbluebuttonbn'),(197,'bigbluebuttonbn','left','bigbluebuttonbn','name','mod_bigbluebuttonbn'),(198,'bigbluebuttonbn','publish','bigbluebuttonbn','name','mod_bigbluebuttonbn'),(199,'bigbluebuttonbn','unpublish','bigbluebuttonbn','name','mod_bigbluebuttonbn'),(200,'bigbluebuttonbn','delete','bigbluebuttonbn','name','mod_bigbluebuttonbn');
/*!40000 ALTER TABLE `mdl_log_display` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_log_queries`
--

DROP TABLE IF EXISTS `mdl_log_queries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_log_queries` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `qtype` mediumint(5) NOT NULL,
  `sqltext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sqlparams` longtext COLLATE utf8mb4_unicode_ci,
  `error` mediumint(5) NOT NULL DEFAULT '0',
  `info` longtext COLLATE utf8mb4_unicode_ci,
  `backtrace` longtext COLLATE utf8mb4_unicode_ci,
  `exectime` decimal(10,5) NOT NULL,
  `timelogged` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Logged database queries.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_log_queries`
--

LOCK TABLES `mdl_log_queries` WRITE;
/*!40000 ALTER TABLE `mdl_log_queries` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_log_queries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_logstore_standard_log`
--

DROP TABLE IF EXISTS `mdl_logstore_standard_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_logstore_standard_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `action` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `target` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objecttable` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `objectid` bigint(10) DEFAULT NULL,
  `crud` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `edulevel` tinyint(1) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `contextlevel` bigint(10) NOT NULL,
  `contextinstanceid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `courseid` bigint(10) DEFAULT NULL,
  `relateduserid` bigint(10) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `other` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL,
  `origin` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `realuserid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_logsstanlog_tim_ix` (`timecreated`),
  KEY `mdl_logsstanlog_couanotim_ix` (`courseid`,`anonymous`,`timecreated`),
  KEY `mdl_logsstanlog_useconconcr_ix` (`userid`,`contextlevel`,`contextinstanceid`,`crud`,`edulevel`,`timecreated`),
  KEY `mdl_logsstanlog_con_ix` (`contextid`)
) ENGINE=InnoDB AUTO_INCREMENT=1774 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Standard log table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_logstore_standard_log`
--

LOCK TABLES `mdl_logstore_standard_log` WRITE;
/*!40000 ALTER TABLE `mdl_logstore_standard_log` DISABLE KEYS */;
INSERT INTO `mdl_logstore_standard_log` VALUES (1,'\\core\\event\\user_loggedin','core','loggedin','user','user',2,'r',0,1,10,0,2,0,NULL,0,'a:1:{s:8:\"username\";s:5:\"admin\";}',1547809897,'web','0:0:0:0:0:0:0:1',NULL),(2,'\\core\\event\\user_password_updated','core','updated','user_password',NULL,NULL,'u',0,5,30,2,2,0,2,0,'a:1:{s:14:\"forgottenreset\";b:0;}',1547809997,'web','0:0:0:0:0:0:0:1',NULL),(3,'\\core\\event\\user_updated','core','updated','user','user',2,'u',0,5,30,2,2,0,2,0,'N;',1547809997,'web','0:0:0:0:0:0:0:1',NULL),(4,'\\core\\event\\config_log_created','core','created','config_log','config_log',546,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"notloggedinroleid\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"6\";s:6:\"plugin\";N;}',1547810003,'web','0:0:0:0:0:0:0:1',NULL),(5,'\\core\\event\\config_log_created','core','created','config_log','config_log',547,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"guestroleid\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"6\";s:6:\"plugin\";N;}',1547810003,'web','0:0:0:0:0:0:0:1',NULL),(6,'\\core\\event\\config_log_created','core','created','config_log','config_log',548,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"defaultuserroleid\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"7\";s:6:\"plugin\";N;}',1547810003,'web','0:0:0:0:0:0:0:1',NULL),(7,'\\core\\event\\config_log_created','core','created','config_log','config_log',549,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"creatornewroleid\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"3\";s:6:\"plugin\";N;}',1547810003,'web','0:0:0:0:0:0:0:1',NULL),(8,'\\core\\event\\config_log_created','core','created','config_log','config_log',550,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"restorernewroleid\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"3\";s:6:\"plugin\";N;}',1547810003,'web','0:0:0:0:0:0:0:1',NULL),(9,'\\core\\event\\config_log_created','core','created','config_log','config_log',551,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"contactdataprotectionofficer\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:16:\"tool_dataprivacy\";}',1547810003,'web','0:0:0:0:0:0:0:1',NULL),(10,'\\core\\event\\config_log_created','core','created','config_log','config_log',552,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"automaticdeletionrequests\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:16:\"tool_dataprivacy\";}',1547810003,'web','0:0:0:0:0:0:0:1',NULL),(11,'\\core\\event\\config_log_created','core','created','config_log','config_log',553,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"privacyrequestexpiry\";s:8:\"oldvalue\";N;s:5:\"value\";s:6:\"604800\";s:6:\"plugin\";s:16:\"tool_dataprivacy\";}',1547810003,'web','0:0:0:0:0:0:0:1',NULL),(12,'\\core\\event\\config_log_created','core','created','config_log','config_log',554,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:33:\"requireallenddatesforuserdeletion\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:16:\"tool_dataprivacy\";}',1547810003,'web','0:0:0:0:0:0:0:1',NULL),(13,'\\core\\event\\config_log_created','core','created','config_log','config_log',555,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"showdataretentionsummary\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:16:\"tool_dataprivacy\";}',1547810003,'web','0:0:0:0:0:0:0:1',NULL),(14,'\\core\\event\\config_log_created','core','created','config_log','config_log',556,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"exportlog\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:8:\"tool_log\";}',1547810003,'web','0:0:0:0:0:0:0:1',NULL),(15,'\\core\\event\\config_log_created','core','created','config_log','config_log',557,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"sitepolicyhandler\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";N;}',1547810003,'web','0:0:0:0:0:0:0:1',NULL),(16,'\\core\\event\\config_log_created','core','created','config_log','config_log',558,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"gradebookroles\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";N;}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(17,'\\core\\event\\config_log_created','core','created','config_log','config_log',559,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"logstore\";s:8:\"oldvalue\";N;s:5:\"value\";s:17:\"logstore_standard\";s:6:\"plugin\";s:9:\"analytics\";}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(18,'\\core\\event\\config_log_created','core','created','config_log','config_log',560,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"coursebinenable\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:15:\"tool_recyclebin\";}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(19,'\\core\\event\\config_log_created','core','created','config_log','config_log',561,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"coursebinexpiry\";s:8:\"oldvalue\";N;s:5:\"value\";s:6:\"604800\";s:6:\"plugin\";s:15:\"tool_recyclebin\";}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(20,'\\core\\event\\config_log_created','core','created','config_log','config_log',562,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"categorybinenable\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:15:\"tool_recyclebin\";}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(21,'\\core\\event\\config_log_created','core','created','config_log','config_log',563,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"categorybinexpiry\";s:8:\"oldvalue\";N;s:5:\"value\";s:6:\"604800\";s:6:\"plugin\";s:15:\"tool_recyclebin\";}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(22,'\\core\\event\\config_log_created','core','created','config_log','config_log',564,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"autohide\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:15:\"tool_recyclebin\";}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(23,'\\core\\event\\config_log_created','core','created','config_log','config_log',565,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"runningmethod\";s:8:\"oldvalue\";N;s:5:\"value\";s:11:\"commandline\";s:6:\"plugin\";s:16:\"antivirus_clamav\";}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(24,'\\core\\event\\config_log_created','core','created','config_log','config_log',566,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"pathtoclam\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:16:\"antivirus_clamav\";}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(25,'\\core\\event\\config_log_created','core','created','config_log','config_log',567,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"pathtounixsocket\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:16:\"antivirus_clamav\";}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(26,'\\core\\event\\config_log_created','core','created','config_log','config_log',568,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"clamfailureonupload\";s:8:\"oldvalue\";N;s:5:\"value\";s:9:\"donothing\";s:6:\"plugin\";s:16:\"antivirus_clamav\";}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(27,'\\core\\event\\config_log_created','core','created','config_log','config_log',569,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"config_showbest\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"3\";s:6:\"plugin\";s:22:\"block_activity_results\";}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(28,'\\core\\event\\config_log_created','core','created','config_log','config_log',570,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"config_showbest_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:22:\"block_activity_results\";}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(29,'\\core\\event\\config_log_created','core','created','config_log','config_log',571,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"config_showworst\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:22:\"block_activity_results\";}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(30,'\\core\\event\\config_log_created','core','created','config_log','config_log',572,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"config_showworst_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:22:\"block_activity_results\";}',1547810004,'web','0:0:0:0:0:0:0:1',NULL),(31,'\\core\\event\\config_log_created','core','created','config_log','config_log',573,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"config_usegroups\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:22:\"block_activity_results\";}',1547810005,'web','0:0:0:0:0:0:0:1',NULL),(32,'\\core\\event\\config_log_created','core','created','config_log','config_log',574,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"config_usegroups_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:22:\"block_activity_results\";}',1547810005,'web','0:0:0:0:0:0:0:1',NULL),(33,'\\core\\event\\config_log_created','core','created','config_log','config_log',575,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"config_nameformat\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:22:\"block_activity_results\";}',1547810005,'web','0:0:0:0:0:0:0:1',NULL),(34,'\\core\\event\\config_log_created','core','created','config_log','config_log',576,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"config_nameformat_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:22:\"block_activity_results\";}',1547810005,'web','0:0:0:0:0:0:0:1',NULL),(35,'\\core\\event\\config_log_created','core','created','config_log','config_log',577,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"config_gradeformat\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:22:\"block_activity_results\";}',1547810005,'web','0:0:0:0:0:0:0:1',NULL),(36,'\\core\\event\\config_log_created','core','created','config_log','config_log',578,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"config_gradeformat_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:22:\"block_activity_results\";}',1547810005,'web','0:0:0:0:0:0:0:1',NULL),(37,'\\core\\event\\config_log_created','core','created','config_log','config_log',579,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"config_decimalpoints\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"2\";s:6:\"plugin\";s:22:\"block_activity_results\";}',1547810005,'web','0:0:0:0:0:0:0:1',NULL),(38,'\\core\\event\\config_log_created','core','created','config_log','config_log',580,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"config_decimalpoints_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:22:\"block_activity_results\";}',1547810005,'web','0:0:0:0:0:0:0:1',NULL),(39,'\\core\\event\\config_log_created','core','created','config_log','config_log',581,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"block_html_allowcssclasses\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810005,'web','0:0:0:0:0:0:0:1',NULL),(40,'\\core\\event\\config_log_created','core','created','config_log','config_log',582,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"block_course_list_adminview\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"all\";s:6:\"plugin\";N;}',1547810005,'web','0:0:0:0:0:0:0:1',NULL),(41,'\\core\\event\\config_log_created','core','created','config_log','config_log',583,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:36:\"block_course_list_hideallcourseslink\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810005,'web','0:0:0:0:0:0:0:1',NULL),(42,'\\core\\event\\config_log_created','core','created','config_log','config_log',584,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"block_online_users_timetosee\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";N;}',1547810005,'web','0:0:0:0:0:0:0:1',NULL),(43,'\\core\\event\\config_log_created','core','created','config_log','config_log',585,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"block_rss_client_num_entries\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";N;}',1547810006,'web','0:0:0:0:0:0:0:1',NULL),(44,'\\core\\event\\config_log_created','core','created','config_log','config_log',586,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"block_rss_client_timeout\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"30\";s:6:\"plugin\";N;}',1547810006,'web','0:0:0:0:0:0:0:1',NULL),(45,'\\core\\event\\config_log_created','core','created','config_log','config_log',587,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"numsections1\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"22\";s:6:\"plugin\";s:19:\"block_section_links\";}',1547810006,'web','0:0:0:0:0:0:0:1',NULL),(46,'\\core\\event\\config_log_created','core','created','config_log','config_log',588,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"incby1\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"2\";s:6:\"plugin\";s:19:\"block_section_links\";}',1547810006,'web','0:0:0:0:0:0:0:1',NULL),(47,'\\core\\event\\config_log_created','core','created','config_log','config_log',589,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"numsections2\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"40\";s:6:\"plugin\";s:19:\"block_section_links\";}',1547810006,'web','0:0:0:0:0:0:0:1',NULL),(48,'\\core\\event\\config_log_created','core','created','config_log','config_log',590,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"incby2\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:19:\"block_section_links\";}',1547810006,'web','0:0:0:0:0:0:0:1',NULL),(49,'\\core\\event\\config_log_created','core','created','config_log','config_log',591,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"apikey\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:17:\"block_tag_youtube\";}',1547810006,'web','0:0:0:0:0:0:0:1',NULL),(50,'\\core\\event\\config_log_created','core','created','config_log','config_log',592,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"issuerid\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:25:\"fileconverter_googledrive\";}',1547810006,'web','0:0:0:0:0:0:0:1',NULL),(51,'\\core\\event\\config_log_created','core','created','config_log','config_log',593,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"pathtounoconv\";s:8:\"oldvalue\";N;s:5:\"value\";s:16:\"/usr/bin/unoconv\";s:6:\"plugin\";N;}',1547810006,'web','0:0:0:0:0:0:0:1',NULL),(52,'\\core\\event\\config_log_created','core','created','config_log','config_log',594,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"toolbar\";s:8:\"oldvalue\";N;s:5:\"value\";s:345:\"collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist\nlinks = link\nfiles = image, media, recordrtc, managefiles\nstyle2 = underline, strike, subscript, superscript\nalign = align\nindent = indent\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html\";s:6:\"plugin\";s:11:\"editor_atto\";}',1547810007,'web','0:0:0:0:0:0:0:1',NULL),(53,'\\core\\event\\config_log_created','core','created','config_log','config_log',595,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"autosavefrequency\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"60\";s:6:\"plugin\";s:11:\"editor_atto\";}',1547810007,'web','0:0:0:0:0:0:0:1',NULL),(54,'\\core\\event\\config_log_created','core','created','config_log','config_log',596,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"showgroups\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:13:\"atto_collapse\";}',1547810007,'web','0:0:0:0:0:0:0:1',NULL),(55,'\\core\\event\\config_log_created','core','created','config_log','config_log',597,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"librarygroup1\";s:8:\"oldvalue\";N;s:5:\"value\";s:244:\"\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n\";s:6:\"plugin\";s:13:\"atto_equation\";}',1547810007,'web','0:0:0:0:0:0:0:1',NULL),(56,'\\core\\event\\config_log_created','core','created','config_log','config_log',598,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"librarygroup2\";s:8:\"oldvalue\";N;s:5:\"value\";s:155:\"\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n\";s:6:\"plugin\";s:13:\"atto_equation\";}',1547810007,'web','0:0:0:0:0:0:0:1',NULL),(57,'\\core\\event\\config_log_created','core','created','config_log','config_log',599,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"librarygroup3\";s:8:\"oldvalue\";N;s:5:\"value\";s:210:\"\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n\";s:6:\"plugin\";s:13:\"atto_equation\";}',1547810007,'web','0:0:0:0:0:0:0:1',NULL),(58,'\\core\\event\\config_log_created','core','created','config_log','config_log',600,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"librarygroup4\";s:8:\"oldvalue\";N;s:5:\"value\";s:239:\"\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n\";s:6:\"plugin\";s:13:\"atto_equation\";}',1547810007,'web','0:0:0:0:0:0:0:1',NULL),(59,'\\core\\event\\config_log_created','core','created','config_log','config_log',601,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"allowedtypes\";s:8:\"oldvalue\";N;s:5:\"value\";s:4:\"both\";s:6:\"plugin\";s:14:\"atto_recordrtc\";}',1547810007,'web','0:0:0:0:0:0:0:1',NULL),(60,'\\core\\event\\config_log_created','core','created','config_log','config_log',602,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"audiobitrate\";s:8:\"oldvalue\";N;s:5:\"value\";s:6:\"128000\";s:6:\"plugin\";s:14:\"atto_recordrtc\";}',1547810007,'web','0:0:0:0:0:0:0:1',NULL),(61,'\\core\\event\\config_log_created','core','created','config_log','config_log',603,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"videobitrate\";s:8:\"oldvalue\";N;s:5:\"value\";s:7:\"2500000\";s:6:\"plugin\";s:14:\"atto_recordrtc\";}',1547810007,'web','0:0:0:0:0:0:0:1',NULL),(62,'\\core\\event\\config_log_created','core','created','config_log','config_log',604,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"timelimit\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"120\";s:6:\"plugin\";s:14:\"atto_recordrtc\";}',1547810007,'web','0:0:0:0:0:0:0:1',NULL),(63,'\\core\\event\\config_log_created','core','created','config_log','config_log',605,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"allowborders\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"atto_table\";}',1547810007,'web','0:0:0:0:0:0:0:1',NULL),(64,'\\core\\event\\config_log_created','core','created','config_log','config_log',606,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"allowbackgroundcolour\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"atto_table\";}',1547810007,'web','0:0:0:0:0:0:0:1',NULL),(65,'\\core\\event\\config_log_created','core','created','config_log','config_log',607,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"allowwidth\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"atto_table\";}',1547810007,'web','0:0:0:0:0:0:0:1',NULL),(66,'\\core\\event\\config_log_created','core','created','config_log','config_log',608,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"customtoolbar\";s:8:\"oldvalue\";N;s:5:\"value\";s:378:\"wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen\";s:6:\"plugin\";s:14:\"editor_tinymce\";}',1547810008,'web','0:0:0:0:0:0:0:1',NULL),(67,'\\core\\event\\config_log_created','core','created','config_log','config_log',609,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"fontselectlist\";s:8:\"oldvalue\";N;s:5:\"value\";s:338:\"Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings\";s:6:\"plugin\";s:14:\"editor_tinymce\";}',1547810008,'web','0:0:0:0:0:0:0:1',NULL),(68,'\\core\\event\\config_log_created','core','created','config_log','config_log',610,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"customconfig\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"editor_tinymce\";}',1547810008,'web','0:0:0:0:0:0:0:1',NULL),(69,'\\core\\event\\config_log_created','core','created','config_log','config_log',611,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"requireemoticon\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:22:\"tinymce_moodleemoticon\";}',1547810008,'web','0:0:0:0:0:0:0:1',NULL),(70,'\\core\\event\\config_log_created','core','created','config_log','config_log',612,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"spellengine\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:20:\"tinymce_spellchecker\";}',1547810008,'web','0:0:0:0:0:0:0:1',NULL),(71,'\\core\\event\\config_log_created','core','created','config_log','config_log',613,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"spelllanguagelist\";s:8:\"oldvalue\";N;s:5:\"value\";s:118:\"+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv\";s:6:\"plugin\";s:20:\"tinymce_spellchecker\";}',1547810008,'web','0:0:0:0:0:0:0:1',NULL),(72,'\\core\\event\\config_log_created','core','created','config_log','config_log',614,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"activitytype\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"forum\";s:6:\"plugin\";s:21:\"format_singleactivity\";}',1547810008,'web','0:0:0:0:0:0:0:1',NULL),(73,'\\core\\event\\config_log_created','core','created','config_log','config_log',615,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"jabberhost\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";N;}',1547810008,'web','0:0:0:0:0:0:0:1',NULL),(74,'\\core\\event\\config_log_created','core','created','config_log','config_log',616,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"jabberserver\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";N;}',1547810008,'web','0:0:0:0:0:0:0:1',NULL),(75,'\\core\\event\\config_log_created','core','created','config_log','config_log',617,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"jabberusername\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";N;}',1547810008,'web','0:0:0:0:0:0:0:1',NULL),(76,'\\core\\event\\config_log_created','core','created','config_log','config_log',618,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"jabberpassword\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";N;}',1547810008,'web','0:0:0:0:0:0:0:1',NULL),(77,'\\core\\event\\config_log_created','core','created','config_log','config_log',619,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"jabberport\";s:8:\"oldvalue\";N;s:5:\"value\";s:4:\"5222\";s:6:\"plugin\";N;}',1547810008,'web','0:0:0:0:0:0:0:1',NULL),(78,'\\core\\event\\config_log_created','core','created','config_log','config_log',620,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"airnotifierurl\";s:8:\"oldvalue\";N;s:5:\"value\";s:27:\"https://messages.moodle.net\";s:6:\"plugin\";N;}',1547810008,'web','0:0:0:0:0:0:0:1',NULL),(79,'\\core\\event\\config_log_created','core','created','config_log','config_log',621,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"airnotifierport\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"443\";s:6:\"plugin\";N;}',1547810009,'web','0:0:0:0:0:0:0:1',NULL),(80,'\\core\\event\\config_log_created','core','created','config_log','config_log',622,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"airnotifiermobileappname\";s:8:\"oldvalue\";N;s:5:\"value\";s:23:\"com.moodle.moodlemobile\";s:6:\"plugin\";N;}',1547810009,'web','0:0:0:0:0:0:0:1',NULL),(81,'\\core\\event\\config_log_created','core','created','config_log','config_log',623,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"airnotifierappname\";s:8:\"oldvalue\";N;s:5:\"value\";s:21:\"commoodlemoodlemobile\";s:6:\"plugin\";N;}',1547810009,'web','0:0:0:0:0:0:0:1',NULL),(82,'\\core\\event\\config_log_created','core','created','config_log','config_log',624,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"airnotifieraccesskey\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";N;}',1547810009,'web','0:0:0:0:0:0:0:1',NULL),(83,'\\core\\event\\config_log_created','core','created','config_log','config_log',625,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"dbdriver\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810009,'web','0:0:0:0:0:0:0:1',NULL),(84,'\\core\\event\\config_log_created','core','created','config_log','config_log',626,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"dbhost\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810009,'web','0:0:0:0:0:0:0:1',NULL),(85,'\\core\\event\\config_log_created','core','created','config_log','config_log',627,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"dbuser\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810009,'web','0:0:0:0:0:0:0:1',NULL),(86,'\\core\\event\\config_log_created','core','created','config_log','config_log',628,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"dbpass\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810009,'web','0:0:0:0:0:0:0:1',NULL),(87,'\\core\\event\\config_log_created','core','created','config_log','config_log',629,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"dbname\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810009,'web','0:0:0:0:0:0:0:1',NULL),(88,'\\core\\event\\config_log_created','core','created','config_log','config_log',630,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"dbtable\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810009,'web','0:0:0:0:0:0:0:1',NULL),(89,'\\core\\event\\config_log_created','core','created','config_log','config_log',631,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"dbpersist\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810009,'web','0:0:0:0:0:0:0:1',NULL),(90,'\\core\\event\\config_log_created','core','created','config_log','config_log',632,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"dbsocket\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810009,'web','0:0:0:0:0:0:0:1',NULL),(91,'\\core\\event\\config_log_created','core','created','config_log','config_log',633,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"dbport\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810009,'web','0:0:0:0:0:0:0:1',NULL),(92,'\\core\\event\\config_log_created','core','created','config_log','config_log',634,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"dbschema\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810009,'web','0:0:0:0:0:0:0:1',NULL),(93,'\\core\\event\\config_log_created','core','created','config_log','config_log',635,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"dbcollation\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810010,'web','0:0:0:0:0:0:0:1',NULL),(94,'\\core\\event\\config_log_created','core','created','config_log','config_log',636,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"dbhandlesoptions\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810010,'web','0:0:0:0:0:0:0:1',NULL),(95,'\\core\\event\\config_log_created','core','created','config_log','config_log',637,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"buffersize\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"50\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810010,'web','0:0:0:0:0:0:0:1',NULL),(96,'\\core\\event\\config_log_created','core','created','config_log','config_log',638,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"logguests\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810010,'web','0:0:0:0:0:0:0:1',NULL),(97,'\\core\\event\\config_log_created','core','created','config_log','config_log',639,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"includelevels\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"1,2,0\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810010,'web','0:0:0:0:0:0:0:1',NULL),(98,'\\core\\event\\config_log_created','core','created','config_log','config_log',640,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"includeactions\";s:8:\"oldvalue\";N;s:5:\"value\";s:7:\"c,r,u,d\";s:6:\"plugin\";s:17:\"logstore_database\";}',1547810010,'web','0:0:0:0:0:0:0:1',NULL),(99,'\\core\\event\\config_log_created','core','created','config_log','config_log',641,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"loglegacy\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:15:\"logstore_legacy\";}',1547810010,'web','0:0:0:0:0:0:0:1',NULL),(100,'\\core\\event\\config_log_created','core','created','config_log','config_log',642,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"logguests\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547810010,'web','0:0:0:0:0:0:0:1',NULL),(101,'\\core\\event\\config_log_created','core','created','config_log','config_log',643,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"loglifetime\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810010,'web','0:0:0:0:0:0:0:1',NULL),(102,'\\core\\event\\config_log_created','core','created','config_log','config_log',644,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"logguests\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:17:\"logstore_standard\";}',1547810010,'web','0:0:0:0:0:0:0:1',NULL),(103,'\\core\\event\\config_log_created','core','created','config_log','config_log',645,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"loglifetime\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:17:\"logstore_standard\";}',1547810010,'web','0:0:0:0:0:0:0:1',NULL),(104,'\\core\\event\\config_log_created','core','created','config_log','config_log',646,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"buffersize\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"50\";s:6:\"plugin\";s:17:\"logstore_standard\";}',1547810011,'web','0:0:0:0:0:0:0:1',NULL),(105,'\\core\\event\\config_log_created','core','created','config_log','config_log',647,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"videoextensions\";s:8:\"oldvalue\";N;s:5:\"value\";s:20:\"html_video,.f4v,.flv\";s:6:\"plugin\";s:13:\"media_videojs\";}',1547810011,'web','0:0:0:0:0:0:0:1',NULL),(106,'\\core\\event\\config_log_created','core','created','config_log','config_log',648,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"audioextensions\";s:8:\"oldvalue\";N;s:5:\"value\";s:10:\"html_audio\";s:6:\"plugin\";s:13:\"media_videojs\";}',1547810011,'web','0:0:0:0:0:0:0:1',NULL),(107,'\\core\\event\\config_log_created','core','created','config_log','config_log',649,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:4:\"rtmp\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:13:\"media_videojs\";}',1547810011,'web','0:0:0:0:0:0:0:1',NULL),(108,'\\core\\event\\config_log_created','core','created','config_log','config_log',650,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"useflash\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:13:\"media_videojs\";}',1547810011,'web','0:0:0:0:0:0:0:1',NULL),(109,'\\core\\event\\config_log_created','core','created','config_log','config_log',651,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"youtube\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:13:\"media_videojs\";}',1547810011,'web','0:0:0:0:0:0:0:1',NULL),(110,'\\core\\event\\config_log_created','core','created','config_log','config_log',652,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"videocssclass\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"video-js\";s:6:\"plugin\";s:13:\"media_videojs\";}',1547810011,'web','0:0:0:0:0:0:0:1',NULL),(111,'\\core\\event\\config_log_created','core','created','config_log','config_log',653,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"audiocssclass\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"video-js\";s:6:\"plugin\";s:13:\"media_videojs\";}',1547810011,'web','0:0:0:0:0:0:0:1',NULL),(112,'\\core\\event\\config_log_created','core','created','config_log','config_log',654,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"limitsize\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:13:\"media_videojs\";}',1547810011,'web','0:0:0:0:0:0:0:1',NULL),(113,'\\core\\event\\config_log_created','core','created','config_log','config_log',655,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"feedback_plugin_for_gradebook\";s:8:\"oldvalue\";N;s:5:\"value\";s:23:\"assignfeedback_comments\";s:6:\"plugin\";s:6:\"assign\";}',1547810011,'web','0:0:0:0:0:0:0:1',NULL),(114,'\\core\\event\\config_log_created','core','created','config_log','config_log',656,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"showrecentsubmissions\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:6:\"assign\";}',1547810011,'web','0:0:0:0:0:0:0:1',NULL),(115,'\\core\\event\\config_log_created','core','created','config_log','config_log',657,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"submissionreceipts\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:6:\"assign\";}',1547810011,'web','0:0:0:0:0:0:0:1',NULL),(116,'\\core\\event\\config_log_created','core','created','config_log','config_log',658,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"submissionstatement\";s:8:\"oldvalue\";N;s:5:\"value\";s:102:\"This assignment is my own work, except where I have acknowledged the use of the works of other people.\";s:6:\"plugin\";s:6:\"assign\";}',1547810011,'web','0:0:0:0:0:0:0:1',NULL),(117,'\\core\\event\\config_log_created','core','created','config_log','config_log',659,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"maxperpage\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"-1\";s:6:\"plugin\";s:6:\"assign\";}',1547810011,'web','0:0:0:0:0:0:0:1',NULL),(118,'\\core\\event\\config_log_created','core','created','config_log','config_log',660,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"alwaysshowdescription\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:6:\"assign\";}',1547810012,'web','0:0:0:0:0:0:0:1',NULL),(119,'\\core\\event\\config_log_created','core','created','config_log','config_log',661,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"alwaysshowdescription_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810012,'web','0:0:0:0:0:0:0:1',NULL),(120,'\\core\\event\\config_log_created','core','created','config_log','config_log',662,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"alwaysshowdescription_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810012,'web','0:0:0:0:0:0:0:1',NULL),(121,'\\core\\event\\config_log_created','core','created','config_log','config_log',663,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"allowsubmissionsfromdate\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:6:\"assign\";}',1547810012,'web','0:0:0:0:0:0:0:1',NULL),(122,'\\core\\event\\config_log_created','core','created','config_log','config_log',664,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:32:\"allowsubmissionsfromdate_enabled\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:6:\"assign\";}',1547810012,'web','0:0:0:0:0:0:0:1',NULL),(123,'\\core\\event\\config_log_created','core','created','config_log','config_log',665,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"allowsubmissionsfromdate_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810012,'web','0:0:0:0:0:0:0:1',NULL),(124,'\\core\\event\\config_log_created','core','created','config_log','config_log',666,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"duedate\";s:8:\"oldvalue\";N;s:5:\"value\";s:6:\"604800\";s:6:\"plugin\";s:6:\"assign\";}',1547810012,'web','0:0:0:0:0:0:0:1',NULL),(125,'\\core\\event\\config_log_created','core','created','config_log','config_log',667,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"duedate_enabled\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:6:\"assign\";}',1547810012,'web','0:0:0:0:0:0:0:1',NULL),(126,'\\core\\event\\config_log_created','core','created','config_log','config_log',668,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"duedate_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810012,'web','0:0:0:0:0:0:0:1',NULL),(127,'\\core\\event\\config_log_created','core','created','config_log','config_log',669,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"cutoffdate\";s:8:\"oldvalue\";N;s:5:\"value\";s:7:\"1209600\";s:6:\"plugin\";s:6:\"assign\";}',1547810012,'web','0:0:0:0:0:0:0:1',NULL),(128,'\\core\\event\\config_log_created','core','created','config_log','config_log',670,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"cutoffdate_enabled\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810012,'web','0:0:0:0:0:0:0:1',NULL),(129,'\\core\\event\\config_log_created','core','created','config_log','config_log',671,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"cutoffdate_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810012,'web','0:0:0:0:0:0:0:1',NULL),(130,'\\core\\event\\config_log_created','core','created','config_log','config_log',672,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"gradingduedate\";s:8:\"oldvalue\";N;s:5:\"value\";s:7:\"1209600\";s:6:\"plugin\";s:6:\"assign\";}',1547810012,'web','0:0:0:0:0:0:0:1',NULL),(131,'\\core\\event\\config_log_created','core','created','config_log','config_log',673,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"gradingduedate_enabled\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:6:\"assign\";}',1547810013,'web','0:0:0:0:0:0:0:1',NULL),(132,'\\core\\event\\config_log_created','core','created','config_log','config_log',674,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"gradingduedate_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810013,'web','0:0:0:0:0:0:0:1',NULL),(133,'\\core\\event\\config_log_created','core','created','config_log','config_log',675,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"submissiondrafts\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:6:\"assign\";}',1547810013,'web','0:0:0:0:0:0:0:1',NULL),(134,'\\core\\event\\config_log_created','core','created','config_log','config_log',676,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"submissiondrafts_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810013,'web','0:0:0:0:0:0:0:1',NULL),(135,'\\core\\event\\config_log_created','core','created','config_log','config_log',677,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"submissiondrafts_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810013,'web','0:0:0:0:0:0:0:1',NULL),(136,'\\core\\event\\config_log_created','core','created','config_log','config_log',678,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"requiresubmissionstatement\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:6:\"assign\";}',1547810013,'web','0:0:0:0:0:0:0:1',NULL),(137,'\\core\\event\\config_log_created','core','created','config_log','config_log',679,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:30:\"requiresubmissionstatement_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810013,'web','0:0:0:0:0:0:0:1',NULL),(138,'\\core\\event\\config_log_created','core','created','config_log','config_log',680,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:33:\"requiresubmissionstatement_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810013,'web','0:0:0:0:0:0:0:1',NULL),(139,'\\core\\event\\config_log_created','core','created','config_log','config_log',681,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"attemptreopenmethod\";s:8:\"oldvalue\";N;s:5:\"value\";s:4:\"none\";s:6:\"plugin\";s:6:\"assign\";}',1547810014,'web','0:0:0:0:0:0:0:1',NULL),(140,'\\core\\event\\config_log_created','core','created','config_log','config_log',682,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"attemptreopenmethod_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810014,'web','0:0:0:0:0:0:0:1',NULL),(141,'\\core\\event\\config_log_created','core','created','config_log','config_log',683,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"attemptreopenmethod_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810014,'web','0:0:0:0:0:0:0:1',NULL),(142,'\\core\\event\\config_log_created','core','created','config_log','config_log',684,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"maxattempts\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"-1\";s:6:\"plugin\";s:6:\"assign\";}',1547810014,'web','0:0:0:0:0:0:0:1',NULL),(143,'\\core\\event\\config_log_created','core','created','config_log','config_log',685,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"maxattempts_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810014,'web','0:0:0:0:0:0:0:1',NULL),(144,'\\core\\event\\config_log_created','core','created','config_log','config_log',686,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"maxattempts_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810014,'web','0:0:0:0:0:0:0:1',NULL),(145,'\\core\\event\\config_log_created','core','created','config_log','config_log',687,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"teamsubmission\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:6:\"assign\";}',1547810014,'web','0:0:0:0:0:0:0:1',NULL),(146,'\\core\\event\\config_log_created','core','created','config_log','config_log',688,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"teamsubmission_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810014,'web','0:0:0:0:0:0:0:1',NULL),(147,'\\core\\event\\config_log_created','core','created','config_log','config_log',689,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"teamsubmission_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810014,'web','0:0:0:0:0:0:0:1',NULL),(148,'\\core\\event\\config_log_created','core','created','config_log','config_log',690,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"preventsubmissionnotingroup\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:6:\"assign\";}',1547810014,'web','0:0:0:0:0:0:0:1',NULL),(149,'\\core\\event\\config_log_created','core','created','config_log','config_log',691,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:31:\"preventsubmissionnotingroup_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810014,'web','0:0:0:0:0:0:0:1',NULL),(150,'\\core\\event\\config_log_created','core','created','config_log','config_log',692,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:34:\"preventsubmissionnotingroup_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810014,'web','0:0:0:0:0:0:0:1',NULL),(151,'\\core\\event\\config_log_created','core','created','config_log','config_log',693,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"requireallteammemberssubmit\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:6:\"assign\";}',1547810014,'web','0:0:0:0:0:0:0:1',NULL),(152,'\\core\\event\\config_log_created','core','created','config_log','config_log',694,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:31:\"requireallteammemberssubmit_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810015,'web','0:0:0:0:0:0:0:1',NULL),(153,'\\core\\event\\config_log_created','core','created','config_log','config_log',695,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:34:\"requireallteammemberssubmit_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810015,'web','0:0:0:0:0:0:0:1',NULL),(154,'\\core\\event\\config_log_created','core','created','config_log','config_log',696,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"teamsubmissiongroupingid\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810015,'web','0:0:0:0:0:0:0:1',NULL),(155,'\\core\\event\\config_log_created','core','created','config_log','config_log',697,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"teamsubmissiongroupingid_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810015,'web','0:0:0:0:0:0:0:1',NULL),(156,'\\core\\event\\config_log_created','core','created','config_log','config_log',698,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"sendnotifications\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:6:\"assign\";}',1547810015,'web','0:0:0:0:0:0:0:1',NULL),(157,'\\core\\event\\config_log_created','core','created','config_log','config_log',699,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"sendnotifications_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810015,'web','0:0:0:0:0:0:0:1',NULL),(158,'\\core\\event\\config_log_created','core','created','config_log','config_log',700,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"sendnotifications_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810015,'web','0:0:0:0:0:0:0:1',NULL),(159,'\\core\\event\\config_log_created','core','created','config_log','config_log',701,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"sendlatenotifications\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:6:\"assign\";}',1547810015,'web','0:0:0:0:0:0:0:1',NULL),(160,'\\core\\event\\config_log_created','core','created','config_log','config_log',702,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"sendlatenotifications_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810015,'web','0:0:0:0:0:0:0:1',NULL),(161,'\\core\\event\\config_log_created','core','created','config_log','config_log',703,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"sendlatenotifications_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810015,'web','0:0:0:0:0:0:0:1',NULL),(162,'\\core\\event\\config_log_created','core','created','config_log','config_log',704,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"sendstudentnotifications\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:6:\"assign\";}',1547810015,'web','0:0:0:0:0:0:0:1',NULL),(163,'\\core\\event\\config_log_created','core','created','config_log','config_log',705,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"sendstudentnotifications_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810016,'web','0:0:0:0:0:0:0:1',NULL),(164,'\\core\\event\\config_log_created','core','created','config_log','config_log',706,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:31:\"sendstudentnotifications_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810016,'web','0:0:0:0:0:0:0:1',NULL),(165,'\\core\\event\\config_log_created','core','created','config_log','config_log',707,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"blindmarking\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:6:\"assign\";}',1547810016,'web','0:0:0:0:0:0:0:1',NULL),(166,'\\core\\event\\config_log_created','core','created','config_log','config_log',708,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"blindmarking_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810016,'web','0:0:0:0:0:0:0:1',NULL),(167,'\\core\\event\\config_log_created','core','created','config_log','config_log',709,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"blindmarking_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810016,'web','0:0:0:0:0:0:0:1',NULL),(168,'\\core\\event\\config_log_created','core','created','config_log','config_log',710,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"markingworkflow\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:6:\"assign\";}',1547810016,'web','0:0:0:0:0:0:0:1',NULL),(169,'\\core\\event\\config_log_created','core','created','config_log','config_log',711,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"markingworkflow_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810016,'web','0:0:0:0:0:0:0:1',NULL),(170,'\\core\\event\\config_log_created','core','created','config_log','config_log',712,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"markingworkflow_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810016,'web','0:0:0:0:0:0:0:1',NULL),(171,'\\core\\event\\config_log_created','core','created','config_log','config_log',713,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"markingallocation\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:6:\"assign\";}',1547810016,'web','0:0:0:0:0:0:0:1',NULL),(172,'\\core\\event\\config_log_created','core','created','config_log','config_log',714,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"markingallocation_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810016,'web','0:0:0:0:0:0:0:1',NULL),(173,'\\core\\event\\config_log_created','core','created','config_log','config_log',715,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"markingallocation_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:6:\"assign\";}',1547810016,'web','0:0:0:0:0:0:0:1',NULL),(174,'\\core\\event\\config_log_created','core','created','config_log','config_log',716,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"default\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:21:\"assignsubmission_file\";}',1547810016,'web','0:0:0:0:0:0:0:1',NULL),(175,'\\core\\event\\config_log_created','core','created','config_log','config_log',717,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"maxfiles\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"20\";s:6:\"plugin\";s:21:\"assignsubmission_file\";}',1547810017,'web','0:0:0:0:0:0:0:1',NULL),(176,'\\core\\event\\config_log_created','core','created','config_log','config_log',718,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"filetypes\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:21:\"assignsubmission_file\";}',1547810017,'web','0:0:0:0:0:0:0:1',NULL),(177,'\\core\\event\\config_log_created','core','created','config_log','config_log',719,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"maxbytes\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:21:\"assignsubmission_file\";}',1547810017,'web','0:0:0:0:0:0:0:1',NULL),(178,'\\core\\event\\config_log_created','core','created','config_log','config_log',720,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"default\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:27:\"assignsubmission_onlinetext\";}',1547810017,'web','0:0:0:0:0:0:0:1',NULL),(179,'\\core\\event\\config_log_created','core','created','config_log','config_log',721,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"default\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:23:\"assignfeedback_comments\";}',1547810017,'web','0:0:0:0:0:0:0:1',NULL),(180,'\\core\\event\\config_log_created','core','created','config_log','config_log',722,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"inline\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:23:\"assignfeedback_comments\";}',1547810017,'web','0:0:0:0:0:0:0:1',NULL),(181,'\\core\\event\\config_log_created','core','created','config_log','config_log',723,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"inline_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:23:\"assignfeedback_comments\";}',1547810017,'web','0:0:0:0:0:0:0:1',NULL),(182,'\\core\\event\\config_log_created','core','created','config_log','config_log',724,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"inline_locked\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:23:\"assignfeedback_comments\";}',1547810017,'web','0:0:0:0:0:0:0:1',NULL),(183,'\\core\\event\\config_log_created','core','created','config_log','config_log',725,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"default\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:22:\"assignfeedback_editpdf\";}',1547810017,'web','0:0:0:0:0:0:0:1',NULL),(184,'\\core\\event\\config_log_created','core','created','config_log','config_log',726,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"stamps\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:22:\"assignfeedback_editpdf\";}',1547810017,'web','0:0:0:0:0:0:0:1',NULL),(185,'\\core\\event\\config_log_created','core','created','config_log','config_log',727,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"default\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"assignfeedback_file\";}',1547810017,'web','0:0:0:0:0:0:0:1',NULL),(186,'\\core\\event\\config_log_created','core','created','config_log','config_log',728,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"default\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:22:\"assignfeedback_offline\";}',1547810017,'web','0:0:0:0:0:0:0:1',NULL),(187,'\\core\\event\\config_log_created','core','created','config_log','config_log',729,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"numberingoptions\";s:8:\"oldvalue\";N;s:5:\"value\";s:7:\"0,1,2,3\";s:6:\"plugin\";s:4:\"book\";}',1547810017,'web','0:0:0:0:0:0:0:1',NULL),(188,'\\core\\event\\config_log_created','core','created','config_log','config_log',730,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"navoptions\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"0,1,2\";s:6:\"plugin\";s:4:\"book\";}',1547810017,'web','0:0:0:0:0:0:0:1',NULL),(189,'\\core\\event\\config_log_created','core','created','config_log','config_log',731,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"numbering\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"book\";}',1547810018,'web','0:0:0:0:0:0:0:1',NULL),(190,'\\core\\event\\config_log_created','core','created','config_log','config_log',732,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"navstyle\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"book\";}',1547810018,'web','0:0:0:0:0:0:0:1',NULL),(191,'\\core\\event\\config_log_created','core','created','config_log','config_log',733,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"data_enablerssfeeds\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810018,'web','0:0:0:0:0:0:0:1',NULL),(192,'\\core\\event\\config_log_created','core','created','config_log','config_log',734,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"feedback_allowfullanonymous\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810018,'web','0:0:0:0:0:0:0:1',NULL),(193,'\\core\\event\\config_log_created','core','created','config_log','config_log',735,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"framesize\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"130\";s:6:\"plugin\";s:8:\"resource\";}',1547810018,'web','0:0:0:0:0:0:0:1',NULL),(194,'\\core\\event\\config_log_created','core','created','config_log','config_log',736,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"displayoptions\";s:8:\"oldvalue\";N;s:5:\"value\";s:9:\"0,1,4,5,6\";s:6:\"plugin\";s:8:\"resource\";}',1547810018,'web','0:0:0:0:0:0:0:1',NULL),(195,'\\core\\event\\config_log_created','core','created','config_log','config_log',737,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"printintro\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:8:\"resource\";}',1547810018,'web','0:0:0:0:0:0:0:1',NULL),(196,'\\core\\event\\config_log_created','core','created','config_log','config_log',738,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"display\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"resource\";}',1547810018,'web','0:0:0:0:0:0:0:1',NULL),(197,'\\core\\event\\config_log_created','core','created','config_log','config_log',739,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"showsize\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"resource\";}',1547810018,'web','0:0:0:0:0:0:0:1',NULL),(198,'\\core\\event\\config_log_created','core','created','config_log','config_log',740,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"showtype\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"resource\";}',1547810018,'web','0:0:0:0:0:0:0:1',NULL),(199,'\\core\\event\\config_log_created','core','created','config_log','config_log',741,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"showdate\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"resource\";}',1547810018,'web','0:0:0:0:0:0:0:1',NULL),(200,'\\core\\event\\config_log_created','core','created','config_log','config_log',742,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"popupwidth\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"620\";s:6:\"plugin\";s:8:\"resource\";}',1547810018,'web','0:0:0:0:0:0:0:1',NULL),(201,'\\core\\event\\config_log_created','core','created','config_log','config_log',743,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"popupheight\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"450\";s:6:\"plugin\";s:8:\"resource\";}',1547810018,'web','0:0:0:0:0:0:0:1',NULL),(202,'\\core\\event\\config_log_created','core','created','config_log','config_log',744,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"filterfiles\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"resource\";}',1547810019,'web','0:0:0:0:0:0:0:1',NULL),(203,'\\core\\event\\config_log_created','core','created','config_log','config_log',745,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"showexpanded\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:6:\"folder\";}',1547810019,'web','0:0:0:0:0:0:0:1',NULL),(204,'\\core\\event\\config_log_created','core','created','config_log','config_log',746,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"maxsizetodownload\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:6:\"folder\";}',1547810019,'web','0:0:0:0:0:0:0:1',NULL),(205,'\\core\\event\\config_log_created','core','created','config_log','config_log',747,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"forum_displaymode\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"3\";s:6:\"plugin\";N;}',1547810019,'web','0:0:0:0:0:0:0:1',NULL),(206,'\\core\\event\\config_log_created','core','created','config_log','config_log',748,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"forum_shortpost\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"300\";s:6:\"plugin\";N;}',1547810019,'web','0:0:0:0:0:0:0:1',NULL),(207,'\\core\\event\\config_log_created','core','created','config_log','config_log',749,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"forum_longpost\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"600\";s:6:\"plugin\";N;}',1547810019,'web','0:0:0:0:0:0:0:1',NULL),(208,'\\core\\event\\config_log_created','core','created','config_log','config_log',750,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"forum_manydiscussions\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"100\";s:6:\"plugin\";N;}',1547810019,'web','0:0:0:0:0:0:0:1',NULL),(209,'\\core\\event\\config_log_created','core','created','config_log','config_log',751,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"forum_maxbytes\";s:8:\"oldvalue\";N;s:5:\"value\";s:6:\"512000\";s:6:\"plugin\";N;}',1547810019,'web','0:0:0:0:0:0:0:1',NULL),(210,'\\core\\event\\config_log_created','core','created','config_log','config_log',752,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"forum_maxattachments\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"9\";s:6:\"plugin\";N;}',1547810019,'web','0:0:0:0:0:0:0:1',NULL),(211,'\\core\\event\\config_log_created','core','created','config_log','config_log',753,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"forum_subscription\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810019,'web','0:0:0:0:0:0:0:1',NULL),(212,'\\core\\event\\config_log_created','core','created','config_log','config_log',754,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"forum_trackingtype\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547810019,'web','0:0:0:0:0:0:0:1',NULL),(213,'\\core\\event\\config_log_created','core','created','config_log','config_log',755,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"forum_trackreadposts\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547810019,'web','0:0:0:0:0:0:0:1',NULL),(214,'\\core\\event\\config_log_created','core','created','config_log','config_log',756,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"forum_allowforcedreadtracking\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810020,'web','0:0:0:0:0:0:0:1',NULL),(215,'\\core\\event\\config_log_created','core','created','config_log','config_log',757,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"forum_oldpostdays\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"14\";s:6:\"plugin\";N;}',1547810020,'web','0:0:0:0:0:0:0:1',NULL),(216,'\\core\\event\\config_log_created','core','created','config_log','config_log',758,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"forum_usermarksread\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810020,'web','0:0:0:0:0:0:0:1',NULL),(217,'\\core\\event\\config_log_created','core','created','config_log','config_log',759,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"forum_cleanreadtime\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"2\";s:6:\"plugin\";N;}',1547810020,'web','0:0:0:0:0:0:0:1',NULL),(218,'\\core\\event\\config_log_created','core','created','config_log','config_log',760,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"digestmailtime\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"17\";s:6:\"plugin\";N;}',1547810020,'web','0:0:0:0:0:0:0:1',NULL),(219,'\\core\\event\\config_log_created','core','created','config_log','config_log',761,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"forum_enablerssfeeds\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810020,'web','0:0:0:0:0:0:0:1',NULL),(220,'\\core\\event\\config_log_created','core','created','config_log','config_log',762,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"forum_enabletimedposts\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547810020,'web','0:0:0:0:0:0:0:1',NULL),(221,'\\core\\event\\config_log_created','core','created','config_log','config_log',763,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"glossary_entbypage\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"10\";s:6:\"plugin\";N;}',1547810020,'web','0:0:0:0:0:0:0:1',NULL),(222,'\\core\\event\\config_log_created','core','created','config_log','config_log',764,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"glossary_dupentries\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810020,'web','0:0:0:0:0:0:0:1',NULL),(223,'\\core\\event\\config_log_created','core','created','config_log','config_log',765,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"glossary_allowcomments\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810020,'web','0:0:0:0:0:0:0:1',NULL),(224,'\\core\\event\\config_log_created','core','created','config_log','config_log',766,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"glossary_linkbydefault\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547810020,'web','0:0:0:0:0:0:0:1',NULL),(225,'\\core\\event\\config_log_created','core','created','config_log','config_log',767,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"glossary_defaultapproval\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547810020,'web','0:0:0:0:0:0:0:1',NULL),(226,'\\core\\event\\config_log_created','core','created','config_log','config_log',768,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"glossary_enablerssfeeds\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810021,'web','0:0:0:0:0:0:0:1',NULL),(227,'\\core\\event\\config_log_created','core','created','config_log','config_log',769,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"glossary_linkentries\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810021,'web','0:0:0:0:0:0:0:1',NULL),(228,'\\core\\event\\config_log_created','core','created','config_log','config_log',770,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"glossary_casesensitive\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810021,'web','0:0:0:0:0:0:0:1',NULL),(229,'\\core\\event\\config_log_created','core','created','config_log','config_log',771,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"glossary_fullmatch\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810021,'web','0:0:0:0:0:0:0:1',NULL),(230,'\\core\\event\\config_log_created','core','created','config_log','config_log',772,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"keepold\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"imscp\";}',1547810021,'web','0:0:0:0:0:0:0:1',NULL),(231,'\\core\\event\\config_log_created','core','created','config_log','config_log',773,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"keepold_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:5:\"imscp\";}',1547810021,'web','0:0:0:0:0:0:0:1',NULL),(232,'\\core\\event\\config_log_created','core','created','config_log','config_log',774,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"timelimit\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:4:\"quiz\";}',1547810021,'web','0:0:0:0:0:0:0:1',NULL),(233,'\\core\\event\\config_log_created','core','created','config_log','config_log',775,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"timelimit_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:4:\"quiz\";}',1547810021,'web','0:0:0:0:0:0:0:1',NULL),(234,'\\core\\event\\config_log_created','core','created','config_log','config_log',776,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"overduehandling\";s:8:\"oldvalue\";N;s:5:\"value\";s:10:\"autosubmit\";s:6:\"plugin\";s:4:\"quiz\";}',1547810021,'web','0:0:0:0:0:0:0:1',NULL),(235,'\\core\\event\\config_log_created','core','created','config_log','config_log',777,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"overduehandling_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:4:\"quiz\";}',1547810021,'web','0:0:0:0:0:0:0:1',NULL),(236,'\\core\\event\\config_log_created','core','created','config_log','config_log',778,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"graceperiod\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"86400\";s:6:\"plugin\";s:4:\"quiz\";}',1547810022,'web','0:0:0:0:0:0:0:1',NULL),(237,'\\core\\event\\config_log_created','core','created','config_log','config_log',779,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"graceperiod_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:4:\"quiz\";}',1547810022,'web','0:0:0:0:0:0:0:1',NULL),(238,'\\core\\event\\config_log_created','core','created','config_log','config_log',780,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"graceperiodmin\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"60\";s:6:\"plugin\";s:4:\"quiz\";}',1547810022,'web','0:0:0:0:0:0:0:1',NULL),(239,'\\core\\event\\config_log_created','core','created','config_log','config_log',781,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"attempts\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:4:\"quiz\";}',1547810022,'web','0:0:0:0:0:0:0:1',NULL),(240,'\\core\\event\\config_log_created','core','created','config_log','config_log',782,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"attempts_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:4:\"quiz\";}',1547810022,'web','0:0:0:0:0:0:0:1',NULL),(241,'\\core\\event\\config_log_created','core','created','config_log','config_log',783,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"grademethod\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"quiz\";}',1547810022,'web','0:0:0:0:0:0:0:1',NULL),(242,'\\core\\event\\config_log_created','core','created','config_log','config_log',784,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"grademethod_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:4:\"quiz\";}',1547810022,'web','0:0:0:0:0:0:0:1',NULL),(243,'\\core\\event\\config_log_created','core','created','config_log','config_log',785,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"maximumgrade\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"10\";s:6:\"plugin\";s:4:\"quiz\";}',1547810022,'web','0:0:0:0:0:0:0:1',NULL),(244,'\\core\\event\\config_log_created','core','created','config_log','config_log',786,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"questionsperpage\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"quiz\";}',1547810022,'web','0:0:0:0:0:0:0:1',NULL),(245,'\\core\\event\\config_log_created','core','created','config_log','config_log',787,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"questionsperpage_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:4:\"quiz\";}',1547810022,'web','0:0:0:0:0:0:0:1',NULL),(246,'\\core\\event\\config_log_created','core','created','config_log','config_log',788,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"navmethod\";s:8:\"oldvalue\";N;s:5:\"value\";s:4:\"free\";s:6:\"plugin\";s:4:\"quiz\";}',1547810022,'web','0:0:0:0:0:0:0:1',NULL),(247,'\\core\\event\\config_log_created','core','created','config_log','config_log',789,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"navmethod_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"quiz\";}',1547810022,'web','0:0:0:0:0:0:0:1',NULL),(248,'\\core\\event\\config_log_created','core','created','config_log','config_log',790,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"shuffleanswers\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"quiz\";}',1547810022,'web','0:0:0:0:0:0:0:1',NULL),(249,'\\core\\event\\config_log_created','core','created','config_log','config_log',791,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"shuffleanswers_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:4:\"quiz\";}',1547810023,'web','0:0:0:0:0:0:0:1',NULL),(250,'\\core\\event\\config_log_created','core','created','config_log','config_log',792,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"preferredbehaviour\";s:8:\"oldvalue\";N;s:5:\"value\";s:16:\"deferredfeedback\";s:6:\"plugin\";s:4:\"quiz\";}',1547810023,'web','0:0:0:0:0:0:0:1',NULL),(251,'\\core\\event\\config_log_created','core','created','config_log','config_log',793,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"canredoquestions\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:4:\"quiz\";}',1547810023,'web','0:0:0:0:0:0:0:1',NULL),(252,'\\core\\event\\config_log_created','core','created','config_log','config_log',794,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"canredoquestions_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"quiz\";}',1547810023,'web','0:0:0:0:0:0:0:1',NULL),(253,'\\core\\event\\config_log_created','core','created','config_log','config_log',795,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"attemptonlast\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:4:\"quiz\";}',1547810023,'web','0:0:0:0:0:0:0:1',NULL),(254,'\\core\\event\\config_log_created','core','created','config_log','config_log',796,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"attemptonlast_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"quiz\";}',1547810023,'web','0:0:0:0:0:0:0:1',NULL),(255,'\\core\\event\\config_log_created','core','created','config_log','config_log',797,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"reviewattempt\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"69904\";s:6:\"plugin\";s:4:\"quiz\";}',1547810023,'web','0:0:0:0:0:0:0:1',NULL),(256,'\\core\\event\\config_log_created','core','created','config_log','config_log',798,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"reviewcorrectness\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"69904\";s:6:\"plugin\";s:4:\"quiz\";}',1547810023,'web','0:0:0:0:0:0:0:1',NULL),(257,'\\core\\event\\config_log_created','core','created','config_log','config_log',799,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"reviewmarks\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"69904\";s:6:\"plugin\";s:4:\"quiz\";}',1547810023,'web','0:0:0:0:0:0:0:1',NULL),(258,'\\core\\event\\config_log_created','core','created','config_log','config_log',800,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"reviewspecificfeedback\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"69904\";s:6:\"plugin\";s:4:\"quiz\";}',1547810023,'web','0:0:0:0:0:0:0:1',NULL),(259,'\\core\\event\\config_log_created','core','created','config_log','config_log',801,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"reviewgeneralfeedback\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"69904\";s:6:\"plugin\";s:4:\"quiz\";}',1547810024,'web','0:0:0:0:0:0:0:1',NULL),(260,'\\core\\event\\config_log_created','core','created','config_log','config_log',802,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"reviewrightanswer\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"69904\";s:6:\"plugin\";s:4:\"quiz\";}',1547810024,'web','0:0:0:0:0:0:0:1',NULL),(261,'\\core\\event\\config_log_created','core','created','config_log','config_log',803,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"reviewoverallfeedback\";s:8:\"oldvalue\";N;s:5:\"value\";s:4:\"4368\";s:6:\"plugin\";s:4:\"quiz\";}',1547810024,'web','0:0:0:0:0:0:0:1',NULL),(262,'\\core\\event\\config_log_created','core','created','config_log','config_log',804,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"showuserpicture\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:4:\"quiz\";}',1547810024,'web','0:0:0:0:0:0:0:1',NULL),(263,'\\core\\event\\config_log_created','core','created','config_log','config_log',805,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"showuserpicture_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:4:\"quiz\";}',1547810024,'web','0:0:0:0:0:0:0:1',NULL),(264,'\\core\\event\\config_log_created','core','created','config_log','config_log',806,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"decimalpoints\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"2\";s:6:\"plugin\";s:4:\"quiz\";}',1547810024,'web','0:0:0:0:0:0:0:1',NULL),(265,'\\core\\event\\config_log_created','core','created','config_log','config_log',807,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"decimalpoints_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:4:\"quiz\";}',1547810024,'web','0:0:0:0:0:0:0:1',NULL),(266,'\\core\\event\\config_log_created','core','created','config_log','config_log',808,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"questiondecimalpoints\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"-1\";s:6:\"plugin\";s:4:\"quiz\";}',1547810024,'web','0:0:0:0:0:0:0:1',NULL),(267,'\\core\\event\\config_log_created','core','created','config_log','config_log',809,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"questiondecimalpoints_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"quiz\";}',1547810024,'web','0:0:0:0:0:0:0:1',NULL),(268,'\\core\\event\\config_log_created','core','created','config_log','config_log',810,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"showblocks\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:4:\"quiz\";}',1547810024,'web','0:0:0:0:0:0:0:1',NULL),(269,'\\core\\event\\config_log_created','core','created','config_log','config_log',811,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"showblocks_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"quiz\";}',1547810024,'web','0:0:0:0:0:0:0:1',NULL),(270,'\\core\\event\\config_log_created','core','created','config_log','config_log',812,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"password\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:4:\"quiz\";}',1547810024,'web','0:0:0:0:0:0:0:1',NULL),(271,'\\core\\event\\config_log_created','core','created','config_log','config_log',813,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"password_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:4:\"quiz\";}',1547810025,'web','0:0:0:0:0:0:0:1',NULL),(272,'\\core\\event\\config_log_created','core','created','config_log','config_log',814,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"subnet\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:4:\"quiz\";}',1547810025,'web','0:0:0:0:0:0:0:1',NULL),(273,'\\core\\event\\config_log_created','core','created','config_log','config_log',815,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"subnet_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"quiz\";}',1547810025,'web','0:0:0:0:0:0:0:1',NULL),(274,'\\core\\event\\config_log_created','core','created','config_log','config_log',816,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"delay1\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:4:\"quiz\";}',1547810025,'web','0:0:0:0:0:0:0:1',NULL),(275,'\\core\\event\\config_log_created','core','created','config_log','config_log',817,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"delay1_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"quiz\";}',1547810025,'web','0:0:0:0:0:0:0:1',NULL),(276,'\\core\\event\\config_log_created','core','created','config_log','config_log',818,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"delay2\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:4:\"quiz\";}',1547810025,'web','0:0:0:0:0:0:0:1',NULL),(277,'\\core\\event\\config_log_created','core','created','config_log','config_log',819,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"delay2_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"quiz\";}',1547810025,'web','0:0:0:0:0:0:0:1',NULL),(278,'\\core\\event\\config_log_created','core','created','config_log','config_log',820,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"browsersecurity\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"-\";s:6:\"plugin\";s:4:\"quiz\";}',1547810025,'web','0:0:0:0:0:0:0:1',NULL),(279,'\\core\\event\\config_log_created','core','created','config_log','config_log',821,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"browsersecurity_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"quiz\";}',1547810025,'web','0:0:0:0:0:0:0:1',NULL),(280,'\\core\\event\\config_log_created','core','created','config_log','config_log',822,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"initialnumfeedbacks\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"2\";s:6:\"plugin\";s:4:\"quiz\";}',1547810025,'web','0:0:0:0:0:0:0:1',NULL),(281,'\\core\\event\\config_log_created','core','created','config_log','config_log',823,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"autosaveperiod\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"60\";s:6:\"plugin\";s:4:\"quiz\";}',1547810026,'web','0:0:0:0:0:0:0:1',NULL),(282,'\\core\\event\\config_log_created','core','created','config_log','config_log',824,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"dndmedia\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"label\";}',1547810026,'web','0:0:0:0:0:0:0:1',NULL),(283,'\\core\\event\\config_log_created','core','created','config_log','config_log',825,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"dndresizewidth\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"400\";s:6:\"plugin\";s:5:\"label\";}',1547810026,'web','0:0:0:0:0:0:0:1',NULL),(284,'\\core\\event\\config_log_created','core','created','config_log','config_log',826,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"dndresizeheight\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"400\";s:6:\"plugin\";s:5:\"label\";}',1547810026,'web','0:0:0:0:0:0:0:1',NULL),(285,'\\core\\event\\config_log_created','core','created','config_log','config_log',827,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"chat_method\";s:8:\"oldvalue\";N;s:5:\"value\";s:4:\"ajax\";s:6:\"plugin\";N;}',1547810026,'web','0:0:0:0:0:0:0:1',NULL),(286,'\\core\\event\\config_log_created','core','created','config_log','config_log',828,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"chat_refresh_userlist\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"10\";s:6:\"plugin\";N;}',1547810026,'web','0:0:0:0:0:0:0:1',NULL),(287,'\\core\\event\\config_log_created','core','created','config_log','config_log',829,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"chat_old_ping\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"35\";s:6:\"plugin\";N;}',1547810026,'web','0:0:0:0:0:0:0:1',NULL),(288,'\\core\\event\\config_log_created','core','created','config_log','config_log',830,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"chat_refresh_room\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";N;}',1547810026,'web','0:0:0:0:0:0:0:1',NULL),(289,'\\core\\event\\config_log_created','core','created','config_log','config_log',831,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"chat_normal_updatemode\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"jsupdate\";s:6:\"plugin\";N;}',1547810026,'web','0:0:0:0:0:0:0:1',NULL),(290,'\\core\\event\\config_log_created','core','created','config_log','config_log',832,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"chat_serverhost\";s:8:\"oldvalue\";N;s:5:\"value\";s:9:\"localhost\";s:6:\"plugin\";N;}',1547810026,'web','0:0:0:0:0:0:0:1',NULL),(291,'\\core\\event\\config_log_created','core','created','config_log','config_log',833,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"chat_serverip\";s:8:\"oldvalue\";N;s:5:\"value\";s:9:\"127.0.0.1\";s:6:\"plugin\";N;}',1547810027,'web','0:0:0:0:0:0:0:1',NULL),(292,'\\core\\event\\config_log_created','core','created','config_log','config_log',834,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"chat_serverport\";s:8:\"oldvalue\";N;s:5:\"value\";s:4:\"9111\";s:6:\"plugin\";N;}',1547810027,'web','0:0:0:0:0:0:0:1',NULL),(293,'\\core\\event\\config_log_created','core','created','config_log','config_log',835,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"chat_servermax\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"100\";s:6:\"plugin\";N;}',1547810027,'web','0:0:0:0:0:0:0:1',NULL),(294,'\\core\\event\\config_log_created','core','created','config_log','config_log',836,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"displayoptions\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:4:\"page\";}',1547810027,'web','0:0:0:0:0:0:0:1',NULL),(295,'\\core\\event\\config_log_created','core','created','config_log','config_log',837,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"printheading\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"page\";}',1547810027,'web','0:0:0:0:0:0:0:1',NULL),(296,'\\core\\event\\config_log_created','core','created','config_log','config_log',838,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"printintro\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:4:\"page\";}',1547810027,'web','0:0:0:0:0:0:0:1',NULL),(297,'\\core\\event\\config_log_created','core','created','config_log','config_log',839,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"printlastmodified\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:4:\"page\";}',1547810027,'web','0:0:0:0:0:0:0:1',NULL),(298,'\\core\\event\\config_log_created','core','created','config_log','config_log',840,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"display\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:4:\"page\";}',1547810027,'web','0:0:0:0:0:0:0:1',NULL),(299,'\\core\\event\\config_log_created','core','created','config_log','config_log',841,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"popupwidth\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"620\";s:6:\"plugin\";s:4:\"page\";}',1547810027,'web','0:0:0:0:0:0:0:1',NULL),(300,'\\core\\event\\config_log_created','core','created','config_log','config_log',842,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"popupheight\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"450\";s:6:\"plugin\";s:4:\"page\";}',1547810027,'web','0:0:0:0:0:0:0:1',NULL),(301,'\\core\\event\\config_log_created','core','created','config_log','config_log',843,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"mediafile\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810027,'web','0:0:0:0:0:0:0:1',NULL),(302,'\\core\\event\\config_log_created','core','created','config_log','config_log',844,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"mediafile_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810028,'web','0:0:0:0:0:0:0:1',NULL),(303,'\\core\\event\\config_log_created','core','created','config_log','config_log',845,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"mediawidth\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"640\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810028,'web','0:0:0:0:0:0:0:1',NULL),(304,'\\core\\event\\config_log_created','core','created','config_log','config_log',846,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"mediaheight\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"480\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810028,'web','0:0:0:0:0:0:0:1',NULL),(305,'\\core\\event\\config_log_created','core','created','config_log','config_log',847,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"mediaclose\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810028,'web','0:0:0:0:0:0:0:1',NULL),(306,'\\core\\event\\config_log_created','core','created','config_log','config_log',848,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"progressbar\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810028,'web','0:0:0:0:0:0:0:1',NULL),(307,'\\core\\event\\config_log_created','core','created','config_log','config_log',849,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"progressbar_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810028,'web','0:0:0:0:0:0:0:1',NULL),(308,'\\core\\event\\config_log_created','core','created','config_log','config_log',850,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"ongoing\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810028,'web','0:0:0:0:0:0:0:1',NULL),(309,'\\core\\event\\config_log_created','core','created','config_log','config_log',851,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"ongoing_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810028,'web','0:0:0:0:0:0:0:1',NULL),(310,'\\core\\event\\config_log_created','core','created','config_log','config_log',852,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"displayleftmenu\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810028,'web','0:0:0:0:0:0:0:1',NULL),(311,'\\core\\event\\config_log_created','core','created','config_log','config_log',853,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"displayleftmenu_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(312,'\\core\\event\\config_log_created','core','created','config_log','config_log',854,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"displayleftif\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(313,'\\core\\event\\config_log_created','core','created','config_log','config_log',855,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"displayleftif_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(314,'\\core\\event\\config_log_created','core','created','config_log','config_log',856,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"slideshow\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(315,'\\core\\event\\config_log_created','core','created','config_log','config_log',857,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"slideshow_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(316,'\\core\\event\\config_log_created','core','created','config_log','config_log',858,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"slideshowwidth\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"640\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(317,'\\core\\event\\config_log_created','core','created','config_log','config_log',859,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"slideshowheight\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"480\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(318,'\\core\\event\\config_log_created','core','created','config_log','config_log',860,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"slideshowbgcolor\";s:8:\"oldvalue\";N;s:5:\"value\";s:7:\"#FFFFFF\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(319,'\\core\\event\\config_log_created','core','created','config_log','config_log',861,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"maxanswers\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(320,'\\core\\event\\config_log_created','core','created','config_log','config_log',862,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"maxanswers_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(321,'\\core\\event\\config_log_created','core','created','config_log','config_log',863,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"defaultfeedback\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(322,'\\core\\event\\config_log_created','core','created','config_log','config_log',864,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"defaultfeedback_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(323,'\\core\\event\\config_log_created','core','created','config_log','config_log',865,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"activitylink\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(324,'\\core\\event\\config_log_created','core','created','config_log','config_log',866,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"activitylink_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(325,'\\core\\event\\config_log_created','core','created','config_log','config_log',867,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"timelimit\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810029,'web','0:0:0:0:0:0:0:1',NULL),(326,'\\core\\event\\config_log_created','core','created','config_log','config_log',868,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"timelimit_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810030,'web','0:0:0:0:0:0:0:1',NULL),(327,'\\core\\event\\config_log_created','core','created','config_log','config_log',869,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"password\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810030,'web','0:0:0:0:0:0:0:1',NULL),(328,'\\core\\event\\config_log_created','core','created','config_log','config_log',870,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"password_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810030,'web','0:0:0:0:0:0:0:1',NULL),(329,'\\core\\event\\config_log_created','core','created','config_log','config_log',871,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"modattempts\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810030,'web','0:0:0:0:0:0:0:1',NULL),(330,'\\core\\event\\config_log_created','core','created','config_log','config_log',872,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"modattempts_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810030,'web','0:0:0:0:0:0:0:1',NULL),(331,'\\core\\event\\config_log_created','core','created','config_log','config_log',873,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"displayreview\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810030,'web','0:0:0:0:0:0:0:1',NULL),(332,'\\core\\event\\config_log_created','core','created','config_log','config_log',874,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"displayreview_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810031,'web','0:0:0:0:0:0:0:1',NULL),(333,'\\core\\event\\config_log_created','core','created','config_log','config_log',875,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"maximumnumberofattempts\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810031,'web','0:0:0:0:0:0:0:1',NULL),(334,'\\core\\event\\config_log_created','core','created','config_log','config_log',876,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"maximumnumberofattempts_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810031,'web','0:0:0:0:0:0:0:1',NULL),(335,'\\core\\event\\config_log_created','core','created','config_log','config_log',877,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"defaultnextpage\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810031,'web','0:0:0:0:0:0:0:1',NULL),(336,'\\core\\event\\config_log_created','core','created','config_log','config_log',878,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"defaultnextpage_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810031,'web','0:0:0:0:0:0:0:1',NULL),(337,'\\core\\event\\config_log_created','core','created','config_log','config_log',879,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"numberofpagestoshow\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810031,'web','0:0:0:0:0:0:0:1',NULL),(338,'\\core\\event\\config_log_created','core','created','config_log','config_log',880,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"numberofpagestoshow_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810031,'web','0:0:0:0:0:0:0:1',NULL),(339,'\\core\\event\\config_log_created','core','created','config_log','config_log',881,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"practice\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810031,'web','0:0:0:0:0:0:0:1',NULL),(340,'\\core\\event\\config_log_created','core','created','config_log','config_log',882,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"practice_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810032,'web','0:0:0:0:0:0:0:1',NULL),(341,'\\core\\event\\config_log_created','core','created','config_log','config_log',883,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"customscoring\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810032,'web','0:0:0:0:0:0:0:1',NULL),(342,'\\core\\event\\config_log_created','core','created','config_log','config_log',884,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"customscoring_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810032,'web','0:0:0:0:0:0:0:1',NULL),(343,'\\core\\event\\config_log_created','core','created','config_log','config_log',885,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"retakesallowed\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810032,'web','0:0:0:0:0:0:0:1',NULL),(344,'\\core\\event\\config_log_created','core','created','config_log','config_log',886,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"retakesallowed_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810032,'web','0:0:0:0:0:0:0:1',NULL),(345,'\\core\\event\\config_log_created','core','created','config_log','config_log',887,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"handlingofretakes\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810032,'web','0:0:0:0:0:0:0:1',NULL),(346,'\\core\\event\\config_log_created','core','created','config_log','config_log',888,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"handlingofretakes_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810032,'web','0:0:0:0:0:0:0:1',NULL),(347,'\\core\\event\\config_log_created','core','created','config_log','config_log',889,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"minimumnumberofquestions\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810032,'web','0:0:0:0:0:0:0:1',NULL),(348,'\\core\\event\\config_log_created','core','created','config_log','config_log',890,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"minimumnumberofquestions_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"mod_lesson\";}',1547810033,'web','0:0:0:0:0:0:0:1',NULL),(349,'\\core\\event\\config_log_created','core','created','config_log','config_log',891,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"displaycoursestructure\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810033,'web','0:0:0:0:0:0:0:1',NULL),(350,'\\core\\event\\config_log_created','core','created','config_log','config_log',892,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"displaycoursestructure_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:5:\"scorm\";}',1547810033,'web','0:0:0:0:0:0:0:1',NULL),(351,'\\core\\event\\config_log_created','core','created','config_log','config_log',893,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:5:\"popup\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810033,'web','0:0:0:0:0:0:0:1',NULL),(352,'\\core\\event\\config_log_created','core','created','config_log','config_log',894,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"popup_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:5:\"scorm\";}',1547810033,'web','0:0:0:0:0:0:0:1',NULL),(353,'\\core\\event\\config_log_created','core','created','config_log','config_log',895,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"displayactivityname\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810033,'web','0:0:0:0:0:0:0:1',NULL),(354,'\\core\\event\\config_log_created','core','created','config_log','config_log',896,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"framewidth\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"100\";s:6:\"plugin\";s:5:\"scorm\";}',1547810033,'web','0:0:0:0:0:0:0:1',NULL),(355,'\\core\\event\\config_log_created','core','created','config_log','config_log',897,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"framewidth_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810033,'web','0:0:0:0:0:0:0:1',NULL),(356,'\\core\\event\\config_log_created','core','created','config_log','config_log',898,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"frameheight\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"500\";s:6:\"plugin\";s:5:\"scorm\";}',1547810033,'web','0:0:0:0:0:0:0:1',NULL),(357,'\\core\\event\\config_log_created','core','created','config_log','config_log',899,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"frameheight_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810034,'web','0:0:0:0:0:0:0:1',NULL),(358,'\\core\\event\\config_log_created','core','created','config_log','config_log',900,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"winoptgrp_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810034,'web','0:0:0:0:0:0:0:1',NULL),(359,'\\core\\event\\config_log_created','core','created','config_log','config_log',901,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"scrollbars\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810034,'web','0:0:0:0:0:0:0:1',NULL),(360,'\\core\\event\\config_log_created','core','created','config_log','config_log',902,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"directories\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810034,'web','0:0:0:0:0:0:0:1',NULL),(361,'\\core\\event\\config_log_created','core','created','config_log','config_log',903,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"location\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810034,'web','0:0:0:0:0:0:0:1',NULL),(362,'\\core\\event\\config_log_created','core','created','config_log','config_log',904,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"menubar\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810034,'web','0:0:0:0:0:0:0:1',NULL),(363,'\\core\\event\\config_log_created','core','created','config_log','config_log',905,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"toolbar\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810034,'web','0:0:0:0:0:0:0:1',NULL),(364,'\\core\\event\\config_log_created','core','created','config_log','config_log',906,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"status\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810034,'web','0:0:0:0:0:0:0:1',NULL),(365,'\\core\\event\\config_log_created','core','created','config_log','config_log',907,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"skipview\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810034,'web','0:0:0:0:0:0:0:1',NULL),(366,'\\core\\event\\config_log_created','core','created','config_log','config_log',908,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"skipview_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810034,'web','0:0:0:0:0:0:0:1',NULL),(367,'\\core\\event\\config_log_created','core','created','config_log','config_log',909,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"hidebrowse\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810034,'web','0:0:0:0:0:0:0:1',NULL),(368,'\\core\\event\\config_log_created','core','created','config_log','config_log',910,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"hidebrowse_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810034,'web','0:0:0:0:0:0:0:1',NULL),(369,'\\core\\event\\config_log_created','core','created','config_log','config_log',911,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"hidetoc\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810034,'web','0:0:0:0:0:0:0:1',NULL),(370,'\\core\\event\\config_log_created','core','created','config_log','config_log',912,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"hidetoc_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810034,'web','0:0:0:0:0:0:0:1',NULL),(371,'\\core\\event\\config_log_created','core','created','config_log','config_log',913,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:3:\"nav\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810035,'web','0:0:0:0:0:0:0:1',NULL),(372,'\\core\\event\\config_log_created','core','created','config_log','config_log',914,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"nav_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810035,'web','0:0:0:0:0:0:0:1',NULL),(373,'\\core\\event\\config_log_created','core','created','config_log','config_log',915,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"navpositionleft\";s:8:\"oldvalue\";N;s:5:\"value\";s:4:\"-100\";s:6:\"plugin\";s:5:\"scorm\";}',1547810035,'web','0:0:0:0:0:0:0:1',NULL),(374,'\\core\\event\\config_log_created','core','created','config_log','config_log',916,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"navpositionleft_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810035,'web','0:0:0:0:0:0:0:1',NULL),(375,'\\core\\event\\config_log_created','core','created','config_log','config_log',917,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"navpositiontop\";s:8:\"oldvalue\";N;s:5:\"value\";s:4:\"-100\";s:6:\"plugin\";s:5:\"scorm\";}',1547810035,'web','0:0:0:0:0:0:0:1',NULL),(376,'\\core\\event\\config_log_created','core','created','config_log','config_log',918,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"navpositiontop_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810035,'web','0:0:0:0:0:0:0:1',NULL),(377,'\\core\\event\\config_log_created','core','created','config_log','config_log',919,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"collapsetocwinsize\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"767\";s:6:\"plugin\";s:5:\"scorm\";}',1547810035,'web','0:0:0:0:0:0:0:1',NULL),(378,'\\core\\event\\config_log_created','core','created','config_log','config_log',920,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"collapsetocwinsize_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810035,'web','0:0:0:0:0:0:0:1',NULL),(379,'\\core\\event\\config_log_created','core','created','config_log','config_log',921,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"displayattemptstatus\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810035,'web','0:0:0:0:0:0:0:1',NULL),(380,'\\core\\event\\config_log_created','core','created','config_log','config_log',922,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"displayattemptstatus_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:5:\"scorm\";}',1547810035,'web','0:0:0:0:0:0:0:1',NULL),(381,'\\core\\event\\config_log_created','core','created','config_log','config_log',923,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"grademethod\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810035,'web','0:0:0:0:0:0:0:1',NULL),(382,'\\core\\event\\config_log_created','core','created','config_log','config_log',924,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"maxgrade\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"100\";s:6:\"plugin\";s:5:\"scorm\";}',1547810035,'web','0:0:0:0:0:0:0:1',NULL),(383,'\\core\\event\\config_log_created','core','created','config_log','config_log',925,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"maxattempt\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810035,'web','0:0:0:0:0:0:0:1',NULL),(384,'\\core\\event\\config_log_created','core','created','config_log','config_log',926,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"whatgrade\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810036,'web','0:0:0:0:0:0:0:1',NULL),(385,'\\core\\event\\config_log_created','core','created','config_log','config_log',927,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"forcecompleted\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810036,'web','0:0:0:0:0:0:0:1',NULL),(386,'\\core\\event\\config_log_created','core','created','config_log','config_log',928,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"forcenewattempt\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810036,'web','0:0:0:0:0:0:0:1',NULL),(387,'\\core\\event\\config_log_created','core','created','config_log','config_log',929,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"autocommit\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810036,'web','0:0:0:0:0:0:0:1',NULL),(388,'\\core\\event\\config_log_created','core','created','config_log','config_log',930,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"masteryoverride\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810036,'web','0:0:0:0:0:0:0:1',NULL),(389,'\\core\\event\\config_log_created','core','created','config_log','config_log',931,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"lastattemptlock\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810036,'web','0:0:0:0:0:0:0:1',NULL),(390,'\\core\\event\\config_log_created','core','created','config_log','config_log',932,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:4:\"auto\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810036,'web','0:0:0:0:0:0:0:1',NULL),(391,'\\core\\event\\config_log_created','core','created','config_log','config_log',933,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"updatefreq\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810036,'web','0:0:0:0:0:0:0:1',NULL),(392,'\\core\\event\\config_log_created','core','created','config_log','config_log',934,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"scormstandard\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810036,'web','0:0:0:0:0:0:0:1',NULL),(393,'\\core\\event\\config_log_created','core','created','config_log','config_log',935,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"allowtypeexternal\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810036,'web','0:0:0:0:0:0:0:1',NULL),(394,'\\core\\event\\config_log_created','core','created','config_log','config_log',936,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"allowtypelocalsync\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810036,'web','0:0:0:0:0:0:0:1',NULL),(395,'\\core\\event\\config_log_created','core','created','config_log','config_log',937,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"allowtypeexternalaicc\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810036,'web','0:0:0:0:0:0:0:1',NULL),(396,'\\core\\event\\config_log_created','core','created','config_log','config_log',938,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"allowaicchacp\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810037,'web','0:0:0:0:0:0:0:1',NULL),(397,'\\core\\event\\config_log_created','core','created','config_log','config_log',939,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"aicchacptimeout\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"30\";s:6:\"plugin\";s:5:\"scorm\";}',1547810037,'web','0:0:0:0:0:0:0:1',NULL),(398,'\\core\\event\\config_log_created','core','created','config_log','config_log',940,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"aicchacpkeepsessiondata\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810037,'web','0:0:0:0:0:0:0:1',NULL),(399,'\\core\\event\\config_log_created','core','created','config_log','config_log',941,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"aiccuserid\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810037,'web','0:0:0:0:0:0:0:1',NULL),(400,'\\core\\event\\config_log_created','core','created','config_log','config_log',942,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"forcejavascript\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:5:\"scorm\";}',1547810037,'web','0:0:0:0:0:0:0:1',NULL),(401,'\\core\\event\\config_log_created','core','created','config_log','config_log',943,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"allowapidebug\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810037,'web','0:0:0:0:0:0:0:1',NULL),(402,'\\core\\event\\config_log_created','core','created','config_log','config_log',944,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"apidebugmask\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\".*\";s:6:\"plugin\";s:5:\"scorm\";}',1547810037,'web','0:0:0:0:0:0:0:1',NULL),(403,'\\core\\event\\config_log_created','core','created','config_log','config_log',945,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"protectpackagedownloads\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:5:\"scorm\";}',1547810037,'web','0:0:0:0:0:0:0:1',NULL),(404,'\\core\\event\\config_log_created','core','created','config_log','config_log',946,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"framesize\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"130\";s:6:\"plugin\";s:3:\"url\";}',1547810037,'web','0:0:0:0:0:0:0:1',NULL),(405,'\\core\\event\\config_log_created','core','created','config_log','config_log',947,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"secretphrase\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:3:\"url\";}',1547810038,'web','0:0:0:0:0:0:0:1',NULL),(406,'\\core\\event\\config_log_created','core','created','config_log','config_log',948,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"rolesinparams\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:3:\"url\";}',1547810038,'web','0:0:0:0:0:0:0:1',NULL),(407,'\\core\\event\\config_log_created','core','created','config_log','config_log',949,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"displayoptions\";s:8:\"oldvalue\";N;s:5:\"value\";s:7:\"0,1,5,6\";s:6:\"plugin\";s:3:\"url\";}',1547810038,'web','0:0:0:0:0:0:0:1',NULL),(408,'\\core\\event\\config_log_created','core','created','config_log','config_log',950,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"printintro\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:3:\"url\";}',1547810038,'web','0:0:0:0:0:0:0:1',NULL),(409,'\\core\\event\\config_log_created','core','created','config_log','config_log',951,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"display\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:3:\"url\";}',1547810038,'web','0:0:0:0:0:0:0:1',NULL),(410,'\\core\\event\\config_log_created','core','created','config_log','config_log',952,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"popupwidth\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"620\";s:6:\"plugin\";s:3:\"url\";}',1547810038,'web','0:0:0:0:0:0:0:1',NULL),(411,'\\core\\event\\config_log_created','core','created','config_log','config_log',953,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"popupheight\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"450\";s:6:\"plugin\";s:3:\"url\";}',1547810038,'web','0:0:0:0:0:0:0:1',NULL),(412,'\\core\\event\\config_log_created','core','created','config_log','config_log',954,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:5:\"grade\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"80\";s:6:\"plugin\";s:8:\"workshop\";}',1547810038,'web','0:0:0:0:0:0:0:1',NULL),(413,'\\core\\event\\config_log_created','core','created','config_log','config_log',955,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"gradinggrade\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"20\";s:6:\"plugin\";s:8:\"workshop\";}',1547810038,'web','0:0:0:0:0:0:0:1',NULL),(414,'\\core\\event\\config_log_created','core','created','config_log','config_log',956,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"gradedecimals\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"workshop\";}',1547810038,'web','0:0:0:0:0:0:0:1',NULL),(415,'\\core\\event\\config_log_created','core','created','config_log','config_log',957,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"maxbytes\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"workshop\";}',1547810038,'web','0:0:0:0:0:0:0:1',NULL),(416,'\\core\\event\\config_log_created','core','created','config_log','config_log',958,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"strategy\";s:8:\"oldvalue\";N;s:5:\"value\";s:12:\"accumulative\";s:6:\"plugin\";s:8:\"workshop\";}',1547810038,'web','0:0:0:0:0:0:0:1',NULL),(417,'\\core\\event\\config_log_created','core','created','config_log','config_log',959,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"examplesmode\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"workshop\";}',1547810038,'web','0:0:0:0:0:0:0:1',NULL),(418,'\\core\\event\\config_log_created','core','created','config_log','config_log',960,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"numofreviews\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:25:\"workshopallocation_random\";}',1547810038,'web','0:0:0:0:0:0:0:1',NULL),(419,'\\core\\event\\config_log_created','core','created','config_log','config_log',961,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"grade0\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"Tidak\";s:6:\"plugin\";s:22:\"workshopform_numerrors\";}',1547810039,'web','0:0:0:0:0:0:0:1',NULL),(420,'\\core\\event\\config_log_created','core','created','config_log','config_log',962,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"grade1\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"Ya\";s:6:\"plugin\";s:22:\"workshopform_numerrors\";}',1547810039,'web','0:0:0:0:0:0:0:1',NULL),(421,'\\core\\event\\config_log_created','core','created','config_log','config_log',963,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"comparison\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:17:\"workshopeval_best\";}',1547810039,'web','0:0:0:0:0:0:0:1',NULL),(422,'\\core\\event\\config_log_created','core','created','config_log','config_log',964,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_map_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810039,'web','0:0:0:0:0:0:0:1',NULL),(423,'\\core\\event\\config_log_created','core','created','config_log','config_log',965,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_updatelocal_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810039,'web','0:0:0:0:0:0:0:1',NULL),(424,'\\core\\event\\config_log_created','core','created','config_log','config_log',966,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_updateremote_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810039,'web','0:0:0:0:0:0:0:1',NULL),(425,'\\core\\event\\config_log_created','core','created','config_log','config_log',967,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_lock_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810039,'web','0:0:0:0:0:0:0:1',NULL),(426,'\\core\\event\\config_log_created','core','created','config_log','config_log',968,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_map_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810039,'web','0:0:0:0:0:0:0:1',NULL),(427,'\\core\\event\\config_log_created','core','created','config_log','config_log',969,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_updatelocal_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810039,'web','0:0:0:0:0:0:0:1',NULL),(428,'\\core\\event\\config_log_created','core','created','config_log','config_log',970,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_updateremote_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810039,'web','0:0:0:0:0:0:0:1',NULL),(429,'\\core\\event\\config_log_created','core','created','config_log','config_log',971,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810039,'web','0:0:0:0:0:0:0:1',NULL),(430,'\\core\\event\\config_log_created','core','created','config_log','config_log',972,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_map_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810039,'web','0:0:0:0:0:0:0:1',NULL),(431,'\\core\\event\\config_log_created','core','created','config_log','config_log',973,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"field_updatelocal_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810039,'web','0:0:0:0:0:0:0:1',NULL),(432,'\\core\\event\\config_log_created','core','created','config_log','config_log',974,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_updateremote_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810040,'web','0:0:0:0:0:0:0:1',NULL),(433,'\\core\\event\\config_log_created','core','created','config_log','config_log',975,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_lock_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810040,'web','0:0:0:0:0:0:0:1',NULL),(434,'\\core\\event\\config_log_created','core','created','config_log','config_log',976,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_map_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810040,'web','0:0:0:0:0:0:0:1',NULL),(435,'\\core\\event\\config_log_created','core','created','config_log','config_log',977,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_updatelocal_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810040,'web','0:0:0:0:0:0:0:1',NULL),(436,'\\core\\event\\config_log_created','core','created','config_log','config_log',978,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"field_updateremote_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810040,'web','0:0:0:0:0:0:0:1',NULL),(437,'\\core\\event\\config_log_created','core','created','config_log','config_log',979,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810040,'web','0:0:0:0:0:0:0:1',NULL),(438,'\\core\\event\\config_log_created','core','created','config_log','config_log',980,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_map_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810040,'web','0:0:0:0:0:0:0:1',NULL),(439,'\\core\\event\\config_log_created','core','created','config_log','config_log',981,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"field_updatelocal_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810040,'web','0:0:0:0:0:0:0:1',NULL),(440,'\\core\\event\\config_log_created','core','created','config_log','config_log',982,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_updateremote_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810040,'web','0:0:0:0:0:0:0:1',NULL),(441,'\\core\\event\\config_log_created','core','created','config_log','config_log',983,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810040,'web','0:0:0:0:0:0:0:1',NULL),(442,'\\core\\event\\config_log_created','core','created','config_log','config_log',984,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_map_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810040,'web','0:0:0:0:0:0:0:1',NULL),(443,'\\core\\event\\config_log_created','core','created','config_log','config_log',985,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_updatelocal_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810040,'web','0:0:0:0:0:0:0:1',NULL),(444,'\\core\\event\\config_log_created','core','created','config_log','config_log',986,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"field_updateremote_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810040,'web','0:0:0:0:0:0:0:1',NULL),(445,'\\core\\event\\config_log_created','core','created','config_log','config_log',987,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810041,'web','0:0:0:0:0:0:0:1',NULL),(446,'\\core\\event\\config_log_created','core','created','config_log','config_log',988,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_map_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810041,'web','0:0:0:0:0:0:0:1',NULL),(447,'\\core\\event\\config_log_created','core','created','config_log','config_log',989,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"field_updatelocal_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810041,'web','0:0:0:0:0:0:0:1',NULL),(448,'\\core\\event\\config_log_created','core','created','config_log','config_log',990,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:30:\"field_updateremote_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810041,'web','0:0:0:0:0:0:0:1',NULL),(449,'\\core\\event\\config_log_created','core','created','config_log','config_log',991,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810041,'web','0:0:0:0:0:0:0:1',NULL),(450,'\\core\\event\\config_log_created','core','created','config_log','config_log',992,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"field_map_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810041,'web','0:0:0:0:0:0:0:1',NULL),(451,'\\core\\event\\config_log_created','core','created','config_log','config_log',993,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_updatelocal_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810041,'web','0:0:0:0:0:0:0:1',NULL),(452,'\\core\\event\\config_log_created','core','created','config_log','config_log',994,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_updateremote_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810041,'web','0:0:0:0:0:0:0:1',NULL),(453,'\\core\\event\\config_log_created','core','created','config_log','config_log',995,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_lock_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810041,'web','0:0:0:0:0:0:0:1',NULL),(454,'\\core\\event\\config_log_created','core','created','config_log','config_log',996,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_map_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810042,'web','0:0:0:0:0:0:0:1',NULL),(455,'\\core\\event\\config_log_created','core','created','config_log','config_log',997,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_updatelocal_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810042,'web','0:0:0:0:0:0:0:1',NULL),(456,'\\core\\event\\config_log_created','core','created','config_log','config_log',998,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_updateremote_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810042,'web','0:0:0:0:0:0:0:1',NULL),(457,'\\core\\event\\config_log_created','core','created','config_log','config_log',999,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810042,'web','0:0:0:0:0:0:0:1',NULL),(458,'\\core\\event\\config_log_created','core','created','config_log','config_log',1000,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_map_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810042,'web','0:0:0:0:0:0:0:1',NULL),(459,'\\core\\event\\config_log_created','core','created','config_log','config_log',1001,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"field_updatelocal_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810042,'web','0:0:0:0:0:0:0:1',NULL),(460,'\\core\\event\\config_log_created','core','created','config_log','config_log',1002,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:30:\"field_updateremote_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810042,'web','0:0:0:0:0:0:0:1',NULL),(461,'\\core\\event\\config_log_created','core','created','config_log','config_log',1003,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810042,'web','0:0:0:0:0:0:0:1',NULL),(462,'\\core\\event\\config_log_created','core','created','config_log','config_log',1004,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_map_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810042,'web','0:0:0:0:0:0:0:1',NULL),(463,'\\core\\event\\config_log_created','core','created','config_log','config_log',1005,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_updatelocal_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810042,'web','0:0:0:0:0:0:0:1',NULL),(464,'\\core\\event\\config_log_created','core','created','config_log','config_log',1006,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"field_updateremote_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810042,'web','0:0:0:0:0:0:0:1',NULL),(465,'\\core\\event\\config_log_created','core','created','config_log','config_log',1007,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810042,'web','0:0:0:0:0:0:0:1',NULL),(466,'\\core\\event\\config_log_created','core','created','config_log','config_log',1008,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_map_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810042,'web','0:0:0:0:0:0:0:1',NULL),(467,'\\core\\event\\config_log_created','core','created','config_log','config_log',1009,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_updatelocal_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810042,'web','0:0:0:0:0:0:0:1',NULL),(468,'\\core\\event\\config_log_created','core','created','config_log','config_log',1010,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"field_updateremote_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810043,'web','0:0:0:0:0:0:0:1',NULL),(469,'\\core\\event\\config_log_created','core','created','config_log','config_log',1011,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810043,'web','0:0:0:0:0:0:0:1',NULL),(470,'\\core\\event\\config_log_created','core','created','config_log','config_log',1012,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_map_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810043,'web','0:0:0:0:0:0:0:1',NULL),(471,'\\core\\event\\config_log_created','core','created','config_log','config_log',1013,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_updatelocal_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810043,'web','0:0:0:0:0:0:0:1',NULL),(472,'\\core\\event\\config_log_created','core','created','config_log','config_log',1014,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"field_updateremote_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810043,'web','0:0:0:0:0:0:0:1',NULL),(473,'\\core\\event\\config_log_created','core','created','config_log','config_log',1015,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810043,'web','0:0:0:0:0:0:0:1',NULL),(474,'\\core\\event\\config_log_created','core','created','config_log','config_log',1016,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_map_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810043,'web','0:0:0:0:0:0:0:1',NULL),(475,'\\core\\event\\config_log_created','core','created','config_log','config_log',1017,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"field_updatelocal_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810043,'web','0:0:0:0:0:0:0:1',NULL),(476,'\\core\\event\\config_log_created','core','created','config_log','config_log',1018,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_updateremote_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810043,'web','0:0:0:0:0:0:0:1',NULL),(477,'\\core\\event\\config_log_created','core','created','config_log','config_log',1019,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810044,'web','0:0:0:0:0:0:0:1',NULL),(478,'\\core\\event\\config_log_created','core','created','config_log','config_log',1020,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_map_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810044,'web','0:0:0:0:0:0:0:1',NULL),(479,'\\core\\event\\config_log_created','core','created','config_log','config_log',1021,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:35:\"field_updatelocal_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810044,'web','0:0:0:0:0:0:0:1',NULL),(480,'\\core\\event\\config_log_created','core','created','config_log','config_log',1022,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:36:\"field_updateremote_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810044,'web','0:0:0:0:0:0:0:1',NULL),(481,'\\core\\event\\config_log_created','core','created','config_log','config_log',1023,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_lock_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810044,'web','0:0:0:0:0:0:0:1',NULL),(482,'\\core\\event\\config_log_created','core','created','config_log','config_log',1024,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_map_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810044,'web','0:0:0:0:0:0:0:1',NULL),(483,'\\core\\event\\config_log_created','core','created','config_log','config_log',1025,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:34:\"field_updatelocal_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810044,'web','0:0:0:0:0:0:0:1',NULL),(484,'\\core\\event\\config_log_created','core','created','config_log','config_log',1026,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:35:\"field_updateremote_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810044,'web','0:0:0:0:0:0:0:1',NULL),(485,'\\core\\event\\config_log_created','core','created','config_log','config_log',1027,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_lock_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810044,'web','0:0:0:0:0:0:0:1',NULL),(486,'\\core\\event\\config_log_created','core','created','config_log','config_log',1028,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_map_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810044,'web','0:0:0:0:0:0:0:1',NULL),(487,'\\core\\event\\config_log_created','core','created','config_log','config_log',1029,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_updatelocal_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810044,'web','0:0:0:0:0:0:0:1',NULL),(488,'\\core\\event\\config_log_created','core','created','config_log','config_log',1030,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"field_updateremote_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810044,'web','0:0:0:0:0:0:0:1',NULL),(489,'\\core\\event\\config_log_created','core','created','config_log','config_log',1031,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810044,'web','0:0:0:0:0:0:0:1',NULL),(490,'\\core\\event\\config_log_created','core','created','config_log','config_log',1032,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"field_map_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810045,'web','0:0:0:0:0:0:0:1',NULL),(491,'\\core\\event\\config_log_created','core','created','config_log','config_log',1033,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:31:\"field_updatelocal_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810045,'web','0:0:0:0:0:0:0:1',NULL),(492,'\\core\\event\\config_log_created','core','created','config_log','config_log',1034,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:32:\"field_updateremote_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810045,'web','0:0:0:0:0:0:0:1',NULL),(493,'\\core\\event\\config_log_created','core','created','config_log','config_log',1035,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_lock_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:8:\"auth_cas\";}',1547810045,'web','0:0:0:0:0:0:0:1',NULL),(494,'\\core\\event\\config_log_created','core','created','config_log','config_log',1036,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:4:\"host\";s:8:\"oldvalue\";N;s:5:\"value\";s:9:\"127.0.0.1\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810045,'web','0:0:0:0:0:0:0:1',NULL),(495,'\\core\\event\\config_log_created','core','created','config_log','config_log',1037,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:4:\"type\";s:8:\"oldvalue\";N;s:5:\"value\";s:6:\"mysqli\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810045,'web','0:0:0:0:0:0:0:1',NULL),(496,'\\core\\event\\config_log_created','core','created','config_log','config_log',1038,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"sybasequoting\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810045,'web','0:0:0:0:0:0:0:1',NULL),(497,'\\core\\event\\config_log_created','core','created','config_log','config_log',1039,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:4:\"name\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810045,'web','0:0:0:0:0:0:0:1',NULL),(498,'\\core\\event\\config_log_created','core','created','config_log','config_log',1040,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:4:\"user\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810045,'web','0:0:0:0:0:0:0:1',NULL),(499,'\\core\\event\\config_log_created','core','created','config_log','config_log',1041,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:4:\"pass\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810045,'web','0:0:0:0:0:0:0:1',NULL),(500,'\\core\\event\\config_log_created','core','created','config_log','config_log',1042,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:5:\"table\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810045,'web','0:0:0:0:0:0:0:1',NULL),(501,'\\core\\event\\config_log_created','core','created','config_log','config_log',1043,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"fielduser\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810045,'web','0:0:0:0:0:0:0:1',NULL),(502,'\\core\\event\\config_log_created','core','created','config_log','config_log',1044,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"fieldpass\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810046,'web','0:0:0:0:0:0:0:1',NULL),(503,'\\core\\event\\config_log_created','core','created','config_log','config_log',1045,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"passtype\";s:8:\"oldvalue\";N;s:5:\"value\";s:9:\"plaintext\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810046,'web','0:0:0:0:0:0:0:1',NULL),(504,'\\core\\event\\config_log_created','core','created','config_log','config_log',1046,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"extencoding\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"utf-8\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810046,'web','0:0:0:0:0:0:0:1',NULL),(505,'\\core\\event\\config_log_created','core','created','config_log','config_log',1047,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"setupsql\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810046,'web','0:0:0:0:0:0:0:1',NULL),(506,'\\core\\event\\config_log_created','core','created','config_log','config_log',1048,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"debugauthdb\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810046,'web','0:0:0:0:0:0:0:1',NULL),(507,'\\core\\event\\config_log_created','core','created','config_log','config_log',1049,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"changepasswordurl\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810046,'web','0:0:0:0:0:0:0:1',NULL),(508,'\\core\\event\\config_log_created','core','created','config_log','config_log',1050,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"removeuser\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810046,'web','0:0:0:0:0:0:0:1',NULL),(509,'\\core\\event\\config_log_created','core','created','config_log','config_log',1051,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"updateusers\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810046,'web','0:0:0:0:0:0:0:1',NULL),(510,'\\core\\event\\config_log_created','core','created','config_log','config_log',1052,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_map_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810047,'web','0:0:0:0:0:0:0:1',NULL),(511,'\\core\\event\\config_log_created','core','created','config_log','config_log',1053,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_updatelocal_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810047,'web','0:0:0:0:0:0:0:1',NULL),(512,'\\core\\event\\config_log_created','core','created','config_log','config_log',1054,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_updateremote_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810047,'web','0:0:0:0:0:0:0:1',NULL),(513,'\\core\\event\\config_log_created','core','created','config_log','config_log',1055,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_lock_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810047,'web','0:0:0:0:0:0:0:1',NULL),(514,'\\core\\event\\config_log_created','core','created','config_log','config_log',1056,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_map_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810047,'web','0:0:0:0:0:0:0:1',NULL),(515,'\\core\\event\\config_log_created','core','created','config_log','config_log',1057,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_updatelocal_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810047,'web','0:0:0:0:0:0:0:1',NULL),(516,'\\core\\event\\config_log_created','core','created','config_log','config_log',1058,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_updateremote_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810047,'web','0:0:0:0:0:0:0:1',NULL),(517,'\\core\\event\\config_log_created','core','created','config_log','config_log',1059,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810047,'web','0:0:0:0:0:0:0:1',NULL),(518,'\\core\\event\\config_log_created','core','created','config_log','config_log',1060,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_map_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810047,'web','0:0:0:0:0:0:0:1',NULL),(519,'\\core\\event\\config_log_created','core','created','config_log','config_log',1061,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"field_updatelocal_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810047,'web','0:0:0:0:0:0:0:1',NULL),(520,'\\core\\event\\config_log_created','core','created','config_log','config_log',1062,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_updateremote_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810047,'web','0:0:0:0:0:0:0:1',NULL),(521,'\\core\\event\\config_log_created','core','created','config_log','config_log',1063,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_lock_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810047,'web','0:0:0:0:0:0:0:1',NULL),(522,'\\core\\event\\config_log_created','core','created','config_log','config_log',1064,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_map_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810047,'web','0:0:0:0:0:0:0:1',NULL),(523,'\\core\\event\\config_log_created','core','created','config_log','config_log',1065,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_updatelocal_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810048,'web','0:0:0:0:0:0:0:1',NULL),(524,'\\core\\event\\config_log_created','core','created','config_log','config_log',1066,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"field_updateremote_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810048,'web','0:0:0:0:0:0:0:1',NULL),(525,'\\core\\event\\config_log_created','core','created','config_log','config_log',1067,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810048,'web','0:0:0:0:0:0:0:1',NULL),(526,'\\core\\event\\config_log_created','core','created','config_log','config_log',1068,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_map_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810048,'web','0:0:0:0:0:0:0:1',NULL),(527,'\\core\\event\\config_log_created','core','created','config_log','config_log',1069,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"field_updatelocal_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810048,'web','0:0:0:0:0:0:0:1',NULL),(528,'\\core\\event\\config_log_created','core','created','config_log','config_log',1070,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_updateremote_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810048,'web','0:0:0:0:0:0:0:1',NULL),(529,'\\core\\event\\config_log_created','core','created','config_log','config_log',1071,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810048,'web','0:0:0:0:0:0:0:1',NULL),(530,'\\core\\event\\config_log_created','core','created','config_log','config_log',1072,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_map_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810048,'web','0:0:0:0:0:0:0:1',NULL),(531,'\\core\\event\\config_log_created','core','created','config_log','config_log',1073,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_updatelocal_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810048,'web','0:0:0:0:0:0:0:1',NULL),(532,'\\core\\event\\config_log_created','core','created','config_log','config_log',1074,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"field_updateremote_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810048,'web','0:0:0:0:0:0:0:1',NULL),(533,'\\core\\event\\config_log_created','core','created','config_log','config_log',1075,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810048,'web','0:0:0:0:0:0:0:1',NULL),(534,'\\core\\event\\config_log_created','core','created','config_log','config_log',1076,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_map_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810048,'web','0:0:0:0:0:0:0:1',NULL),(535,'\\core\\event\\config_log_created','core','created','config_log','config_log',1077,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"field_updatelocal_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810048,'web','0:0:0:0:0:0:0:1',NULL),(536,'\\core\\event\\config_log_created','core','created','config_log','config_log',1078,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:30:\"field_updateremote_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810049,'web','0:0:0:0:0:0:0:1',NULL),(537,'\\core\\event\\config_log_created','core','created','config_log','config_log',1079,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810049,'web','0:0:0:0:0:0:0:1',NULL),(538,'\\core\\event\\config_log_created','core','created','config_log','config_log',1080,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"field_map_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810049,'web','0:0:0:0:0:0:0:1',NULL),(539,'\\core\\event\\config_log_created','core','created','config_log','config_log',1081,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_updatelocal_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810049,'web','0:0:0:0:0:0:0:1',NULL),(540,'\\core\\event\\config_log_created','core','created','config_log','config_log',1082,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_updateremote_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810049,'web','0:0:0:0:0:0:0:1',NULL),(541,'\\core\\event\\config_log_created','core','created','config_log','config_log',1083,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_lock_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810049,'web','0:0:0:0:0:0:0:1',NULL),(542,'\\core\\event\\config_log_created','core','created','config_log','config_log',1084,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_map_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810049,'web','0:0:0:0:0:0:0:1',NULL),(543,'\\core\\event\\config_log_created','core','created','config_log','config_log',1085,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_updatelocal_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810049,'web','0:0:0:0:0:0:0:1',NULL),(544,'\\core\\event\\config_log_created','core','created','config_log','config_log',1086,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_updateremote_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810049,'web','0:0:0:0:0:0:0:1',NULL),(545,'\\core\\event\\config_log_created','core','created','config_log','config_log',1087,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810049,'web','0:0:0:0:0:0:0:1',NULL),(546,'\\core\\event\\config_log_created','core','created','config_log','config_log',1088,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_map_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810049,'web','0:0:0:0:0:0:0:1',NULL),(547,'\\core\\event\\config_log_created','core','created','config_log','config_log',1089,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"field_updatelocal_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810049,'web','0:0:0:0:0:0:0:1',NULL),(548,'\\core\\event\\config_log_created','core','created','config_log','config_log',1090,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:30:\"field_updateremote_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810049,'web','0:0:0:0:0:0:0:1',NULL),(549,'\\core\\event\\config_log_created','core','created','config_log','config_log',1091,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810050,'web','0:0:0:0:0:0:0:1',NULL),(550,'\\core\\event\\config_log_created','core','created','config_log','config_log',1092,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_map_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810050,'web','0:0:0:0:0:0:0:1',NULL),(551,'\\core\\event\\config_log_created','core','created','config_log','config_log',1093,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_updatelocal_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810050,'web','0:0:0:0:0:0:0:1',NULL),(552,'\\core\\event\\config_log_created','core','created','config_log','config_log',1094,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"field_updateremote_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810050,'web','0:0:0:0:0:0:0:1',NULL),(553,'\\core\\event\\config_log_created','core','created','config_log','config_log',1095,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810050,'web','0:0:0:0:0:0:0:1',NULL),(554,'\\core\\event\\config_log_created','core','created','config_log','config_log',1096,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_map_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810050,'web','0:0:0:0:0:0:0:1',NULL),(555,'\\core\\event\\config_log_created','core','created','config_log','config_log',1097,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_updatelocal_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810050,'web','0:0:0:0:0:0:0:1',NULL),(556,'\\core\\event\\config_log_created','core','created','config_log','config_log',1098,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"field_updateremote_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810050,'web','0:0:0:0:0:0:0:1',NULL),(557,'\\core\\event\\config_log_created','core','created','config_log','config_log',1099,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810050,'web','0:0:0:0:0:0:0:1',NULL),(558,'\\core\\event\\config_log_created','core','created','config_log','config_log',1100,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_map_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810051,'web','0:0:0:0:0:0:0:1',NULL),(559,'\\core\\event\\config_log_created','core','created','config_log','config_log',1101,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_updatelocal_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810051,'web','0:0:0:0:0:0:0:1',NULL),(560,'\\core\\event\\config_log_created','core','created','config_log','config_log',1102,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"field_updateremote_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810051,'web','0:0:0:0:0:0:0:1',NULL),(561,'\\core\\event\\config_log_created','core','created','config_log','config_log',1103,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810051,'web','0:0:0:0:0:0:0:1',NULL),(562,'\\core\\event\\config_log_created','core','created','config_log','config_log',1104,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_map_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810051,'web','0:0:0:0:0:0:0:1',NULL),(563,'\\core\\event\\config_log_created','core','created','config_log','config_log',1105,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"field_updatelocal_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810051,'web','0:0:0:0:0:0:0:1',NULL),(564,'\\core\\event\\config_log_created','core','created','config_log','config_log',1106,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_updateremote_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810051,'web','0:0:0:0:0:0:0:1',NULL),(565,'\\core\\event\\config_log_created','core','created','config_log','config_log',1107,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810051,'web','0:0:0:0:0:0:0:1',NULL),(566,'\\core\\event\\config_log_created','core','created','config_log','config_log',1108,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_map_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810051,'web','0:0:0:0:0:0:0:1',NULL),(567,'\\core\\event\\config_log_created','core','created','config_log','config_log',1109,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:35:\"field_updatelocal_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810051,'web','0:0:0:0:0:0:0:1',NULL),(568,'\\core\\event\\config_log_created','core','created','config_log','config_log',1110,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:36:\"field_updateremote_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810051,'web','0:0:0:0:0:0:0:1',NULL),(569,'\\core\\event\\config_log_created','core','created','config_log','config_log',1111,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_lock_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810051,'web','0:0:0:0:0:0:0:1',NULL),(570,'\\core\\event\\config_log_created','core','created','config_log','config_log',1112,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_map_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810051,'web','0:0:0:0:0:0:0:1',NULL),(571,'\\core\\event\\config_log_created','core','created','config_log','config_log',1113,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:34:\"field_updatelocal_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810051,'web','0:0:0:0:0:0:0:1',NULL),(572,'\\core\\event\\config_log_created','core','created','config_log','config_log',1114,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:35:\"field_updateremote_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810052,'web','0:0:0:0:0:0:0:1',NULL),(573,'\\core\\event\\config_log_created','core','created','config_log','config_log',1115,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_lock_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810052,'web','0:0:0:0:0:0:0:1',NULL),(574,'\\core\\event\\config_log_created','core','created','config_log','config_log',1116,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_map_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810052,'web','0:0:0:0:0:0:0:1',NULL),(575,'\\core\\event\\config_log_created','core','created','config_log','config_log',1117,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_updatelocal_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810052,'web','0:0:0:0:0:0:0:1',NULL),(576,'\\core\\event\\config_log_created','core','created','config_log','config_log',1118,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"field_updateremote_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810052,'web','0:0:0:0:0:0:0:1',NULL),(577,'\\core\\event\\config_log_created','core','created','config_log','config_log',1119,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810052,'web','0:0:0:0:0:0:0:1',NULL),(578,'\\core\\event\\config_log_created','core','created','config_log','config_log',1120,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"field_map_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810052,'web','0:0:0:0:0:0:0:1',NULL),(579,'\\core\\event\\config_log_created','core','created','config_log','config_log',1121,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:31:\"field_updatelocal_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810052,'web','0:0:0:0:0:0:0:1',NULL),(580,'\\core\\event\\config_log_created','core','created','config_log','config_log',1122,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:32:\"field_updateremote_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810052,'web','0:0:0:0:0:0:0:1',NULL),(581,'\\core\\event\\config_log_created','core','created','config_log','config_log',1123,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_lock_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:7:\"auth_db\";}',1547810052,'web','0:0:0:0:0:0:0:1',NULL),(582,'\\core\\event\\config_log_created','core','created','config_log','config_log',1124,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_map_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810052,'web','0:0:0:0:0:0:0:1',NULL),(583,'\\core\\event\\config_log_created','core','created','config_log','config_log',1125,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_updatelocal_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810052,'web','0:0:0:0:0:0:0:1',NULL),(584,'\\core\\event\\config_log_created','core','created','config_log','config_log',1126,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_updateremote_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810052,'web','0:0:0:0:0:0:0:1',NULL),(585,'\\core\\event\\config_log_created','core','created','config_log','config_log',1127,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_lock_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810052,'web','0:0:0:0:0:0:0:1',NULL),(586,'\\core\\event\\config_log_created','core','created','config_log','config_log',1128,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_map_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810053,'web','0:0:0:0:0:0:0:1',NULL),(587,'\\core\\event\\config_log_created','core','created','config_log','config_log',1129,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_updatelocal_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810053,'web','0:0:0:0:0:0:0:1',NULL),(588,'\\core\\event\\config_log_created','core','created','config_log','config_log',1130,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_updateremote_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810053,'web','0:0:0:0:0:0:0:1',NULL),(589,'\\core\\event\\config_log_created','core','created','config_log','config_log',1131,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810053,'web','0:0:0:0:0:0:0:1',NULL),(590,'\\core\\event\\config_log_created','core','created','config_log','config_log',1132,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_map_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810053,'web','0:0:0:0:0:0:0:1',NULL),(591,'\\core\\event\\config_log_created','core','created','config_log','config_log',1133,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"field_updatelocal_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810053,'web','0:0:0:0:0:0:0:1',NULL),(592,'\\core\\event\\config_log_created','core','created','config_log','config_log',1134,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_updateremote_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810053,'web','0:0:0:0:0:0:0:1',NULL),(593,'\\core\\event\\config_log_created','core','created','config_log','config_log',1135,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_lock_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810053,'web','0:0:0:0:0:0:0:1',NULL),(594,'\\core\\event\\config_log_created','core','created','config_log','config_log',1136,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_map_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810053,'web','0:0:0:0:0:0:0:1',NULL),(595,'\\core\\event\\config_log_created','core','created','config_log','config_log',1137,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_updatelocal_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810053,'web','0:0:0:0:0:0:0:1',NULL),(596,'\\core\\event\\config_log_created','core','created','config_log','config_log',1138,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"field_updateremote_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810053,'web','0:0:0:0:0:0:0:1',NULL),(597,'\\core\\event\\config_log_created','core','created','config_log','config_log',1139,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810053,'web','0:0:0:0:0:0:0:1',NULL),(598,'\\core\\event\\config_log_created','core','created','config_log','config_log',1140,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_map_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810054,'web','0:0:0:0:0:0:0:1',NULL),(599,'\\core\\event\\config_log_created','core','created','config_log','config_log',1141,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"field_updatelocal_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810054,'web','0:0:0:0:0:0:0:1',NULL),(600,'\\core\\event\\config_log_created','core','created','config_log','config_log',1142,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_updateremote_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810054,'web','0:0:0:0:0:0:0:1',NULL),(601,'\\core\\event\\config_log_created','core','created','config_log','config_log',1143,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810054,'web','0:0:0:0:0:0:0:1',NULL),(602,'\\core\\event\\config_log_created','core','created','config_log','config_log',1144,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_map_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810054,'web','0:0:0:0:0:0:0:1',NULL),(603,'\\core\\event\\config_log_created','core','created','config_log','config_log',1145,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_updatelocal_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810054,'web','0:0:0:0:0:0:0:1',NULL),(604,'\\core\\event\\config_log_created','core','created','config_log','config_log',1146,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"field_updateremote_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(605,'\\core\\event\\config_log_created','core','created','config_log','config_log',1147,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(606,'\\core\\event\\config_log_created','core','created','config_log','config_log',1148,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_map_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(607,'\\core\\event\\config_log_created','core','created','config_log','config_log',1149,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"field_updatelocal_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(608,'\\core\\event\\config_log_created','core','created','config_log','config_log',1150,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:30:\"field_updateremote_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(609,'\\core\\event\\config_log_created','core','created','config_log','config_log',1151,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(610,'\\core\\event\\config_log_created','core','created','config_log','config_log',1152,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"field_map_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(611,'\\core\\event\\config_log_created','core','created','config_log','config_log',1153,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_updatelocal_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(612,'\\core\\event\\config_log_created','core','created','config_log','config_log',1154,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_updateremote_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(613,'\\core\\event\\config_log_created','core','created','config_log','config_log',1155,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_lock_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(614,'\\core\\event\\config_log_created','core','created','config_log','config_log',1156,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_map_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(615,'\\core\\event\\config_log_created','core','created','config_log','config_log',1157,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_updatelocal_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(616,'\\core\\event\\config_log_created','core','created','config_log','config_log',1158,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_updateremote_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(617,'\\core\\event\\config_log_created','core','created','config_log','config_log',1159,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(618,'\\core\\event\\config_log_created','core','created','config_log','config_log',1160,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_map_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810055,'web','0:0:0:0:0:0:0:1',NULL),(619,'\\core\\event\\config_log_created','core','created','config_log','config_log',1161,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"field_updatelocal_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810056,'web','0:0:0:0:0:0:0:1',NULL),(620,'\\core\\event\\config_log_created','core','created','config_log','config_log',1162,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:30:\"field_updateremote_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810056,'web','0:0:0:0:0:0:0:1',NULL),(621,'\\core\\event\\config_log_created','core','created','config_log','config_log',1163,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810056,'web','0:0:0:0:0:0:0:1',NULL),(622,'\\core\\event\\config_log_created','core','created','config_log','config_log',1164,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_map_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810056,'web','0:0:0:0:0:0:0:1',NULL),(623,'\\core\\event\\config_log_created','core','created','config_log','config_log',1165,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_updatelocal_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810056,'web','0:0:0:0:0:0:0:1',NULL),(624,'\\core\\event\\config_log_created','core','created','config_log','config_log',1166,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"field_updateremote_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810056,'web','0:0:0:0:0:0:0:1',NULL),(625,'\\core\\event\\config_log_created','core','created','config_log','config_log',1167,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810056,'web','0:0:0:0:0:0:0:1',NULL),(626,'\\core\\event\\config_log_created','core','created','config_log','config_log',1168,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_map_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810056,'web','0:0:0:0:0:0:0:1',NULL),(627,'\\core\\event\\config_log_created','core','created','config_log','config_log',1169,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_updatelocal_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810057,'web','0:0:0:0:0:0:0:1',NULL),(628,'\\core\\event\\config_log_created','core','created','config_log','config_log',1170,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"field_updateremote_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810057,'web','0:0:0:0:0:0:0:1',NULL),(629,'\\core\\event\\config_log_created','core','created','config_log','config_log',1171,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810057,'web','0:0:0:0:0:0:0:1',NULL),(630,'\\core\\event\\config_log_created','core','created','config_log','config_log',1172,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_map_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810057,'web','0:0:0:0:0:0:0:1',NULL),(631,'\\core\\event\\config_log_created','core','created','config_log','config_log',1173,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_updatelocal_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810057,'web','0:0:0:0:0:0:0:1',NULL),(632,'\\core\\event\\config_log_created','core','created','config_log','config_log',1174,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"field_updateremote_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810057,'web','0:0:0:0:0:0:0:1',NULL),(633,'\\core\\event\\config_log_created','core','created','config_log','config_log',1175,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810057,'web','0:0:0:0:0:0:0:1',NULL),(634,'\\core\\event\\config_log_created','core','created','config_log','config_log',1176,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_map_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810057,'web','0:0:0:0:0:0:0:1',NULL),(635,'\\core\\event\\config_log_created','core','created','config_log','config_log',1177,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"field_updatelocal_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810057,'web','0:0:0:0:0:0:0:1',NULL),(636,'\\core\\event\\config_log_created','core','created','config_log','config_log',1178,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_updateremote_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810057,'web','0:0:0:0:0:0:0:1',NULL),(637,'\\core\\event\\config_log_created','core','created','config_log','config_log',1179,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810057,'web','0:0:0:0:0:0:0:1',NULL),(638,'\\core\\event\\config_log_created','core','created','config_log','config_log',1180,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_map_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810057,'web','0:0:0:0:0:0:0:1',NULL),(639,'\\core\\event\\config_log_created','core','created','config_log','config_log',1181,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:35:\"field_updatelocal_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810058,'web','0:0:0:0:0:0:0:1',NULL),(640,'\\core\\event\\config_log_created','core','created','config_log','config_log',1182,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:36:\"field_updateremote_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810058,'web','0:0:0:0:0:0:0:1',NULL),(641,'\\core\\event\\config_log_created','core','created','config_log','config_log',1183,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_lock_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810058,'web','0:0:0:0:0:0:0:1',NULL),(642,'\\core\\event\\config_log_created','core','created','config_log','config_log',1184,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_map_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810058,'web','0:0:0:0:0:0:0:1',NULL),(643,'\\core\\event\\config_log_created','core','created','config_log','config_log',1185,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:34:\"field_updatelocal_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810058,'web','0:0:0:0:0:0:0:1',NULL),(644,'\\core\\event\\config_log_created','core','created','config_log','config_log',1186,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:35:\"field_updateremote_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810058,'web','0:0:0:0:0:0:0:1',NULL),(645,'\\core\\event\\config_log_created','core','created','config_log','config_log',1187,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_lock_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810058,'web','0:0:0:0:0:0:0:1',NULL),(646,'\\core\\event\\config_log_created','core','created','config_log','config_log',1188,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_map_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810058,'web','0:0:0:0:0:0:0:1',NULL),(647,'\\core\\event\\config_log_created','core','created','config_log','config_log',1189,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_updatelocal_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810058,'web','0:0:0:0:0:0:0:1',NULL),(648,'\\core\\event\\config_log_created','core','created','config_log','config_log',1190,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"field_updateremote_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810058,'web','0:0:0:0:0:0:0:1',NULL),(649,'\\core\\event\\config_log_created','core','created','config_log','config_log',1191,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810058,'web','0:0:0:0:0:0:0:1',NULL),(650,'\\core\\event\\config_log_created','core','created','config_log','config_log',1192,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"field_map_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810058,'web','0:0:0:0:0:0:0:1',NULL),(651,'\\core\\event\\config_log_created','core','created','config_log','config_log',1193,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:31:\"field_updatelocal_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810058,'web','0:0:0:0:0:0:0:1',NULL),(652,'\\core\\event\\config_log_created','core','created','config_log','config_log',1194,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:32:\"field_updateremote_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810059,'web','0:0:0:0:0:0:0:1',NULL),(653,'\\core\\event\\config_log_created','core','created','config_log','config_log',1195,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_lock_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_ldap\";}',1547810059,'web','0:0:0:0:0:0:0:1',NULL),(654,'\\core\\event\\config_log_created','core','created','config_log','config_log',1196,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"expiration\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810059,'web','0:0:0:0:0:0:0:1',NULL),(655,'\\core\\event\\config_log_created','core','created','config_log','config_log',1197,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"expirationtime\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"30\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810059,'web','0:0:0:0:0:0:0:1',NULL),(656,'\\core\\event\\config_log_created','core','created','config_log','config_log',1198,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"expiration_warning\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810059,'web','0:0:0:0:0:0:0:1',NULL),(657,'\\core\\event\\config_log_created','core','created','config_log','config_log',1199,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_lock_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810059,'web','0:0:0:0:0:0:0:1',NULL),(658,'\\core\\event\\config_log_created','core','created','config_log','config_log',1200,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810059,'web','0:0:0:0:0:0:0:1',NULL),(659,'\\core\\event\\config_log_created','core','created','config_log','config_log',1201,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_lock_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810059,'web','0:0:0:0:0:0:0:1',NULL),(660,'\\core\\event\\config_log_created','core','created','config_log','config_log',1202,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810059,'web','0:0:0:0:0:0:0:1',NULL),(661,'\\core\\event\\config_log_created','core','created','config_log','config_log',1203,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810059,'web','0:0:0:0:0:0:0:1',NULL),(662,'\\core\\event\\config_log_created','core','created','config_log','config_log',1204,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810059,'web','0:0:0:0:0:0:0:1',NULL),(663,'\\core\\event\\config_log_created','core','created','config_log','config_log',1205,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810059,'web','0:0:0:0:0:0:0:1',NULL),(664,'\\core\\event\\config_log_created','core','created','config_log','config_log',1206,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_lock_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810059,'web','0:0:0:0:0:0:0:1',NULL),(665,'\\core\\event\\config_log_created','core','created','config_log','config_log',1207,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810060,'web','0:0:0:0:0:0:0:1',NULL),(666,'\\core\\event\\config_log_created','core','created','config_log','config_log',1208,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810060,'web','0:0:0:0:0:0:0:1',NULL),(667,'\\core\\event\\config_log_created','core','created','config_log','config_log',1209,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810060,'web','0:0:0:0:0:0:0:1',NULL),(668,'\\core\\event\\config_log_created','core','created','config_log','config_log',1210,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810060,'web','0:0:0:0:0:0:0:1',NULL),(669,'\\core\\event\\config_log_created','core','created','config_log','config_log',1211,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810060,'web','0:0:0:0:0:0:0:1',NULL),(670,'\\core\\event\\config_log_created','core','created','config_log','config_log',1212,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810060,'web','0:0:0:0:0:0:0:1',NULL),(671,'\\core\\event\\config_log_created','core','created','config_log','config_log',1213,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_lock_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810060,'web','0:0:0:0:0:0:0:1',NULL),(672,'\\core\\event\\config_log_created','core','created','config_log','config_log',1214,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_lock_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810060,'web','0:0:0:0:0:0:0:1',NULL),(673,'\\core\\event\\config_log_created','core','created','config_log','config_log',1215,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810060,'web','0:0:0:0:0:0:0:1',NULL),(674,'\\core\\event\\config_log_created','core','created','config_log','config_log',1216,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_lock_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_manual\";}',1547810060,'web','0:0:0:0:0:0:0:1',NULL),(675,'\\core\\event\\config_log_created','core','created','config_log','config_log',1217,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"rpc_negotiation_timeout\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"30\";s:6:\"plugin\";s:9:\"auth_mnet\";}',1547810060,'web','0:0:0:0:0:0:0:1',NULL),(676,'\\core\\event\\config_log_created','core','created','config_log','config_log',1218,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_lock_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810060,'web','0:0:0:0:0:0:0:1',NULL),(677,'\\core\\event\\config_log_created','core','created','config_log','config_log',1219,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810061,'web','0:0:0:0:0:0:0:1',NULL),(678,'\\core\\event\\config_log_created','core','created','config_log','config_log',1220,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_lock_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810061,'web','0:0:0:0:0:0:0:1',NULL),(679,'\\core\\event\\config_log_created','core','created','config_log','config_log',1221,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810061,'web','0:0:0:0:0:0:0:1',NULL),(680,'\\core\\event\\config_log_created','core','created','config_log','config_log',1222,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810061,'web','0:0:0:0:0:0:0:1',NULL),(681,'\\core\\event\\config_log_created','core','created','config_log','config_log',1223,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810061,'web','0:0:0:0:0:0:0:1',NULL),(682,'\\core\\event\\config_log_created','core','created','config_log','config_log',1224,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810061,'web','0:0:0:0:0:0:0:1',NULL),(683,'\\core\\event\\config_log_created','core','created','config_log','config_log',1225,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_lock_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810061,'web','0:0:0:0:0:0:0:1',NULL),(684,'\\core\\event\\config_log_created','core','created','config_log','config_log',1226,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810061,'web','0:0:0:0:0:0:0:1',NULL),(685,'\\core\\event\\config_log_created','core','created','config_log','config_log',1227,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810062,'web','0:0:0:0:0:0:0:1',NULL),(686,'\\core\\event\\config_log_created','core','created','config_log','config_log',1228,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810062,'web','0:0:0:0:0:0:0:1',NULL),(687,'\\core\\event\\config_log_created','core','created','config_log','config_log',1229,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810062,'web','0:0:0:0:0:0:0:1',NULL),(688,'\\core\\event\\config_log_created','core','created','config_log','config_log',1230,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810062,'web','0:0:0:0:0:0:0:1',NULL),(689,'\\core\\event\\config_log_created','core','created','config_log','config_log',1231,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810062,'web','0:0:0:0:0:0:0:1',NULL),(690,'\\core\\event\\config_log_created','core','created','config_log','config_log',1232,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_lock_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810062,'web','0:0:0:0:0:0:0:1',NULL),(691,'\\core\\event\\config_log_created','core','created','config_log','config_log',1233,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_lock_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810062,'web','0:0:0:0:0:0:0:1',NULL),(692,'\\core\\event\\config_log_created','core','created','config_log','config_log',1234,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810062,'web','0:0:0:0:0:0:0:1',NULL),(693,'\\core\\event\\config_log_created','core','created','config_log','config_log',1235,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_lock_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:11:\"auth_oauth2\";}',1547810062,'web','0:0:0:0:0:0:0:1',NULL),(694,'\\core\\event\\config_log_created','core','created','config_log','config_log',1236,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"recaptcha\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810062,'web','0:0:0:0:0:0:0:1',NULL),(695,'\\core\\event\\config_log_created','core','created','config_log','config_log',1237,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_lock_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810062,'web','0:0:0:0:0:0:0:1',NULL),(696,'\\core\\event\\config_log_created','core','created','config_log','config_log',1238,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810062,'web','0:0:0:0:0:0:0:1',NULL),(697,'\\core\\event\\config_log_created','core','created','config_log','config_log',1239,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_lock_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810062,'web','0:0:0:0:0:0:0:1',NULL),(698,'\\core\\event\\config_log_created','core','created','config_log','config_log',1240,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810062,'web','0:0:0:0:0:0:0:1',NULL),(699,'\\core\\event\\config_log_created','core','created','config_log','config_log',1241,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810063,'web','0:0:0:0:0:0:0:1',NULL),(700,'\\core\\event\\config_log_created','core','created','config_log','config_log',1242,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810063,'web','0:0:0:0:0:0:0:1',NULL),(701,'\\core\\event\\config_log_created','core','created','config_log','config_log',1243,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810063,'web','0:0:0:0:0:0:0:1',NULL),(702,'\\core\\event\\config_log_created','core','created','config_log','config_log',1244,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_lock_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810063,'web','0:0:0:0:0:0:0:1',NULL),(703,'\\core\\event\\config_log_created','core','created','config_log','config_log',1245,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810063,'web','0:0:0:0:0:0:0:1',NULL),(704,'\\core\\event\\config_log_created','core','created','config_log','config_log',1246,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810063,'web','0:0:0:0:0:0:0:1',NULL),(705,'\\core\\event\\config_log_created','core','created','config_log','config_log',1247,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810063,'web','0:0:0:0:0:0:0:1',NULL),(706,'\\core\\event\\config_log_created','core','created','config_log','config_log',1248,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810063,'web','0:0:0:0:0:0:0:1',NULL),(707,'\\core\\event\\config_log_created','core','created','config_log','config_log',1249,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810063,'web','0:0:0:0:0:0:0:1',NULL),(708,'\\core\\event\\config_log_created','core','created','config_log','config_log',1250,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810063,'web','0:0:0:0:0:0:0:1',NULL),(709,'\\core\\event\\config_log_created','core','created','config_log','config_log',1251,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_lock_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810063,'web','0:0:0:0:0:0:0:1',NULL),(710,'\\core\\event\\config_log_created','core','created','config_log','config_log',1252,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_lock_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810063,'web','0:0:0:0:0:0:0:1',NULL),(711,'\\core\\event\\config_log_created','core','created','config_log','config_log',1253,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810063,'web','0:0:0:0:0:0:0:1',NULL),(712,'\\core\\event\\config_log_created','core','created','config_log','config_log',1254,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_lock_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:10:\"auth_email\";}',1547810064,'web','0:0:0:0:0:0:0:1',NULL),(713,'\\core\\event\\config_log_created','core','created','config_log','config_log',1255,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"user_attribute\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810064,'web','0:0:0:0:0:0:0:1',NULL),(714,'\\core\\event\\config_log_created','core','created','config_log','config_log',1256,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"convert_data\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810064,'web','0:0:0:0:0:0:0:1',NULL),(715,'\\core\\event\\config_log_created','core','created','config_log','config_log',1257,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"alt_login\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"off\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810064,'web','0:0:0:0:0:0:0:1',NULL),(716,'\\core\\event\\config_log_created','core','created','config_log','config_log',1258,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"organization_selection\";s:8:\"oldvalue\";N;s:5:\"value\";s:259:\"urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810064,'web','0:0:0:0:0:0:0:1',NULL),(717,'\\core\\event\\config_log_created','core','created','config_log','config_log',1259,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"logout_handler\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810064,'web','0:0:0:0:0:0:0:1',NULL),(718,'\\core\\event\\config_log_created','core','created','config_log','config_log',1260,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"logout_return_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810064,'web','0:0:0:0:0:0:0:1',NULL),(719,'\\core\\event\\config_log_created','core','created','config_log','config_log',1261,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"login_name\";s:8:\"oldvalue\";N;s:5:\"value\";s:16:\"Shibboleth Login\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810064,'web','0:0:0:0:0:0:0:1',NULL),(720,'\\core\\event\\config_log_created','core','created','config_log','config_log',1262,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"auth_logo\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810064,'web','0:0:0:0:0:0:0:1',NULL),(721,'\\core\\event\\config_log_created','core','created','config_log','config_log',1263,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"auth_instructions\";s:8:\"oldvalue\";N;s:5:\"value\";s:212:\"Use the <a href=\"http://localhost/hr-assessment/auth/shibboleth/index.php\">Shibboleth login</a> to get access via Shibboleth, if your institution supports it.<br />Otherwise, use the normal login form shown here.\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810064,'web','0:0:0:0:0:0:0:1',NULL),(722,'\\core\\event\\config_log_created','core','created','config_log','config_log',1264,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"changepasswordurl\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810064,'web','0:0:0:0:0:0:0:1',NULL),(723,'\\core\\event\\config_log_created','core','created','config_log','config_log',1265,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_map_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810064,'web','0:0:0:0:0:0:0:1',NULL),(724,'\\core\\event\\config_log_created','core','created','config_log','config_log',1266,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_updatelocal_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(725,'\\core\\event\\config_log_created','core','created','config_log','config_log',1267,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_lock_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(726,'\\core\\event\\config_log_created','core','created','config_log','config_log',1268,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_map_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(727,'\\core\\event\\config_log_created','core','created','config_log','config_log',1269,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_updatelocal_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(728,'\\core\\event\\config_log_created','core','created','config_log','config_log',1270,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(729,'\\core\\event\\config_log_created','core','created','config_log','config_log',1271,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_map_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(730,'\\core\\event\\config_log_created','core','created','config_log','config_log',1272,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"field_updatelocal_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(731,'\\core\\event\\config_log_created','core','created','config_log','config_log',1273,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_lock_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(732,'\\core\\event\\config_log_created','core','created','config_log','config_log',1274,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_map_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(733,'\\core\\event\\config_log_created','core','created','config_log','config_log',1275,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_updatelocal_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(734,'\\core\\event\\config_log_created','core','created','config_log','config_log',1276,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(735,'\\core\\event\\config_log_created','core','created','config_log','config_log',1277,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_map_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(736,'\\core\\event\\config_log_created','core','created','config_log','config_log',1278,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"field_updatelocal_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(737,'\\core\\event\\config_log_created','core','created','config_log','config_log',1279,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(738,'\\core\\event\\config_log_created','core','created','config_log','config_log',1280,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_map_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810065,'web','0:0:0:0:0:0:0:1',NULL),(739,'\\core\\event\\config_log_created','core','created','config_log','config_log',1281,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_updatelocal_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810066,'web','0:0:0:0:0:0:0:1',NULL),(740,'\\core\\event\\config_log_created','core','created','config_log','config_log',1282,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810066,'web','0:0:0:0:0:0:0:1',NULL),(741,'\\core\\event\\config_log_created','core','created','config_log','config_log',1283,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_map_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810066,'web','0:0:0:0:0:0:0:1',NULL),(742,'\\core\\event\\config_log_created','core','created','config_log','config_log',1284,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"field_updatelocal_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810066,'web','0:0:0:0:0:0:0:1',NULL),(743,'\\core\\event\\config_log_created','core','created','config_log','config_log',1285,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810066,'web','0:0:0:0:0:0:0:1',NULL),(744,'\\core\\event\\config_log_created','core','created','config_log','config_log',1286,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"field_map_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810066,'web','0:0:0:0:0:0:0:1',NULL),(745,'\\core\\event\\config_log_created','core','created','config_log','config_log',1287,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_updatelocal_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810066,'web','0:0:0:0:0:0:0:1',NULL),(746,'\\core\\event\\config_log_created','core','created','config_log','config_log',1288,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_lock_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810066,'web','0:0:0:0:0:0:0:1',NULL),(747,'\\core\\event\\config_log_created','core','created','config_log','config_log',1289,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_map_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810066,'web','0:0:0:0:0:0:0:1',NULL),(748,'\\core\\event\\config_log_created','core','created','config_log','config_log',1290,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_updatelocal_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810066,'web','0:0:0:0:0:0:0:1',NULL),(749,'\\core\\event\\config_log_created','core','created','config_log','config_log',1291,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810066,'web','0:0:0:0:0:0:0:1',NULL),(750,'\\core\\event\\config_log_created','core','created','config_log','config_log',1292,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_map_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810066,'web','0:0:0:0:0:0:0:1',NULL),(751,'\\core\\event\\config_log_created','core','created','config_log','config_log',1293,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"field_updatelocal_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810066,'web','0:0:0:0:0:0:0:1',NULL),(752,'\\core\\event\\config_log_created','core','created','config_log','config_log',1294,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810067,'web','0:0:0:0:0:0:0:1',NULL),(753,'\\core\\event\\config_log_created','core','created','config_log','config_log',1295,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_map_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810067,'web','0:0:0:0:0:0:0:1',NULL),(754,'\\core\\event\\config_log_created','core','created','config_log','config_log',1296,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_updatelocal_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810067,'web','0:0:0:0:0:0:0:1',NULL),(755,'\\core\\event\\config_log_created','core','created','config_log','config_log',1297,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810067,'web','0:0:0:0:0:0:0:1',NULL),(756,'\\core\\event\\config_log_created','core','created','config_log','config_log',1298,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_map_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810067,'web','0:0:0:0:0:0:0:1',NULL),(757,'\\core\\event\\config_log_created','core','created','config_log','config_log',1299,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_updatelocal_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810067,'web','0:0:0:0:0:0:0:1',NULL),(758,'\\core\\event\\config_log_created','core','created','config_log','config_log',1300,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810067,'web','0:0:0:0:0:0:0:1',NULL),(759,'\\core\\event\\config_log_created','core','created','config_log','config_log',1301,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_map_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810067,'web','0:0:0:0:0:0:0:1',NULL),(760,'\\core\\event\\config_log_created','core','created','config_log','config_log',1302,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_updatelocal_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810067,'web','0:0:0:0:0:0:0:1',NULL),(761,'\\core\\event\\config_log_created','core','created','config_log','config_log',1303,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810067,'web','0:0:0:0:0:0:0:1',NULL),(762,'\\core\\event\\config_log_created','core','created','config_log','config_log',1304,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_map_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810067,'web','0:0:0:0:0:0:0:1',NULL),(763,'\\core\\event\\config_log_created','core','created','config_log','config_log',1305,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:25:\"field_updatelocal_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810068,'web','0:0:0:0:0:0:0:1',NULL),(764,'\\core\\event\\config_log_created','core','created','config_log','config_log',1306,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810068,'web','0:0:0:0:0:0:0:1',NULL),(765,'\\core\\event\\config_log_created','core','created','config_log','config_log',1307,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_map_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810068,'web','0:0:0:0:0:0:0:1',NULL),(766,'\\core\\event\\config_log_created','core','created','config_log','config_log',1308,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:35:\"field_updatelocal_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810068,'web','0:0:0:0:0:0:0:1',NULL),(767,'\\core\\event\\config_log_created','core','created','config_log','config_log',1309,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_lock_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810068,'web','0:0:0:0:0:0:0:1',NULL),(768,'\\core\\event\\config_log_created','core','created','config_log','config_log',1310,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"field_map_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810068,'web','0:0:0:0:0:0:0:1',NULL),(769,'\\core\\event\\config_log_created','core','created','config_log','config_log',1311,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:34:\"field_updatelocal_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810068,'web','0:0:0:0:0:0:0:1',NULL),(770,'\\core\\event\\config_log_created','core','created','config_log','config_log',1312,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_lock_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810068,'web','0:0:0:0:0:0:0:1',NULL),(771,'\\core\\event\\config_log_created','core','created','config_log','config_log',1313,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_map_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810068,'web','0:0:0:0:0:0:0:1',NULL),(772,'\\core\\event\\config_log_created','core','created','config_log','config_log',1314,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_updatelocal_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810068,'web','0:0:0:0:0:0:0:1',NULL),(773,'\\core\\event\\config_log_created','core','created','config_log','config_log',1315,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810068,'web','0:0:0:0:0:0:0:1',NULL),(774,'\\core\\event\\config_log_created','core','created','config_log','config_log',1316,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"field_map_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810068,'web','0:0:0:0:0:0:0:1',NULL),(775,'\\core\\event\\config_log_created','core','created','config_log','config_log',1317,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:31:\"field_updatelocal_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"oncreate\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810068,'web','0:0:0:0:0:0:0:1',NULL),(776,'\\core\\event\\config_log_created','core','created','config_log','config_log',1318,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_lock_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:15:\"auth_shibboleth\";}',1547810069,'web','0:0:0:0:0:0:0:1',NULL),(777,'\\core\\event\\config_log_created','core','created','config_log','config_log',1319,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"field_lock_firstname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810069,'web','0:0:0:0:0:0:0:1',NULL),(778,'\\core\\event\\config_log_created','core','created','config_log','config_log',1320,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_lastname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810069,'web','0:0:0:0:0:0:0:1',NULL),(779,'\\core\\event\\config_log_created','core','created','config_log','config_log',1321,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"field_lock_email\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810069,'web','0:0:0:0:0:0:0:1',NULL),(780,'\\core\\event\\config_log_created','core','created','config_log','config_log',1322,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_city\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810069,'web','0:0:0:0:0:0:0:1',NULL),(781,'\\core\\event\\config_log_created','core','created','config_log','config_log',1323,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_country\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810069,'web','0:0:0:0:0:0:0:1',NULL),(782,'\\core\\event\\config_log_created','core','created','config_log','config_log',1324,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"field_lock_lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810069,'web','0:0:0:0:0:0:0:1',NULL),(783,'\\core\\event\\config_log_created','core','created','config_log','config_log',1325,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_description\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810069,'web','0:0:0:0:0:0:0:1',NULL),(784,'\\core\\event\\config_log_created','core','created','config_log','config_log',1326,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"field_lock_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810069,'web','0:0:0:0:0:0:0:1',NULL),(785,'\\core\\event\\config_log_created','core','created','config_log','config_log',1327,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"field_lock_idnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810069,'web','0:0:0:0:0:0:0:1',NULL),(786,'\\core\\event\\config_log_created','core','created','config_log','config_log',1328,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"field_lock_institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810069,'web','0:0:0:0:0:0:0:1',NULL),(787,'\\core\\event\\config_log_created','core','created','config_log','config_log',1329,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_department\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810069,'web','0:0:0:0:0:0:0:1',NULL),(788,'\\core\\event\\config_log_created','core','created','config_log','config_log',1330,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone1\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810070,'web','0:0:0:0:0:0:0:1',NULL),(789,'\\core\\event\\config_log_created','core','created','config_log','config_log',1331,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"field_lock_phone2\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810070,'web','0:0:0:0:0:0:0:1',NULL),(790,'\\core\\event\\config_log_created','core','created','config_log','config_log',1332,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"field_lock_address\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810070,'web','0:0:0:0:0:0:0:1',NULL),(791,'\\core\\event\\config_log_created','core','created','config_log','config_log',1333,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:28:\"field_lock_firstnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810070,'web','0:0:0:0:0:0:0:1',NULL),(792,'\\core\\event\\config_log_created','core','created','config_log','config_log',1334,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:27:\"field_lock_lastnamephonetic\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810070,'web','0:0:0:0:0:0:0:1',NULL),(793,'\\core\\event\\config_log_created','core','created','config_log','config_log',1335,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"field_lock_middlename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810070,'web','0:0:0:0:0:0:0:1',NULL),(794,'\\core\\event\\config_log_created','core','created','config_log','config_log',1336,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"field_lock_alternatename\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"unlocked\";s:6:\"plugin\";s:9:\"auth_none\";}',1547810070,'web','0:0:0:0:0:0:0:1',NULL),(795,'\\core\\event\\config_log_created','core','created','config_log','config_log',1337,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"roleid\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:12:\"enrol_cohort\";}',1547810070,'web','0:0:0:0:0:0:0:1',NULL),(796,'\\core\\event\\config_log_created','core','created','config_log','config_log',1338,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"unenrolaction\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:12:\"enrol_cohort\";}',1547810070,'web','0:0:0:0:0:0:0:1',NULL),(797,'\\core\\event\\config_log_created','core','created','config_log','config_log',1339,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"nosyncroleids\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:10:\"enrol_meta\";}',1547810071,'web','0:0:0:0:0:0:0:1',NULL),(798,'\\core\\event\\config_log_created','core','created','config_log','config_log',1340,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"syncall\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"enrol_meta\";}',1547810071,'web','0:0:0:0:0:0:0:1',NULL),(799,'\\core\\event\\config_log_created','core','created','config_log','config_log',1341,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"unenrolaction\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"3\";s:6:\"plugin\";s:10:\"enrol_meta\";}',1547810071,'web','0:0:0:0:0:0:0:1',NULL),(800,'\\core\\event\\config_log_created','core','created','config_log','config_log',1342,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"coursesort\";s:8:\"oldvalue\";N;s:5:\"value\";s:9:\"sortorder\";s:6:\"plugin\";s:10:\"enrol_meta\";}',1547810071,'web','0:0:0:0:0:0:0:1',NULL),(801,'\\core\\event\\config_log_created','core','created','config_log','config_log',1343,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"dbtype\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810071,'web','0:0:0:0:0:0:0:1',NULL),(802,'\\core\\event\\config_log_created','core','created','config_log','config_log',1344,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"dbhost\";s:8:\"oldvalue\";N;s:5:\"value\";s:9:\"localhost\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810071,'web','0:0:0:0:0:0:0:1',NULL),(803,'\\core\\event\\config_log_created','core','created','config_log','config_log',1345,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"dbuser\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810071,'web','0:0:0:0:0:0:0:1',NULL),(804,'\\core\\event\\config_log_created','core','created','config_log','config_log',1346,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"dbpass\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810071,'web','0:0:0:0:0:0:0:1',NULL),(805,'\\core\\event\\config_log_created','core','created','config_log','config_log',1347,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"dbname\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810071,'web','0:0:0:0:0:0:0:1',NULL),(806,'\\core\\event\\config_log_created','core','created','config_log','config_log',1348,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"dbencoding\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"utf-8\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810072,'web','0:0:0:0:0:0:0:1',NULL),(807,'\\core\\event\\config_log_created','core','created','config_log','config_log',1349,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"dbsetupsql\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810072,'web','0:0:0:0:0:0:0:1',NULL),(808,'\\core\\event\\config_log_created','core','created','config_log','config_log',1350,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"dbsybasequoting\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810072,'web','0:0:0:0:0:0:0:1',NULL),(809,'\\core\\event\\config_log_created','core','created','config_log','config_log',1351,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"debugdb\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810072,'web','0:0:0:0:0:0:0:1',NULL),(810,'\\core\\event\\config_log_created','core','created','config_log','config_log',1352,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"localcoursefield\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"idnumber\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810072,'web','0:0:0:0:0:0:0:1',NULL),(811,'\\core\\event\\config_log_created','core','created','config_log','config_log',1353,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"localuserfield\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"idnumber\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810072,'web','0:0:0:0:0:0:0:1',NULL),(812,'\\core\\event\\config_log_created','core','created','config_log','config_log',1354,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"localrolefield\";s:8:\"oldvalue\";N;s:5:\"value\";s:9:\"shortname\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810072,'web','0:0:0:0:0:0:0:1',NULL),(813,'\\core\\event\\config_log_created','core','created','config_log','config_log',1355,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"localcategoryfield\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"id\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810072,'web','0:0:0:0:0:0:0:1',NULL),(814,'\\core\\event\\config_log_created','core','created','config_log','config_log',1356,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"remoteenroltable\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810072,'web','0:0:0:0:0:0:0:1',NULL),(815,'\\core\\event\\config_log_created','core','created','config_log','config_log',1357,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"remotecoursefield\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810072,'web','0:0:0:0:0:0:0:1',NULL),(816,'\\core\\event\\config_log_created','core','created','config_log','config_log',1358,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"remoteuserfield\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810072,'web','0:0:0:0:0:0:0:1',NULL),(817,'\\core\\event\\config_log_created','core','created','config_log','config_log',1359,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"remoterolefield\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810072,'web','0:0:0:0:0:0:0:1',NULL),(818,'\\core\\event\\config_log_created','core','created','config_log','config_log',1360,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"remoteotheruserfield\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810072,'web','0:0:0:0:0:0:0:1',NULL),(819,'\\core\\event\\config_log_created','core','created','config_log','config_log',1361,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"defaultrole\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810072,'web','0:0:0:0:0:0:0:1',NULL),(820,'\\core\\event\\config_log_created','core','created','config_log','config_log',1362,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"ignorehiddencourses\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(821,'\\core\\event\\config_log_created','core','created','config_log','config_log',1363,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"unenrolaction\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(822,'\\core\\event\\config_log_created','core','created','config_log','config_log',1364,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"newcoursetable\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(823,'\\core\\event\\config_log_created','core','created','config_log','config_log',1365,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"newcoursefullname\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"fullname\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(824,'\\core\\event\\config_log_created','core','created','config_log','config_log',1366,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:18:\"newcourseshortname\";s:8:\"oldvalue\";N;s:5:\"value\";s:9:\"shortname\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(825,'\\core\\event\\config_log_created','core','created','config_log','config_log',1367,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"newcourseidnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:8:\"idnumber\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(826,'\\core\\event\\config_log_created','core','created','config_log','config_log',1368,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"newcoursecategory\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(827,'\\core\\event\\config_log_created','core','created','config_log','config_log',1369,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"defaultcategory\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(828,'\\core\\event\\config_log_created','core','created','config_log','config_log',1370,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"templatecourse\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"enrol_database\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(829,'\\core\\event\\config_log_created','core','created','config_log','config_log',1371,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"location\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:14:\"enrol_flatfile\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(830,'\\core\\event\\config_log_created','core','created','config_log','config_log',1372,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"encoding\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"UTF-8\";s:6:\"plugin\";s:14:\"enrol_flatfile\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(831,'\\core\\event\\config_log_created','core','created','config_log','config_log',1373,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"mailstudents\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:14:\"enrol_flatfile\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(832,'\\core\\event\\config_log_created','core','created','config_log','config_log',1374,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"mailteachers\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:14:\"enrol_flatfile\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(833,'\\core\\event\\config_log_created','core','created','config_log','config_log',1375,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"mailadmins\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:14:\"enrol_flatfile\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(834,'\\core\\event\\config_log_created','core','created','config_log','config_log',1376,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"unenrolaction\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"3\";s:6:\"plugin\";s:14:\"enrol_flatfile\";}',1547810073,'web','0:0:0:0:0:0:0:1',NULL),(835,'\\core\\event\\config_log_created','core','created','config_log','config_log',1377,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"expiredaction\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"3\";s:6:\"plugin\";s:14:\"enrol_flatfile\";}',1547810074,'web','0:0:0:0:0:0:0:1',NULL),(836,'\\core\\event\\config_log_created','core','created','config_log','config_log',1378,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"requirepassword\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:11:\"enrol_guest\";}',1547810074,'web','0:0:0:0:0:0:0:1',NULL),(837,'\\core\\event\\config_log_created','core','created','config_log','config_log',1379,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"usepasswordpolicy\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:11:\"enrol_guest\";}',1547810074,'web','0:0:0:0:0:0:0:1',NULL),(838,'\\core\\event\\config_log_created','core','created','config_log','config_log',1380,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"showhint\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:11:\"enrol_guest\";}',1547810074,'web','0:0:0:0:0:0:0:1',NULL),(839,'\\core\\event\\config_log_created','core','created','config_log','config_log',1381,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"defaultenrol\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:11:\"enrol_guest\";}',1547810074,'web','0:0:0:0:0:0:0:1',NULL),(840,'\\core\\event\\config_log_created','core','created','config_log','config_log',1382,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"status\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:11:\"enrol_guest\";}',1547810074,'web','0:0:0:0:0:0:0:1',NULL),(841,'\\core\\event\\config_log_created','core','created','config_log','config_log',1383,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"status_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:11:\"enrol_guest\";}',1547810074,'web','0:0:0:0:0:0:0:1',NULL),(842,'\\core\\event\\config_log_created','core','created','config_log','config_log',1384,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"imsfilelocation\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810074,'web','0:0:0:0:0:0:0:1',NULL),(843,'\\core\\event\\config_log_created','core','created','config_log','config_log',1385,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"logtolocation\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810074,'web','0:0:0:0:0:0:0:1',NULL),(844,'\\core\\event\\config_log_created','core','created','config_log','config_log',1386,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"mailadmins\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810074,'web','0:0:0:0:0:0:0:1',NULL),(845,'\\core\\event\\config_log_created','core','created','config_log','config_log',1387,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"createnewusers\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810074,'web','0:0:0:0:0:0:0:1',NULL),(846,'\\core\\event\\config_log_created','core','created','config_log','config_log',1388,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"imsupdateusers\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810074,'web','0:0:0:0:0:0:0:1',NULL),(847,'\\core\\event\\config_log_created','core','created','config_log','config_log',1389,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"imsdeleteusers\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810074,'web','0:0:0:0:0:0:0:1',NULL),(848,'\\core\\event\\config_log_created','core','created','config_log','config_log',1390,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"fixcaseusernames\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810074,'web','0:0:0:0:0:0:0:1',NULL),(849,'\\core\\event\\config_log_created','core','created','config_log','config_log',1391,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"fixcasepersonalnames\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810075,'web','0:0:0:0:0:0:0:1',NULL),(850,'\\core\\event\\config_log_created','core','created','config_log','config_log',1392,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"imssourcedidfallback\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810075,'web','0:0:0:0:0:0:0:1',NULL),(851,'\\core\\event\\config_log_created','core','created','config_log','config_log',1393,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"imsrolemap01\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810075,'web','0:0:0:0:0:0:0:1',NULL),(852,'\\core\\event\\config_log_created','core','created','config_log','config_log',1394,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"imsrolemap02\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"3\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810075,'web','0:0:0:0:0:0:0:1',NULL),(853,'\\core\\event\\config_log_created','core','created','config_log','config_log',1395,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"imsrolemap03\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"3\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810075,'web','0:0:0:0:0:0:0:1',NULL),(854,'\\core\\event\\config_log_created','core','created','config_log','config_log',1396,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"imsrolemap04\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810075,'web','0:0:0:0:0:0:0:1',NULL),(855,'\\core\\event\\config_log_created','core','created','config_log','config_log',1397,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"imsrolemap05\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810075,'web','0:0:0:0:0:0:0:1',NULL),(856,'\\core\\event\\config_log_created','core','created','config_log','config_log',1398,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"imsrolemap06\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"4\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810076,'web','0:0:0:0:0:0:0:1',NULL),(857,'\\core\\event\\config_log_created','core','created','config_log','config_log',1399,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"imsrolemap07\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810076,'web','0:0:0:0:0:0:0:1',NULL),(858,'\\core\\event\\config_log_created','core','created','config_log','config_log',1400,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"imsrolemap08\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"4\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810076,'web','0:0:0:0:0:0:0:1',NULL),(859,'\\core\\event\\config_log_created','core','created','config_log','config_log',1401,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"truncatecoursecodes\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810076,'web','0:0:0:0:0:0:0:1',NULL),(860,'\\core\\event\\config_log_created','core','created','config_log','config_log',1402,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"createnewcourses\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810076,'web','0:0:0:0:0:0:0:1',NULL),(861,'\\core\\event\\config_log_created','core','created','config_log','config_log',1403,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"updatecourses\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810076,'web','0:0:0:0:0:0:0:1',NULL),(862,'\\core\\event\\config_log_created','core','created','config_log','config_log',1404,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"createnewcategories\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810076,'web','0:0:0:0:0:0:0:1',NULL),(863,'\\core\\event\\config_log_created','core','created','config_log','config_log',1405,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"nestedcategories\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810076,'web','0:0:0:0:0:0:0:1',NULL),(864,'\\core\\event\\config_log_created','core','created','config_log','config_log',1406,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"categoryidnumber\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810076,'web','0:0:0:0:0:0:0:1',NULL),(865,'\\core\\event\\config_log_created','core','created','config_log','config_log',1407,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"categoryseparator\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810076,'web','0:0:0:0:0:0:0:1',NULL),(866,'\\core\\event\\config_log_created','core','created','config_log','config_log',1408,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"imsunenrol\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810076,'web','0:0:0:0:0:0:0:1',NULL),(867,'\\core\\event\\config_log_created','core','created','config_log','config_log',1409,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"imscoursemapshortname\";s:8:\"oldvalue\";N;s:5:\"value\";s:10:\"coursecode\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810076,'web','0:0:0:0:0:0:0:1',NULL),(868,'\\core\\event\\config_log_created','core','created','config_log','config_log',1410,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"imscoursemapfullname\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"short\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810076,'web','0:0:0:0:0:0:0:1',NULL),(869,'\\core\\event\\config_log_created','core','created','config_log','config_log',1411,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"imscoursemapsummary\";s:8:\"oldvalue\";N;s:5:\"value\";s:6:\"ignore\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810076,'web','0:0:0:0:0:0:0:1',NULL),(870,'\\core\\event\\config_log_created','core','created','config_log','config_log',1412,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"imsrestricttarget\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810077,'web','0:0:0:0:0:0:0:1',NULL),(871,'\\core\\event\\config_log_created','core','created','config_log','config_log',1413,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"imscapitafix\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:19:\"enrol_imsenterprise\";}',1547810077,'web','0:0:0:0:0:0:0:1',NULL),(872,'\\core\\event\\config_log_created','core','created','config_log','config_log',1414,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"expiredaction\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:12:\"enrol_manual\";}',1547810077,'web','0:0:0:0:0:0:0:1',NULL),(873,'\\core\\event\\config_log_created','core','created','config_log','config_log',1415,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"expirynotifyhour\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"6\";s:6:\"plugin\";s:12:\"enrol_manual\";}',1547810077,'web','0:0:0:0:0:0:0:1',NULL),(874,'\\core\\event\\config_log_created','core','created','config_log','config_log',1416,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"defaultenrol\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:12:\"enrol_manual\";}',1547810077,'web','0:0:0:0:0:0:0:1',NULL),(875,'\\core\\event\\config_log_created','core','created','config_log','config_log',1417,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"status\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:12:\"enrol_manual\";}',1547810077,'web','0:0:0:0:0:0:0:1',NULL),(876,'\\core\\event\\config_log_created','core','created','config_log','config_log',1418,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"roleid\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:12:\"enrol_manual\";}',1547810077,'web','0:0:0:0:0:0:0:1',NULL),(877,'\\core\\event\\config_log_created','core','created','config_log','config_log',1419,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"enrolstart\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"4\";s:6:\"plugin\";s:12:\"enrol_manual\";}',1547810077,'web','0:0:0:0:0:0:0:1',NULL),(878,'\\core\\event\\config_log_created','core','created','config_log','config_log',1420,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"enrolperiod\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:12:\"enrol_manual\";}',1547810077,'web','0:0:0:0:0:0:0:1',NULL),(879,'\\core\\event\\config_log_created','core','created','config_log','config_log',1421,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"expirynotify\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:12:\"enrol_manual\";}',1547810077,'web','0:0:0:0:0:0:0:1',NULL),(880,'\\core\\event\\config_log_created','core','created','config_log','config_log',1422,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"expirythreshold\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"86400\";s:6:\"plugin\";s:12:\"enrol_manual\";}',1547810077,'web','0:0:0:0:0:0:0:1',NULL),(881,'\\core\\event\\config_log_created','core','created','config_log','config_log',1423,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"roleid\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:10:\"enrol_mnet\";}',1547810077,'web','0:0:0:0:0:0:0:1',NULL),(882,'\\core\\event\\config_log_created','core','created','config_log','config_log',1424,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"roleid_adv\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"enrol_mnet\";}',1547810078,'web','0:0:0:0:0:0:0:1',NULL),(883,'\\core\\event\\config_log_created','core','created','config_log','config_log',1425,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"paypalbusiness\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:12:\"enrol_paypal\";}',1547810078,'web','0:0:0:0:0:0:0:1',NULL),(884,'\\core\\event\\config_log_created','core','created','config_log','config_log',1426,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"mailstudents\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:12:\"enrol_paypal\";}',1547810078,'web','0:0:0:0:0:0:0:1',NULL),(885,'\\core\\event\\config_log_created','core','created','config_log','config_log',1427,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"mailteachers\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:12:\"enrol_paypal\";}',1547810078,'web','0:0:0:0:0:0:0:1',NULL),(886,'\\core\\event\\config_log_created','core','created','config_log','config_log',1428,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:10:\"mailadmins\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:12:\"enrol_paypal\";}',1547810078,'web','0:0:0:0:0:0:0:1',NULL),(887,'\\core\\event\\config_log_created','core','created','config_log','config_log',1429,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"expiredaction\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"3\";s:6:\"plugin\";s:12:\"enrol_paypal\";}',1547810078,'web','0:0:0:0:0:0:0:1',NULL),(888,'\\core\\event\\config_log_created','core','created','config_log','config_log',1430,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"status\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:12:\"enrol_paypal\";}',1547810078,'web','0:0:0:0:0:0:0:1',NULL),(889,'\\core\\event\\config_log_created','core','created','config_log','config_log',1431,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:4:\"cost\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:12:\"enrol_paypal\";}',1547810078,'web','0:0:0:0:0:0:0:1',NULL),(890,'\\core\\event\\config_log_created','core','created','config_log','config_log',1432,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"currency\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"USD\";s:6:\"plugin\";s:12:\"enrol_paypal\";}',1547810078,'web','0:0:0:0:0:0:0:1',NULL),(891,'\\core\\event\\config_log_created','core','created','config_log','config_log',1433,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"roleid\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:12:\"enrol_paypal\";}',1547810078,'web','0:0:0:0:0:0:0:1',NULL),(892,'\\core\\event\\config_log_created','core','created','config_log','config_log',1434,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"enrolperiod\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:12:\"enrol_paypal\";}',1547810078,'web','0:0:0:0:0:0:0:1',NULL),(893,'\\core\\event\\config_log_created','core','created','config_log','config_log',1435,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"emaildisplay\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"2\";s:6:\"plugin\";s:9:\"enrol_lti\";}',1547810078,'web','0:0:0:0:0:0:0:1',NULL),(894,'\\core\\event\\config_log_created','core','created','config_log','config_log',1436,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:4:\"city\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"enrol_lti\";}',1547810078,'web','0:0:0:0:0:0:0:1',NULL),(895,'\\core\\event\\config_log_created','core','created','config_log','config_log',1437,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"country\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"enrol_lti\";}',1547810079,'web','0:0:0:0:0:0:0:1',NULL),(896,'\\core\\event\\config_log_created','core','created','config_log','config_log',1438,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"timezone\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"99\";s:6:\"plugin\";s:9:\"enrol_lti\";}',1547810079,'web','0:0:0:0:0:0:0:1',NULL),(897,'\\core\\event\\config_log_created','core','created','config_log','config_log',1439,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:4:\"lang\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"id\";s:6:\"plugin\";s:9:\"enrol_lti\";}',1547810079,'web','0:0:0:0:0:0:0:1',NULL),(898,'\\core\\event\\config_log_created','core','created','config_log','config_log',1440,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"institution\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:9:\"enrol_lti\";}',1547810079,'web','0:0:0:0:0:0:0:1',NULL),(899,'\\core\\event\\config_log_created','core','created','config_log','config_log',1441,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"requirepassword\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810079,'web','0:0:0:0:0:0:0:1',NULL),(900,'\\core\\event\\config_log_created','core','created','config_log','config_log',1442,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"usepasswordpolicy\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810079,'web','0:0:0:0:0:0:0:1',NULL),(901,'\\core\\event\\config_log_created','core','created','config_log','config_log',1443,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"showhint\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810079,'web','0:0:0:0:0:0:0:1',NULL),(902,'\\core\\event\\config_log_created','core','created','config_log','config_log',1444,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"expiredaction\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810079,'web','0:0:0:0:0:0:0:1',NULL),(903,'\\core\\event\\config_log_created','core','created','config_log','config_log',1445,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"expirynotifyhour\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"6\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810079,'web','0:0:0:0:0:0:0:1',NULL),(904,'\\core\\event\\config_log_created','core','created','config_log','config_log',1446,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"defaultenrol\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810079,'web','0:0:0:0:0:0:0:1',NULL),(905,'\\core\\event\\config_log_created','core','created','config_log','config_log',1447,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"status\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810079,'web','0:0:0:0:0:0:0:1',NULL),(906,'\\core\\event\\config_log_created','core','created','config_log','config_log',1448,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"newenrols\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810079,'web','0:0:0:0:0:0:0:1',NULL),(907,'\\core\\event\\config_log_created','core','created','config_log','config_log',1449,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"groupkey\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810080,'web','0:0:0:0:0:0:0:1',NULL),(908,'\\core\\event\\config_log_created','core','created','config_log','config_log',1450,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:6:\"roleid\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"5\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810080,'web','0:0:0:0:0:0:0:1',NULL),(909,'\\core\\event\\config_log_created','core','created','config_log','config_log',1451,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"enrolperiod\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810080,'web','0:0:0:0:0:0:0:1',NULL),(910,'\\core\\event\\config_log_created','core','created','config_log','config_log',1452,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"expirynotify\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810080,'web','0:0:0:0:0:0:0:1',NULL),(911,'\\core\\event\\config_log_created','core','created','config_log','config_log',1453,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"expirythreshold\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"86400\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810080,'web','0:0:0:0:0:0:0:1',NULL),(912,'\\core\\event\\config_log_created','core','created','config_log','config_log',1454,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"longtimenosee\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810080,'web','0:0:0:0:0:0:0:1',NULL),(913,'\\core\\event\\config_log_created','core','created','config_log','config_log',1455,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"maxenrolled\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810080,'web','0:0:0:0:0:0:0:1',NULL),(914,'\\core\\event\\config_log_created','core','created','config_log','config_log',1456,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:24:\"sendcoursewelcomemessage\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:10:\"enrol_self\";}',1547810080,'web','0:0:0:0:0:0:0:1',NULL),(915,'\\core\\event\\config_log_created','core','created','config_log','config_log',1457,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"formats\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:16:\"filter_urltolink\";}',1547810080,'web','0:0:0:0:0:0:0:1',NULL),(916,'\\core\\event\\config_log_created','core','created','config_log','config_log',1458,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"embedimages\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:16:\"filter_urltolink\";}',1547810080,'web','0:0:0:0:0:0:0:1',NULL),(917,'\\core\\event\\config_log_created','core','created','config_log','config_log',1459,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"formats\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"1,4,0\";s:6:\"plugin\";s:15:\"filter_emoticon\";}',1547810080,'web','0:0:0:0:0:0:0:1',NULL),(918,'\\core\\event\\config_log_created','core','created','config_log','config_log',1460,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"httpsurl\";s:8:\"oldvalue\";N;s:5:\"value\";s:63:\"https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.2/MathJax.js\";s:6:\"plugin\";s:20:\"filter_mathjaxloader\";}',1547810080,'web','0:0:0:0:0:0:0:1',NULL),(919,'\\core\\event\\config_log_created','core','created','config_log','config_log',1461,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"texfiltercompatibility\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";s:20:\"filter_mathjaxloader\";}',1547810080,'web','0:0:0:0:0:0:0:1',NULL),(920,'\\core\\event\\config_log_created','core','created','config_log','config_log',1462,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"mathjaxconfig\";s:8:\"oldvalue\";N;s:5:\"value\";s:162:\"\nMathJax.Hub.Config({\n    config: [\"Accessible.js\", \"Safe.js\"],\n    errorSettings: { message: [\"!\"] },\n    skipStartupTypeset: true,\n    messageStyle: \"none\"\n});\n\";s:6:\"plugin\";s:20:\"filter_mathjaxloader\";}',1547810080,'web','0:0:0:0:0:0:0:1',NULL),(921,'\\core\\event\\config_log_created','core','created','config_log','config_log',1463,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"additionaldelimiters\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:20:\"filter_mathjaxloader\";}',1547810081,'web','0:0:0:0:0:0:0:1',NULL),(922,'\\core\\event\\config_log_created','core','created','config_log','config_log',1464,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"filter_multilang_force_old\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810081,'web','0:0:0:0:0:0:0:1',NULL),(923,'\\core\\event\\config_log_created','core','created','config_log','config_log',1465,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"latexpreamble\";s:8:\"oldvalue\";N;s:5:\"value\";s:115:\"\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n\";s:6:\"plugin\";s:10:\"filter_tex\";}',1547810081,'web','0:0:0:0:0:0:0:1',NULL),(924,'\\core\\event\\config_log_created','core','created','config_log','config_log',1466,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"latexbackground\";s:8:\"oldvalue\";N;s:5:\"value\";s:7:\"#FFFFFF\";s:6:\"plugin\";s:10:\"filter_tex\";}',1547810081,'web','0:0:0:0:0:0:0:1',NULL),(925,'\\core\\event\\config_log_created','core','created','config_log','config_log',1467,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:7:\"density\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"120\";s:6:\"plugin\";s:10:\"filter_tex\";}',1547810081,'web','0:0:0:0:0:0:0:1',NULL),(926,'\\core\\event\\config_log_created','core','created','config_log','config_log',1468,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"pathlatex\";s:8:\"oldvalue\";N;s:5:\"value\";s:14:\"/usr/bin/latex\";s:6:\"plugin\";s:10:\"filter_tex\";}',1547810081,'web','0:0:0:0:0:0:0:1',NULL),(927,'\\core\\event\\config_log_created','core','created','config_log','config_log',1469,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"pathdvips\";s:8:\"oldvalue\";N;s:5:\"value\";s:14:\"/usr/bin/dvips\";s:6:\"plugin\";s:10:\"filter_tex\";}',1547810081,'web','0:0:0:0:0:0:0:1',NULL),(928,'\\core\\event\\config_log_created','core','created','config_log','config_log',1470,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"pathconvert\";s:8:\"oldvalue\";N;s:5:\"value\";s:16:\"/usr/bin/convert\";s:6:\"plugin\";s:10:\"filter_tex\";}',1547810081,'web','0:0:0:0:0:0:0:1',NULL),(929,'\\core\\event\\config_log_created','core','created','config_log','config_log',1471,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"pathdvisvgm\";s:8:\"oldvalue\";N;s:5:\"value\";s:16:\"/usr/bin/dvisvgm\";s:6:\"plugin\";s:10:\"filter_tex\";}',1547810081,'web','0:0:0:0:0:0:0:1',NULL),(930,'\\core\\event\\config_log_created','core','created','config_log','config_log',1472,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:11:\"pathmimetex\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:10:\"filter_tex\";}',1547810081,'web','0:0:0:0:0:0:0:1',NULL),(931,'\\core\\event\\config_log_created','core','created','config_log','config_log',1473,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"convertformat\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"gif\";s:6:\"plugin\";s:10:\"filter_tex\";}',1547810081,'web','0:0:0:0:0:0:0:1',NULL),(932,'\\core\\event\\config_log_created','core','created','config_log','config_log',1474,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"filter_censor_badwords\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";N;}',1547810081,'web','0:0:0:0:0:0:0:1',NULL),(933,'\\core\\event\\config_log_created','core','created','config_log','config_log',1475,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"answerhowmany\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:17:\"qtype_multichoice\";}',1547810082,'web','0:0:0:0:0:0:0:1',NULL),(934,'\\core\\event\\config_log_created','core','created','config_log','config_log',1476,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"shuffleanswers\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";s:17:\"qtype_multichoice\";}',1547810082,'web','0:0:0:0:0:0:0:1',NULL),(935,'\\core\\event\\config_log_created','core','created','config_log','config_log',1477,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"answernumbering\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"abc\";s:6:\"plugin\";s:17:\"qtype_multichoice\";}',1547810082,'web','0:0:0:0:0:0:0:1',NULL),(936,'\\core\\event\\config_log_created','core','created','config_log','config_log',1478,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"profileroles\";s:8:\"oldvalue\";N;s:5:\"value\";s:5:\"5,4,3\";s:6:\"plugin\";N;}',1547810082,'web','0:0:0:0:0:0:0:1',NULL),(937,'\\core\\event\\config_log_created','core','created','config_log','config_log',1479,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:13:\"coursecontact\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"3\";s:6:\"plugin\";N;}',1547810082,'web','0:0:0:0:0:0:0:1',NULL),(938,'\\core\\event\\config_log_created','core','created','config_log','config_log',1480,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"frontpage\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"6\";s:6:\"plugin\";N;}',1547810082,'web','0:0:0:0:0:0:0:1',NULL),(939,'\\core\\event\\config_log_created','core','created','config_log','config_log',1481,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:17:\"frontpageloggedin\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"6\";s:6:\"plugin\";N;}',1547810082,'web','0:0:0:0:0:0:0:1',NULL),(940,'\\core\\event\\config_log_created','core','created','config_log','config_log',1482,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:16:\"maxcategorydepth\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"2\";s:6:\"plugin\";N;}',1547810082,'web','0:0:0:0:0:0:0:1',NULL),(941,'\\core\\event\\config_log_created','core','created','config_log','config_log',1483,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:20:\"frontpagecourselimit\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"200\";s:6:\"plugin\";N;}',1547810082,'web','0:0:0:0:0:0:0:1',NULL),(942,'\\core\\event\\config_log_created','core','created','config_log','config_log',1484,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:15:\"commentsperpage\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"15\";s:6:\"plugin\";N;}',1547810082,'web','0:0:0:0:0:0:0:1',NULL),(943,'\\core\\event\\config_log_created','core','created','config_log','config_log',1485,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"defaultfrontpageroleid\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"8\";s:6:\"plugin\";N;}',1547810082,'web','0:0:0:0:0:0:0:1',NULL),(944,'\\core\\event\\config_log_created','core','created','config_log','config_log',1486,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"messageinbound_enabled\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810082,'web','0:0:0:0:0:0:0:1',NULL),(945,'\\core\\event\\config_log_created','core','created','config_log','config_log',1487,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"messageinbound_mailbox\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";N;}',1547810083,'web','0:0:0:0:0:0:0:1',NULL),(946,'\\core\\event\\config_log_created','core','created','config_log','config_log',1488,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:21:\"messageinbound_domain\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";N;}',1547810083,'web','0:0:0:0:0:0:0:1',NULL),(947,'\\core\\event\\config_log_created','core','created','config_log','config_log',1489,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:19:\"messageinbound_host\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";N;}',1547810083,'web','0:0:0:0:0:0:0:1',NULL),(948,'\\core\\event\\config_log_created','core','created','config_log','config_log',1490,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"messageinbound_hostssl\";s:8:\"oldvalue\";N;s:5:\"value\";s:3:\"ssl\";s:6:\"plugin\";N;}',1547810083,'web','0:0:0:0:0:0:0:1',NULL),(949,'\\core\\event\\config_log_created','core','created','config_log','config_log',1491,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"messageinbound_hostuser\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";N;}',1547810083,'web','0:0:0:0:0:0:0:1',NULL),(950,'\\core\\event\\config_log_created','core','created','config_log','config_log',1492,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:23:\"messageinbound_hostpass\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";N;}',1547810083,'web','0:0:0:0:0:0:0:1',NULL),(951,'\\core\\event\\config_log_created','core','created','config_log','config_log',1493,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:22:\"enablemobilewebservice\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547810083,'web','0:0:0:0:0:0:0:1',NULL),(952,'\\core\\event\\config_log_created','core','created','config_log','config_log',1494,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:9:\"apppolicy\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";s:11:\"tool_mobile\";}',1547810083,'web','0:0:0:0:0:0:0:1',NULL),(953,'\\core\\event\\config_log_created','core','created','config_log','config_log',1495,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:8:\"timezone\";s:8:\"oldvalue\";N;s:5:\"value\";s:12:\"Asia/Jakarta\";s:6:\"plugin\";N;}',1547810149,'web','0:0:0:0:0:0:0:1',NULL),(954,'\\core\\event\\config_log_created','core','created','config_log','config_log',1496,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:12:\"registerauth\";s:8:\"oldvalue\";N;s:5:\"value\";s:0:\"\";s:6:\"plugin\";N;}',1547810149,'web','0:0:0:0:0:0:0:1',NULL),(955,'\\core\\event\\config_log_created','core','created','config_log','config_log',1497,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:14:\"noreplyaddress\";s:8:\"oldvalue\";N;s:5:\"value\";s:25:\"hr-assessment@halinda.com\";s:6:\"plugin\";N;}',1547810178,'web','0:0:0:0:0:0:0:1',NULL),(956,'\\core\\event\\dashboard_viewed','core','viewed','dashboard',NULL,NULL,'r',0,5,30,2,2,0,2,0,'N;',1547810181,'web','0:0:0:0:0:0:0:1',NULL),(957,'\\tool_usertours\\event\\tour_started','tool_usertours','started','tour','tool_usertours_tours',2,'r',2,5,30,2,2,0,2,0,'a:1:{s:7:\"pageurl\";s:34:\"http://localhost/hr-assessment/my/\";}',1547810183,'web','0:0:0:0:0:0:0:1',NULL),(958,'\\tool_usertours\\event\\step_shown','tool_usertours','shown','step','tool_usertours_steps',7,'r',2,5,30,2,2,0,2,0,'a:3:{s:7:\"pageurl\";s:34:\"http://localhost/hr-assessment/my/\";s:6:\"tourid\";i:2;s:9:\"stepindex\";i:0;}',1547810184,'web','0:0:0:0:0:0:0:1',NULL),(959,'\\tool_usertours\\event\\tour_ended','tool_usertours','ended','tour','tool_usertours_tours',2,'c',2,5,30,2,2,0,2,0,'a:3:{s:7:\"pageurl\";s:34:\"http://localhost/hr-assessment/my/\";s:6:\"stepid\";i:7;s:9:\"stepindex\";i:0;}',1547810186,'web','0:0:0:0:0:0:0:1',NULL),(960,'\\core\\event\\dashboard_viewed','core','viewed','dashboard',NULL,NULL,'r',0,5,30,2,2,0,2,0,'N;',1547811505,'web','0:0:0:0:0:0:0:1',NULL),(961,'\\core\\event\\user_loggedin','core','loggedin','user','user',2,'r',0,1,10,0,2,0,NULL,0,'a:1:{s:8:\"username\";s:5:\"admin\";}',1547818919,'web','0:0:0:0:0:0:0:1',NULL),(962,'\\core\\event\\config_log_created','core','created','config_log','config_log',1498,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:26:\"bigbluebuttonbn_server_url\";s:8:\"oldvalue\";N;s:5:\"value\";s:56:\"http://test-install.blindsidenetworks.com/bigbluebutton/\";s:6:\"plugin\";N;}',1547819222,'web','0:0:0:0:0:0:0:1',NULL),(963,'\\core\\event\\config_log_created','core','created','config_log','config_log',1499,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:29:\"bigbluebuttonbn_shared_secret\";s:8:\"oldvalue\";N;s:5:\"value\";s:32:\"8cd8ef52e8e101574e400365b55e11a6\";s:6:\"plugin\";N;}',1547819223,'web','0:0:0:0:0:0:0:1',NULL),(964,'\\core\\event\\config_log_created','core','created','config_log','config_log',1500,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:33:\"bigbluebuttonbn_recording_default\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547819223,'web','0:0:0:0:0:0:0:1',NULL),(965,'\\core\\event\\config_log_created','core','created','config_log','config_log',1501,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:34:\"bigbluebuttonbn_recording_editable\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547819223,'web','0:0:0:0:0:0:0:1',NULL),(966,'\\core\\event\\config_log_created','core','created','config_log','config_log',1502,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:39:\"bigbluebuttonbn_recording_icons_enabled\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547819223,'web','0:0:0:0:0:0:0:1',NULL),(967,'\\core\\event\\config_log_created','core','created','config_log','config_log',1503,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:40:\"bigbluebuttonbn_importrecordings_enabled\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547819223,'web','0:0:0:0:0:0:0:1',NULL),(968,'\\core\\event\\config_log_created','core','created','config_log','config_log',1504,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:53:\"bigbluebuttonbn_importrecordings_from_deleted_enabled\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547819223,'web','0:0:0:0:0:0:0:1',NULL),(969,'\\core\\event\\config_log_created','core','created','config_log','config_log',1505,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:39:\"bigbluebuttonbn_recordings_html_default\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547819223,'web','0:0:0:0:0:0:0:1',NULL),(970,'\\core\\event\\config_log_created','core','created','config_log','config_log',1506,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:40:\"bigbluebuttonbn_recordings_html_editable\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547819224,'web','0:0:0:0:0:0:0:1',NULL),(971,'\\core\\event\\config_log_created','core','created','config_log','config_log',1507,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:42:\"bigbluebuttonbn_recordings_deleted_default\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547819224,'web','0:0:0:0:0:0:0:1',NULL),(972,'\\core\\event\\config_log_created','core','created','config_log','config_log',1508,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:43:\"bigbluebuttonbn_recordings_deleted_editable\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547819224,'web','0:0:0:0:0:0:0:1',NULL),(973,'\\core\\event\\config_log_created','core','created','config_log','config_log',1509,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:43:\"bigbluebuttonbn_recordings_imported_default\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547819224,'web','0:0:0:0:0:0:0:1',NULL),(974,'\\core\\event\\config_log_created','core','created','config_log','config_log',1510,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:44:\"bigbluebuttonbn_recordings_imported_editable\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547819224,'web','0:0:0:0:0:0:0:1',NULL),(975,'\\core\\event\\config_log_created','core','created','config_log','config_log',1511,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:42:\"bigbluebuttonbn_recordings_preview_default\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547819224,'web','0:0:0:0:0:0:0:1',NULL),(976,'\\core\\event\\config_log_created','core','created','config_log','config_log',1512,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:43:\"bigbluebuttonbn_recordings_preview_editable\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547819224,'web','0:0:0:0:0:0:0:1',NULL),(977,'\\core\\event\\config_log_created','core','created','config_log','config_log',1513,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:40:\"bigbluebuttonbn_waitformoderator_default\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547819224,'web','0:0:0:0:0:0:0:1',NULL),(978,'\\core\\event\\config_log_created','core','created','config_log','config_log',1514,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:41:\"bigbluebuttonbn_waitformoderator_editable\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547819224,'web','0:0:0:0:0:0:0:1',NULL),(979,'\\core\\event\\config_log_created','core','created','config_log','config_log',1515,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:46:\"bigbluebuttonbn_waitformoderator_ping_interval\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"10\";s:6:\"plugin\";N;}',1547819224,'web','0:0:0:0:0:0:0:1',NULL),(980,'\\core\\event\\config_log_created','core','created','config_log','config_log',1516,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:42:\"bigbluebuttonbn_waitformoderator_cache_ttl\";s:8:\"oldvalue\";N;s:5:\"value\";s:2:\"60\";s:6:\"plugin\";N;}',1547819225,'web','0:0:0:0:0:0:0:1',NULL),(981,'\\core\\event\\config_log_created','core','created','config_log','config_log',1517,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:36:\"bigbluebuttonbn_voicebridge_editable\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547819225,'web','0:0:0:0:0:0:0:1',NULL),(982,'\\core\\event\\config_log_created','core','created','config_log','config_log',1518,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:45:\"bigbluebuttonbn_preuploadpresentation_enabled\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547819225,'web','0:0:0:0:0:0:0:1',NULL),(983,'\\core\\event\\config_log_created','core','created','config_log','config_log',1519,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:33:\"bigbluebuttonbn_userlimit_default\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547819225,'web','0:0:0:0:0:0:0:1',NULL),(984,'\\core\\event\\config_log_created','core','created','config_log','config_log',1520,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:34:\"bigbluebuttonbn_userlimit_editable\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547819225,'web','0:0:0:0:0:0:0:1',NULL),(985,'\\core\\event\\config_log_created','core','created','config_log','config_log',1521,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:45:\"bigbluebuttonbn_participant_moderator_default\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547819225,'web','0:0:0:0:0:0:0:1',NULL),(986,'\\core\\event\\config_log_created','core','created','config_log','config_log',1522,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:41:\"bigbluebuttonbn_sendnotifications_enabled\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"1\";s:6:\"plugin\";N;}',1547819225,'web','0:0:0:0:0:0:0:1',NULL),(987,'\\core\\event\\config_log_created','core','created','config_log','config_log',1523,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:38:\"bigbluebuttonbn_recordingready_enabled\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547819225,'web','0:0:0:0:0:0:0:1',NULL),(988,'\\core\\event\\config_log_created','core','created','config_log','config_log',1524,'c',0,1,10,0,2,0,NULL,0,'a:4:{s:4:\"name\";s:37:\"bigbluebuttonbn_meetingevents_enabled\";s:8:\"oldvalue\";N;s:5:\"value\";s:1:\"0\";s:6:\"plugin\";N;}',1547819225,'web','0:0:0:0:0:0:0:1',NULL),(989,'\\core\\event\\dashboard_viewed','core','viewed','dashboard',NULL,NULL,'r',0,5,30,2,2,0,2,0,'N;',1547824280,'web','0:0:0:0:0:0:0:1',NULL),(990,'\\core\\event\\course_category_created','core','created','course_category','course_categories',2,'c',0,25,40,2,2,0,NULL,0,'N;',1547824321,'web','0:0:0:0:0:0:0:1',NULL),(991,'\\core\\event\\user_profile_viewed','core','viewed','user_profile','user',2,'r',0,5,30,2,2,0,2,0,'N;',1547828094,'web','0:0:0:0:0:0:0:1',NULL),(992,'\\core\\event\\dashboard_viewed','core','viewed','dashboard',NULL,NULL,'r',0,5,30,2,2,0,2,0,'N;',1547828391,'web','0:0:0:0:0:0:0:1',NULL),(993,'\\core\\event\\dashboard_viewed','core','viewed','dashboard',NULL,NULL,'r',0,5,30,2,2,0,2,0,'N;',1547828667,'web','0:0:0:0:0:0:0:1',NULL),(994,'\\core\\event\\user_loggedout','core','loggedout','user','user',2,'r',0,1,10,0,2,0,NULL,0,'a:1:{s:9:\"sessionid\";s:26:\"dts9af70okr3uvdop1lnhkgm2e\";}',1547828812,'web','0:0:0:0:0:0:0:1',NULL),(995,'\\core\\event\\course_viewed','core','viewed','course',NULL,NULL,'r',2,2,50,1,0,1,NULL,0,'N;',1547828813,'web','0:0:0:0:0:0:0:1',NULL),(996,'\\core\\event\\course_viewed','core','viewed','course',NULL,NULL,'r',2,2,50,1,0,1,NULL,0,'N;',1547828861,'web','0:0:0:0:0:0:0:1',NULL),(997,'\\core\\event\\course_viewed','core','viewed','course',NULL,NULL,'r',2,2,50,1,0,1,NULL,0,'N;',1548020635,'web','0:0:0:0:0:0:0:1',NULL),(998,'\\core\\event\\user_login_failed','core','failed','user_login',NULL,NULL,'r',0,1,10,0,0,0,NULL,0,'a:2:{s:8:\"username\";s:10:\"ainulyaqin\";s:6:\"reason\";i:1;}',1548020665,'web','0:0:0:0:0:0:0:1',NULL),(999,'\\core\\event\\user_loggedin','core','loggedin','user','user',2,'r',0,1,10,0,2,0,NULL,0,'a:1:{s:8:\"username\";s:5:\"admin\";}',1548020681,'web','0:0:0:0:0:0:0:1',NULL),(1000,'\\core\\event\\dashboard_viewed','core','viewed','dashboard',NULL,NULL,'r',0,5,30,2,2,0,2,0,'N;',1548020689,'web','0:0:0:0:0:0:0:1',NULL),(1001,'\\core\\event\\course_viewed','core','viewed','course',NULL,NULL,'r',2,2,50,1,0,1,NULL,0,'N;',1548668778,'web','0:0:0:0:0:0:0:1',NULL),(1002,'\\core\\event\\user_loggedin','core','loggedin','user','user',2,'r',0,1,10,0,2,0,NULL,0,'a:1:{s:8:\"username\";s:5:\"admin\";}',1548668808,'web','0:0:0:0:0:0:0:1',NULL),(1003,'\\core\\event\\dashboard_viewed','core','viewed','dashboard',NULL,NULL,'r',0,5,30,2,2,0,2,0,'N;',1548668820,'web','0:0:0:0:0:0:0:1',NULL),(1004,'\\core\\event\\course_viewed','core','viewed','course',